# Alpakka 1.0.x

To understand the forces on version numbers, read about @ref:[Alpakka's versioning scheme](../other-docs/versioning.md). 

## 1.0.2

Released 2019-05-25

This release fixes a bug in the CSV parser which was introduced in 1.0.1 and makes the CSV parser accept escape characters when there is nothing to escape.


## Highlights since 1.0.1

* CSV: Fixed bug when last column in last line is empty [#1710](https://github.com/akka/alpakka/issues/1710)

**See [changes per module](#changes-per-module)**

## Contributors in 1.0.2

| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="2m" src="https://avatars3.githubusercontent.com/u/422086?v=4&s=40"> **2m**](https://github.com/2m) | 16 | 1079 | 1047 |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&s=40"> **ennru**](https://github.com/ennru) | 9 | 168 | 461 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&s=40"> **sullis**](https://github.com/sullis) | 1 | 1 | 1 |
| [<img width="20" alt="mavericksid" src="https://avatars2.githubusercontent.com/u/4543634?v=4&s=40"> **mavericksid**](https://github.com/mavericksid) | 1 | 1 | 1 |

## All changes since 1.0.1

* [*closed in 1.0.2*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0.2)



## 1.0.1

Released 2019-05-16

## Highlights since 1.0.0

* Akka 2.5.22 [#1630](https://github.com/akka/alpakka/pull/1630) by [@sullis](https://github.com/sullis)
* FTP: Support partial file download @github[#1660](#1660) by [Thomas Gambet, @tgambet](https://github.com/tgambet)
* HBase: add source [#1648](https://github.com/akka/alpakka/pull/1648) by [takako shimamoto, @shimamoto](https://github.com/shimamoto) 
* AWS SQS: Revise stream element data model [#1604](https://github.com/akka/alpakka/pull/1604) by [Michel Davit, @RustedBones](https://github.com/RustedBones) **api-change**
* AWS SQS/SNS: Enable Scala 2.13 [#1641](https://github.com/akka/alpakka/pull/1641)  **dependency-change**  
* AWS S3: Bucket management [#1546](https://github.com/akka/alpakka/issues/1546) and [#1608](https://github.com/akka/alpakka/issues/1608) by [Marcin Aman, @MarcinAman](https://github.com/MarcinAman)
* AWS S3: forward proxy support [#1639](https://github.com/akka/alpakka/pull/1639) by [Fredrik Wendelboe Løkke, @floekke](https://github.com/floekke)

**See [changes per module](#changes-per-module)**

## Contributors in 1.0.1

| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&s=40"> **ennru**](https://github.com/ennru) | 19 | 968 | 329 |
| [<img width="20" alt="2m" src="https://avatars3.githubusercontent.com/u/422086?v=4&s=40"> **2m**](https://github.com/2m) | 15 | 1146 | 277 |
| [<img width="20" alt="tgambet" src="https://avatars1.githubusercontent.com/u/1452037?v=4&s=40"> **tgambet**](https://github.com/tgambet) | 3 | 848 | 1435 |
| [<img width="20" alt="MarcinAman" src="https://avatars0.githubusercontent.com/u/15652452?v=4&s=40"> **MarcinAman**](https://github.com/MarcinAman) | 2 | 721 | 8 |
| [<img width="20" alt="raboof" src="https://avatars2.githubusercontent.com/u/131856?v=4&s=40"> **raboof**](https://github.com/raboof) | 2 | 28 | 1 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&s=40"> **sullis**](https://github.com/sullis) | 2 | 10 | 9 |
| [<img width="20" alt="RustedBones" src="https://avatars3.githubusercontent.com/u/2845540?v=4&s=40"> **RustedBones**](https://github.com/RustedBones) | 1 | 655 | 384 |
| [<img width="20" alt="htmldoug" src="https://avatars2.githubusercontent.com/u/663139?v=4&s=40"> **htmldoug**](https://github.com/htmldoug) | 1 | 326 | 106 |
| [<img width="20" alt="floekke" src="https://avatars1.githubusercontent.com/u/5900695?v=4&s=40"> **floekke**](https://github.com/floekke) | 1 | 169 | 21 |
| [<img width="20" alt="mayankbansal93" src="https://avatars2.githubusercontent.com/u/8069749?v=4&s=40"> **mayankbansal93**](https://github.com/mayankbansal93) | 1 | 153 | 0 |
| [<img width="20" alt="giena" src="https://avatars3.githubusercontent.com/u/6929360?v=4&s=40"> **giena**](https://github.com/giena) | 1 | 144 | 11 |
| [<img width="20" alt="shimamoto" src="https://avatars1.githubusercontent.com/u/1875052?v=4&s=40"> **shimamoto**](https://github.com/shimamoto) | 1 | 134 | 6 |
| [<img width="20" alt="samidalouche" src="https://avatars3.githubusercontent.com/u/142329?v=4&s=40"> **samidalouche**](https://github.com/samidalouche) | 1 | 16 | 1 |
| [<img width="20" alt="mayankbansal93" src="https://avatars2.githubusercontent.com/u/8069749?v=4&s=40"> **mayankbansal93**](https://github.com/mayankbansal93) | 1 | 13 | 1 |
| [<img width="20" alt="huntc" src="https://avatars2.githubusercontent.com/u/694893?v=4&s=40"> **huntc**](https://github.com/huntc) | 1 | 12 | 11 |
| [<img width="20" alt="jcroig" src="https://avatars2.githubusercontent.com/u/122266?v=4&s=40"> **jcroig**](https://github.com/jcroig) | 1 | 8 | 2 |
| [<img width="20" alt="longshorej" src="https://avatars1.githubusercontent.com/u/515201?v=4&s=40"> **longshorej**](https://github.com/longshorej) | 1 | 4 | 0 |
| [<img width="20" alt="matsluni" src="https://avatars3.githubusercontent.com/u/2551177?v=4&s=40"> **matsluni**](https://github.com/matsluni) | 1 | 3 | 2 |
| [<img width="20" alt="zingkg" src="https://avatars3.githubusercontent.com/u/20845097?v=4&s=40"> **zingkg**](https://github.com/zingkg) | 1 | 2 | 2 |
| [<img width="20" alt="chbatey" src="https://avatars1.githubusercontent.com/u/1866779?v=4&s=40"> **chbatey**](https://github.com/chbatey) | 1 | 1 | 1 |
| [<img width="20" alt="shiv4nsh" src="https://avatars3.githubusercontent.com/u/12807854?v=4&s=40"> **shiv4nsh**](https://github.com/shiv4nsh) | 1 | 1 | 0 |


## All changes since 1.0.0

* [*closed in 1.0.1*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0.1)


## 1.0.0

Released 2019-04-04

With this 1.0.0 release Alpakka is another member of the [Akka family](https://akka.io/docs/) promising great Open Source software with the [Reactive Manifesto](https://www.reactivemanifesto.org/) in mind.

By now all modules have been worked with to follow a similar structure so that both the user experience and the contributor experience are transferable across the many modules in Alpakka. The recommended structure for connectors is illustrated by the [Reference connector](https://doc.akka.io/docs/alpakka/current/reference.html).

Having that said, a few parts make use of the `@ApiMayChange` annotation to keep the door open for API changes, so that they can evolve more rapidly than other modules within Alpakka.

If you have kept to older versions of Alpakka to avoid multiple upgrades, **now is the time** to migrate to what it offers with 1.0.

Most artifacts of Alpakka are available for Scala 2.11, 2.12 and 2.13.0-M5.

Alpakka 1.0.0 modules require at least [Akka](https://akka.io/blog/news-archive.html) 2.5.21. Some modules built up [Akka HTTP](https://doc.akka.io/docs/akka-http/current/release-notes/10.1.x.html) 10.1.7.


### Compatibility

A major goal before turning to 1.0 was to improve chances all Alpakka modules can evolve without breaking users' code. There are two sides to that: One is **binary-compatibility** which effectively means you can replace just the jar with a later version's jar in your installation and everything will work. This becomes extremely important as soon as you use other libraries that rely on the same jar. They will continue to work without recompilation. The other is **source-compatibility** which, when upgrading to a later minor version, would not require any code changes. Akka and Alpakka strive for binary-compatibility and source-compatibility, but we do not guarantee source-compatibility.

All modules of Alpakka can be used independently, you may mix Alpakka versions for different libraries. With Akka though, it is important though to be strictly using one version (never blend eg. `akka-actor 2.5.21` and `akka-stream 2.5.12`), and do not use an Akka version lower than the one the Alpakka dependency requires (sometimes Alpakka modules depend on features of the latest Akka release).


## Highlights since 1.0-RC1

* Official support is now available via [Lightbend Platform Subscription](https://www.lightbend.com/lightbend-platform-subscription) for the first modules: Couchbase and CSV ([Alpakka Kafka](https://doc.akka.io/docs/alpakka-kafka/current/) has been supported for a while)
* MQTT Streaming has been further stabilized
* AWS SQS has been marked "API may change" as there are some improvements coming up (see [#1604](https://github.com/akka/alpakka/pull/1604))


## Contributors

| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&s=40"> **ennru**](https://github.com/ennru) | 14 | 571 | 179 |
| [<img width="20" alt="longshorej" src="https://avatars1.githubusercontent.com/u/515201?v=4&s=40"> **longshorej**](https://github.com/longshorej) | 5 | 366 | 110 |
| [<img width="20" alt="gabfssilva" src="https://avatars1.githubusercontent.com/u/5403842?v=4&s=40"> **gabfssilva**](https://github.com/gabfssilva) | 1 | 55 | 0 |
| [<img width="20" alt="mwegrz" src="https://avatars0.githubusercontent.com/u/7756433?v=4&s=40"> **mwegrz**](https://github.com/mwegrz) | 1 | 13 | 8 |
| [<img width="20" alt="azolotko" src="https://avatars2.githubusercontent.com/u/110424?v=4&s=40"> **azolotko**](https://github.com/azolotko) | 1 | 5 | 5 |
| [<img width="20" alt="nukky94" src="https://avatars2.githubusercontent.com/u/11653587?v=4&s=40"> **nukky94**](https://github.com/nukky94) | 1 | 4 | 3 |
| [<img width="20" alt="RustedBones" src="https://avatars3.githubusercontent.com/u/2845540?v=4&s=40"> **RustedBones**](https://github.com/RustedBones) | 1 | 1 | 27 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&s=40"> **sullis**](https://github.com/sullis) | 1 | 1 | 1 |


## All changes since 0.20

* [*closed in 1.0.0*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0.0)

* [*closed in 1.0-RC1*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-RC1)

* [*closed in 1.0-M3*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3)

* [*closed in 1.0-M2*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2)

* [*closed in 1.0-M1*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1)


## Changes per module

@@toc { depth=1 }

@@@ index

* [AMQP](1.0.x/amqp.md)
* [Apache Cassandra](1.0.x/cassandra.md)
* [Apache Geode](1.0.x/geode.md)
* [Apache Kafka](1.0.x/kafka.md)
* [Apache Kudu](1.0.x/kudu.md)
* [Apache Solr](1.0.x/solr.md)
* [Avro Parquet](1.0.x/avroparquet.md)
* [AWS DynamoDB](1.0.x/dynamodb.md)
* [AWS Kinesis](1.0.x/kinesis.md)
* [AWS Lambda](1.0.x/awslambda.md)
* [AWS S3](1.0.x/s3.md)
* [AWS SNS](1.0.x/sns.md)
* [AWS SQS](1.0.x/sqs.md)
* [Azure Storage Queue](1.0.x/azure-storage-queue.md)
* [CSV](1.0.x/csv.md)
* [Couchbase](1.0.x/couchbase.md)
* [Elasticsearch](1.0.x/elasticsearch.md)
* [File](1.0.x/file.md)
* [FTP](1.0.x/ftp.md)
* [Google Cloud Pub/Sub](1.0.x/google-cloud-pub-sub.md)
* [Google Cloud Pub/Sub gRPC](1.0.x/google-cloud-pub-sub-grpc.md)
* [Google Firebase Cloud Messaging](1.0.x/google-fcm.md)
* [Hadoop Distributed File System](1.0.x/hdfs.md)
* [HBase](1.0.x/hbase.md)
* [IronMQ](1.0.x/ironmq.md)
* [JMS](1.0.x/jms.md)
* [Json streaming](1.0.x/json-streaming.md)
* [MongoDB](1.0.x/mongodb.md)
* [MQTT](1.0.x/mqtt.md)
* [MQTT Streaming](1.0.x/mqtt-streaming.md)
* [OrientDB](1.0.x/orientdb.md)
* [Server-sent Events (SSE)](1.0.x/sse.md)
* [Simple Codecs (RecordIO)](1.0.x/simple-codecs.md)
* [Slick (JDBC)](1.0.x/slick.md)
* [Spring Web](1.0.x/spring-web.md)
* [UDP](1.0.x/udp.md)
* [Unix Domain Sockets](1.0.x/unix-domain-socket.md)
* [XML](1.0.x/xml.md)


@@@
