Release Alpakka $VERSION$

<!--
# Release Train Issue Template for Alpakka

(Liberally copied and adopted from Scala itself https://github.com/scala/scala-dev/blob/b11cd2e4a4431de7867db6b39362bea8fa6650e7/notes/releases/template.md)

For every Alpakka release, make a copy of this file named after the release, and expand the variables.
Ideally replacing variables could become a script you can run on your local machine.

Variables to be expanded in this template:
- $VERSION$=???

Key links:
  - akka/alpakka milestone: https://github.com/akka/alpakka/milestone/?
-->
### ~ 1 week before the release

- [ ] Check that any new `deprecated` annotations use the correct version name
- [ ] Check that open PRs and issues assigned to the milestone are reasonable
- [ ] Decide on planned release date
- [ ] Notify depending projects (Akka persistence plugins) about the upcoming release
- [ ] Create a new milestone for the [next version](https://github.com/akka/alpakka/milestones)
- [ ] Check [closed issues without a milestone](https://github.com/akka/alpakka/issues?utf8=%E2%9C%93&q=is%3Aissue%20is%3Aclosed%20no%3Amilestone) and either assign them the 'upcoming' release milestone or `invalid/not release-bound`

### 1 day before the release

- [ ] Make sure all important / big PRs have been merged by now
- [ ] Communicate that a new version is about to be released in [Gitter Akka Dev Channel](https://gitter.im/akka/dev), so that no new Pull Requests are merged

### Preparing release notes in the documentation / announcement

- [ ] For non-patch releases: rename the 'alpakka-x.x-stable' and 'alpakka-supported-x.x-stable' reporting projects in [WhiteSource](https://saas.whitesourcesoftware.com/Wss/WSS.html#!project;id=517292) accordingly (unfortunately this requires permissions that cannot be shared outside of Lightbend)
- [ ] Check readiness levels in `/project/project-info.conf`, and put in the release date for any new modules
- [ ] Check supported projects listing in `whitesourceSupported`
- [ ] Add a release notes entry in `docs/src/main/paradox/release-notes/` listing contributors generated by [`sbt-authors`](https://github.com/2m/authors) (eg. `sbt authors v0.22 HEAD`)
- [ ] For non-patch releases: Create a news item draft PR on [akka.github.com](https://github.com/akka/akka.github.com), using the milestone
- [ ] Move all [unclosed issues](https://github.com/akka/alpakka/issues?q=is%3Aopen+is%3Aissue+milestone%3A$VERSION$) for this milestone to the next milestone
- [ ] Release notes PR has been merged

### Cutting the release

- [ ] Wait until [master build finished](https://travis-ci.com/akka/alpakka/builds/) after merging the release notes
- [ ] Create a [new release](https://github.com/akka/alpakka/releases/new) with the next tag version `v$VERSION$`, title and release description linking to announcement, release notes and milestone
- [ ] Check that Travis CI release build has executed successfully (Travis will start a [CI build](https://travis-ci.com/akka/alpakka/builds) for the new tag and publish artifacts to Bintray and documentation to Gustav)
- [ ] Go to [Bintray](https://bintray.com/akka/maven/alpakka) and select the just released version
- [ ] Go to the Maven Central tab, check the *Close and release repository when done* checkbox and sync with Sonatype (using your Sonatype TOKEN key and password)
- [ ] Close the [$VERSION$ milestone](https://github.com/akka/alpakka/milestones?direction=asc&sort=due_date)

### Check availability

- [ ] Check [API](https://doc.akka.io/api/alpakka/$VERSION$/) documentation
- [ ] Check [reference](https://doc.akka.io/docs/alpakka/$VERSION$/) documentation
- [ ] Check the release on [Maven central](http://central.maven.org/maven2/com/lightbend/akka/akka-stream-alpakka-xml_2.12/$VERSION$/)

### When everything is on maven central
  - [ ] Log into `gustav.akka.io` as `akkarepo` 
    - [ ] update the `current` links on `repo.akka.io` to point to the latest version with
         ```
         ln -nsf $VERSION$ www/docs/alpakka/current
         ln -nsf $VERSION$ www/api/alpakka/current
         ln -nsf $VERSION$ www/docs/alpakka/1.1
         ln -nsf $VERSION$ www/api/alpakka/1.1
         ```
    - [ ] check changes and commit the new version to the local git repository
         ```
         cd ~/www
         git add docs/alpakka/1.1 docs/alpakka/current docs/alpakka/$VERSION$
         git add api/alpakka/1.1 api/alpakka/current api/alpakka/$VERSION$
         git commit -m "Alpakka $VERSION$"
         ```

### Announcements

- [ ] For non-patch releases: Merge draft news item for [akka.io](https://github.com/akka/akka.github.com)
- [ ] Send a release notification to [Lightbend discuss](https://discuss.akka.io)
- [ ] Tweet using the akkateam account (or ask someone to) about the new release
- [ ] Announce on [Gitter akka/akka](https://gitter.im/akka/akka)
- [ ] Announce internally

### Afterwards

- [ ] If Couchbase has relevant changes, create/update PR in [Akka Persistence Couchbase](https://github.com/akka/akka-persistence-couchbase/) to upgrade to $VERSION$
- [ ] Update version for [Lightbend Supported Modules](https://developer.lightbend.com/docs/lightbend-platform/introduction/getting-help/build-dependencies.html#_alpakka) in [private project](https://github.com/lightbend/lightbend-platform-docs/blob/master/docs/modules/getting-help/examples/build.sbt)
- Close this issue
