# Alpakka 1.0-M3

## Third milestone release for Alpakka 1.0

All modules are now restructured to meet the preferred code layout as illustrated by the [Reference connector](https://doc.akka.io/docs/alpakka/current/reference.html).

On this [Road to Alpakka 1.0](https://akka.io/blog/news/2018/08/30/alpakka-towards-1.0) we are deliberately making a lot of non-compatible API changes to many connectors. From version 1.0 Alpakka will stay [binary-compatible](https://doc.akka.io/docs/akka/current/common/binary-compatibility-rules.html#binary-compatibility-rules) between minor releases.

Having that said, Alpakka will start to make use of the `@ApiMayChange` annotation to keep the door open for API changes in new modules, so that they can evolve more rapidly than other modules within Alpakka.

Even modules that have been changed to meet Alpakka 1.0 standards might get more API-breaking changes before Alpakka reaches 1.0. If you prefer adapting to these changes in one bigger step, keep the version you are using until Alpakka 1.0 is final.

Everything done in this release is [in the milestone](https://github.com/akka/alpakka/issues?q=milestone%3A1.0-M3).

## Highlights in this release

* @ref:[Elasticsearch](../elasticsearch.md) connector now has support for the new Akka Stream context propagation feature.
* @ref:[AWS DynamoDb](../dynamodb.md), @ref:[Google Cloud Pub/Sub gRPC](../google-cloud-pub-sub-grpc.md), @ref:[Kudu](../kudu.md) now use Akka Stream attributes to inject needed resources
* @ref:[Apache Solr](../solr.md), @ref:[AWS Kinesis](../kinesis.md), @ref:[Geode](../geode.md), @ref:[Google FCM](../google-fcm.md), @ref:[HBase](../hbase.md), @ref:[HDFS](../hdfs.md), @ref:[IronMq](../ironmq.md), @ref:[MongoDb](../mongodb.md), @ref:[OrientDb](../orientdb.md), @ref:[XML](../data-transformations/xml.md) connectors have been refactored to more closely follow Alpakka connector guidelines
* Most of the connectors now support Scala 2.13.0-M5. You may track the progress for the remaining connectors in the [Scala 2.13 GitHub project](https://github.com/akka/alpakka/projects/2).

## Changes per module

### @ref:[AMQP](../amqp.md)

**Breaking API changes**

* fixed a bug where source would not shut down @github[#1500](#1500)
* renamed stream elements according to the Alpakka connector guidelines @github[#1513](#1513)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aamqp)

### @ref:[Apache Solr](../solr.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1090](#1090)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Asolr)

### @ref:[AWS DynamoDb](../dynamodb.md)

**Breaking API changes**

* DynamoDb client is now injected via stream attributes @github[#1420](#1420)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aaws-dynamodb)

### @ref:[AWS S3](../s3.md)

* fixed a bug where settings would not be applied to all flows @github[#1443](#1443)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aaws-s3)

### @ref:[AWS SNS](../sns.md)

* upgraded the connector to the new AWS SDK v2 @github[#1343](#1343)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aaws-sns)

### @ref:[AWS SQS](../sqs.md)

* upgraded the connector to the new AWS SDK v2 @github[#1344](#1344)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aaws-sqs)

### @ref:[AWS Kinesis](../kinesis.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1080](#1080)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aaws-kinesis)

### @ref:[File](../file.md)

* generalised LogRotator to take sink factories @github[#1452](#1452)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Afile)

### @ref:[Ftp](../ftp.md)

* fixed a bug where a wrong path separator would be used when running client on windows @github[#1470](#1470)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aftp)

### @ref:[Elasticsearch](../elasticsearch.md)

**Breaking API changes**

* added support for the new Akka Stream context propagation @github[#1523](#1523)
* added support for Elastic search create operation @github[#1510](#1510)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aelasticsearch)

### @ref:[Geode](../geode.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1073](#1073)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Ageode)

### @ref:[Google Cloud Pub/Sub gRPC](../google-cloud-pub-sub-grpc.md)

**Breaking API changes**

* grpc publisher/subscriber is now injected via stream attributes @github[#1466](#1466)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Agoogle-cloud-pub-sub-grpc)

### @ref:[Google Firebase Cloud Messaging](../google-fcm.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1075](#1075)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Agoogle-fcm)

### @ref:[HBase](../hbase.md)

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1076](#1076)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Ahbase)

### @ref:[HDFS](../hdfs.md)

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1441](#1441)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Ahdfs)

### @ref:[IronMq](../ironmq.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1472](#1472)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aironmq)

### @ref:[JMS](../jms/index.md)

* added runnable IBM MQ testcase @github[#1328](#1328)
* added destination names in log messages @github[#1483](#1483)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Ajms)

### @ref:[Kudu](../kudu.md)

**Breaking API changes**

* kudu client is now injected via stream attributes @github[#1217](#1217)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Akudu)

### @ref:[MongoDB](../mongodb.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1082](#1082)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Amongodb)

### @ref:[Mqtt Streaming](../mqtt-streaming.md)

* various bugfixes @github[#1489](#1489) @github[#1480](#1480) @github[#1440](#1440) @github[#1436](#1436)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Amqtt-streaming)

### @ref:[OrientDB](../orientdb.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1085](#1085)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aorientdb)

### @ref:[Slick](../slick.md)

* upgraded Slick to 3.3.0 @github[#1487](#1487)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aslick)

### @ref:[Spring Web](../spring-web.md)

* added support from Spring Boot 2.0 @github[#1451](#1451)
* added ability to set ActorSystem name @github[#1454](#1454)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Aspring-web)

### @ref:[XML](../data-transformations/xml.md)

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1094](#1094)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M3+label%3Ap%3Axml)

## Acknowledgements

This release was made possible by a lot of new and earlier contributors:

| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="2m" src="https://avatars3.githubusercontent.com/u/422086?v=4&amp;s=40"/> **2m**](https://github.com/2m) | 62 | 4856 | 3529 |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&amp;s=40"/> **ennru**](https://github.com/ennru) | 61 | 14004 | 12640 |
| [<img width="20" alt="huntc" src="https://avatars2.githubusercontent.com/u/694893?v=4&amp;s=40"/> **huntc**](https://github.com/huntc) | 13 | 1190 | 1044 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&amp;s=40"/> **sullis**](https://github.com/sullis) | 5 | 19 | 10 |
| [<img width="20" alt="gabfssilva" src="https://avatars1.githubusercontent.com/u/5403842?v=4&amp;s=40"/> **gabfssilva**](https://github.com/gabfssilva) | 2 | 1441 | 2001 |
| [<img width="20" alt="sleipnir" src="https://avatars2.githubusercontent.com/u/342502?v=4&amp;s=40"/> **sleipnir**](https://github.com/sleipnir) | 2 | 102 | 19 |
| [<img width="20" alt="NikitaZhevnitskiy" src="https://avatars2.githubusercontent.com/u/15572799?v=4&amp;s=40"/> **NikitaZhevnitskiy**](https://github.com/NikitaZhevnitskiy) | 1 | 415 | 141 |
| [<img width="20" alt="longshorej" src="https://avatars1.githubusercontent.com/u/515201?v=4&amp;s=40"/> **longshorej**](https://github.com/longshorej) | 1 | 115 | 37 |
| [<img width="20" alt="stephennancekivell" src="https://avatars0.githubusercontent.com/u/727013?v=4&amp;s=40"/> **stephennancekivell**](https://github.com/stephennancekivell) | 1 | 98 | 29 |
| [<img width="20" alt="yiftizur" src="https://avatars3.githubusercontent.com/u/82019?v=4&amp;s=40"/> **yiftizur**](https://github.com/yiftizur) | 1 | 90 | 5 |
| [<img width="20" alt="danelkotev" src="https://avatars1.githubusercontent.com/u/35635831?v=4&amp;s=40"/> **danelkotev**](https://github.com/danelkotev) | 1 | 50 | 6 |
| [<img width="20" alt="seglo" src="https://avatars2.githubusercontent.com/u/1148412?v=4&amp;s=40"/> **seglo**](https://github.com/seglo) | 1 | 34 | 0 |
| [<img width="20" alt="denisgarci" src="https://avatars3.githubusercontent.com/u/5141673?v=4&amp;s=40"/> **denisgarci**](https://github.com/denisgarci) | 1 | 10 | 10 |
| [<img width="20" alt="ukayani" src="https://avatars3.githubusercontent.com/u/14280152?v=4&amp;s=40"/> **ukayani**](https://github.com/ukayani) | 1 | 9 | 0 |
| [<img width="20" alt="sdeigm" src="https://avatars3.githubusercontent.com/u/46769049?v=4&amp;s=40"/> **sdeigm**](https://github.com/sdeigm) | 1 | 4 | 1 |
