# Alpakka 1.0-M2

## Second milestone release for Alpakka 1.0

Many modules have been restructured to meet the preferred code layout as illustrated by the [Reference connector](https://doc.akka.io/docs/alpakka/current/reference.html).

On this [Road to Alpakka 1.0](https://akka.io/blog/news/2018/08/30/alpakka-towards-1.0) we are deliberately making a lot of non-compatible API changes to many connectors. From version 1.0 Alpakka will stay [binary-compatible](https://doc.akka.io/docs/akka/current/common/binary-compatibility-rules.html#binary-compatibility-rules) between minor releases.

Having that said, Alpakka will start to make use of the `@ApiMayChange` annotation to keep the door open for API changes in new modules, so that they can evolve more rapidly than other modules within Alpakka.

Even modules that have been changed to meet Alpakka 1.0 standards might get more API-breaking changes before Alpakka reaches 1.0. If you prefer adapting to these changes in one bigger step, keep the version you are using until Alpakka 1.0 is final.

Everything done in this release is [in the milestone](https://github.com/akka/alpakka/issues?q=milestone%3A1.0-M2).

## Highlights in this release

* new Akka Stream native @ref:[MQTT Streaming Connector](../mqtt-streaming.md) thanks to [@huntc](https://github.com/huntc), the existing Eclipse Paho-based connector will stay around for a while but might be discontinued in the future
* new @ref:[Couchbase Connector](../couchbase.md) which even is the base for the new [Akka Persistence Couchbase](https://doc.akka.io/docs/akka-persistence-couchbase/current/), thanks to [@dannylesnik](https://github.com/dannylesnik) 
* refactoring of the @ref:[S3 Connector](../s3.md). See below for more details
* refactoring of the @ref:[JMS Connector](../jms/index.md).
  Also support for retries and connection status thanks to [@andreas-schroeder](https://github.com/andreas-schroeder)
* refactoring of the @ref:[Google Cloud Pub/Sub Connector](../google-cloud-pub-sub.md) thanks to [@tg44](https://github.com/tg44)


## Changes per module

### @ref:[AMQP](../amqp.md)

* automatic recovery is disabled by default @github[#1273](#1273)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Aamqp)

### @ref:[Apache Geode](../geode.md)

* updated to Geode `1.8.0` @github[#1374](#1374)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Ageode)

### @ref:[Apache Solr](../solr.md)

* support for optional routing value @github[#1301](#1301)
* fixed a bug where requests could be reordered @github[#1363](#1363)
* handle errors with Akka supervision @github[#1351](#1351)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Asolr)
 
### @ref:[AWS DynamoDB](../dynamodb.md)

* base url is now overridable @github[#1384](#1384)
* added support for transactional operations @github[#1408](#1408)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Adynamodb)

### @ref:[AWS S3](../s3.md)

The S3 module has been refactored to follow the preferred code layout.
This means that all of the factory methods have been moved from `S3Client` instance to a static factory @scala[@scaladoc[S3](akka.stream.alpakka.s3.scaladsl.S3$)]@java[@scaladoc[S3](akka.stream.alpakka.s3.javadsl.S3$)].
Also the factory method return types have been cleaned from @scala[`Future`]@java[`CompletionStage`] types.

These changes have been done with the intention to embrace the blue-print nature of Akka Stream API.
Any `Source`, `Flow` or a `Sink` should be reusable even across different `ActorSystem`s.
The old S3 module API made every stream related to a particular instance of `S3Client`, which was in turn related to a particular
`ActorSystem`, `ActorMaterializer` and `S3Settings`.
New API frees the factory methods from these dependencies.
All of the required resources are injected during the materialization time.

If you are loading `S3Settings` from the `application.conf` then migration should be done by changing all method calls on `s3Client` instance to method calls on the @scala[@scaladoc[S3](akka.stream.alpakka.s3.scaladsl.S3$)]@java[@scaladoc[S3](akka.stream.alpakka.s3.javadsl.S3$)] factory.
If you were using multiple `s3Client` instances with different configurations, then take a look at the new @ref:[documentation section](../s3.md#apply-s3-settings-to-a-part-of-the-stream) about how to use `S3Attributes` to apply different `S3Settings` to different parts of the same Akka Stream graph.

The configuration path has been shortened from `akka.stream.alpakka.s3` to `alpakka.s3`.
Please update your `application.conf` files accordingly.

Other S3 changes:

 * allow to get object metadata without size limit @github[#1332](#1332)
 * path-style access is now the default @github[#1308](#1308)
 * requests are now retried for S3 internal errors @github[#1303](#1303)
 * fix session token access @github[#1299](#1299)
 * downloaded file is wrapped into an `Option` to allow for missing files @github[#1275](#1275)
 * cache control added to object metadata requests @github[#1274](#1274)
 * support for exceptions from non XML responses @github[#1265](#1265)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Aaws-s3)

### @ref:[AWS SNS](../sns.md)

* added support for per message destinations @github[#1267](#1267)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Aaws-sns)

### @ref:[AWS SQS](../sqs.md)

**Breaking API changes**

* added support for per message destinations @github[#1267](#1267)
* fixed a bug where the connector would not always complete @github[#513](#513)
* added support for visibility timeout @github[#1287](#1287)
* fixed missing equality in model classes @github[#1310](#1310)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Aaws-sqs)

### @ref:[Couchbase](../couchbase.md)

* new Couchbase connector @github[#36](#36)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Acouchbase)

### @ref:[Elasticsearch](../elasticsearch.md)

* fixed retry logic @github[#1300](#1300)
* scroll duration is now configurable @github[#1366](#1366)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Aelasticsearch)

### @ref:[FTP](../ftp.md)

* upgraded dependencies @github[#1372](#1372)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Aftp)

### @ref:[Google Cloud Pub/Sub](../google-cloud-pub-sub.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1258](#1258)
* added a backoff when no messages are fetched @github[#1259](#1259)
* removed not used api key parameter @github[#1407](#1407)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Agoogle-cloud-pub-sub)

### @ref:[JMS](../jms/index.md)

**Breaking API changes**

* refactored the connector to more closely follow Alpakka connector guidelines @github[#1314](#1314)
* added retry support to producer @github[#1227](#1227)
* added connection status support @github[#1252](#1252)
* improved pass-through support @github[#1331](#1331)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Ajms)

### @ref:[MQTT](../mqtt.md)

* added support to offline persistence settings @github[#1272](#1272)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Amqtt)
 
### @ref:[MQTT Streaming](../mqtt-streaming.md)

* new Akka Stream native MQTT connector @github[#892](#892)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Amqtt-streaming)

### @ref:[CSV](../data-transformations/csv.md)

* added support for non-standard line endings @github[#1398](1398)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Acsv)

### @ref:[XML](../data-transformations/xml.md)

**Breaking API changes**

* fixed parsing subtrees with namespaces @github[#1277](#1277)
* moved `ParseEventMarker` to correct package @github[#1373](1373)

[*all closed issues*](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M2+label%3Ap%3Axml)


## Acknowledgements

This release was made possible by a lot of new and earlier contributors:


| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="2m" src="https://avatars3.githubusercontent.com/u/422086?v=4&amp;s=40"/> **2m**](https://github.com/2m) | 36 | 5138 | 4834 |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&amp;s=40"/> **ennru**](https://github.com/ennru) | 30 | 13003 | 9262 |
| [<img width="20" alt="huntc" src="https://avatars2.githubusercontent.com/u/694893?v=4&amp;s=40"/> **huntc**](https://github.com/huntc) | 20 | 8975 | 1263 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&amp;s=40"/> **sullis**](https://github.com/sullis) | 10 | 720 | 865 |
| [<img width="20" alt="andreas-schroeder" src="https://avatars3.githubusercontent.com/u/6724788?v=4&amp;s=40"/> **andreas-schroeder**](https://github.com/andreas-schroeder) | 4 | 1797 | 618 |
| [<img width="20" alt="RustedBones" src="https://avatars3.githubusercontent.com/u/2845540?v=4&amp;s=40"/> **RustedBones**](https://github.com/RustedBones) | 3 | 1303 | 1019 |
| [<img width="20" alt="cheleb" src="https://avatars0.githubusercontent.com/u/378539?v=4&amp;s=40"/> **cheleb**](https://github.com/cheleb) | 3 | 179 | 93 |
| [<img width="20" alt="gregbeech" src="https://avatars2.githubusercontent.com/u/1895226?v=4&amp;s=40"/> **gregbeech**](https://github.com/gregbeech) | 3 | 95 | 14 |
| [<img width="20" alt="dannylesnik" src="https://avatars2.githubusercontent.com/u/40953798?v=4&amp;s=40"/> **dannylesnik**](https://github.com/dannylesnik) | 2 | 2000 | 4 |
| [<img width="20" alt="jtjeferreira" src="https://avatars1.githubusercontent.com/u/943051?v=4&amp;s=40"/> **jtjeferreira**](https://github.com/jtjeferreira) | 2 | 204 | 147 |
| [<img width="20" alt="giena" src="https://avatars3.githubusercontent.com/u/6929360?v=4&amp;s=40"/> **giena**](https://github.com/giena) | 2 | 176 | 65 |
| [<img width="20" alt="juanjoDiaz" src="https://avatars0.githubusercontent.com/u/3322485?v=4&amp;s=40"/> **juanjoDiaz**](https://github.com/juanjoDiaz) | 2 | 10 | 401 |
| [<img width="20" alt="tg44" src="https://avatars1.githubusercontent.com/u/31839?v=4&amp;s=40"/> **tg44**](https://github.com/tg44) | 1 | 1205 | 1153 |
| [<img width="20" alt="gabfssilva" src="https://avatars1.githubusercontent.com/u/5403842?v=4&amp;s=40"/> **gabfssilva**](https://github.com/gabfssilva) | 1 | 278 | 51 |
| [<img width="20" alt="bigmoby" src="https://avatars1.githubusercontent.com/u/11453002?v=4&amp;s=40"/> **bigmoby**](https://github.com/bigmoby) | 1 | 161 | 23 |
| [<img width="20" alt="michaelpisula" src="https://avatars3.githubusercontent.com/u/2330663?v=4&amp;s=40"/> **michaelpisula**](https://github.com/michaelpisula) | 1 | 96 | 13 |
| [<img width="20" alt="fbessadok" src="https://avatars2.githubusercontent.com/u/1790778?v=4&amp;s=40"/> **fbessadok**](https://github.com/fbessadok) | 1 | 89 | 8 |
| [<img width="20" alt="bpiper" src="https://avatars3.githubusercontent.com/u/12616466?v=4&amp;s=40"/> **bpiper**](https://github.com/bpiper) | 1 | 82 | 18 |
| [<img width="20" alt="barakbaronk" src="https://avatars2.githubusercontent.com/u/16286839?v=4&amp;s=40"/> **barakbaronk**](https://github.com/barakbaronk) | 1 | 53 | 6 |
| [<img width="20" alt="stephennancekivell" src="https://avatars0.githubusercontent.com/u/727013?v=4&amp;s=40"/> **stephennancekivell**](https://github.com/stephennancekivell) | 1 | 29 | 59 |
| Grigorii Chudnov | 1 | 29 | 6 |
| [<img width="20" alt="scoquelin" src="https://avatars0.githubusercontent.com/u/2460514?v=4&amp;s=40"/> **scoquelin**](https://github.com/scoquelin) | 1 | 20 | 22 |
| [<img width="20" alt="duartepinto" src="https://avatars1.githubusercontent.com/u/7612420?v=4&amp;s=40"/> **duartepinto**](https://github.com/duartepinto) | 1 | 18 | 1 |
| [<img width="20" alt="longshorej" src="https://avatars1.githubusercontent.com/u/515201?v=4&amp;s=40"/> **longshorej**](https://github.com/longshorej) | 1 | 17 | 6 |
| [<img width="20" alt="DmitryBMsk" src="https://avatars2.githubusercontent.com/u/4634893?v=4&amp;s=40"/> **DmitryBMsk**](https://github.com/DmitryBMsk) | 1 | 17 | 6 |
| [<img width="20" alt="gabrielreid" src="https://avatars3.githubusercontent.com/u/527401?v=4&amp;s=40"/> **gabrielreid**](https://github.com/gabrielreid) | 1 | 10 | 4 |
| [<img width="20" alt="tPl0ch" src="https://avatars0.githubusercontent.com/u/115348?v=4&amp;s=40"/> **tPl0ch**](https://github.com/tPl0ch) | 1 | 8 | 7 |
| [<img width="20" alt="odd" src="https://avatars0.githubusercontent.com/u/49301?v=4&amp;s=40"/> **odd**](https://github.com/odd) | 1 | 7 | 1 |
| [<img width="20" alt="gchudnov" src="https://avatars2.githubusercontent.com/u/1832751?v=4&amp;s=40"/> **gchudnov**](https://github.com/gchudnov) | 1 | 3 | 3 |
| [<img width="20" alt="Ewan-Keith" src="https://avatars2.githubusercontent.com/u/11393965?v=4&amp;s=40"/> **Ewan-Keith**](https://github.com/Ewan-Keith) | 1 | 3 | 3 |
| [<img width="20" alt="raboof" src="https://avatars2.githubusercontent.com/u/131856?v=4&amp;s=40"/> **raboof**](https://github.com/raboof) | 1 | 1 | 1 |
| [<img width="20" alt="sergeantwolf" src="https://avatars2.githubusercontent.com/u/4949483?v=4&amp;s=40"/> **sergeantwolf**](https://github.com/sergeantwolf) | 1 | 1 | 1 |
| [<img width="20" alt="btapo" src="https://avatars2.githubusercontent.com/u/11292769?v=4&amp;s=40"/> **btapo**](https://github.com/btapo) | 1 | 1 | 1 |
