# Alpakka 1.0-M1

## First milestone release for Alpakka 1.0

Many modules have been restructured to meet the preferred code layout as illustrated by the [Reference connector](https://doc.akka.io/docs/alpakka/current/reference.html).

On this [Road to Alpakka 1.0](https://akka.io/blog/news/2018/08/30/alpakka-towards-1.0) we are deliberately making a lot of non-compatible API changes to many connectors. From version 1.0 Alpakka will stay [binary-compatible](https://doc.akka.io/docs/akka/current/common/binary-compatibility-rules.html#binary-compatibility-rules) between minor releases.

Having that said, Alpakka will start to make use of the `@ApiMayChange` annotation to keep the door open for API changes in new modules, so that they can evolve more rapidly than other modules within Alpakka.

Even modules that have been changed to meet Alpakka 1.0 standards might get more API-breaking changes before Alpakka reaches 1.0. If you prefer adapting to these changes in one bigger step, keep the version you are using until Alpakka 1.0 is final.


## Highlights in this release

* Major new functionality in the @ref:[JMS module](../jms/index.md). Primarily contributed by [@akara], [@andreas-schroeder] and [@jugalps].

* Support for Update/Delete/Atomic update and batching in @ref:[Solr](../solr.md), contributed by [@giena].

* Support for Update and Delete in @ref:[Elasticsearch](../elasticsearch.md), contributed by [@takezoe].

* New gRPC-based connector to @ref:[Google Cloud Pub/Sub](../google-cloud-pub-sub-grpc.md) (complementing the HTTP-based), initial work by [@CremboC].

* @ref:[XML](../data-transformations/xml.md) Subtree flow, which extracts elements that match a certain path, contributed by [@takezoe].

[@akara]: https://github.com/akara
[@andreas-schroeder]: https://github.com/andreas-schroeder
[@jugalps]: https://github.com/jugalps
[@giena]: https://github.com/giena
[@takezoe]: https://github.com/takezoe
[@CremboC]: https://github.com/CremboC

## Highlights per module


### @ref:[AMQP](../amqp.md)

**Breaking API changes**

 * Support for all SSL configuration variants #1146
 * Support for AMQP `autoAck` #1001
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aamqp)

### @ref:[Apache Cassandra](../cassandra.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Acassandra)

### @ref:[Apache Geode](../geode.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Ageode)

### @ref:[Apache Kudu](../kudu.md)

**Breaking API changes**
    
 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Akudu)

### @ref:[Apache Solr](../solr.md)

**Breaking API changes**

 * Support for update/delete/atomic update operations 
 * Batch operations to Solr
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Asolr)

### @ref:[AWS DynamoDB](../dynamodb.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Adynamodb)

### @ref:[AWS Kinesis](../kinesis.md)

 * Unchanged

### @ref:[AWS Lambda](../awslambda.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aaws-lambda)

### @ref:[AWS S3](../s3.md)

 * fail stream when request fails #1117
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aaws-s3)

### @ref:[AWS SNS](../sns.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * Support for using PublishRequest #1114
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aaws-sns)

### @ref:[AWS SQS](../sqs.md)

**Breaking API changes**

 * Keep message order #1214
 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aaws-sqs)

### @ref:[Azure Storage Queue](../azure-storage-queue.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aazure-storage-queue)

### @ref:[Elasticsearch](../elasticsearch.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * per message metadata #1161
 * Support update and delete #1104
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aelasticsearch)

### @ref:[File](../file.md)

 * Prepared for Alpakka 1.0 (backwards-compatible)
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Afile)

### @ref:[FTP](../ftp.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aftp)

### @ref:[Google Cloud Pub/Sub](../google-cloud-pub-sub.md)

 * Slightly improved error handling
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Agoogle-cloud-pub-sub)

### @ref:[Google Cloud Pub/Sub gRPC](../google-cloud-pub-sub-grpc.md)

 * New module for Google Cloud Pub/Sub based on the new [Akka gRPC](https://developer.lightbend.com/docs/akka-grpc/current/) module
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Agoogle-cloud-pub-sub-grpc)
 
### @ref:[Google FCM](../google-fcm.md)

 * Unchanged

### @ref:[HDFS](../hdfs.md)

 * Unchanged
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Ahdfs)

### @ref:[HBase](../hbase.md)

 * Unchanged

### @ref:[IronMQ](../ironmq.md)

 * Unchanged

### @ref:[JMS](../jms/index.md)

 * Support Pass-Through in producer flow #1211
 * Connection timeouts and retries #1194 
 * Commit timeouts #1189
 * Per message destinations #1181
 * Support durable subscriptions #1178
 * Multi-JMS-session producer #1148
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Ajms)

### @ref:[MongoDb](../mongodb.md)

 * Upgraded to Mongo Scala Driver 2.4.2
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Amongodb)

### @ref:[MQTT](../mqtt.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Amqtt)

### @ref:[OrientDB](../orientdb.md)

**Breaking API changes**

 * Prepared for Alpakka 1.0
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aorientdb)

### @ref:[SSE - Sever-sent events](../sse.md)

 * Unchanged

### @ref:[Slick / JDBC](../slick.md)

 * Prepared for Alpakka 1.0 (backwards-compatible)
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aslick)

### @ref:[Spring Web](../spring-web.md)

 * Prepared for Alpakka 1.0 (backwards-compatible)
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aspring-web)

### @ref:[UDP](../udp.md)

 * Unchanged

### @ref:[Unix Domain Socket](../unix-domain-socket.md)

 * Prepared for Alpakka 1.0 (backwards-compatible)
 * Improved halfClose handling #1142
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Aunix-domain-socket)


### @ref:[CSV](../data-transformations/csv.md)

 * Prepared for Alpakka 1.0 (backwards-compatible)
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Acsv)

### @ref:[JSON Streaming](../data-transformations/json.md)

 * Prepared for Alpakka 1.0 (backwards-compatible)
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Ajson-streaming )

### @ref:[RecordIO / Simple codecs](../data-transformations/simple-codecs.md)

 * Prepared for Alpakka 1.0 (backwards-compatible)
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Arecordio)

### @ref:[Text](../data-transformations/text.md)

 * Unchanged
 
### @ref:[XML](../data-transformations/xml.md)

 * Subtree flow, which extracts elements that match a certain path #1099
 * Improved Java API #1221
 * [closed issues](https://github.com/akka/alpakka/issues?q=is%3Aclosed+milestone%3A1.0-M1+label%3Ap%3Axml)

Everything done in this release is [in the milestone](https://github.com/akka/alpakka/issues?q=milestone%3A1.0-M1).


## General information

This release is compiled and tested against [Akka 2.5](https://doc.akka.io/docs/akka/current/).
The S3 and SSE connectors require at least *Akka Http 10.0.13* and are compatible with Akka Http 10.1.1+.

This release was made possible by a lot of new and earlier contributors:

| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&amp;s=40"/> **ennru**](https://github.com/ennru) | 64 | 19793 | 16823 |
| [<img width="20" alt="2m" src="https://avatars3.githubusercontent.com/u/422086?v=4&amp;s=40"/> **2m**](https://github.com/2m) | 29 | 6885 | 5141 |
| [<img width="20" alt="takezoe" src="https://avatars1.githubusercontent.com/u/1094760?v=4&amp;s=40"/> **takezoe**](https://github.com/takezoe) | 10 | 824 | 251 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&amp;s=40"/> **sullis**](https://github.com/sullis) | 5 | 5 | 5 |
| [<img width="20" alt="andreas-schroeder" src="https://avatars3.githubusercontent.com/u/6724788?v=4&amp;s=40"/> **andreas-schroeder**](https://github.com/andreas-schroeder) | 4 | 1324 | 295 |
| [<img width="20" alt="johanandren" src="https://avatars3.githubusercontent.com/u/666915?v=4&amp;s=40"/> **johanandren**](https://github.com/johanandren) | 3 | 116 | 60 |
| [<img width="20" alt="akara" src="https://avatars3.githubusercontent.com/u/77111?v=4&amp;s=40"/> **akara**](https://github.com/akara) | 2 | 774 | 146 |
| [<img width="20" alt="davideicardi" src="https://avatars2.githubusercontent.com/u/852570?v=4&amp;s=40"/> **davideicardi**](https://github.com/davideicardi) | 2 | 174 | 3 |
| [<img width="20" alt="cheleb" src="https://avatars0.githubusercontent.com/u/378539?v=4&amp;s=40"/> **cheleb**](https://github.com/cheleb) | 1 | 1975 | 1896 |
| [<img width="20" alt="giena" src="https://avatars3.githubusercontent.com/u/6929360?v=4&amp;s=40"/> **giena**](https://github.com/giena) | 1 | 1299 | 202 |
| [<img width="20" alt="dannylesnik" src="https://avatars2.githubusercontent.com/u/40953798?v=4&amp;s=40"/> **dannylesnik**](https://github.com/dannylesnik) | 1 | 784 | 0 |
| [<img width="20" alt="CremboC" src="https://avatars1.githubusercontent.com/u/880130?v=4&amp;s=40"/> **CremboC**](https://github.com/CremboC) | 1 | 716 | 140 |
| [<img width="20" alt="longshorej" src="https://avatars1.githubusercontent.com/u/515201?v=4&amp;s=40"/> **longshorej**](https://github.com/longshorej) | 1 | 476 | 63 |
| [<img width="20" alt="fholger" src="https://avatars3.githubusercontent.com/u/8431552?v=4&amp;s=40"/> **fholger**](https://github.com/fholger) | 1 | 176 | 79 |
| [<img width="20" alt="jugalps" src="https://avatars0.githubusercontent.com/u/576749?v=4&amp;s=40"/> **jugalps**](https://github.com/jugalps) | 1 | 138 | 27 |
| [<img width="20" alt="gabfssilva" src="https://avatars1.githubusercontent.com/u/5403842?v=4&amp;s=40"/> **gabfssilva**](https://github.com/gabfssilva) | 1 | 131 | 13 |
| [<img width="20" alt="juanjoDiaz" src="https://avatars0.githubusercontent.com/u/3322485?v=4&amp;s=40"/> **juanjoDiaz**](https://github.com/juanjoDiaz) | 1 | 63 | 7 |
| [<img width="20" alt="damianbl" src="https://avatars3.githubusercontent.com/u/3999787?v=4&amp;s=40"/> **damianbl**](https://github.com/damianbl) | 1 | 46 | 3 |
| [<img width="20" alt="Synesso" src="https://avatars3.githubusercontent.com/u/21859?v=4&amp;s=40"/> **Synesso**](https://github.com/Synesso) | 1 | 40 | 8 |
| [<img width="20" alt="nebtrx" src="https://avatars0.githubusercontent.com/u/1876959?v=4&amp;s=40"/> **nebtrx**](https://github.com/nebtrx) | 1 | 28 | 2 |
| [<img width="20" alt="eyalfa" src="https://avatars3.githubusercontent.com/u/1131833?v=4&amp;s=40"/> **eyalfa**](https://github.com/eyalfa) | 1 | 13 | 4 |
| [<img width="20" alt="anmol2709" src="https://avatars1.githubusercontent.com/u/25051841?v=4&amp;s=40"/> **anmol2709**](https://github.com/anmol2709) | 1 | 9 | 9 |
| [<img width="20" alt="mertesen" src="https://avatars3.githubusercontent.com/u/6774374?v=4&amp;s=40"/> **mertesen**](https://github.com/mertesen) | 1 | 2 | 2 |
| [<img width="20" alt="niqdev" src="https://avatars2.githubusercontent.com/u/9458643?v=4&amp;s=40"/> **niqdev**](https://github.com/niqdev) | 1 | 2 | 2 |
| [<img width="20" alt="Vincibean" src="https://avatars3.githubusercontent.com/u/5950783?v=4&amp;s=40"/> **Vincibean**](https://github.com/Vincibean) | 1 | 1 | 3 |
| [<img width="20" alt="mikela" src="https://avatars3.githubusercontent.com/u/7447644?v=4&amp;s=40"/> **mikela**](https://github.com/mikela) | 1 | 1 | 1 |
| [<img width="20" alt="bekiroguz" src="https://avatars3.githubusercontent.com/u/1783691?v=4&amp;s=40"/> **bekiroguz**](https://github.com/bekiroguz) | 1 | 1 | 1 |
| [<img width="20" alt="nwtgck" src="https://avatars1.githubusercontent.com/u/10933561?v=4&amp;s=40"/> **nwtgck**](https://github.com/nwtgck) | 1 | 0 | 2 |
