/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.OptionsReader;
import json.ext.RuntimeInfo;
import json.ext.StringDecoder;
import json.ext.Utils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.ConvertDouble;

public class Parser
extends RubyObject {
    private final RuntimeInfo info;
    private RubyString vSource;
    private RubyString createId;
    private boolean createAdditions;
    private int maxNesting;
    private boolean allowNaN;
    private boolean symbolizeNames;
    private boolean quirksMode;
    private RubyClass objectClass;
    private RubyClass arrayClass;
    private RubyHash match_string;
    private static final int DEFAULT_MAX_NESTING = 19;
    private static final ByteList JSON_MINUS_INFINITY = new ByteList(ByteList.plain((CharSequence)"-Infinity"));
    private static final String CONST_NAN = "NaN";
    private static final String CONST_INFINITY = "Infinity";
    private static final String CONST_MINUS_INFINITY = "MinusInfinity";
    static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Parser(ruby, rubyClass);
        }
    };

    public Parser(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.info = RuntimeInfo.forRuntime(ruby);
    }

    @JRubyMethod(name={"new"}, required=1, optional=1, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Parser parser = (Parser)((RubyClass)iRubyObject).allocate();
        parser.callInit(iRubyObjectArray, block);
        return parser;
    }

    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (this.vSource != null) {
            throw ruby.newTypeError("already initialized instance");
        }
        OptionsReader optionsReader = new OptionsReader(threadContext, iRubyObjectArray.length > 1 ? iRubyObjectArray[1] : null);
        this.maxNesting = optionsReader.getInt("max_nesting", 19);
        this.allowNaN = optionsReader.getBool("allow_nan", false);
        this.symbolizeNames = optionsReader.getBool("symbolize_names", false);
        this.quirksMode = optionsReader.getBool("quirks_mode", false);
        this.createId = optionsReader.getString("create_id", this.getCreateId(threadContext));
        this.createAdditions = optionsReader.getBool("create_additions", true);
        this.objectClass = optionsReader.getClass("object_class", ruby.getHash());
        this.arrayClass = optionsReader.getClass("array_class", ruby.getArray());
        this.match_string = optionsReader.getHash("match_string");
        this.vSource = iRubyObjectArray[0].convertToString();
        if (!this.quirksMode) {
            this.vSource = this.convertEncoding(threadContext, this.vSource);
        }
        return this;
    }

    private RubyString convertEncoding(ThreadContext threadContext, RubyString rubyString) {
        ByteList byteList = rubyString.getByteList();
        int n = byteList.length();
        if (n < 2) {
            throw Utils.newException(threadContext, "ParserError", "A JSON text must at least contain two octets!");
        }
        if (this.info.encodingsSupported()) {
            RubyEncoding rubyEncoding = (RubyEncoding)rubyString.encoding(threadContext);
            if (rubyEncoding != this.info.ascii8bit.get()) {
                return (RubyString)rubyString.encode(threadContext, (IRubyObject)this.info.utf8.get());
            }
            String string = Parser.sniffByteList(byteList);
            if (string == null) {
                return rubyString;
            }
            return this.reinterpretEncoding(threadContext, rubyString, string);
        }
        String string = Parser.sniffByteList(byteList);
        if (string == null) {
            return rubyString;
        }
        Ruby ruby = threadContext.getRuntime();
        return (RubyString)((RubyModule)this.info.jsonModule.get()).callMethod(threadContext, "iconv", new IRubyObject[]{ruby.newString("utf-8"), ruby.newString(string), rubyString});
    }

    private static String sniffByteList(ByteList byteList) {
        if (byteList.length() < 4) {
            return null;
        }
        if (byteList.get(0) == 0 && byteList.get(2) == 0) {
            return byteList.get(1) == 0 ? "utf-32be" : "utf-16be";
        }
        if (byteList.get(1) == 0 && byteList.get(3) == 0) {
            return byteList.get(2) == 0 ? "utf-32le" : "utf-16le";
        }
        return null;
    }

    private RubyString reinterpretEncoding(ThreadContext threadContext, RubyString rubyString, String string) {
        RubyEncoding rubyEncoding = this.info.getEncoding(threadContext, string);
        RubyEncoding rubyEncoding2 = (RubyEncoding)this.info.utf8.get();
        RubyString rubyString2 = (RubyString)rubyString.dup();
        rubyString2.force_encoding(threadContext, (IRubyObject)rubyEncoding);
        return (RubyString)rubyString2.encode_bang(threadContext, (IRubyObject)rubyEncoding2);
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext threadContext) {
        return new ParserSession(this, threadContext).parse();
    }

    @JRubyMethod(name={"source"})
    public IRubyObject source_get() {
        return this.checkAndGetSource().dup();
    }

    @JRubyMethod(name={"quirks_mode?"})
    public IRubyObject quirks_mode_p(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.quirksMode);
    }

    public RubyString checkAndGetSource() {
        if (this.vSource != null) {
            return this.vSource;
        }
        throw this.getRuntime().newTypeError("uninitialized instance");
    }

    private RubyString getCreateId(ThreadContext threadContext) {
        IRubyObject iRubyObject = ((RubyModule)this.info.jsonModule.get()).callMethod(threadContext, "create_id");
        return iRubyObject.isTrue() ? iRubyObject.convertToString() : null;
    }

    static /* synthetic */ boolean access$100(Parser parser) {
        return parser.allowNaN;
    }

    static /* synthetic */ ByteList access$300() {
        return JSON_MINUS_INFINITY;
    }

    static /* synthetic */ boolean access$400(Parser parser) {
        return parser.createAdditions;
    }

    static /* synthetic */ RubyHash access$500(Parser parser) {
        return parser.match_string;
    }

    static /* synthetic */ int access$700(Parser parser) {
        return parser.maxNesting;
    }

    static /* synthetic */ RubyClass access$800(Parser parser) {
        return parser.arrayClass;
    }

    static /* synthetic */ RubyClass access$900(Parser parser) {
        return parser.objectClass;
    }

    static /* synthetic */ boolean access$1000(Parser parser) {
        return parser.symbolizeNames;
    }

    static /* synthetic */ RubyString access$1100(Parser parser) {
        return parser.createId;
    }

    private static class ParserSession {
        private final Parser parser;
        private final ThreadContext context;
        private final ByteList byteList;
        private final ByteList view;
        private final byte[] data;
        private final StringDecoder decoder;
        private int currentNesting = 0;
        private final ConvertDouble.DoubleConverter dc;
        private static final int EVIL = 1638;
        private static final byte[] _JSON_value_actions = ParserSession.init__JSON_value_actions_0();
        private static final byte[] _JSON_value_key_offsets = ParserSession.init__JSON_value_key_offsets_0();
        private static final char[] _JSON_value_trans_keys = ParserSession.init__JSON_value_trans_keys_0();
        private static final byte[] _JSON_value_single_lengths = ParserSession.init__JSON_value_single_lengths_0();
        private static final byte[] _JSON_value_range_lengths = ParserSession.init__JSON_value_range_lengths_0();
        private static final byte[] _JSON_value_index_offsets = ParserSession.init__JSON_value_index_offsets_0();
        private static final byte[] _JSON_value_trans_targs = ParserSession.init__JSON_value_trans_targs_0();
        private static final byte[] _JSON_value_trans_actions = ParserSession.init__JSON_value_trans_actions_0();
        private static final byte[] _JSON_value_from_state_actions = ParserSession.init__JSON_value_from_state_actions_0();
        static final int JSON_value_start = 1;
        static final int JSON_value_first_final = 21;
        static final int JSON_value_error = 0;
        static final int JSON_value_en_main = 1;
        private static final byte[] _JSON_integer_actions = ParserSession.init__JSON_integer_actions_0();
        private static final byte[] _JSON_integer_key_offsets = ParserSession.init__JSON_integer_key_offsets_0();
        private static final char[] _JSON_integer_trans_keys = ParserSession.init__JSON_integer_trans_keys_0();
        private static final byte[] _JSON_integer_single_lengths = ParserSession.init__JSON_integer_single_lengths_0();
        private static final byte[] _JSON_integer_range_lengths = ParserSession.init__JSON_integer_range_lengths_0();
        private static final byte[] _JSON_integer_index_offsets = ParserSession.init__JSON_integer_index_offsets_0();
        private static final byte[] _JSON_integer_indicies = ParserSession.init__JSON_integer_indicies_0();
        private static final byte[] _JSON_integer_trans_targs = ParserSession.init__JSON_integer_trans_targs_0();
        private static final byte[] _JSON_integer_trans_actions = ParserSession.init__JSON_integer_trans_actions_0();
        static final int JSON_integer_start = 1;
        static final int JSON_integer_first_final = 3;
        static final int JSON_integer_error = 0;
        static final int JSON_integer_en_main = 1;
        private static final byte[] _JSON_float_actions = ParserSession.init__JSON_float_actions_0();
        private static final byte[] _JSON_float_key_offsets = ParserSession.init__JSON_float_key_offsets_0();
        private static final char[] _JSON_float_trans_keys = ParserSession.init__JSON_float_trans_keys_0();
        private static final byte[] _JSON_float_single_lengths = ParserSession.init__JSON_float_single_lengths_0();
        private static final byte[] _JSON_float_range_lengths = ParserSession.init__JSON_float_range_lengths_0();
        private static final byte[] _JSON_float_index_offsets = ParserSession.init__JSON_float_index_offsets_0();
        private static final byte[] _JSON_float_indicies = ParserSession.init__JSON_float_indicies_0();
        private static final byte[] _JSON_float_trans_targs = ParserSession.init__JSON_float_trans_targs_0();
        private static final byte[] _JSON_float_trans_actions = ParserSession.init__JSON_float_trans_actions_0();
        static final int JSON_float_start = 1;
        static final int JSON_float_first_final = 8;
        static final int JSON_float_error = 0;
        static final int JSON_float_en_main = 1;
        private static final byte[] _JSON_string_actions = ParserSession.init__JSON_string_actions_0();
        private static final byte[] _JSON_string_key_offsets = ParserSession.init__JSON_string_key_offsets_0();
        private static final char[] _JSON_string_trans_keys = ParserSession.init__JSON_string_trans_keys_0();
        private static final byte[] _JSON_string_single_lengths = ParserSession.init__JSON_string_single_lengths_0();
        private static final byte[] _JSON_string_range_lengths = ParserSession.init__JSON_string_range_lengths_0();
        private static final byte[] _JSON_string_index_offsets = ParserSession.init__JSON_string_index_offsets_0();
        private static final byte[] _JSON_string_indicies = ParserSession.init__JSON_string_indicies_0();
        private static final byte[] _JSON_string_trans_targs = ParserSession.init__JSON_string_trans_targs_0();
        private static final byte[] _JSON_string_trans_actions = ParserSession.init__JSON_string_trans_actions_0();
        static final int JSON_string_start = 1;
        static final int JSON_string_first_final = 8;
        static final int JSON_string_error = 0;
        static final int JSON_string_en_main = 1;
        private static final byte[] _JSON_array_actions = ParserSession.init__JSON_array_actions_0();
        private static final byte[] _JSON_array_key_offsets = ParserSession.init__JSON_array_key_offsets_0();
        private static final char[] _JSON_array_trans_keys = ParserSession.init__JSON_array_trans_keys_0();
        private static final byte[] _JSON_array_single_lengths = ParserSession.init__JSON_array_single_lengths_0();
        private static final byte[] _JSON_array_range_lengths = ParserSession.init__JSON_array_range_lengths_0();
        private static final byte[] _JSON_array_index_offsets = ParserSession.init__JSON_array_index_offsets_0();
        private static final byte[] _JSON_array_indicies = ParserSession.init__JSON_array_indicies_0();
        private static final byte[] _JSON_array_trans_targs = ParserSession.init__JSON_array_trans_targs_0();
        private static final byte[] _JSON_array_trans_actions = ParserSession.init__JSON_array_trans_actions_0();
        static final int JSON_array_start = 1;
        static final int JSON_array_first_final = 17;
        static final int JSON_array_error = 0;
        static final int JSON_array_en_main = 1;
        private static final byte[] _JSON_object_actions = ParserSession.init__JSON_object_actions_0();
        private static final byte[] _JSON_object_key_offsets = ParserSession.init__JSON_object_key_offsets_0();
        private static final char[] _JSON_object_trans_keys = ParserSession.init__JSON_object_trans_keys_0();
        private static final byte[] _JSON_object_single_lengths = ParserSession.init__JSON_object_single_lengths_0();
        private static final byte[] _JSON_object_range_lengths = ParserSession.init__JSON_object_range_lengths_0();
        private static final byte[] _JSON_object_index_offsets = ParserSession.init__JSON_object_index_offsets_0();
        private static final byte[] _JSON_object_indicies = ParserSession.init__JSON_object_indicies_0();
        private static final byte[] _JSON_object_trans_targs = ParserSession.init__JSON_object_trans_targs_0();
        private static final byte[] _JSON_object_trans_actions = ParserSession.init__JSON_object_trans_actions_0();
        static final int JSON_object_start = 1;
        static final int JSON_object_first_final = 27;
        static final int JSON_object_error = 0;
        static final int JSON_object_en_main = 1;
        private static final byte[] _JSON_actions = ParserSession.init__JSON_actions_0();
        private static final byte[] _JSON_key_offsets = ParserSession.init__JSON_key_offsets_0();
        private static final char[] _JSON_trans_keys = ParserSession.init__JSON_trans_keys_0();
        private static final byte[] _JSON_single_lengths = ParserSession.init__JSON_single_lengths_0();
        private static final byte[] _JSON_range_lengths = ParserSession.init__JSON_range_lengths_0();
        private static final byte[] _JSON_index_offsets = ParserSession.init__JSON_index_offsets_0();
        private static final byte[] _JSON_indicies = ParserSession.init__JSON_indicies_0();
        private static final byte[] _JSON_trans_targs = ParserSession.init__JSON_trans_targs_0();
        private static final byte[] _JSON_trans_actions = ParserSession.init__JSON_trans_actions_0();
        static final int JSON_start = 1;
        static final int JSON_first_final = 10;
        static final int JSON_error = 0;
        static final int JSON_en_main = 1;
        private static final byte[] _JSON_quirks_mode_actions = ParserSession.init__JSON_quirks_mode_actions_0();
        private static final byte[] _JSON_quirks_mode_key_offsets = ParserSession.init__JSON_quirks_mode_key_offsets_0();
        private static final char[] _JSON_quirks_mode_trans_keys = ParserSession.init__JSON_quirks_mode_trans_keys_0();
        private static final byte[] _JSON_quirks_mode_single_lengths = ParserSession.init__JSON_quirks_mode_single_lengths_0();
        private static final byte[] _JSON_quirks_mode_range_lengths = ParserSession.init__JSON_quirks_mode_range_lengths_0();
        private static final byte[] _JSON_quirks_mode_index_offsets = ParserSession.init__JSON_quirks_mode_index_offsets_0();
        private static final byte[] _JSON_quirks_mode_indicies = ParserSession.init__JSON_quirks_mode_indicies_0();
        private static final byte[] _JSON_quirks_mode_trans_targs = ParserSession.init__JSON_quirks_mode_trans_targs_0();
        private static final byte[] _JSON_quirks_mode_trans_actions = ParserSession.init__JSON_quirks_mode_trans_actions_0();
        static final int JSON_quirks_mode_start = 1;
        static final int JSON_quirks_mode_first_final = 10;
        static final int JSON_quirks_mode_error = 0;
        static final int JSON_quirks_mode_en_main = 1;

        private ParserSession(Parser parser, ThreadContext threadContext) {
            this.parser = parser;
            this.context = threadContext;
            this.byteList = parser.checkAndGetSource().getByteList();
            this.data = this.byteList.unsafeBytes();
            this.view = new ByteList(this.data, false);
            this.decoder = new StringDecoder(threadContext);
            this.dc = new ConvertDouble.DoubleConverter();
        }

        private RaiseException unexpectedToken(int n, int n2) {
            RubyString rubyString = this.getRuntime().newString("unexpected token at '").cat(this.data, n, n2 - n).cat((byte)39);
            return this.newException("ParserError", rubyString);
        }

        private Ruby getRuntime() {
            return this.context.getRuntime();
        }

        private static byte[] init__JSON_value_actions_0() {
            return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9};
        }

        private static byte[] init__JSON_value_key_offsets_0() {
            return new byte[]{0, 0, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
        }

        private static char[] init__JSON_value_trans_keys_0() {
            return new char[]{'\"', '-', 'I', 'N', '[', 'f', 'n', 't', '{', '0', '9', 'n', 'f', 'i', 'n', 'i', 't', 'y', 'a', 'N', 'a', 'l', 's', 'e', 'u', 'l', 'l', 'r', 'u', 'e', '\u0000'};
        }

        private static byte[] init__JSON_value_single_lengths_0() {
            return new byte[]{0, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0};
        }

        private static byte[] init__JSON_value_range_lengths_0() {
            return new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        private static byte[] init__JSON_value_index_offsets_0() {
            return new byte[]{0, 0, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49};
        }

        private static byte[] init__JSON_value_trans_targs_0() {
            return new byte[]{21, 21, 2, 9, 21, 11, 15, 18, 21, 21, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 21, 0, 10, 0, 21, 0, 12, 0, 13, 0, 14, 0, 21, 0, 16, 0, 17, 0, 21, 0, 19, 0, 20, 0, 21, 0, 0, 0};
        }

        private static byte[] init__JSON_value_trans_actions_0() {
            return new byte[]{13, 11, 0, 0, 15, 0, 0, 0, 17, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 5, 0, 0, 0};
        }

        private static byte[] init__JSON_value_from_state_actions_0() {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19};
        }

        /*
         * Unable to fully structure code
         */
        void parseValue(ParserResult var1_1, int var2_2, int var3_3) {
            var4_4 = 1638;
            var5_5 = null;
            var4_4 = 1;
            var7_6 = 0;
            var11_7 = 0;
            block19: while (true) {
                switch (var11_7) {
                    case 0: {
                        if (var2_2 == var3_3) {
                            var11_7 = 4;
                            continue block19;
                        }
                        if (var4_4 == 0) {
                            var11_7 = 5;
                            continue block19;
                        }
                    }
                    case 1: {
                        var8_9 = ParserSession._JSON_value_from_state_actions[var4_4];
                        var9_10 = ParserSession._JSON_value_actions[var8_9++];
                        while (var9_10-- > 0) {
                            switch (ParserSession._JSON_value_actions[var8_9++]) {
                                case 9: {
                                    --var2_2;
                                    ++var2_2;
                                    var11_7 = 5;
                                    continue block19;
                                }
                            }
                        }
                        var10_11 = ParserSession._JSON_value_key_offsets[var4_4];
                        var7_6 = ParserSession._JSON_value_index_offsets[var4_4];
                        var6_8 = ParserSession._JSON_value_single_lengths[var4_4];
                        if (var6_8 <= 0) ** GOTO lbl44
                        var12_12 = var10_11;
                        var14_14 = var10_11 + var6_8 - 1;
                        while (var14_14 >= var12_12) {
                            var13_13 = var12_12 + (var14_14 - var12_12 >> 1);
                            if (this.data[var2_2] < ParserSession._JSON_value_trans_keys[var13_13]) {
                                var14_14 = var13_13 - 1;
                                continue;
                            }
                            if (this.data[var2_2] > ParserSession._JSON_value_trans_keys[var13_13]) {
                                var12_12 = var13_13 + 1;
                                continue;
                            }
                            var7_6 += var13_13 - var10_11;
                            ** GOTO lbl58
                        }
                        var10_11 += var6_8;
                        var7_6 += var6_8;
lbl44:
                        // 2 sources

                        if ((var6_8 = ParserSession._JSON_value_range_lengths[var4_4]) > 0) {
                            var12_12 = var10_11;
                            var14_14 = var10_11 + (var6_8 << 1) - 2;
                            while (var14_14 >= var12_12) {
                                var13_13 = var12_12 + (var14_14 - var12_12 >> 1 & -2);
                                if (this.data[var2_2] < ParserSession._JSON_value_trans_keys[var13_13]) {
                                    var14_14 = var13_13 - 2;
                                    continue;
                                }
                                if (this.data[var2_2] > ParserSession._JSON_value_trans_keys[var13_13 + 1]) {
                                    var12_12 = var13_13 + 2;
                                    continue;
                                }
                                var7_6 += var13_13 - var10_11 >> 1;
                                ** GOTO lbl58
                            }
                            var7_6 += var6_8;
                        }
lbl58:
                        // 5 sources

                        var4_4 = ParserSession._JSON_value_trans_targs[var7_6];
                        if (ParserSession._JSON_value_trans_actions[var7_6] != 0) {
                            var8_9 = ParserSession._JSON_value_trans_actions[var7_6];
                            var9_10 = ParserSession._JSON_value_actions[var8_9++];
                            while (var9_10-- > 0) {
                                switch (ParserSession._JSON_value_actions[var8_9++]) {
                                    case 0: {
                                        var5_5 = this.getRuntime().getNil();
                                        break;
                                    }
                                    case 1: {
                                        var5_5 = this.getRuntime().getFalse();
                                        break;
                                    }
                                    case 2: {
                                        var5_5 = this.getRuntime().getTrue();
                                        break;
                                    }
                                    case 3: {
                                        if (Parser.access$100(this.parser)) {
                                            var5_5 = this.getConstant("NaN");
                                            break;
                                        }
                                        throw this.unexpectedToken(var2_2 - 2, var3_3);
                                    }
                                    case 4: {
                                        if (Parser.access$100(this.parser)) {
                                            var5_5 = this.getConstant("Infinity");
                                            break;
                                        }
                                        throw this.unexpectedToken(var2_2 - 7, var3_3);
                                    }
                                    case 5: {
                                        if (var3_3 > var2_2 + 9 - (Parser.access$200(this.parser) != false ? 1 : 0) && this.absSubSequence(var2_2, var2_2 + 9).equals((Object)Parser.access$300())) {
                                            if (Parser.access$100(this.parser)) {
                                                var5_5 = this.getConstant("MinusInfinity");
                                                var2_2 = var2_2 + 10 - 1;
                                                --var2_2;
                                                ++var2_2;
                                                var11_7 = 5;
                                                continue block19;
                                            }
                                            throw this.unexpectedToken(var2_2, var3_3);
                                        }
                                        this.parseFloat(var1_1, var2_2, var3_3);
                                        if (var1_1.result != null) {
                                            var5_5 = var1_1.result;
                                            var2_2 = var1_1.p - 1;
                                        }
                                        this.parseInteger(var1_1, var2_2, var3_3);
                                        if (var1_1.result != null) {
                                            var5_5 = var1_1.result;
                                            var2_2 = var1_1.p - 1;
                                        }
                                        --var2_2;
                                        ++var2_2;
                                        var11_7 = 5;
                                        continue block19;
                                    }
                                    case 6: {
                                        this.parseString(var1_1, var2_2, var3_3);
                                        if (var1_1.result == null) {
                                            --var2_2;
                                            ++var2_2;
                                            var11_7 = 5;
                                            continue block19;
                                        }
                                        var5_5 = var1_1.result;
                                        var2_2 = var1_1.p - 1;
                                        break;
                                    }
                                    case 7: {
                                        ++this.currentNesting;
                                        this.parseArray(var1_1, var2_2, var3_3);
                                        --this.currentNesting;
                                        if (var1_1.result == null) {
                                            --var2_2;
                                            ++var2_2;
                                            var11_7 = 5;
                                            continue block19;
                                        }
                                        var5_5 = var1_1.result;
                                        var2_2 = var1_1.p - 1;
                                        break;
                                    }
                                    case 8: {
                                        ++this.currentNesting;
                                        this.parseObject(var1_1, var2_2, var3_3);
                                        --this.currentNesting;
                                        if (var1_1.result == null) {
                                            --var2_2;
                                            ++var2_2;
                                            var11_7 = 5;
                                            continue block19;
                                        }
                                        var5_5 = var1_1.result;
                                        var2_2 = var1_1.p - 1;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var4_4 == 0) {
                            var11_7 = 5;
                            continue block19;
                        }
                        if (++var2_2 == var3_3) break block19;
                        var11_7 = 1;
                        continue block19;
                    }
                }
                break;
            }
            if (var4_4 >= 21 && var5_5 != null) {
                var1_1.update(var5_5, var2_2);
            } else {
                var1_1.update(null, var2_2);
            }
        }

        private static byte[] init__JSON_integer_actions_0() {
            return new byte[]{0, 1, 0};
        }

        private static byte[] init__JSON_integer_key_offsets_0() {
            return new byte[]{0, 0, 4, 7, 9, 9};
        }

        private static char[] init__JSON_integer_trans_keys_0() {
            return new char[]{'-', '0', '1', '9', '0', '1', '9', '0', '9', '0', '9', '\u0000'};
        }

        private static byte[] init__JSON_integer_single_lengths_0() {
            return new byte[]{0, 2, 1, 0, 0, 0};
        }

        private static byte[] init__JSON_integer_range_lengths_0() {
            return new byte[]{0, 1, 1, 1, 0, 1};
        }

        private static byte[] init__JSON_integer_index_offsets_0() {
            return new byte[]{0, 0, 4, 7, 9, 10};
        }

        private static byte[] init__JSON_integer_indicies_0() {
            return new byte[]{0, 2, 3, 1, 2, 3, 1, 1, 4, 1, 3, 4, 0};
        }

        private static byte[] init__JSON_integer_trans_targs_0() {
            return new byte[]{2, 0, 3, 5, 4};
        }

        private static byte[] init__JSON_integer_trans_actions_0() {
            return new byte[]{0, 0, 0, 0, 1};
        }

        void parseInteger(ParserResult parserResult, int n, int n2) {
            int n3 = this.parseIntegerInternal(n, n2);
            if (n3 == -1) {
                parserResult.update(null, n);
                return;
            }
            RubyInteger rubyInteger = this.createInteger(n, n3);
            parserResult.update((IRubyObject)rubyInteger, n3 + 1);
        }

        /*
         * Unable to fully structure code
         */
        int parseIntegerInternal(int var1_1, int var2_2) {
            var3_3 = 1638;
            var3_3 = 1;
            var4_4 = var1_1;
            var6_5 = 0;
            var10_6 = 0;
            block8: while (true) {
                switch (var10_6) {
                    case 0: {
                        if (var1_1 == var2_2) {
                            var10_6 = 4;
                            continue block8;
                        }
                        if (var3_3 == 0) {
                            var10_6 = 5;
                            continue block8;
                        }
                    }
                    case 1: {
                        var9_10 = ParserSession._JSON_integer_key_offsets[var3_3];
                        var6_5 = ParserSession._JSON_integer_index_offsets[var3_3];
                        var5_7 = ParserSession._JSON_integer_single_lengths[var3_3];
                        if (var5_7 <= 0) ** GOTO lbl34
                        var11_11 = var9_10;
                        var13_13 = var9_10 + var5_7 - 1;
                        while (var13_13 >= var11_11) {
                            var12_12 = var11_11 + (var13_13 - var11_11 >> 1);
                            if (this.data[var1_1] < ParserSession._JSON_integer_trans_keys[var12_12]) {
                                var13_13 = var12_12 - 1;
                                continue;
                            }
                            if (this.data[var1_1] > ParserSession._JSON_integer_trans_keys[var12_12]) {
                                var11_11 = var12_12 + 1;
                                continue;
                            }
                            var6_5 += var12_12 - var9_10;
                            ** GOTO lbl48
                        }
                        var9_10 += var5_7;
                        var6_5 += var5_7;
lbl34:
                        // 2 sources

                        if ((var5_7 = ParserSession._JSON_integer_range_lengths[var3_3]) > 0) {
                            var11_11 = var9_10;
                            var13_13 = var9_10 + (var5_7 << 1) - 2;
                            while (var13_13 >= var11_11) {
                                var12_12 = var11_11 + (var13_13 - var11_11 >> 1 & -2);
                                if (this.data[var1_1] < ParserSession._JSON_integer_trans_keys[var12_12]) {
                                    var13_13 = var12_12 - 2;
                                    continue;
                                }
                                if (this.data[var1_1] > ParserSession._JSON_integer_trans_keys[var12_12 + 1]) {
                                    var11_11 = var12_12 + 2;
                                    continue;
                                }
                                var6_5 += var12_12 - var9_10 >> 1;
                                ** GOTO lbl48
                            }
                            var6_5 += var5_7;
                        }
lbl48:
                        // 5 sources

                        var6_5 = ParserSession._JSON_integer_indicies[var6_5];
                        var3_3 = ParserSession._JSON_integer_trans_targs[var6_5];
                        if (ParserSession._JSON_integer_trans_actions[var6_5] != 0) {
                            var7_8 = ParserSession._JSON_integer_trans_actions[var6_5];
                            var8_9 = ParserSession._JSON_integer_actions[var7_8++];
                            while (var8_9-- > 0) {
                                switch (ParserSession._JSON_integer_actions[var7_8++]) {
                                    case 0: {
                                        --var1_1;
                                        ++var1_1;
                                        var10_6 = 5;
                                        continue block8;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var3_3 == 0) {
                            var10_6 = 5;
                            continue block8;
                        }
                        if (++var1_1 == var2_2) break block8;
                        var10_6 = 1;
                        continue block8;
                    }
                }
                break;
            }
            if (var3_3 < 3) {
                return -1;
            }
            return var1_1;
        }

        RubyInteger createInteger(int n, int n2) {
            Ruby ruby = this.getRuntime();
            ByteList byteList = this.absSubSequence(n, n2);
            return this.bytesToInum(ruby, byteList);
        }

        RubyInteger bytesToInum(Ruby ruby, ByteList byteList) {
            return ruby.is1_9() ? ConvertBytes.byteListToInum19((Ruby)ruby, (ByteList)byteList, (int)10, (boolean)true) : ConvertBytes.byteListToInum((Ruby)ruby, (ByteList)byteList, (int)10, (boolean)true);
        }

        private static byte[] init__JSON_float_actions_0() {
            return new byte[]{0, 1, 0};
        }

        private static byte[] init__JSON_float_key_offsets_0() {
            return new byte[]{0, 0, 4, 7, 10, 12, 16, 18, 23, 29, 29};
        }

        private static char[] init__JSON_float_trans_keys_0() {
            return new char[]{'-', '0', '1', '9', '0', '1', '9', '.', 'E', 'e', '0', '9', '+', '-', '0', '9', '0', '9', '.', 'E', 'e', '0', '9', 'E', 'e', '-', '.', '0', '9', 'E', 'e', '-', '.', '0', '9', '\u0000'};
        }

        private static byte[] init__JSON_float_single_lengths_0() {
            return new byte[]{0, 2, 1, 3, 0, 2, 0, 3, 2, 0, 2};
        }

        private static byte[] init__JSON_float_range_lengths_0() {
            return new byte[]{0, 1, 1, 0, 1, 1, 1, 1, 2, 0, 2};
        }

        private static byte[] init__JSON_float_index_offsets_0() {
            return new byte[]{0, 0, 4, 7, 11, 13, 17, 19, 24, 29, 30};
        }

        private static byte[] init__JSON_float_indicies_0() {
            return new byte[]{0, 2, 3, 1, 2, 3, 1, 4, 5, 5, 1, 6, 1, 7, 7, 8, 1, 8, 1, 4, 5, 5, 3, 1, 5, 5, 1, 6, 9, 1, 1, 1, 1, 8, 9, 0};
        }

        private static byte[] init__JSON_float_trans_targs_0() {
            return new byte[]{2, 0, 3, 7, 4, 5, 8, 6, 10, 9};
        }

        private static byte[] init__JSON_float_trans_actions_0() {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }

        void parseFloat(ParserResult parserResult, int n, int n2) {
            int n3 = this.parseFloatInternal(n, n2);
            if (n3 == -1) {
                parserResult.update(null, n);
                return;
            }
            RubyFloat rubyFloat = this.createFloat(n, n3);
            parserResult.update((IRubyObject)rubyFloat, n3 + 1);
        }

        /*
         * Unable to fully structure code
         */
        int parseFloatInternal(int var1_1, int var2_2) {
            var3_3 = 1638;
            var3_3 = 1;
            var4_4 = var1_1;
            var6_5 = 0;
            var10_6 = 0;
            block8: while (true) {
                switch (var10_6) {
                    case 0: {
                        if (var1_1 == var2_2) {
                            var10_6 = 4;
                            continue block8;
                        }
                        if (var3_3 == 0) {
                            var10_6 = 5;
                            continue block8;
                        }
                    }
                    case 1: {
                        var9_10 = ParserSession._JSON_float_key_offsets[var3_3];
                        var6_5 = ParserSession._JSON_float_index_offsets[var3_3];
                        var5_7 = ParserSession._JSON_float_single_lengths[var3_3];
                        if (var5_7 <= 0) ** GOTO lbl34
                        var11_11 = var9_10;
                        var13_13 = var9_10 + var5_7 - 1;
                        while (var13_13 >= var11_11) {
                            var12_12 = var11_11 + (var13_13 - var11_11 >> 1);
                            if (this.data[var1_1] < ParserSession._JSON_float_trans_keys[var12_12]) {
                                var13_13 = var12_12 - 1;
                                continue;
                            }
                            if (this.data[var1_1] > ParserSession._JSON_float_trans_keys[var12_12]) {
                                var11_11 = var12_12 + 1;
                                continue;
                            }
                            var6_5 += var12_12 - var9_10;
                            ** GOTO lbl48
                        }
                        var9_10 += var5_7;
                        var6_5 += var5_7;
lbl34:
                        // 2 sources

                        if ((var5_7 = ParserSession._JSON_float_range_lengths[var3_3]) > 0) {
                            var11_11 = var9_10;
                            var13_13 = var9_10 + (var5_7 << 1) - 2;
                            while (var13_13 >= var11_11) {
                                var12_12 = var11_11 + (var13_13 - var11_11 >> 1 & -2);
                                if (this.data[var1_1] < ParserSession._JSON_float_trans_keys[var12_12]) {
                                    var13_13 = var12_12 - 2;
                                    continue;
                                }
                                if (this.data[var1_1] > ParserSession._JSON_float_trans_keys[var12_12 + 1]) {
                                    var11_11 = var12_12 + 2;
                                    continue;
                                }
                                var6_5 += var12_12 - var9_10 >> 1;
                                ** GOTO lbl48
                            }
                            var6_5 += var5_7;
                        }
lbl48:
                        // 5 sources

                        var6_5 = ParserSession._JSON_float_indicies[var6_5];
                        var3_3 = ParserSession._JSON_float_trans_targs[var6_5];
                        if (ParserSession._JSON_float_trans_actions[var6_5] != 0) {
                            var7_8 = ParserSession._JSON_float_trans_actions[var6_5];
                            var8_9 = ParserSession._JSON_float_actions[var7_8++];
                            while (var8_9-- > 0) {
                                switch (ParserSession._JSON_float_actions[var7_8++]) {
                                    case 0: {
                                        --var1_1;
                                        ++var1_1;
                                        var10_6 = 5;
                                        continue block8;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var3_3 == 0) {
                            var10_6 = 5;
                            continue block8;
                        }
                        if (++var1_1 == var2_2) break block8;
                        var10_6 = 1;
                        continue block8;
                    }
                }
                break;
            }
            if (var3_3 < 8) {
                return -1;
            }
            return var1_1;
        }

        RubyFloat createFloat(int n, int n2) {
            Ruby ruby = this.getRuntime();
            ByteList byteList = this.absSubSequence(n, n2);
            return RubyFloat.newFloat((Ruby)ruby, (double)this.dc.parse(byteList, true, ruby.is1_9()));
        }

        private static byte[] init__JSON_string_actions_0() {
            return new byte[]{0, 2, 0, 1};
        }

        private static byte[] init__JSON_string_key_offsets_0() {
            return new byte[]{0, 0, 1, 5, 8, 14, 20, 26, 32};
        }

        private static char[] init__JSON_string_trans_keys_0() {
            return new char[]{'\"', '\"', '\\', '\u0000', '\u001f', 'u', '\u0000', '\u001f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', '\u0000'};
        }

        private static byte[] init__JSON_string_single_lengths_0() {
            return new byte[]{0, 1, 2, 1, 0, 0, 0, 0, 0};
        }

        private static byte[] init__JSON_string_range_lengths_0() {
            return new byte[]{0, 0, 1, 1, 3, 3, 3, 3, 0};
        }

        private static byte[] init__JSON_string_index_offsets_0() {
            return new byte[]{0, 0, 2, 6, 9, 13, 17, 21, 25};
        }

        private static byte[] init__JSON_string_indicies_0() {
            return new byte[]{0, 1, 2, 3, 1, 0, 4, 1, 0, 5, 5, 5, 1, 6, 6, 6, 1, 7, 7, 7, 1, 0, 0, 0, 1, 1, 0};
        }

        private static byte[] init__JSON_string_trans_targs_0() {
            return new byte[]{2, 0, 8, 3, 4, 5, 6, 7};
        }

        private static byte[] init__JSON_string_trans_actions_0() {
            return new byte[]{0, 0, 1, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         */
        void parseString(ParserResult var1_1, int var2_2, int var3_3) {
            var4_4 = 1638;
            var5_5 = null;
            var4_4 = 1;
            var6_6 = var2_2;
            var8_7 = 0;
            var12_9 = 0;
            block11: while (true) {
                switch (var12_9) {
                    case 0: {
                        if (var2_2 == var3_3) {
                            var12_9 = 4;
                            continue block11;
                        }
                        if (var4_4 == 0) {
                            var12_9 = 5;
                            continue block11;
                        }
                    }
                    case 1: {
                        var11_19 = ParserSession._JSON_string_key_offsets[var4_4];
                        var8_7 = ParserSession._JSON_string_index_offsets[var4_4];
                        var7_10 = ParserSession._JSON_string_single_lengths[var4_4];
                        if (var7_10 <= 0) ** GOTO lbl35
                        var13_20 = var11_19;
                        var15_23 = var11_19 + var7_10 - 1;
                        while (var15_23 >= var13_20) {
                            var14_21 = var13_20 + (var15_23 - var13_20 >> 1);
                            if (this.data[var2_2] < ParserSession._JSON_string_trans_keys[var14_21]) {
                                var15_23 = var14_21 - 1;
                                continue;
                            }
                            if (this.data[var2_2] > ParserSession._JSON_string_trans_keys[var14_21]) {
                                var13_20 = var14_21 + 1;
                                continue;
                            }
                            var8_7 += var14_21 - var11_19;
                            ** GOTO lbl49
                        }
                        var11_19 += var7_10;
                        var8_7 += var7_10;
lbl35:
                        // 2 sources

                        if ((var7_10 = ParserSession._JSON_string_range_lengths[var4_4]) > 0) {
                            var13_20 = var11_19;
                            var15_23 = var11_19 + (var7_10 << 1) - 2;
                            while (var15_23 >= var13_20) {
                                var14_21 = var13_20 + (var15_23 - var13_20 >> 1 & -2);
                                if (this.data[var2_2] < ParserSession._JSON_string_trans_keys[var14_21]) {
                                    var15_23 = var14_21 - 2;
                                    continue;
                                }
                                if (this.data[var2_2] > ParserSession._JSON_string_trans_keys[var14_21 + 1]) {
                                    var13_20 = var14_21 + 2;
                                    continue;
                                }
                                var8_7 += var14_21 - var11_19 >> 1;
                                ** GOTO lbl49
                            }
                            var8_7 += var7_10;
                        }
lbl49:
                        // 5 sources

                        var8_7 = ParserSession._JSON_string_indicies[var8_7];
                        var4_4 = ParserSession._JSON_string_trans_targs[var8_7];
                        if (ParserSession._JSON_string_trans_actions[var8_7] != 0) {
                            var9_14 = ParserSession._JSON_string_trans_actions[var8_7];
                            var10_18 = ParserSession._JSON_string_actions[var9_14++];
                            while (var10_18-- > 0) {
                                switch (ParserSession._JSON_string_actions[var9_14++]) {
                                    case 0: {
                                        var13_20 = this.byteList.begin();
                                        var14_22 = this.decoder.decode(this.byteList, var6_6 + 1 - var13_20, var2_2 - var13_20);
                                        var5_5 = this.getRuntime().newString(var14_22);
                                        if (var5_5 == null) {
                                            --var2_2;
                                            ++var2_2;
                                            var12_9 = 5;
                                            continue block11;
                                        }
                                        var2_2 = var2_2 + 1 - 1;
                                        break;
                                    }
                                    case 1: {
                                        --var2_2;
                                        ++var2_2;
                                        var12_9 = 5;
                                        continue block11;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var4_4 == 0) {
                            var12_9 = 5;
                            continue block11;
                        }
                        if (++var2_2 == var3_3) break block11;
                        var12_9 = 1;
                        continue block11;
                    }
                }
                break;
            }
            if (Parser.access$400(this.parser) && (var7_11 = Parser.access$500(this.parser)) != null) {
                var8_8 = new IRubyObject[]{var5_5, null};
                try {
                    var7_11.visitAll(new RubyHash.Visitor(){

                        public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                            if (iRubyObject.callMethod(ParserSession.this.context, "===", var8_8[0]).isTrue()) {
                                var8_8[1] = iRubyObject2;
                                throw JumpException.SPECIAL_JUMP;
                            }
                        }
                    });
                }
                catch (JumpException var9_15) {
                    // empty catch block
                }
                if (var8_8[1] != null && (var9_17 = (RubyClass)var8_8[1]).respondsTo("json_creatable?") && var9_17.callMethod(this.context, "json_creatable?").isTrue()) {
                    var5_5 = var9_17.callMethod(this.context, "json_create", var5_5);
                }
            }
            if (var4_4 >= 8 && var5_5 != null) {
                var7_13 = RuntimeInfo.forRuntime(this.context.getRuntime());
                if (var7_13.encodingsSupported() && var5_5 instanceof RubyString) {
                    ((RubyString)var5_5).force_encoding(this.context, (IRubyObject)var7_13.utf8.get());
                }
                var1_1.update(var5_5, var2_2 + 1);
            } else {
                var1_1.update(null, var2_2 + 1);
            }
        }

        private static byte[] init__JSON_array_actions_0() {
            return new byte[]{0, 1, 0, 1, 1};
        }

        private static byte[] init__JSON_array_key_offsets_0() {
            return new byte[]{0, 0, 1, 18, 25, 41, 43, 44, 46, 47, 49, 50, 52, 53, 55, 56, 58, 59};
        }

        private static char[] init__JSON_array_trans_keys_0() {
            return new char[]{'[', '\r', ' ', '\"', '-', '/', 'I', 'N', '[', ']', 'f', 'n', 't', '{', '\t', '\n', '0', '9', '\r', ' ', ',', '/', ']', '\t', '\n', '\r', ' ', '\"', '-', '/', 'I', 'N', '[', 'f', 'n', 't', '{', '\t', '\n', '0', '9', '*', '/', '*', '*', '/', '\n', '*', '/', '*', '*', '/', '\n', '*', '/', '*', '*', '/', '\n', '\u0000'};
        }

        private static byte[] init__JSON_array_single_lengths_0() {
            return new byte[]{0, 1, 13, 5, 12, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0};
        }

        private static byte[] init__JSON_array_range_lengths_0() {
            return new byte[]{0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        private static byte[] init__JSON_array_index_offsets_0() {
            return new byte[]{0, 0, 2, 18, 25, 40, 43, 45, 48, 50, 53, 55, 58, 60, 63, 65, 68, 70};
        }

        private static byte[] init__JSON_array_indicies_0() {
            return new byte[]{0, 1, 0, 0, 2, 2, 3, 2, 2, 2, 4, 2, 2, 2, 2, 0, 2, 1, 5, 5, 6, 7, 4, 5, 1, 6, 6, 2, 2, 8, 2, 2, 2, 2, 2, 2, 2, 6, 2, 1, 9, 10, 1, 11, 9, 11, 6, 9, 6, 10, 12, 13, 1, 14, 12, 14, 5, 12, 5, 13, 15, 16, 1, 17, 15, 17, 0, 15, 0, 16, 1, 0};
        }

        private static byte[] init__JSON_array_trans_targs_0() {
            return new byte[]{2, 0, 3, 13, 17, 3, 4, 9, 5, 6, 8, 7, 10, 12, 11, 14, 16, 15};
        }

        private static byte[] init__JSON_array_trans_actions_0() {
            return new byte[]{0, 0, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        void parseArray(ParserResult var1_1, int var2_2, int var3_3) {
            var4_4 = 1638;
            if (Parser.access$700(this.parser) > 0 && this.currentNesting > Parser.access$700(this.parser)) {
                throw this.newException("NestingError", "nesting of " + this.currentNesting + " is too deep");
            }
            var5_5 /* !! */  = Parser.access$800(this.parser) == this.getRuntime().getArray() ? RubyArray.newArray((Ruby)this.getRuntime()) : Parser.access$800(this.parser).newInstance(this.context, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
            var4_4 = 1;
            var7_6 = 0;
            var11_7 = 0;
            block9: while (true) {
                switch (var11_7) {
                    case 0: {
                        if (var2_2 == var3_3) {
                            var11_7 = 4;
                            continue block9;
                        }
                        if (var4_4 == 0) {
                            var11_7 = 5;
                            continue block9;
                        }
                    }
                    case 1: {
                        var10_11 = ParserSession._JSON_array_key_offsets[var4_4];
                        var7_6 = ParserSession._JSON_array_index_offsets[var4_4];
                        var6_8 = ParserSession._JSON_array_single_lengths[var4_4];
                        if (var6_8 <= 0) ** GOTO lbl36
                        var12_12 = var10_11;
                        var14_14 = var10_11 + var6_8 - 1;
                        while (var14_14 >= var12_12) {
                            var13_13 = var12_12 + (var14_14 - var12_12 >> 1);
                            if (this.data[var2_2] < ParserSession._JSON_array_trans_keys[var13_13]) {
                                var14_14 = var13_13 - 1;
                                continue;
                            }
                            if (this.data[var2_2] > ParserSession._JSON_array_trans_keys[var13_13]) {
                                var12_12 = var13_13 + 1;
                                continue;
                            }
                            var7_6 += var13_13 - var10_11;
                            ** GOTO lbl50
                        }
                        var10_11 += var6_8;
                        var7_6 += var6_8;
lbl36:
                        // 2 sources

                        if ((var6_8 = ParserSession._JSON_array_range_lengths[var4_4]) > 0) {
                            var12_12 = var10_11;
                            var14_14 = var10_11 + (var6_8 << 1) - 2;
                            while (var14_14 >= var12_12) {
                                var13_13 = var12_12 + (var14_14 - var12_12 >> 1 & -2);
                                if (this.data[var2_2] < ParserSession._JSON_array_trans_keys[var13_13]) {
                                    var14_14 = var13_13 - 2;
                                    continue;
                                }
                                if (this.data[var2_2] > ParserSession._JSON_array_trans_keys[var13_13 + 1]) {
                                    var12_12 = var13_13 + 2;
                                    continue;
                                }
                                var7_6 += var13_13 - var10_11 >> 1;
                                ** GOTO lbl50
                            }
                            var7_6 += var6_8;
                        }
lbl50:
                        // 5 sources

                        var7_6 = ParserSession._JSON_array_indicies[var7_6];
                        var4_4 = ParserSession._JSON_array_trans_targs[var7_6];
                        if (ParserSession._JSON_array_trans_actions[var7_6] != 0) {
                            var8_9 = ParserSession._JSON_array_trans_actions[var7_6];
                            var9_10 = ParserSession._JSON_array_actions[var8_9++];
                            while (var9_10-- > 0) {
                                switch (ParserSession._JSON_array_actions[var8_9++]) {
                                    case 0: {
                                        this.parseValue(var1_1, var2_2, var3_3);
                                        if (var1_1.result == null) {
                                            --var2_2;
                                            ++var2_2;
                                            var11_7 = 5;
                                            continue block9;
                                        }
                                        if (Parser.access$800(this.parser) == this.getRuntime().getArray()) {
                                            var5_5 /* !! */ .append(var1_1.result);
                                        } else {
                                            var5_5 /* !! */ .callMethod(this.context, "<<", var1_1.result);
                                        }
                                        var2_2 = var1_1.p - 1;
                                        break;
                                    }
                                    case 1: {
                                        --var2_2;
                                        ++var2_2;
                                        var11_7 = 5;
                                        continue block9;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var4_4 == 0) {
                            var11_7 = 5;
                            continue block9;
                        }
                        if (++var2_2 == var3_3) break block9;
                        var11_7 = 1;
                        continue block9;
                    }
                }
                break;
            }
            if (var4_4 < 17) {
                throw this.unexpectedToken(var2_2, var3_3);
            }
            var1_1.update((IRubyObject)var5_5 /* !! */ , var2_2 + 1);
        }

        private static byte[] init__JSON_object_actions_0() {
            return new byte[]{0, 1, 0, 1, 1, 1, 2};
        }

        private static byte[] init__JSON_object_key_offsets_0() {
            return new byte[]{0, 0, 1, 8, 14, 16, 17, 19, 20, 36, 43, 49, 51, 52, 54, 55, 57, 58, 60, 61, 63, 64, 66, 67, 69, 70, 72, 73};
        }

        private static char[] init__JSON_object_trans_keys_0() {
            return new char[]{'{', '\r', ' ', '\"', '/', '}', '\t', '\n', '\r', ' ', '/', ':', '\t', '\n', '*', '/', '*', '*', '/', '\n', '\r', ' ', '\"', '-', '/', 'I', 'N', '[', 'f', 'n', 't', '{', '\t', '\n', '0', '9', '\r', ' ', ',', '/', '}', '\t', '\n', '\r', ' ', '\"', '/', '\t', '\n', '*', '/', '*', '*', '/', '\n', '*', '/', '*', '*', '/', '\n', '*', '/', '*', '*', '/', '\n', '*', '/', '*', '*', '/', '\n', '\u0000'};
        }

        private static byte[] init__JSON_object_single_lengths_0() {
            return new byte[]{0, 1, 5, 4, 2, 1, 2, 1, 12, 5, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0};
        }

        private static byte[] init__JSON_object_range_lengths_0() {
            return new byte[]{0, 0, 1, 1, 0, 0, 0, 0, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        private static byte[] init__JSON_object_index_offsets_0() {
            return new byte[]{0, 0, 2, 9, 15, 18, 20, 23, 25, 40, 47, 53, 56, 58, 61, 63, 66, 68, 71, 73, 76, 78, 81, 83, 86, 88, 91, 93};
        }

        private static byte[] init__JSON_object_indicies_0() {
            return new byte[]{0, 1, 0, 0, 2, 3, 4, 0, 1, 5, 5, 6, 7, 5, 1, 8, 9, 1, 10, 8, 10, 5, 8, 5, 9, 7, 7, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 7, 11, 1, 13, 13, 14, 15, 4, 13, 1, 14, 14, 2, 16, 14, 1, 17, 18, 1, 19, 17, 19, 14, 17, 14, 18, 20, 21, 1, 22, 20, 22, 13, 20, 13, 21, 23, 24, 1, 25, 23, 25, 7, 23, 7, 24, 26, 27, 1, 28, 26, 28, 0, 26, 0, 27, 1, 0};
        }

        private static byte[] init__JSON_object_trans_targs_0() {
            return new byte[]{2, 0, 3, 23, 27, 3, 4, 8, 5, 7, 6, 9, 19, 9, 10, 15, 11, 12, 14, 13, 16, 18, 17, 20, 22, 21, 24, 26, 25};
        }

        private static byte[] init__JSON_object_trans_actions_0() {
            return new byte[]{0, 0, 3, 0, 5, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        void parseObject(ParserResult var1_1, int var2_2, int var3_3) {
            var4_4 = 1638;
            var5_5 /* !! */  = null;
            var6_6 = true;
            if (Parser.access$700(this.parser) > 0 && this.currentNesting > Parser.access$700(this.parser)) {
                throw this.newException("NestingError", "nesting of " + this.currentNesting + " is too deep");
            }
            if (Parser.access$900(this.parser) == this.getRuntime().getHash()) {
                var7_7 = RubyHash.newHash((Ruby)this.getRuntime());
            } else {
                var6_6 = false;
                var7_7 = Parser.access$900(this.parser).newInstance(this.context, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
            }
            var4_4 = 1;
            var9_8 = 0;
            var13_10 = 0;
            block10: while (true) {
                switch (var13_10) {
                    case 0: {
                        if (var2_2 == var3_3) {
                            var13_10 = 4;
                            continue block10;
                        }
                        if (var4_4 == 0) {
                            var13_10 = 5;
                            continue block10;
                        }
                    }
                    case 1: {
                        var12_16 = ParserSession._JSON_object_key_offsets[var4_4];
                        var9_8 = ParserSession._JSON_object_index_offsets[var4_4];
                        var8_11 = ParserSession._JSON_object_single_lengths[var4_4];
                        if (var8_11 <= 0) ** GOTO lbl42
                        var14_17 = var12_16;
                        var16_20 = var12_16 + var8_11 - 1;
                        while (var16_20 >= var14_17) {
                            var15_19 = var14_17 + (var16_20 - var14_17 >> 1);
                            if (this.data[var2_2] < ParserSession._JSON_object_trans_keys[var15_19]) {
                                var16_20 = var15_19 - 1;
                                continue;
                            }
                            if (this.data[var2_2] > ParserSession._JSON_object_trans_keys[var15_19]) {
                                var14_17 = var15_19 + 1;
                                continue;
                            }
                            var9_8 += var15_19 - var12_16;
                            ** GOTO lbl56
                        }
                        var12_16 += var8_11;
                        var9_8 += var8_11;
lbl42:
                        // 2 sources

                        if ((var8_11 = ParserSession._JSON_object_range_lengths[var4_4]) > 0) {
                            var14_17 = var12_16;
                            var16_20 = var12_16 + (var8_11 << 1) - 2;
                            while (var16_20 >= var14_17) {
                                var15_19 = var14_17 + (var16_20 - var14_17 >> 1 & -2);
                                if (this.data[var2_2] < ParserSession._JSON_object_trans_keys[var15_19]) {
                                    var16_20 = var15_19 - 2;
                                    continue;
                                }
                                if (this.data[var2_2] > ParserSession._JSON_object_trans_keys[var15_19 + 1]) {
                                    var14_17 = var15_19 + 2;
                                    continue;
                                }
                                var9_8 += var15_19 - var12_16 >> 1;
                                ** GOTO lbl56
                            }
                            var9_8 += var8_11;
                        }
lbl56:
                        // 5 sources

                        var9_8 = ParserSession._JSON_object_indicies[var9_8];
                        var4_4 = ParserSession._JSON_object_trans_targs[var9_8];
                        if (ParserSession._JSON_object_trans_actions[var9_8] != 0) {
                            var10_13 = ParserSession._JSON_object_trans_actions[var9_8];
                            var11_15 = ParserSession._JSON_object_actions[var10_13++];
                            while (var11_15-- > 0) {
                                switch (ParserSession._JSON_object_actions[var10_13++]) {
                                    case 0: {
                                        this.parseValue(var1_1, var2_2, var3_3);
                                        if (var1_1.result == null) {
                                            --var2_2;
                                            ++var2_2;
                                            var13_10 = 5;
                                            continue block10;
                                        }
                                        if (Parser.access$900(this.parser) == this.getRuntime().getHash()) {
                                            var7_7.op_aset(this.context, (IRubyObject)var5_5 /* !! */ , var1_1.result);
                                        } else {
                                            var7_7.callMethod(this.context, "[]=", new IRubyObject[]{var5_5 /* !! */ , var1_1.result});
                                        }
                                        var2_2 = var1_1.p - 1;
                                        break;
                                    }
                                    case 1: {
                                        this.parseString(var1_1, var2_2, var3_3);
                                        if (var1_1.result == null) {
                                            --var2_2;
                                            ++var2_2;
                                            var13_10 = 5;
                                            continue block10;
                                        }
                                        var14_18 = (RubyString)var1_1.result;
                                        var5_5 /* !! */  = Parser.access$1000(this.parser) != false ? (this.context.getRuntime().is1_9() != false ? var14_18.intern19() : var14_18.intern()) : var14_18;
                                        var2_2 = var1_1.p - 1;
                                        break;
                                    }
                                    case 2: {
                                        --var2_2;
                                        ++var2_2;
                                        var13_10 = 5;
                                        continue block10;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var4_4 == 0) {
                            var13_10 = 5;
                            continue block10;
                        }
                        if (++var2_2 == var3_3) break block10;
                        var13_10 = 1;
                        continue block10;
                    }
                }
                break;
            }
            if (var4_4 < 27) {
                var1_1.update(null, var2_2 + 1);
                return;
            }
            var8_12 = var7_7;
            if (Parser.access$400(this.parser) && !(var9_9 = var6_6 != false ? var7_7.op_aref(this.context, (IRubyObject)Parser.access$1100(this.parser)) : var7_7.callMethod(this.context, "[]", (IRubyObject)Parser.access$1100(this.parser))).isNil() && (var10_14 = ((RubyModule)Parser.access$1200((Parser)this.parser).jsonModule.get()).callMethod(this.context, "deep_const_get", var9_9)).respondsTo("json_creatable?") && var10_14.callMethod(this.context, "json_creatable?").isTrue()) {
                var8_12 = var10_14.callMethod(this.context, "json_create", (IRubyObject)var7_7);
            }
            var1_1.update((IRubyObject)var8_12, var2_2 + 1);
        }

        private static byte[] init__JSON_actions_0() {
            return new byte[]{0, 1, 0, 1, 1};
        }

        private static byte[] init__JSON_key_offsets_0() {
            return new byte[]{0, 0, 7, 9, 10, 12, 13, 15, 16, 18, 19};
        }

        private static char[] init__JSON_trans_keys_0() {
            return new char[]{'\r', ' ', '/', '[', '{', '\t', '\n', '*', '/', '*', '*', '/', '\n', '*', '/', '*', '*', '/', '\n', '\r', ' ', '/', '\t', '\n', '\u0000'};
        }

        private static byte[] init__JSON_single_lengths_0() {
            return new byte[]{0, 5, 2, 1, 2, 1, 2, 1, 2, 1, 3};
        }

        private static byte[] init__JSON_range_lengths_0() {
            return new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }

        private static byte[] init__JSON_index_offsets_0() {
            return new byte[]{0, 0, 7, 10, 12, 15, 17, 20, 22, 25, 27};
        }

        private static byte[] init__JSON_indicies_0() {
            return new byte[]{0, 0, 2, 3, 4, 0, 1, 5, 6, 1, 7, 5, 7, 0, 5, 0, 6, 8, 9, 1, 10, 8, 10, 11, 8, 11, 9, 11, 11, 12, 11, 1, 0};
        }

        private static byte[] init__JSON_trans_targs_0() {
            return new byte[]{1, 0, 2, 10, 10, 3, 5, 4, 7, 9, 8, 10, 6};
        }

        private static byte[] init__JSON_trans_actions_0() {
            return new byte[]{0, 0, 0, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         */
        public IRubyObject parseStrict() {
            var1_1 = 1638;
            var4_2 = null;
            var5_3 = new ParserResult();
            var1_1 = 1;
            var2_4 = this.byteList.begin();
            var3_5 = var2_4 + this.byteList.length();
            var7_6 = 0;
            var11_7 = 0;
            block9: while (true) {
                switch (var11_7) {
                    case 0: {
                        if (var2_4 == var3_5) {
                            var11_7 = 4;
                            continue block9;
                        }
                        if (var1_1 == 0) {
                            var11_7 = 5;
                            continue block9;
                        }
                    }
                    case 1: {
                        var10_11 = ParserSession._JSON_key_offsets[var1_1];
                        var7_6 = ParserSession._JSON_index_offsets[var1_1];
                        var6_8 = ParserSession._JSON_single_lengths[var1_1];
                        if (var6_8 <= 0) ** GOTO lbl37
                        var12_12 = var10_11;
                        var14_14 = var10_11 + var6_8 - 1;
                        while (var14_14 >= var12_12) {
                            var13_13 = var12_12 + (var14_14 - var12_12 >> 1);
                            if (this.data[var2_4] < ParserSession._JSON_trans_keys[var13_13]) {
                                var14_14 = var13_13 - 1;
                                continue;
                            }
                            if (this.data[var2_4] > ParserSession._JSON_trans_keys[var13_13]) {
                                var12_12 = var13_13 + 1;
                                continue;
                            }
                            var7_6 += var13_13 - var10_11;
                            ** GOTO lbl51
                        }
                        var10_11 += var6_8;
                        var7_6 += var6_8;
lbl37:
                        // 2 sources

                        if ((var6_8 = ParserSession._JSON_range_lengths[var1_1]) > 0) {
                            var12_12 = var10_11;
                            var14_14 = var10_11 + (var6_8 << 1) - 2;
                            while (var14_14 >= var12_12) {
                                var13_13 = var12_12 + (var14_14 - var12_12 >> 1 & -2);
                                if (this.data[var2_4] < ParserSession._JSON_trans_keys[var13_13]) {
                                    var14_14 = var13_13 - 2;
                                    continue;
                                }
                                if (this.data[var2_4] > ParserSession._JSON_trans_keys[var13_13 + 1]) {
                                    var12_12 = var13_13 + 2;
                                    continue;
                                }
                                var7_6 += var13_13 - var10_11 >> 1;
                                ** GOTO lbl51
                            }
                            var7_6 += var6_8;
                        }
lbl51:
                        // 5 sources

                        var7_6 = ParserSession._JSON_indicies[var7_6];
                        var1_1 = ParserSession._JSON_trans_targs[var7_6];
                        if (ParserSession._JSON_trans_actions[var7_6] != 0) {
                            var8_9 = ParserSession._JSON_trans_actions[var7_6];
                            var9_10 = ParserSession._JSON_actions[var8_9++];
                            while (var9_10-- > 0) {
                                switch (ParserSession._JSON_actions[var8_9++]) {
                                    case 0: {
                                        this.currentNesting = 1;
                                        this.parseObject(var5_3, var2_4, var3_5);
                                        if (var5_3.result == null) {
                                            --var2_4;
                                            ++var2_4;
                                            var11_7 = 5;
                                            continue block9;
                                        }
                                        var4_2 = var5_3.result;
                                        var2_4 = var5_3.p - 1;
                                        break;
                                    }
                                    case 1: {
                                        this.currentNesting = 1;
                                        this.parseArray(var5_3, var2_4, var3_5);
                                        if (var5_3.result == null) {
                                            --var2_4;
                                            ++var2_4;
                                            var11_7 = 5;
                                            continue block9;
                                        }
                                        var4_2 = var5_3.result;
                                        var2_4 = var5_3.p - 1;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var1_1 == 0) {
                            var11_7 = 5;
                            continue block9;
                        }
                        if (++var2_4 == var3_5) break block9;
                        var11_7 = 1;
                        continue block9;
                    }
                }
                break;
            }
            if (var1_1 >= 10 && var2_4 == var3_5) {
                return var4_2;
            }
            throw this.unexpectedToken(var2_4, var3_5);
        }

        private static byte[] init__JSON_quirks_mode_actions_0() {
            return new byte[]{0, 1, 0};
        }

        private static byte[] init__JSON_quirks_mode_key_offsets_0() {
            return new byte[]{0, 0, 16, 18, 19, 21, 22, 24, 25, 27, 28};
        }

        private static char[] init__JSON_quirks_mode_trans_keys_0() {
            return new char[]{'\r', ' ', '\"', '-', '/', 'I', 'N', '[', 'f', 'n', 't', '{', '\t', '\n', '0', '9', '*', '/', '*', '*', '/', '\n', '*', '/', '*', '*', '/', '\n', '\r', ' ', '/', '\t', '\n', '\u0000'};
        }

        private static byte[] init__JSON_quirks_mode_single_lengths_0() {
            return new byte[]{0, 12, 2, 1, 2, 1, 2, 1, 2, 1, 3};
        }

        private static byte[] init__JSON_quirks_mode_range_lengths_0() {
            return new byte[]{0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }

        private static byte[] init__JSON_quirks_mode_index_offsets_0() {
            return new byte[]{0, 0, 15, 18, 20, 23, 25, 28, 30, 33, 35};
        }

        private static byte[] init__JSON_quirks_mode_indicies_0() {
            return new byte[]{0, 0, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 0, 2, 1, 4, 5, 1, 6, 4, 6, 7, 4, 7, 5, 8, 9, 1, 10, 8, 10, 0, 8, 0, 9, 7, 7, 11, 7, 1, 0};
        }

        private static byte[] init__JSON_quirks_mode_trans_targs_0() {
            return new byte[]{1, 0, 10, 6, 3, 5, 4, 10, 7, 9, 8, 2};
        }

        private static byte[] init__JSON_quirks_mode_trans_actions_0() {
            return new byte[]{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         */
        public IRubyObject parseQuirksMode() {
            var1_1 = 1638;
            var4_2 = null;
            var5_3 = new ParserResult();
            var1_1 = 1;
            var2_4 = this.byteList.begin();
            var3_5 = var2_4 + this.byteList.length();
            var7_6 = 0;
            var11_7 = 0;
            block8: while (true) {
                switch (var11_7) {
                    case 0: {
                        if (var2_4 == var3_5) {
                            var11_7 = 4;
                            continue block8;
                        }
                        if (var1_1 == 0) {
                            var11_7 = 5;
                            continue block8;
                        }
                    }
                    case 1: {
                        var10_11 = ParserSession._JSON_quirks_mode_key_offsets[var1_1];
                        var7_6 = ParserSession._JSON_quirks_mode_index_offsets[var1_1];
                        var6_8 = ParserSession._JSON_quirks_mode_single_lengths[var1_1];
                        if (var6_8 <= 0) ** GOTO lbl37
                        var12_12 = var10_11;
                        var14_14 = var10_11 + var6_8 - 1;
                        while (var14_14 >= var12_12) {
                            var13_13 = var12_12 + (var14_14 - var12_12 >> 1);
                            if (this.data[var2_4] < ParserSession._JSON_quirks_mode_trans_keys[var13_13]) {
                                var14_14 = var13_13 - 1;
                                continue;
                            }
                            if (this.data[var2_4] > ParserSession._JSON_quirks_mode_trans_keys[var13_13]) {
                                var12_12 = var13_13 + 1;
                                continue;
                            }
                            var7_6 += var13_13 - var10_11;
                            ** GOTO lbl51
                        }
                        var10_11 += var6_8;
                        var7_6 += var6_8;
lbl37:
                        // 2 sources

                        if ((var6_8 = ParserSession._JSON_quirks_mode_range_lengths[var1_1]) > 0) {
                            var12_12 = var10_11;
                            var14_14 = var10_11 + (var6_8 << 1) - 2;
                            while (var14_14 >= var12_12) {
                                var13_13 = var12_12 + (var14_14 - var12_12 >> 1 & -2);
                                if (this.data[var2_4] < ParserSession._JSON_quirks_mode_trans_keys[var13_13]) {
                                    var14_14 = var13_13 - 2;
                                    continue;
                                }
                                if (this.data[var2_4] > ParserSession._JSON_quirks_mode_trans_keys[var13_13 + 1]) {
                                    var12_12 = var13_13 + 2;
                                    continue;
                                }
                                var7_6 += var13_13 - var10_11 >> 1;
                                ** GOTO lbl51
                            }
                            var7_6 += var6_8;
                        }
lbl51:
                        // 5 sources

                        var7_6 = ParserSession._JSON_quirks_mode_indicies[var7_6];
                        var1_1 = ParserSession._JSON_quirks_mode_trans_targs[var7_6];
                        if (ParserSession._JSON_quirks_mode_trans_actions[var7_6] != 0) {
                            var8_9 = ParserSession._JSON_quirks_mode_trans_actions[var7_6];
                            var9_10 = ParserSession._JSON_quirks_mode_actions[var8_9++];
                            while (var9_10-- > 0) {
                                switch (ParserSession._JSON_quirks_mode_actions[var8_9++]) {
                                    case 0: {
                                        this.parseValue(var5_3, var2_4, var3_5);
                                        if (var5_3.result == null) {
                                            --var2_4;
                                            ++var2_4;
                                            var11_7 = 5;
                                            continue block8;
                                        }
                                        var4_2 = var5_3.result;
                                        var2_4 = var5_3.p - 1;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var1_1 == 0) {
                            var11_7 = 5;
                            continue block8;
                        }
                        if (++var2_4 == var3_5) break block8;
                        var11_7 = 1;
                        continue block8;
                    }
                }
                break;
            }
            if (var1_1 >= 10 && var2_4 == var3_5) {
                return var4_2;
            }
            throw this.unexpectedToken(var2_4, var3_5);
        }

        public IRubyObject parse() {
            if (this.parser.quirksMode) {
                return this.parseQuirksMode();
            }
            return this.parseStrict();
        }

        private ByteList absSubSequence(int n, int n2) {
            this.view.setBegin(n);
            this.view.setRealSize(n2 - n);
            return this.view;
        }

        private IRubyObject getConstant(String string) {
            return ((RubyModule)((Parser)this.parser).info.jsonModule.get()).getConstant(string);
        }

        private RaiseException newException(String string, String string2) {
            return Utils.newException(this.context, string, string2);
        }

        private RaiseException newException(String string, RubyString rubyString) {
            return Utils.newException(this.context, string, rubyString);
        }

        private RaiseException newException(String string, String string2, ByteList byteList) {
            return this.newException(string, this.getRuntime().newString(string2).cat(byteList));
        }
    }

    static final class ParserResult {
        IRubyObject result;
        int p;

        ParserResult() {
        }

        void update(IRubyObject iRubyObject, int n) {
            this.result = iRubyObject;
            this.p = n;
        }
    }
}

