
(function(window){window.Appwrite=function(){let config={endpoint:'https://appwrite.test/v1',project:'',key:'',locale:'',mode:'',};let setEndpoint=function(endpoint){config.endpoint=endpoint;return this;};let setProject=function(value)
{http.addGlobalHeader('X-Appwrite-Project',value);config.project=value;return this;};let setKey=function(value)
{http.addGlobalHeader('X-Appwrite-Key',value);config.key=value;return this;};let setLocale=function(value)
{http.addGlobalHeader('X-Appwrite-Locale',value);config.locale=value;return this;};let setMode=function(value)
{http.addGlobalHeader('X-Appwrite-Mode',value);config.mode=value;return this;};let http=function(document){let globalParams=[],globalHeaders=[];let addParam=function(url,param,value){let a=document.createElement('a'),regex=/(?:\?|&amp;|&)+([^=]+)(?:=([^&]*))*/g;let match,str=[];a.href=url;param=encodeURIComponent(param);while(match=regex.exec(a.search))if(param!==match[1])str.push(match[1]+(match[2]?"="+match[2]:""));str.push(param+(value?"="+encodeURIComponent(value):""));a.search=str.join("&");return a.href;};let buildQuery=function(params){let str=[];for(let p in params){if(Array.isArray(params[p])){for(let index=0;index<params[p].length;index++){let param=params[p][index];str.push(encodeURIComponent(p+'[]')+"="+encodeURIComponent(param));}}
else{str.push(encodeURIComponent(p)+"="+encodeURIComponent(params[p]));}}
return str.join("&");};let addGlobalHeader=function(key,value){globalHeaders[key]={key:key.toLowerCase(),value:value.toLowerCase()};};let addGlobalParam=function(key,value){globalParams.push({key:key,value:value});};addGlobalHeader('x-sdk-version','appwrite:javascript:v1.0.19');addGlobalHeader('content-type','');let call=function(method,path,headers={},params={},progress=null){let i;path=config.endpoint+path;if(-1===['GET','POST','PUT','DELETE','TRACE','HEAD','OPTIONS','CONNECT','PATCH'].indexOf(method)){throw new Error('var method must contain a valid HTTP method name');}
if(typeof path!=='string'){throw new Error('var path must be of type string');}
if(typeof headers!=='object'){throw new Error('var headers must be of type object');}
for(i=0;i<globalParams.length;i++){path=addParam(path,globalParams[i].key,globalParams[i].value);}
for(let key in globalHeaders){if(globalHeaders.hasOwnProperty(key)){if(!headers[globalHeaders[key].key]){headers[globalHeaders[key].key]=globalHeaders[key].value;}}}
if(method==='GET'){for(let param in params){if(param.hasOwnProperty(key)){path=addParam(path,key+(Array.isArray(param)?'[]':''),params[key]);}}}
switch(headers['content-type']){case'application/json':params=JSON.stringify(params);break;case'multipart/form-data':let formData=new FormData();Object.keys(params).forEach(function(key){let param=params[key];formData.append(key+(Array.isArray(param)?'[]':''),param);});params=formData;break;}
return new Promise(function(resolve,reject){let request=new XMLHttpRequest(),key;request.withCredentials=true;request.open(method,path,true);for(key in headers){if(headers.hasOwnProperty(key)){if(key==='content-type'&&headers[key]==='multipart/form-data'){continue;}
request.setRequestHeader(key,headers[key]);}}
request.onload=function(){if(4===request.readyState&&399>=request.status){let data=request.response;let contentType=this.getResponseHeader('content-type')||'';contentType=contentType.substring(0,contentType.indexOf(';'));switch(contentType){case'application/json':data=JSON.parse(data);break;}
resolve(data);}else{reject(new Error(request.statusText));}};if(progress){request.addEventListener('progress',progress);request.upload.addEventListener('progress',progress,false);}
request.onerror=function(){reject(new Error("Network Error"));};request.send(params);})};return{'get':function(path,headers={},params={}){return call('GET',path+((Object.keys(params).length>0)?'?'+buildQuery(params):''),headers,{});},'post':function(path,headers={},params={},progress=null){return call('POST',path,headers,params,progress);},'put':function(path,headers={},params={},progress=null){return call('PUT',path,headers,params,progress);},'patch':function(path,headers={},params={},progress=null){return call('PATCH',path,headers,params,progress);},'delete':function(path,headers={},params={},progress=null){return call('DELETE',path,headers,params,progress);},'addGlobalParam':addGlobalParam,'addGlobalHeader':addGlobalHeader}}(window.document);let iframe=function(method,url,params){let form=document.createElement('form');form.setAttribute('method',method);form.setAttribute('action',config.endpoint+url);for(let key in params){if(params.hasOwnProperty(key)){let hiddenField=document.createElement("input");hiddenField.setAttribute("type","hidden");hiddenField.setAttribute("name",key);hiddenField.setAttribute("value",params[key]);form.appendChild(hiddenField);}}
document.body.appendChild(form);return form.submit();};let account={get:function(){let path='/account';return http.get(path,{'content-type':'application/json'},{});},delete:function(){let path='/account';return http.delete(path,{'content-type':'application/json'},{});},updateEmail:function(email,password){if(email===undefined){throw new Error('Missing required parameter: "email"');}
if(password===undefined){throw new Error('Missing required parameter: "password"');}
let path='/account/email';return http.patch(path,{'content-type':'application/json'},{'email':email,'password':password});},updateName:function(name){if(name===undefined){throw new Error('Missing required parameter: "name"');}
let path='/account/name';return http.patch(path,{'content-type':'application/json'},{'name':name});},updatePassword:function(password,oldPassword){if(password===undefined){throw new Error('Missing required parameter: "password"');}
if(oldPassword===undefined){throw new Error('Missing required parameter: "oldPassword"');}
let path='/account/password';return http.patch(path,{'content-type':'application/json'},{'password':password,'old-password':oldPassword});},getPrefs:function(){let path='/account/prefs';return http.get(path,{'content-type':'application/json'},{});},updatePrefs:function(prefs){if(prefs===undefined){throw new Error('Missing required parameter: "prefs"');}
let path='/account/prefs';return http.patch(path,{'content-type':'application/json'},{'prefs':prefs});},getSecurity:function(){let path='/account/security';return http.get(path,{'content-type':'application/json'},{});},getSessions:function(){let path='/account/sessions';return http.get(path,{'content-type':'application/json'},{});}};let auth={login:function(email,password,success='',failure=''){if(email===undefined){throw new Error('Missing required parameter: "email"');}
if(password===undefined){throw new Error('Missing required parameter: "password"');}
let path='/auth/login';return iframe('post',path,{project:config.project,'email':email,'password':password,'success':success,'failure':failure});},logout:function(){let path='/auth/logout';return http.delete(path,{'content-type':'application/json'},{});},logoutBySession:function(id){if(id===undefined){throw new Error('Missing required parameter: "id"');}
let path='/auth/logout/{id}'.replace(new RegExp('{id}','g'),id);return http.delete(path,{'content-type':'application/json'},{});},recovery:function(email,redirect){if(email===undefined){throw new Error('Missing required parameter: "email"');}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"');}
let path='/auth/recovery';return http.post(path,{'content-type':'application/json'},{'email':email,'redirect':redirect});},recoveryReset:function(userId,token,passwordA,passwordB){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
if(token===undefined){throw new Error('Missing required parameter: "token"');}
if(passwordA===undefined){throw new Error('Missing required parameter: "passwordA"');}
if(passwordB===undefined){throw new Error('Missing required parameter: "passwordB"');}
let path='/auth/recovery/reset';return http.put(path,{'content-type':'application/json'},{'userId':userId,'token':token,'password-a':passwordA,'password-b':passwordB});},register:function(email,password,redirect,name='',success='',failure=''){if(email===undefined){throw new Error('Missing required parameter: "email"');}
if(password===undefined){throw new Error('Missing required parameter: "password"');}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"');}
let path='/auth/register';return iframe('post',path,{project:config.project,'email':email,'password':password,'name':name,'redirect':redirect,'success':success,'failure':failure});},confirm:function(userId,token){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
if(token===undefined){throw new Error('Missing required parameter: "token"');}
let path='/auth/register/confirm';return http.post(path,{'content-type':'application/json'},{'userId':userId,'token':token});},confirmResend:function(redirect){if(redirect===undefined){throw new Error('Missing required parameter: "redirect"');}
let path='/auth/register/confirm/resend';return http.post(path,{'content-type':'application/json'},{'redirect':redirect});},oauthCallback:function(projectId,provider,code,state=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(provider===undefined){throw new Error('Missing required parameter: "provider"');}
if(code===undefined){throw new Error('Missing required parameter: "code"');}
let path='/oauth/callback/{provider}/{projectId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{provider}','g'),provider);return http.get(path,{'content-type':'application/json'},{'code':code,'state':state});},oauth:function(provider,success='',failure=''){if(provider===undefined){throw new Error('Missing required parameter: "provider"');}
let path='/oauth/{provider}'.replace(new RegExp('{provider}','g'),provider);return http.get(path,{'content-type':'application/json'},{'success':success,'failure':failure});}};let avatars={getBrowser:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"');}
let path='/avatars/browsers/{code}'.replace(new RegExp('{code}','g'),code);return http.get(path,{'content-type':'application/json'},{'width':width,'height':height,'quality':quality});},getCreditCard:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"');}
let path='/avatars/credit-cards/{code}'.replace(new RegExp('{code}','g'),code);return http.get(path,{'content-type':'application/json'},{'width':width,'height':height,'quality':quality});},getFavicon:function(url){if(url===undefined){throw new Error('Missing required parameter: "url"');}
let path='/avatars/favicon';return http.get(path,{'content-type':'application/json'},{'url':url});},getFlag:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"');}
let path='/avatars/flags/{code}'.replace(new RegExp('{code}','g'),code);return http.get(path,{'content-type':'application/json'},{'width':width,'height':height,'quality':quality});},getImage:function(url,width=400,height=400){if(url===undefined){throw new Error('Missing required parameter: "url"');}
let path='/avatars/image';return http.get(path,{'content-type':'application/json'},{'url':url,'width':width,'height':height});},getQR:function(text,size=400,margin=1,download=0){if(text===undefined){throw new Error('Missing required parameter: "text"');}
let path='/avatars/qr';return http.get(path,{'content-type':'application/json'},{'text':text,'size':size,'margin':margin,'download':download});}};let database={listCollections:function(search='',limit=25,offset=0,orderType='ASC'){let path='/database';return http.get(path,{'content-type':'application/json'},{'search':search,'limit':limit,'offset':offset,'orderType':orderType});},createCollection:function(name,read=[],write=[],rules=[]){if(name===undefined){throw new Error('Missing required parameter: "name"');}
let path='/database';return http.post(path,{'content-type':'application/json'},{'name':name,'read':read,'write':write,'rules':rules});},getCollection:function(collectionId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"');}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);return http.get(path,{'content-type':'application/json'},{});},updateCollection:function(collectionId,name,read=[],write=[],rules=[]){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);return http.put(path,{'content-type':'application/json'},{'name':name,'read':read,'write':write,'rules':rules});},deleteCollection:function(collectionId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"');}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);return http.delete(path,{'content-type':'application/json'},{});},listDocuments:function(collectionId,filters=[],offset=0,limit=50,orderField='$uid',orderType='ASC',orderCast='string',search='',first=0,last=0){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"');}
let path='/database/{collectionId}/documents'.replace(new RegExp('{collectionId}','g'),collectionId);return http.get(path,{'content-type':'application/json'},{'filters':filters,'offset':offset,'limit':limit,'order-field':orderField,'order-type':orderType,'order-cast':orderCast,'search':search,'first':first,'last':last});},createDocument:function(collectionId,data,read=[],write=[],parentDocument='',parentProperty='',parentPropertyType='assign'){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"');}
if(data===undefined){throw new Error('Missing required parameter: "data"');}
let path='/database/{collectionId}/documents'.replace(new RegExp('{collectionId}','g'),collectionId);return http.post(path,{'content-type':'application/json'},{'data':data,'read':read,'write':write,'parentDocument':parentDocument,'parentProperty':parentProperty,'parentPropertyType':parentPropertyType});},getDocument:function(collectionId,documentId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"');}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"');}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);return http.get(path,{'content-type':'application/json'},{});},updateDocument:function(collectionId,documentId,data,read=[],write=[]){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"');}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"');}
if(data===undefined){throw new Error('Missing required parameter: "data"');}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);return http.patch(path,{'content-type':'application/json'},{'data':data,'read':read,'write':write});},deleteDocument:function(collectionId,documentId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"');}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"');}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);return http.delete(path,{'content-type':'application/json'},{});}};let locale={getLocale:function(){let path='/locale';return http.get(path,{'content-type':'application/json'},{});},getCountries:function(){let path='/locale/countries';return http.get(path,{'content-type':'application/json'},{});},getCountriesEU:function(){let path='/locale/countries/eu';return http.get(path,{'content-type':'application/json'},{});},getCountriesPhones:function(){let path='/locale/countries/phones';return http.get(path,{'content-type':'application/json'},{});},getCurrencies:function(){let path='/locale/currencies';return http.get(path,{'content-type':'application/json'},{});}};let projects={listProjects:function(){let path='/projects';return http.get(path,{'content-type':'application/json'},{});},createProject:function(name,teamId,description='',logo='',url='',legalName='',legalCountry='',legalState='',legalCity='',legalAddress='',legalTaxId=''){if(name===undefined){throw new Error('Missing required parameter: "name"');}
if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
let path='/projects';return http.post(path,{'content-type':'application/json'},{'name':name,'teamId':teamId,'description':description,'logo':logo,'url':url,'legalName':legalName,'legalCountry':legalCountry,'legalState':legalState,'legalCity':legalCity,'legalAddress':legalAddress,'legalTaxId':legalTaxId});},getProject:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{});},updateProject:function(projectId,name,description='',logo='',url='',legalName='',legalCountry='',legalState='',legalCity='',legalAddress='',legalTaxId=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);return http.patch(path,{'content-type':'application/json'},{'name':name,'description':description,'logo':logo,'url':url,'legalName':legalName,'legalCountry':legalCountry,'legalState':legalState,'legalCity':legalCity,'legalAddress':legalAddress,'legalTaxId':legalTaxId});},deleteProject:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);return http.delete(path,{'content-type':'application/json'},{});},listKeys:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/keys'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{});},createKey:function(projectId,name,scopes){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
if(scopes===undefined){throw new Error('Missing required parameter: "scopes"');}
let path='/projects/{projectId}/keys'.replace(new RegExp('{projectId}','g'),projectId);return http.post(path,{'content-type':'application/json'},{'name':name,'scopes':scopes});},getKey:function(projectId,keyId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"');}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);return http.get(path,{'content-type':'application/json'},{});},updateKey:function(projectId,keyId,name,scopes){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
if(scopes===undefined){throw new Error('Missing required parameter: "scopes"');}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);return http.put(path,{'content-type':'application/json'},{'name':name,'scopes':scopes});},deleteKey:function(projectId,keyId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"');}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);return http.delete(path,{'content-type':'application/json'},{});},updateProjectOAuth:function(projectId,provider,appId='',secret=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(provider===undefined){throw new Error('Missing required parameter: "provider"');}
let path='/projects/{projectId}/oauth'.replace(new RegExp('{projectId}','g'),projectId);return http.patch(path,{'content-type':'application/json'},{'provider':provider,'appId':appId,'secret':secret});},listPlatforms:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/platforms'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{});},createPlatform:function(projectId,type,name,key='',store='',url=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(type===undefined){throw new Error('Missing required parameter: "type"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
let path='/projects/{projectId}/platforms'.replace(new RegExp('{projectId}','g'),projectId);return http.post(path,{'content-type':'application/json'},{'type':type,'name':name,'key':key,'store':store,'url':url});},getPlatform:function(projectId,platformId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"');}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);return http.get(path,{'content-type':'application/json'},{});},updatePlatform:function(projectId,platformId,name,key='',store='',url=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);return http.put(path,{'content-type':'application/json'},{'name':name,'key':key,'store':store,'url':url});},deletePlatform:function(projectId,platformId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"');}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);return http.delete(path,{'content-type':'application/json'},{});},listTasks:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/tasks'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{});},createTask:function(projectId,name,status,schedule,security,httpMethod,httpUrl,httpHeaders=[],httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
if(status===undefined){throw new Error('Missing required parameter: "status"');}
if(schedule===undefined){throw new Error('Missing required parameter: "schedule"');}
if(security===undefined){throw new Error('Missing required parameter: "security"');}
if(httpMethod===undefined){throw new Error('Missing required parameter: "httpMethod"');}
if(httpUrl===undefined){throw new Error('Missing required parameter: "httpUrl"');}
let path='/projects/{projectId}/tasks'.replace(new RegExp('{projectId}','g'),projectId);return http.post(path,{'content-type':'application/json'},{'name':name,'status':status,'schedule':schedule,'security':security,'httpMethod':httpMethod,'httpUrl':httpUrl,'httpHeaders':httpHeaders,'httpUser':httpUser,'httpPass':httpPass});},getTask:function(projectId,taskId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"');}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);return http.get(path,{'content-type':'application/json'},{});},updateTask:function(projectId,taskId,name,status,schedule,security,httpMethod,httpUrl,httpHeaders=[],httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
if(status===undefined){throw new Error('Missing required parameter: "status"');}
if(schedule===undefined){throw new Error('Missing required parameter: "schedule"');}
if(security===undefined){throw new Error('Missing required parameter: "security"');}
if(httpMethod===undefined){throw new Error('Missing required parameter: "httpMethod"');}
if(httpUrl===undefined){throw new Error('Missing required parameter: "httpUrl"');}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);return http.put(path,{'content-type':'application/json'},{'name':name,'status':status,'schedule':schedule,'security':security,'httpMethod':httpMethod,'httpUrl':httpUrl,'httpHeaders':httpHeaders,'httpUser':httpUser,'httpPass':httpPass});},deleteTask:function(projectId,taskId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"');}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);return http.delete(path,{'content-type':'application/json'},{});},getProjectUsage:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/usage'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{});},listWebhooks:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/webhooks'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{});},createWebhook:function(projectId,name,events,url,security,httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
if(events===undefined){throw new Error('Missing required parameter: "events"');}
if(url===undefined){throw new Error('Missing required parameter: "url"');}
if(security===undefined){throw new Error('Missing required parameter: "security"');}
let path='/projects/{projectId}/webhooks'.replace(new RegExp('{projectId}','g'),projectId);return http.post(path,{'content-type':'application/json'},{'name':name,'events':events,'url':url,'security':security,'httpUser':httpUser,'httpPass':httpPass});},getWebhook:function(projectId,webhookId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"');}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);return http.get(path,{'content-type':'application/json'},{});},updateWebhook:function(projectId,webhookId,name,events,url,security,httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
if(events===undefined){throw new Error('Missing required parameter: "events"');}
if(url===undefined){throw new Error('Missing required parameter: "url"');}
if(security===undefined){throw new Error('Missing required parameter: "security"');}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);return http.put(path,{'content-type':'application/json'},{'name':name,'events':events,'url':url,'security':security,'httpUser':httpUser,'httpPass':httpPass});},deleteWebhook:function(projectId,webhookId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"');}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"');}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);return http.delete(path,{'content-type':'application/json'},{});}};let storage={listFiles:function(search='',limit=25,offset=0,orderType='ASC'){let path='/storage/files';return http.get(path,{'content-type':'application/json'},{'search':search,'limit':limit,'offset':offset,'orderType':orderType});},createFile:function(files,read=[],write=[],folderId=''){if(files===undefined){throw new Error('Missing required parameter: "files"');}
let path='/storage/files';return http.post(path,{'content-type':'multipart/form-data'},{'files':files,'read':read,'write':write,'folderId':folderId});},getFile:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);return http.get(path,{'content-type':'application/json'},{});},updateFile:function(fileId,read=[],write=[],folderId=''){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);return http.put(path,{'content-type':'application/json'},{'read':read,'write':write,'folderId':folderId});},deleteFile:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);return http.delete(path,{'content-type':'application/json'},{});},getFileDownload:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}/download'.replace(new RegExp('{fileId}','g'),fileId);return http.get(path,{'content-type':'application/json'},{});},getFilePreview:function(fileId,width=0,height=0,quality=100,background='',output=''){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}/preview'.replace(new RegExp('{fileId}','g'),fileId);return http.get(path,{'content-type':'application/json'},{'width':width,'height':height,'quality':quality,'background':background,'output':output});},getFileView:function(fileId,as=''){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}/view'.replace(new RegExp('{fileId}','g'),fileId);return http.get(path,{'content-type':'application/json'},{'as':as});}};let teams={listTeams:function(search='',limit=25,offset=0,orderType='ASC'){let path='/teams';return http.get(path,{'content-type':'application/json'},{'search':search,'limit':limit,'offset':offset,'orderType':orderType});},createTeam:function(name,roles=["owner"]){if(name===undefined){throw new Error('Missing required parameter: "name"');}
let path='/teams';return http.post(path,{'content-type':'application/json'},{'name':name,'roles':roles});},getTeam:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);return http.get(path,{'content-type':'application/json'},{});},updateTeam:function(teamId,name){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
if(name===undefined){throw new Error('Missing required parameter: "name"');}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);return http.put(path,{'content-type':'application/json'},{'name':name});},deleteTeam:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);return http.delete(path,{'content-type':'application/json'},{});},getTeamMembers:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
let path='/teams/{teamId}/members'.replace(new RegExp('{teamId}','g'),teamId);return http.get(path,{'content-type':'application/json'},{});},createTeamMembership:function(teamId,email,roles,redirect,name=''){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
if(email===undefined){throw new Error('Missing required parameter: "email"');}
if(roles===undefined){throw new Error('Missing required parameter: "roles"');}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"');}
let path='/teams/{teamId}/memberships'.replace(new RegExp('{teamId}','g'),teamId);return http.post(path,{'content-type':'application/json'},{'email':email,'name':name,'roles':roles,'redirect':redirect});},deleteTeamMembership:function(teamId,inviteId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"');}
let path='/teams/{teamId}/memberships/{inviteId}'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);return http.delete(path,{'content-type':'application/json'},{});},createTeamMembershipResend:function(teamId,inviteId,redirect){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"');}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"');}
let path='/teams/{teamId}/memberships/{inviteId}/resend'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);return http.post(path,{'content-type':'application/json'},{'redirect':redirect});},updateTeamMembershipStatus:function(teamId,inviteId,userId,secret,success='',failure=''){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"');}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"');}
if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
if(secret===undefined){throw new Error('Missing required parameter: "secret"');}
let path='/teams/{teamId}/memberships/{inviteId}/status'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);return iframe('patch',path,{project:config.project,'userId':userId,'secret':secret,'success':success,'failure':failure});}};let users={listUsers:function(search='',limit=25,offset=0,orderType='ASC'){let path='/users';return http.get(path,{'content-type':'application/json'},{'search':search,'limit':limit,'offset':offset,'orderType':orderType});},createUser:function(email,password,name=''){if(email===undefined){throw new Error('Missing required parameter: "email"');}
if(password===undefined){throw new Error('Missing required parameter: "password"');}
let path='/users';return http.post(path,{'content-type':'application/json'},{'email':email,'password':password,'name':name});},getUser:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
let path='/users/{userId}'.replace(new RegExp('{userId}','g'),userId);return http.get(path,{'content-type':'application/json'},{});},getUserLogs:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
let path='/users/{userId}/logs'.replace(new RegExp('{userId}','g'),userId);return http.get(path,{'content-type':'application/json'},{});},getUserPrefs:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
let path='/users/{userId}/prefs'.replace(new RegExp('{userId}','g'),userId);return http.get(path,{'content-type':'application/json'},{});},getUserSessions:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
let path='/users/{userId}/sessions'.replace(new RegExp('{userId}','g'),userId);return http.get(path,{'content-type':'application/json'},{});},deleteUserSessions:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
let path='/users/{userId}/sessions'.replace(new RegExp('{userId}','g'),userId);return http.delete(path,{'content-type':'application/json'},{});},deleteUsersSession:function(userId,sessionId){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
if(sessionId===undefined){throw new Error('Missing required parameter: "sessionId"');}
let path='/users/{userId}/sessions/:session'.replace(new RegExp('{userId}','g'),userId);return http.delete(path,{'content-type':'application/json'},{'sessionId':sessionId});},updateUserStatus:function(userId,status){if(userId===undefined){throw new Error('Missing required parameter: "userId"');}
if(status===undefined){throw new Error('Missing required parameter: "status"');}
let path='/users/{userId}/status'.replace(new RegExp('{userId}','g'),userId);return http.patch(path,{'content-type':'application/json'},{'status':status});}};return{setEndpoint:setEndpoint,setProject:setProject,setKey:setKey,setLocale:setLocale,setMode:setMode,account:account,auth:auth,avatars:avatars,database:database,locale:locale,projects:projects,storage:storage,teams:teams,users:users};};})(window);(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.Chart=f()}})(function(){var define,module,exports;return(function(){function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s}return e})()({1:[function(require,module,exports){var colorNames=require(5);module.exports={getRgba:getRgba,getHsla:getHsla,getRgb:getRgb,getHsl:getHsl,getHwb:getHwb,getAlpha:getAlpha,hexString:hexString,rgbString:rgbString,rgbaString:rgbaString,percentString:percentString,percentaString:percentaString,hslString:hslString,hslaString:hslaString,hwbString:hwbString,keyword:keyword}
function getRgba(string){if(!string){return;}
var abbr=/^#([a-fA-F0-9]{3})$/i,hex=/^#([a-fA-F0-9]{6})$/i,rgba=/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,per=/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,keyword=/(\w+)/;var rgb=[0,0,0],a=1,match=string.match(abbr);if(match){match=match[1];for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match[i]+match[i],16);}}
else if(match=string.match(hex)){match=match[1];for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match.slice(i*2,i*2+2),16);}}
else if(match=string.match(rgba)){for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match[i+1]);}
a=parseFloat(match[4]);}
else if(match=string.match(per)){for(var i=0;i<rgb.length;i++){rgb[i]=Math.round(parseFloat(match[i+1])*2.55);}
a=parseFloat(match[4]);}
else if(match=string.match(keyword)){if(match[1]=="transparent"){return[0,0,0,0];}
rgb=colorNames[match[1]];if(!rgb){return;}}
for(var i=0;i<rgb.length;i++){rgb[i]=scale(rgb[i],0,255);}
if(!a&&a!=0){a=1;}
else{a=scale(a,0,1);}
rgb[3]=a;return rgb;}
function getHsla(string){if(!string){return;}
var hsl=/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;var match=string.match(hsl);if(match){var alpha=parseFloat(match[4]);var h=scale(parseInt(match[1]),0,360),s=scale(parseFloat(match[2]),0,100),l=scale(parseFloat(match[3]),0,100),a=scale(isNaN(alpha)?1:alpha,0,1);return[h,s,l,a];}}
function getHwb(string){if(!string){return;}
var hwb=/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;var match=string.match(hwb);if(match){var alpha=parseFloat(match[4]);var h=scale(parseInt(match[1]),0,360),w=scale(parseFloat(match[2]),0,100),b=scale(parseFloat(match[3]),0,100),a=scale(isNaN(alpha)?1:alpha,0,1);return[h,w,b,a];}}
function getRgb(string){var rgba=getRgba(string);return rgba&&rgba.slice(0,3);}
function getHsl(string){var hsla=getHsla(string);return hsla&&hsla.slice(0,3);}
function getAlpha(string){var vals=getRgba(string);if(vals){return vals[3];}
else if(vals=getHsla(string)){return vals[3];}
else if(vals=getHwb(string)){return vals[3];}}
function hexString(rgb){return"#"+hexDouble(rgb[0])+hexDouble(rgb[1])
+hexDouble(rgb[2]);}
function rgbString(rgba,alpha){if(alpha<1||(rgba[3]&&rgba[3]<1)){return rgbaString(rgba,alpha);}
return"rgb("+rgba[0]+", "+rgba[1]+", "+rgba[2]+")";}
function rgbaString(rgba,alpha){if(alpha===undefined){alpha=(rgba[3]!==undefined?rgba[3]:1);}
return"rgba("+rgba[0]+", "+rgba[1]+", "+rgba[2]
+", "+alpha+")";}
function percentString(rgba,alpha){if(alpha<1||(rgba[3]&&rgba[3]<1)){return percentaString(rgba,alpha);}
var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgb("+r+"%, "+g+"%, "+b+"%)";}
function percentaString(rgba,alpha){var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgba("+r+"%, "+g+"%, "+b+"%, "+(alpha||rgba[3]||1)+")";}
function hslString(hsla,alpha){if(alpha<1||(hsla[3]&&hsla[3]<1)){return hslaString(hsla,alpha);}
return"hsl("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%)";}
function hslaString(hsla,alpha){if(alpha===undefined){alpha=(hsla[3]!==undefined?hsla[3]:1);}
return"hsla("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%, "
+alpha+")";}
function hwbString(hwb,alpha){if(alpha===undefined){alpha=(hwb[3]!==undefined?hwb[3]:1);}
return"hwb("+hwb[0]+", "+hwb[1]+"%, "+hwb[2]+"%"
+(alpha!==undefined&&alpha!==1?", "+alpha:"")+")";}
function keyword(rgb){return reverseNames[rgb.slice(0,3)];}
function scale(num,min,max){return Math.min(Math.max(min,num),max);}
function hexDouble(num){var str=num.toString(16).toUpperCase();return(str.length<2)?"0"+str:str;}
var reverseNames={};for(var name in colorNames){reverseNames[colorNames[name]]=name;}},{"5":5}],2:[function(require,module,exports){var convert=require(4);var string=require(1);var Color=function(obj){if(obj instanceof Color){return obj;}
if(!(this instanceof Color)){return new Color(obj);}
this.valid=false;this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1};var vals;if(typeof obj==='string'){vals=string.getRgba(obj);if(vals){this.setValues('rgb',vals);}else if(vals=string.getHsla(obj)){this.setValues('hsl',vals);}else if(vals=string.getHwb(obj)){this.setValues('hwb',vals);}}else if(typeof obj==='object'){vals=obj;if(vals.r!==undefined||vals.red!==undefined){this.setValues('rgb',vals);}else if(vals.l!==undefined||vals.lightness!==undefined){this.setValues('hsl',vals);}else if(vals.v!==undefined||vals.value!==undefined){this.setValues('hsv',vals);}else if(vals.w!==undefined||vals.whiteness!==undefined){this.setValues('hwb',vals);}else if(vals.c!==undefined||vals.cyan!==undefined){this.setValues('cmyk',vals);}}};Color.prototype={isValid:function(){return this.valid;},rgb:function(){return this.setSpace('rgb',arguments);},hsl:function(){return this.setSpace('hsl',arguments);},hsv:function(){return this.setSpace('hsv',arguments);},hwb:function(){return this.setSpace('hwb',arguments);},cmyk:function(){return this.setSpace('cmyk',arguments);},rgbArray:function(){return this.values.rgb;},hslArray:function(){return this.values.hsl;},hsvArray:function(){return this.values.hsv;},hwbArray:function(){var values=this.values;if(values.alpha!==1){return values.hwb.concat([values.alpha]);}
return values.hwb;},cmykArray:function(){return this.values.cmyk;},rgbaArray:function(){var values=this.values;return values.rgb.concat([values.alpha]);},hslaArray:function(){var values=this.values;return values.hsl.concat([values.alpha]);},alpha:function(val){if(val===undefined){return this.values.alpha;}
this.setValues('alpha',val);return this;},red:function(val){return this.setChannel('rgb',0,val);},green:function(val){return this.setChannel('rgb',1,val);},blue:function(val){return this.setChannel('rgb',2,val);},hue:function(val){if(val){val%=360;val=val<0?360+val:val;}
return this.setChannel('hsl',0,val);},saturation:function(val){return this.setChannel('hsl',1,val);},lightness:function(val){return this.setChannel('hsl',2,val);},saturationv:function(val){return this.setChannel('hsv',1,val);},whiteness:function(val){return this.setChannel('hwb',1,val);},blackness:function(val){return this.setChannel('hwb',2,val);},value:function(val){return this.setChannel('hsv',2,val);},cyan:function(val){return this.setChannel('cmyk',0,val);},magenta:function(val){return this.setChannel('cmyk',1,val);},yellow:function(val){return this.setChannel('cmyk',2,val);},black:function(val){return this.setChannel('cmyk',3,val);},hexString:function(){return string.hexString(this.values.rgb);},rgbString:function(){return string.rgbString(this.values.rgb,this.values.alpha);},rgbaString:function(){return string.rgbaString(this.values.rgb,this.values.alpha);},percentString:function(){return string.percentString(this.values.rgb,this.values.alpha);},hslString:function(){return string.hslString(this.values.hsl,this.values.alpha);},hslaString:function(){return string.hslaString(this.values.hsl,this.values.alpha);},hwbString:function(){return string.hwbString(this.values.hwb,this.values.alpha);},keyword:function(){return string.keyword(this.values.rgb,this.values.alpha);},rgbNumber:function(){var rgb=this.values.rgb;return(rgb[0]<<16)|(rgb[1]<<8)|rgb[2];},luminosity:function(){var rgb=this.values.rgb;var lum=[];for(var i=0;i<rgb.length;i++){var chan=rgb[i]/255;lum[i]=(chan<=0.03928)?chan/12.92:Math.pow(((chan+0.055)/1.055),2.4);}
return 0.2126*lum[0]+0.7152*lum[1]+0.0722*lum[2];},contrast:function(color2){var lum1=this.luminosity();var lum2=color2.luminosity();if(lum1>lum2){return(lum1+0.05)/(lum2+0.05);}
return(lum2+0.05)/(lum1+0.05);},level:function(color2){var contrastRatio=this.contrast(color2);if(contrastRatio>=7.1){return'AAA';}
return(contrastRatio>=4.5)?'AA':'';},dark:function(){var rgb=this.values.rgb;var yiq=(rgb[0]*299+rgb[1]*587+rgb[2]*114)/1000;return yiq<128;},light:function(){return!this.dark();},negate:function(){var rgb=[];for(var i=0;i<3;i++){rgb[i]=255-this.values.rgb[i];}
this.setValues('rgb',rgb);return this;},lighten:function(ratio){var hsl=this.values.hsl;hsl[2]+=hsl[2]*ratio;this.setValues('hsl',hsl);return this;},darken:function(ratio){var hsl=this.values.hsl;hsl[2]-=hsl[2]*ratio;this.setValues('hsl',hsl);return this;},saturate:function(ratio){var hsl=this.values.hsl;hsl[1]+=hsl[1]*ratio;this.setValues('hsl',hsl);return this;},desaturate:function(ratio){var hsl=this.values.hsl;hsl[1]-=hsl[1]*ratio;this.setValues('hsl',hsl);return this;},whiten:function(ratio){var hwb=this.values.hwb;hwb[1]+=hwb[1]*ratio;this.setValues('hwb',hwb);return this;},blacken:function(ratio){var hwb=this.values.hwb;hwb[2]+=hwb[2]*ratio;this.setValues('hwb',hwb);return this;},greyscale:function(){var rgb=this.values.rgb;var val=rgb[0]*0.3+rgb[1]*0.59+rgb[2]*0.11;this.setValues('rgb',[val,val,val]);return this;},clearer:function(ratio){var alpha=this.values.alpha;this.setValues('alpha',alpha-(alpha*ratio));return this;},opaquer:function(ratio){var alpha=this.values.alpha;this.setValues('alpha',alpha+(alpha*ratio));return this;},rotate:function(degrees){var hsl=this.values.hsl;var hue=(hsl[0]+degrees)%360;hsl[0]=hue<0?360+hue:hue;this.setValues('hsl',hsl);return this;},mix:function(mixinColor,weight){var color1=this;var color2=mixinColor;var p=weight===undefined?0.5:weight;var w=2*p-1;var a=color1.alpha()-color2.alpha();var w1=(((w*a===-1)?w:(w+a)/(1+w*a))+1)/2.0;var w2=1-w1;return this.rgb(w1*color1.red()+w2*color2.red(),w1*color1.green()+w2*color2.green(),w1*color1.blue()+w2*color2.blue()).alpha(color1.alpha()*p+color2.alpha()*(1-p));},toJSON:function(){return this.rgb();},clone:function(){var result=new Color();var source=this.values;var target=result.values;var value,type;for(var prop in source){if(source.hasOwnProperty(prop)){value=source[prop];type=({}).toString.call(value);if(type==='[object Array]'){target[prop]=value.slice(0);}else if(type==='[object Number]'){target[prop]=value;}else{console.error('unexpected color value:',value);}}}
return result;}};Color.prototype.spaces={rgb:['red','green','blue'],hsl:['hue','saturation','lightness'],hsv:['hue','saturation','value'],hwb:['hue','whiteness','blackness'],cmyk:['cyan','magenta','yellow','black']};Color.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]};Color.prototype.getValues=function(space){var values=this.values;var vals={};for(var i=0;i<space.length;i++){vals[space.charAt(i)]=values[space][i];}
if(values.alpha!==1){vals.a=values.alpha;}
return vals;};Color.prototype.setValues=function(space,vals){var values=this.values;var spaces=this.spaces;var maxes=this.maxes;var alpha=1;var i;this.valid=true;if(space==='alpha'){alpha=vals;}else if(vals.length){values[space]=vals.slice(0,space.length);alpha=vals[space.length];}else if(vals[space.charAt(0)]!==undefined){for(i=0;i<space.length;i++){values[space][i]=vals[space.charAt(i)];}
alpha=vals.a;}else if(vals[spaces[space][0]]!==undefined){var chans=spaces[space];for(i=0;i<space.length;i++){values[space][i]=vals[chans[i]];}
alpha=vals.alpha;}
values.alpha=Math.max(0,Math.min(1,(alpha===undefined?values.alpha:alpha)));if(space==='alpha'){return false;}
var capped;for(i=0;i<space.length;i++){capped=Math.max(0,Math.min(maxes[space][i],values[space][i]));values[space][i]=Math.round(capped);}
for(var sname in spaces){if(sname!==space){values[sname]=convert[space][sname](values[space]);}}
return true;};Color.prototype.setSpace=function(space,args){var vals=args[0];if(vals===undefined){return this.getValues(space);}
if(typeof vals==='number'){vals=Array.prototype.slice.call(args);}
this.setValues(space,vals);return this;};Color.prototype.setChannel=function(space,index,val){var svalues=this.values[space];if(val===undefined){return svalues[index];}else if(val===svalues[index]){return this;}
svalues[index]=val;this.setValues(space,svalues);return this;};if(typeof window!=='undefined'){window.Color=Color;}
module.exports=Color;},{"1":1,"4":4}],3:[function(require,module,exports){module.exports={rgb2hsl:rgb2hsl,rgb2hsv:rgb2hsv,rgb2hwb:rgb2hwb,rgb2cmyk:rgb2cmyk,rgb2keyword:rgb2keyword,rgb2xyz:rgb2xyz,rgb2lab:rgb2lab,rgb2lch:rgb2lch,hsl2rgb:hsl2rgb,hsl2hsv:hsl2hsv,hsl2hwb:hsl2hwb,hsl2cmyk:hsl2cmyk,hsl2keyword:hsl2keyword,hsv2rgb:hsv2rgb,hsv2hsl:hsv2hsl,hsv2hwb:hsv2hwb,hsv2cmyk:hsv2cmyk,hsv2keyword:hsv2keyword,hwb2rgb:hwb2rgb,hwb2hsl:hwb2hsl,hwb2hsv:hwb2hsv,hwb2cmyk:hwb2cmyk,hwb2keyword:hwb2keyword,cmyk2rgb:cmyk2rgb,cmyk2hsl:cmyk2hsl,cmyk2hsv:cmyk2hsv,cmyk2hwb:cmyk2hwb,cmyk2keyword:cmyk2keyword,keyword2rgb:keyword2rgb,keyword2hsl:keyword2hsl,keyword2hsv:keyword2hsv,keyword2hwb:keyword2hwb,keyword2cmyk:keyword2cmyk,keyword2lab:keyword2lab,keyword2xyz:keyword2xyz,xyz2rgb:xyz2rgb,xyz2lab:xyz2lab,xyz2lch:xyz2lch,lab2xyz:lab2xyz,lab2rgb:lab2rgb,lab2lch:lab2lch,lch2lab:lch2lab,lch2xyz:lch2xyz,lch2rgb:lch2rgb}
function rgb2hsl(rgb){var r=rgb[0]/255,g=rgb[1]/255,b=rgb[2]/255,min=Math.min(r,g,b),max=Math.max(r,g,b),delta=max-min,h,s,l;if(max==min)
h=0;else if(r==max)
h=(g-b)/delta;else if(g==max)
h=2+(b-r)/delta;else if(b==max)
h=4+(r-g)/delta;h=Math.min(h*60,360);if(h<0)
h+=360;l=(min+max)/2;if(max==min)
s=0;else if(l<=0.5)
s=delta/(max+min);else
s=delta/(2-max-min);return[h,s*100,l*100];}
function rgb2hsv(rgb){var r=rgb[0],g=rgb[1],b=rgb[2],min=Math.min(r,g,b),max=Math.max(r,g,b),delta=max-min,h,s,v;if(max==0)
s=0;else
s=(delta/max*1000)/10;if(max==min)
h=0;else if(r==max)
h=(g-b)/delta;else if(g==max)
h=2+(b-r)/delta;else if(b==max)
h=4+(r-g)/delta;h=Math.min(h*60,360);if(h<0)
h+=360;v=((max/255)*1000)/10;return[h,s,v];}
function rgb2hwb(rgb){var r=rgb[0],g=rgb[1],b=rgb[2],h=rgb2hsl(rgb)[0],w=1/255*Math.min(r,Math.min(g,b)),b=1-1/255*Math.max(r,Math.max(g,b));return[h,w*100,b*100];}
function rgb2cmyk(rgb){var r=rgb[0]/255,g=rgb[1]/255,b=rgb[2]/255,c,m,y,k;k=Math.min(1-r,1-g,1-b);c=(1-r-k)/(1-k)||0;m=(1-g-k)/(1-k)||0;y=(1-b-k)/(1-k)||0;return[c*100,m*100,y*100,k*100];}
function rgb2keyword(rgb){return reverseKeywords[JSON.stringify(rgb)];}
function rgb2xyz(rgb){var r=rgb[0]/255,g=rgb[1]/255,b=rgb[2]/255;r=r>0.04045?Math.pow(((r+0.055)/1.055),2.4):(r/12.92);g=g>0.04045?Math.pow(((g+0.055)/1.055),2.4):(g/12.92);b=b>0.04045?Math.pow(((b+0.055)/1.055),2.4):(b/12.92);var x=(r*0.4124)+(g*0.3576)+(b*0.1805);var y=(r*0.2126)+(g*0.7152)+(b*0.0722);var z=(r*0.0193)+(g*0.1192)+(b*0.9505);return[x*100,y*100,z*100];}
function rgb2lab(rgb){var xyz=rgb2xyz(rgb),x=xyz[0],y=xyz[1],z=xyz[2],l,a,b;x/=95.047;y/=100;z/=108.883;x=x>0.008856?Math.pow(x,1/3):(7.787*x)+(16/116);y=y>0.008856?Math.pow(y,1/3):(7.787*y)+(16/116);z=z>0.008856?Math.pow(z,1/3):(7.787*z)+(16/116);l=(116*y)-16;a=500*(x-y);b=200*(y-z);return[l,a,b];}
function rgb2lch(args){return lab2lch(rgb2lab(args));}
function hsl2rgb(hsl){var h=hsl[0]/360,s=hsl[1]/100,l=hsl[2]/100,t1,t2,t3,rgb,val;if(s==0){val=l*255;return[val,val,val];}
if(l<0.5)
t2=l*(1+s);else
t2=l+s-l*s;t1=2*l-t2;rgb=[0,0,0];for(var i=0;i<3;i++){t3=h+1/3*-(i-1);t3<0&&t3++;t3>1&&t3--;if(6*t3<1)
val=t1+(t2-t1)*6*t3;else if(2*t3<1)
val=t2;else if(3*t3<2)
val=t1+(t2-t1)*(2/3-t3)*6;else
val=t1;rgb[i]=val*255;}
return rgb;}
function hsl2hsv(hsl){var h=hsl[0],s=hsl[1]/100,l=hsl[2]/100,sv,v;if(l===0){return[0,0,0];}
l*=2;s*=(l<=1)?l:2-l;v=(l+s)/2;sv=(2*s)/(l+s);return[h,sv*100,v*100];}
function hsl2hwb(args){return rgb2hwb(hsl2rgb(args));}
function hsl2cmyk(args){return rgb2cmyk(hsl2rgb(args));}
function hsl2keyword(args){return rgb2keyword(hsl2rgb(args));}
function hsv2rgb(hsv){var h=hsv[0]/60,s=hsv[1]/100,v=hsv[2]/100,hi=Math.floor(h)%6;var f=h-Math.floor(h),p=255*v*(1-s),q=255*v*(1-(s*f)),t=255*v*(1-(s*(1-f))),v=255*v;switch(hi){case 0:return[v,t,p];case 1:return[q,v,p];case 2:return[p,v,t];case 3:return[p,q,v];case 4:return[t,p,v];case 5:return[v,p,q];}}
function hsv2hsl(hsv){var h=hsv[0],s=hsv[1]/100,v=hsv[2]/100,sl,l;l=(2-s)*v;sl=s*v;sl/=(l<=1)?l:2-l;sl=sl||0;l/=2;return[h,sl*100,l*100];}
function hsv2hwb(args){return rgb2hwb(hsv2rgb(args))}
function hsv2cmyk(args){return rgb2cmyk(hsv2rgb(args));}
function hsv2keyword(args){return rgb2keyword(hsv2rgb(args));}
function hwb2rgb(hwb){var h=hwb[0]/360,wh=hwb[1]/100,bl=hwb[2]/100,ratio=wh+bl,i,v,f,n;if(ratio>1){wh/=ratio;bl/=ratio;}
i=Math.floor(6*h);v=1-bl;f=6*h-i;if((i&0x01)!=0){f=1-f;}
n=wh+f*(v-wh);switch(i){default:case 6:case 0:r=v;g=n;b=wh;break;case 1:r=n;g=v;b=wh;break;case 2:r=wh;g=v;b=n;break;case 3:r=wh;g=n;b=v;break;case 4:r=n;g=wh;b=v;break;case 5:r=v;g=wh;b=n;break;}
return[r*255,g*255,b*255];}
function hwb2hsl(args){return rgb2hsl(hwb2rgb(args));}
function hwb2hsv(args){return rgb2hsv(hwb2rgb(args));}
function hwb2cmyk(args){return rgb2cmyk(hwb2rgb(args));}
function hwb2keyword(args){return rgb2keyword(hwb2rgb(args));}
function cmyk2rgb(cmyk){var c=cmyk[0]/100,m=cmyk[1]/100,y=cmyk[2]/100,k=cmyk[3]/100,r,g,b;r=1-Math.min(1,c*(1-k)+k);g=1-Math.min(1,m*(1-k)+k);b=1-Math.min(1,y*(1-k)+k);return[r*255,g*255,b*255];}
function cmyk2hsl(args){return rgb2hsl(cmyk2rgb(args));}
function cmyk2hsv(args){return rgb2hsv(cmyk2rgb(args));}
function cmyk2hwb(args){return rgb2hwb(cmyk2rgb(args));}
function cmyk2keyword(args){return rgb2keyword(cmyk2rgb(args));}
function xyz2rgb(xyz){var x=xyz[0]/100,y=xyz[1]/100,z=xyz[2]/100,r,g,b;r=(x*3.2406)+(y*-1.5372)+(z*-0.4986);g=(x*-0.9689)+(y*1.8758)+(z*0.0415);b=(x*0.0557)+(y*-0.2040)+(z*1.0570);r=r>0.0031308?((1.055*Math.pow(r,1.0/2.4))-0.055):r=(r*12.92);g=g>0.0031308?((1.055*Math.pow(g,1.0/2.4))-0.055):g=(g*12.92);b=b>0.0031308?((1.055*Math.pow(b,1.0/2.4))-0.055):b=(b*12.92);r=Math.min(Math.max(0,r),1);g=Math.min(Math.max(0,g),1);b=Math.min(Math.max(0,b),1);return[r*255,g*255,b*255];}
function xyz2lab(xyz){var x=xyz[0],y=xyz[1],z=xyz[2],l,a,b;x/=95.047;y/=100;z/=108.883;x=x>0.008856?Math.pow(x,1/3):(7.787*x)+(16/116);y=y>0.008856?Math.pow(y,1/3):(7.787*y)+(16/116);z=z>0.008856?Math.pow(z,1/3):(7.787*z)+(16/116);l=(116*y)-16;a=500*(x-y);b=200*(y-z);return[l,a,b];}
function xyz2lch(args){return lab2lch(xyz2lab(args));}
function lab2xyz(lab){var l=lab[0],a=lab[1],b=lab[2],x,y,z,y2;if(l<=8){y=(l*100)/903.3;y2=(7.787*(y/100))+(16/116);}else{y=100*Math.pow((l+16)/116,3);y2=Math.pow(y/100,1/3);}
x=x/95.047<=0.008856?x=(95.047*((a/500)+y2-(16/116)))/7.787:95.047*Math.pow((a/500)+y2,3);z=z/108.883<=0.008859?z=(108.883*(y2-(b/200)-(16/116)))/7.787:108.883*Math.pow(y2-(b/200),3);return[x,y,z];}
function lab2lch(lab){var l=lab[0],a=lab[1],b=lab[2],hr,h,c;hr=Math.atan2(b,a);h=hr*360/2/Math.PI;if(h<0){h+=360;}
c=Math.sqrt(a*a+b*b);return[l,c,h];}
function lab2rgb(args){return xyz2rgb(lab2xyz(args));}
function lch2lab(lch){var l=lch[0],c=lch[1],h=lch[2],a,b,hr;hr=h/360*2*Math.PI;a=c*Math.cos(hr);b=c*Math.sin(hr);return[l,a,b];}
function lch2xyz(args){return lab2xyz(lch2lab(args));}
function lch2rgb(args){return lab2rgb(lch2lab(args));}
function keyword2rgb(keyword){return cssKeywords[keyword];}
function keyword2hsl(args){return rgb2hsl(keyword2rgb(args));}
function keyword2hsv(args){return rgb2hsv(keyword2rgb(args));}
function keyword2hwb(args){return rgb2hwb(keyword2rgb(args));}
function keyword2cmyk(args){return rgb2cmyk(keyword2rgb(args));}
function keyword2lab(args){return rgb2lab(keyword2rgb(args));}
function keyword2xyz(args){return rgb2xyz(keyword2rgb(args));}
var cssKeywords={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};var reverseKeywords={};for(var key in cssKeywords){reverseKeywords[JSON.stringify(cssKeywords[key])]=key;}},{}],4:[function(require,module,exports){var conversions=require(3);var convert=function(){return new Converter();}
for(var func in conversions){convert[func+"Raw"]=(function(func){return function(arg){if(typeof arg=="number")
arg=Array.prototype.slice.call(arguments);return conversions[func](arg);}})(func);var pair=/(\w+)2(\w+)/.exec(func),from=pair[1],to=pair[2];convert[from]=convert[from]||{};convert[from][to]=convert[func]=(function(func){return function(arg){if(typeof arg=="number")
arg=Array.prototype.slice.call(arguments);var val=conversions[func](arg);if(typeof val=="string"||val===undefined)
return val;for(var i=0;i<val.length;i++)
val[i]=Math.round(val[i]);return val;}})(func);}
var Converter=function(){this.convs={};};Converter.prototype.routeSpace=function(space,args){var values=args[0];if(values===undefined){return this.getValues(space);}
if(typeof values=="number"){values=Array.prototype.slice.call(args);}
return this.setValues(space,values);};Converter.prototype.setValues=function(space,values){this.space=space;this.convs={};this.convs[space]=values;return this;};Converter.prototype.getValues=function(space){var vals=this.convs[space];if(!vals){var fspace=this.space,from=this.convs[fspace];vals=convert[fspace][space](from);this.convs[space]=vals;}
return vals;};["rgb","hsl","hsv","cmyk","keyword"].forEach(function(space){Converter.prototype[space]=function(vals){return this.routeSpace(space,arguments);}});module.exports=convert;},{"3":3}],5:[function(require,module,exports){'use strict'
module.exports={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]};},{}],6:[function(require,module,exports){;(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory():typeof define==='function'&&define.amd?define(factory):global.moment=factory()}(this,(function(){'use strict';var hookCallback;function hooks(){return hookCallback.apply(null,arguments);}
function setHookCallback(callback){hookCallback=callback;}
function isArray(input){return input instanceof Array||Object.prototype.toString.call(input)==='[object Array]';}
function isObject(input){return input!=null&&Object.prototype.toString.call(input)==='[object Object]';}
function isObjectEmpty(obj){if(Object.getOwnPropertyNames){return(Object.getOwnPropertyNames(obj).length===0);}else{var k;for(k in obj){if(obj.hasOwnProperty(k)){return false;}}
return true;}}
function isUndefined(input){return input===void 0;}
function isNumber(input){return typeof input==='number'||Object.prototype.toString.call(input)==='[object Number]';}
function isDate(input){return input instanceof Date||Object.prototype.toString.call(input)==='[object Date]';}
function map(arr,fn){var res=[],i;for(i=0;i<arr.length;++i){res.push(fn(arr[i],i));}
return res;}
function hasOwnProp(a,b){return Object.prototype.hasOwnProperty.call(a,b);}
function extend(a,b){for(var i in b){if(hasOwnProp(b,i)){a[i]=b[i];}}
if(hasOwnProp(b,'toString')){a.toString=b.toString;}
if(hasOwnProp(b,'valueOf')){a.valueOf=b.valueOf;}
return a;}
function createUTC(input,format,locale,strict){return createLocalOrUTC(input,format,locale,strict,true).utc();}
function defaultParsingFlags(){return{empty:false,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:false,invalidMonth:null,invalidFormat:false,userInvalidated:false,iso:false,parsedDateParts:[],meridiem:null,rfc2822:false,weekdayMismatch:false};}
function getParsingFlags(m){if(m._pf==null){m._pf=defaultParsingFlags();}
return m._pf;}
var some;if(Array.prototype.some){some=Array.prototype.some;}else{some=function(fun){var t=Object(this);var len=t.length>>>0;for(var i=0;i<len;i++){if(i in t&&fun.call(this,t[i],i,t)){return true;}}
return false;};}
function isValid(m){if(m._isValid==null){var flags=getParsingFlags(m);var parsedParts=some.call(flags.parsedDateParts,function(i){return i!=null;});var isNowValid=!isNaN(m._d.getTime())&&flags.overflow<0&&!flags.empty&&!flags.invalidMonth&&!flags.invalidWeekday&&!flags.weekdayMismatch&&!flags.nullInput&&!flags.invalidFormat&&!flags.userInvalidated&&(!flags.meridiem||(flags.meridiem&&parsedParts));if(m._strict){isNowValid=isNowValid&&flags.charsLeftOver===0&&flags.unusedTokens.length===0&&flags.bigHour===undefined;}
if(Object.isFrozen==null||!Object.isFrozen(m)){m._isValid=isNowValid;}
else{return isNowValid;}}
return m._isValid;}
function createInvalid(flags){var m=createUTC(NaN);if(flags!=null){extend(getParsingFlags(m),flags);}
else{getParsingFlags(m).userInvalidated=true;}
return m;}
var momentProperties=hooks.momentProperties=[];function copyConfig(to,from){var i,prop,val;if(!isUndefined(from._isAMomentObject)){to._isAMomentObject=from._isAMomentObject;}
if(!isUndefined(from._i)){to._i=from._i;}
if(!isUndefined(from._f)){to._f=from._f;}
if(!isUndefined(from._l)){to._l=from._l;}
if(!isUndefined(from._strict)){to._strict=from._strict;}
if(!isUndefined(from._tzm)){to._tzm=from._tzm;}
if(!isUndefined(from._isUTC)){to._isUTC=from._isUTC;}
if(!isUndefined(from._offset)){to._offset=from._offset;}
if(!isUndefined(from._pf)){to._pf=getParsingFlags(from);}
if(!isUndefined(from._locale)){to._locale=from._locale;}
if(momentProperties.length>0){for(i=0;i<momentProperties.length;i++){prop=momentProperties[i];val=from[prop];if(!isUndefined(val)){to[prop]=val;}}}
return to;}
var updateInProgress=false;function Moment(config){copyConfig(this,config);this._d=new Date(config._d!=null?config._d.getTime():NaN);if(!this.isValid()){this._d=new Date(NaN);}
if(updateInProgress===false){updateInProgress=true;hooks.updateOffset(this);updateInProgress=false;}}
function isMoment(obj){return obj instanceof Moment||(obj!=null&&obj._isAMomentObject!=null);}
function absFloor(number){if(number<0){return Math.ceil(number)||0;}else{return Math.floor(number);}}
function toInt(argumentForCoercion){var coercedNumber=+argumentForCoercion,value=0;if(coercedNumber!==0&&isFinite(coercedNumber)){value=absFloor(coercedNumber);}
return value;}
function compareArrays(array1,array2,dontConvert){var len=Math.min(array1.length,array2.length),lengthDiff=Math.abs(array1.length-array2.length),diffs=0,i;for(i=0;i<len;i++){if((dontConvert&&array1[i]!==array2[i])||(!dontConvert&&toInt(array1[i])!==toInt(array2[i]))){diffs++;}}
return diffs+lengthDiff;}
function warn(msg){if(hooks.suppressDeprecationWarnings===false&&(typeof console!=='undefined')&&console.warn){console.warn('Deprecation warning: '+msg);}}
function deprecate(msg,fn){var firstTime=true;return extend(function(){if(hooks.deprecationHandler!=null){hooks.deprecationHandler(null,msg);}
if(firstTime){var args=[];var arg;for(var i=0;i<arguments.length;i++){arg='';if(typeof arguments[i]==='object'){arg+='\n['+i+'] ';for(var key in arguments[0]){arg+=key+': '+arguments[0][key]+', ';}
arg=arg.slice(0,-2);}else{arg=arguments[i];}
args.push(arg);}
warn(msg+'\nArguments: '+Array.prototype.slice.call(args).join('')+'\n'+(new Error()).stack);firstTime=false;}
return fn.apply(this,arguments);},fn);}
var deprecations={};function deprecateSimple(name,msg){if(hooks.deprecationHandler!=null){hooks.deprecationHandler(name,msg);}
if(!deprecations[name]){warn(msg);deprecations[name]=true;}}
hooks.suppressDeprecationWarnings=false;hooks.deprecationHandler=null;function isFunction(input){return input instanceof Function||Object.prototype.toString.call(input)==='[object Function]';}
function set(config){var prop,i;for(i in config){prop=config[i];if(isFunction(prop)){this[i]=prop;}else{this['_'+i]=prop;}}
this._config=config;this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+'|'+(/\d{1,2}/).source);}
function mergeConfigs(parentConfig,childConfig){var res=extend({},parentConfig),prop;for(prop in childConfig){if(hasOwnProp(childConfig,prop)){if(isObject(parentConfig[prop])&&isObject(childConfig[prop])){res[prop]={};extend(res[prop],parentConfig[prop]);extend(res[prop],childConfig[prop]);}else if(childConfig[prop]!=null){res[prop]=childConfig[prop];}else{delete res[prop];}}}
for(prop in parentConfig){if(hasOwnProp(parentConfig,prop)&&!hasOwnProp(childConfig,prop)&&isObject(parentConfig[prop])){res[prop]=extend({},res[prop]);}}
return res;}
function Locale(config){if(config!=null){this.set(config);}}
var keys;if(Object.keys){keys=Object.keys;}else{keys=function(obj){var i,res=[];for(i in obj){if(hasOwnProp(obj,i)){res.push(i);}}
return res;};}
var defaultCalendar={sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'};function calendar(key,mom,now){var output=this._calendar[key]||this._calendar['sameElse'];return isFunction(output)?output.call(mom,now):output;}
var defaultLongDateFormat={LTS:'h:mm:ss A',LT:'h:mm A',L:'MM/DD/YYYY',LL:'MMMM D, YYYY',LLL:'MMMM D, YYYY h:mm A',LLLL:'dddd, MMMM D, YYYY h:mm A'};function longDateFormat(key){var format=this._longDateFormat[key],formatUpper=this._longDateFormat[key.toUpperCase()];if(format||!formatUpper){return format;}
this._longDateFormat[key]=formatUpper.replace(/MMMM|MM|DD|dddd/g,function(val){return val.slice(1);});return this._longDateFormat[key];}
var defaultInvalidDate='Invalid date';function invalidDate(){return this._invalidDate;}
var defaultOrdinal='%d';var defaultDayOfMonthOrdinalParse=/\d{1,2}/;function ordinal(number){return this._ordinal.replace('%d',number);}
var defaultRelativeTime={future:'in %s',past:'%s ago',s:'a few seconds',ss:'%d seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'};function relativeTime(number,withoutSuffix,string,isFuture){var output=this._relativeTime[string];return(isFunction(output))?output(number,withoutSuffix,string,isFuture):output.replace(/%d/i,number);}
function pastFuture(diff,output){var format=this._relativeTime[diff>0?'future':'past'];return isFunction(format)?format(output):format.replace(/%s/i,output);}
var aliases={};function addUnitAlias(unit,shorthand){var lowerCase=unit.toLowerCase();aliases[lowerCase]=aliases[lowerCase+'s']=aliases[shorthand]=unit;}
function normalizeUnits(units){return typeof units==='string'?aliases[units]||aliases[units.toLowerCase()]:undefined;}
function normalizeObjectUnits(inputObject){var normalizedInput={},normalizedProp,prop;for(prop in inputObject){if(hasOwnProp(inputObject,prop)){normalizedProp=normalizeUnits(prop);if(normalizedProp){normalizedInput[normalizedProp]=inputObject[prop];}}}
return normalizedInput;}
var priorities={};function addUnitPriority(unit,priority){priorities[unit]=priority;}
function getPrioritizedUnits(unitsObj){var units=[];for(var u in unitsObj){units.push({unit:u,priority:priorities[u]});}
units.sort(function(a,b){return a.priority-b.priority;});return units;}
function zeroFill(number,targetLength,forceSign){var absNumber=''+Math.abs(number),zerosToFill=targetLength-absNumber.length,sign=number>=0;return(sign?(forceSign?'+':''):'-')+
Math.pow(10,Math.max(0,zerosToFill)).toString().substr(1)+absNumber;}
var formattingTokens=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;var localFormattingTokens=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;var formatFunctions={};var formatTokenFunctions={};function addFormatToken(token,padded,ordinal,callback){var func=callback;if(typeof callback==='string'){func=function(){return this[callback]();};}
if(token){formatTokenFunctions[token]=func;}
if(padded){formatTokenFunctions[padded[0]]=function(){return zeroFill(func.apply(this,arguments),padded[1],padded[2]);};}
if(ordinal){formatTokenFunctions[ordinal]=function(){return this.localeData().ordinal(func.apply(this,arguments),token);};}}
function removeFormattingTokens(input){if(input.match(/\[[\s\S]/)){return input.replace(/^\[|\]$/g,'');}
return input.replace(/\\/g,'');}
function makeFormatFunction(format){var array=format.match(formattingTokens),i,length;for(i=0,length=array.length;i<length;i++){if(formatTokenFunctions[array[i]]){array[i]=formatTokenFunctions[array[i]];}else{array[i]=removeFormattingTokens(array[i]);}}
return function(mom){var output='',i;for(i=0;i<length;i++){output+=isFunction(array[i])?array[i].call(mom,format):array[i];}
return output;};}
function formatMoment(m,format){if(!m.isValid()){return m.localeData().invalidDate();}
format=expandFormat(format,m.localeData());formatFunctions[format]=formatFunctions[format]||makeFormatFunction(format);return formatFunctions[format](m);}
function expandFormat(format,locale){var i=5;function replaceLongDateFormatTokens(input){return locale.longDateFormat(input)||input;}
localFormattingTokens.lastIndex=0;while(i>=0&&localFormattingTokens.test(format)){format=format.replace(localFormattingTokens,replaceLongDateFormatTokens);localFormattingTokens.lastIndex=0;i-=1;}
return format;}
var match1=/\d/;var match2=/\d\d/;var match3=/\d{3}/;var match4=/\d{4}/;var match6=/[+-]?\d{6}/;var match1to2=/\d\d?/;var match3to4=/\d\d\d\d?/;var match5to6=/\d\d\d\d\d\d?/;var match1to3=/\d{1,3}/;var match1to4=/\d{1,4}/;var match1to6=/[+-]?\d{1,6}/;var matchUnsigned=/\d+/;var matchSigned=/[+-]?\d+/;var matchOffset=/Z|[+-]\d\d:?\d\d/gi;var matchShortOffset=/Z|[+-]\d\d(?::?\d\d)?/gi;var matchTimestamp=/[+-]?\d+(\.\d{1,3})?/;var matchWord=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i;var regexes={};function addRegexToken(token,regex,strictRegex){regexes[token]=isFunction(regex)?regex:function(isStrict,localeData){return(isStrict&&strictRegex)?strictRegex:regex;};}
function getParseRegexForToken(token,config){if(!hasOwnProp(regexes,token)){return new RegExp(unescapeFormat(token));}
return regexes[token](config._strict,config._locale);}
function unescapeFormat(s){return regexEscape(s.replace('\\','').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(matched,p1,p2,p3,p4){return p1||p2||p3||p4;}));}
function regexEscape(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');}
var tokens={};function addParseToken(token,callback){var i,func=callback;if(typeof token==='string'){token=[token];}
if(isNumber(callback)){func=function(input,array){array[callback]=toInt(input);};}
for(i=0;i<token.length;i++){tokens[token[i]]=func;}}
function addWeekParseToken(token,callback){addParseToken(token,function(input,array,config,token){config._w=config._w||{};callback(input,config._w,config,token);});}
function addTimeToArrayFromToken(token,input,config){if(input!=null&&hasOwnProp(tokens,token)){tokens[token](input,config._a,config,token);}}
var YEAR=0;var MONTH=1;var DATE=2;var HOUR=3;var MINUTE=4;var SECOND=5;var MILLISECOND=6;var WEEK=7;var WEEKDAY=8;addFormatToken('Y',0,0,function(){var y=this.year();return y<=9999?''+y:'+'+y;});addFormatToken(0,['YY',2],0,function(){return this.year()%100;});addFormatToken(0,['YYYY',4],0,'year');addFormatToken(0,['YYYYY',5],0,'year');addFormatToken(0,['YYYYYY',6,true],0,'year');addUnitAlias('year','y');addUnitPriority('year',1);addRegexToken('Y',matchSigned);addRegexToken('YY',match1to2,match2);addRegexToken('YYYY',match1to4,match4);addRegexToken('YYYYY',match1to6,match6);addRegexToken('YYYYYY',match1to6,match6);addParseToken(['YYYYY','YYYYYY'],YEAR);addParseToken('YYYY',function(input,array){array[YEAR]=input.length===2?hooks.parseTwoDigitYear(input):toInt(input);});addParseToken('YY',function(input,array){array[YEAR]=hooks.parseTwoDigitYear(input);});addParseToken('Y',function(input,array){array[YEAR]=parseInt(input,10);});function daysInYear(year){return isLeapYear(year)?366:365;}
function isLeapYear(year){return(year%4===0&&year%100!==0)||year%400===0;}
hooks.parseTwoDigitYear=function(input){return toInt(input)+(toInt(input)>68?1900:2000);};var getSetYear=makeGetSet('FullYear',true);function getIsLeapYear(){return isLeapYear(this.year());}
function makeGetSet(unit,keepTime){return function(value){if(value!=null){set$1(this,unit,value);hooks.updateOffset(this,keepTime);return this;}else{return get(this,unit);}};}
function get(mom,unit){return mom.isValid()?mom._d['get'+(mom._isUTC?'UTC':'')+unit]():NaN;}
function set$1(mom,unit,value){if(mom.isValid()&&!isNaN(value)){if(unit==='FullYear'&&isLeapYear(mom.year())&&mom.month()===1&&mom.date()===29){mom._d['set'+(mom._isUTC?'UTC':'')+unit](value,mom.month(),daysInMonth(value,mom.month()));}
else{mom._d['set'+(mom._isUTC?'UTC':'')+unit](value);}}}
function stringGet(units){units=normalizeUnits(units);if(isFunction(this[units])){return this[units]();}
return this;}
function stringSet(units,value){if(typeof units==='object'){units=normalizeObjectUnits(units);var prioritized=getPrioritizedUnits(units);for(var i=0;i<prioritized.length;i++){this[prioritized[i].unit](units[prioritized[i].unit]);}}else{units=normalizeUnits(units);if(isFunction(this[units])){return this[units](value);}}
return this;}
function mod(n,x){return((n%x)+x)%x;}
var indexOf;if(Array.prototype.indexOf){indexOf=Array.prototype.indexOf;}else{indexOf=function(o){var i;for(i=0;i<this.length;++i){if(this[i]===o){return i;}}
return-1;};}
function daysInMonth(year,month){if(isNaN(year)||isNaN(month)){return NaN;}
var modMonth=mod(month,12);year+=(month-modMonth)/12;return modMonth===1?(isLeapYear(year)?29:28):(31-modMonth%7%2);}
addFormatToken('M',['MM',2],'Mo',function(){return this.month()+1;});addFormatToken('MMM',0,0,function(format){return this.localeData().monthsShort(this,format);});addFormatToken('MMMM',0,0,function(format){return this.localeData().months(this,format);});addUnitAlias('month','M');addUnitPriority('month',8);addRegexToken('M',match1to2);addRegexToken('MM',match1to2,match2);addRegexToken('MMM',function(isStrict,locale){return locale.monthsShortRegex(isStrict);});addRegexToken('MMMM',function(isStrict,locale){return locale.monthsRegex(isStrict);});addParseToken(['M','MM'],function(input,array){array[MONTH]=toInt(input)-1;});addParseToken(['MMM','MMMM'],function(input,array,config,token){var month=config._locale.monthsParse(input,token,config._strict);if(month!=null){array[MONTH]=month;}else{getParsingFlags(config).invalidMonth=input;}});var MONTHS_IN_FORMAT=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;var defaultLocaleMonths='January_February_March_April_May_June_July_August_September_October_November_December'.split('_');function localeMonths(m,format){if(!m){return isArray(this._months)?this._months:this._months['standalone'];}
return isArray(this._months)?this._months[m.month()]:this._months[(this._months.isFormat||MONTHS_IN_FORMAT).test(format)?'format':'standalone'][m.month()];}
var defaultLocaleMonthsShort='Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');function localeMonthsShort(m,format){if(!m){return isArray(this._monthsShort)?this._monthsShort:this._monthsShort['standalone'];}
return isArray(this._monthsShort)?this._monthsShort[m.month()]:this._monthsShort[MONTHS_IN_FORMAT.test(format)?'format':'standalone'][m.month()];}
function handleStrictParse(monthName,format,strict){var i,ii,mom,llc=monthName.toLocaleLowerCase();if(!this._monthsParse){this._monthsParse=[];this._longMonthsParse=[];this._shortMonthsParse=[];for(i=0;i<12;++i){mom=createUTC([2000,i]);this._shortMonthsParse[i]=this.monthsShort(mom,'').toLocaleLowerCase();this._longMonthsParse[i]=this.months(mom,'').toLocaleLowerCase();}}
if(strict){if(format==='MMM'){ii=indexOf.call(this._shortMonthsParse,llc);return ii!==-1?ii:null;}else{ii=indexOf.call(this._longMonthsParse,llc);return ii!==-1?ii:null;}}else{if(format==='MMM'){ii=indexOf.call(this._shortMonthsParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._longMonthsParse,llc);return ii!==-1?ii:null;}else{ii=indexOf.call(this._longMonthsParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._shortMonthsParse,llc);return ii!==-1?ii:null;}}}
function localeMonthsParse(monthName,format,strict){var i,mom,regex;if(this._monthsParseExact){return handleStrictParse.call(this,monthName,format,strict);}
if(!this._monthsParse){this._monthsParse=[];this._longMonthsParse=[];this._shortMonthsParse=[];}
for(i=0;i<12;i++){mom=createUTC([2000,i]);if(strict&&!this._longMonthsParse[i]){this._longMonthsParse[i]=new RegExp('^'+this.months(mom,'').replace('.','')+'$','i');this._shortMonthsParse[i]=new RegExp('^'+this.monthsShort(mom,'').replace('.','')+'$','i');}
if(!strict&&!this._monthsParse[i]){regex='^'+this.months(mom,'')+'|^'+this.monthsShort(mom,'');this._monthsParse[i]=new RegExp(regex.replace('.',''),'i');}
if(strict&&format==='MMMM'&&this._longMonthsParse[i].test(monthName)){return i;}else if(strict&&format==='MMM'&&this._shortMonthsParse[i].test(monthName)){return i;}else if(!strict&&this._monthsParse[i].test(monthName)){return i;}}}
function setMonth(mom,value){var dayOfMonth;if(!mom.isValid()){return mom;}
if(typeof value==='string'){if(/^\d+$/.test(value)){value=toInt(value);}else{value=mom.localeData().monthsParse(value);if(!isNumber(value)){return mom;}}}
dayOfMonth=Math.min(mom.date(),daysInMonth(mom.year(),value));mom._d['set'+(mom._isUTC?'UTC':'')+'Month'](value,dayOfMonth);return mom;}
function getSetMonth(value){if(value!=null){setMonth(this,value);hooks.updateOffset(this,true);return this;}else{return get(this,'Month');}}
function getDaysInMonth(){return daysInMonth(this.year(),this.month());}
var defaultMonthsShortRegex=matchWord;function monthsShortRegex(isStrict){if(this._monthsParseExact){if(!hasOwnProp(this,'_monthsRegex')){computeMonthsParse.call(this);}
if(isStrict){return this._monthsShortStrictRegex;}else{return this._monthsShortRegex;}}else{if(!hasOwnProp(this,'_monthsShortRegex')){this._monthsShortRegex=defaultMonthsShortRegex;}
return this._monthsShortStrictRegex&&isStrict?this._monthsShortStrictRegex:this._monthsShortRegex;}}
var defaultMonthsRegex=matchWord;function monthsRegex(isStrict){if(this._monthsParseExact){if(!hasOwnProp(this,'_monthsRegex')){computeMonthsParse.call(this);}
if(isStrict){return this._monthsStrictRegex;}else{return this._monthsRegex;}}else{if(!hasOwnProp(this,'_monthsRegex')){this._monthsRegex=defaultMonthsRegex;}
return this._monthsStrictRegex&&isStrict?this._monthsStrictRegex:this._monthsRegex;}}
function computeMonthsParse(){function cmpLenRev(a,b){return b.length-a.length;}
var shortPieces=[],longPieces=[],mixedPieces=[],i,mom;for(i=0;i<12;i++){mom=createUTC([2000,i]);shortPieces.push(this.monthsShort(mom,''));longPieces.push(this.months(mom,''));mixedPieces.push(this.months(mom,''));mixedPieces.push(this.monthsShort(mom,''));}
shortPieces.sort(cmpLenRev);longPieces.sort(cmpLenRev);mixedPieces.sort(cmpLenRev);for(i=0;i<12;i++){shortPieces[i]=regexEscape(shortPieces[i]);longPieces[i]=regexEscape(longPieces[i]);}
for(i=0;i<24;i++){mixedPieces[i]=regexEscape(mixedPieces[i]);}
this._monthsRegex=new RegExp('^('+mixedPieces.join('|')+')','i');this._monthsShortRegex=this._monthsRegex;this._monthsStrictRegex=new RegExp('^('+longPieces.join('|')+')','i');this._monthsShortStrictRegex=new RegExp('^('+shortPieces.join('|')+')','i');}
function createDate(y,m,d,h,M,s,ms){var date=new Date(y,m,d,h,M,s,ms);if(y<100&&y>=0&&isFinite(date.getFullYear())){date.setFullYear(y);}
return date;}
function createUTCDate(y){var date=new Date(Date.UTC.apply(null,arguments));if(y<100&&y>=0&&isFinite(date.getUTCFullYear())){date.setUTCFullYear(y);}
return date;}
function firstWeekOffset(year,dow,doy){var
fwd=7+dow-doy,fwdlw=(7+createUTCDate(year,0,fwd).getUTCDay()-dow)%7;return-fwdlw+fwd-1;}
function dayOfYearFromWeeks(year,week,weekday,dow,doy){var localWeekday=(7+weekday-dow)%7,weekOffset=firstWeekOffset(year,dow,doy),dayOfYear=1+7*(week-1)+localWeekday+weekOffset,resYear,resDayOfYear;if(dayOfYear<=0){resYear=year-1;resDayOfYear=daysInYear(resYear)+dayOfYear;}else if(dayOfYear>daysInYear(year)){resYear=year+1;resDayOfYear=dayOfYear-daysInYear(year);}else{resYear=year;resDayOfYear=dayOfYear;}
return{year:resYear,dayOfYear:resDayOfYear};}
function weekOfYear(mom,dow,doy){var weekOffset=firstWeekOffset(mom.year(),dow,doy),week=Math.floor((mom.dayOfYear()-weekOffset-1)/7)+1,resWeek,resYear;if(week<1){resYear=mom.year()-1;resWeek=week+weeksInYear(resYear,dow,doy);}else if(week>weeksInYear(mom.year(),dow,doy)){resWeek=week-weeksInYear(mom.year(),dow,doy);resYear=mom.year()+1;}else{resYear=mom.year();resWeek=week;}
return{week:resWeek,year:resYear};}
function weeksInYear(year,dow,doy){var weekOffset=firstWeekOffset(year,dow,doy),weekOffsetNext=firstWeekOffset(year+1,dow,doy);return(daysInYear(year)-weekOffset+weekOffsetNext)/7;}
addFormatToken('w',['ww',2],'wo','week');addFormatToken('W',['WW',2],'Wo','isoWeek');addUnitAlias('week','w');addUnitAlias('isoWeek','W');addUnitPriority('week',5);addUnitPriority('isoWeek',5);addRegexToken('w',match1to2);addRegexToken('ww',match1to2,match2);addRegexToken('W',match1to2);addRegexToken('WW',match1to2,match2);addWeekParseToken(['w','ww','W','WW'],function(input,week,config,token){week[token.substr(0,1)]=toInt(input);});function localeWeek(mom){return weekOfYear(mom,this._week.dow,this._week.doy).week;}
var defaultLocaleWeek={dow:0,doy:6};function localeFirstDayOfWeek(){return this._week.dow;}
function localeFirstDayOfYear(){return this._week.doy;}
function getSetWeek(input){var week=this.localeData().week(this);return input==null?week:this.add((input-week)*7,'d');}
function getSetISOWeek(input){var week=weekOfYear(this,1,4).week;return input==null?week:this.add((input-week)*7,'d');}
addFormatToken('d',0,'do','day');addFormatToken('dd',0,0,function(format){return this.localeData().weekdaysMin(this,format);});addFormatToken('ddd',0,0,function(format){return this.localeData().weekdaysShort(this,format);});addFormatToken('dddd',0,0,function(format){return this.localeData().weekdays(this,format);});addFormatToken('e',0,0,'weekday');addFormatToken('E',0,0,'isoWeekday');addUnitAlias('day','d');addUnitAlias('weekday','e');addUnitAlias('isoWeekday','E');addUnitPriority('day',11);addUnitPriority('weekday',11);addUnitPriority('isoWeekday',11);addRegexToken('d',match1to2);addRegexToken('e',match1to2);addRegexToken('E',match1to2);addRegexToken('dd',function(isStrict,locale){return locale.weekdaysMinRegex(isStrict);});addRegexToken('ddd',function(isStrict,locale){return locale.weekdaysShortRegex(isStrict);});addRegexToken('dddd',function(isStrict,locale){return locale.weekdaysRegex(isStrict);});addWeekParseToken(['dd','ddd','dddd'],function(input,week,config,token){var weekday=config._locale.weekdaysParse(input,token,config._strict);if(weekday!=null){week.d=weekday;}else{getParsingFlags(config).invalidWeekday=input;}});addWeekParseToken(['d','e','E'],function(input,week,config,token){week[token]=toInt(input);});function parseWeekday(input,locale){if(typeof input!=='string'){return input;}
if(!isNaN(input)){return parseInt(input,10);}
input=locale.weekdaysParse(input);if(typeof input==='number'){return input;}
return null;}
function parseIsoWeekday(input,locale){if(typeof input==='string'){return locale.weekdaysParse(input)%7||7;}
return isNaN(input)?null:input;}
var defaultLocaleWeekdays='Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');function localeWeekdays(m,format){if(!m){return isArray(this._weekdays)?this._weekdays:this._weekdays['standalone'];}
return isArray(this._weekdays)?this._weekdays[m.day()]:this._weekdays[this._weekdays.isFormat.test(format)?'format':'standalone'][m.day()];}
var defaultLocaleWeekdaysShort='Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');function localeWeekdaysShort(m){return(m)?this._weekdaysShort[m.day()]:this._weekdaysShort;}
var defaultLocaleWeekdaysMin='Su_Mo_Tu_We_Th_Fr_Sa'.split('_');function localeWeekdaysMin(m){return(m)?this._weekdaysMin[m.day()]:this._weekdaysMin;}
function handleStrictParse$1(weekdayName,format,strict){var i,ii,mom,llc=weekdayName.toLocaleLowerCase();if(!this._weekdaysParse){this._weekdaysParse=[];this._shortWeekdaysParse=[];this._minWeekdaysParse=[];for(i=0;i<7;++i){mom=createUTC([2000,1]).day(i);this._minWeekdaysParse[i]=this.weekdaysMin(mom,'').toLocaleLowerCase();this._shortWeekdaysParse[i]=this.weekdaysShort(mom,'').toLocaleLowerCase();this._weekdaysParse[i]=this.weekdays(mom,'').toLocaleLowerCase();}}
if(strict){if(format==='dddd'){ii=indexOf.call(this._weekdaysParse,llc);return ii!==-1?ii:null;}else if(format==='ddd'){ii=indexOf.call(this._shortWeekdaysParse,llc);return ii!==-1?ii:null;}else{ii=indexOf.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null;}}else{if(format==='dddd'){ii=indexOf.call(this._weekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._shortWeekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null;}else if(format==='ddd'){ii=indexOf.call(this._shortWeekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._weekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null;}else{ii=indexOf.call(this._minWeekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._weekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._shortWeekdaysParse,llc);return ii!==-1?ii:null;}}}
function localeWeekdaysParse(weekdayName,format,strict){var i,mom,regex;if(this._weekdaysParseExact){return handleStrictParse$1.call(this,weekdayName,format,strict);}
if(!this._weekdaysParse){this._weekdaysParse=[];this._minWeekdaysParse=[];this._shortWeekdaysParse=[];this._fullWeekdaysParse=[];}
for(i=0;i<7;i++){mom=createUTC([2000,1]).day(i);if(strict&&!this._fullWeekdaysParse[i]){this._fullWeekdaysParse[i]=new RegExp('^'+this.weekdays(mom,'').replace('.','\.?')+'$','i');this._shortWeekdaysParse[i]=new RegExp('^'+this.weekdaysShort(mom,'').replace('.','\.?')+'$','i');this._minWeekdaysParse[i]=new RegExp('^'+this.weekdaysMin(mom,'').replace('.','\.?')+'$','i');}
if(!this._weekdaysParse[i]){regex='^'+this.weekdays(mom,'')+'|^'+this.weekdaysShort(mom,'')+'|^'+this.weekdaysMin(mom,'');this._weekdaysParse[i]=new RegExp(regex.replace('.',''),'i');}
if(strict&&format==='dddd'&&this._fullWeekdaysParse[i].test(weekdayName)){return i;}else if(strict&&format==='ddd'&&this._shortWeekdaysParse[i].test(weekdayName)){return i;}else if(strict&&format==='dd'&&this._minWeekdaysParse[i].test(weekdayName)){return i;}else if(!strict&&this._weekdaysParse[i].test(weekdayName)){return i;}}}
function getSetDayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN;}
var day=this._isUTC?this._d.getUTCDay():this._d.getDay();if(input!=null){input=parseWeekday(input,this.localeData());return this.add(input-day,'d');}else{return day;}}
function getSetLocaleDayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN;}
var weekday=(this.day()+7-this.localeData()._week.dow)%7;return input==null?weekday:this.add(input-weekday,'d');}
function getSetISODayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN;}
if(input!=null){var weekday=parseIsoWeekday(input,this.localeData());return this.day(this.day()%7?weekday:weekday-7);}else{return this.day()||7;}}
var defaultWeekdaysRegex=matchWord;function weekdaysRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,'_weekdaysRegex')){computeWeekdaysParse.call(this);}
if(isStrict){return this._weekdaysStrictRegex;}else{return this._weekdaysRegex;}}else{if(!hasOwnProp(this,'_weekdaysRegex')){this._weekdaysRegex=defaultWeekdaysRegex;}
return this._weekdaysStrictRegex&&isStrict?this._weekdaysStrictRegex:this._weekdaysRegex;}}
var defaultWeekdaysShortRegex=matchWord;function weekdaysShortRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,'_weekdaysRegex')){computeWeekdaysParse.call(this);}
if(isStrict){return this._weekdaysShortStrictRegex;}else{return this._weekdaysShortRegex;}}else{if(!hasOwnProp(this,'_weekdaysShortRegex')){this._weekdaysShortRegex=defaultWeekdaysShortRegex;}
return this._weekdaysShortStrictRegex&&isStrict?this._weekdaysShortStrictRegex:this._weekdaysShortRegex;}}
var defaultWeekdaysMinRegex=matchWord;function weekdaysMinRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,'_weekdaysRegex')){computeWeekdaysParse.call(this);}
if(isStrict){return this._weekdaysMinStrictRegex;}else{return this._weekdaysMinRegex;}}else{if(!hasOwnProp(this,'_weekdaysMinRegex')){this._weekdaysMinRegex=defaultWeekdaysMinRegex;}
return this._weekdaysMinStrictRegex&&isStrict?this._weekdaysMinStrictRegex:this._weekdaysMinRegex;}}
function computeWeekdaysParse(){function cmpLenRev(a,b){return b.length-a.length;}
var minPieces=[],shortPieces=[],longPieces=[],mixedPieces=[],i,mom,minp,shortp,longp;for(i=0;i<7;i++){mom=createUTC([2000,1]).day(i);minp=this.weekdaysMin(mom,'');shortp=this.weekdaysShort(mom,'');longp=this.weekdays(mom,'');minPieces.push(minp);shortPieces.push(shortp);longPieces.push(longp);mixedPieces.push(minp);mixedPieces.push(shortp);mixedPieces.push(longp);}
minPieces.sort(cmpLenRev);shortPieces.sort(cmpLenRev);longPieces.sort(cmpLenRev);mixedPieces.sort(cmpLenRev);for(i=0;i<7;i++){shortPieces[i]=regexEscape(shortPieces[i]);longPieces[i]=regexEscape(longPieces[i]);mixedPieces[i]=regexEscape(mixedPieces[i]);}
this._weekdaysRegex=new RegExp('^('+mixedPieces.join('|')+')','i');this._weekdaysShortRegex=this._weekdaysRegex;this._weekdaysMinRegex=this._weekdaysRegex;this._weekdaysStrictRegex=new RegExp('^('+longPieces.join('|')+')','i');this._weekdaysShortStrictRegex=new RegExp('^('+shortPieces.join('|')+')','i');this._weekdaysMinStrictRegex=new RegExp('^('+minPieces.join('|')+')','i');}
function hFormat(){return this.hours()%12||12;}
function kFormat(){return this.hours()||24;}
addFormatToken('H',['HH',2],0,'hour');addFormatToken('h',['hh',2],0,hFormat);addFormatToken('k',['kk',2],0,kFormat);addFormatToken('hmm',0,0,function(){return''+hFormat.apply(this)+zeroFill(this.minutes(),2);});addFormatToken('hmmss',0,0,function(){return''+hFormat.apply(this)+zeroFill(this.minutes(),2)+
zeroFill(this.seconds(),2);});addFormatToken('Hmm',0,0,function(){return''+this.hours()+zeroFill(this.minutes(),2);});addFormatToken('Hmmss',0,0,function(){return''+this.hours()+zeroFill(this.minutes(),2)+
zeroFill(this.seconds(),2);});function meridiem(token,lowercase){addFormatToken(token,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),lowercase);});}
meridiem('a',true);meridiem('A',false);addUnitAlias('hour','h');addUnitPriority('hour',13);function matchMeridiem(isStrict,locale){return locale._meridiemParse;}
addRegexToken('a',matchMeridiem);addRegexToken('A',matchMeridiem);addRegexToken('H',match1to2);addRegexToken('h',match1to2);addRegexToken('k',match1to2);addRegexToken('HH',match1to2,match2);addRegexToken('hh',match1to2,match2);addRegexToken('kk',match1to2,match2);addRegexToken('hmm',match3to4);addRegexToken('hmmss',match5to6);addRegexToken('Hmm',match3to4);addRegexToken('Hmmss',match5to6);addParseToken(['H','HH'],HOUR);addParseToken(['k','kk'],function(input,array,config){var kInput=toInt(input);array[HOUR]=kInput===24?0:kInput;});addParseToken(['a','A'],function(input,array,config){config._isPm=config._locale.isPM(input);config._meridiem=input;});addParseToken(['h','hh'],function(input,array,config){array[HOUR]=toInt(input);getParsingFlags(config).bigHour=true;});addParseToken('hmm',function(input,array,config){var pos=input.length-2;array[HOUR]=toInt(input.substr(0,pos));array[MINUTE]=toInt(input.substr(pos));getParsingFlags(config).bigHour=true;});addParseToken('hmmss',function(input,array,config){var pos1=input.length-4;var pos2=input.length-2;array[HOUR]=toInt(input.substr(0,pos1));array[MINUTE]=toInt(input.substr(pos1,2));array[SECOND]=toInt(input.substr(pos2));getParsingFlags(config).bigHour=true;});addParseToken('Hmm',function(input,array,config){var pos=input.length-2;array[HOUR]=toInt(input.substr(0,pos));array[MINUTE]=toInt(input.substr(pos));});addParseToken('Hmmss',function(input,array,config){var pos1=input.length-4;var pos2=input.length-2;array[HOUR]=toInt(input.substr(0,pos1));array[MINUTE]=toInt(input.substr(pos1,2));array[SECOND]=toInt(input.substr(pos2));});function localeIsPM(input){return((input+'').toLowerCase().charAt(0)==='p');}
var defaultLocaleMeridiemParse=/[ap]\.?m?\.?/i;function localeMeridiem(hours,minutes,isLower){if(hours>11){return isLower?'pm':'PM';}else{return isLower?'am':'AM';}}
var getSetHour=makeGetSet('Hours',true);var baseConfig={calendar:defaultCalendar,longDateFormat:defaultLongDateFormat,invalidDate:defaultInvalidDate,ordinal:defaultOrdinal,dayOfMonthOrdinalParse:defaultDayOfMonthOrdinalParse,relativeTime:defaultRelativeTime,months:defaultLocaleMonths,monthsShort:defaultLocaleMonthsShort,week:defaultLocaleWeek,weekdays:defaultLocaleWeekdays,weekdaysMin:defaultLocaleWeekdaysMin,weekdaysShort:defaultLocaleWeekdaysShort,meridiemParse:defaultLocaleMeridiemParse};var locales={};var localeFamilies={};var globalLocale;function normalizeLocale(key){return key?key.toLowerCase().replace('_','-'):key;}
function chooseLocale(names){var i=0,j,next,locale,split;while(i<names.length){split=normalizeLocale(names[i]).split('-');j=split.length;next=normalizeLocale(names[i+1]);next=next?next.split('-'):null;while(j>0){locale=loadLocale(split.slice(0,j).join('-'));if(locale){return locale;}
if(next&&next.length>=j&&compareArrays(split,next,true)>=j-1){break;}
j--;}
i++;}
return null;}
function loadLocale(name){var oldLocale=null;if(!locales[name]&&(typeof module!=='undefined')&&module&&module.exports){try{oldLocale=globalLocale._abbr;var aliasedRequire=require;aliasedRequire('./locale/'+name);getSetGlobalLocale(oldLocale);}catch(e){}}
return locales[name];}
function getSetGlobalLocale(key,values){var data;if(key){if(isUndefined(values)){data=getLocale(key);}
else{data=defineLocale(key,values);}
if(data){globalLocale=data;}}
return globalLocale._abbr;}
function defineLocale(name,config){if(config!==null){var parentConfig=baseConfig;config.abbr=name;if(locales[name]!=null){deprecateSimple('defineLocaleOverride','use moment.updateLocale(localeName, config) to change '+'an existing locale. moment.defineLocale(localeName, '+'config) should only be used for creating a new locale '+'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');parentConfig=locales[name]._config;}else if(config.parentLocale!=null){if(locales[config.parentLocale]!=null){parentConfig=locales[config.parentLocale]._config;}else{if(!localeFamilies[config.parentLocale]){localeFamilies[config.parentLocale]=[];}
localeFamilies[config.parentLocale].push({name:name,config:config});return null;}}
locales[name]=new Locale(mergeConfigs(parentConfig,config));if(localeFamilies[name]){localeFamilies[name].forEach(function(x){defineLocale(x.name,x.config);});}
getSetGlobalLocale(name);return locales[name];}else{delete locales[name];return null;}}
function updateLocale(name,config){if(config!=null){var locale,tmpLocale,parentConfig=baseConfig;tmpLocale=loadLocale(name);if(tmpLocale!=null){parentConfig=tmpLocale._config;}
config=mergeConfigs(parentConfig,config);locale=new Locale(config);locale.parentLocale=locales[name];locales[name]=locale;getSetGlobalLocale(name);}else{if(locales[name]!=null){if(locales[name].parentLocale!=null){locales[name]=locales[name].parentLocale;}else if(locales[name]!=null){delete locales[name];}}}
return locales[name];}
function getLocale(key){var locale;if(key&&key._locale&&key._locale._abbr){key=key._locale._abbr;}
if(!key){return globalLocale;}
if(!isArray(key)){locale=loadLocale(key);if(locale){return locale;}
key=[key];}
return chooseLocale(key);}
function listLocales(){return keys(locales);}
function checkOverflow(m){var overflow;var a=m._a;if(a&&getParsingFlags(m).overflow===-2){overflow=a[MONTH]<0||a[MONTH]>11?MONTH:a[DATE]<1||a[DATE]>daysInMonth(a[YEAR],a[MONTH])?DATE:a[HOUR]<0||a[HOUR]>24||(a[HOUR]===24&&(a[MINUTE]!==0||a[SECOND]!==0||a[MILLISECOND]!==0))?HOUR:a[MINUTE]<0||a[MINUTE]>59?MINUTE:a[SECOND]<0||a[SECOND]>59?SECOND:a[MILLISECOND]<0||a[MILLISECOND]>999?MILLISECOND:-1;if(getParsingFlags(m)._overflowDayOfYear&&(overflow<YEAR||overflow>DATE)){overflow=DATE;}
if(getParsingFlags(m)._overflowWeeks&&overflow===-1){overflow=WEEK;}
if(getParsingFlags(m)._overflowWeekday&&overflow===-1){overflow=WEEKDAY;}
getParsingFlags(m).overflow=overflow;}
return m;}
function defaults(a,b,c){if(a!=null){return a;}
if(b!=null){return b;}
return c;}
function currentDateArray(config){var nowValue=new Date(hooks.now());if(config._useUTC){return[nowValue.getUTCFullYear(),nowValue.getUTCMonth(),nowValue.getUTCDate()];}
return[nowValue.getFullYear(),nowValue.getMonth(),nowValue.getDate()];}
function configFromArray(config){var i,date,input=[],currentDate,expectedWeekday,yearToUse;if(config._d){return;}
currentDate=currentDateArray(config);if(config._w&&config._a[DATE]==null&&config._a[MONTH]==null){dayOfYearFromWeekInfo(config);}
if(config._dayOfYear!=null){yearToUse=defaults(config._a[YEAR],currentDate[YEAR]);if(config._dayOfYear>daysInYear(yearToUse)||config._dayOfYear===0){getParsingFlags(config)._overflowDayOfYear=true;}
date=createUTCDate(yearToUse,0,config._dayOfYear);config._a[MONTH]=date.getUTCMonth();config._a[DATE]=date.getUTCDate();}
for(i=0;i<3&&config._a[i]==null;++i){config._a[i]=input[i]=currentDate[i];}
for(;i<7;i++){config._a[i]=input[i]=(config._a[i]==null)?(i===2?1:0):config._a[i];}
if(config._a[HOUR]===24&&config._a[MINUTE]===0&&config._a[SECOND]===0&&config._a[MILLISECOND]===0){config._nextDay=true;config._a[HOUR]=0;}
config._d=(config._useUTC?createUTCDate:createDate).apply(null,input);expectedWeekday=config._useUTC?config._d.getUTCDay():config._d.getDay();if(config._tzm!=null){config._d.setUTCMinutes(config._d.getUTCMinutes()-config._tzm);}
if(config._nextDay){config._a[HOUR]=24;}
if(config._w&&typeof config._w.d!=='undefined'&&config._w.d!==expectedWeekday){getParsingFlags(config).weekdayMismatch=true;}}
function dayOfYearFromWeekInfo(config){var w,weekYear,week,weekday,dow,doy,temp,weekdayOverflow;w=config._w;if(w.GG!=null||w.W!=null||w.E!=null){dow=1;doy=4;weekYear=defaults(w.GG,config._a[YEAR],weekOfYear(createLocal(),1,4).year);week=defaults(w.W,1);weekday=defaults(w.E,1);if(weekday<1||weekday>7){weekdayOverflow=true;}}else{dow=config._locale._week.dow;doy=config._locale._week.doy;var curWeek=weekOfYear(createLocal(),dow,doy);weekYear=defaults(w.gg,config._a[YEAR],curWeek.year);week=defaults(w.w,curWeek.week);if(w.d!=null){weekday=w.d;if(weekday<0||weekday>6){weekdayOverflow=true;}}else if(w.e!=null){weekday=w.e+dow;if(w.e<0||w.e>6){weekdayOverflow=true;}}else{weekday=dow;}}
if(week<1||week>weeksInYear(weekYear,dow,doy)){getParsingFlags(config)._overflowWeeks=true;}else if(weekdayOverflow!=null){getParsingFlags(config)._overflowWeekday=true;}else{temp=dayOfYearFromWeeks(weekYear,week,weekday,dow,doy);config._a[YEAR]=temp.year;config._dayOfYear=temp.dayOfYear;}}
var extendedIsoRegex=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;var basicIsoRegex=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;var tzRegex=/Z|[+-]\d\d(?::?\d\d)?/;var isoDates=[['YYYYYY-MM-DD',/[+-]\d{6}-\d\d-\d\d/],['YYYY-MM-DD',/\d{4}-\d\d-\d\d/],['GGGG-[W]WW-E',/\d{4}-W\d\d-\d/],['GGGG-[W]WW',/\d{4}-W\d\d/,false],['YYYY-DDD',/\d{4}-\d{3}/],['YYYY-MM',/\d{4}-\d\d/,false],['YYYYYYMMDD',/[+-]\d{10}/],['YYYYMMDD',/\d{8}/],['GGGG[W]WWE',/\d{4}W\d{3}/],['GGGG[W]WW',/\d{4}W\d{2}/,false],['YYYYDDD',/\d{7}/]];var isoTimes=[['HH:mm:ss.SSSS',/\d\d:\d\d:\d\d\.\d+/],['HH:mm:ss,SSSS',/\d\d:\d\d:\d\d,\d+/],['HH:mm:ss',/\d\d:\d\d:\d\d/],['HH:mm',/\d\d:\d\d/],['HHmmss.SSSS',/\d\d\d\d\d\d\.\d+/],['HHmmss,SSSS',/\d\d\d\d\d\d,\d+/],['HHmmss',/\d\d\d\d\d\d/],['HHmm',/\d\d\d\d/],['HH',/\d\d/]];var aspNetJsonRegex=/^\/?Date\((\-?\d+)/i;function configFromISO(config){var i,l,string=config._i,match=extendedIsoRegex.exec(string)||basicIsoRegex.exec(string),allowTime,dateFormat,timeFormat,tzFormat;if(match){getParsingFlags(config).iso=true;for(i=0,l=isoDates.length;i<l;i++){if(isoDates[i][1].exec(match[1])){dateFormat=isoDates[i][0];allowTime=isoDates[i][2]!==false;break;}}
if(dateFormat==null){config._isValid=false;return;}
if(match[3]){for(i=0,l=isoTimes.length;i<l;i++){if(isoTimes[i][1].exec(match[3])){timeFormat=(match[2]||' ')+isoTimes[i][0];break;}}
if(timeFormat==null){config._isValid=false;return;}}
if(!allowTime&&timeFormat!=null){config._isValid=false;return;}
if(match[4]){if(tzRegex.exec(match[4])){tzFormat='Z';}else{config._isValid=false;return;}}
config._f=dateFormat+(timeFormat||'')+(tzFormat||'');configFromStringAndFormat(config);}else{config._isValid=false;}}
var rfc2822=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;function extractFromRFC2822Strings(yearStr,monthStr,dayStr,hourStr,minuteStr,secondStr){var result=[untruncateYear(yearStr),defaultLocaleMonthsShort.indexOf(monthStr),parseInt(dayStr,10),parseInt(hourStr,10),parseInt(minuteStr,10)];if(secondStr){result.push(parseInt(secondStr,10));}
return result;}
function untruncateYear(yearStr){var year=parseInt(yearStr,10);if(year<=49){return 2000+year;}else if(year<=999){return 1900+year;}
return year;}
function preprocessRFC2822(s){return s.replace(/\([^)]*\)|[\n\t]/g,' ').replace(/(\s\s+)/g,' ').trim();}
function checkWeekday(weekdayStr,parsedInput,config){if(weekdayStr){var weekdayProvided=defaultLocaleWeekdaysShort.indexOf(weekdayStr),weekdayActual=new Date(parsedInput[0],parsedInput[1],parsedInput[2]).getDay();if(weekdayProvided!==weekdayActual){getParsingFlags(config).weekdayMismatch=true;config._isValid=false;return false;}}
return true;}
var obsOffsets={UT:0,GMT:0,EDT:-4*60,EST:-5*60,CDT:-5*60,CST:-6*60,MDT:-6*60,MST:-7*60,PDT:-7*60,PST:-8*60};function calculateOffset(obsOffset,militaryOffset,numOffset){if(obsOffset){return obsOffsets[obsOffset];}else if(militaryOffset){return 0;}else{var hm=parseInt(numOffset,10);var m=hm%100,h=(hm-m)/100;return h*60+m;}}
function configFromRFC2822(config){var match=rfc2822.exec(preprocessRFC2822(config._i));if(match){var parsedArray=extractFromRFC2822Strings(match[4],match[3],match[2],match[5],match[6],match[7]);if(!checkWeekday(match[1],parsedArray,config)){return;}
config._a=parsedArray;config._tzm=calculateOffset(match[8],match[9],match[10]);config._d=createUTCDate.apply(null,config._a);config._d.setUTCMinutes(config._d.getUTCMinutes()-config._tzm);getParsingFlags(config).rfc2822=true;}else{config._isValid=false;}}
function configFromString(config){var matched=aspNetJsonRegex.exec(config._i);if(matched!==null){config._d=new Date(+matched[1]);return;}
configFromISO(config);if(config._isValid===false){delete config._isValid;}else{return;}
configFromRFC2822(config);if(config._isValid===false){delete config._isValid;}else{return;}
hooks.createFromInputFallback(config);}
hooks.createFromInputFallback=deprecate('value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), '+'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are '+'discouraged and will be removed in an upcoming major release. Please refer to '+'http://momentjs.com/guides/#/warnings/js-date/ for more info.',function(config){config._d=new Date(config._i+(config._useUTC?' UTC':''));});hooks.ISO_8601=function(){};hooks.RFC_2822=function(){};function configFromStringAndFormat(config){if(config._f===hooks.ISO_8601){configFromISO(config);return;}
if(config._f===hooks.RFC_2822){configFromRFC2822(config);return;}
config._a=[];getParsingFlags(config).empty=true;var string=''+config._i,i,parsedInput,tokens,token,skipped,stringLength=string.length,totalParsedInputLength=0;tokens=expandFormat(config._f,config._locale).match(formattingTokens)||[];for(i=0;i<tokens.length;i++){token=tokens[i];parsedInput=(string.match(getParseRegexForToken(token,config))||[])[0];if(parsedInput){skipped=string.substr(0,string.indexOf(parsedInput));if(skipped.length>0){getParsingFlags(config).unusedInput.push(skipped);}
string=string.slice(string.indexOf(parsedInput)+parsedInput.length);totalParsedInputLength+=parsedInput.length;}
if(formatTokenFunctions[token]){if(parsedInput){getParsingFlags(config).empty=false;}
else{getParsingFlags(config).unusedTokens.push(token);}
addTimeToArrayFromToken(token,parsedInput,config);}
else if(config._strict&&!parsedInput){getParsingFlags(config).unusedTokens.push(token);}}
getParsingFlags(config).charsLeftOver=stringLength-totalParsedInputLength;if(string.length>0){getParsingFlags(config).unusedInput.push(string);}
if(config._a[HOUR]<=12&&getParsingFlags(config).bigHour===true&&config._a[HOUR]>0){getParsingFlags(config).bigHour=undefined;}
getParsingFlags(config).parsedDateParts=config._a.slice(0);getParsingFlags(config).meridiem=config._meridiem;config._a[HOUR]=meridiemFixWrap(config._locale,config._a[HOUR],config._meridiem);configFromArray(config);checkOverflow(config);}
function meridiemFixWrap(locale,hour,meridiem){var isPm;if(meridiem==null){return hour;}
if(locale.meridiemHour!=null){return locale.meridiemHour(hour,meridiem);}else if(locale.isPM!=null){isPm=locale.isPM(meridiem);if(isPm&&hour<12){hour+=12;}
if(!isPm&&hour===12){hour=0;}
return hour;}else{return hour;}}
function configFromStringAndArray(config){var tempConfig,bestMoment,scoreToBeat,i,currentScore;if(config._f.length===0){getParsingFlags(config).invalidFormat=true;config._d=new Date(NaN);return;}
for(i=0;i<config._f.length;i++){currentScore=0;tempConfig=copyConfig({},config);if(config._useUTC!=null){tempConfig._useUTC=config._useUTC;}
tempConfig._f=config._f[i];configFromStringAndFormat(tempConfig);if(!isValid(tempConfig)){continue;}
currentScore+=getParsingFlags(tempConfig).charsLeftOver;currentScore+=getParsingFlags(tempConfig).unusedTokens.length*10;getParsingFlags(tempConfig).score=currentScore;if(scoreToBeat==null||currentScore<scoreToBeat){scoreToBeat=currentScore;bestMoment=tempConfig;}}
extend(config,bestMoment||tempConfig);}
function configFromObject(config){if(config._d){return;}
var i=normalizeObjectUnits(config._i);config._a=map([i.year,i.month,i.day||i.date,i.hour,i.minute,i.second,i.millisecond],function(obj){return obj&&parseInt(obj,10);});configFromArray(config);}
function createFromConfig(config){var res=new Moment(checkOverflow(prepareConfig(config)));if(res._nextDay){res.add(1,'d');res._nextDay=undefined;}
return res;}
function prepareConfig(config){var input=config._i,format=config._f;config._locale=config._locale||getLocale(config._l);if(input===null||(format===undefined&&input==='')){return createInvalid({nullInput:true});}
if(typeof input==='string'){config._i=input=config._locale.preparse(input);}
if(isMoment(input)){return new Moment(checkOverflow(input));}else if(isDate(input)){config._d=input;}else if(isArray(format)){configFromStringAndArray(config);}else if(format){configFromStringAndFormat(config);}else{configFromInput(config);}
if(!isValid(config)){config._d=null;}
return config;}
function configFromInput(config){var input=config._i;if(isUndefined(input)){config._d=new Date(hooks.now());}else if(isDate(input)){config._d=new Date(input.valueOf());}else if(typeof input==='string'){configFromString(config);}else if(isArray(input)){config._a=map(input.slice(0),function(obj){return parseInt(obj,10);});configFromArray(config);}else if(isObject(input)){configFromObject(config);}else if(isNumber(input)){config._d=new Date(input);}else{hooks.createFromInputFallback(config);}}
function createLocalOrUTC(input,format,locale,strict,isUTC){var c={};if(locale===true||locale===false){strict=locale;locale=undefined;}
if((isObject(input)&&isObjectEmpty(input))||(isArray(input)&&input.length===0)){input=undefined;}
c._isAMomentObject=true;c._useUTC=c._isUTC=isUTC;c._l=locale;c._i=input;c._f=format;c._strict=strict;return createFromConfig(c);}
function createLocal(input,format,locale,strict){return createLocalOrUTC(input,format,locale,strict,false);}
var prototypeMin=deprecate('moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',function(){var other=createLocal.apply(null,arguments);if(this.isValid()&&other.isValid()){return other<this?this:other;}else{return createInvalid();}});var prototypeMax=deprecate('moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',function(){var other=createLocal.apply(null,arguments);if(this.isValid()&&other.isValid()){return other>this?this:other;}else{return createInvalid();}});function pickBy(fn,moments){var res,i;if(moments.length===1&&isArray(moments[0])){moments=moments[0];}
if(!moments.length){return createLocal();}
res=moments[0];for(i=1;i<moments.length;++i){if(!moments[i].isValid()||moments[i][fn](res)){res=moments[i];}}
return res;}
function min(){var args=[].slice.call(arguments,0);return pickBy('isBefore',args);}
function max(){var args=[].slice.call(arguments,0);return pickBy('isAfter',args);}
var now=function(){return Date.now?Date.now():+(new Date());};var ordering=['year','quarter','month','week','day','hour','minute','second','millisecond'];function isDurationValid(m){for(var key in m){if(!(indexOf.call(ordering,key)!==-1&&(m[key]==null||!isNaN(m[key])))){return false;}}
var unitHasDecimal=false;for(var i=0;i<ordering.length;++i){if(m[ordering[i]]){if(unitHasDecimal){return false;}
if(parseFloat(m[ordering[i]])!==toInt(m[ordering[i]])){unitHasDecimal=true;}}}
return true;}
function isValid$1(){return this._isValid;}
function createInvalid$1(){return createDuration(NaN);}
function Duration(duration){var normalizedInput=normalizeObjectUnits(duration),years=normalizedInput.year||0,quarters=normalizedInput.quarter||0,months=normalizedInput.month||0,weeks=normalizedInput.week||0,days=normalizedInput.day||0,hours=normalizedInput.hour||0,minutes=normalizedInput.minute||0,seconds=normalizedInput.second||0,milliseconds=normalizedInput.millisecond||0;this._isValid=isDurationValid(normalizedInput);this._milliseconds=+milliseconds+
seconds*1e3+
minutes*6e4+
hours*1000*60*60;this._days=+days+
weeks*7;this._months=+months+
quarters*3+
years*12;this._data={};this._locale=getLocale();this._bubble();}
function isDuration(obj){return obj instanceof Duration;}
function absRound(number){if(number<0){return Math.round(-1*number)*-1;}else{return Math.round(number);}}
function offset(token,separator){addFormatToken(token,0,0,function(){var offset=this.utcOffset();var sign='+';if(offset<0){offset=-offset;sign='-';}
return sign+zeroFill(~~(offset/60),2)+separator+zeroFill(~~(offset)%60,2);});}
offset('Z',':');offset('ZZ','');addRegexToken('Z',matchShortOffset);addRegexToken('ZZ',matchShortOffset);addParseToken(['Z','ZZ'],function(input,array,config){config._useUTC=true;config._tzm=offsetFromString(matchShortOffset,input);});var chunkOffset=/([\+\-]|\d\d)/gi;function offsetFromString(matcher,string){var matches=(string||'').match(matcher);if(matches===null){return null;}
var chunk=matches[matches.length-1]||[];var parts=(chunk+'').match(chunkOffset)||['-',0,0];var minutes=+(parts[1]*60)+toInt(parts[2]);return minutes===0?0:parts[0]==='+'?minutes:-minutes;}
function cloneWithOffset(input,model){var res,diff;if(model._isUTC){res=model.clone();diff=(isMoment(input)||isDate(input)?input.valueOf():createLocal(input).valueOf())-res.valueOf();res._d.setTime(res._d.valueOf()+diff);hooks.updateOffset(res,false);return res;}else{return createLocal(input).local();}}
function getDateOffset(m){return-Math.round(m._d.getTimezoneOffset()/15)*15;}
hooks.updateOffset=function(){};function getSetOffset(input,keepLocalTime,keepMinutes){var offset=this._offset||0,localAdjust;if(!this.isValid()){return input!=null?this:NaN;}
if(input!=null){if(typeof input==='string'){input=offsetFromString(matchShortOffset,input);if(input===null){return this;}}else if(Math.abs(input)<16&&!keepMinutes){input=input*60;}
if(!this._isUTC&&keepLocalTime){localAdjust=getDateOffset(this);}
this._offset=input;this._isUTC=true;if(localAdjust!=null){this.add(localAdjust,'m');}
if(offset!==input){if(!keepLocalTime||this._changeInProgress){addSubtract(this,createDuration(input-offset,'m'),1,false);}else if(!this._changeInProgress){this._changeInProgress=true;hooks.updateOffset(this,true);this._changeInProgress=null;}}
return this;}else{return this._isUTC?offset:getDateOffset(this);}}
function getSetZone(input,keepLocalTime){if(input!=null){if(typeof input!=='string'){input=-input;}
this.utcOffset(input,keepLocalTime);return this;}else{return-this.utcOffset();}}
function setOffsetToUTC(keepLocalTime){return this.utcOffset(0,keepLocalTime);}
function setOffsetToLocal(keepLocalTime){if(this._isUTC){this.utcOffset(0,keepLocalTime);this._isUTC=false;if(keepLocalTime){this.subtract(getDateOffset(this),'m');}}
return this;}
function setOffsetToParsedOffset(){if(this._tzm!=null){this.utcOffset(this._tzm,false,true);}else if(typeof this._i==='string'){var tZone=offsetFromString(matchOffset,this._i);if(tZone!=null){this.utcOffset(tZone);}
else{this.utcOffset(0,true);}}
return this;}
function hasAlignedHourOffset(input){if(!this.isValid()){return false;}
input=input?createLocal(input).utcOffset():0;return(this.utcOffset()-input)%60===0;}
function isDaylightSavingTime(){return(this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset());}
function isDaylightSavingTimeShifted(){if(!isUndefined(this._isDSTShifted)){return this._isDSTShifted;}
var c={};copyConfig(c,this);c=prepareConfig(c);if(c._a){var other=c._isUTC?createUTC(c._a):createLocal(c._a);this._isDSTShifted=this.isValid()&&compareArrays(c._a,other.toArray())>0;}else{this._isDSTShifted=false;}
return this._isDSTShifted;}
function isLocal(){return this.isValid()?!this._isUTC:false;}
function isUtcOffset(){return this.isValid()?this._isUTC:false;}
function isUtc(){return this.isValid()?this._isUTC&&this._offset===0:false;}
var aspNetRegex=/^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;var isoRegex=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function createDuration(input,key){var duration=input,match=null,sign,ret,diffRes;if(isDuration(input)){duration={ms:input._milliseconds,d:input._days,M:input._months};}else if(isNumber(input)){duration={};if(key){duration[key]=input;}else{duration.milliseconds=input;}}else if(!!(match=aspNetRegex.exec(input))){sign=(match[1]==='-')?-1:1;duration={y:0,d:toInt(match[DATE])*sign,h:toInt(match[HOUR])*sign,m:toInt(match[MINUTE])*sign,s:toInt(match[SECOND])*sign,ms:toInt(absRound(match[MILLISECOND]*1000))*sign};}else if(!!(match=isoRegex.exec(input))){sign=(match[1]==='-')?-1:(match[1]==='+')?1:1;duration={y:parseIso(match[2],sign),M:parseIso(match[3],sign),w:parseIso(match[4],sign),d:parseIso(match[5],sign),h:parseIso(match[6],sign),m:parseIso(match[7],sign),s:parseIso(match[8],sign)};}else if(duration==null){duration={};}else if(typeof duration==='object'&&('from'in duration||'to'in duration)){diffRes=momentsDifference(createLocal(duration.from),createLocal(duration.to));duration={};duration.ms=diffRes.milliseconds;duration.M=diffRes.months;}
ret=new Duration(duration);if(isDuration(input)&&hasOwnProp(input,'_locale')){ret._locale=input._locale;}
return ret;}
createDuration.fn=Duration.prototype;createDuration.invalid=createInvalid$1;function parseIso(inp,sign){var res=inp&&parseFloat(inp.replace(',','.'));return(isNaN(res)?0:res)*sign;}
function positiveMomentsDifference(base,other){var res={milliseconds:0,months:0};res.months=other.month()-base.month()+
(other.year()-base.year())*12;if(base.clone().add(res.months,'M').isAfter(other)){--res.months;}
res.milliseconds=+other-+(base.clone().add(res.months,'M'));return res;}
function momentsDifference(base,other){var res;if(!(base.isValid()&&other.isValid())){return{milliseconds:0,months:0};}
other=cloneWithOffset(other,base);if(base.isBefore(other)){res=positiveMomentsDifference(base,other);}else{res=positiveMomentsDifference(other,base);res.milliseconds=-res.milliseconds;res.months=-res.months;}
return res;}
function createAdder(direction,name){return function(val,period){var dur,tmp;if(period!==null&&!isNaN(+period)){deprecateSimple(name,'moment().'+name+'(period, number) is deprecated. Please use moment().'+name+'(number, period). '+'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');tmp=val;val=period;period=tmp;}
val=typeof val==='string'?+val:val;dur=createDuration(val,period);addSubtract(this,dur,direction);return this;};}
function addSubtract(mom,duration,isAdding,updateOffset){var milliseconds=duration._milliseconds,days=absRound(duration._days),months=absRound(duration._months);if(!mom.isValid()){return;}
updateOffset=updateOffset==null?true:updateOffset;if(months){setMonth(mom,get(mom,'Month')+months*isAdding);}
if(days){set$1(mom,'Date',get(mom,'Date')+days*isAdding);}
if(milliseconds){mom._d.setTime(mom._d.valueOf()+milliseconds*isAdding);}
if(updateOffset){hooks.updateOffset(mom,days||months);}}
var add=createAdder(1,'add');var subtract=createAdder(-1,'subtract');function getCalendarFormat(myMoment,now){var diff=myMoment.diff(now,'days',true);return diff<-6?'sameElse':diff<-1?'lastWeek':diff<0?'lastDay':diff<1?'sameDay':diff<2?'nextDay':diff<7?'nextWeek':'sameElse';}
function calendar$1(time,formats){var now=time||createLocal(),sod=cloneWithOffset(now,this).startOf('day'),format=hooks.calendarFormat(this,sod)||'sameElse';var output=formats&&(isFunction(formats[format])?formats[format].call(this,now):formats[format]);return this.format(output||this.localeData().calendar(format,this,createLocal(now)));}
function clone(){return new Moment(this);}
function isAfter(input,units){var localInput=isMoment(input)?input:createLocal(input);if(!(this.isValid()&&localInput.isValid())){return false;}
units=normalizeUnits(!isUndefined(units)?units:'millisecond');if(units==='millisecond'){return this.valueOf()>localInput.valueOf();}else{return localInput.valueOf()<this.clone().startOf(units).valueOf();}}
function isBefore(input,units){var localInput=isMoment(input)?input:createLocal(input);if(!(this.isValid()&&localInput.isValid())){return false;}
units=normalizeUnits(!isUndefined(units)?units:'millisecond');if(units==='millisecond'){return this.valueOf()<localInput.valueOf();}else{return this.clone().endOf(units).valueOf()<localInput.valueOf();}}
function isBetween(from,to,units,inclusivity){inclusivity=inclusivity||'()';return(inclusivity[0]==='('?this.isAfter(from,units):!this.isBefore(from,units))&&(inclusivity[1]===')'?this.isBefore(to,units):!this.isAfter(to,units));}
function isSame(input,units){var localInput=isMoment(input)?input:createLocal(input),inputMs;if(!(this.isValid()&&localInput.isValid())){return false;}
units=normalizeUnits(units||'millisecond');if(units==='millisecond'){return this.valueOf()===localInput.valueOf();}else{inputMs=localInput.valueOf();return this.clone().startOf(units).valueOf()<=inputMs&&inputMs<=this.clone().endOf(units).valueOf();}}
function isSameOrAfter(input,units){return this.isSame(input,units)||this.isAfter(input,units);}
function isSameOrBefore(input,units){return this.isSame(input,units)||this.isBefore(input,units);}
function diff(input,units,asFloat){var that,zoneDelta,delta,output;if(!this.isValid()){return NaN;}
that=cloneWithOffset(input,this);if(!that.isValid()){return NaN;}
zoneDelta=(that.utcOffset()-this.utcOffset())*6e4;units=normalizeUnits(units);switch(units){case'year':output=monthDiff(this,that)/12;break;case'month':output=monthDiff(this,that);break;case'quarter':output=monthDiff(this,that)/3;break;case'second':output=(this-that)/1e3;break;case'minute':output=(this-that)/6e4;break;case'hour':output=(this-that)/36e5;break;case'day':output=(this-that-zoneDelta)/864e5;break;case'week':output=(this-that-zoneDelta)/6048e5;break;default:output=this-that;}
return asFloat?output:absFloor(output);}
function monthDiff(a,b){var wholeMonthDiff=((b.year()-a.year())*12)+(b.month()-a.month()),anchor=a.clone().add(wholeMonthDiff,'months'),anchor2,adjust;if(b-anchor<0){anchor2=a.clone().add(wholeMonthDiff-1,'months');adjust=(b-anchor)/(anchor-anchor2);}else{anchor2=a.clone().add(wholeMonthDiff+1,'months');adjust=(b-anchor)/(anchor2-anchor);}
return-(wholeMonthDiff+adjust)||0;}
hooks.defaultFormat='YYYY-MM-DDTHH:mm:ssZ';hooks.defaultFormatUtc='YYYY-MM-DDTHH:mm:ss[Z]';function toString(){return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');}
function toISOString(keepOffset){if(!this.isValid()){return null;}
var utc=keepOffset!==true;var m=utc?this.clone().utc():this;if(m.year()<0||m.year()>9999){return formatMoment(m,utc?'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]':'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ');}
if(isFunction(Date.prototype.toISOString)){if(utc){return this.toDate().toISOString();}else{return new Date(this._d.valueOf()).toISOString().replace('Z',formatMoment(m,'Z'));}}
return formatMoment(m,utc?'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]':'YYYY-MM-DD[T]HH:mm:ss.SSSZ');}
function inspect(){if(!this.isValid()){return'moment.invalid(/* '+this._i+' */)';}
var func='moment';var zone='';if(!this.isLocal()){func=this.utcOffset()===0?'moment.utc':'moment.parseZone';zone='Z';}
var prefix='['+func+'("]';var year=(0<=this.year()&&this.year()<=9999)?'YYYY':'YYYYYY';var datetime='-MM-DD[T]HH:mm:ss.SSS';var suffix=zone+'[")]';return this.format(prefix+year+datetime+suffix);}
function format(inputString){if(!inputString){inputString=this.isUtc()?hooks.defaultFormatUtc:hooks.defaultFormat;}
var output=formatMoment(this,inputString);return this.localeData().postformat(output);}
function from(time,withoutSuffix){if(this.isValid()&&((isMoment(time)&&time.isValid())||createLocal(time).isValid())){return createDuration({to:this,from:time}).locale(this.locale()).humanize(!withoutSuffix);}else{return this.localeData().invalidDate();}}
function fromNow(withoutSuffix){return this.from(createLocal(),withoutSuffix);}
function to(time,withoutSuffix){if(this.isValid()&&((isMoment(time)&&time.isValid())||createLocal(time).isValid())){return createDuration({from:this,to:time}).locale(this.locale()).humanize(!withoutSuffix);}else{return this.localeData().invalidDate();}}
function toNow(withoutSuffix){return this.to(createLocal(),withoutSuffix);}
function locale(key){var newLocaleData;if(key===undefined){return this._locale._abbr;}else{newLocaleData=getLocale(key);if(newLocaleData!=null){this._locale=newLocaleData;}
return this;}}
var lang=deprecate('moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',function(key){if(key===undefined){return this.localeData();}else{return this.locale(key);}});function localeData(){return this._locale;}
function startOf(units){units=normalizeUnits(units);switch(units){case'year':this.month(0);case'quarter':case'month':this.date(1);case'week':case'isoWeek':case'day':case'date':this.hours(0);case'hour':this.minutes(0);case'minute':this.seconds(0);case'second':this.milliseconds(0);}
if(units==='week'){this.weekday(0);}
if(units==='isoWeek'){this.isoWeekday(1);}
if(units==='quarter'){this.month(Math.floor(this.month()/3)*3);}
return this;}
function endOf(units){units=normalizeUnits(units);if(units===undefined||units==='millisecond'){return this;}
if(units==='date'){units='day';}
return this.startOf(units).add(1,(units==='isoWeek'?'week':units)).subtract(1,'ms');}
function valueOf(){return this._d.valueOf()-((this._offset||0)*60000);}
function unix(){return Math.floor(this.valueOf()/1000);}
function toDate(){return new Date(this.valueOf());}
function toArray(){var m=this;return[m.year(),m.month(),m.date(),m.hour(),m.minute(),m.second(),m.millisecond()];}
function toObject(){var m=this;return{years:m.year(),months:m.month(),date:m.date(),hours:m.hours(),minutes:m.minutes(),seconds:m.seconds(),milliseconds:m.milliseconds()};}
function toJSON(){return this.isValid()?this.toISOString():null;}
function isValid$2(){return isValid(this);}
function parsingFlags(){return extend({},getParsingFlags(this));}
function invalidAt(){return getParsingFlags(this).overflow;}
function creationData(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict};}
addFormatToken(0,['gg',2],0,function(){return this.weekYear()%100;});addFormatToken(0,['GG',2],0,function(){return this.isoWeekYear()%100;});function addWeekYearFormatToken(token,getter){addFormatToken(0,[token,token.length],0,getter);}
addWeekYearFormatToken('gggg','weekYear');addWeekYearFormatToken('ggggg','weekYear');addWeekYearFormatToken('GGGG','isoWeekYear');addWeekYearFormatToken('GGGGG','isoWeekYear');addUnitAlias('weekYear','gg');addUnitAlias('isoWeekYear','GG');addUnitPriority('weekYear',1);addUnitPriority('isoWeekYear',1);addRegexToken('G',matchSigned);addRegexToken('g',matchSigned);addRegexToken('GG',match1to2,match2);addRegexToken('gg',match1to2,match2);addRegexToken('GGGG',match1to4,match4);addRegexToken('gggg',match1to4,match4);addRegexToken('GGGGG',match1to6,match6);addRegexToken('ggggg',match1to6,match6);addWeekParseToken(['gggg','ggggg','GGGG','GGGGG'],function(input,week,config,token){week[token.substr(0,2)]=toInt(input);});addWeekParseToken(['gg','GG'],function(input,week,config,token){week[token]=hooks.parseTwoDigitYear(input);});function getSetWeekYear(input){return getSetWeekYearHelper.call(this,input,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy);}
function getSetISOWeekYear(input){return getSetWeekYearHelper.call(this,input,this.isoWeek(),this.isoWeekday(),1,4);}
function getISOWeeksInYear(){return weeksInYear(this.year(),1,4);}
function getWeeksInYear(){var weekInfo=this.localeData()._week;return weeksInYear(this.year(),weekInfo.dow,weekInfo.doy);}
function getSetWeekYearHelper(input,week,weekday,dow,doy){var weeksTarget;if(input==null){return weekOfYear(this,dow,doy).year;}else{weeksTarget=weeksInYear(input,dow,doy);if(week>weeksTarget){week=weeksTarget;}
return setWeekAll.call(this,input,week,weekday,dow,doy);}}
function setWeekAll(weekYear,week,weekday,dow,doy){var dayOfYearData=dayOfYearFromWeeks(weekYear,week,weekday,dow,doy),date=createUTCDate(dayOfYearData.year,0,dayOfYearData.dayOfYear);this.year(date.getUTCFullYear());this.month(date.getUTCMonth());this.date(date.getUTCDate());return this;}
addFormatToken('Q',0,'Qo','quarter');addUnitAlias('quarter','Q');addUnitPriority('quarter',7);addRegexToken('Q',match1);addParseToken('Q',function(input,array){array[MONTH]=(toInt(input)-1)*3;});function getSetQuarter(input){return input==null?Math.ceil((this.month()+1)/3):this.month((input-1)*3+this.month()%3);}
addFormatToken('D',['DD',2],'Do','date');addUnitAlias('date','D');addUnitPriority('date',9);addRegexToken('D',match1to2);addRegexToken('DD',match1to2,match2);addRegexToken('Do',function(isStrict,locale){return isStrict?(locale._dayOfMonthOrdinalParse||locale._ordinalParse):locale._dayOfMonthOrdinalParseLenient;});addParseToken(['D','DD'],DATE);addParseToken('Do',function(input,array){array[DATE]=toInt(input.match(match1to2)[0]);});var getSetDayOfMonth=makeGetSet('Date',true);addFormatToken('DDD',['DDDD',3],'DDDo','dayOfYear');addUnitAlias('dayOfYear','DDD');addUnitPriority('dayOfYear',4);addRegexToken('DDD',match1to3);addRegexToken('DDDD',match3);addParseToken(['DDD','DDDD'],function(input,array,config){config._dayOfYear=toInt(input);});function getSetDayOfYear(input){var dayOfYear=Math.round((this.clone().startOf('day')-this.clone().startOf('year'))/864e5)+1;return input==null?dayOfYear:this.add((input-dayOfYear),'d');}
addFormatToken('m',['mm',2],0,'minute');addUnitAlias('minute','m');addUnitPriority('minute',14);addRegexToken('m',match1to2);addRegexToken('mm',match1to2,match2);addParseToken(['m','mm'],MINUTE);var getSetMinute=makeGetSet('Minutes',false);addFormatToken('s',['ss',2],0,'second');addUnitAlias('second','s');addUnitPriority('second',15);addRegexToken('s',match1to2);addRegexToken('ss',match1to2,match2);addParseToken(['s','ss'],SECOND);var getSetSecond=makeGetSet('Seconds',false);addFormatToken('S',0,0,function(){return~~(this.millisecond()/100);});addFormatToken(0,['SS',2],0,function(){return~~(this.millisecond()/10);});addFormatToken(0,['SSS',3],0,'millisecond');addFormatToken(0,['SSSS',4],0,function(){return this.millisecond()*10;});addFormatToken(0,['SSSSS',5],0,function(){return this.millisecond()*100;});addFormatToken(0,['SSSSSS',6],0,function(){return this.millisecond()*1000;});addFormatToken(0,['SSSSSSS',7],0,function(){return this.millisecond()*10000;});addFormatToken(0,['SSSSSSSS',8],0,function(){return this.millisecond()*100000;});addFormatToken(0,['SSSSSSSSS',9],0,function(){return this.millisecond()*1000000;});addUnitAlias('millisecond','ms');addUnitPriority('millisecond',16);addRegexToken('S',match1to3,match1);addRegexToken('SS',match1to3,match2);addRegexToken('SSS',match1to3,match3);var token;for(token='SSSS';token.length<=9;token+='S'){addRegexToken(token,matchUnsigned);}
function parseMs(input,array){array[MILLISECOND]=toInt(('0.'+input)*1000);}
for(token='S';token.length<=9;token+='S'){addParseToken(token,parseMs);}
var getSetMillisecond=makeGetSet('Milliseconds',false);addFormatToken('z',0,0,'zoneAbbr');addFormatToken('zz',0,0,'zoneName');function getZoneAbbr(){return this._isUTC?'UTC':'';}
function getZoneName(){return this._isUTC?'Coordinated Universal Time':'';}
var proto=Moment.prototype;proto.add=add;proto.calendar=calendar$1;proto.clone=clone;proto.diff=diff;proto.endOf=endOf;proto.format=format;proto.from=from;proto.fromNow=fromNow;proto.to=to;proto.toNow=toNow;proto.get=stringGet;proto.invalidAt=invalidAt;proto.isAfter=isAfter;proto.isBefore=isBefore;proto.isBetween=isBetween;proto.isSame=isSame;proto.isSameOrAfter=isSameOrAfter;proto.isSameOrBefore=isSameOrBefore;proto.isValid=isValid$2;proto.lang=lang;proto.locale=locale;proto.localeData=localeData;proto.max=prototypeMax;proto.min=prototypeMin;proto.parsingFlags=parsingFlags;proto.set=stringSet;proto.startOf=startOf;proto.subtract=subtract;proto.toArray=toArray;proto.toObject=toObject;proto.toDate=toDate;proto.toISOString=toISOString;proto.inspect=inspect;proto.toJSON=toJSON;proto.toString=toString;proto.unix=unix;proto.valueOf=valueOf;proto.creationData=creationData;proto.year=getSetYear;proto.isLeapYear=getIsLeapYear;proto.weekYear=getSetWeekYear;proto.isoWeekYear=getSetISOWeekYear;proto.quarter=proto.quarters=getSetQuarter;proto.month=getSetMonth;proto.daysInMonth=getDaysInMonth;proto.week=proto.weeks=getSetWeek;proto.isoWeek=proto.isoWeeks=getSetISOWeek;proto.weeksInYear=getWeeksInYear;proto.isoWeeksInYear=getISOWeeksInYear;proto.date=getSetDayOfMonth;proto.day=proto.days=getSetDayOfWeek;proto.weekday=getSetLocaleDayOfWeek;proto.isoWeekday=getSetISODayOfWeek;proto.dayOfYear=getSetDayOfYear;proto.hour=proto.hours=getSetHour;proto.minute=proto.minutes=getSetMinute;proto.second=proto.seconds=getSetSecond;proto.millisecond=proto.milliseconds=getSetMillisecond;proto.utcOffset=getSetOffset;proto.utc=setOffsetToUTC;proto.local=setOffsetToLocal;proto.parseZone=setOffsetToParsedOffset;proto.hasAlignedHourOffset=hasAlignedHourOffset;proto.isDST=isDaylightSavingTime;proto.isLocal=isLocal;proto.isUtcOffset=isUtcOffset;proto.isUtc=isUtc;proto.isUTC=isUtc;proto.zoneAbbr=getZoneAbbr;proto.zoneName=getZoneName;proto.dates=deprecate('dates accessor is deprecated. Use date instead.',getSetDayOfMonth);proto.months=deprecate('months accessor is deprecated. Use month instead',getSetMonth);proto.years=deprecate('years accessor is deprecated. Use year instead',getSetYear);proto.zone=deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/',getSetZone);proto.isDSTShifted=deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information',isDaylightSavingTimeShifted);function createUnix(input){return createLocal(input*1000);}
function createInZone(){return createLocal.apply(null,arguments).parseZone();}
function preParsePostFormat(string){return string;}
var proto$1=Locale.prototype;proto$1.calendar=calendar;proto$1.longDateFormat=longDateFormat;proto$1.invalidDate=invalidDate;proto$1.ordinal=ordinal;proto$1.preparse=preParsePostFormat;proto$1.postformat=preParsePostFormat;proto$1.relativeTime=relativeTime;proto$1.pastFuture=pastFuture;proto$1.set=set;proto$1.months=localeMonths;proto$1.monthsShort=localeMonthsShort;proto$1.monthsParse=localeMonthsParse;proto$1.monthsRegex=monthsRegex;proto$1.monthsShortRegex=monthsShortRegex;proto$1.week=localeWeek;proto$1.firstDayOfYear=localeFirstDayOfYear;proto$1.firstDayOfWeek=localeFirstDayOfWeek;proto$1.weekdays=localeWeekdays;proto$1.weekdaysMin=localeWeekdaysMin;proto$1.weekdaysShort=localeWeekdaysShort;proto$1.weekdaysParse=localeWeekdaysParse;proto$1.weekdaysRegex=weekdaysRegex;proto$1.weekdaysShortRegex=weekdaysShortRegex;proto$1.weekdaysMinRegex=weekdaysMinRegex;proto$1.isPM=localeIsPM;proto$1.meridiem=localeMeridiem;function get$1(format,index,field,setter){var locale=getLocale();var utc=createUTC().set(setter,index);return locale[field](utc,format);}
function listMonthsImpl(format,index,field){if(isNumber(format)){index=format;format=undefined;}
format=format||'';if(index!=null){return get$1(format,index,field,'month');}
var i;var out=[];for(i=0;i<12;i++){out[i]=get$1(format,i,field,'month');}
return out;}
function listWeekdaysImpl(localeSorted,format,index,field){if(typeof localeSorted==='boolean'){if(isNumber(format)){index=format;format=undefined;}
format=format||'';}else{format=localeSorted;index=format;localeSorted=false;if(isNumber(format)){index=format;format=undefined;}
format=format||'';}
var locale=getLocale(),shift=localeSorted?locale._week.dow:0;if(index!=null){return get$1(format,(index+shift)%7,field,'day');}
var i;var out=[];for(i=0;i<7;i++){out[i]=get$1(format,(i+shift)%7,field,'day');}
return out;}
function listMonths(format,index){return listMonthsImpl(format,index,'months');}
function listMonthsShort(format,index){return listMonthsImpl(format,index,'monthsShort');}
function listWeekdays(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,'weekdays');}
function listWeekdaysShort(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,'weekdaysShort');}
function listWeekdaysMin(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,'weekdaysMin');}
getSetGlobalLocale('en',{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(number){var b=number%10,output=(toInt(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;}});hooks.lang=deprecate('moment.lang is deprecated. Use moment.locale instead.',getSetGlobalLocale);hooks.langData=deprecate('moment.langData is deprecated. Use moment.localeData instead.',getLocale);var mathAbs=Math.abs;function abs(){var data=this._data;this._milliseconds=mathAbs(this._milliseconds);this._days=mathAbs(this._days);this._months=mathAbs(this._months);data.milliseconds=mathAbs(data.milliseconds);data.seconds=mathAbs(data.seconds);data.minutes=mathAbs(data.minutes);data.hours=mathAbs(data.hours);data.months=mathAbs(data.months);data.years=mathAbs(data.years);return this;}
function addSubtract$1(duration,input,value,direction){var other=createDuration(input,value);duration._milliseconds+=direction*other._milliseconds;duration._days+=direction*other._days;duration._months+=direction*other._months;return duration._bubble();}
function add$1(input,value){return addSubtract$1(this,input,value,1);}
function subtract$1(input,value){return addSubtract$1(this,input,value,-1);}
function absCeil(number){if(number<0){return Math.floor(number);}else{return Math.ceil(number);}}
function bubble(){var milliseconds=this._milliseconds;var days=this._days;var months=this._months;var data=this._data;var seconds,minutes,hours,years,monthsFromDays;if(!((milliseconds>=0&&days>=0&&months>=0)||(milliseconds<=0&&days<=0&&months<=0))){milliseconds+=absCeil(monthsToDays(months)+days)*864e5;days=0;months=0;}
data.milliseconds=milliseconds%1000;seconds=absFloor(milliseconds/1000);data.seconds=seconds%60;minutes=absFloor(seconds/60);data.minutes=minutes%60;hours=absFloor(minutes/60);data.hours=hours%24;days+=absFloor(hours/24);monthsFromDays=absFloor(daysToMonths(days));months+=monthsFromDays;days-=absCeil(monthsToDays(monthsFromDays));years=absFloor(months/12);months%=12;data.days=days;data.months=months;data.years=years;return this;}
function daysToMonths(days){return days*4800/146097;}
function monthsToDays(months){return months*146097/4800;}
function as(units){if(!this.isValid()){return NaN;}
var days;var months;var milliseconds=this._milliseconds;units=normalizeUnits(units);if(units==='month'||units==='year'){days=this._days+milliseconds/864e5;months=this._months+daysToMonths(days);return units==='month'?months:months/12;}else{days=this._days+Math.round(monthsToDays(this._months));switch(units){case'week':return days/7+milliseconds/6048e5;case'day':return days+milliseconds/864e5;case'hour':return days*24+milliseconds/36e5;case'minute':return days*1440+milliseconds/6e4;case'second':return days*86400+milliseconds/1000;case'millisecond':return Math.floor(days*864e5)+milliseconds;default:throw new Error('Unknown unit '+units);}}}
function valueOf$1(){if(!this.isValid()){return NaN;}
return(this._milliseconds+
this._days*864e5+
(this._months%12)*2592e6+
toInt(this._months/12)*31536e6);}
function makeAs(alias){return function(){return this.as(alias);};}
var asMilliseconds=makeAs('ms');var asSeconds=makeAs('s');var asMinutes=makeAs('m');var asHours=makeAs('h');var asDays=makeAs('d');var asWeeks=makeAs('w');var asMonths=makeAs('M');var asYears=makeAs('y');function clone$1(){return createDuration(this);}
function get$2(units){units=normalizeUnits(units);return this.isValid()?this[units+'s']():NaN;}
function makeGetter(name){return function(){return this.isValid()?this._data[name]:NaN;};}
var milliseconds=makeGetter('milliseconds');var seconds=makeGetter('seconds');var minutes=makeGetter('minutes');var hours=makeGetter('hours');var days=makeGetter('days');var months=makeGetter('months');var years=makeGetter('years');function weeks(){return absFloor(this.days()/7);}
var round=Math.round;var thresholds={ss:44,s:45,m:45,h:22,d:26,M:11};function substituteTimeAgo(string,number,withoutSuffix,isFuture,locale){return locale.relativeTime(number||1,!!withoutSuffix,string,isFuture);}
function relativeTime$1(posNegDuration,withoutSuffix,locale){var duration=createDuration(posNegDuration).abs();var seconds=round(duration.as('s'));var minutes=round(duration.as('m'));var hours=round(duration.as('h'));var days=round(duration.as('d'));var months=round(duration.as('M'));var years=round(duration.as('y'));var a=seconds<=thresholds.ss&&['s',seconds]||seconds<thresholds.s&&['ss',seconds]||minutes<=1&&['m']||minutes<thresholds.m&&['mm',minutes]||hours<=1&&['h']||hours<thresholds.h&&['hh',hours]||days<=1&&['d']||days<thresholds.d&&['dd',days]||months<=1&&['M']||months<thresholds.M&&['MM',months]||years<=1&&['y']||['yy',years];a[2]=withoutSuffix;a[3]=+posNegDuration>0;a[4]=locale;return substituteTimeAgo.apply(null,a);}
function getSetRelativeTimeRounding(roundingFunction){if(roundingFunction===undefined){return round;}
if(typeof(roundingFunction)==='function'){round=roundingFunction;return true;}
return false;}
function getSetRelativeTimeThreshold(threshold,limit){if(thresholds[threshold]===undefined){return false;}
if(limit===undefined){return thresholds[threshold];}
thresholds[threshold]=limit;if(threshold==='s'){thresholds.ss=limit-1;}
return true;}
function humanize(withSuffix){if(!this.isValid()){return this.localeData().invalidDate();}
var locale=this.localeData();var output=relativeTime$1(this,!withSuffix,locale);if(withSuffix){output=locale.pastFuture(+this,output);}
return locale.postformat(output);}
var abs$1=Math.abs;function sign(x){return((x>0)-(x<0))||+x;}
function toISOString$1(){if(!this.isValid()){return this.localeData().invalidDate();}
var seconds=abs$1(this._milliseconds)/1000;var days=abs$1(this._days);var months=abs$1(this._months);var minutes,hours,years;minutes=absFloor(seconds/60);hours=absFloor(minutes/60);seconds%=60;minutes%=60;years=absFloor(months/12);months%=12;var Y=years;var M=months;var D=days;var h=hours;var m=minutes;var s=seconds?seconds.toFixed(3).replace(/\.?0+$/,''):'';var total=this.asSeconds();if(!total){return'P0D';}
var totalSign=total<0?'-':'';var ymSign=sign(this._months)!==sign(total)?'-':'';var daysSign=sign(this._days)!==sign(total)?'-':'';var hmsSign=sign(this._milliseconds)!==sign(total)?'-':'';return totalSign+'P'+
(Y?ymSign+Y+'Y':'')+
(M?ymSign+M+'M':'')+
(D?daysSign+D+'D':'')+
((h||m||s)?'T':'')+
(h?hmsSign+h+'H':'')+
(m?hmsSign+m+'M':'')+
(s?hmsSign+s+'S':'');}
var proto$2=Duration.prototype;proto$2.isValid=isValid$1;proto$2.abs=abs;proto$2.add=add$1;proto$2.subtract=subtract$1;proto$2.as=as;proto$2.asMilliseconds=asMilliseconds;proto$2.asSeconds=asSeconds;proto$2.asMinutes=asMinutes;proto$2.asHours=asHours;proto$2.asDays=asDays;proto$2.asWeeks=asWeeks;proto$2.asMonths=asMonths;proto$2.asYears=asYears;proto$2.valueOf=valueOf$1;proto$2._bubble=bubble;proto$2.clone=clone$1;proto$2.get=get$2;proto$2.milliseconds=milliseconds;proto$2.seconds=seconds;proto$2.minutes=minutes;proto$2.hours=hours;proto$2.days=days;proto$2.weeks=weeks;proto$2.months=months;proto$2.years=years;proto$2.humanize=humanize;proto$2.toISOString=toISOString$1;proto$2.toString=toISOString$1;proto$2.toJSON=toISOString$1;proto$2.locale=locale;proto$2.localeData=localeData;proto$2.toIsoString=deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)',toISOString$1);proto$2.lang=lang;addFormatToken('X',0,0,'unix');addFormatToken('x',0,0,'valueOf');addRegexToken('x',matchSigned);addRegexToken('X',matchTimestamp);addParseToken('X',function(input,array,config){config._d=new Date(parseFloat(input,10)*1000);});addParseToken('x',function(input,array,config){config._d=new Date(toInt(input));});hooks.version='2.20.1';setHookCallback(createLocal);hooks.fn=proto;hooks.min=min;hooks.max=max;hooks.now=now;hooks.utc=createUTC;hooks.unix=createUnix;hooks.months=listMonths;hooks.isDate=isDate;hooks.locale=getSetGlobalLocale;hooks.invalid=createInvalid;hooks.duration=createDuration;hooks.isMoment=isMoment;hooks.weekdays=listWeekdays;hooks.parseZone=createInZone;hooks.localeData=getLocale;hooks.isDuration=isDuration;hooks.monthsShort=listMonthsShort;hooks.weekdaysMin=listWeekdaysMin;hooks.defineLocale=defineLocale;hooks.updateLocale=updateLocale;hooks.locales=listLocales;hooks.weekdaysShort=listWeekdaysShort;hooks.normalizeUnits=normalizeUnits;hooks.relativeTimeRounding=getSetRelativeTimeRounding;hooks.relativeTimeThreshold=getSetRelativeTimeThreshold;hooks.calendarFormat=getCalendarFormat;hooks.prototype=proto;hooks.HTML5_FMT={DATETIME_LOCAL:'YYYY-MM-DDTHH:mm',DATETIME_LOCAL_SECONDS:'YYYY-MM-DDTHH:mm:ss',DATETIME_LOCAL_MS:'YYYY-MM-DDTHH:mm:ss.SSS',DATE:'YYYY-MM-DD',TIME:'HH:mm',TIME_SECONDS:'HH:mm:ss',TIME_MS:'HH:mm:ss.SSS',WEEK:'YYYY-[W]WW',MONTH:'YYYY-MM'};return hooks;})));},{}],7:[function(require,module,exports){var Chart=require(29)();Chart.helpers=require(45);require(27)(Chart);Chart.defaults=require(25);Chart.Element=require(26);Chart.elements=require(40);Chart.Interaction=require(28);Chart.layouts=require(30);Chart.platform=require(48);Chart.plugins=require(31);Chart.Ticks=require(34);require(22)(Chart);require(23)(Chart);require(24)(Chart);require(33)(Chart);require(32)(Chart);require(35)(Chart);require(55)(Chart);require(53)(Chart);require(54)(Chart);require(56)(Chart);require(57)(Chart);require(58)(Chart);require(15)(Chart);require(16)(Chart);require(17)(Chart);require(18)(Chart);require(19)(Chart);require(20)(Chart);require(21)(Chart);require(8)(Chart);require(9)(Chart);require(10)(Chart);require(11)(Chart);require(12)(Chart);require(13)(Chart);require(14)(Chart);var plugins=require(49);for(var k in plugins){if(plugins.hasOwnProperty(k)){Chart.plugins.register(plugins[k]);}}
Chart.platform.initialize();module.exports=Chart;if(typeof window!=='undefined'){window.Chart=Chart;}
Chart.Legend=plugins.legend._element;Chart.Title=plugins.title._element;Chart.pluginService=Chart.plugins;Chart.PluginBase=Chart.Element.extend({});Chart.canvasHelpers=Chart.helpers.canvas;Chart.layoutService=Chart.layouts;},{"10":10,"11":11,"12":12,"13":13,"14":14,"15":15,"16":16,"17":17,"18":18,"19":19,"20":20,"21":21,"22":22,"23":23,"24":24,"25":25,"26":26,"27":27,"28":28,"29":29,"30":30,"31":31,"32":32,"33":33,"34":34,"35":35,"40":40,"45":45,"48":48,"49":49,"53":53,"54":54,"55":55,"56":56,"57":57,"58":58,"8":8,"9":9}],8:[function(require,module,exports){'use strict';module.exports=function(Chart){Chart.Bar=function(context,config){config.type='bar';return new Chart(context,config);};};},{}],9:[function(require,module,exports){'use strict';module.exports=function(Chart){Chart.Bubble=function(context,config){config.type='bubble';return new Chart(context,config);};};},{}],10:[function(require,module,exports){'use strict';module.exports=function(Chart){Chart.Doughnut=function(context,config){config.type='doughnut';return new Chart(context,config);};};},{}],11:[function(require,module,exports){'use strict';module.exports=function(Chart){Chart.Line=function(context,config){config.type='line';return new Chart(context,config);};};},{}],12:[function(require,module,exports){'use strict';module.exports=function(Chart){Chart.PolarArea=function(context,config){config.type='polarArea';return new Chart(context,config);};};},{}],13:[function(require,module,exports){'use strict';module.exports=function(Chart){Chart.Radar=function(context,config){config.type='radar';return new Chart(context,config);};};},{}],14:[function(require,module,exports){'use strict';module.exports=function(Chart){Chart.Scatter=function(context,config){config.type='scatter';return new Chart(context,config);};};},{}],15:[function(require,module,exports){'use strict';var defaults=require(25);var elements=require(40);var helpers=require(45);defaults._set('bar',{hover:{mode:'label'},scales:{xAxes:[{type:'category',categoryPercentage:0.8,barPercentage:0.9,offset:true,gridLines:{offsetGridLines:true}}],yAxes:[{type:'linear'}]}});defaults._set('horizontalBar',{hover:{mode:'index',axis:'y'},scales:{xAxes:[{type:'linear',position:'bottom'}],yAxes:[{position:'left',type:'category',categoryPercentage:0.8,barPercentage:0.9,offset:true,gridLines:{offsetGridLines:true}}]},elements:{rectangle:{borderSkipped:'left'}},tooltips:{callbacks:{title:function(item,data){var title='';if(item.length>0){if(item[0].yLabel){title=item[0].yLabel;}else if(data.labels.length>0&&item[0].index<data.labels.length){title=data.labels[item[0].index];}}
return title;},label:function(item,data){var datasetLabel=data.datasets[item.datasetIndex].label||'';return datasetLabel+': '+item.xLabel;}},mode:'index',axis:'y'}});function computeMinSampleSize(scale,pixels){var min=scale.isHorizontal()?scale.width:scale.height;var ticks=scale.getTicks();var prev,curr,i,ilen;for(i=1,ilen=pixels.length;i<ilen;++i){min=Math.min(min,pixels[i]-pixels[i-1]);}
for(i=0,ilen=ticks.length;i<ilen;++i){curr=scale.getPixelForTick(i);min=i>0?Math.min(min,curr-prev):min;prev=curr;}
return min;}
function computeFitCategoryTraits(index,ruler,options){var thickness=options.barThickness;var count=ruler.stackCount;var curr=ruler.pixels[index];var size,ratio;if(helpers.isNullOrUndef(thickness)){size=ruler.min*options.categoryPercentage;ratio=options.barPercentage;}else{size=thickness*count;ratio=1;}
return{chunk:size/count,ratio:ratio,start:curr-(size/2)};}
function computeFlexCategoryTraits(index,ruler,options){var pixels=ruler.pixels;var curr=pixels[index];var prev=index>0?pixels[index-1]:null;var next=index<pixels.length-1?pixels[index+1]:null;var percent=options.categoryPercentage;var start,size;if(prev===null){prev=curr-(next===null?ruler.end-curr:next-curr);}
if(next===null){next=curr+curr-prev;}
start=curr-((curr-prev)/2)*percent;size=((next-prev)/2)*percent;return{chunk:size/ruler.stackCount,ratio:options.barPercentage,start:start};}
module.exports=function(Chart){Chart.controllers.bar=Chart.DatasetController.extend({dataElementType:elements.Rectangle,initialize:function(){var me=this;var meta;Chart.DatasetController.prototype.initialize.apply(me,arguments);meta=me.getMeta();meta.stack=me.getDataset().stack;meta.bar=true;},update:function(reset){var me=this;var rects=me.getMeta().data;var i,ilen;me._ruler=me.getRuler();for(i=0,ilen=rects.length;i<ilen;++i){me.updateElement(rects[i],i,reset);}},updateElement:function(rectangle,index,reset){var me=this;var chart=me.chart;var meta=me.getMeta();var dataset=me.getDataset();var custom=rectangle.custom||{};var rectangleOptions=chart.options.elements.rectangle;rectangle._xScale=me.getScaleForId(meta.xAxisID);rectangle._yScale=me.getScaleForId(meta.yAxisID);rectangle._datasetIndex=me.index;rectangle._index=index;rectangle._model={datasetLabel:dataset.label,label:chart.data.labels[index],borderSkipped:custom.borderSkipped?custom.borderSkipped:rectangleOptions.borderSkipped,backgroundColor:custom.backgroundColor?custom.backgroundColor:helpers.valueAtIndexOrDefault(dataset.backgroundColor,index,rectangleOptions.backgroundColor),borderColor:custom.borderColor?custom.borderColor:helpers.valueAtIndexOrDefault(dataset.borderColor,index,rectangleOptions.borderColor),borderWidth:custom.borderWidth?custom.borderWidth:helpers.valueAtIndexOrDefault(dataset.borderWidth,index,rectangleOptions.borderWidth)};me.updateElementGeometry(rectangle,index,reset);rectangle.pivot();},updateElementGeometry:function(rectangle,index,reset){var me=this;var model=rectangle._model;var vscale=me.getValueScale();var base=vscale.getBasePixel();var horizontal=vscale.isHorizontal();var ruler=me._ruler||me.getRuler();var vpixels=me.calculateBarValuePixels(me.index,index);var ipixels=me.calculateBarIndexPixels(me.index,index,ruler);model.horizontal=horizontal;model.base=reset?base:vpixels.base;model.x=horizontal?reset?base:vpixels.head:ipixels.center;model.y=horizontal?ipixels.center:reset?base:vpixels.head;model.height=horizontal?ipixels.size:undefined;model.width=horizontal?undefined:ipixels.size;},getValueScaleId:function(){return this.getMeta().yAxisID;},getIndexScaleId:function(){return this.getMeta().xAxisID;},getValueScale:function(){return this.getScaleForId(this.getValueScaleId());},getIndexScale:function(){return this.getScaleForId(this.getIndexScaleId());},_getStacks:function(last){var me=this;var chart=me.chart;var scale=me.getIndexScale();var stacked=scale.options.stacked;var ilen=last===undefined?chart.data.datasets.length:last+1;var stacks=[];var i,meta;for(i=0;i<ilen;++i){meta=chart.getDatasetMeta(i);if(meta.bar&&chart.isDatasetVisible(i)&&(stacked===false||(stacked===true&&stacks.indexOf(meta.stack)===-1)||(stacked===undefined&&(meta.stack===undefined||stacks.indexOf(meta.stack)===-1)))){stacks.push(meta.stack);}}
return stacks;},getStackCount:function(){return this._getStacks().length;},getStackIndex:function(datasetIndex,name){var stacks=this._getStacks(datasetIndex);var index=(name!==undefined)?stacks.indexOf(name):-1;return(index===-1)?stacks.length-1:index;},getRuler:function(){var me=this;var scale=me.getIndexScale();var stackCount=me.getStackCount();var datasetIndex=me.index;var isHorizontal=scale.isHorizontal();var start=isHorizontal?scale.left:scale.top;var end=start+(isHorizontal?scale.width:scale.height);var pixels=[];var i,ilen,min;for(i=0,ilen=me.getMeta().data.length;i<ilen;++i){pixels.push(scale.getPixelForValue(null,i,datasetIndex));}
min=helpers.isNullOrUndef(scale.options.barThickness)?computeMinSampleSize(scale,pixels):-1;return{min:min,pixels:pixels,start:start,end:end,stackCount:stackCount,scale:scale};},calculateBarValuePixels:function(datasetIndex,index){var me=this;var chart=me.chart;var meta=me.getMeta();var scale=me.getValueScale();var datasets=chart.data.datasets;var value=scale.getRightValue(datasets[datasetIndex].data[index]);var stacked=scale.options.stacked;var stack=meta.stack;var start=0;var i,imeta,ivalue,base,head,size;if(stacked||(stacked===undefined&&stack!==undefined)){for(i=0;i<datasetIndex;++i){imeta=chart.getDatasetMeta(i);if(imeta.bar&&imeta.stack===stack&&imeta.controller.getValueScaleId()===scale.id&&chart.isDatasetVisible(i)){ivalue=scale.getRightValue(datasets[i].data[index]);if((value<0&&ivalue<0)||(value>=0&&ivalue>0)){start+=ivalue;}}}}
base=scale.getPixelForValue(start);head=scale.getPixelForValue(start+value);size=(head-base)/2;return{size:size,base:base,head:head,center:head+size/2};},calculateBarIndexPixels:function(datasetIndex,index,ruler){var me=this;var options=ruler.scale.options;var range=options.barThickness==='flex'?computeFlexCategoryTraits(index,ruler,options):computeFitCategoryTraits(index,ruler,options);var stackIndex=me.getStackIndex(datasetIndex,me.getMeta().stack);var center=range.start+(range.chunk*stackIndex)+(range.chunk/2);var size=Math.min(helpers.valueOrDefault(options.maxBarThickness,Infinity),range.chunk*range.ratio);return{base:center-size/2,head:center+size/2,center:center,size:size};},draw:function(){var me=this;var chart=me.chart;var scale=me.getValueScale();var rects=me.getMeta().data;var dataset=me.getDataset();var ilen=rects.length;var i=0;helpers.canvas.clipArea(chart.ctx,chart.chartArea);for(;i<ilen;++i){if(!isNaN(scale.getRightValue(dataset.data[i]))){rects[i].draw();}}
helpers.canvas.unclipArea(chart.ctx);},setHoverStyle:function(rectangle){var dataset=this.chart.data.datasets[rectangle._datasetIndex];var index=rectangle._index;var custom=rectangle.custom||{};var model=rectangle._model;model.backgroundColor=custom.hoverBackgroundColor?custom.hoverBackgroundColor:helpers.valueAtIndexOrDefault(dataset.hoverBackgroundColor,index,helpers.getHoverColor(model.backgroundColor));model.borderColor=custom.hoverBorderColor?custom.hoverBorderColor:helpers.valueAtIndexOrDefault(dataset.hoverBorderColor,index,helpers.getHoverColor(model.borderColor));model.borderWidth=custom.hoverBorderWidth?custom.hoverBorderWidth:helpers.valueAtIndexOrDefault(dataset.hoverBorderWidth,index,model.borderWidth);},removeHoverStyle:function(rectangle){var dataset=this.chart.data.datasets[rectangle._datasetIndex];var index=rectangle._index;var custom=rectangle.custom||{};var model=rectangle._model;var rectangleElementOptions=this.chart.options.elements.rectangle;model.backgroundColor=custom.backgroundColor?custom.backgroundColor:helpers.valueAtIndexOrDefault(dataset.backgroundColor,index,rectangleElementOptions.backgroundColor);model.borderColor=custom.borderColor?custom.borderColor:helpers.valueAtIndexOrDefault(dataset.borderColor,index,rectangleElementOptions.borderColor);model.borderWidth=custom.borderWidth?custom.borderWidth:helpers.valueAtIndexOrDefault(dataset.borderWidth,index,rectangleElementOptions.borderWidth);}});Chart.controllers.horizontalBar=Chart.controllers.bar.extend({getValueScaleId:function(){return this.getMeta().xAxisID;},getIndexScaleId:function(){return this.getMeta().yAxisID;}});};},{"25":25,"40":40,"45":45}],16:[function(require,module,exports){'use strict';var defaults=require(25);var elements=require(40);var helpers=require(45);defaults._set('bubble',{hover:{mode:'single'},scales:{xAxes:[{type:'linear',position:'bottom',id:'x-axis-0'}],yAxes:[{type:'linear',position:'left',id:'y-axis-0'}]},tooltips:{callbacks:{title:function(){return'';},label:function(item,data){var datasetLabel=data.datasets[item.datasetIndex].label||'';var dataPoint=data.datasets[item.datasetIndex].data[item.index];return datasetLabel+': ('+item.xLabel+', '+item.yLabel+', '+dataPoint.r+')';}}}});module.exports=function(Chart){Chart.controllers.bubble=Chart.DatasetController.extend({dataElementType:elements.Point,update:function(reset){var me=this;var meta=me.getMeta();var points=meta.data;helpers.each(points,function(point,index){me.updateElement(point,index,reset);});},updateElement:function(point,index,reset){var me=this;var meta=me.getMeta();var custom=point.custom||{};var xScale=me.getScaleForId(meta.xAxisID);var yScale=me.getScaleForId(meta.yAxisID);var options=me._resolveElementOptions(point,index);var data=me.getDataset().data[index];var dsIndex=me.index;var x=reset?xScale.getPixelForDecimal(0.5):xScale.getPixelForValue(typeof data==='object'?data:NaN,index,dsIndex);var y=reset?yScale.getBasePixel():yScale.getPixelForValue(data,index,dsIndex);point._xScale=xScale;point._yScale=yScale;point._options=options;point._datasetIndex=dsIndex;point._index=index;point._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,hitRadius:options.hitRadius,pointStyle:options.pointStyle,radius:reset?0:options.radius,skip:custom.skip||isNaN(x)||isNaN(y),x:x,y:y,};point.pivot();},setHoverStyle:function(point){var model=point._model;var options=point._options;model.backgroundColor=helpers.valueOrDefault(options.hoverBackgroundColor,helpers.getHoverColor(options.backgroundColor));model.borderColor=helpers.valueOrDefault(options.hoverBorderColor,helpers.getHoverColor(options.borderColor));model.borderWidth=helpers.valueOrDefault(options.hoverBorderWidth,options.borderWidth);model.radius=options.radius+options.hoverRadius;},removeHoverStyle:function(point){var model=point._model;var options=point._options;model.backgroundColor=options.backgroundColor;model.borderColor=options.borderColor;model.borderWidth=options.borderWidth;model.radius=options.radius;},_resolveElementOptions:function(point,index){var me=this;var chart=me.chart;var datasets=chart.data.datasets;var dataset=datasets[me.index];var custom=point.custom||{};var options=chart.options.elements.point;var resolve=helpers.options.resolve;var data=dataset.data[index];var values={};var i,ilen,key;var context={chart:chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};var keys=['backgroundColor','borderColor','borderWidth','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth','hoverRadius','hitRadius','pointStyle'];for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];values[key]=resolve([custom[key],dataset[key],options[key]],context,index);}
values.radius=resolve([custom.radius,data?data.r:undefined,dataset.radius,options.radius],context,index);return values;}});};},{"25":25,"40":40,"45":45}],17:[function(require,module,exports){'use strict';var defaults=require(25);var elements=require(40);var helpers=require(45);defaults._set('doughnut',{animation:{animateRotate:true,animateScale:false},hover:{mode:'single'},legendCallback:function(chart){var text=[];text.push('<ul class="'+chart.id+'-legend">');var data=chart.data;var datasets=data.datasets;var labels=data.labels;if(datasets.length){for(var i=0;i<datasets[0].data.length;++i){text.push('<li><span style="background-color:'+datasets[0].backgroundColor[i]+'"></span>');if(labels[i]){text.push(labels[i]);}
text.push('</li>');}}
text.push('</ul>');return text.join('');},legend:{labels:{generateLabels:function(chart){var data=chart.data;if(data.labels.length&&data.datasets.length){return data.labels.map(function(label,i){var meta=chart.getDatasetMeta(0);var ds=data.datasets[0];var arc=meta.data[i];var custom=arc&&arc.custom||{};var valueAtIndexOrDefault=helpers.valueAtIndexOrDefault;var arcOpts=chart.options.elements.arc;var fill=custom.backgroundColor?custom.backgroundColor:valueAtIndexOrDefault(ds.backgroundColor,i,arcOpts.backgroundColor);var stroke=custom.borderColor?custom.borderColor:valueAtIndexOrDefault(ds.borderColor,i,arcOpts.borderColor);var bw=custom.borderWidth?custom.borderWidth:valueAtIndexOrDefault(ds.borderWidth,i,arcOpts.borderWidth);return{text:label,fillStyle:fill,strokeStyle:stroke,lineWidth:bw,hidden:isNaN(ds.data[i])||meta.data[i].hidden,index:i};});}
return[];}},onClick:function(e,legendItem){var index=legendItem.index;var chart=this.chart;var i,ilen,meta;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){meta=chart.getDatasetMeta(i);if(meta.data[index]){meta.data[index].hidden=!meta.data[index].hidden;}}
chart.update();}},cutoutPercentage:50,rotation:Math.PI*-0.5,circumference:Math.PI*2.0,tooltips:{callbacks:{title:function(){return'';},label:function(tooltipItem,data){var dataLabel=data.labels[tooltipItem.index];var value=': '+data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];if(helpers.isArray(dataLabel)){dataLabel=dataLabel.slice();dataLabel[0]+=value;}else{dataLabel+=value;}
return dataLabel;}}}});defaults._set('pie',helpers.clone(defaults.doughnut));defaults._set('pie',{cutoutPercentage:0});module.exports=function(Chart){Chart.controllers.doughnut=Chart.controllers.pie=Chart.DatasetController.extend({dataElementType:elements.Arc,linkScales:helpers.noop,getRingIndex:function(datasetIndex){var ringIndex=0;for(var j=0;j<datasetIndex;++j){if(this.chart.isDatasetVisible(j)){++ringIndex;}}
return ringIndex;},update:function(reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var arcOpts=opts.elements.arc;var availableWidth=chartArea.right-chartArea.left-arcOpts.borderWidth;var availableHeight=chartArea.bottom-chartArea.top-arcOpts.borderWidth;var minSize=Math.min(availableWidth,availableHeight);var offset={x:0,y:0};var meta=me.getMeta();var cutoutPercentage=opts.cutoutPercentage;var circumference=opts.circumference;if(circumference<Math.PI*2.0){var startAngle=opts.rotation%(Math.PI*2.0);startAngle+=Math.PI*2.0*(startAngle>=Math.PI?-1:startAngle<-Math.PI?1:0);var endAngle=startAngle+circumference;var start={x:Math.cos(startAngle),y:Math.sin(startAngle)};var end={x:Math.cos(endAngle),y:Math.sin(endAngle)};var contains0=(startAngle<=0&&endAngle>=0)||(startAngle<=Math.PI*2.0&&Math.PI*2.0<=endAngle);var contains90=(startAngle<=Math.PI*0.5&&Math.PI*0.5<=endAngle)||(startAngle<=Math.PI*2.5&&Math.PI*2.5<=endAngle);var contains180=(startAngle<=-Math.PI&&-Math.PI<=endAngle)||(startAngle<=Math.PI&&Math.PI<=endAngle);var contains270=(startAngle<=-Math.PI*0.5&&-Math.PI*0.5<=endAngle)||(startAngle<=Math.PI*1.5&&Math.PI*1.5<=endAngle);var cutout=cutoutPercentage/100.0;var min={x:contains180?-1:Math.min(start.x*(start.x<0?1:cutout),end.x*(end.x<0?1:cutout)),y:contains270?-1:Math.min(start.y*(start.y<0?1:cutout),end.y*(end.y<0?1:cutout))};var max={x:contains0?1:Math.max(start.x*(start.x>0?1:cutout),end.x*(end.x>0?1:cutout)),y:contains90?1:Math.max(start.y*(start.y>0?1:cutout),end.y*(end.y>0?1:cutout))};var size={width:(max.x-min.x)*0.5,height:(max.y-min.y)*0.5};minSize=Math.min(availableWidth/size.width,availableHeight/size.height);offset={x:(max.x+min.x)*-0.5,y:(max.y+min.y)*-0.5};}
chart.borderWidth=me.getMaxBorderWidth(meta.data);chart.outerRadius=Math.max((minSize-chart.borderWidth)/2,0);chart.innerRadius=Math.max(cutoutPercentage?(chart.outerRadius/100)*(cutoutPercentage):0,0);chart.radiusLength=(chart.outerRadius-chart.innerRadius)/chart.getVisibleDatasetCount();chart.offsetX=offset.x*chart.outerRadius;chart.offsetY=offset.y*chart.outerRadius;meta.total=me.calculateTotal();me.outerRadius=chart.outerRadius-(chart.radiusLength*me.getRingIndex(me.index));me.innerRadius=Math.max(me.outerRadius-chart.radiusLength,0);helpers.each(meta.data,function(arc,index){me.updateElement(arc,index,reset);});},updateElement:function(arc,index,reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var animationOpts=opts.animation;var centerX=(chartArea.left+chartArea.right)/2;var centerY=(chartArea.top+chartArea.bottom)/2;var startAngle=opts.rotation;var endAngle=opts.rotation;var dataset=me.getDataset();var circumference=reset&&animationOpts.animateRotate?0:arc.hidden?0:me.calculateCircumference(dataset.data[index])*(opts.circumference/(2.0*Math.PI));var innerRadius=reset&&animationOpts.animateScale?0:me.innerRadius;var outerRadius=reset&&animationOpts.animateScale?0:me.outerRadius;var valueAtIndexOrDefault=helpers.valueAtIndexOrDefault;helpers.extend(arc,{_datasetIndex:me.index,_index:index,_model:{x:centerX+chart.offsetX,y:centerY+chart.offsetY,startAngle:startAngle,endAngle:endAngle,circumference:circumference,outerRadius:outerRadius,innerRadius:innerRadius,label:valueAtIndexOrDefault(dataset.label,index,chart.data.labels[index])}});var model=arc._model;this.removeHoverStyle(arc);if(!reset||!animationOpts.animateRotate){if(index===0){model.startAngle=opts.rotation;}else{model.startAngle=me.getMeta().data[index-1]._model.endAngle;}
model.endAngle=model.startAngle+model.circumference;}
arc.pivot();},removeHoverStyle:function(arc){Chart.DatasetController.prototype.removeHoverStyle.call(this,arc,this.chart.options.elements.arc);},calculateTotal:function(){var dataset=this.getDataset();var meta=this.getMeta();var total=0;var value;helpers.each(meta.data,function(element,index){value=dataset.data[index];if(!isNaN(value)&&!element.hidden){total+=Math.abs(value);}});return total;},calculateCircumference:function(value){var total=this.getMeta().total;if(total>0&&!isNaN(value)){return(Math.PI*2.0)*(Math.abs(value)/total);}
return 0;},getMaxBorderWidth:function(arcs){var max=0;var index=this.index;var length=arcs.length;var borderWidth;var hoverWidth;for(var i=0;i<length;i++){borderWidth=arcs[i]._model?arcs[i]._model.borderWidth:0;hoverWidth=arcs[i]._chart?arcs[i]._chart.config.data.datasets[index].hoverBorderWidth:0;max=borderWidth>max?borderWidth:max;max=hoverWidth>max?hoverWidth:max;}
return max;}});};},{"25":25,"40":40,"45":45}],18:[function(require,module,exports){'use strict';var defaults=require(25);var elements=require(40);var helpers=require(45);defaults._set('line',{showLines:true,spanGaps:false,hover:{mode:'label'},scales:{xAxes:[{type:'category',id:'x-axis-0'}],yAxes:[{type:'linear',id:'y-axis-0'}]}});module.exports=function(Chart){function lineEnabled(dataset,options){return helpers.valueOrDefault(dataset.showLine,options.showLines);}
Chart.controllers.line=Chart.DatasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,update:function(reset){var me=this;var meta=me.getMeta();var line=meta.dataset;var points=meta.data||[];var options=me.chart.options;var lineElementOptions=options.elements.line;var scale=me.getScaleForId(meta.yAxisID);var i,ilen,custom;var dataset=me.getDataset();var showLine=lineEnabled(dataset,options);if(showLine){custom=line.custom||{};if((dataset.tension!==undefined)&&(dataset.lineTension===undefined)){dataset.lineTension=dataset.tension;}
line._scale=scale;line._datasetIndex=me.index;line._children=points;line._model={spanGaps:dataset.spanGaps?dataset.spanGaps:options.spanGaps,tension:custom.tension?custom.tension:helpers.valueOrDefault(dataset.lineTension,lineElementOptions.tension),backgroundColor:custom.backgroundColor?custom.backgroundColor:(dataset.backgroundColor||lineElementOptions.backgroundColor),borderWidth:custom.borderWidth?custom.borderWidth:(dataset.borderWidth||lineElementOptions.borderWidth),borderColor:custom.borderColor?custom.borderColor:(dataset.borderColor||lineElementOptions.borderColor),borderCapStyle:custom.borderCapStyle?custom.borderCapStyle:(dataset.borderCapStyle||lineElementOptions.borderCapStyle),borderDash:custom.borderDash?custom.borderDash:(dataset.borderDash||lineElementOptions.borderDash),borderDashOffset:custom.borderDashOffset?custom.borderDashOffset:(dataset.borderDashOffset||lineElementOptions.borderDashOffset),borderJoinStyle:custom.borderJoinStyle?custom.borderJoinStyle:(dataset.borderJoinStyle||lineElementOptions.borderJoinStyle),fill:custom.fill?custom.fill:(dataset.fill!==undefined?dataset.fill:lineElementOptions.fill),steppedLine:custom.steppedLine?custom.steppedLine:helpers.valueOrDefault(dataset.steppedLine,lineElementOptions.stepped),cubicInterpolationMode:custom.cubicInterpolationMode?custom.cubicInterpolationMode:helpers.valueOrDefault(dataset.cubicInterpolationMode,lineElementOptions.cubicInterpolationMode),};line.pivot();}
for(i=0,ilen=points.length;i<ilen;++i){me.updateElement(points[i],i,reset);}
if(showLine&&line._model.tension!==0){me.updateBezierControlPoints();}
for(i=0,ilen=points.length;i<ilen;++i){points[i].pivot();}},getPointBackgroundColor:function(point,index){var backgroundColor=this.chart.options.elements.point.backgroundColor;var dataset=this.getDataset();var custom=point.custom||{};if(custom.backgroundColor){backgroundColor=custom.backgroundColor;}else if(dataset.pointBackgroundColor){backgroundColor=helpers.valueAtIndexOrDefault(dataset.pointBackgroundColor,index,backgroundColor);}else if(dataset.backgroundColor){backgroundColor=dataset.backgroundColor;}
return backgroundColor;},getPointBorderColor:function(point,index){var borderColor=this.chart.options.elements.point.borderColor;var dataset=this.getDataset();var custom=point.custom||{};if(custom.borderColor){borderColor=custom.borderColor;}else if(dataset.pointBorderColor){borderColor=helpers.valueAtIndexOrDefault(dataset.pointBorderColor,index,borderColor);}else if(dataset.borderColor){borderColor=dataset.borderColor;}
return borderColor;},getPointBorderWidth:function(point,index){var borderWidth=this.chart.options.elements.point.borderWidth;var dataset=this.getDataset();var custom=point.custom||{};if(!isNaN(custom.borderWidth)){borderWidth=custom.borderWidth;}else if(!isNaN(dataset.pointBorderWidth)||helpers.isArray(dataset.pointBorderWidth)){borderWidth=helpers.valueAtIndexOrDefault(dataset.pointBorderWidth,index,borderWidth);}else if(!isNaN(dataset.borderWidth)){borderWidth=dataset.borderWidth;}
return borderWidth;},updateElement:function(point,index,reset){var me=this;var meta=me.getMeta();var custom=point.custom||{};var dataset=me.getDataset();var datasetIndex=me.index;var value=dataset.data[index];var yScale=me.getScaleForId(meta.yAxisID);var xScale=me.getScaleForId(meta.xAxisID);var pointOptions=me.chart.options.elements.point;var x,y;if((dataset.radius!==undefined)&&(dataset.pointRadius===undefined)){dataset.pointRadius=dataset.radius;}
if((dataset.hitRadius!==undefined)&&(dataset.pointHitRadius===undefined)){dataset.pointHitRadius=dataset.hitRadius;}
x=xScale.getPixelForValue(typeof value==='object'?value:NaN,index,datasetIndex);y=reset?yScale.getBasePixel():me.calculatePointY(value,index,datasetIndex);point._xScale=xScale;point._yScale=yScale;point._datasetIndex=datasetIndex;point._index=index;point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:custom.radius||helpers.valueAtIndexOrDefault(dataset.pointRadius,index,pointOptions.radius),pointStyle:custom.pointStyle||helpers.valueAtIndexOrDefault(dataset.pointStyle,index,pointOptions.pointStyle),backgroundColor:me.getPointBackgroundColor(point,index),borderColor:me.getPointBorderColor(point,index),borderWidth:me.getPointBorderWidth(point,index),tension:meta.dataset._model?meta.dataset._model.tension:0,steppedLine:meta.dataset._model?meta.dataset._model.steppedLine:false,hitRadius:custom.hitRadius||helpers.valueAtIndexOrDefault(dataset.pointHitRadius,index,pointOptions.hitRadius)};},calculatePointY:function(value,index,datasetIndex){var me=this;var chart=me.chart;var meta=me.getMeta();var yScale=me.getScaleForId(meta.yAxisID);var sumPos=0;var sumNeg=0;var i,ds,dsMeta;if(yScale.options.stacked){for(i=0;i<datasetIndex;i++){ds=chart.data.datasets[i];dsMeta=chart.getDatasetMeta(i);if(dsMeta.type==='line'&&dsMeta.yAxisID===yScale.id&&chart.isDatasetVisible(i)){var stackedRightValue=Number(yScale.getRightValue(ds.data[index]));if(stackedRightValue<0){sumNeg+=stackedRightValue||0;}else{sumPos+=stackedRightValue||0;}}}
var rightValue=Number(yScale.getRightValue(value));if(rightValue<0){return yScale.getPixelForValue(sumNeg+rightValue);}
return yScale.getPixelForValue(sumPos+rightValue);}
return yScale.getPixelForValue(value);},updateBezierControlPoints:function(){var me=this;var meta=me.getMeta();var area=me.chart.chartArea;var points=(meta.data||[]);var i,ilen,point,model,controlPoints;if(meta.dataset._model.spanGaps){points=points.filter(function(pt){return!pt._model.skip;});}
function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min);}
if(meta.dataset._model.cubicInterpolationMode==='monotone'){helpers.splineCurveMonotone(points);}else{for(i=0,ilen=points.length;i<ilen;++i){point=points[i];model=point._model;controlPoints=helpers.splineCurve(helpers.previousItem(points,i)._model,model,helpers.nextItem(points,i)._model,meta.dataset._model.tension);model.controlPointPreviousX=controlPoints.previous.x;model.controlPointPreviousY=controlPoints.previous.y;model.controlPointNextX=controlPoints.next.x;model.controlPointNextY=controlPoints.next.y;}}
if(me.chart.options.elements.line.capBezierPoints){for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;model.controlPointPreviousX=capControlPoint(model.controlPointPreviousX,area.left,area.right);model.controlPointPreviousY=capControlPoint(model.controlPointPreviousY,area.top,area.bottom);model.controlPointNextX=capControlPoint(model.controlPointNextX,area.left,area.right);model.controlPointNextY=capControlPoint(model.controlPointNextY,area.top,area.bottom);}}},draw:function(){var me=this;var chart=me.chart;var meta=me.getMeta();var points=meta.data||[];var area=chart.chartArea;var ilen=points.length;var i=0;helpers.canvas.clipArea(chart.ctx,area);if(lineEnabled(me.getDataset(),chart.options)){meta.dataset.draw();}
helpers.canvas.unclipArea(chart.ctx);for(;i<ilen;++i){points[i].draw(area);}},setHoverStyle:function(point){var dataset=this.chart.data.datasets[point._datasetIndex];var index=point._index;var custom=point.custom||{};var model=point._model;model.radius=custom.hoverRadius||helpers.valueAtIndexOrDefault(dataset.pointHoverRadius,index,this.chart.options.elements.point.hoverRadius);model.backgroundColor=custom.hoverBackgroundColor||helpers.valueAtIndexOrDefault(dataset.pointHoverBackgroundColor,index,helpers.getHoverColor(model.backgroundColor));model.borderColor=custom.hoverBorderColor||helpers.valueAtIndexOrDefault(dataset.pointHoverBorderColor,index,helpers.getHoverColor(model.borderColor));model.borderWidth=custom.hoverBorderWidth||helpers.valueAtIndexOrDefault(dataset.pointHoverBorderWidth,index,model.borderWidth);},removeHoverStyle:function(point){var me=this;var dataset=me.chart.data.datasets[point._datasetIndex];var index=point._index;var custom=point.custom||{};var model=point._model;if((dataset.radius!==undefined)&&(dataset.pointRadius===undefined)){dataset.pointRadius=dataset.radius;}
model.radius=custom.radius||helpers.valueAtIndexOrDefault(dataset.pointRadius,index,me.chart.options.elements.point.radius);model.backgroundColor=me.getPointBackgroundColor(point,index);model.borderColor=me.getPointBorderColor(point,index);model.borderWidth=me.getPointBorderWidth(point,index);}});};},{"25":25,"40":40,"45":45}],19:[function(require,module,exports){'use strict';var defaults=require(25);var elements=require(40);var helpers=require(45);defaults._set('polarArea',{scale:{type:'radialLinear',angleLines:{display:false},gridLines:{circular:true},pointLabels:{display:false},ticks:{beginAtZero:true}},animation:{animateRotate:true,animateScale:true},startAngle:-0.5*Math.PI,legendCallback:function(chart){var text=[];text.push('<ul class="'+chart.id+'-legend">');var data=chart.data;var datasets=data.datasets;var labels=data.labels;if(datasets.length){for(var i=0;i<datasets[0].data.length;++i){text.push('<li><span style="background-color:'+datasets[0].backgroundColor[i]+'"></span>');if(labels[i]){text.push(labels[i]);}
text.push('</li>');}}
text.push('</ul>');return text.join('');},legend:{labels:{generateLabels:function(chart){var data=chart.data;if(data.labels.length&&data.datasets.length){return data.labels.map(function(label,i){var meta=chart.getDatasetMeta(0);var ds=data.datasets[0];var arc=meta.data[i];var custom=arc.custom||{};var valueAtIndexOrDefault=helpers.valueAtIndexOrDefault;var arcOpts=chart.options.elements.arc;var fill=custom.backgroundColor?custom.backgroundColor:valueAtIndexOrDefault(ds.backgroundColor,i,arcOpts.backgroundColor);var stroke=custom.borderColor?custom.borderColor:valueAtIndexOrDefault(ds.borderColor,i,arcOpts.borderColor);var bw=custom.borderWidth?custom.borderWidth:valueAtIndexOrDefault(ds.borderWidth,i,arcOpts.borderWidth);return{text:label,fillStyle:fill,strokeStyle:stroke,lineWidth:bw,hidden:isNaN(ds.data[i])||meta.data[i].hidden,index:i};});}
return[];}},onClick:function(e,legendItem){var index=legendItem.index;var chart=this.chart;var i,ilen,meta;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){meta=chart.getDatasetMeta(i);meta.data[index].hidden=!meta.data[index].hidden;}
chart.update();}},tooltips:{callbacks:{title:function(){return'';},label:function(item,data){return data.labels[item.index]+': '+item.yLabel;}}}});module.exports=function(Chart){Chart.controllers.polarArea=Chart.DatasetController.extend({dataElementType:elements.Arc,linkScales:helpers.noop,update:function(reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var meta=me.getMeta();var opts=chart.options;var arcOpts=opts.elements.arc;var minSize=Math.min(chartArea.right-chartArea.left,chartArea.bottom-chartArea.top);chart.outerRadius=Math.max((minSize-arcOpts.borderWidth/2)/2,0);chart.innerRadius=Math.max(opts.cutoutPercentage?(chart.outerRadius/100)*(opts.cutoutPercentage):1,0);chart.radiusLength=(chart.outerRadius-chart.innerRadius)/chart.getVisibleDatasetCount();me.outerRadius=chart.outerRadius-(chart.radiusLength*me.index);me.innerRadius=me.outerRadius-chart.radiusLength;meta.count=me.countVisibleElements();helpers.each(meta.data,function(arc,index){me.updateElement(arc,index,reset);});},updateElement:function(arc,index,reset){var me=this;var chart=me.chart;var dataset=me.getDataset();var opts=chart.options;var animationOpts=opts.animation;var scale=chart.scale;var labels=chart.data.labels;var circumference=me.calculateCircumference(dataset.data[index]);var centerX=scale.xCenter;var centerY=scale.yCenter;var visibleCount=0;var meta=me.getMeta();for(var i=0;i<index;++i){if(!isNaN(dataset.data[i])&&!meta.data[i].hidden){++visibleCount;}}
var datasetStartAngle=opts.startAngle;var distance=arc.hidden?0:scale.getDistanceFromCenterForValue(dataset.data[index]);var startAngle=datasetStartAngle+(circumference*visibleCount);var endAngle=startAngle+(arc.hidden?0:circumference);var resetRadius=animationOpts.animateScale?0:scale.getDistanceFromCenterForValue(dataset.data[index]);helpers.extend(arc,{_datasetIndex:me.index,_index:index,_scale:scale,_model:{x:centerX,y:centerY,innerRadius:0,outerRadius:reset?resetRadius:distance,startAngle:reset&&animationOpts.animateRotate?datasetStartAngle:startAngle,endAngle:reset&&animationOpts.animateRotate?datasetStartAngle:endAngle,label:helpers.valueAtIndexOrDefault(labels,index,labels[index])}});me.removeHoverStyle(arc);arc.pivot();},removeHoverStyle:function(arc){Chart.DatasetController.prototype.removeHoverStyle.call(this,arc,this.chart.options.elements.arc);},countVisibleElements:function(){var dataset=this.getDataset();var meta=this.getMeta();var count=0;helpers.each(meta.data,function(element,index){if(!isNaN(dataset.data[index])&&!element.hidden){count++;}});return count;},calculateCircumference:function(value){var count=this.getMeta().count;if(count>0&&!isNaN(value)){return(2*Math.PI)/count;}
return 0;}});};},{"25":25,"40":40,"45":45}],20:[function(require,module,exports){'use strict';var defaults=require(25);var elements=require(40);var helpers=require(45);defaults._set('radar',{scale:{type:'radialLinear'},elements:{line:{tension:0}}});module.exports=function(Chart){Chart.controllers.radar=Chart.DatasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,linkScales:helpers.noop,update:function(reset){var me=this;var meta=me.getMeta();var line=meta.dataset;var points=meta.data;var custom=line.custom||{};var dataset=me.getDataset();var lineElementOptions=me.chart.options.elements.line;var scale=me.chart.scale;if((dataset.tension!==undefined)&&(dataset.lineTension===undefined)){dataset.lineTension=dataset.tension;}
helpers.extend(meta.dataset,{_datasetIndex:me.index,_scale:scale,_children:points,_loop:true,_model:{tension:custom.tension?custom.tension:helpers.valueOrDefault(dataset.lineTension,lineElementOptions.tension),backgroundColor:custom.backgroundColor?custom.backgroundColor:(dataset.backgroundColor||lineElementOptions.backgroundColor),borderWidth:custom.borderWidth?custom.borderWidth:(dataset.borderWidth||lineElementOptions.borderWidth),borderColor:custom.borderColor?custom.borderColor:(dataset.borderColor||lineElementOptions.borderColor),fill:custom.fill?custom.fill:(dataset.fill!==undefined?dataset.fill:lineElementOptions.fill),borderCapStyle:custom.borderCapStyle?custom.borderCapStyle:(dataset.borderCapStyle||lineElementOptions.borderCapStyle),borderDash:custom.borderDash?custom.borderDash:(dataset.borderDash||lineElementOptions.borderDash),borderDashOffset:custom.borderDashOffset?custom.borderDashOffset:(dataset.borderDashOffset||lineElementOptions.borderDashOffset),borderJoinStyle:custom.borderJoinStyle?custom.borderJoinStyle:(dataset.borderJoinStyle||lineElementOptions.borderJoinStyle),}});meta.dataset.pivot();helpers.each(points,function(point,index){me.updateElement(point,index,reset);},me);me.updateBezierControlPoints();},updateElement:function(point,index,reset){var me=this;var custom=point.custom||{};var dataset=me.getDataset();var scale=me.chart.scale;var pointElementOptions=me.chart.options.elements.point;var pointPosition=scale.getPointPositionForValue(index,dataset.data[index]);if((dataset.radius!==undefined)&&(dataset.pointRadius===undefined)){dataset.pointRadius=dataset.radius;}
if((dataset.hitRadius!==undefined)&&(dataset.pointHitRadius===undefined)){dataset.pointHitRadius=dataset.hitRadius;}
helpers.extend(point,{_datasetIndex:me.index,_index:index,_scale:scale,_model:{x:reset?scale.xCenter:pointPosition.x,y:reset?scale.yCenter:pointPosition.y,tension:custom.tension?custom.tension:helpers.valueOrDefault(dataset.lineTension,me.chart.options.elements.line.tension),radius:custom.radius?custom.radius:helpers.valueAtIndexOrDefault(dataset.pointRadius,index,pointElementOptions.radius),backgroundColor:custom.backgroundColor?custom.backgroundColor:helpers.valueAtIndexOrDefault(dataset.pointBackgroundColor,index,pointElementOptions.backgroundColor),borderColor:custom.borderColor?custom.borderColor:helpers.valueAtIndexOrDefault(dataset.pointBorderColor,index,pointElementOptions.borderColor),borderWidth:custom.borderWidth?custom.borderWidth:helpers.valueAtIndexOrDefault(dataset.pointBorderWidth,index,pointElementOptions.borderWidth),pointStyle:custom.pointStyle?custom.pointStyle:helpers.valueAtIndexOrDefault(dataset.pointStyle,index,pointElementOptions.pointStyle),hitRadius:custom.hitRadius?custom.hitRadius:helpers.valueAtIndexOrDefault(dataset.pointHitRadius,index,pointElementOptions.hitRadius)}});point._model.skip=custom.skip?custom.skip:(isNaN(point._model.x)||isNaN(point._model.y));},updateBezierControlPoints:function(){var chartArea=this.chart.chartArea;var meta=this.getMeta();helpers.each(meta.data,function(point,index){var model=point._model;var controlPoints=helpers.splineCurve(helpers.previousItem(meta.data,index,true)._model,model,helpers.nextItem(meta.data,index,true)._model,model.tension);model.controlPointPreviousX=Math.max(Math.min(controlPoints.previous.x,chartArea.right),chartArea.left);model.controlPointPreviousY=Math.max(Math.min(controlPoints.previous.y,chartArea.bottom),chartArea.top);model.controlPointNextX=Math.max(Math.min(controlPoints.next.x,chartArea.right),chartArea.left);model.controlPointNextY=Math.max(Math.min(controlPoints.next.y,chartArea.bottom),chartArea.top);point.pivot();});},setHoverStyle:function(point){var dataset=this.chart.data.datasets[point._datasetIndex];var custom=point.custom||{};var index=point._index;var model=point._model;model.radius=custom.hoverRadius?custom.hoverRadius:helpers.valueAtIndexOrDefault(dataset.pointHoverRadius,index,this.chart.options.elements.point.hoverRadius);model.backgroundColor=custom.hoverBackgroundColor?custom.hoverBackgroundColor:helpers.valueAtIndexOrDefault(dataset.pointHoverBackgroundColor,index,helpers.getHoverColor(model.backgroundColor));model.borderColor=custom.hoverBorderColor?custom.hoverBorderColor:helpers.valueAtIndexOrDefault(dataset.pointHoverBorderColor,index,helpers.getHoverColor(model.borderColor));model.borderWidth=custom.hoverBorderWidth?custom.hoverBorderWidth:helpers.valueAtIndexOrDefault(dataset.pointHoverBorderWidth,index,model.borderWidth);},removeHoverStyle:function(point){var dataset=this.chart.data.datasets[point._datasetIndex];var custom=point.custom||{};var index=point._index;var model=point._model;var pointElementOptions=this.chart.options.elements.point;model.radius=custom.radius?custom.radius:helpers.valueAtIndexOrDefault(dataset.pointRadius,index,pointElementOptions.radius);model.backgroundColor=custom.backgroundColor?custom.backgroundColor:helpers.valueAtIndexOrDefault(dataset.pointBackgroundColor,index,pointElementOptions.backgroundColor);model.borderColor=custom.borderColor?custom.borderColor:helpers.valueAtIndexOrDefault(dataset.pointBorderColor,index,pointElementOptions.borderColor);model.borderWidth=custom.borderWidth?custom.borderWidth:helpers.valueAtIndexOrDefault(dataset.pointBorderWidth,index,pointElementOptions.borderWidth);}});};},{"25":25,"40":40,"45":45}],21:[function(require,module,exports){'use strict';var defaults=require(25);defaults._set('scatter',{hover:{mode:'single'},scales:{xAxes:[{id:'x-axis-1',type:'linear',position:'bottom'}],yAxes:[{id:'y-axis-1',type:'linear',position:'left'}]},showLines:false,tooltips:{callbacks:{title:function(){return'';},label:function(item){return'('+item.xLabel+', '+item.yLabel+')';}}}});module.exports=function(Chart){Chart.controllers.scatter=Chart.controllers.line;};},{"25":25}],22:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);var helpers=require(45);defaults._set('global',{animation:{duration:1000,easing:'easeOutQuart',onProgress:helpers.noop,onComplete:helpers.noop}});module.exports=function(Chart){Chart.Animation=Element.extend({chart:null,currentStep:0,numSteps:60,easing:'',render:null,onAnimationProgress:null,onAnimationComplete:null,});Chart.animationService={frameDuration:17,animations:[],dropFrames:0,request:null,addAnimation:function(chart,animation,duration,lazy){var animations=this.animations;var i,ilen;animation.chart=chart;if(!lazy){chart.animating=true;}
for(i=0,ilen=animations.length;i<ilen;++i){if(animations[i].chart===chart){animations[i]=animation;return;}}
animations.push(animation);if(animations.length===1){this.requestAnimationFrame();}},cancelAnimation:function(chart){var index=helpers.findIndex(this.animations,function(animation){return animation.chart===chart;});if(index!==-1){this.animations.splice(index,1);chart.animating=false;}},requestAnimationFrame:function(){var me=this;if(me.request===null){me.request=helpers.requestAnimFrame.call(window,function(){me.request=null;me.startDigest();});}},startDigest:function(){var me=this;var startTime=Date.now();var framesToDrop=0;if(me.dropFrames>1){framesToDrop=Math.floor(me.dropFrames);me.dropFrames=me.dropFrames%1;}
me.advance(1+framesToDrop);var endTime=Date.now();me.dropFrames+=(endTime-startTime)/me.frameDuration;if(me.animations.length>0){me.requestAnimationFrame();}},advance:function(count){var animations=this.animations;var animation,chart;var i=0;while(i<animations.length){animation=animations[i];chart=animation.chart;animation.currentStep=(animation.currentStep||0)+count;animation.currentStep=Math.min(animation.currentStep,animation.numSteps);helpers.callback(animation.render,[chart,animation],chart);helpers.callback(animation.onAnimationProgress,[animation],chart);if(animation.currentStep>=animation.numSteps){helpers.callback(animation.onAnimationComplete,[animation],chart);chart.animating=false;animations.splice(i,1);}else{++i;}}}};Object.defineProperty(Chart.Animation.prototype,'animationObject',{get:function(){return this;}});Object.defineProperty(Chart.Animation.prototype,'chartInstance',{get:function(){return this.chart;},set:function(value){this.chart=value;}});};},{"25":25,"26":26,"45":45}],23:[function(require,module,exports){'use strict';var defaults=require(25);var helpers=require(45);var Interaction=require(28);var layouts=require(30);var platform=require(48);var plugins=require(31);module.exports=function(Chart){Chart.types={};Chart.instances={};Chart.controllers={};function initConfig(config){config=config||{};var data=config.data=config.data||{};data.datasets=data.datasets||[];data.labels=data.labels||[];config.options=helpers.configMerge(defaults.global,defaults[config.type],config.options||{});return config;}
function updateConfig(chart){var newOptions=chart.options;helpers.each(chart.scales,function(scale){layouts.removeBox(chart,scale);});newOptions=helpers.configMerge(Chart.defaults.global,Chart.defaults[chart.config.type],newOptions);chart.options=chart.config.options=newOptions;chart.ensureScalesHaveIDs();chart.buildOrUpdateScales();chart.tooltip._options=newOptions.tooltips;chart.tooltip.initialize();}
function positionIsHorizontal(position){return position==='top'||position==='bottom';}
helpers.extend(Chart.prototype,{construct:function(item,config){var me=this;config=initConfig(config);var context=platform.acquireContext(item,config);var canvas=context&&context.canvas;var height=canvas&&canvas.height;var width=canvas&&canvas.width;me.id=helpers.uid();me.ctx=context;me.canvas=canvas;me.config=config;me.width=width;me.height=height;me.aspectRatio=height?width/height:null;me.options=config.options;me._bufferedRender=false;me.chart=me;me.controller=me;Chart.instances[me.id]=me;Object.defineProperty(me,'data',{get:function(){return me.config.data;},set:function(value){me.config.data=value;}});if(!context||!canvas){console.error("Failed to create chart: can't acquire context from the given item");return;}
me.initialize();me.update();},initialize:function(){var me=this;plugins.notify(me,'beforeInit');helpers.retinaScale(me,me.options.devicePixelRatio);me.bindEvents();if(me.options.responsive){me.resize(true);}
me.ensureScalesHaveIDs();me.buildOrUpdateScales();me.initToolTip();plugins.notify(me,'afterInit');return me;},clear:function(){helpers.canvas.clear(this);return this;},stop:function(){Chart.animationService.cancelAnimation(this);return this;},resize:function(silent){var me=this;var options=me.options;var canvas=me.canvas;var aspectRatio=(options.maintainAspectRatio&&me.aspectRatio)||null;var newWidth=Math.max(0,Math.floor(helpers.getMaximumWidth(canvas)));var newHeight=Math.max(0,Math.floor(aspectRatio?newWidth/aspectRatio:helpers.getMaximumHeight(canvas)));if(me.width===newWidth&&me.height===newHeight){return;}
canvas.width=me.width=newWidth;canvas.height=me.height=newHeight;canvas.style.width=newWidth+'px';canvas.style.height=newHeight+'px';helpers.retinaScale(me,options.devicePixelRatio);if(!silent){var newSize={width:newWidth,height:newHeight};plugins.notify(me,'resize',[newSize]);if(me.options.onResize){me.options.onResize(me,newSize);}
me.stop();me.update(me.options.responsiveAnimationDuration);}},ensureScalesHaveIDs:function(){var options=this.options;var scalesOptions=options.scales||{};var scaleOptions=options.scale;helpers.each(scalesOptions.xAxes,function(xAxisOptions,index){xAxisOptions.id=xAxisOptions.id||('x-axis-'+index);});helpers.each(scalesOptions.yAxes,function(yAxisOptions,index){yAxisOptions.id=yAxisOptions.id||('y-axis-'+index);});if(scaleOptions){scaleOptions.id=scaleOptions.id||'scale';}},buildOrUpdateScales:function(){var me=this;var options=me.options;var scales=me.scales||{};var items=[];var updated=Object.keys(scales).reduce(function(obj,id){obj[id]=false;return obj;},{});if(options.scales){items=items.concat((options.scales.xAxes||[]).map(function(xAxisOptions){return{options:xAxisOptions,dtype:'category',dposition:'bottom'};}),(options.scales.yAxes||[]).map(function(yAxisOptions){return{options:yAxisOptions,dtype:'linear',dposition:'left'};}));}
if(options.scale){items.push({options:options.scale,dtype:'radialLinear',isDefault:true,dposition:'chartArea'});}
helpers.each(items,function(item){var scaleOptions=item.options;var id=scaleOptions.id;var scaleType=helpers.valueOrDefault(scaleOptions.type,item.dtype);if(positionIsHorizontal(scaleOptions.position)!==positionIsHorizontal(item.dposition)){scaleOptions.position=item.dposition;}
updated[id]=true;var scale=null;if(id in scales&&scales[id].type===scaleType){scale=scales[id];scale.options=scaleOptions;scale.ctx=me.ctx;scale.chart=me;}else{var scaleClass=Chart.scaleService.getScaleConstructor(scaleType);if(!scaleClass){return;}
scale=new scaleClass({id:id,type:scaleType,options:scaleOptions,ctx:me.ctx,chart:me});scales[scale.id]=scale;}
scale.mergeTicksOptions();if(item.isDefault){me.scale=scale;}});helpers.each(updated,function(hasUpdated,id){if(!hasUpdated){delete scales[id];}});me.scales=scales;Chart.scaleService.addScalesToLayout(this);},buildOrUpdateControllers:function(){var me=this;var types=[];var newControllers=[];helpers.each(me.data.datasets,function(dataset,datasetIndex){var meta=me.getDatasetMeta(datasetIndex);var type=dataset.type||me.config.type;if(meta.type&&meta.type!==type){me.destroyDatasetMeta(datasetIndex);meta=me.getDatasetMeta(datasetIndex);}
meta.type=type;types.push(meta.type);if(meta.controller){meta.controller.updateIndex(datasetIndex);meta.controller.linkScales();}else{var ControllerClass=Chart.controllers[meta.type];if(ControllerClass===undefined){throw new Error('"'+meta.type+'" is not a chart type.');}
meta.controller=new ControllerClass(me,datasetIndex);newControllers.push(meta.controller);}},me);return newControllers;},resetElements:function(){var me=this;helpers.each(me.data.datasets,function(dataset,datasetIndex){me.getDatasetMeta(datasetIndex).controller.reset();},me);},reset:function(){this.resetElements();this.tooltip.initialize();},update:function(config){var me=this;if(!config||typeof config!=='object'){config={duration:config,lazy:arguments[1]};}
updateConfig(me);plugins._invalidate(me);if(plugins.notify(me,'beforeUpdate')===false){return;}
me.tooltip._data=me.data;var newControllers=me.buildOrUpdateControllers();helpers.each(me.data.datasets,function(dataset,datasetIndex){me.getDatasetMeta(datasetIndex).controller.buildOrUpdateElements();},me);me.updateLayout();if(me.options.animation&&me.options.animation.duration){helpers.each(newControllers,function(controller){controller.reset();});}
me.updateDatasets();me.tooltip.initialize();me.lastActive=[];plugins.notify(me,'afterUpdate');if(me._bufferedRender){me._bufferedRequest={duration:config.duration,easing:config.easing,lazy:config.lazy};}else{me.render(config);}},updateLayout:function(){var me=this;if(plugins.notify(me,'beforeLayout')===false){return;}
layouts.update(this,this.width,this.height);plugins.notify(me,'afterScaleUpdate');plugins.notify(me,'afterLayout');},updateDatasets:function(){var me=this;if(plugins.notify(me,'beforeDatasetsUpdate')===false){return;}
for(var i=0,ilen=me.data.datasets.length;i<ilen;++i){me.updateDataset(i);}
plugins.notify(me,'afterDatasetsUpdate');},updateDataset:function(index){var me=this;var meta=me.getDatasetMeta(index);var args={meta:meta,index:index};if(plugins.notify(me,'beforeDatasetUpdate',[args])===false){return;}
meta.controller.update();plugins.notify(me,'afterDatasetUpdate',[args]);},render:function(config){var me=this;if(!config||typeof config!=='object'){config={duration:config,lazy:arguments[1]};}
var duration=config.duration;var lazy=config.lazy;if(plugins.notify(me,'beforeRender')===false){return;}
var animationOptions=me.options.animation;var onComplete=function(animation){plugins.notify(me,'afterRender');helpers.callback(animationOptions&&animationOptions.onComplete,[animation],me);};if(animationOptions&&((typeof duration!=='undefined'&&duration!==0)||(typeof duration==='undefined'&&animationOptions.duration!==0))){var animation=new Chart.Animation({numSteps:(duration||animationOptions.duration)/16.66,easing:config.easing||animationOptions.easing,render:function(chart,animationObject){var easingFunction=helpers.easing.effects[animationObject.easing];var currentStep=animationObject.currentStep;var stepDecimal=currentStep/animationObject.numSteps;chart.draw(easingFunction(stepDecimal),stepDecimal,currentStep);},onAnimationProgress:animationOptions.onProgress,onAnimationComplete:onComplete});Chart.animationService.addAnimation(me,animation,duration,lazy);}else{me.draw();onComplete(new Chart.Animation({numSteps:0,chart:me}));}
return me;},draw:function(easingValue){var me=this;me.clear();if(helpers.isNullOrUndef(easingValue)){easingValue=1;}
me.transition(easingValue);if(plugins.notify(me,'beforeDraw',[easingValue])===false){return;}
helpers.each(me.boxes,function(box){box.draw(me.chartArea);},me);if(me.scale){me.scale.draw();}
me.drawDatasets(easingValue);me._drawTooltip(easingValue);plugins.notify(me,'afterDraw',[easingValue]);},transition:function(easingValue){var me=this;for(var i=0,ilen=(me.data.datasets||[]).length;i<ilen;++i){if(me.isDatasetVisible(i)){me.getDatasetMeta(i).controller.transition(easingValue);}}
me.tooltip.transition(easingValue);},drawDatasets:function(easingValue){var me=this;if(plugins.notify(me,'beforeDatasetsDraw',[easingValue])===false){return;}
for(var i=(me.data.datasets||[]).length-1;i>=0;--i){if(me.isDatasetVisible(i)){me.drawDataset(i,easingValue);}}
plugins.notify(me,'afterDatasetsDraw',[easingValue]);},drawDataset:function(index,easingValue){var me=this;var meta=me.getDatasetMeta(index);var args={meta:meta,index:index,easingValue:easingValue};if(plugins.notify(me,'beforeDatasetDraw',[args])===false){return;}
meta.controller.draw(easingValue);plugins.notify(me,'afterDatasetDraw',[args]);},_drawTooltip:function(easingValue){var me=this;var tooltip=me.tooltip;var args={tooltip:tooltip,easingValue:easingValue};if(plugins.notify(me,'beforeTooltipDraw',[args])===false){return;}
tooltip.draw();plugins.notify(me,'afterTooltipDraw',[args]);},getElementAtEvent:function(e){return Interaction.modes.single(this,e);},getElementsAtEvent:function(e){return Interaction.modes.label(this,e,{intersect:true});},getElementsAtXAxis:function(e){return Interaction.modes['x-axis'](this,e,{intersect:true});},getElementsAtEventForMode:function(e,mode,options){var method=Interaction.modes[mode];if(typeof method==='function'){return method(this,e,options);}
return[];},getDatasetAtEvent:function(e){return Interaction.modes.dataset(this,e,{intersect:true});},getDatasetMeta:function(datasetIndex){var me=this;var dataset=me.data.datasets[datasetIndex];if(!dataset._meta){dataset._meta={};}
var meta=dataset._meta[me.id];if(!meta){meta=dataset._meta[me.id]={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null};}
return meta;},getVisibleDatasetCount:function(){var count=0;for(var i=0,ilen=this.data.datasets.length;i<ilen;++i){if(this.isDatasetVisible(i)){count++;}}
return count;},isDatasetVisible:function(datasetIndex){var meta=this.getDatasetMeta(datasetIndex);return typeof meta.hidden==='boolean'?!meta.hidden:!this.data.datasets[datasetIndex].hidden;},generateLegend:function(){return this.options.legendCallback(this);},destroyDatasetMeta:function(datasetIndex){var id=this.id;var dataset=this.data.datasets[datasetIndex];var meta=dataset._meta&&dataset._meta[id];if(meta){meta.controller.destroy();delete dataset._meta[id];}},destroy:function(){var me=this;var canvas=me.canvas;var i,ilen;me.stop();for(i=0,ilen=me.data.datasets.length;i<ilen;++i){me.destroyDatasetMeta(i);}
if(canvas){me.unbindEvents();helpers.canvas.clear(me);platform.releaseContext(me.ctx);me.canvas=null;me.ctx=null;}
plugins.notify(me,'destroy');delete Chart.instances[me.id];},toBase64Image:function(){return this.canvas.toDataURL.apply(this.canvas,arguments);},initToolTip:function(){var me=this;me.tooltip=new Chart.Tooltip({_chart:me,_chartInstance:me,_data:me.data,_options:me.options.tooltips},me);},bindEvents:function(){var me=this;var listeners=me._listeners={};var listener=function(){me.eventHandler.apply(me,arguments);};helpers.each(me.options.events,function(type){platform.addEventListener(me,type,listener);listeners[type]=listener;});if(me.options.responsive){listener=function(){me.resize();};platform.addEventListener(me,'resize',listener);listeners.resize=listener;}},unbindEvents:function(){var me=this;var listeners=me._listeners;if(!listeners){return;}
delete me._listeners;helpers.each(listeners,function(listener,type){platform.removeEventListener(me,type,listener);});},updateHoverStyle:function(elements,mode,enabled){var method=enabled?'setHoverStyle':'removeHoverStyle';var element,i,ilen;for(i=0,ilen=elements.length;i<ilen;++i){element=elements[i];if(element){this.getDatasetMeta(element._datasetIndex).controller[method](element);}}},eventHandler:function(e){var me=this;var tooltip=me.tooltip;if(plugins.notify(me,'beforeEvent',[e])===false){return;}
me._bufferedRender=true;me._bufferedRequest=null;var changed=me.handleEvent(e);if(tooltip){changed=tooltip._start?tooltip.handleEvent(e):changed|tooltip.handleEvent(e);}
plugins.notify(me,'afterEvent',[e]);var bufferedRequest=me._bufferedRequest;if(bufferedRequest){me.render(bufferedRequest);}else if(changed&&!me.animating){me.stop();me.render(me.options.hover.animationDuration,true);}
me._bufferedRender=false;me._bufferedRequest=null;return me;},handleEvent:function(e){var me=this;var options=me.options||{};var hoverOptions=options.hover;var changed=false;me.lastActive=me.lastActive||[];if(e.type==='mouseout'){me.active=[];}else{me.active=me.getElementsAtEventForMode(e,hoverOptions.mode,hoverOptions);}
helpers.callback(options.onHover||options.hover.onHover,[e.native,me.active],me);if(e.type==='mouseup'||e.type==='click'){if(options.onClick){options.onClick.call(me,e.native,me.active);}}
if(me.lastActive.length){me.updateHoverStyle(me.lastActive,hoverOptions.mode,false);}
if(me.active.length&&hoverOptions.mode){me.updateHoverStyle(me.active,hoverOptions.mode,true);}
changed=!helpers.arrayEquals(me.active,me.lastActive);me.lastActive=me.active;return changed;}});Chart.Controller=Chart;};},{"25":25,"28":28,"30":30,"31":31,"45":45,"48":48}],24:[function(require,module,exports){'use strict';var helpers=require(45);module.exports=function(Chart){var arrayEvents=['push','pop','shift','splice','unshift'];function listenArrayEvents(array,listener){if(array._chartjs){array._chartjs.listeners.push(listener);return;}
Object.defineProperty(array,'_chartjs',{configurable:true,enumerable:false,value:{listeners:[listener]}});arrayEvents.forEach(function(key){var method='onData'+key.charAt(0).toUpperCase()+key.slice(1);var base=array[key];Object.defineProperty(array,key,{configurable:true,enumerable:false,value:function(){var args=Array.prototype.slice.call(arguments);var res=base.apply(this,args);helpers.each(array._chartjs.listeners,function(object){if(typeof object[method]==='function'){object[method].apply(object,args);}});return res;}});});}
function unlistenArrayEvents(array,listener){var stub=array._chartjs;if(!stub){return;}
var listeners=stub.listeners;var index=listeners.indexOf(listener);if(index!==-1){listeners.splice(index,1);}
if(listeners.length>0){return;}
arrayEvents.forEach(function(key){delete array[key];});delete array._chartjs;}
Chart.DatasetController=function(chart,datasetIndex){this.initialize(chart,datasetIndex);};helpers.extend(Chart.DatasetController.prototype,{datasetElementType:null,dataElementType:null,initialize:function(chart,datasetIndex){var me=this;me.chart=chart;me.index=datasetIndex;me.linkScales();me.addElements();},updateIndex:function(datasetIndex){this.index=datasetIndex;},linkScales:function(){var me=this;var meta=me.getMeta();var dataset=me.getDataset();if(meta.xAxisID===null||!(meta.xAxisID in me.chart.scales)){meta.xAxisID=dataset.xAxisID||me.chart.options.scales.xAxes[0].id;}
if(meta.yAxisID===null||!(meta.yAxisID in me.chart.scales)){meta.yAxisID=dataset.yAxisID||me.chart.options.scales.yAxes[0].id;}},getDataset:function(){return this.chart.data.datasets[this.index];},getMeta:function(){return this.chart.getDatasetMeta(this.index);},getScaleForId:function(scaleID){return this.chart.scales[scaleID];},reset:function(){this.update(true);},destroy:function(){if(this._data){unlistenArrayEvents(this._data,this);}},createMetaDataset:function(){var me=this;var type=me.datasetElementType;return type&&new type({_chart:me.chart,_datasetIndex:me.index});},createMetaData:function(index){var me=this;var type=me.dataElementType;return type&&new type({_chart:me.chart,_datasetIndex:me.index,_index:index});},addElements:function(){var me=this;var meta=me.getMeta();var data=me.getDataset().data||[];var metaData=meta.data;var i,ilen;for(i=0,ilen=data.length;i<ilen;++i){metaData[i]=metaData[i]||me.createMetaData(i);}
meta.dataset=meta.dataset||me.createMetaDataset();},addElementAndReset:function(index){var element=this.createMetaData(index);this.getMeta().data.splice(index,0,element);this.updateElement(element,index,true);},buildOrUpdateElements:function(){var me=this;var dataset=me.getDataset();var data=dataset.data||(dataset.data=[]);if(me._data!==data){if(me._data){unlistenArrayEvents(me._data,me);}
listenArrayEvents(data,me);me._data=data;}
me.resyncElements();},update:helpers.noop,transition:function(easingValue){var meta=this.getMeta();var elements=meta.data||[];var ilen=elements.length;var i=0;for(;i<ilen;++i){elements[i].transition(easingValue);}
if(meta.dataset){meta.dataset.transition(easingValue);}},draw:function(){var meta=this.getMeta();var elements=meta.data||[];var ilen=elements.length;var i=0;if(meta.dataset){meta.dataset.draw();}
for(;i<ilen;++i){elements[i].draw();}},removeHoverStyle:function(element,elementOpts){var dataset=this.chart.data.datasets[element._datasetIndex];var index=element._index;var custom=element.custom||{};var valueOrDefault=helpers.valueAtIndexOrDefault;var model=element._model;model.backgroundColor=custom.backgroundColor?custom.backgroundColor:valueOrDefault(dataset.backgroundColor,index,elementOpts.backgroundColor);model.borderColor=custom.borderColor?custom.borderColor:valueOrDefault(dataset.borderColor,index,elementOpts.borderColor);model.borderWidth=custom.borderWidth?custom.borderWidth:valueOrDefault(dataset.borderWidth,index,elementOpts.borderWidth);},setHoverStyle:function(element){var dataset=this.chart.data.datasets[element._datasetIndex];var index=element._index;var custom=element.custom||{};var valueOrDefault=helpers.valueAtIndexOrDefault;var getHoverColor=helpers.getHoverColor;var model=element._model;model.backgroundColor=custom.hoverBackgroundColor?custom.hoverBackgroundColor:valueOrDefault(dataset.hoverBackgroundColor,index,getHoverColor(model.backgroundColor));model.borderColor=custom.hoverBorderColor?custom.hoverBorderColor:valueOrDefault(dataset.hoverBorderColor,index,getHoverColor(model.borderColor));model.borderWidth=custom.hoverBorderWidth?custom.hoverBorderWidth:valueOrDefault(dataset.hoverBorderWidth,index,model.borderWidth);},resyncElements:function(){var me=this;var meta=me.getMeta();var data=me.getDataset().data;var numMeta=meta.data.length;var numData=data.length;if(numData<numMeta){meta.data.splice(numData,numMeta-numData);}else if(numData>numMeta){me.insertElements(numMeta,numData-numMeta);}},insertElements:function(start,count){for(var i=0;i<count;++i){this.addElementAndReset(start+i);}},onDataPush:function(){this.insertElements(this.getDataset().data.length-1,arguments.length);},onDataPop:function(){this.getMeta().data.pop();},onDataShift:function(){this.getMeta().data.shift();},onDataSplice:function(start,count){this.getMeta().data.splice(start,count);this.insertElements(start,arguments.length-2);},onDataUnshift:function(){this.insertElements(0,arguments.length);}});Chart.DatasetController.extend=helpers.inherits;};},{"45":45}],25:[function(require,module,exports){'use strict';var helpers=require(45);module.exports={_set:function(scope,values){return helpers.merge(this[scope]||(this[scope]={}),values);}};},{"45":45}],26:[function(require,module,exports){'use strict';var color=require(2);var helpers=require(45);function interpolate(start,view,model,ease){var keys=Object.keys(model);var i,ilen,key,actual,origin,target,type,c0,c1;for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];target=model[key];if(!view.hasOwnProperty(key)){view[key]=target;}
actual=view[key];if(actual===target||key[0]==='_'){continue;}
if(!start.hasOwnProperty(key)){start[key]=actual;}
origin=start[key];type=typeof target;if(type===typeof origin){if(type==='string'){c0=color(origin);if(c0.valid){c1=color(target);if(c1.valid){view[key]=c1.mix(c0,ease).rgbString();continue;}}}else if(type==='number'&&isFinite(origin)&&isFinite(target)){view[key]=origin+(target-origin)*ease;continue;}}
view[key]=target;}}
var Element=function(configuration){helpers.extend(this,configuration);this.initialize.apply(this,arguments);};helpers.extend(Element.prototype,{initialize:function(){this.hidden=false;},pivot:function(){var me=this;if(!me._view){me._view=helpers.clone(me._model);}
me._start={};return me;},transition:function(ease){var me=this;var model=me._model;var start=me._start;var view=me._view;if(!model||ease===1){me._view=model;me._start=null;return me;}
if(!view){view=me._view={};}
if(!start){start=me._start={};}
interpolate(start,view,model,ease);return me;},tooltipPosition:function(){return{x:this._model.x,y:this._model.y};},hasValue:function(){return helpers.isNumber(this._model.x)&&helpers.isNumber(this._model.y);}});Element.extend=helpers.inherits;module.exports=Element;},{"2":2,"45":45}],27:[function(require,module,exports){'use strict';var color=require(2);var defaults=require(25);var helpers=require(45);module.exports=function(Chart){helpers.configMerge=function(){return helpers.merge(helpers.clone(arguments[0]),[].slice.call(arguments,1),{merger:function(key,target,source,options){var tval=target[key]||{};var sval=source[key];if(key==='scales'){target[key]=helpers.scaleMerge(tval,sval);}else if(key==='scale'){target[key]=helpers.merge(tval,[Chart.scaleService.getScaleDefaults(sval.type),sval]);}else{helpers._merger(key,target,source,options);}}});};helpers.scaleMerge=function(){return helpers.merge(helpers.clone(arguments[0]),[].slice.call(arguments,1),{merger:function(key,target,source,options){if(key==='xAxes'||key==='yAxes'){var slen=source[key].length;var i,type,scale;if(!target[key]){target[key]=[];}
for(i=0;i<slen;++i){scale=source[key][i];type=helpers.valueOrDefault(scale.type,key==='xAxes'?'category':'linear');if(i>=target[key].length){target[key].push({});}
if(!target[key][i].type||(scale.type&&scale.type!==target[key][i].type)){helpers.merge(target[key][i],[Chart.scaleService.getScaleDefaults(type),scale]);}else{helpers.merge(target[key][i],scale);}}}else{helpers._merger(key,target,source,options);}}});};helpers.where=function(collection,filterCallback){if(helpers.isArray(collection)&&Array.prototype.filter){return collection.filter(filterCallback);}
var filtered=[];helpers.each(collection,function(item){if(filterCallback(item)){filtered.push(item);}});return filtered;};helpers.findIndex=Array.prototype.findIndex?function(array,callback,scope){return array.findIndex(callback,scope);}:function(array,callback,scope){scope=scope===undefined?array:scope;for(var i=0,ilen=array.length;i<ilen;++i){if(callback.call(scope,array[i],i,array)){return i;}}
return-1;};helpers.findNextWhere=function(arrayToSearch,filterCallback,startIndex){if(helpers.isNullOrUndef(startIndex)){startIndex=-1;}
for(var i=startIndex+1;i<arrayToSearch.length;i++){var currentItem=arrayToSearch[i];if(filterCallback(currentItem)){return currentItem;}}};helpers.findPreviousWhere=function(arrayToSearch,filterCallback,startIndex){if(helpers.isNullOrUndef(startIndex)){startIndex=arrayToSearch.length;}
for(var i=startIndex-1;i>=0;i--){var currentItem=arrayToSearch[i];if(filterCallback(currentItem)){return currentItem;}}};helpers.isNumber=function(n){return!isNaN(parseFloat(n))&&isFinite(n);};helpers.almostEquals=function(x,y,epsilon){return Math.abs(x-y)<epsilon;};helpers.almostWhole=function(x,epsilon){var rounded=Math.round(x);return(((rounded-epsilon)<x)&&((rounded+epsilon)>x));};helpers.max=function(array){return array.reduce(function(max,value){if(!isNaN(value)){return Math.max(max,value);}
return max;},Number.NEGATIVE_INFINITY);};helpers.min=function(array){return array.reduce(function(min,value){if(!isNaN(value)){return Math.min(min,value);}
return min;},Number.POSITIVE_INFINITY);};helpers.sign=Math.sign?function(x){return Math.sign(x);}:function(x){x=+x;if(x===0||isNaN(x)){return x;}
return x>0?1:-1;};helpers.log10=Math.log10?function(x){return Math.log10(x);}:function(x){var exponent=Math.log(x)*Math.LOG10E;var powerOf10=Math.round(exponent);var isPowerOf10=x===Math.pow(10,powerOf10);return isPowerOf10?powerOf10:exponent;};helpers.toRadians=function(degrees){return degrees*(Math.PI/180);};helpers.toDegrees=function(radians){return radians*(180/Math.PI);};helpers.getAngleFromPoint=function(centrePoint,anglePoint){var distanceFromXCenter=anglePoint.x-centrePoint.x;var distanceFromYCenter=anglePoint.y-centrePoint.y;var radialDistanceFromCenter=Math.sqrt(distanceFromXCenter*distanceFromXCenter+distanceFromYCenter*distanceFromYCenter);var angle=Math.atan2(distanceFromYCenter,distanceFromXCenter);if(angle<(-0.5*Math.PI)){angle+=2.0*Math.PI;}
return{angle:angle,distance:radialDistanceFromCenter};};helpers.distanceBetweenPoints=function(pt1,pt2){return Math.sqrt(Math.pow(pt2.x-pt1.x,2)+Math.pow(pt2.y-pt1.y,2));};helpers.aliasPixel=function(pixelWidth){return(pixelWidth%2===0)?0:0.5;};helpers.splineCurve=function(firstPoint,middlePoint,afterPoint,t){var previous=firstPoint.skip?middlePoint:firstPoint;var current=middlePoint;var next=afterPoint.skip?middlePoint:afterPoint;var d01=Math.sqrt(Math.pow(current.x-previous.x,2)+Math.pow(current.y-previous.y,2));var d12=Math.sqrt(Math.pow(next.x-current.x,2)+Math.pow(next.y-current.y,2));var s01=d01/(d01+d12);var s12=d12/(d01+d12);s01=isNaN(s01)?0:s01;s12=isNaN(s12)?0:s12;var fa=t*s01;var fb=t*s12;return{previous:{x:current.x-fa*(next.x-previous.x),y:current.y-fa*(next.y-previous.y)},next:{x:current.x+fb*(next.x-previous.x),y:current.y+fb*(next.y-previous.y)}};};helpers.EPSILON=Number.EPSILON||1e-14;helpers.splineCurveMonotone=function(points){var pointsWithTangents=(points||[]).map(function(point){return{model:point._model,deltaK:0,mK:0};});var pointsLen=pointsWithTangents.length;var i,pointBefore,pointCurrent,pointAfter;for(i=0;i<pointsLen;++i){pointCurrent=pointsWithTangents[i];if(pointCurrent.model.skip){continue;}
pointBefore=i>0?pointsWithTangents[i-1]:null;pointAfter=i<pointsLen-1?pointsWithTangents[i+1]:null;if(pointAfter&&!pointAfter.model.skip){var slopeDeltaX=(pointAfter.model.x-pointCurrent.model.x);pointCurrent.deltaK=slopeDeltaX!==0?(pointAfter.model.y-pointCurrent.model.y)/slopeDeltaX:0;}
if(!pointBefore||pointBefore.model.skip){pointCurrent.mK=pointCurrent.deltaK;}else if(!pointAfter||pointAfter.model.skip){pointCurrent.mK=pointBefore.deltaK;}else if(this.sign(pointBefore.deltaK)!==this.sign(pointCurrent.deltaK)){pointCurrent.mK=0;}else{pointCurrent.mK=(pointBefore.deltaK+pointCurrent.deltaK)/2;}}
var alphaK,betaK,tauK,squaredMagnitude;for(i=0;i<pointsLen-1;++i){pointCurrent=pointsWithTangents[i];pointAfter=pointsWithTangents[i+1];if(pointCurrent.model.skip||pointAfter.model.skip){continue;}
if(helpers.almostEquals(pointCurrent.deltaK,0,this.EPSILON)){pointCurrent.mK=pointAfter.mK=0;continue;}
alphaK=pointCurrent.mK/pointCurrent.deltaK;betaK=pointAfter.mK/pointCurrent.deltaK;squaredMagnitude=Math.pow(alphaK,2)+Math.pow(betaK,2);if(squaredMagnitude<=9){continue;}
tauK=3/Math.sqrt(squaredMagnitude);pointCurrent.mK=alphaK*tauK*pointCurrent.deltaK;pointAfter.mK=betaK*tauK*pointCurrent.deltaK;}
var deltaX;for(i=0;i<pointsLen;++i){pointCurrent=pointsWithTangents[i];if(pointCurrent.model.skip){continue;}
pointBefore=i>0?pointsWithTangents[i-1]:null;pointAfter=i<pointsLen-1?pointsWithTangents[i+1]:null;if(pointBefore&&!pointBefore.model.skip){deltaX=(pointCurrent.model.x-pointBefore.model.x)/3;pointCurrent.model.controlPointPreviousX=pointCurrent.model.x-deltaX;pointCurrent.model.controlPointPreviousY=pointCurrent.model.y-deltaX*pointCurrent.mK;}
if(pointAfter&&!pointAfter.model.skip){deltaX=(pointAfter.model.x-pointCurrent.model.x)/3;pointCurrent.model.controlPointNextX=pointCurrent.model.x+deltaX;pointCurrent.model.controlPointNextY=pointCurrent.model.y+deltaX*pointCurrent.mK;}}};helpers.nextItem=function(collection,index,loop){if(loop){return index>=collection.length-1?collection[0]:collection[index+1];}
return index>=collection.length-1?collection[collection.length-1]:collection[index+1];};helpers.previousItem=function(collection,index,loop){if(loop){return index<=0?collection[collection.length-1]:collection[index-1];}
return index<=0?collection[0]:collection[index-1];};helpers.niceNum=function(range,round){var exponent=Math.floor(helpers.log10(range));var fraction=range/Math.pow(10,exponent);var niceFraction;if(round){if(fraction<1.5){niceFraction=1;}else if(fraction<3){niceFraction=2;}else if(fraction<7){niceFraction=5;}else{niceFraction=10;}}else if(fraction<=1.0){niceFraction=1;}else if(fraction<=2){niceFraction=2;}else if(fraction<=5){niceFraction=5;}else{niceFraction=10;}
return niceFraction*Math.pow(10,exponent);};helpers.requestAnimFrame=(function(){if(typeof window==='undefined'){return function(callback){callback();};}
return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){return window.setTimeout(callback,1000/60);};}());helpers.getRelativePosition=function(evt,chart){var mouseX,mouseY;var e=evt.originalEvent||evt;var canvas=evt.currentTarget||evt.srcElement;var boundingRect=canvas.getBoundingClientRect();var touches=e.touches;if(touches&&touches.length>0){mouseX=touches[0].clientX;mouseY=touches[0].clientY;}else{mouseX=e.clientX;mouseY=e.clientY;}
var paddingLeft=parseFloat(helpers.getStyle(canvas,'padding-left'));var paddingTop=parseFloat(helpers.getStyle(canvas,'padding-top'));var paddingRight=parseFloat(helpers.getStyle(canvas,'padding-right'));var paddingBottom=parseFloat(helpers.getStyle(canvas,'padding-bottom'));var width=boundingRect.right-boundingRect.left-paddingLeft-paddingRight;var height=boundingRect.bottom-boundingRect.top-paddingTop-paddingBottom;mouseX=Math.round((mouseX-boundingRect.left-paddingLeft)/(width)*canvas.width/chart.currentDevicePixelRatio);mouseY=Math.round((mouseY-boundingRect.top-paddingTop)/(height)*canvas.height/chart.currentDevicePixelRatio);return{x:mouseX,y:mouseY};};function parseMaxStyle(styleValue,node,parentProperty){var valueInPixels;if(typeof styleValue==='string'){valueInPixels=parseInt(styleValue,10);if(styleValue.indexOf('%')!==-1){valueInPixels=valueInPixels/100*node.parentNode[parentProperty];}}else{valueInPixels=styleValue;}
return valueInPixels;}
function isConstrainedValue(value){return value!==undefined&&value!==null&&value!=='none';}
function getConstraintDimension(domNode,maxStyle,percentageProperty){var view=document.defaultView;var parentNode=domNode.parentNode;var constrainedNode=view.getComputedStyle(domNode)[maxStyle];var constrainedContainer=view.getComputedStyle(parentNode)[maxStyle];var hasCNode=isConstrainedValue(constrainedNode);var hasCContainer=isConstrainedValue(constrainedContainer);var infinity=Number.POSITIVE_INFINITY;if(hasCNode||hasCContainer){return Math.min(hasCNode?parseMaxStyle(constrainedNode,domNode,percentageProperty):infinity,hasCContainer?parseMaxStyle(constrainedContainer,parentNode,percentageProperty):infinity);}
return'none';}
helpers.getConstraintWidth=function(domNode){return getConstraintDimension(domNode,'max-width','clientWidth');};helpers.getConstraintHeight=function(domNode){return getConstraintDimension(domNode,'max-height','clientHeight');};helpers.getMaximumWidth=function(domNode){var container=domNode.parentNode;if(!container){return domNode.clientWidth;}
var paddingLeft=parseInt(helpers.getStyle(container,'padding-left'),10);var paddingRight=parseInt(helpers.getStyle(container,'padding-right'),10);var w=container.clientWidth-paddingLeft-paddingRight;var cw=helpers.getConstraintWidth(domNode);return isNaN(cw)?w:Math.min(w,cw);};helpers.getMaximumHeight=function(domNode){var container=domNode.parentNode;if(!container){return domNode.clientHeight;}
var paddingTop=parseInt(helpers.getStyle(container,'padding-top'),10);var paddingBottom=parseInt(helpers.getStyle(container,'padding-bottom'),10);var h=container.clientHeight-paddingTop-paddingBottom;var ch=helpers.getConstraintHeight(domNode);return isNaN(ch)?h:Math.min(h,ch);};helpers.getStyle=function(el,property){return el.currentStyle?el.currentStyle[property]:document.defaultView.getComputedStyle(el,null).getPropertyValue(property);};helpers.retinaScale=function(chart,forceRatio){var pixelRatio=chart.currentDevicePixelRatio=forceRatio||window.devicePixelRatio||1;if(pixelRatio===1){return;}
var canvas=chart.canvas;var height=chart.height;var width=chart.width;canvas.height=height*pixelRatio;canvas.width=width*pixelRatio;chart.ctx.scale(pixelRatio,pixelRatio);if(!canvas.style.height&&!canvas.style.width){canvas.style.height=height+'px';canvas.style.width=width+'px';}};helpers.fontString=function(pixelSize,fontStyle,fontFamily){return fontStyle+' '+pixelSize+'px '+fontFamily;};helpers.longestText=function(ctx,font,arrayOfThings,cache){cache=cache||{};var data=cache.data=cache.data||{};var gc=cache.garbageCollect=cache.garbageCollect||[];if(cache.font!==font){data=cache.data={};gc=cache.garbageCollect=[];cache.font=font;}
ctx.font=font;var longest=0;helpers.each(arrayOfThings,function(thing){if(thing!==undefined&&thing!==null&&helpers.isArray(thing)!==true){longest=helpers.measureText(ctx,data,gc,longest,thing);}else if(helpers.isArray(thing)){helpers.each(thing,function(nestedThing){if(nestedThing!==undefined&&nestedThing!==null&&!helpers.isArray(nestedThing)){longest=helpers.measureText(ctx,data,gc,longest,nestedThing);}});}});var gcLen=gc.length/2;if(gcLen>arrayOfThings.length){for(var i=0;i<gcLen;i++){delete data[gc[i]];}
gc.splice(0,gcLen);}
return longest;};helpers.measureText=function(ctx,data,gc,longest,string){var textWidth=data[string];if(!textWidth){textWidth=data[string]=ctx.measureText(string).width;gc.push(string);}
if(textWidth>longest){longest=textWidth;}
return longest;};helpers.numberOfLabelLines=function(arrayOfThings){var numberOfLines=1;helpers.each(arrayOfThings,function(thing){if(helpers.isArray(thing)){if(thing.length>numberOfLines){numberOfLines=thing.length;}}});return numberOfLines;};helpers.color=!color?function(value){console.error('Color.js not found!');return value;}:function(value){if(value instanceof CanvasGradient){value=defaults.global.defaultColor;}
return color(value);};helpers.getHoverColor=function(colorValue){return(colorValue instanceof CanvasPattern)?colorValue:helpers.color(colorValue).saturate(0.5).darken(0.1).rgbString();};};},{"2":2,"25":25,"45":45}],28:[function(require,module,exports){'use strict';var helpers=require(45);function getRelativePosition(e,chart){if(e.native){return{x:e.x,y:e.y};}
return helpers.getRelativePosition(e,chart);}
function parseVisibleItems(chart,handler){var datasets=chart.data.datasets;var meta,i,j,ilen,jlen;for(i=0,ilen=datasets.length;i<ilen;++i){if(!chart.isDatasetVisible(i)){continue;}
meta=chart.getDatasetMeta(i);for(j=0,jlen=meta.data.length;j<jlen;++j){var element=meta.data[j];if(!element._view.skip){handler(element);}}}}
function getIntersectItems(chart,position){var elements=[];parseVisibleItems(chart,function(element){if(element.inRange(position.x,position.y)){elements.push(element);}});return elements;}
function getNearestItems(chart,position,intersect,distanceMetric){var minDistance=Number.POSITIVE_INFINITY;var nearestItems=[];parseVisibleItems(chart,function(element){if(intersect&&!element.inRange(position.x,position.y)){return;}
var center=element.getCenterPoint();var distance=distanceMetric(position,center);if(distance<minDistance){nearestItems=[element];minDistance=distance;}else if(distance===minDistance){nearestItems.push(element);}});return nearestItems;}
function getDistanceMetricForAxis(axis){var useX=axis.indexOf('x')!==-1;var useY=axis.indexOf('y')!==-1;return function(pt1,pt2){var deltaX=useX?Math.abs(pt1.x-pt2.x):0;var deltaY=useY?Math.abs(pt1.y-pt2.y):0;return Math.sqrt(Math.pow(deltaX,2)+Math.pow(deltaY,2));};}
function indexMode(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'x';var distanceMetric=getDistanceMetricForAxis(options.axis);var items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,false,distanceMetric);var elements=[];if(!items.length){return[];}
chart.data.datasets.forEach(function(dataset,datasetIndex){if(chart.isDatasetVisible(datasetIndex)){var meta=chart.getDatasetMeta(datasetIndex);var element=meta.data[items[0]._index];if(element&&!element._view.skip){elements.push(element);}}});return elements;}
module.exports={modes:{single:function(chart,e){var position=getRelativePosition(e,chart);var elements=[];parseVisibleItems(chart,function(element){if(element.inRange(position.x,position.y)){elements.push(element);return elements;}});return elements.slice(0,1);},label:indexMode,index:indexMode,dataset:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'xy';var distanceMetric=getDistanceMetricForAxis(options.axis);var items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,false,distanceMetric);if(items.length>0){items=chart.getDatasetMeta(items[0]._datasetIndex).data;}
return items;},'x-axis':function(chart,e){return indexMode(chart,e,{intersect:false});},point:function(chart,e){var position=getRelativePosition(e,chart);return getIntersectItems(chart,position);},nearest:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'xy';var distanceMetric=getDistanceMetricForAxis(options.axis);var nearestItems=getNearestItems(chart,position,options.intersect,distanceMetric);if(nearestItems.length>1){nearestItems.sort(function(a,b){var sizeA=a.getArea();var sizeB=b.getArea();var ret=sizeA-sizeB;if(ret===0){ret=a._datasetIndex-b._datasetIndex;}
return ret;});}
return nearestItems.slice(0,1);},x:function(chart,e,options){var position=getRelativePosition(e,chart);var items=[];var intersectsItem=false;parseVisibleItems(chart,function(element){if(element.inXRange(position.x)){items.push(element);}
if(element.inRange(position.x,position.y)){intersectsItem=true;}});if(options.intersect&&!intersectsItem){items=[];}
return items;},y:function(chart,e,options){var position=getRelativePosition(e,chart);var items=[];var intersectsItem=false;parseVisibleItems(chart,function(element){if(element.inYRange(position.y)){items.push(element);}
if(element.inRange(position.x,position.y)){intersectsItem=true;}});if(options.intersect&&!intersectsItem){items=[];}
return items;}}};},{"45":45}],29:[function(require,module,exports){'use strict';var defaults=require(25);defaults._set('global',{responsive:true,responsiveAnimationDuration:0,maintainAspectRatio:true,events:['mousemove','mouseout','click','touchstart','touchmove'],hover:{onHover:null,mode:'nearest',intersect:true,animationDuration:400},onClick:null,defaultColor:'rgba(0,0,0,0.1)',defaultFontColor:'#666',defaultFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",defaultFontSize:12,defaultFontStyle:'normal',showLines:true,elements:{},layout:{padding:{top:0,right:0,bottom:0,left:0}}});module.exports=function(){var Chart=function(item,config){this.construct(item,config);return this;};Chart.Chart=Chart;return Chart;};},{"25":25}],30:[function(require,module,exports){'use strict';var helpers=require(45);function filterByPosition(array,position){return helpers.where(array,function(v){return v.position===position;});}
function sortByWeight(array,reverse){array.forEach(function(v,i){v._tmpIndex_=i;return v;});array.sort(function(a,b){var v0=reverse?b:a;var v1=reverse?a:b;return v0.weight===v1.weight?v0._tmpIndex_-v1._tmpIndex_:v0.weight-v1.weight;});array.forEach(function(v){delete v._tmpIndex_;});}
module.exports={defaults:{},addBox:function(chart,item){if(!chart.boxes){chart.boxes=[];}
item.fullWidth=item.fullWidth||false;item.position=item.position||'top';item.weight=item.weight||0;chart.boxes.push(item);},removeBox:function(chart,layoutItem){var index=chart.boxes?chart.boxes.indexOf(layoutItem):-1;if(index!==-1){chart.boxes.splice(index,1);}},configure:function(chart,item,options){var props=['fullWidth','position','weight'];var ilen=props.length;var i=0;var prop;for(;i<ilen;++i){prop=props[i];if(options.hasOwnProperty(prop)){item[prop]=options[prop];}}},update:function(chart,width,height){if(!chart){return;}
var layoutOptions=chart.options.layout||{};var padding=helpers.options.toPadding(layoutOptions.padding);var leftPadding=padding.left;var rightPadding=padding.right;var topPadding=padding.top;var bottomPadding=padding.bottom;var leftBoxes=filterByPosition(chart.boxes,'left');var rightBoxes=filterByPosition(chart.boxes,'right');var topBoxes=filterByPosition(chart.boxes,'top');var bottomBoxes=filterByPosition(chart.boxes,'bottom');var chartAreaBoxes=filterByPosition(chart.boxes,'chartArea');sortByWeight(leftBoxes,true);sortByWeight(rightBoxes,false);sortByWeight(topBoxes,true);sortByWeight(bottomBoxes,false);var chartWidth=width-leftPadding-rightPadding;var chartHeight=height-topPadding-bottomPadding;var chartAreaWidth=chartWidth/2;var chartAreaHeight=chartHeight/2;var verticalBoxWidth=(width-chartAreaWidth)/(leftBoxes.length+rightBoxes.length);var horizontalBoxHeight=(height-chartAreaHeight)/(topBoxes.length+bottomBoxes.length);var maxChartAreaWidth=chartWidth;var maxChartAreaHeight=chartHeight;var minBoxSizes=[];function getMinimumBoxSize(box){var minSize;var isHorizontal=box.isHorizontal();if(isHorizontal){minSize=box.update(box.fullWidth?chartWidth:maxChartAreaWidth,horizontalBoxHeight);maxChartAreaHeight-=minSize.height;}else{minSize=box.update(verticalBoxWidth,maxChartAreaHeight);maxChartAreaWidth-=minSize.width;}
minBoxSizes.push({horizontal:isHorizontal,minSize:minSize,box:box,});}
helpers.each(leftBoxes.concat(rightBoxes,topBoxes,bottomBoxes),getMinimumBoxSize);var maxHorizontalLeftPadding=0;var maxHorizontalRightPadding=0;var maxVerticalTopPadding=0;var maxVerticalBottomPadding=0;helpers.each(topBoxes.concat(bottomBoxes),function(horizontalBox){if(horizontalBox.getPadding){var boxPadding=horizontalBox.getPadding();maxHorizontalLeftPadding=Math.max(maxHorizontalLeftPadding,boxPadding.left);maxHorizontalRightPadding=Math.max(maxHorizontalRightPadding,boxPadding.right);}});helpers.each(leftBoxes.concat(rightBoxes),function(verticalBox){if(verticalBox.getPadding){var boxPadding=verticalBox.getPadding();maxVerticalTopPadding=Math.max(maxVerticalTopPadding,boxPadding.top);maxVerticalBottomPadding=Math.max(maxVerticalBottomPadding,boxPadding.bottom);}});var totalLeftBoxesWidth=leftPadding;var totalRightBoxesWidth=rightPadding;var totalTopBoxesHeight=topPadding;var totalBottomBoxesHeight=bottomPadding;function fitBox(box){var minBoxSize=helpers.findNextWhere(minBoxSizes,function(minBox){return minBox.box===box;});if(minBoxSize){if(box.isHorizontal()){var scaleMargin={left:Math.max(totalLeftBoxesWidth,maxHorizontalLeftPadding),right:Math.max(totalRightBoxesWidth,maxHorizontalRightPadding),top:0,bottom:0};box.update(box.fullWidth?chartWidth:maxChartAreaWidth,chartHeight/2,scaleMargin);}else{box.update(minBoxSize.minSize.width,maxChartAreaHeight);}}}
helpers.each(leftBoxes.concat(rightBoxes),fitBox);helpers.each(leftBoxes,function(box){totalLeftBoxesWidth+=box.width;});helpers.each(rightBoxes,function(box){totalRightBoxesWidth+=box.width;});helpers.each(topBoxes.concat(bottomBoxes),fitBox);helpers.each(topBoxes,function(box){totalTopBoxesHeight+=box.height;});helpers.each(bottomBoxes,function(box){totalBottomBoxesHeight+=box.height;});function finalFitVerticalBox(box){var minBoxSize=helpers.findNextWhere(minBoxSizes,function(minSize){return minSize.box===box;});var scaleMargin={left:0,right:0,top:totalTopBoxesHeight,bottom:totalBottomBoxesHeight};if(minBoxSize){box.update(minBoxSize.minSize.width,maxChartAreaHeight,scaleMargin);}}
helpers.each(leftBoxes.concat(rightBoxes),finalFitVerticalBox);totalLeftBoxesWidth=leftPadding;totalRightBoxesWidth=rightPadding;totalTopBoxesHeight=topPadding;totalBottomBoxesHeight=bottomPadding;helpers.each(leftBoxes,function(box){totalLeftBoxesWidth+=box.width;});helpers.each(rightBoxes,function(box){totalRightBoxesWidth+=box.width;});helpers.each(topBoxes,function(box){totalTopBoxesHeight+=box.height;});helpers.each(bottomBoxes,function(box){totalBottomBoxesHeight+=box.height;});var leftPaddingAddition=Math.max(maxHorizontalLeftPadding-totalLeftBoxesWidth,0);totalLeftBoxesWidth+=leftPaddingAddition;totalRightBoxesWidth+=Math.max(maxHorizontalRightPadding-totalRightBoxesWidth,0);var topPaddingAddition=Math.max(maxVerticalTopPadding-totalTopBoxesHeight,0);totalTopBoxesHeight+=topPaddingAddition;totalBottomBoxesHeight+=Math.max(maxVerticalBottomPadding-totalBottomBoxesHeight,0);var newMaxChartAreaHeight=height-totalTopBoxesHeight-totalBottomBoxesHeight;var newMaxChartAreaWidth=width-totalLeftBoxesWidth-totalRightBoxesWidth;if(newMaxChartAreaWidth!==maxChartAreaWidth||newMaxChartAreaHeight!==maxChartAreaHeight){helpers.each(leftBoxes,function(box){box.height=newMaxChartAreaHeight;});helpers.each(rightBoxes,function(box){box.height=newMaxChartAreaHeight;});helpers.each(topBoxes,function(box){if(!box.fullWidth){box.width=newMaxChartAreaWidth;}});helpers.each(bottomBoxes,function(box){if(!box.fullWidth){box.width=newMaxChartAreaWidth;}});maxChartAreaHeight=newMaxChartAreaHeight;maxChartAreaWidth=newMaxChartAreaWidth;}
var left=leftPadding+leftPaddingAddition;var top=topPadding+topPaddingAddition;function placeBox(box){if(box.isHorizontal()){box.left=box.fullWidth?leftPadding:totalLeftBoxesWidth;box.right=box.fullWidth?width-rightPadding:totalLeftBoxesWidth+maxChartAreaWidth;box.top=top;box.bottom=top+box.height;top=box.bottom;}else{box.left=left;box.right=left+box.width;box.top=totalTopBoxesHeight;box.bottom=totalTopBoxesHeight+maxChartAreaHeight;left=box.right;}}
helpers.each(leftBoxes.concat(topBoxes),placeBox);left+=maxChartAreaWidth;top+=maxChartAreaHeight;helpers.each(rightBoxes,placeBox);helpers.each(bottomBoxes,placeBox);chart.chartArea={left:totalLeftBoxesWidth,top:totalTopBoxesHeight,right:totalLeftBoxesWidth+maxChartAreaWidth,bottom:totalTopBoxesHeight+maxChartAreaHeight};helpers.each(chartAreaBoxes,function(box){box.left=chart.chartArea.left;box.top=chart.chartArea.top;box.right=chart.chartArea.right;box.bottom=chart.chartArea.bottom;box.update(maxChartAreaWidth,maxChartAreaHeight);});}};},{"45":45}],31:[function(require,module,exports){'use strict';var defaults=require(25);var helpers=require(45);defaults._set('global',{plugins:{}});module.exports={_plugins:[],_cacheId:0,register:function(plugins){var p=this._plugins;([]).concat(plugins).forEach(function(plugin){if(p.indexOf(plugin)===-1){p.push(plugin);}});this._cacheId++;},unregister:function(plugins){var p=this._plugins;([]).concat(plugins).forEach(function(plugin){var idx=p.indexOf(plugin);if(idx!==-1){p.splice(idx,1);}});this._cacheId++;},clear:function(){this._plugins=[];this._cacheId++;},count:function(){return this._plugins.length;},getAll:function(){return this._plugins;},notify:function(chart,hook,args){var descriptors=this.descriptors(chart);var ilen=descriptors.length;var i,descriptor,plugin,params,method;for(i=0;i<ilen;++i){descriptor=descriptors[i];plugin=descriptor.plugin;method=plugin[hook];if(typeof method==='function'){params=[chart].concat(args||[]);params.push(descriptor.options);if(method.apply(plugin,params)===false){return false;}}}
return true;},descriptors:function(chart){var cache=chart.$plugins||(chart.$plugins={});if(cache.id===this._cacheId){return cache.descriptors;}
var plugins=[];var descriptors=[];var config=(chart&&chart.config)||{};var options=(config.options&&config.options.plugins)||{};this._plugins.concat(config.plugins||[]).forEach(function(plugin){var idx=plugins.indexOf(plugin);if(idx!==-1){return;}
var id=plugin.id;var opts=options[id];if(opts===false){return;}
if(opts===true){opts=helpers.clone(defaults.global.plugins[id]);}
plugins.push(plugin);descriptors.push({plugin:plugin,options:opts||{}});});cache.descriptors=descriptors;cache.id=this._cacheId;return descriptors;},_invalidate:function(chart){delete chart.$plugins;}};},{"25":25,"45":45}],32:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);var helpers=require(45);var Ticks=require(34);defaults._set('scale',{display:true,position:'left',offset:false,gridLines:{display:true,color:'rgba(0, 0, 0, 0.1)',lineWidth:1,drawBorder:true,drawOnChartArea:true,drawTicks:true,tickMarkLength:10,zeroLineWidth:1,zeroLineColor:'rgba(0,0,0,0.25)',zeroLineBorderDash:[],zeroLineBorderDashOffset:0.0,offsetGridLines:false,borderDash:[],borderDashOffset:0.0},scaleLabel:{display:false,labelString:'',lineHeight:1.2,padding:{top:4,bottom:4}},ticks:{beginAtZero:false,minRotation:0,maxRotation:50,mirror:false,padding:0,reverse:false,display:true,autoSkip:true,autoSkipPadding:0,labelOffset:0,callback:Ticks.formatters.values,minor:{},major:{}}});function labelsFromTicks(ticks){var labels=[];var i,ilen;for(i=0,ilen=ticks.length;i<ilen;++i){labels.push(ticks[i].label);}
return labels;}
function getLineValue(scale,index,offsetGridLines){var lineValue=scale.getPixelForTick(index);if(offsetGridLines){if(index===0){lineValue-=(scale.getPixelForTick(1)-lineValue)/2;}else{lineValue-=(lineValue-scale.getPixelForTick(index-1))/2;}}
return lineValue;}
module.exports=function(Chart){function computeTextSize(context,tick,font){return helpers.isArray(tick)?helpers.longestText(context,font,tick):context.measureText(tick).width;}
function parseFontOptions(options){var valueOrDefault=helpers.valueOrDefault;var globalDefaults=defaults.global;var size=valueOrDefault(options.fontSize,globalDefaults.defaultFontSize);var style=valueOrDefault(options.fontStyle,globalDefaults.defaultFontStyle);var family=valueOrDefault(options.fontFamily,globalDefaults.defaultFontFamily);return{size:size,style:style,family:family,font:helpers.fontString(size,style,family)};}
function parseLineHeight(options){return helpers.options.toLineHeight(helpers.valueOrDefault(options.lineHeight,1.2),helpers.valueOrDefault(options.fontSize,defaults.global.defaultFontSize));}
Chart.Scale=Element.extend({getPadding:function(){var me=this;return{left:me.paddingLeft||0,top:me.paddingTop||0,right:me.paddingRight||0,bottom:me.paddingBottom||0};},getTicks:function(){return this._ticks;},mergeTicksOptions:function(){var ticks=this.options.ticks;if(ticks.minor===false){ticks.minor={display:false};}
if(ticks.major===false){ticks.major={display:false};}
for(var key in ticks){if(key!=='major'&&key!=='minor'){if(typeof ticks.minor[key]==='undefined'){ticks.minor[key]=ticks[key];}
if(typeof ticks.major[key]==='undefined'){ticks.major[key]=ticks[key];}}}},beforeUpdate:function(){helpers.callback(this.options.beforeUpdate,[this]);},update:function(maxWidth,maxHeight,margins){var me=this;var i,ilen,labels,label,ticks,tick;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=helpers.extend({left:0,right:0,top:0,bottom:0},margins);me.longestTextCache=me.longestTextCache||{};me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeDataLimits();me.determineDataLimits();me.afterDataLimits();me.beforeBuildTicks();ticks=me.buildTicks()||[];me.afterBuildTicks();me.beforeTickToLabelConversion();labels=me.convertTicksToLabels(ticks)||me.ticks;me.afterTickToLabelConversion();me.ticks=labels;for(i=0,ilen=labels.length;i<ilen;++i){label=labels[i];tick=ticks[i];if(!tick){ticks.push(tick={label:label,major:false});}else{tick.label=label;}}
me._ticks=ticks;me.beforeCalculateTickRotation();me.calculateTickRotation();me.afterCalculateTickRotation();me.beforeFit();me.fit();me.afterFit();me.afterUpdate();return me.minSize;},afterUpdate:function(){helpers.callback(this.options.afterUpdate,[this]);},beforeSetDimensions:function(){helpers.callback(this.options.beforeSetDimensions,[this]);},setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width;}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height;}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0;},afterSetDimensions:function(){helpers.callback(this.options.afterSetDimensions,[this]);},beforeDataLimits:function(){helpers.callback(this.options.beforeDataLimits,[this]);},determineDataLimits:helpers.noop,afterDataLimits:function(){helpers.callback(this.options.afterDataLimits,[this]);},beforeBuildTicks:function(){helpers.callback(this.options.beforeBuildTicks,[this]);},buildTicks:helpers.noop,afterBuildTicks:function(){helpers.callback(this.options.afterBuildTicks,[this]);},beforeTickToLabelConversion:function(){helpers.callback(this.options.beforeTickToLabelConversion,[this]);},convertTicksToLabels:function(){var me=this;var tickOpts=me.options.ticks;me.ticks=me.ticks.map(tickOpts.userCallback||tickOpts.callback,this);},afterTickToLabelConversion:function(){helpers.callback(this.options.afterTickToLabelConversion,[this]);},beforeCalculateTickRotation:function(){helpers.callback(this.options.beforeCalculateTickRotation,[this]);},calculateTickRotation:function(){var me=this;var context=me.ctx;var tickOpts=me.options.ticks;var labels=labelsFromTicks(me._ticks);var tickFont=parseFontOptions(tickOpts);context.font=tickFont.font;var labelRotation=tickOpts.minRotation||0;if(labels.length&&me.options.display&&me.isHorizontal()){var originalLabelWidth=helpers.longestText(context,tickFont.font,labels,me.longestTextCache);var labelWidth=originalLabelWidth;var cosRotation,sinRotation;var tickWidth=me.getPixelForTick(1)-me.getPixelForTick(0)-6;while(labelWidth>tickWidth&&labelRotation<tickOpts.maxRotation){var angleRadians=helpers.toRadians(labelRotation);cosRotation=Math.cos(angleRadians);sinRotation=Math.sin(angleRadians);if(sinRotation*originalLabelWidth>me.maxHeight){labelRotation--;break;}
labelRotation++;labelWidth=cosRotation*originalLabelWidth;}}
me.labelRotation=labelRotation;},afterCalculateTickRotation:function(){helpers.callback(this.options.afterCalculateTickRotation,[this]);},beforeFit:function(){helpers.callback(this.options.beforeFit,[this]);},fit:function(){var me=this;var minSize=me.minSize={width:0,height:0};var labels=labelsFromTicks(me._ticks);var opts=me.options;var tickOpts=opts.ticks;var scaleLabelOpts=opts.scaleLabel;var gridLineOpts=opts.gridLines;var display=opts.display;var isHorizontal=me.isHorizontal();var tickFont=parseFontOptions(tickOpts);var tickMarkLength=opts.gridLines.tickMarkLength;if(isHorizontal){minSize.width=me.isFullWidth()?me.maxWidth-me.margins.left-me.margins.right:me.maxWidth;}else{minSize.width=display&&gridLineOpts.drawTicks?tickMarkLength:0;}
if(isHorizontal){minSize.height=display&&gridLineOpts.drawTicks?tickMarkLength:0;}else{minSize.height=me.maxHeight;}
if(scaleLabelOpts.display&&display){var scaleLabelLineHeight=parseLineHeight(scaleLabelOpts);var scaleLabelPadding=helpers.options.toPadding(scaleLabelOpts.padding);var deltaHeight=scaleLabelLineHeight+scaleLabelPadding.height;if(isHorizontal){minSize.height+=deltaHeight;}else{minSize.width+=deltaHeight;}}
if(tickOpts.display&&display){var largestTextWidth=helpers.longestText(me.ctx,tickFont.font,labels,me.longestTextCache);var tallestLabelHeightInLines=helpers.numberOfLabelLines(labels);var lineSpace=tickFont.size*0.5;var tickPadding=me.options.ticks.padding;if(isHorizontal){me.longestLabelWidth=largestTextWidth;var angleRadians=helpers.toRadians(me.labelRotation);var cosRotation=Math.cos(angleRadians);var sinRotation=Math.sin(angleRadians);var labelHeight=(sinRotation*largestTextWidth)
+(tickFont.size*tallestLabelHeightInLines)
+(lineSpace*(tallestLabelHeightInLines-1))
+lineSpace;minSize.height=Math.min(me.maxHeight,minSize.height+labelHeight+tickPadding);me.ctx.font=tickFont.font;var firstLabelWidth=computeTextSize(me.ctx,labels[0],tickFont.font);var lastLabelWidth=computeTextSize(me.ctx,labels[labels.length-1],tickFont.font);if(me.labelRotation!==0){me.paddingLeft=opts.position==='bottom'?(cosRotation*firstLabelWidth)+3:(cosRotation*lineSpace)+3;me.paddingRight=opts.position==='bottom'?(cosRotation*lineSpace)+3:(cosRotation*lastLabelWidth)+3;}else{me.paddingLeft=firstLabelWidth/2+3;me.paddingRight=lastLabelWidth/2+3;}}else{if(tickOpts.mirror){largestTextWidth=0;}else{largestTextWidth+=tickPadding+lineSpace;}
minSize.width=Math.min(me.maxWidth,minSize.width+largestTextWidth);me.paddingTop=tickFont.size/2;me.paddingBottom=tickFont.size/2;}}
me.handleMargins();me.width=minSize.width;me.height=minSize.height;},handleMargins:function(){var me=this;if(me.margins){me.paddingLeft=Math.max(me.paddingLeft-me.margins.left,0);me.paddingTop=Math.max(me.paddingTop-me.margins.top,0);me.paddingRight=Math.max(me.paddingRight-me.margins.right,0);me.paddingBottom=Math.max(me.paddingBottom-me.margins.bottom,0);}},afterFit:function(){helpers.callback(this.options.afterFit,[this]);},isHorizontal:function(){return this.options.position==='top'||this.options.position==='bottom';},isFullWidth:function(){return(this.options.fullWidth);},getRightValue:function(rawValue){if(helpers.isNullOrUndef(rawValue)){return NaN;}
if(typeof rawValue==='number'&&!isFinite(rawValue)){return NaN;}
if(rawValue){if(this.isHorizontal()){if(rawValue.x!==undefined){return this.getRightValue(rawValue.x);}}else if(rawValue.y!==undefined){return this.getRightValue(rawValue.y);}}
return rawValue;},getLabelForIndex:helpers.noop,getPixelForValue:helpers.noop,getValueForPixel:helpers.noop,getPixelForTick:function(index){var me=this;var offset=me.options.offset;if(me.isHorizontal()){var innerWidth=me.width-(me.paddingLeft+me.paddingRight);var tickWidth=innerWidth/Math.max((me._ticks.length-(offset?0:1)),1);var pixel=(tickWidth*index)+me.paddingLeft;if(offset){pixel+=tickWidth/2;}
var finalVal=me.left+Math.round(pixel);finalVal+=me.isFullWidth()?me.margins.left:0;return finalVal;}
var innerHeight=me.height-(me.paddingTop+me.paddingBottom);return me.top+(index*(innerHeight/(me._ticks.length-1)));},getPixelForDecimal:function(decimal){var me=this;if(me.isHorizontal()){var innerWidth=me.width-(me.paddingLeft+me.paddingRight);var valueOffset=(innerWidth*decimal)+me.paddingLeft;var finalVal=me.left+Math.round(valueOffset);finalVal+=me.isFullWidth()?me.margins.left:0;return finalVal;}
return me.top+(decimal*me.height);},getBasePixel:function(){return this.getPixelForValue(this.getBaseValue());},getBaseValue:function(){var me=this;var min=me.min;var max=me.max;return me.beginAtZero?0:min<0&&max<0?max:min>0&&max>0?min:0;},_autoSkip:function(ticks){var skipRatio;var me=this;var isHorizontal=me.isHorizontal();var optionTicks=me.options.ticks.minor;var tickCount=ticks.length;var labelRotationRadians=helpers.toRadians(me.labelRotation);var cosRotation=Math.cos(labelRotationRadians);var longestRotatedLabel=me.longestLabelWidth*cosRotation;var result=[];var i,tick,shouldSkip;var maxTicks;if(optionTicks.maxTicksLimit){maxTicks=optionTicks.maxTicksLimit;}
if(isHorizontal){skipRatio=false;if((longestRotatedLabel+optionTicks.autoSkipPadding)*tickCount>(me.width-(me.paddingLeft+me.paddingRight))){skipRatio=1+Math.floor(((longestRotatedLabel+optionTicks.autoSkipPadding)*tickCount)/(me.width-(me.paddingLeft+me.paddingRight)));}
if(maxTicks&&tickCount>maxTicks){skipRatio=Math.max(skipRatio,Math.floor(tickCount/maxTicks));}}
for(i=0;i<tickCount;i++){tick=ticks[i];shouldSkip=(skipRatio>1&&i%skipRatio>0)||(i%skipRatio===0&&i+skipRatio>=tickCount);if(shouldSkip&&i!==tickCount-1){delete tick.label;}
result.push(tick);}
return result;},draw:function(chartArea){var me=this;var options=me.options;if(!options.display){return;}
var context=me.ctx;var globalDefaults=defaults.global;var optionTicks=options.ticks.minor;var optionMajorTicks=options.ticks.major||optionTicks;var gridLines=options.gridLines;var scaleLabel=options.scaleLabel;var isRotated=me.labelRotation!==0;var isHorizontal=me.isHorizontal();var ticks=optionTicks.autoSkip?me._autoSkip(me.getTicks()):me.getTicks();var tickFontColor=helpers.valueOrDefault(optionTicks.fontColor,globalDefaults.defaultFontColor);var tickFont=parseFontOptions(optionTicks);var majorTickFontColor=helpers.valueOrDefault(optionMajorTicks.fontColor,globalDefaults.defaultFontColor);var majorTickFont=parseFontOptions(optionMajorTicks);var tl=gridLines.drawTicks?gridLines.tickMarkLength:0;var scaleLabelFontColor=helpers.valueOrDefault(scaleLabel.fontColor,globalDefaults.defaultFontColor);var scaleLabelFont=parseFontOptions(scaleLabel);var scaleLabelPadding=helpers.options.toPadding(scaleLabel.padding);var labelRotationRadians=helpers.toRadians(me.labelRotation);var itemsToDraw=[];var axisWidth=me.options.gridLines.lineWidth;var xTickStart=options.position==='right'?me.right:me.right-axisWidth-tl;var xTickEnd=options.position==='right'?me.right+tl:me.right;var yTickStart=options.position==='bottom'?me.top+axisWidth:me.bottom-tl-axisWidth;var yTickEnd=options.position==='bottom'?me.top+axisWidth+tl:me.bottom+axisWidth;helpers.each(ticks,function(tick,index){if(helpers.isNullOrUndef(tick.label)){return;}
var label=tick.label;var lineWidth,lineColor,borderDash,borderDashOffset;if(index===me.zeroLineIndex&&options.offset===gridLines.offsetGridLines){lineWidth=gridLines.zeroLineWidth;lineColor=gridLines.zeroLineColor;borderDash=gridLines.zeroLineBorderDash;borderDashOffset=gridLines.zeroLineBorderDashOffset;}else{lineWidth=helpers.valueAtIndexOrDefault(gridLines.lineWidth,index);lineColor=helpers.valueAtIndexOrDefault(gridLines.color,index);borderDash=helpers.valueOrDefault(gridLines.borderDash,globalDefaults.borderDash);borderDashOffset=helpers.valueOrDefault(gridLines.borderDashOffset,globalDefaults.borderDashOffset);}
var tx1,ty1,tx2,ty2,x1,y1,x2,y2,labelX,labelY;var textAlign='middle';var textBaseline='middle';var tickPadding=optionTicks.padding;if(isHorizontal){var labelYOffset=tl+tickPadding;if(options.position==='bottom'){textBaseline=!isRotated?'top':'middle';textAlign=!isRotated?'center':'right';labelY=me.top+labelYOffset;}else{textBaseline=!isRotated?'bottom':'middle';textAlign=!isRotated?'center':'left';labelY=me.bottom-labelYOffset;}
var xLineValue=getLineValue(me,index,gridLines.offsetGridLines&&ticks.length>1);if(xLineValue<me.left){lineColor='rgba(0,0,0,0)';}
xLineValue+=helpers.aliasPixel(lineWidth);labelX=me.getPixelForTick(index)+optionTicks.labelOffset;tx1=tx2=x1=x2=xLineValue;ty1=yTickStart;ty2=yTickEnd;y1=chartArea.top;y2=chartArea.bottom+axisWidth;}else{var isLeft=options.position==='left';var labelXOffset;if(optionTicks.mirror){textAlign=isLeft?'left':'right';labelXOffset=tickPadding;}else{textAlign=isLeft?'right':'left';labelXOffset=tl+tickPadding;}
labelX=isLeft?me.right-labelXOffset:me.left+labelXOffset;var yLineValue=getLineValue(me,index,gridLines.offsetGridLines&&ticks.length>1);if(yLineValue<me.top){lineColor='rgba(0,0,0,0)';}
yLineValue+=helpers.aliasPixel(lineWidth);labelY=me.getPixelForTick(index)+optionTicks.labelOffset;tx1=xTickStart;tx2=xTickEnd;x1=chartArea.left;x2=chartArea.right+axisWidth;ty1=ty2=y1=y2=yLineValue;}
itemsToDraw.push({tx1:tx1,ty1:ty1,tx2:tx2,ty2:ty2,x1:x1,y1:y1,x2:x2,y2:y2,labelX:labelX,labelY:labelY,glWidth:lineWidth,glColor:lineColor,glBorderDash:borderDash,glBorderDashOffset:borderDashOffset,rotation:-1*labelRotationRadians,label:label,major:tick.major,textBaseline:textBaseline,textAlign:textAlign});});helpers.each(itemsToDraw,function(itemToDraw){if(gridLines.display){context.save();context.lineWidth=itemToDraw.glWidth;context.strokeStyle=itemToDraw.glColor;if(context.setLineDash){context.setLineDash(itemToDraw.glBorderDash);context.lineDashOffset=itemToDraw.glBorderDashOffset;}
context.beginPath();if(gridLines.drawTicks){context.moveTo(itemToDraw.tx1,itemToDraw.ty1);context.lineTo(itemToDraw.tx2,itemToDraw.ty2);}
if(gridLines.drawOnChartArea){context.moveTo(itemToDraw.x1,itemToDraw.y1);context.lineTo(itemToDraw.x2,itemToDraw.y2);}
context.stroke();context.restore();}
if(optionTicks.display){context.save();context.translate(itemToDraw.labelX,itemToDraw.labelY);context.rotate(itemToDraw.rotation);context.font=itemToDraw.major?majorTickFont.font:tickFont.font;context.fillStyle=itemToDraw.major?majorTickFontColor:tickFontColor;context.textBaseline=itemToDraw.textBaseline;context.textAlign=itemToDraw.textAlign;var label=itemToDraw.label;if(helpers.isArray(label)){var lineCount=label.length;var lineHeight=tickFont.size*1.5;var y=me.isHorizontal()?0:-lineHeight*(lineCount-1)/2;for(var i=0;i<lineCount;++i){context.fillText(''+label[i],0,y);y+=lineHeight;}}else{context.fillText(label,0,0);}
context.restore();}});if(scaleLabel.display){var scaleLabelX;var scaleLabelY;var rotation=0;var halfLineHeight=parseLineHeight(scaleLabel)/2;if(isHorizontal){scaleLabelX=me.left+((me.right-me.left)/2);scaleLabelY=options.position==='bottom'?me.bottom-halfLineHeight-scaleLabelPadding.bottom:me.top+halfLineHeight+scaleLabelPadding.top;}else{var isLeft=options.position==='left';scaleLabelX=isLeft?me.left+halfLineHeight+scaleLabelPadding.top:me.right-halfLineHeight-scaleLabelPadding.top;scaleLabelY=me.top+((me.bottom-me.top)/2);rotation=isLeft?-0.5*Math.PI:0.5*Math.PI;}
context.save();context.translate(scaleLabelX,scaleLabelY);context.rotate(rotation);context.textAlign='center';context.textBaseline='middle';context.fillStyle=scaleLabelFontColor;context.font=scaleLabelFont.font;context.fillText(scaleLabel.labelString,0,0);context.restore();}
if(gridLines.drawBorder){context.lineWidth=helpers.valueAtIndexOrDefault(gridLines.lineWidth,0);context.strokeStyle=helpers.valueAtIndexOrDefault(gridLines.color,0);var x1=me.left;var x2=me.right+axisWidth;var y1=me.top;var y2=me.bottom+axisWidth;var aliasPixel=helpers.aliasPixel(context.lineWidth);if(isHorizontal){y1=y2=options.position==='top'?me.bottom:me.top;y1+=aliasPixel;y2+=aliasPixel;}else{x1=x2=options.position==='left'?me.right:me.left;x1+=aliasPixel;x2+=aliasPixel;}
context.beginPath();context.moveTo(x1,y1);context.lineTo(x2,y2);context.stroke();}}});};},{"25":25,"26":26,"34":34,"45":45}],33:[function(require,module,exports){'use strict';var defaults=require(25);var helpers=require(45);var layouts=require(30);module.exports=function(Chart){Chart.scaleService={constructors:{},defaults:{},registerScaleType:function(type,scaleConstructor,scaleDefaults){this.constructors[type]=scaleConstructor;this.defaults[type]=helpers.clone(scaleDefaults);},getScaleConstructor:function(type){return this.constructors.hasOwnProperty(type)?this.constructors[type]:undefined;},getScaleDefaults:function(type){return this.defaults.hasOwnProperty(type)?helpers.merge({},[defaults.scale,this.defaults[type]]):{};},updateScaleDefaults:function(type,additions){var me=this;if(me.defaults.hasOwnProperty(type)){me.defaults[type]=helpers.extend(me.defaults[type],additions);}},addScalesToLayout:function(chart){helpers.each(chart.scales,function(scale){scale.fullWidth=scale.options.fullWidth;scale.position=scale.options.position;scale.weight=scale.options.weight;layouts.addBox(chart,scale);});}};};},{"25":25,"30":30,"45":45}],34:[function(require,module,exports){'use strict';var helpers=require(45);module.exports={formatters:{values:function(value){return helpers.isArray(value)?value:''+value;},linear:function(tickValue,index,ticks){var delta=ticks.length>3?ticks[2]-ticks[1]:ticks[1]-ticks[0];if(Math.abs(delta)>1){if(tickValue!==Math.floor(tickValue)){delta=tickValue-Math.floor(tickValue);}}
var logDelta=helpers.log10(Math.abs(delta));var tickString='';if(tickValue!==0){var numDecimal=-1*Math.floor(logDelta);numDecimal=Math.max(Math.min(numDecimal,20),0);tickString=tickValue.toFixed(numDecimal);}else{tickString='0';}
return tickString;},logarithmic:function(tickValue,index,ticks){var remain=tickValue/(Math.pow(10,Math.floor(helpers.log10(tickValue))));if(tickValue===0){return'0';}else if(remain===1||remain===2||remain===5||index===0||index===ticks.length-1){return tickValue.toExponential();}
return'';}}};},{"45":45}],35:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);var helpers=require(45);defaults._set('global',{tooltips:{enabled:true,custom:null,mode:'nearest',position:'average',intersect:true,backgroundColor:'rgba(0,0,0,0.8)',titleFontStyle:'bold',titleSpacing:2,titleMarginBottom:6,titleFontColor:'#fff',titleAlign:'left',bodySpacing:2,bodyFontColor:'#fff',bodyAlign:'left',footerFontStyle:'bold',footerSpacing:2,footerMarginTop:6,footerFontColor:'#fff',footerAlign:'left',yPadding:6,xPadding:6,caretPadding:2,caretSize:5,cornerRadius:6,multiKeyBackground:'#fff',displayColors:true,borderColor:'rgba(0,0,0,0)',borderWidth:0,callbacks:{beforeTitle:helpers.noop,title:function(tooltipItems,data){var title='';var labels=data.labels;var labelCount=labels?labels.length:0;if(tooltipItems.length>0){var item=tooltipItems[0];if(item.xLabel){title=item.xLabel;}else if(labelCount>0&&item.index<labelCount){title=labels[item.index];}}
return title;},afterTitle:helpers.noop,beforeBody:helpers.noop,beforeLabel:helpers.noop,label:function(tooltipItem,data){var label=data.datasets[tooltipItem.datasetIndex].label||'';if(label){label+=': ';}
label+=tooltipItem.yLabel;return label;},labelColor:function(tooltipItem,chart){var meta=chart.getDatasetMeta(tooltipItem.datasetIndex);var activeElement=meta.data[tooltipItem.index];var view=activeElement._view;return{borderColor:view.borderColor,backgroundColor:view.backgroundColor};},labelTextColor:function(){return this._options.bodyFontColor;},afterLabel:helpers.noop,afterBody:helpers.noop,beforeFooter:helpers.noop,footer:helpers.noop,afterFooter:helpers.noop}}});module.exports=function(Chart){function mergeOpacity(colorString,opacity){var color=helpers.color(colorString);return color.alpha(opacity*color.alpha()).rgbaString();}
function pushOrConcat(base,toPush){if(toPush){if(helpers.isArray(toPush)){Array.prototype.push.apply(base,toPush);}else{base.push(toPush);}}
return base;}
function createTooltipItem(element){var xScale=element._xScale;var yScale=element._yScale||element._scale;var index=element._index;var datasetIndex=element._datasetIndex;return{xLabel:xScale?xScale.getLabelForIndex(index,datasetIndex):'',yLabel:yScale?yScale.getLabelForIndex(index,datasetIndex):'',index:index,datasetIndex:datasetIndex,x:element._model.x,y:element._model.y};}
function getBaseModel(tooltipOpts){var globalDefaults=defaults.global;var valueOrDefault=helpers.valueOrDefault;return{xPadding:tooltipOpts.xPadding,yPadding:tooltipOpts.yPadding,xAlign:tooltipOpts.xAlign,yAlign:tooltipOpts.yAlign,bodyFontColor:tooltipOpts.bodyFontColor,_bodyFontFamily:valueOrDefault(tooltipOpts.bodyFontFamily,globalDefaults.defaultFontFamily),_bodyFontStyle:valueOrDefault(tooltipOpts.bodyFontStyle,globalDefaults.defaultFontStyle),_bodyAlign:tooltipOpts.bodyAlign,bodyFontSize:valueOrDefault(tooltipOpts.bodyFontSize,globalDefaults.defaultFontSize),bodySpacing:tooltipOpts.bodySpacing,titleFontColor:tooltipOpts.titleFontColor,_titleFontFamily:valueOrDefault(tooltipOpts.titleFontFamily,globalDefaults.defaultFontFamily),_titleFontStyle:valueOrDefault(tooltipOpts.titleFontStyle,globalDefaults.defaultFontStyle),titleFontSize:valueOrDefault(tooltipOpts.titleFontSize,globalDefaults.defaultFontSize),_titleAlign:tooltipOpts.titleAlign,titleSpacing:tooltipOpts.titleSpacing,titleMarginBottom:tooltipOpts.titleMarginBottom,footerFontColor:tooltipOpts.footerFontColor,_footerFontFamily:valueOrDefault(tooltipOpts.footerFontFamily,globalDefaults.defaultFontFamily),_footerFontStyle:valueOrDefault(tooltipOpts.footerFontStyle,globalDefaults.defaultFontStyle),footerFontSize:valueOrDefault(tooltipOpts.footerFontSize,globalDefaults.defaultFontSize),_footerAlign:tooltipOpts.footerAlign,footerSpacing:tooltipOpts.footerSpacing,footerMarginTop:tooltipOpts.footerMarginTop,caretSize:tooltipOpts.caretSize,cornerRadius:tooltipOpts.cornerRadius,backgroundColor:tooltipOpts.backgroundColor,opacity:0,legendColorBackground:tooltipOpts.multiKeyBackground,displayColors:tooltipOpts.displayColors,borderColor:tooltipOpts.borderColor,borderWidth:tooltipOpts.borderWidth};}
function getTooltipSize(tooltip,model){var ctx=tooltip._chart.ctx;var height=model.yPadding*2;var width=0;var body=model.body;var combinedBodyLength=body.reduce(function(count,bodyItem){return count+bodyItem.before.length+bodyItem.lines.length+bodyItem.after.length;},0);combinedBodyLength+=model.beforeBody.length+model.afterBody.length;var titleLineCount=model.title.length;var footerLineCount=model.footer.length;var titleFontSize=model.titleFontSize;var bodyFontSize=model.bodyFontSize;var footerFontSize=model.footerFontSize;height+=titleLineCount*titleFontSize;height+=titleLineCount?(titleLineCount-1)*model.titleSpacing:0;height+=titleLineCount?model.titleMarginBottom:0;height+=combinedBodyLength*bodyFontSize;height+=combinedBodyLength?(combinedBodyLength-1)*model.bodySpacing:0;height+=footerLineCount?model.footerMarginTop:0;height+=footerLineCount*(footerFontSize);height+=footerLineCount?(footerLineCount-1)*model.footerSpacing:0;var widthPadding=0;var maxLineWidth=function(line){width=Math.max(width,ctx.measureText(line).width+widthPadding);};ctx.font=helpers.fontString(titleFontSize,model._titleFontStyle,model._titleFontFamily);helpers.each(model.title,maxLineWidth);ctx.font=helpers.fontString(bodyFontSize,model._bodyFontStyle,model._bodyFontFamily);helpers.each(model.beforeBody.concat(model.afterBody),maxLineWidth);widthPadding=model.displayColors?(bodyFontSize+2):0;helpers.each(body,function(bodyItem){helpers.each(bodyItem.before,maxLineWidth);helpers.each(bodyItem.lines,maxLineWidth);helpers.each(bodyItem.after,maxLineWidth);});widthPadding=0;ctx.font=helpers.fontString(footerFontSize,model._footerFontStyle,model._footerFontFamily);helpers.each(model.footer,maxLineWidth);width+=2*model.xPadding;return{width:width,height:height};}
function determineAlignment(tooltip,size){var model=tooltip._model;var chart=tooltip._chart;var chartArea=tooltip._chart.chartArea;var xAlign='center';var yAlign='center';if(model.y<size.height){yAlign='top';}else if(model.y>(chart.height-size.height)){yAlign='bottom';}
var lf,rf;var olf,orf;var yf;var midX=(chartArea.left+chartArea.right)/2;var midY=(chartArea.top+chartArea.bottom)/2;if(yAlign==='center'){lf=function(x){return x<=midX;};rf=function(x){return x>midX;};}else{lf=function(x){return x<=(size.width/2);};rf=function(x){return x>=(chart.width-(size.width/2));};}
olf=function(x){return x+size.width+model.caretSize+model.caretPadding>chart.width;};orf=function(x){return x-size.width-model.caretSize-model.caretPadding<0;};yf=function(y){return y<=midY?'top':'bottom';};if(lf(model.x)){xAlign='left';if(olf(model.x)){xAlign='center';yAlign=yf(model.y);}}else if(rf(model.x)){xAlign='right';if(orf(model.x)){xAlign='center';yAlign=yf(model.y);}}
var opts=tooltip._options;return{xAlign:opts.xAlign?opts.xAlign:xAlign,yAlign:opts.yAlign?opts.yAlign:yAlign};}
function getBackgroundPoint(vm,size,alignment,chart){var x=vm.x;var y=vm.y;var caretSize=vm.caretSize;var caretPadding=vm.caretPadding;var cornerRadius=vm.cornerRadius;var xAlign=alignment.xAlign;var yAlign=alignment.yAlign;var paddingAndSize=caretSize+caretPadding;var radiusAndPadding=cornerRadius+caretPadding;if(xAlign==='right'){x-=size.width;}else if(xAlign==='center'){x-=(size.width/2);if(x+size.width>chart.width){x=chart.width-size.width;}
if(x<0){x=0;}}
if(yAlign==='top'){y+=paddingAndSize;}else if(yAlign==='bottom'){y-=size.height+paddingAndSize;}else{y-=(size.height/2);}
if(yAlign==='center'){if(xAlign==='left'){x+=paddingAndSize;}else if(xAlign==='right'){x-=paddingAndSize;}}else if(xAlign==='left'){x-=radiusAndPadding;}else if(xAlign==='right'){x+=radiusAndPadding;}
return{x:x,y:y};}
Chart.Tooltip=Element.extend({initialize:function(){this._model=getBaseModel(this._options);this._lastActive=[];},getTitle:function(){var me=this;var opts=me._options;var callbacks=opts.callbacks;var beforeTitle=callbacks.beforeTitle.apply(me,arguments);var title=callbacks.title.apply(me,arguments);var afterTitle=callbacks.afterTitle.apply(me,arguments);var lines=[];lines=pushOrConcat(lines,beforeTitle);lines=pushOrConcat(lines,title);lines=pushOrConcat(lines,afterTitle);return lines;},getBeforeBody:function(){var lines=this._options.callbacks.beforeBody.apply(this,arguments);return helpers.isArray(lines)?lines:lines!==undefined?[lines]:[];},getBody:function(tooltipItems,data){var me=this;var callbacks=me._options.callbacks;var bodyItems=[];helpers.each(tooltipItems,function(tooltipItem){var bodyItem={before:[],lines:[],after:[]};pushOrConcat(bodyItem.before,callbacks.beforeLabel.call(me,tooltipItem,data));pushOrConcat(bodyItem.lines,callbacks.label.call(me,tooltipItem,data));pushOrConcat(bodyItem.after,callbacks.afterLabel.call(me,tooltipItem,data));bodyItems.push(bodyItem);});return bodyItems;},getAfterBody:function(){var lines=this._options.callbacks.afterBody.apply(this,arguments);return helpers.isArray(lines)?lines:lines!==undefined?[lines]:[];},getFooter:function(){var me=this;var callbacks=me._options.callbacks;var beforeFooter=callbacks.beforeFooter.apply(me,arguments);var footer=callbacks.footer.apply(me,arguments);var afterFooter=callbacks.afterFooter.apply(me,arguments);var lines=[];lines=pushOrConcat(lines,beforeFooter);lines=pushOrConcat(lines,footer);lines=pushOrConcat(lines,afterFooter);return lines;},update:function(changed){var me=this;var opts=me._options;var existingModel=me._model;var model=me._model=getBaseModel(opts);var active=me._active;var data=me._data;var alignment={xAlign:existingModel.xAlign,yAlign:existingModel.yAlign};var backgroundPoint={x:existingModel.x,y:existingModel.y};var tooltipSize={width:existingModel.width,height:existingModel.height};var tooltipPosition={x:existingModel.caretX,y:existingModel.caretY};var i,len;if(active.length){model.opacity=1;var labelColors=[];var labelTextColors=[];tooltipPosition=Chart.Tooltip.positioners[opts.position].call(me,active,me._eventPosition);var tooltipItems=[];for(i=0,len=active.length;i<len;++i){tooltipItems.push(createTooltipItem(active[i]));}
if(opts.filter){tooltipItems=tooltipItems.filter(function(a){return opts.filter(a,data);});}
if(opts.itemSort){tooltipItems=tooltipItems.sort(function(a,b){return opts.itemSort(a,b,data);});}
helpers.each(tooltipItems,function(tooltipItem){labelColors.push(opts.callbacks.labelColor.call(me,tooltipItem,me._chart));labelTextColors.push(opts.callbacks.labelTextColor.call(me,tooltipItem,me._chart));});model.title=me.getTitle(tooltipItems,data);model.beforeBody=me.getBeforeBody(tooltipItems,data);model.body=me.getBody(tooltipItems,data);model.afterBody=me.getAfterBody(tooltipItems,data);model.footer=me.getFooter(tooltipItems,data);model.x=Math.round(tooltipPosition.x);model.y=Math.round(tooltipPosition.y);model.caretPadding=opts.caretPadding;model.labelColors=labelColors;model.labelTextColors=labelTextColors;model.dataPoints=tooltipItems;tooltipSize=getTooltipSize(this,model);alignment=determineAlignment(this,tooltipSize);backgroundPoint=getBackgroundPoint(model,tooltipSize,alignment,me._chart);}else{model.opacity=0;}
model.xAlign=alignment.xAlign;model.yAlign=alignment.yAlign;model.x=backgroundPoint.x;model.y=backgroundPoint.y;model.width=tooltipSize.width;model.height=tooltipSize.height;model.caretX=tooltipPosition.x;model.caretY=tooltipPosition.y;me._model=model;if(changed&&opts.custom){opts.custom.call(me,model);}
return me;},drawCaret:function(tooltipPoint,size){var ctx=this._chart.ctx;var vm=this._view;var caretPosition=this.getCaretPosition(tooltipPoint,size,vm);ctx.lineTo(caretPosition.x1,caretPosition.y1);ctx.lineTo(caretPosition.x2,caretPosition.y2);ctx.lineTo(caretPosition.x3,caretPosition.y3);},getCaretPosition:function(tooltipPoint,size,vm){var x1,x2,x3,y1,y2,y3;var caretSize=vm.caretSize;var cornerRadius=vm.cornerRadius;var xAlign=vm.xAlign;var yAlign=vm.yAlign;var ptX=tooltipPoint.x;var ptY=tooltipPoint.y;var width=size.width;var height=size.height;if(yAlign==='center'){y2=ptY+(height/2);if(xAlign==='left'){x1=ptX;x2=x1-caretSize;x3=x1;y1=y2+caretSize;y3=y2-caretSize;}else{x1=ptX+width;x2=x1+caretSize;x3=x1;y1=y2-caretSize;y3=y2+caretSize;}}else{if(xAlign==='left'){x2=ptX+cornerRadius+(caretSize);x1=x2-caretSize;x3=x2+caretSize;}else if(xAlign==='right'){x2=ptX+width-cornerRadius-caretSize;x1=x2-caretSize;x3=x2+caretSize;}else{x2=vm.caretX;x1=x2-caretSize;x3=x2+caretSize;}
if(yAlign==='top'){y1=ptY;y2=y1-caretSize;y3=y1;}else{y1=ptY+height;y2=y1+caretSize;y3=y1;var tmp=x3;x3=x1;x1=tmp;}}
return{x1:x1,x2:x2,x3:x3,y1:y1,y2:y2,y3:y3};},drawTitle:function(pt,vm,ctx,opacity){var title=vm.title;if(title.length){ctx.textAlign=vm._titleAlign;ctx.textBaseline='top';var titleFontSize=vm.titleFontSize;var titleSpacing=vm.titleSpacing;ctx.fillStyle=mergeOpacity(vm.titleFontColor,opacity);ctx.font=helpers.fontString(titleFontSize,vm._titleFontStyle,vm._titleFontFamily);var i,len;for(i=0,len=title.length;i<len;++i){ctx.fillText(title[i],pt.x,pt.y);pt.y+=titleFontSize+titleSpacing;if(i+1===title.length){pt.y+=vm.titleMarginBottom-titleSpacing;}}}},drawBody:function(pt,vm,ctx,opacity){var bodyFontSize=vm.bodyFontSize;var bodySpacing=vm.bodySpacing;var body=vm.body;ctx.textAlign=vm._bodyAlign;ctx.textBaseline='top';ctx.font=helpers.fontString(bodyFontSize,vm._bodyFontStyle,vm._bodyFontFamily);var xLinePadding=0;var fillLineOfText=function(line){ctx.fillText(line,pt.x+xLinePadding,pt.y);pt.y+=bodyFontSize+bodySpacing;};ctx.fillStyle=mergeOpacity(vm.bodyFontColor,opacity);helpers.each(vm.beforeBody,fillLineOfText);var drawColorBoxes=vm.displayColors;xLinePadding=drawColorBoxes?(bodyFontSize+2):0;helpers.each(body,function(bodyItem,i){var textColor=mergeOpacity(vm.labelTextColors[i],opacity);ctx.fillStyle=textColor;helpers.each(bodyItem.before,fillLineOfText);helpers.each(bodyItem.lines,function(line){if(drawColorBoxes){ctx.fillStyle=mergeOpacity(vm.legendColorBackground,opacity);ctx.fillRect(pt.x,pt.y,bodyFontSize,bodyFontSize);ctx.lineWidth=1;ctx.strokeStyle=mergeOpacity(vm.labelColors[i].borderColor,opacity);ctx.strokeRect(pt.x,pt.y,bodyFontSize,bodyFontSize);ctx.fillStyle=mergeOpacity(vm.labelColors[i].backgroundColor,opacity);ctx.fillRect(pt.x+1,pt.y+1,bodyFontSize-2,bodyFontSize-2);ctx.fillStyle=textColor;}
fillLineOfText(line);});helpers.each(bodyItem.after,fillLineOfText);});xLinePadding=0;helpers.each(vm.afterBody,fillLineOfText);pt.y-=bodySpacing;},drawFooter:function(pt,vm,ctx,opacity){var footer=vm.footer;if(footer.length){pt.y+=vm.footerMarginTop;ctx.textAlign=vm._footerAlign;ctx.textBaseline='top';ctx.fillStyle=mergeOpacity(vm.footerFontColor,opacity);ctx.font=helpers.fontString(vm.footerFontSize,vm._footerFontStyle,vm._footerFontFamily);helpers.each(footer,function(line){ctx.fillText(line,pt.x,pt.y);pt.y+=vm.footerFontSize+vm.footerSpacing;});}},drawBackground:function(pt,vm,ctx,tooltipSize,opacity){ctx.fillStyle=mergeOpacity(vm.backgroundColor,opacity);ctx.strokeStyle=mergeOpacity(vm.borderColor,opacity);ctx.lineWidth=vm.borderWidth;var xAlign=vm.xAlign;var yAlign=vm.yAlign;var x=pt.x;var y=pt.y;var width=tooltipSize.width;var height=tooltipSize.height;var radius=vm.cornerRadius;ctx.beginPath();ctx.moveTo(x+radius,y);if(yAlign==='top'){this.drawCaret(pt,tooltipSize);}
ctx.lineTo(x+width-radius,y);ctx.quadraticCurveTo(x+width,y,x+width,y+radius);if(yAlign==='center'&&xAlign==='right'){this.drawCaret(pt,tooltipSize);}
ctx.lineTo(x+width,y+height-radius);ctx.quadraticCurveTo(x+width,y+height,x+width-radius,y+height);if(yAlign==='bottom'){this.drawCaret(pt,tooltipSize);}
ctx.lineTo(x+radius,y+height);ctx.quadraticCurveTo(x,y+height,x,y+height-radius);if(yAlign==='center'&&xAlign==='left'){this.drawCaret(pt,tooltipSize);}
ctx.lineTo(x,y+radius);ctx.quadraticCurveTo(x,y,x+radius,y);ctx.closePath();ctx.fill();if(vm.borderWidth>0){ctx.stroke();}},draw:function(){var ctx=this._chart.ctx;var vm=this._view;if(vm.opacity===0){return;}
var tooltipSize={width:vm.width,height:vm.height};var pt={x:vm.x,y:vm.y};var opacity=Math.abs(vm.opacity<1e-3)?0:vm.opacity;var hasTooltipContent=vm.title.length||vm.beforeBody.length||vm.body.length||vm.afterBody.length||vm.footer.length;if(this._options.enabled&&hasTooltipContent){this.drawBackground(pt,vm,ctx,tooltipSize,opacity);pt.x+=vm.xPadding;pt.y+=vm.yPadding;this.drawTitle(pt,vm,ctx,opacity);this.drawBody(pt,vm,ctx,opacity);this.drawFooter(pt,vm,ctx,opacity);}},handleEvent:function(e){var me=this;var options=me._options;var changed=false;me._lastActive=me._lastActive||[];if(e.type==='mouseout'){me._active=[];}else{me._active=me._chart.getElementsAtEventForMode(e,options.mode,options);}
changed=!helpers.arrayEquals(me._active,me._lastActive);if(changed){me._lastActive=me._active;if(options.enabled||options.custom){me._eventPosition={x:e.x,y:e.y};me.update(true);me.pivot();}}
return changed;}});Chart.Tooltip.positioners={average:function(elements){if(!elements.length){return false;}
var i,len;var x=0;var y=0;var count=0;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var pos=el.tooltipPosition();x+=pos.x;y+=pos.y;++count;}}
return{x:Math.round(x/count),y:Math.round(y/count)};},nearest:function(elements,eventPosition){var x=eventPosition.x;var y=eventPosition.y;var minDistance=Number.POSITIVE_INFINITY;var i,len,nearestElement;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var center=el.getCenterPoint();var d=helpers.distanceBetweenPoints(eventPosition,center);if(d<minDistance){minDistance=d;nearestElement=el;}}}
if(nearestElement){var tp=nearestElement.tooltipPosition();x=tp.x;y=tp.y;}
return{x:x,y:y};}};};},{"25":25,"26":26,"45":45}],36:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);var helpers=require(45);defaults._set('global',{elements:{arc:{backgroundColor:defaults.global.defaultColor,borderColor:'#fff',borderWidth:2}}});module.exports=Element.extend({inLabelRange:function(mouseX){var vm=this._view;if(vm){return(Math.pow(mouseX-vm.x,2)<Math.pow(vm.radius+vm.hoverRadius,2));}
return false;},inRange:function(chartX,chartY){var vm=this._view;if(vm){var pointRelativePosition=helpers.getAngleFromPoint(vm,{x:chartX,y:chartY});var	angle=pointRelativePosition.angle;var distance=pointRelativePosition.distance;var startAngle=vm.startAngle;var endAngle=vm.endAngle;while(endAngle<startAngle){endAngle+=2.0*Math.PI;}
while(angle>endAngle){angle-=2.0*Math.PI;}
while(angle<startAngle){angle+=2.0*Math.PI;}
var betweenAngles=(angle>=startAngle&&angle<=endAngle);var withinRadius=(distance>=vm.innerRadius&&distance<=vm.outerRadius);return(betweenAngles&&withinRadius);}
return false;},getCenterPoint:function(){var vm=this._view;var halfAngle=(vm.startAngle+vm.endAngle)/2;var halfRadius=(vm.innerRadius+vm.outerRadius)/2;return{x:vm.x+Math.cos(halfAngle)*halfRadius,y:vm.y+Math.sin(halfAngle)*halfRadius};},getArea:function(){var vm=this._view;return Math.PI*((vm.endAngle-vm.startAngle)/(2*Math.PI))*(Math.pow(vm.outerRadius,2)-Math.pow(vm.innerRadius,2));},tooltipPosition:function(){var vm=this._view;var centreAngle=vm.startAngle+((vm.endAngle-vm.startAngle)/2);var rangeFromCentre=(vm.outerRadius-vm.innerRadius)/2+vm.innerRadius;return{x:vm.x+(Math.cos(centreAngle)*rangeFromCentre),y:vm.y+(Math.sin(centreAngle)*rangeFromCentre)};},draw:function(){var ctx=this._chart.ctx;var vm=this._view;var sA=vm.startAngle;var eA=vm.endAngle;ctx.beginPath();ctx.arc(vm.x,vm.y,vm.outerRadius,sA,eA);ctx.arc(vm.x,vm.y,vm.innerRadius,eA,sA,true);ctx.closePath();ctx.strokeStyle=vm.borderColor;ctx.lineWidth=vm.borderWidth;ctx.fillStyle=vm.backgroundColor;ctx.fill();ctx.lineJoin='bevel';if(vm.borderWidth){ctx.stroke();}}});},{"25":25,"26":26,"45":45}],37:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);var helpers=require(45);var globalDefaults=defaults.global;defaults._set('global',{elements:{line:{tension:0.4,backgroundColor:globalDefaults.defaultColor,borderWidth:3,borderColor:globalDefaults.defaultColor,borderCapStyle:'butt',borderDash:[],borderDashOffset:0.0,borderJoinStyle:'miter',capBezierPoints:true,fill:true,}}});module.exports=Element.extend({draw:function(){var me=this;var vm=me._view;var ctx=me._chart.ctx;var spanGaps=vm.spanGaps;var points=me._children.slice();var globalOptionLineElements=globalDefaults.elements.line;var lastDrawnIndex=-1;var index,current,previous,currentVM;if(me._loop&&points.length){points.push(points[0]);}
ctx.save();ctx.lineCap=vm.borderCapStyle||globalOptionLineElements.borderCapStyle;if(ctx.setLineDash){ctx.setLineDash(vm.borderDash||globalOptionLineElements.borderDash);}
ctx.lineDashOffset=vm.borderDashOffset||globalOptionLineElements.borderDashOffset;ctx.lineJoin=vm.borderJoinStyle||globalOptionLineElements.borderJoinStyle;ctx.lineWidth=vm.borderWidth||globalOptionLineElements.borderWidth;ctx.strokeStyle=vm.borderColor||globalDefaults.defaultColor;ctx.beginPath();lastDrawnIndex=-1;for(index=0;index<points.length;++index){current=points[index];previous=helpers.previousItem(points,index);currentVM=current._view;if(index===0){if(!currentVM.skip){ctx.moveTo(currentVM.x,currentVM.y);lastDrawnIndex=index;}}else{previous=lastDrawnIndex===-1?previous:points[lastDrawnIndex];if(!currentVM.skip){if((lastDrawnIndex!==(index-1)&&!spanGaps)||lastDrawnIndex===-1){ctx.moveTo(currentVM.x,currentVM.y);}else{helpers.canvas.lineTo(ctx,previous._view,current._view);}
lastDrawnIndex=index;}}}
ctx.stroke();ctx.restore();}});},{"25":25,"26":26,"45":45}],38:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);var helpers=require(45);var defaultColor=defaults.global.defaultColor;defaults._set('global',{elements:{point:{radius:3,pointStyle:'circle',backgroundColor:defaultColor,borderColor:defaultColor,borderWidth:1,hitRadius:1,hoverRadius:4,hoverBorderWidth:1}}});function xRange(mouseX){var vm=this._view;return vm?(Math.abs(mouseX-vm.x)<vm.radius+vm.hitRadius):false;}
function yRange(mouseY){var vm=this._view;return vm?(Math.abs(mouseY-vm.y)<vm.radius+vm.hitRadius):false;}
module.exports=Element.extend({inRange:function(mouseX,mouseY){var vm=this._view;return vm?((Math.pow(mouseX-vm.x,2)+Math.pow(mouseY-vm.y,2))<Math.pow(vm.hitRadius+vm.radius,2)):false;},inLabelRange:xRange,inXRange:xRange,inYRange:yRange,getCenterPoint:function(){var vm=this._view;return{x:vm.x,y:vm.y};},getArea:function(){return Math.PI*Math.pow(this._view.radius,2);},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y,padding:vm.radius+vm.borderWidth};},draw:function(chartArea){var vm=this._view;var model=this._model;var ctx=this._chart.ctx;var pointStyle=vm.pointStyle;var radius=vm.radius;var x=vm.x;var y=vm.y;var color=helpers.color;var errMargin=1.01;var ratio=0;if(vm.skip){return;}
ctx.strokeStyle=vm.borderColor||defaultColor;ctx.lineWidth=helpers.valueOrDefault(vm.borderWidth,defaults.global.elements.point.borderWidth);ctx.fillStyle=vm.backgroundColor||defaultColor;if((chartArea!==undefined)&&((model.x<chartArea.left)||(chartArea.right*errMargin<model.x)||(model.y<chartArea.top)||(chartArea.bottom*errMargin<model.y))){if(model.x<chartArea.left){ratio=(x-model.x)/(chartArea.left-model.x);}else if(chartArea.right*errMargin<model.x){ratio=(model.x-x)/(model.x-chartArea.right);}else if(model.y<chartArea.top){ratio=(y-model.y)/(chartArea.top-model.y);}else if(chartArea.bottom*errMargin<model.y){ratio=(model.y-y)/(model.y-chartArea.bottom);}
ratio=Math.round(ratio*100)/100;ctx.strokeStyle=color(ctx.strokeStyle).alpha(ratio).rgbString();ctx.fillStyle=color(ctx.fillStyle).alpha(ratio).rgbString();}
helpers.canvas.drawPoint(ctx,pointStyle,radius,x,y);}});},{"25":25,"26":26,"45":45}],39:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);defaults._set('global',{elements:{rectangle:{backgroundColor:defaults.global.defaultColor,borderColor:defaults.global.defaultColor,borderSkipped:'bottom',borderWidth:0}}});function isVertical(bar){return bar._view.width!==undefined;}
function getBarBounds(bar){var vm=bar._view;var x1,x2,y1,y2;if(isVertical(bar)){var halfWidth=vm.width/2;x1=vm.x-halfWidth;x2=vm.x+halfWidth;y1=Math.min(vm.y,vm.base);y2=Math.max(vm.y,vm.base);}else{var halfHeight=vm.height/2;x1=Math.min(vm.x,vm.base);x2=Math.max(vm.x,vm.base);y1=vm.y-halfHeight;y2=vm.y+halfHeight;}
return{left:x1,top:y1,right:x2,bottom:y2};}
module.exports=Element.extend({draw:function(){var ctx=this._chart.ctx;var vm=this._view;var left,right,top,bottom,signX,signY,borderSkipped;var borderWidth=vm.borderWidth;if(!vm.horizontal){left=vm.x-vm.width/2;right=vm.x+vm.width/2;top=vm.y;bottom=vm.base;signX=1;signY=bottom>top?1:-1;borderSkipped=vm.borderSkipped||'bottom';}else{left=vm.base;right=vm.x;top=vm.y-vm.height/2;bottom=vm.y+vm.height/2;signX=right>left?1:-1;signY=1;borderSkipped=vm.borderSkipped||'left';}
if(borderWidth){var barSize=Math.min(Math.abs(left-right),Math.abs(top-bottom));borderWidth=borderWidth>barSize?barSize:borderWidth;var halfStroke=borderWidth/2;var borderLeft=left+(borderSkipped!=='left'?halfStroke*signX:0);var borderRight=right+(borderSkipped!=='right'?-halfStroke*signX:0);var borderTop=top+(borderSkipped!=='top'?halfStroke*signY:0);var borderBottom=bottom+(borderSkipped!=='bottom'?-halfStroke*signY:0);if(borderLeft!==borderRight){top=borderTop;bottom=borderBottom;}
if(borderTop!==borderBottom){left=borderLeft;right=borderRight;}}
ctx.beginPath();ctx.fillStyle=vm.backgroundColor;ctx.strokeStyle=vm.borderColor;ctx.lineWidth=borderWidth;var corners=[[left,bottom],[left,top],[right,top],[right,bottom]];var borders=['bottom','left','top','right'];var startCorner=borders.indexOf(borderSkipped,0);if(startCorner===-1){startCorner=0;}
function cornerAt(index){return corners[(startCorner+index)%4];}
var corner=cornerAt(0);ctx.moveTo(corner[0],corner[1]);for(var i=1;i<4;i++){corner=cornerAt(i);ctx.lineTo(corner[0],corner[1]);}
ctx.fill();if(borderWidth){ctx.stroke();}},height:function(){var vm=this._view;return vm.base-vm.y;},inRange:function(mouseX,mouseY){var inRange=false;if(this._view){var bounds=getBarBounds(this);inRange=mouseX>=bounds.left&&mouseX<=bounds.right&&mouseY>=bounds.top&&mouseY<=bounds.bottom;}
return inRange;},inLabelRange:function(mouseX,mouseY){var me=this;if(!me._view){return false;}
var inRange=false;var bounds=getBarBounds(me);if(isVertical(me)){inRange=mouseX>=bounds.left&&mouseX<=bounds.right;}else{inRange=mouseY>=bounds.top&&mouseY<=bounds.bottom;}
return inRange;},inXRange:function(mouseX){var bounds=getBarBounds(this);return mouseX>=bounds.left&&mouseX<=bounds.right;},inYRange:function(mouseY){var bounds=getBarBounds(this);return mouseY>=bounds.top&&mouseY<=bounds.bottom;},getCenterPoint:function(){var vm=this._view;var x,y;if(isVertical(this)){x=vm.x;y=(vm.y+vm.base)/2;}else{x=(vm.x+vm.base)/2;y=vm.y;}
return{x:x,y:y};},getArea:function(){var vm=this._view;return vm.width*Math.abs(vm.y-vm.base);},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y};}});},{"25":25,"26":26}],40:[function(require,module,exports){'use strict';module.exports={};module.exports.Arc=require(36);module.exports.Line=require(37);module.exports.Point=require(38);module.exports.Rectangle=require(39);},{"36":36,"37":37,"38":38,"39":39}],41:[function(require,module,exports){'use strict';var helpers=require(42);var exports=module.exports={clear:function(chart){chart.ctx.clearRect(0,0,chart.width,chart.height);},roundedRect:function(ctx,x,y,width,height,radius){if(radius){var rx=Math.min(radius,width/2);var ry=Math.min(radius,height/2);ctx.moveTo(x+rx,y);ctx.lineTo(x+width-rx,y);ctx.quadraticCurveTo(x+width,y,x+width,y+ry);ctx.lineTo(x+width,y+height-ry);ctx.quadraticCurveTo(x+width,y+height,x+width-rx,y+height);ctx.lineTo(x+rx,y+height);ctx.quadraticCurveTo(x,y+height,x,y+height-ry);ctx.lineTo(x,y+ry);ctx.quadraticCurveTo(x,y,x+rx,y);}else{ctx.rect(x,y,width,height);}},drawPoint:function(ctx,style,radius,x,y){var type,edgeLength,xOffset,yOffset,height,size;if(style&&typeof style==='object'){type=style.toString();if(type==='[object HTMLImageElement]'||type==='[object HTMLCanvasElement]'){ctx.drawImage(style,x-style.width/2,y-style.height/2,style.width,style.height);return;}}
if(isNaN(radius)||radius<=0){return;}
switch(style){default:ctx.beginPath();ctx.arc(x,y,radius,0,Math.PI*2);ctx.closePath();ctx.fill();break;case'triangle':ctx.beginPath();edgeLength=3*radius/Math.sqrt(3);height=edgeLength*Math.sqrt(3)/2;ctx.moveTo(x-edgeLength/2,y+height/3);ctx.lineTo(x+edgeLength/2,y+height/3);ctx.lineTo(x,y-2*height/3);ctx.closePath();ctx.fill();break;case'rect':size=1/Math.SQRT2*radius;ctx.beginPath();ctx.fillRect(x-size,y-size,2*size,2*size);ctx.strokeRect(x-size,y-size,2*size,2*size);break;case'rectRounded':var offset=radius/Math.SQRT2;var leftX=x-offset;var topY=y-offset;var sideSize=Math.SQRT2*radius;ctx.beginPath();this.roundedRect(ctx,leftX,topY,sideSize,sideSize,radius/2);ctx.closePath();ctx.fill();break;case'rectRot':size=1/Math.SQRT2*radius;ctx.beginPath();ctx.moveTo(x-size,y);ctx.lineTo(x,y+size);ctx.lineTo(x+size,y);ctx.lineTo(x,y-size);ctx.closePath();ctx.fill();break;case'cross':ctx.beginPath();ctx.moveTo(x,y+radius);ctx.lineTo(x,y-radius);ctx.moveTo(x-radius,y);ctx.lineTo(x+radius,y);ctx.closePath();break;case'crossRot':ctx.beginPath();xOffset=Math.cos(Math.PI/4)*radius;yOffset=Math.sin(Math.PI/4)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x-xOffset,y+yOffset);ctx.lineTo(x+xOffset,y-yOffset);ctx.closePath();break;case'star':ctx.beginPath();ctx.moveTo(x,y+radius);ctx.lineTo(x,y-radius);ctx.moveTo(x-radius,y);ctx.lineTo(x+radius,y);xOffset=Math.cos(Math.PI/4)*radius;yOffset=Math.sin(Math.PI/4)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x-xOffset,y+yOffset);ctx.lineTo(x+xOffset,y-yOffset);ctx.closePath();break;case'line':ctx.beginPath();ctx.moveTo(x-radius,y);ctx.lineTo(x+radius,y);ctx.closePath();break;case'dash':ctx.beginPath();ctx.moveTo(x,y);ctx.lineTo(x+radius,y);ctx.closePath();break;}
ctx.stroke();},clipArea:function(ctx,area){ctx.save();ctx.beginPath();ctx.rect(area.left,area.top,area.right-area.left,area.bottom-area.top);ctx.clip();},unclipArea:function(ctx){ctx.restore();},lineTo:function(ctx,previous,target,flip){if(target.steppedLine){if((target.steppedLine==='after'&&!flip)||(target.steppedLine!=='after'&&flip)){ctx.lineTo(previous.x,target.y);}else{ctx.lineTo(target.x,previous.y);}
ctx.lineTo(target.x,target.y);return;}
if(!target.tension){ctx.lineTo(target.x,target.y);return;}
ctx.bezierCurveTo(flip?previous.controlPointPreviousX:previous.controlPointNextX,flip?previous.controlPointPreviousY:previous.controlPointNextY,flip?target.controlPointNextX:target.controlPointPreviousX,flip?target.controlPointNextY:target.controlPointPreviousY,target.x,target.y);}};helpers.clear=exports.clear;helpers.drawRoundedRectangle=function(ctx){ctx.beginPath();exports.roundedRect.apply(exports,arguments);ctx.closePath();};},{"42":42}],42:[function(require,module,exports){'use strict';var helpers={noop:function(){},uid:(function(){var id=0;return function(){return id++;};}()),isNullOrUndef:function(value){return value===null||typeof value==='undefined';},isArray:Array.isArray?Array.isArray:function(value){return Object.prototype.toString.call(value)==='[object Array]';},isObject:function(value){return value!==null&&Object.prototype.toString.call(value)==='[object Object]';},valueOrDefault:function(value,defaultValue){return typeof value==='undefined'?defaultValue:value;},valueAtIndexOrDefault:function(value,index,defaultValue){return helpers.valueOrDefault(helpers.isArray(value)?value[index]:value,defaultValue);},callback:function(fn,args,thisArg){if(fn&&typeof fn.call==='function'){return fn.apply(thisArg,args);}},each:function(loopable,fn,thisArg,reverse){var i,len,keys;if(helpers.isArray(loopable)){len=loopable.length;if(reverse){for(i=len-1;i>=0;i--){fn.call(thisArg,loopable[i],i);}}else{for(i=0;i<len;i++){fn.call(thisArg,loopable[i],i);}}}else if(helpers.isObject(loopable)){keys=Object.keys(loopable);len=keys.length;for(i=0;i<len;i++){fn.call(thisArg,loopable[keys[i]],keys[i]);}}},arrayEquals:function(a0,a1){var i,ilen,v0,v1;if(!a0||!a1||a0.length!==a1.length){return false;}
for(i=0,ilen=a0.length;i<ilen;++i){v0=a0[i];v1=a1[i];if(v0 instanceof Array&&v1 instanceof Array){if(!helpers.arrayEquals(v0,v1)){return false;}}else if(v0!==v1){return false;}}
return true;},clone:function(source){if(helpers.isArray(source)){return source.map(helpers.clone);}
if(helpers.isObject(source)){var target={};var keys=Object.keys(source);var klen=keys.length;var k=0;for(;k<klen;++k){target[keys[k]]=helpers.clone(source[keys[k]]);}
return target;}
return source;},_merger:function(key,target,source,options){var tval=target[key];var sval=source[key];if(helpers.isObject(tval)&&helpers.isObject(sval)){helpers.merge(tval,sval,options);}else{target[key]=helpers.clone(sval);}},_mergerIf:function(key,target,source){var tval=target[key];var sval=source[key];if(helpers.isObject(tval)&&helpers.isObject(sval)){helpers.mergeIf(tval,sval);}else if(!target.hasOwnProperty(key)){target[key]=helpers.clone(sval);}},merge:function(target,source,options){var sources=helpers.isArray(source)?source:[source];var ilen=sources.length;var merge,i,keys,klen,k;if(!helpers.isObject(target)){return target;}
options=options||{};merge=options.merger||helpers._merger;for(i=0;i<ilen;++i){source=sources[i];if(!helpers.isObject(source)){continue;}
keys=Object.keys(source);for(k=0,klen=keys.length;k<klen;++k){merge(keys[k],target,source,options);}}
return target;},mergeIf:function(target,source){return helpers.merge(target,source,{merger:helpers._mergerIf});},extend:function(target){var setFn=function(value,key){target[key]=value;};for(var i=1,ilen=arguments.length;i<ilen;++i){helpers.each(arguments[i],setFn);}
return target;},inherits:function(extensions){var me=this;var ChartElement=(extensions&&extensions.hasOwnProperty('constructor'))?extensions.constructor:function(){return me.apply(this,arguments);};var Surrogate=function(){this.constructor=ChartElement;};Surrogate.prototype=me.prototype;ChartElement.prototype=new Surrogate();ChartElement.extend=helpers.inherits;if(extensions){helpers.extend(ChartElement.prototype,extensions);}
ChartElement.__super__=me.prototype;return ChartElement;}};module.exports=helpers;helpers.callCallback=helpers.callback;helpers.indexOf=function(array,item,fromIndex){return Array.prototype.indexOf.call(array,item,fromIndex);};helpers.getValueOrDefault=helpers.valueOrDefault;helpers.getValueAtIndexOrDefault=helpers.valueAtIndexOrDefault;},{}],43:[function(require,module,exports){'use strict';var helpers=require(42);var effects={linear:function(t){return t;},easeInQuad:function(t){return t*t;},easeOutQuad:function(t){return-t*(t-2);},easeInOutQuad:function(t){if((t/=0.5)<1){return 0.5*t*t;}
return-0.5*((--t)*(t-2)-1);},easeInCubic:function(t){return t*t*t;},easeOutCubic:function(t){return(t=t-1)*t*t+1;},easeInOutCubic:function(t){if((t/=0.5)<1){return 0.5*t*t*t;}
return 0.5*((t-=2)*t*t+2);},easeInQuart:function(t){return t*t*t*t;},easeOutQuart:function(t){return-((t=t-1)*t*t*t-1);},easeInOutQuart:function(t){if((t/=0.5)<1){return 0.5*t*t*t*t;}
return-0.5*((t-=2)*t*t*t-2);},easeInQuint:function(t){return t*t*t*t*t;},easeOutQuint:function(t){return(t=t-1)*t*t*t*t+1;},easeInOutQuint:function(t){if((t/=0.5)<1){return 0.5*t*t*t*t*t;}
return 0.5*((t-=2)*t*t*t*t+2);},easeInSine:function(t){return-Math.cos(t*(Math.PI/2))+1;},easeOutSine:function(t){return Math.sin(t*(Math.PI/2));},easeInOutSine:function(t){return-0.5*(Math.cos(Math.PI*t)-1);},easeInExpo:function(t){return(t===0)?0:Math.pow(2,10*(t-1));},easeOutExpo:function(t){return(t===1)?1:-Math.pow(2,-10*t)+1;},easeInOutExpo:function(t){if(t===0){return 0;}
if(t===1){return 1;}
if((t/=0.5)<1){return 0.5*Math.pow(2,10*(t-1));}
return 0.5*(-Math.pow(2,-10*--t)+2);},easeInCirc:function(t){if(t>=1){return t;}
return-(Math.sqrt(1-t*t)-1);},easeOutCirc:function(t){return Math.sqrt(1-(t=t-1)*t);},easeInOutCirc:function(t){if((t/=0.5)<1){return-0.5*(Math.sqrt(1-t*t)-1);}
return 0.5*(Math.sqrt(1-(t-=2)*t)+1);},easeInElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0;}
if(t===1){return 1;}
if(!p){p=0.3;}
if(a<1){a=1;s=p/4;}else{s=p/(2*Math.PI)*Math.asin(1/a);}
return-(a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p));},easeOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0;}
if(t===1){return 1;}
if(!p){p=0.3;}
if(a<1){a=1;s=p/4;}else{s=p/(2*Math.PI)*Math.asin(1/a);}
return a*Math.pow(2,-10*t)*Math.sin((t-s)*(2*Math.PI)/p)+1;},easeInOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0;}
if((t/=0.5)===2){return 1;}
if(!p){p=0.45;}
if(a<1){a=1;s=p/4;}else{s=p/(2*Math.PI)*Math.asin(1/a);}
if(t<1){return-0.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p));}
return a*Math.pow(2,-10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p)*0.5+1;},easeInBack:function(t){var s=1.70158;return t*t*((s+1)*t-s);},easeOutBack:function(t){var s=1.70158;return(t=t-1)*t*((s+1)*t+s)+1;},easeInOutBack:function(t){var s=1.70158;if((t/=0.5)<1){return 0.5*(t*t*(((s*=(1.525))+1)*t-s));}
return 0.5*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2);},easeInBounce:function(t){return 1-effects.easeOutBounce(1-t);},easeOutBounce:function(t){if(t<(1/2.75)){return 7.5625*t*t;}
if(t<(2/2.75)){return 7.5625*(t-=(1.5/2.75))*t+0.75;}
if(t<(2.5/2.75)){return 7.5625*(t-=(2.25/2.75))*t+0.9375;}
return 7.5625*(t-=(2.625/2.75))*t+0.984375;},easeInOutBounce:function(t){if(t<0.5){return effects.easeInBounce(t*2)*0.5;}
return effects.easeOutBounce(t*2-1)*0.5+0.5;}};module.exports={effects:effects};helpers.easingEffects=effects;},{"42":42}],44:[function(require,module,exports){'use strict';var helpers=require(42);module.exports={toLineHeight:function(value,size){var matches=(''+value).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);if(!matches||matches[1]==='normal'){return size*1.2;}
value=+matches[2];switch(matches[3]){case'px':return value;case'%':value/=100;break;default:break;}
return size*value;},toPadding:function(value){var t,r,b,l;if(helpers.isObject(value)){t=+value.top||0;r=+value.right||0;b=+value.bottom||0;l=+value.left||0;}else{t=r=b=l=+value||0;}
return{top:t,right:r,bottom:b,left:l,height:t+b,width:l+r};},resolve:function(inputs,context,index){var i,ilen,value;for(i=0,ilen=inputs.length;i<ilen;++i){value=inputs[i];if(value===undefined){continue;}
if(context!==undefined&&typeof value==='function'){value=value(context);}
if(index!==undefined&&helpers.isArray(value)){value=value[index];}
if(value!==undefined){return value;}}}};},{"42":42}],45:[function(require,module,exports){'use strict';module.exports=require(42);module.exports.easing=require(43);module.exports.canvas=require(41);module.exports.options=require(44);},{"41":41,"42":42,"43":43,"44":44}],46:[function(require,module,exports){module.exports={acquireContext:function(item){if(item&&item.canvas){item=item.canvas;}
return item&&item.getContext('2d')||null;}};},{}],47:[function(require,module,exports){'use strict';var helpers=require(45);var EXPANDO_KEY='$chartjs';var CSS_PREFIX='chartjs-';var CSS_RENDER_MONITOR=CSS_PREFIX+'render-monitor';var CSS_RENDER_ANIMATION=CSS_PREFIX+'render-animation';var ANIMATION_START_EVENTS=['animationstart','webkitAnimationStart'];var EVENT_TYPES={touchstart:'mousedown',touchmove:'mousemove',touchend:'mouseup',pointerenter:'mouseenter',pointerdown:'mousedown',pointermove:'mousemove',pointerup:'mouseup',pointerleave:'mouseout',pointerout:'mouseout'};function readUsedSize(element,property){var value=helpers.getStyle(element,property);var matches=value&&value.match(/^(\d+)(\.\d+)?px$/);return matches?Number(matches[1]):undefined;}
function initCanvas(canvas,config){var style=canvas.style;var renderHeight=canvas.getAttribute('height');var renderWidth=canvas.getAttribute('width');canvas[EXPANDO_KEY]={initial:{height:renderHeight,width:renderWidth,style:{display:style.display,height:style.height,width:style.width}}};style.display=style.display||'block';if(renderWidth===null||renderWidth===''){var displayWidth=readUsedSize(canvas,'width');if(displayWidth!==undefined){canvas.width=displayWidth;}}
if(renderHeight===null||renderHeight===''){if(canvas.style.height===''){canvas.height=canvas.width/(config.options.aspectRatio||2);}else{var displayHeight=readUsedSize(canvas,'height');if(displayWidth!==undefined){canvas.height=displayHeight;}}}
return canvas;}
var supportsEventListenerOptions=(function(){var supports=false;try{var options=Object.defineProperty({},'passive',{get:function(){supports=true;}});window.addEventListener('e',null,options);}catch(e){}
return supports;}());var eventListenerOptions=supportsEventListenerOptions?{passive:true}:false;function addEventListener(node,type,listener){node.addEventListener(type,listener,eventListenerOptions);}
function removeEventListener(node,type,listener){node.removeEventListener(type,listener,eventListenerOptions);}
function createEvent(type,chart,x,y,nativeEvent){return{type:type,chart:chart,native:nativeEvent||null,x:x!==undefined?x:null,y:y!==undefined?y:null,};}
function fromNativeEvent(event,chart){var type=EVENT_TYPES[event.type]||event.type;var pos=helpers.getRelativePosition(event,chart);return createEvent(type,chart,pos.x,pos.y,event);}
function throttled(fn,thisArg){var ticking=false;var args=[];return function(){args=Array.prototype.slice.call(arguments);thisArg=thisArg||this;if(!ticking){ticking=true;helpers.requestAnimFrame.call(window,function(){ticking=false;fn.apply(thisArg,args);});}};}
function createResizer(handler){var resizer=document.createElement('div');var cls=CSS_PREFIX+'size-monitor';var maxSize=1000000;var style='position:absolute;'+'left:0;'+'top:0;'+'right:0;'+'bottom:0;'+'overflow:hidden;'+'pointer-events:none;'+'visibility:hidden;'+'z-index:-1;';resizer.style.cssText=style;resizer.className=cls;resizer.innerHTML='<div class="'+cls+'-expand" style="'+style+'">'+'<div style="'+'position:absolute;'+'width:'+maxSize+'px;'+'height:'+maxSize+'px;'+'left:0;'+'top:0">'+'</div>'+'</div>'+'<div class="'+cls+'-shrink" style="'+style+'">'+'<div style="'+'position:absolute;'+'width:200%;'+'height:200%;'+'left:0; '+'top:0">'+'</div>'+'</div>';var expand=resizer.childNodes[0];var shrink=resizer.childNodes[1];resizer._reset=function(){expand.scrollLeft=maxSize;expand.scrollTop=maxSize;shrink.scrollLeft=maxSize;shrink.scrollTop=maxSize;};var onScroll=function(){resizer._reset();handler();};addEventListener(expand,'scroll',onScroll.bind(expand,'expand'));addEventListener(shrink,'scroll',onScroll.bind(shrink,'shrink'));return resizer;}
function watchForRender(node,handler){var expando=node[EXPANDO_KEY]||(node[EXPANDO_KEY]={});var proxy=expando.renderProxy=function(e){if(e.animationName===CSS_RENDER_ANIMATION){handler();}};helpers.each(ANIMATION_START_EVENTS,function(type){addEventListener(node,type,proxy);});expando.reflow=!!node.offsetParent;node.classList.add(CSS_RENDER_MONITOR);}
function unwatchForRender(node){var expando=node[EXPANDO_KEY]||{};var proxy=expando.renderProxy;if(proxy){helpers.each(ANIMATION_START_EVENTS,function(type){removeEventListener(node,type,proxy);});delete expando.renderProxy;}
node.classList.remove(CSS_RENDER_MONITOR);}
function addResizeListener(node,listener,chart){var expando=node[EXPANDO_KEY]||(node[EXPANDO_KEY]={});var resizer=expando.resizer=createResizer(throttled(function(){if(expando.resizer){return listener(createEvent('resize',chart));}}));watchForRender(node,function(){if(expando.resizer){var container=node.parentNode;if(container&&container!==resizer.parentNode){container.insertBefore(resizer,container.firstChild);}
resizer._reset();}});}
function removeResizeListener(node){var expando=node[EXPANDO_KEY]||{};var resizer=expando.resizer;delete expando.resizer;unwatchForRender(node);if(resizer&&resizer.parentNode){resizer.parentNode.removeChild(resizer);}}
function injectCSS(platform,css){var style=platform._style||document.createElement('style');if(!platform._style){platform._style=style;css='/* Chart.js */\n'+css;style.setAttribute('type','text/css');document.getElementsByTagName('head')[0].appendChild(style);}
style.appendChild(document.createTextNode(css));}
module.exports={_enabled:typeof window!=='undefined'&&typeof document!=='undefined',initialize:function(){var keyframes='from{opacity:0.99}to{opacity:1}';injectCSS(this,'@-webkit-keyframes '+CSS_RENDER_ANIMATION+'{'+keyframes+'}'+'@keyframes '+CSS_RENDER_ANIMATION+'{'+keyframes+'}'+'.'+CSS_RENDER_MONITOR+'{'+'-webkit-animation:'+CSS_RENDER_ANIMATION+' 0.001s;'+'animation:'+CSS_RENDER_ANIMATION+' 0.001s;'+'}');},acquireContext:function(item,config){if(typeof item==='string'){item=document.getElementById(item);}else if(item.length){item=item[0];}
if(item&&item.canvas){item=item.canvas;}
var context=item&&item.getContext&&item.getContext('2d');if(context&&context.canvas===item){initCanvas(item,config);return context;}
return null;},releaseContext:function(context){var canvas=context.canvas;if(!canvas[EXPANDO_KEY]){return;}
var initial=canvas[EXPANDO_KEY].initial;['height','width'].forEach(function(prop){var value=initial[prop];if(helpers.isNullOrUndef(value)){canvas.removeAttribute(prop);}else{canvas.setAttribute(prop,value);}});helpers.each(initial.style||{},function(value,key){canvas.style[key]=value;});canvas.width=canvas.width;delete canvas[EXPANDO_KEY];},addEventListener:function(chart,type,listener){var canvas=chart.canvas;if(type==='resize'){addResizeListener(canvas,listener,chart);return;}
var expando=listener[EXPANDO_KEY]||(listener[EXPANDO_KEY]={});var proxies=expando.proxies||(expando.proxies={});var proxy=proxies[chart.id+'_'+type]=function(event){listener(fromNativeEvent(event,chart));};addEventListener(canvas,type,proxy);},removeEventListener:function(chart,type,listener){var canvas=chart.canvas;if(type==='resize'){removeResizeListener(canvas,listener);return;}
var expando=listener[EXPANDO_KEY]||{};var proxies=expando.proxies||{};var proxy=proxies[chart.id+'_'+type];if(!proxy){return;}
removeEventListener(canvas,type,proxy);}};helpers.addEvent=addEventListener;helpers.removeEvent=removeEventListener;},{"45":45}],48:[function(require,module,exports){'use strict';var helpers=require(45);var basic=require(46);var dom=require(47);var implementation=dom._enabled?dom:basic;module.exports=helpers.extend({initialize:function(){},acquireContext:function(){},releaseContext:function(){},addEventListener:function(){},removeEventListener:function(){}},implementation);},{"45":45,"46":46,"47":47}],49:[function(require,module,exports){'use strict';module.exports={};module.exports.filler=require(50);module.exports.legend=require(51);module.exports.title=require(52);},{"50":50,"51":51,"52":52}],50:[function(require,module,exports){'use strict';var defaults=require(25);var elements=require(40);var helpers=require(45);defaults._set('global',{plugins:{filler:{propagate:true}}});var mappers={dataset:function(source){var index=source.fill;var chart=source.chart;var meta=chart.getDatasetMeta(index);var visible=meta&&chart.isDatasetVisible(index);var points=(visible&&meta.dataset._children)||[];var length=points.length||0;return!length?null:function(point,i){return(i<length&&points[i]._view)||null;};},boundary:function(source){var boundary=source.boundary;var x=boundary?boundary.x:null;var y=boundary?boundary.y:null;return function(point){return{x:x===null?point.x:x,y:y===null?point.y:y,};};}};function decodeFill(el,index,count){var model=el._model||{};var fill=model.fill;var target;if(fill===undefined){fill=!!model.backgroundColor;}
if(fill===false||fill===null){return false;}
if(fill===true){return'origin';}
target=parseFloat(fill,10);if(isFinite(target)&&Math.floor(target)===target){if(fill[0]==='-'||fill[0]==='+'){target=index+target;}
if(target===index||target<0||target>=count){return false;}
return target;}
switch(fill){case'bottom':return'start';case'top':return'end';case'zero':return'origin';case'origin':case'start':case'end':return fill;default:return false;}}
function computeBoundary(source){var model=source.el._model||{};var scale=source.el._scale||{};var fill=source.fill;var target=null;var horizontal;if(isFinite(fill)){return null;}
if(fill==='start'){target=model.scaleBottom===undefined?scale.bottom:model.scaleBottom;}else if(fill==='end'){target=model.scaleTop===undefined?scale.top:model.scaleTop;}else if(model.scaleZero!==undefined){target=model.scaleZero;}else if(scale.getBasePosition){target=scale.getBasePosition();}else if(scale.getBasePixel){target=scale.getBasePixel();}
if(target!==undefined&&target!==null){if(target.x!==undefined&&target.y!==undefined){return target;}
if(typeof target==='number'&&isFinite(target)){horizontal=scale.isHorizontal();return{x:horizontal?target:null,y:horizontal?null:target};}}
return null;}
function resolveTarget(sources,index,propagate){var source=sources[index];var fill=source.fill;var visited=[index];var target;if(!propagate){return fill;}
while(fill!==false&&visited.indexOf(fill)===-1){if(!isFinite(fill)){return fill;}
target=sources[fill];if(!target){return false;}
if(target.visible){return fill;}
visited.push(fill);fill=target.fill;}
return false;}
function createMapper(source){var fill=source.fill;var type='dataset';if(fill===false){return null;}
if(!isFinite(fill)){type='boundary';}
return mappers[type](source);}
function isDrawable(point){return point&&!point.skip;}
function drawArea(ctx,curve0,curve1,len0,len1){var i;if(!len0||!len1){return;}
ctx.moveTo(curve0[0].x,curve0[0].y);for(i=1;i<len0;++i){helpers.canvas.lineTo(ctx,curve0[i-1],curve0[i]);}
ctx.lineTo(curve1[len1-1].x,curve1[len1-1].y);for(i=len1-1;i>0;--i){helpers.canvas.lineTo(ctx,curve1[i],curve1[i-1],true);}}
function doFill(ctx,points,mapper,view,color,loop){var count=points.length;var span=view.spanGaps;var curve0=[];var curve1=[];var len0=0;var len1=0;var i,ilen,index,p0,p1,d0,d1;ctx.beginPath();for(i=0,ilen=(count+!!loop);i<ilen;++i){index=i%count;p0=points[index]._view;p1=mapper(p0,index,view);d0=isDrawable(p0);d1=isDrawable(p1);if(d0&&d1){len0=curve0.push(p0);len1=curve1.push(p1);}else if(len0&&len1){if(!span){drawArea(ctx,curve0,curve1,len0,len1);len0=len1=0;curve0=[];curve1=[];}else{if(d0){curve0.push(p0);}
if(d1){curve1.push(p1);}}}}
drawArea(ctx,curve0,curve1,len0,len1);ctx.closePath();ctx.fillStyle=color;ctx.fill();}
module.exports={id:'filler',afterDatasetsUpdate:function(chart,options){var count=(chart.data.datasets||[]).length;var propagate=options.propagate;var sources=[];var meta,i,el,source;for(i=0;i<count;++i){meta=chart.getDatasetMeta(i);el=meta.dataset;source=null;if(el&&el._model&&el instanceof elements.Line){source={visible:chart.isDatasetVisible(i),fill:decodeFill(el,i,count),chart:chart,el:el};}
meta.$filler=source;sources.push(source);}
for(i=0;i<count;++i){source=sources[i];if(!source){continue;}
source.fill=resolveTarget(sources,i,propagate);source.boundary=computeBoundary(source);source.mapper=createMapper(source);}},beforeDatasetDraw:function(chart,args){var meta=args.meta.$filler;if(!meta){return;}
var ctx=chart.ctx;var el=meta.el;var view=el._view;var points=el._children||[];var mapper=meta.mapper;var color=view.backgroundColor||defaults.global.defaultColor;if(mapper&&color&&points.length){helpers.canvas.clipArea(ctx,chart.chartArea);doFill(ctx,points,mapper,view,color,el._loop);helpers.canvas.unclipArea(ctx);}}};},{"25":25,"40":40,"45":45}],51:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);var helpers=require(45);var layouts=require(30);var noop=helpers.noop;defaults._set('global',{legend:{display:true,position:'top',fullWidth:true,reverse:false,weight:1000,onClick:function(e,legendItem){var index=legendItem.datasetIndex;var ci=this.chart;var meta=ci.getDatasetMeta(index);meta.hidden=meta.hidden===null?!ci.data.datasets[index].hidden:null;ci.update();},onHover:null,labels:{boxWidth:40,padding:10,generateLabels:function(chart){var data=chart.data;return helpers.isArray(data.datasets)?data.datasets.map(function(dataset,i){return{text:dataset.label,fillStyle:(!helpers.isArray(dataset.backgroundColor)?dataset.backgroundColor:dataset.backgroundColor[0]),hidden:!chart.isDatasetVisible(i),lineCap:dataset.borderCapStyle,lineDash:dataset.borderDash,lineDashOffset:dataset.borderDashOffset,lineJoin:dataset.borderJoinStyle,lineWidth:dataset.borderWidth,strokeStyle:dataset.borderColor,pointStyle:dataset.pointStyle,datasetIndex:i};},this):[];}}},legendCallback:function(chart){var text=[];text.push('<ul class="'+chart.id+'-legend">');for(var i=0;i<chart.data.datasets.length;i++){text.push('<li><span style="background-color:'+chart.data.datasets[i].backgroundColor+'"></span>');if(chart.data.datasets[i].label){text.push(chart.data.datasets[i].label);}
text.push('</li>');}
text.push('</ul>');return text.join('');}});function getBoxWidth(labelOpts,fontSize){return labelOpts.usePointStyle?fontSize*Math.SQRT2:labelOpts.boxWidth;}
var Legend=Element.extend({initialize:function(config){helpers.extend(this,config);this.legendHitBoxes=[];this.doughnutMode=false;},beforeUpdate:noop,update:function(maxWidth,maxHeight,margins){var me=this;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=margins;me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeBuildLabels();me.buildLabels();me.afterBuildLabels();me.beforeFit();me.fit();me.afterFit();me.afterUpdate();return me.minSize;},afterUpdate:noop,beforeSetDimensions:noop,setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width;}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height;}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0;me.minSize={width:0,height:0};},afterSetDimensions:noop,beforeBuildLabels:noop,buildLabels:function(){var me=this;var labelOpts=me.options.labels||{};var legendItems=helpers.callback(labelOpts.generateLabels,[me.chart],me)||[];if(labelOpts.filter){legendItems=legendItems.filter(function(item){return labelOpts.filter(item,me.chart.data);});}
if(me.options.reverse){legendItems.reverse();}
me.legendItems=legendItems;},afterBuildLabels:noop,beforeFit:noop,fit:function(){var me=this;var opts=me.options;var labelOpts=opts.labels;var display=opts.display;var ctx=me.ctx;var globalDefault=defaults.global;var valueOrDefault=helpers.valueOrDefault;var fontSize=valueOrDefault(labelOpts.fontSize,globalDefault.defaultFontSize);var fontStyle=valueOrDefault(labelOpts.fontStyle,globalDefault.defaultFontStyle);var fontFamily=valueOrDefault(labelOpts.fontFamily,globalDefault.defaultFontFamily);var labelFont=helpers.fontString(fontSize,fontStyle,fontFamily);var hitboxes=me.legendHitBoxes=[];var minSize=me.minSize;var isHorizontal=me.isHorizontal();if(isHorizontal){minSize.width=me.maxWidth;minSize.height=display?10:0;}else{minSize.width=display?10:0;minSize.height=me.maxHeight;}
if(display){ctx.font=labelFont;if(isHorizontal){var lineWidths=me.lineWidths=[0];var totalHeight=me.legendItems.length?fontSize+(labelOpts.padding):0;ctx.textAlign='left';ctx.textBaseline='top';helpers.each(me.legendItems,function(legendItem,i){var boxWidth=getBoxWidth(labelOpts,fontSize);var width=boxWidth+(fontSize/2)+ctx.measureText(legendItem.text).width;if(lineWidths[lineWidths.length-1]+width+labelOpts.padding>=me.width){totalHeight+=fontSize+(labelOpts.padding);lineWidths[lineWidths.length]=me.left;}
hitboxes[i]={left:0,top:0,width:width,height:fontSize};lineWidths[lineWidths.length-1]+=width+labelOpts.padding;});minSize.height+=totalHeight;}else{var vPadding=labelOpts.padding;var columnWidths=me.columnWidths=[];var totalWidth=labelOpts.padding;var currentColWidth=0;var currentColHeight=0;var itemHeight=fontSize+vPadding;helpers.each(me.legendItems,function(legendItem,i){var boxWidth=getBoxWidth(labelOpts,fontSize);var itemWidth=boxWidth+(fontSize/2)+ctx.measureText(legendItem.text).width;if(currentColHeight+itemHeight>minSize.height){totalWidth+=currentColWidth+labelOpts.padding;columnWidths.push(currentColWidth);currentColWidth=0;currentColHeight=0;}
currentColWidth=Math.max(currentColWidth,itemWidth);currentColHeight+=itemHeight;hitboxes[i]={left:0,top:0,width:itemWidth,height:fontSize};});totalWidth+=currentColWidth;columnWidths.push(currentColWidth);minSize.width+=totalWidth;}}
me.width=minSize.width;me.height=minSize.height;},afterFit:noop,isHorizontal:function(){return this.options.position==='top'||this.options.position==='bottom';},draw:function(){var me=this;var opts=me.options;var labelOpts=opts.labels;var globalDefault=defaults.global;var lineDefault=globalDefault.elements.line;var legendWidth=me.width;var lineWidths=me.lineWidths;if(opts.display){var ctx=me.ctx;var valueOrDefault=helpers.valueOrDefault;var fontColor=valueOrDefault(labelOpts.fontColor,globalDefault.defaultFontColor);var fontSize=valueOrDefault(labelOpts.fontSize,globalDefault.defaultFontSize);var fontStyle=valueOrDefault(labelOpts.fontStyle,globalDefault.defaultFontStyle);var fontFamily=valueOrDefault(labelOpts.fontFamily,globalDefault.defaultFontFamily);var labelFont=helpers.fontString(fontSize,fontStyle,fontFamily);var cursor;ctx.textAlign='left';ctx.textBaseline='middle';ctx.lineWidth=0.5;ctx.strokeStyle=fontColor;ctx.fillStyle=fontColor;ctx.font=labelFont;var boxWidth=getBoxWidth(labelOpts,fontSize);var hitboxes=me.legendHitBoxes;var drawLegendBox=function(x,y,legendItem){if(isNaN(boxWidth)||boxWidth<=0){return;}
ctx.save();ctx.fillStyle=valueOrDefault(legendItem.fillStyle,globalDefault.defaultColor);ctx.lineCap=valueOrDefault(legendItem.lineCap,lineDefault.borderCapStyle);ctx.lineDashOffset=valueOrDefault(legendItem.lineDashOffset,lineDefault.borderDashOffset);ctx.lineJoin=valueOrDefault(legendItem.lineJoin,lineDefault.borderJoinStyle);ctx.lineWidth=valueOrDefault(legendItem.lineWidth,lineDefault.borderWidth);ctx.strokeStyle=valueOrDefault(legendItem.strokeStyle,globalDefault.defaultColor);var isLineWidthZero=(valueOrDefault(legendItem.lineWidth,lineDefault.borderWidth)===0);if(ctx.setLineDash){ctx.setLineDash(valueOrDefault(legendItem.lineDash,lineDefault.borderDash));}
if(opts.labels&&opts.labels.usePointStyle){var radius=fontSize*Math.SQRT2/2;var offSet=radius/Math.SQRT2;var centerX=x+offSet;var centerY=y+offSet;helpers.canvas.drawPoint(ctx,legendItem.pointStyle,radius,centerX,centerY);}else{if(!isLineWidthZero){ctx.strokeRect(x,y,boxWidth,fontSize);}
ctx.fillRect(x,y,boxWidth,fontSize);}
ctx.restore();};var fillText=function(x,y,legendItem,textWidth){var halfFontSize=fontSize/2;var xLeft=boxWidth+halfFontSize+x;var yMiddle=y+halfFontSize;ctx.fillText(legendItem.text,xLeft,yMiddle);if(legendItem.hidden){ctx.beginPath();ctx.lineWidth=2;ctx.moveTo(xLeft,yMiddle);ctx.lineTo(xLeft+textWidth,yMiddle);ctx.stroke();}};var isHorizontal=me.isHorizontal();if(isHorizontal){cursor={x:me.left+((legendWidth-lineWidths[0])/2),y:me.top+labelOpts.padding,line:0};}else{cursor={x:me.left+labelOpts.padding,y:me.top+labelOpts.padding,line:0};}
var itemHeight=fontSize+labelOpts.padding;helpers.each(me.legendItems,function(legendItem,i){var textWidth=ctx.measureText(legendItem.text).width;var width=boxWidth+(fontSize/2)+textWidth;var x=cursor.x;var y=cursor.y;if(isHorizontal){if(x+width>=legendWidth){y=cursor.y+=itemHeight;cursor.line++;x=cursor.x=me.left+((legendWidth-lineWidths[cursor.line])/2);}}else if(y+itemHeight>me.bottom){x=cursor.x=x+me.columnWidths[cursor.line]+labelOpts.padding;y=cursor.y=me.top+labelOpts.padding;cursor.line++;}
drawLegendBox(x,y,legendItem);hitboxes[i].left=x;hitboxes[i].top=y;fillText(x,y,legendItem,textWidth);if(isHorizontal){cursor.x+=width+(labelOpts.padding);}else{cursor.y+=itemHeight;}});}},handleEvent:function(e){var me=this;var opts=me.options;var type=e.type==='mouseup'?'click':e.type;var changed=false;if(type==='mousemove'){if(!opts.onHover){return;}}else if(type==='click'){if(!opts.onClick){return;}}else{return;}
var x=e.x;var y=e.y;if(x>=me.left&&x<=me.right&&y>=me.top&&y<=me.bottom){var lh=me.legendHitBoxes;for(var i=0;i<lh.length;++i){var hitBox=lh[i];if(x>=hitBox.left&&x<=hitBox.left+hitBox.width&&y>=hitBox.top&&y<=hitBox.top+hitBox.height){if(type==='click'){opts.onClick.call(me,e.native,me.legendItems[i]);changed=true;break;}else if(type==='mousemove'){opts.onHover.call(me,e.native,me.legendItems[i]);changed=true;break;}}}}
return changed;}});function createNewLegendAndAttach(chart,legendOpts){var legend=new Legend({ctx:chart.ctx,options:legendOpts,chart:chart});layouts.configure(chart,legend,legendOpts);layouts.addBox(chart,legend);chart.legend=legend;}
module.exports={id:'legend',_element:Legend,beforeInit:function(chart){var legendOpts=chart.options.legend;if(legendOpts){createNewLegendAndAttach(chart,legendOpts);}},beforeUpdate:function(chart){var legendOpts=chart.options.legend;var legend=chart.legend;if(legendOpts){helpers.mergeIf(legendOpts,defaults.global.legend);if(legend){layouts.configure(chart,legend,legendOpts);legend.options=legendOpts;}else{createNewLegendAndAttach(chart,legendOpts);}}else if(legend){layouts.removeBox(chart,legend);delete chart.legend;}},afterEvent:function(chart,e){var legend=chart.legend;if(legend){legend.handleEvent(e);}}};},{"25":25,"26":26,"30":30,"45":45}],52:[function(require,module,exports){'use strict';var defaults=require(25);var Element=require(26);var helpers=require(45);var layouts=require(30);var noop=helpers.noop;defaults._set('global',{title:{display:false,fontStyle:'bold',fullWidth:true,lineHeight:1.2,padding:10,position:'top',text:'',weight:2000}});var Title=Element.extend({initialize:function(config){var me=this;helpers.extend(me,config);me.legendHitBoxes=[];},beforeUpdate:noop,update:function(maxWidth,maxHeight,margins){var me=this;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=margins;me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeBuildLabels();me.buildLabels();me.afterBuildLabels();me.beforeFit();me.fit();me.afterFit();me.afterUpdate();return me.minSize;},afterUpdate:noop,beforeSetDimensions:noop,setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width;}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height;}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0;me.minSize={width:0,height:0};},afterSetDimensions:noop,beforeBuildLabels:noop,buildLabels:noop,afterBuildLabels:noop,beforeFit:noop,fit:function(){var me=this;var valueOrDefault=helpers.valueOrDefault;var opts=me.options;var display=opts.display;var fontSize=valueOrDefault(opts.fontSize,defaults.global.defaultFontSize);var minSize=me.minSize;var lineCount=helpers.isArray(opts.text)?opts.text.length:1;var lineHeight=helpers.options.toLineHeight(opts.lineHeight,fontSize);var textSize=display?(lineCount*lineHeight)+(opts.padding*2):0;if(me.isHorizontal()){minSize.width=me.maxWidth;minSize.height=textSize;}else{minSize.width=textSize;minSize.height=me.maxHeight;}
me.width=minSize.width;me.height=minSize.height;},afterFit:noop,isHorizontal:function(){var pos=this.options.position;return pos==='top'||pos==='bottom';},draw:function(){var me=this;var ctx=me.ctx;var valueOrDefault=helpers.valueOrDefault;var opts=me.options;var globalDefaults=defaults.global;if(opts.display){var fontSize=valueOrDefault(opts.fontSize,globalDefaults.defaultFontSize);var fontStyle=valueOrDefault(opts.fontStyle,globalDefaults.defaultFontStyle);var fontFamily=valueOrDefault(opts.fontFamily,globalDefaults.defaultFontFamily);var titleFont=helpers.fontString(fontSize,fontStyle,fontFamily);var lineHeight=helpers.options.toLineHeight(opts.lineHeight,fontSize);var offset=lineHeight/2+opts.padding;var rotation=0;var top=me.top;var left=me.left;var bottom=me.bottom;var right=me.right;var maxWidth,titleX,titleY;ctx.fillStyle=valueOrDefault(opts.fontColor,globalDefaults.defaultFontColor);ctx.font=titleFont;if(me.isHorizontal()){titleX=left+((right-left)/2);titleY=top+offset;maxWidth=right-left;}else{titleX=opts.position==='left'?left+offset:right-offset;titleY=top+((bottom-top)/2);maxWidth=bottom-top;rotation=Math.PI*(opts.position==='left'?-0.5:0.5);}
ctx.save();ctx.translate(titleX,titleY);ctx.rotate(rotation);ctx.textAlign='center';ctx.textBaseline='middle';var text=opts.text;if(helpers.isArray(text)){var y=0;for(var i=0;i<text.length;++i){ctx.fillText(text[i],0,y,maxWidth);y+=lineHeight;}}else{ctx.fillText(text,0,0,maxWidth);}
ctx.restore();}}});function createNewTitleBlockAndAttach(chart,titleOpts){var title=new Title({ctx:chart.ctx,options:titleOpts,chart:chart});layouts.configure(chart,title,titleOpts);layouts.addBox(chart,title);chart.titleBlock=title;}
module.exports={id:'title',_element:Title,beforeInit:function(chart){var titleOpts=chart.options.title;if(titleOpts){createNewTitleBlockAndAttach(chart,titleOpts);}},beforeUpdate:function(chart){var titleOpts=chart.options.title;var titleBlock=chart.titleBlock;if(titleOpts){helpers.mergeIf(titleOpts,defaults.global.title);if(titleBlock){layouts.configure(chart,titleBlock,titleOpts);titleBlock.options=titleOpts;}else{createNewTitleBlockAndAttach(chart,titleOpts);}}else if(titleBlock){layouts.removeBox(chart,titleBlock);delete chart.titleBlock;}}};},{"25":25,"26":26,"30":30,"45":45}],53:[function(require,module,exports){'use strict';module.exports=function(Chart){var defaultConfig={position:'bottom'};var DatasetScale=Chart.Scale.extend({getLabels:function(){var data=this.chart.data;return this.options.labels||(this.isHorizontal()?data.xLabels:data.yLabels)||data.labels;},determineDataLimits:function(){var me=this;var labels=me.getLabels();me.minIndex=0;me.maxIndex=labels.length-1;var findIndex;if(me.options.ticks.min!==undefined){findIndex=labels.indexOf(me.options.ticks.min);me.minIndex=findIndex!==-1?findIndex:me.minIndex;}
if(me.options.ticks.max!==undefined){findIndex=labels.indexOf(me.options.ticks.max);me.maxIndex=findIndex!==-1?findIndex:me.maxIndex;}
me.min=labels[me.minIndex];me.max=labels[me.maxIndex];},buildTicks:function(){var me=this;var labels=me.getLabels();me.ticks=(me.minIndex===0&&me.maxIndex===labels.length-1)?labels:labels.slice(me.minIndex,me.maxIndex+1);},getLabelForIndex:function(index,datasetIndex){var me=this;var data=me.chart.data;var isHorizontal=me.isHorizontal();if(data.yLabels&&!isHorizontal){return me.getRightValue(data.datasets[datasetIndex].data[index]);}
return me.ticks[index-me.minIndex];},getPixelForValue:function(value,index){var me=this;var offset=me.options.offset;var offsetAmt=Math.max((me.maxIndex+1-me.minIndex-(offset?0:1)),1);var valueCategory;if(value!==undefined&&value!==null){valueCategory=me.isHorizontal()?value.x:value.y;}
if(valueCategory!==undefined||(value!==undefined&&isNaN(index))){var labels=me.getLabels();value=valueCategory||value;var idx=labels.indexOf(value);index=idx!==-1?idx:index;}
if(me.isHorizontal()){var valueWidth=me.width/offsetAmt;var widthOffset=(valueWidth*(index-me.minIndex));if(offset){widthOffset+=(valueWidth/2);}
return me.left+Math.round(widthOffset);}
var valueHeight=me.height/offsetAmt;var heightOffset=(valueHeight*(index-me.minIndex));if(offset){heightOffset+=(valueHeight/2);}
return me.top+Math.round(heightOffset);},getPixelForTick:function(index){return this.getPixelForValue(this.ticks[index],index+this.minIndex,null);},getValueForPixel:function(pixel){var me=this;var offset=me.options.offset;var value;var offsetAmt=Math.max((me._ticks.length-(offset?0:1)),1);var horz=me.isHorizontal();var valueDimension=(horz?me.width:me.height)/offsetAmt;pixel-=horz?me.left:me.top;if(offset){pixel-=(valueDimension/2);}
if(pixel<=0){value=0;}else{value=Math.round(pixel/valueDimension);}
return value+me.minIndex;},getBasePixel:function(){return this.bottom;}});Chart.scaleService.registerScaleType('category',DatasetScale,defaultConfig);};},{}],54:[function(require,module,exports){'use strict';var defaults=require(25);var helpers=require(45);var Ticks=require(34);module.exports=function(Chart){var defaultConfig={position:'left',ticks:{callback:Ticks.formatters.linear}};var LinearScale=Chart.LinearScaleBase.extend({determineDataLimits:function(){var me=this;var opts=me.options;var chart=me.chart;var data=chart.data;var datasets=data.datasets;var isHorizontal=me.isHorizontal();var DEFAULT_MIN=0;var DEFAULT_MAX=1;function IDMatches(meta){return isHorizontal?meta.xAxisID===me.id:meta.yAxisID===me.id;}
me.min=null;me.max=null;var hasStacks=opts.stacked;if(hasStacks===undefined){helpers.each(datasets,function(dataset,datasetIndex){if(hasStacks){return;}
var meta=chart.getDatasetMeta(datasetIndex);if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)&&meta.stack!==undefined){hasStacks=true;}});}
if(opts.stacked||hasStacks){var valuesPerStack={};helpers.each(datasets,function(dataset,datasetIndex){var meta=chart.getDatasetMeta(datasetIndex);var key=[meta.type,((opts.stacked===undefined&&meta.stack===undefined)?datasetIndex:''),meta.stack].join('.');if(valuesPerStack[key]===undefined){valuesPerStack[key]={positiveValues:[],negativeValues:[]};}
var positiveValues=valuesPerStack[key].positiveValues;var negativeValues=valuesPerStack[key].negativeValues;if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)){helpers.each(dataset.data,function(rawValue,index){var value=+me.getRightValue(rawValue);if(isNaN(value)||meta.data[index].hidden){return;}
positiveValues[index]=positiveValues[index]||0;negativeValues[index]=negativeValues[index]||0;if(opts.relativePoints){positiveValues[index]=100;}else if(value<0){negativeValues[index]+=value;}else{positiveValues[index]+=value;}});}});helpers.each(valuesPerStack,function(valuesForType){var values=valuesForType.positiveValues.concat(valuesForType.negativeValues);var minVal=helpers.min(values);var maxVal=helpers.max(values);me.min=me.min===null?minVal:Math.min(me.min,minVal);me.max=me.max===null?maxVal:Math.max(me.max,maxVal);});}else{helpers.each(datasets,function(dataset,datasetIndex){var meta=chart.getDatasetMeta(datasetIndex);if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)){helpers.each(dataset.data,function(rawValue,index){var value=+me.getRightValue(rawValue);if(isNaN(value)||meta.data[index].hidden){return;}
if(me.min===null){me.min=value;}else if(value<me.min){me.min=value;}
if(me.max===null){me.max=value;}else if(value>me.max){me.max=value;}});}});}
me.min=isFinite(me.min)&&!isNaN(me.min)?me.min:DEFAULT_MIN;me.max=isFinite(me.max)&&!isNaN(me.max)?me.max:DEFAULT_MAX;this.handleTickRangeOptions();},getTickLimit:function(){var maxTicks;var me=this;var tickOpts=me.options.ticks;if(me.isHorizontal()){maxTicks=Math.min(tickOpts.maxTicksLimit?tickOpts.maxTicksLimit:11,Math.ceil(me.width/50));}else{var tickFontSize=helpers.valueOrDefault(tickOpts.fontSize,defaults.global.defaultFontSize);maxTicks=Math.min(tickOpts.maxTicksLimit?tickOpts.maxTicksLimit:11,Math.ceil(me.height/(2*tickFontSize)));}
return maxTicks;},handleDirectionalChanges:function(){if(!this.isHorizontal()){this.ticks.reverse();}},getLabelForIndex:function(index,datasetIndex){return+this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);},getPixelForValue:function(value){var me=this;var start=me.start;var rightValue=+me.getRightValue(value);var pixel;var range=me.end-start;if(me.isHorizontal()){pixel=me.left+(me.width/range*(rightValue-start));}else{pixel=me.bottom-(me.height/range*(rightValue-start));}
return pixel;},getValueForPixel:function(pixel){var me=this;var isHorizontal=me.isHorizontal();var innerDimension=isHorizontal?me.width:me.height;var offset=(isHorizontal?pixel-me.left:me.bottom-pixel)/innerDimension;return me.start+((me.end-me.start)*offset);},getPixelForTick:function(index){return this.getPixelForValue(this.ticksAsNumbers[index]);}});Chart.scaleService.registerScaleType('linear',LinearScale,defaultConfig);};},{"25":25,"34":34,"45":45}],55:[function(require,module,exports){'use strict';var helpers=require(45);function generateTicks(generationOptions,dataRange){var ticks=[];var spacing;if(generationOptions.stepSize&&generationOptions.stepSize>0){spacing=generationOptions.stepSize;}else{var niceRange=helpers.niceNum(dataRange.max-dataRange.min,false);spacing=helpers.niceNum(niceRange/(generationOptions.maxTicks-1),true);}
var niceMin=Math.floor(dataRange.min/spacing)*spacing;var niceMax=Math.ceil(dataRange.max/spacing)*spacing;if(generationOptions.min&&generationOptions.max&&generationOptions.stepSize){if(helpers.almostWhole((generationOptions.max-generationOptions.min)/generationOptions.stepSize,spacing/1000)){niceMin=generationOptions.min;niceMax=generationOptions.max;}}
var numSpaces=(niceMax-niceMin)/spacing;if(helpers.almostEquals(numSpaces,Math.round(numSpaces),spacing/1000)){numSpaces=Math.round(numSpaces);}else{numSpaces=Math.ceil(numSpaces);}
var precision=1;if(spacing<1){precision=Math.pow(10,spacing.toString().length-2);niceMin=Math.round(niceMin*precision)/precision;niceMax=Math.round(niceMax*precision)/precision;}
ticks.push(generationOptions.min!==undefined?generationOptions.min:niceMin);for(var j=1;j<numSpaces;++j){ticks.push(Math.round((niceMin+j*spacing)*precision)/precision);}
ticks.push(generationOptions.max!==undefined?generationOptions.max:niceMax);return ticks;}
module.exports=function(Chart){var noop=helpers.noop;Chart.LinearScaleBase=Chart.Scale.extend({getRightValue:function(value){if(typeof value==='string'){return+value;}
return Chart.Scale.prototype.getRightValue.call(this,value);},handleTickRangeOptions:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;if(tickOpts.beginAtZero){var minSign=helpers.sign(me.min);var maxSign=helpers.sign(me.max);if(minSign<0&&maxSign<0){me.max=0;}else if(minSign>0&&maxSign>0){me.min=0;}}
var setMin=tickOpts.min!==undefined||tickOpts.suggestedMin!==undefined;var setMax=tickOpts.max!==undefined||tickOpts.suggestedMax!==undefined;if(tickOpts.min!==undefined){me.min=tickOpts.min;}else if(tickOpts.suggestedMin!==undefined){if(me.min===null){me.min=tickOpts.suggestedMin;}else{me.min=Math.min(me.min,tickOpts.suggestedMin);}}
if(tickOpts.max!==undefined){me.max=tickOpts.max;}else if(tickOpts.suggestedMax!==undefined){if(me.max===null){me.max=tickOpts.suggestedMax;}else{me.max=Math.max(me.max,tickOpts.suggestedMax);}}
if(setMin!==setMax){if(me.min>=me.max){if(setMin){me.max=me.min+1;}else{me.min=me.max-1;}}}
if(me.min===me.max){me.max++;if(!tickOpts.beginAtZero){me.min--;}}},getTickLimit:noop,handleDirectionalChanges:noop,buildTicks:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;var maxTicks=me.getTickLimit();maxTicks=Math.max(2,maxTicks);var numericGeneratorOptions={maxTicks:maxTicks,min:tickOpts.min,max:tickOpts.max,stepSize:helpers.valueOrDefault(tickOpts.fixedStepSize,tickOpts.stepSize)};var ticks=me.ticks=generateTicks(numericGeneratorOptions,me);me.handleDirectionalChanges();me.max=helpers.max(ticks);me.min=helpers.min(ticks);if(tickOpts.reverse){ticks.reverse();me.start=me.max;me.end=me.min;}else{me.start=me.min;me.end=me.max;}},convertTicksToLabels:function(){var me=this;me.ticksAsNumbers=me.ticks.slice();me.zeroLineIndex=me.ticks.indexOf(0);Chart.Scale.prototype.convertTicksToLabels.call(me);}});};},{"45":45}],56:[function(require,module,exports){'use strict';var helpers=require(45);var Ticks=require(34);function generateTicks(generationOptions,dataRange){var ticks=[];var valueOrDefault=helpers.valueOrDefault;var tickVal=valueOrDefault(generationOptions.min,Math.pow(10,Math.floor(helpers.log10(dataRange.min))));var endExp=Math.floor(helpers.log10(dataRange.max));var endSignificand=Math.ceil(dataRange.max/Math.pow(10,endExp));var exp,significand;if(tickVal===0){exp=Math.floor(helpers.log10(dataRange.minNotZero));significand=Math.floor(dataRange.minNotZero/Math.pow(10,exp));ticks.push(tickVal);tickVal=significand*Math.pow(10,exp);}else{exp=Math.floor(helpers.log10(tickVal));significand=Math.floor(tickVal/Math.pow(10,exp));}
var precision=exp<0?Math.pow(10,Math.abs(exp)):1;do{ticks.push(tickVal);++significand;if(significand===10){significand=1;++exp;precision=exp>=0?1:precision;}
tickVal=Math.round(significand*Math.pow(10,exp)*precision)/precision;}while(exp<endExp||(exp===endExp&&significand<endSignificand));var lastTick=valueOrDefault(generationOptions.max,tickVal);ticks.push(lastTick);return ticks;}
module.exports=function(Chart){var defaultConfig={position:'left',ticks:{callback:Ticks.formatters.logarithmic}};var LogarithmicScale=Chart.Scale.extend({determineDataLimits:function(){var me=this;var opts=me.options;var chart=me.chart;var data=chart.data;var datasets=data.datasets;var isHorizontal=me.isHorizontal();function IDMatches(meta){return isHorizontal?meta.xAxisID===me.id:meta.yAxisID===me.id;}
me.min=null;me.max=null;me.minNotZero=null;var hasStacks=opts.stacked;if(hasStacks===undefined){helpers.each(datasets,function(dataset,datasetIndex){if(hasStacks){return;}
var meta=chart.getDatasetMeta(datasetIndex);if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)&&meta.stack!==undefined){hasStacks=true;}});}
if(opts.stacked||hasStacks){var valuesPerStack={};helpers.each(datasets,function(dataset,datasetIndex){var meta=chart.getDatasetMeta(datasetIndex);var key=[meta.type,((opts.stacked===undefined&&meta.stack===undefined)?datasetIndex:''),meta.stack].join('.');if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)){if(valuesPerStack[key]===undefined){valuesPerStack[key]=[];}
helpers.each(dataset.data,function(rawValue,index){var values=valuesPerStack[key];var value=+me.getRightValue(rawValue);if(isNaN(value)||meta.data[index].hidden||value<0){return;}
values[index]=values[index]||0;values[index]+=value;});}});helpers.each(valuesPerStack,function(valuesForType){if(valuesForType.length>0){var minVal=helpers.min(valuesForType);var maxVal=helpers.max(valuesForType);me.min=me.min===null?minVal:Math.min(me.min,minVal);me.max=me.max===null?maxVal:Math.max(me.max,maxVal);}});}else{helpers.each(datasets,function(dataset,datasetIndex){var meta=chart.getDatasetMeta(datasetIndex);if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)){helpers.each(dataset.data,function(rawValue,index){var value=+me.getRightValue(rawValue);if(isNaN(value)||meta.data[index].hidden||value<0){return;}
if(me.min===null){me.min=value;}else if(value<me.min){me.min=value;}
if(me.max===null){me.max=value;}else if(value>me.max){me.max=value;}
if(value!==0&&(me.minNotZero===null||value<me.minNotZero)){me.minNotZero=value;}});}});}
this.handleTickRangeOptions();},handleTickRangeOptions:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;var valueOrDefault=helpers.valueOrDefault;var DEFAULT_MIN=1;var DEFAULT_MAX=10;me.min=valueOrDefault(tickOpts.min,me.min);me.max=valueOrDefault(tickOpts.max,me.max);if(me.min===me.max){if(me.min!==0&&me.min!==null){me.min=Math.pow(10,Math.floor(helpers.log10(me.min))-1);me.max=Math.pow(10,Math.floor(helpers.log10(me.max))+1);}else{me.min=DEFAULT_MIN;me.max=DEFAULT_MAX;}}
if(me.min===null){me.min=Math.pow(10,Math.floor(helpers.log10(me.max))-1);}
if(me.max===null){me.max=me.min!==0?Math.pow(10,Math.floor(helpers.log10(me.min))+1):DEFAULT_MAX;}
if(me.minNotZero===null){if(me.min>0){me.minNotZero=me.min;}else if(me.max<1){me.minNotZero=Math.pow(10,Math.floor(helpers.log10(me.max)));}else{me.minNotZero=DEFAULT_MIN;}}},buildTicks:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;var reverse=!me.isHorizontal();var generationOptions={min:tickOpts.min,max:tickOpts.max};var ticks=me.ticks=generateTicks(generationOptions,me);me.max=helpers.max(ticks);me.min=helpers.min(ticks);if(tickOpts.reverse){reverse=!reverse;me.start=me.max;me.end=me.min;}else{me.start=me.min;me.end=me.max;}
if(reverse){ticks.reverse();}},convertTicksToLabels:function(){this.tickValues=this.ticks.slice();Chart.Scale.prototype.convertTicksToLabels.call(this);},getLabelForIndex:function(index,datasetIndex){return+this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);},getPixelForTick:function(index){return this.getPixelForValue(this.tickValues[index]);},_getFirstTickValue:function(value){var exp=Math.floor(helpers.log10(value));var significand=Math.floor(value/Math.pow(10,exp));return significand*Math.pow(10,exp);},getPixelForValue:function(value){var me=this;var reverse=me.options.ticks.reverse;var log10=helpers.log10;var firstTickValue=me._getFirstTickValue(me.minNotZero);var offset=0;var innerDimension,pixel,start,end,sign;value=+me.getRightValue(value);if(reverse){start=me.end;end=me.start;sign=-1;}else{start=me.start;end=me.end;sign=1;}
if(me.isHorizontal()){innerDimension=me.width;pixel=reverse?me.right:me.left;}else{innerDimension=me.height;sign*=-1;pixel=reverse?me.top:me.bottom;}
if(value!==start){if(start===0){offset=helpers.getValueOrDefault(me.options.ticks.fontSize,Chart.defaults.global.defaultFontSize);innerDimension-=offset;start=firstTickValue;}
if(value!==0){offset+=innerDimension/(log10(end)-log10(start))*(log10(value)-log10(start));}
pixel+=sign*offset;}
return pixel;},getValueForPixel:function(pixel){var me=this;var reverse=me.options.ticks.reverse;var log10=helpers.log10;var firstTickValue=me._getFirstTickValue(me.minNotZero);var innerDimension,start,end,value;if(reverse){start=me.end;end=me.start;}else{start=me.start;end=me.end;}
if(me.isHorizontal()){innerDimension=me.width;value=reverse?me.right-pixel:pixel-me.left;}else{innerDimension=me.height;value=reverse?pixel-me.top:me.bottom-pixel;}
if(value!==start){if(start===0){var offset=helpers.getValueOrDefault(me.options.ticks.fontSize,Chart.defaults.global.defaultFontSize);value-=offset;innerDimension-=offset;start=firstTickValue;}
value*=log10(end)-log10(start);value/=innerDimension;value=Math.pow(10,log10(start)+value);}
return value;}});Chart.scaleService.registerScaleType('logarithmic',LogarithmicScale,defaultConfig);};},{"34":34,"45":45}],57:[function(require,module,exports){'use strict';var defaults=require(25);var helpers=require(45);var Ticks=require(34);module.exports=function(Chart){var globalDefaults=defaults.global;var defaultConfig={display:true,animate:true,position:'chartArea',angleLines:{display:true,color:'rgba(0, 0, 0, 0.1)',lineWidth:1},gridLines:{circular:false},ticks:{showLabelBackdrop:true,backdropColor:'rgba(255,255,255,0.75)',backdropPaddingY:2,backdropPaddingX:2,callback:Ticks.formatters.linear},pointLabels:{display:true,fontSize:10,callback:function(label){return label;}}};function getValueCount(scale){var opts=scale.options;return opts.angleLines.display||opts.pointLabels.display?scale.chart.data.labels.length:0;}
function getPointLabelFontOptions(scale){var pointLabelOptions=scale.options.pointLabels;var fontSize=helpers.valueOrDefault(pointLabelOptions.fontSize,globalDefaults.defaultFontSize);var fontStyle=helpers.valueOrDefault(pointLabelOptions.fontStyle,globalDefaults.defaultFontStyle);var fontFamily=helpers.valueOrDefault(pointLabelOptions.fontFamily,globalDefaults.defaultFontFamily);var font=helpers.fontString(fontSize,fontStyle,fontFamily);return{size:fontSize,style:fontStyle,family:fontFamily,font:font};}
function measureLabelSize(ctx,fontSize,label){if(helpers.isArray(label)){return{w:helpers.longestText(ctx,ctx.font,label),h:(label.length*fontSize)+((label.length-1)*1.5*fontSize)};}
return{w:ctx.measureText(label).width,h:fontSize};}
function determineLimits(angle,pos,size,min,max){if(angle===min||angle===max){return{start:pos-(size/2),end:pos+(size/2)};}else if(angle<min||angle>max){return{start:pos-size-5,end:pos};}
return{start:pos,end:pos+size+5};}
function fitWithPointLabels(scale){var plFont=getPointLabelFontOptions(scale);var largestPossibleRadius=Math.min(scale.height/2,scale.width/2);var furthestLimits={r:scale.width,l:0,t:scale.height,b:0};var furthestAngles={};var i,textSize,pointPosition;scale.ctx.font=plFont.font;scale._pointLabelSizes=[];var valueCount=getValueCount(scale);for(i=0;i<valueCount;i++){pointPosition=scale.getPointPosition(i,largestPossibleRadius);textSize=measureLabelSize(scale.ctx,plFont.size,scale.pointLabels[i]||'');scale._pointLabelSizes[i]=textSize;var angleRadians=scale.getIndexAngle(i);var angle=helpers.toDegrees(angleRadians)%360;var hLimits=determineLimits(angle,pointPosition.x,textSize.w,0,180);var vLimits=determineLimits(angle,pointPosition.y,textSize.h,90,270);if(hLimits.start<furthestLimits.l){furthestLimits.l=hLimits.start;furthestAngles.l=angleRadians;}
if(hLimits.end>furthestLimits.r){furthestLimits.r=hLimits.end;furthestAngles.r=angleRadians;}
if(vLimits.start<furthestLimits.t){furthestLimits.t=vLimits.start;furthestAngles.t=angleRadians;}
if(vLimits.end>furthestLimits.b){furthestLimits.b=vLimits.end;furthestAngles.b=angleRadians;}}
scale.setReductions(largestPossibleRadius,furthestLimits,furthestAngles);}
function fit(scale){var largestPossibleRadius=Math.min(scale.height/2,scale.width/2);scale.drawingArea=Math.round(largestPossibleRadius);scale.setCenterPoint(0,0,0,0);}
function getTextAlignForAngle(angle){if(angle===0||angle===180){return'center';}else if(angle<180){return'left';}
return'right';}
function fillText(ctx,text,position,fontSize){if(helpers.isArray(text)){var y=position.y;var spacing=1.5*fontSize;for(var i=0;i<text.length;++i){ctx.fillText(text[i],position.x,y);y+=spacing;}}else{ctx.fillText(text,position.x,position.y);}}
function adjustPointPositionForLabelHeight(angle,textSize,position){if(angle===90||angle===270){position.y-=(textSize.h/2);}else if(angle>270||angle<90){position.y-=textSize.h;}}
function drawPointLabels(scale){var ctx=scale.ctx;var opts=scale.options;var angleLineOpts=opts.angleLines;var pointLabelOpts=opts.pointLabels;ctx.lineWidth=angleLineOpts.lineWidth;ctx.strokeStyle=angleLineOpts.color;var outerDistance=scale.getDistanceFromCenterForValue(opts.ticks.reverse?scale.min:scale.max);var plFont=getPointLabelFontOptions(scale);ctx.textBaseline='top';for(var i=getValueCount(scale)-1;i>=0;i--){if(angleLineOpts.display){var outerPosition=scale.getPointPosition(i,outerDistance);ctx.beginPath();ctx.moveTo(scale.xCenter,scale.yCenter);ctx.lineTo(outerPosition.x,outerPosition.y);ctx.stroke();ctx.closePath();}
if(pointLabelOpts.display){var pointLabelPosition=scale.getPointPosition(i,outerDistance+5);var pointLabelFontColor=helpers.valueAtIndexOrDefault(pointLabelOpts.fontColor,i,globalDefaults.defaultFontColor);ctx.font=plFont.font;ctx.fillStyle=pointLabelFontColor;var angleRadians=scale.getIndexAngle(i);var angle=helpers.toDegrees(angleRadians);ctx.textAlign=getTextAlignForAngle(angle);adjustPointPositionForLabelHeight(angle,scale._pointLabelSizes[i],pointLabelPosition);fillText(ctx,scale.pointLabels[i]||'',pointLabelPosition,plFont.size);}}}
function drawRadiusLine(scale,gridLineOpts,radius,index){var ctx=scale.ctx;ctx.strokeStyle=helpers.valueAtIndexOrDefault(gridLineOpts.color,index-1);ctx.lineWidth=helpers.valueAtIndexOrDefault(gridLineOpts.lineWidth,index-1);if(scale.options.gridLines.circular){ctx.beginPath();ctx.arc(scale.xCenter,scale.yCenter,radius,0,Math.PI*2);ctx.closePath();ctx.stroke();}else{var valueCount=getValueCount(scale);if(valueCount===0){return;}
ctx.beginPath();var pointPosition=scale.getPointPosition(0,radius);ctx.moveTo(pointPosition.x,pointPosition.y);for(var i=1;i<valueCount;i++){pointPosition=scale.getPointPosition(i,radius);ctx.lineTo(pointPosition.x,pointPosition.y);}
ctx.closePath();ctx.stroke();}}
function numberOrZero(param){return helpers.isNumber(param)?param:0;}
var LinearRadialScale=Chart.LinearScaleBase.extend({setDimensions:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;me.width=me.maxWidth;me.height=me.maxHeight;me.xCenter=Math.round(me.width/2);me.yCenter=Math.round(me.height/2);var minSize=helpers.min([me.height,me.width]);var tickFontSize=helpers.valueOrDefault(tickOpts.fontSize,globalDefaults.defaultFontSize);me.drawingArea=opts.display?(minSize/2)-(tickFontSize/2+tickOpts.backdropPaddingY):(minSize/2);},determineDataLimits:function(){var me=this;var chart=me.chart;var min=Number.POSITIVE_INFINITY;var max=Number.NEGATIVE_INFINITY;helpers.each(chart.data.datasets,function(dataset,datasetIndex){if(chart.isDatasetVisible(datasetIndex)){var meta=chart.getDatasetMeta(datasetIndex);helpers.each(dataset.data,function(rawValue,index){var value=+me.getRightValue(rawValue);if(isNaN(value)||meta.data[index].hidden){return;}
min=Math.min(value,min);max=Math.max(value,max);});}});me.min=(min===Number.POSITIVE_INFINITY?0:min);me.max=(max===Number.NEGATIVE_INFINITY?0:max);me.handleTickRangeOptions();},getTickLimit:function(){var tickOpts=this.options.ticks;var tickFontSize=helpers.valueOrDefault(tickOpts.fontSize,globalDefaults.defaultFontSize);return Math.min(tickOpts.maxTicksLimit?tickOpts.maxTicksLimit:11,Math.ceil(this.drawingArea/(1.5*tickFontSize)));},convertTicksToLabels:function(){var me=this;Chart.LinearScaleBase.prototype.convertTicksToLabels.call(me);me.pointLabels=me.chart.data.labels.map(me.options.pointLabels.callback,me);},getLabelForIndex:function(index,datasetIndex){return+this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);},fit:function(){if(this.options.pointLabels.display){fitWithPointLabels(this);}else{fit(this);}},setReductions:function(largestPossibleRadius,furthestLimits,furthestAngles){var me=this;var radiusReductionLeft=furthestLimits.l/Math.sin(furthestAngles.l);var radiusReductionRight=Math.max(furthestLimits.r-me.width,0)/Math.sin(furthestAngles.r);var radiusReductionTop=-furthestLimits.t/Math.cos(furthestAngles.t);var radiusReductionBottom=-Math.max(furthestLimits.b-me.height,0)/Math.cos(furthestAngles.b);radiusReductionLeft=numberOrZero(radiusReductionLeft);radiusReductionRight=numberOrZero(radiusReductionRight);radiusReductionTop=numberOrZero(radiusReductionTop);radiusReductionBottom=numberOrZero(radiusReductionBottom);me.drawingArea=Math.min(Math.round(largestPossibleRadius-(radiusReductionLeft+radiusReductionRight)/2),Math.round(largestPossibleRadius-(radiusReductionTop+radiusReductionBottom)/2));me.setCenterPoint(radiusReductionLeft,radiusReductionRight,radiusReductionTop,radiusReductionBottom);},setCenterPoint:function(leftMovement,rightMovement,topMovement,bottomMovement){var me=this;var maxRight=me.width-rightMovement-me.drawingArea;var maxLeft=leftMovement+me.drawingArea;var maxTop=topMovement+me.drawingArea;var maxBottom=me.height-bottomMovement-me.drawingArea;me.xCenter=Math.round(((maxLeft+maxRight)/2)+me.left);me.yCenter=Math.round(((maxTop+maxBottom)/2)+me.top);},getIndexAngle:function(index){var angleMultiplier=(Math.PI*2)/getValueCount(this);var startAngle=this.chart.options&&this.chart.options.startAngle?this.chart.options.startAngle:0;var startAngleRadians=startAngle*Math.PI*2/360;return index*angleMultiplier+startAngleRadians;},getDistanceFromCenterForValue:function(value){var me=this;if(value===null){return 0;}
var scalingFactor=me.drawingArea/(me.max-me.min);if(me.options.ticks.reverse){return(me.max-value)*scalingFactor;}
return(value-me.min)*scalingFactor;},getPointPosition:function(index,distanceFromCenter){var me=this;var thisAngle=me.getIndexAngle(index)-(Math.PI/2);return{x:Math.round(Math.cos(thisAngle)*distanceFromCenter)+me.xCenter,y:Math.round(Math.sin(thisAngle)*distanceFromCenter)+me.yCenter};},getPointPositionForValue:function(index,value){return this.getPointPosition(index,this.getDistanceFromCenterForValue(value));},getBasePosition:function(){var me=this;var min=me.min;var max=me.max;return me.getPointPositionForValue(0,me.beginAtZero?0:min<0&&max<0?max:min>0&&max>0?min:0);},draw:function(){var me=this;var opts=me.options;var gridLineOpts=opts.gridLines;var tickOpts=opts.ticks;var valueOrDefault=helpers.valueOrDefault;if(opts.display){var ctx=me.ctx;var startAngle=this.getIndexAngle(0);var tickFontSize=valueOrDefault(tickOpts.fontSize,globalDefaults.defaultFontSize);var tickFontStyle=valueOrDefault(tickOpts.fontStyle,globalDefaults.defaultFontStyle);var tickFontFamily=valueOrDefault(tickOpts.fontFamily,globalDefaults.defaultFontFamily);var tickLabelFont=helpers.fontString(tickFontSize,tickFontStyle,tickFontFamily);helpers.each(me.ticks,function(label,index){if(index>0||tickOpts.reverse){var yCenterOffset=me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]);if(gridLineOpts.display&&index!==0){drawRadiusLine(me,gridLineOpts,yCenterOffset,index);}
if(tickOpts.display){var tickFontColor=valueOrDefault(tickOpts.fontColor,globalDefaults.defaultFontColor);ctx.font=tickLabelFont;ctx.save();ctx.translate(me.xCenter,me.yCenter);ctx.rotate(startAngle);if(tickOpts.showLabelBackdrop){var labelWidth=ctx.measureText(label).width;ctx.fillStyle=tickOpts.backdropColor;ctx.fillRect(-labelWidth/2-tickOpts.backdropPaddingX,-yCenterOffset-tickFontSize/2-tickOpts.backdropPaddingY,labelWidth+tickOpts.backdropPaddingX*2,tickFontSize+tickOpts.backdropPaddingY*2);}
ctx.textAlign='center';ctx.textBaseline='middle';ctx.fillStyle=tickFontColor;ctx.fillText(label,0,-yCenterOffset);ctx.restore();}}});if(opts.angleLines.display||opts.pointLabels.display){drawPointLabels(me);}}}});Chart.scaleService.registerScaleType('radialLinear',LinearRadialScale,defaultConfig);};},{"25":25,"34":34,"45":45}],58:[function(require,module,exports){'use strict';var moment=require(6);moment=typeof moment==='function'?moment:window.moment;var defaults=require(25);var helpers=require(45);var MIN_INTEGER=Number.MIN_SAFE_INTEGER||-9007199254740991;var MAX_INTEGER=Number.MAX_SAFE_INTEGER||9007199254740991;var INTERVALS={millisecond:{common:true,size:1,steps:[1,2,5,10,20,50,100,250,500]},second:{common:true,size:1000,steps:[1,2,5,10,30]},minute:{common:true,size:60000,steps:[1,2,5,10,30]},hour:{common:true,size:3600000,steps:[1,2,3,6,12]},day:{common:true,size:86400000,steps:[1,2,5]},week:{common:false,size:604800000,steps:[1,2,3,4]},month:{common:true,size:2.628e9,steps:[1,2,3]},quarter:{common:false,size:7.884e9,steps:[1,2,3,4]},year:{common:true,size:3.154e10}};var UNITS=Object.keys(INTERVALS);function sorter(a,b){return a-b;}
function arrayUnique(items){var hash={};var out=[];var i,ilen,item;for(i=0,ilen=items.length;i<ilen;++i){item=items[i];if(!hash[item]){hash[item]=true;out.push(item);}}
return out;}
function buildLookupTable(timestamps,min,max,distribution){if(distribution==='linear'||!timestamps.length){return[{time:min,pos:0},{time:max,pos:1}];}
var table=[];var items=[min];var i,ilen,prev,curr,next;for(i=0,ilen=timestamps.length;i<ilen;++i){curr=timestamps[i];if(curr>min&&curr<max){items.push(curr);}}
items.push(max);for(i=0,ilen=items.length;i<ilen;++i){next=items[i+1];prev=items[i-1];curr=items[i];if(prev===undefined||next===undefined||Math.round((next+prev)/2)!==curr){table.push({time:curr,pos:i/(ilen-1)});}}
return table;}
function lookup(table,key,value){var lo=0;var hi=table.length-1;var mid,i0,i1;while(lo>=0&&lo<=hi){mid=(lo+hi)>>1;i0=table[mid-1]||null;i1=table[mid];if(!i0){return{lo:null,hi:i1};}else if(i1[key]<value){lo=mid+1;}else if(i0[key]>value){hi=mid-1;}else{return{lo:i0,hi:i1};}}
return{lo:i1,hi:null};}
function interpolate(table,skey,sval,tkey){var range=lookup(table,skey,sval);var prev=!range.lo?table[0]:!range.hi?table[table.length-2]:range.lo;var next=!range.lo?table[1]:!range.hi?table[table.length-1]:range.hi;var span=next[skey]-prev[skey];var ratio=span?(sval-prev[skey])/span:0;var offset=(next[tkey]-prev[tkey])*ratio;return prev[tkey]+offset;}
function momentify(value,options){var parser=options.parser;var format=options.parser||options.format;if(typeof parser==='function'){return parser(value);}
if(typeof value==='string'&&typeof format==='string'){return moment(value,format);}
if(!(value instanceof moment)){value=moment(value);}
if(value.isValid()){return value;}
if(typeof format==='function'){return format(value);}
return value;}
function parse(input,scale){if(helpers.isNullOrUndef(input)){return null;}
var options=scale.options.time;var value=momentify(scale.getRightValue(input),options);if(!value.isValid()){return null;}
if(options.round){value.startOf(options.round);}
return value.valueOf();}
function determineStepSize(min,max,unit,capacity){var range=max-min;var interval=INTERVALS[unit];var milliseconds=interval.size;var steps=interval.steps;var i,ilen,factor;if(!steps){return Math.ceil(range/(capacity*milliseconds));}
for(i=0,ilen=steps.length;i<ilen;++i){factor=steps[i];if(Math.ceil(range/(milliseconds*factor))<=capacity){break;}}
return factor;}
function determineUnitForAutoTicks(minUnit,min,max,capacity){var ilen=UNITS.length;var i,interval,factor;for(i=UNITS.indexOf(minUnit);i<ilen-1;++i){interval=INTERVALS[UNITS[i]];factor=interval.steps?interval.steps[interval.steps.length-1]:MAX_INTEGER;if(interval.common&&Math.ceil((max-min)/(factor*interval.size))<=capacity){return UNITS[i];}}
return UNITS[ilen-1];}
function determineUnitForFormatting(ticks,minUnit,min,max){var duration=moment.duration(moment(max).diff(moment(min)));var ilen=UNITS.length;var i,unit;for(i=ilen-1;i>=UNITS.indexOf(minUnit);i--){unit=UNITS[i];if(INTERVALS[unit].common&&duration.as(unit)>=ticks.length){return unit;}}
return UNITS[minUnit?UNITS.indexOf(minUnit):0];}
function determineMajorUnit(unit){for(var i=UNITS.indexOf(unit)+1,ilen=UNITS.length;i<ilen;++i){if(INTERVALS[UNITS[i]].common){return UNITS[i];}}}
function generate(min,max,capacity,options){var timeOpts=options.time;var minor=timeOpts.unit||determineUnitForAutoTicks(timeOpts.minUnit,min,max,capacity);var major=determineMajorUnit(minor);var stepSize=helpers.valueOrDefault(timeOpts.stepSize,timeOpts.unitStepSize);var weekday=minor==='week'?timeOpts.isoWeekday:false;var majorTicksEnabled=options.ticks.major.enabled;var interval=INTERVALS[minor];var first=moment(min);var last=moment(max);var ticks=[];var time;if(!stepSize){stepSize=determineStepSize(min,max,minor,capacity);}
if(weekday){first=first.isoWeekday(weekday);last=last.isoWeekday(weekday);}
first=first.startOf(weekday?'day':minor);last=last.startOf(weekday?'day':minor);if(last<max){last.add(1,minor);}
time=moment(first);if(majorTicksEnabled&&major&&!weekday&&!timeOpts.round){time.startOf(major);time.add(~~((first-time)/(interval.size*stepSize))*stepSize,minor);}
for(;time<last;time.add(stepSize,minor)){ticks.push(+time);}
ticks.push(+time);return ticks;}
function computeOffsets(table,ticks,min,max,options){var left=0;var right=0;var upper,lower;if(options.offset&&ticks.length){if(!options.time.min){upper=ticks.length>1?ticks[1]:max;lower=ticks[0];left=(interpolate(table,'time',upper,'pos')-
interpolate(table,'time',lower,'pos'))/2;}
if(!options.time.max){upper=ticks[ticks.length-1];lower=ticks.length>1?ticks[ticks.length-2]:min;right=(interpolate(table,'time',upper,'pos')-
interpolate(table,'time',lower,'pos'))/2;}}
return{left:left,right:right};}
function ticksFromTimestamps(values,majorUnit){var ticks=[];var i,ilen,value,major;for(i=0,ilen=values.length;i<ilen;++i){value=values[i];major=majorUnit?value===+moment(value).startOf(majorUnit):false;ticks.push({value:value,major:major});}
return ticks;}
function determineLabelFormat(data,timeOpts){var i,momentDate,hasTime;var ilen=data.length;for(i=0;i<ilen;i++){momentDate=momentify(data[i],timeOpts);if(momentDate.millisecond()!==0){return'MMM D, YYYY h:mm:ss.SSS a';}
if(momentDate.second()!==0||momentDate.minute()!==0||momentDate.hour()!==0){hasTime=true;}}
if(hasTime){return'MMM D, YYYY h:mm:ss a';}
return'MMM D, YYYY';}
module.exports=function(Chart){var defaultConfig={position:'bottom',distribution:'linear',bounds:'data',time:{parser:false,format:false,unit:false,round:false,displayFormat:false,isoWeekday:false,minUnit:'millisecond',displayFormats:{millisecond:'h:mm:ss.SSS a',second:'h:mm:ss a',minute:'h:mm a',hour:'hA',day:'MMM D',week:'ll',month:'MMM YYYY',quarter:'[Q]Q - YYYY',year:'YYYY'},},ticks:{autoSkip:false,source:'auto',major:{enabled:false}}};var TimeScale=Chart.Scale.extend({initialize:function(){if(!moment){throw new Error('Chart.js - Moment.js could not be found! You must include it before Chart.js to use the time scale. Download at https://momentjs.com');}
this.mergeTicksOptions();Chart.Scale.prototype.initialize.call(this);},update:function(){var me=this;var options=me.options;if(options.time&&options.time.format){console.warn('options.time.format is deprecated and replaced by options.time.parser.');}
return Chart.Scale.prototype.update.apply(me,arguments);},getRightValue:function(rawValue){if(rawValue&&rawValue.t!==undefined){rawValue=rawValue.t;}
return Chart.Scale.prototype.getRightValue.call(this,rawValue);},determineDataLimits:function(){var me=this;var chart=me.chart;var timeOpts=me.options.time;var unit=timeOpts.unit||'day';var min=MAX_INTEGER;var max=MIN_INTEGER;var timestamps=[];var datasets=[];var labels=[];var i,j,ilen,jlen,data,timestamp;for(i=0,ilen=chart.data.labels.length;i<ilen;++i){labels.push(parse(chart.data.labels[i],me));}
for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){if(chart.isDatasetVisible(i)){data=chart.data.datasets[i].data;if(helpers.isObject(data[0])){datasets[i]=[];for(j=0,jlen=data.length;j<jlen;++j){timestamp=parse(data[j],me);timestamps.push(timestamp);datasets[i][j]=timestamp;}}else{timestamps.push.apply(timestamps,labels);datasets[i]=labels.slice(0);}}else{datasets[i]=[];}}
if(labels.length){labels=arrayUnique(labels).sort(sorter);min=Math.min(min,labels[0]);max=Math.max(max,labels[labels.length-1]);}
if(timestamps.length){timestamps=arrayUnique(timestamps).sort(sorter);min=Math.min(min,timestamps[0]);max=Math.max(max,timestamps[timestamps.length-1]);}
min=parse(timeOpts.min,me)||min;max=parse(timeOpts.max,me)||max;min=min===MAX_INTEGER?+moment().startOf(unit):min;max=max===MIN_INTEGER?+moment().endOf(unit)+1:max;me.min=Math.min(min,max);me.max=Math.max(min+1,max);me._horizontal=me.isHorizontal();me._table=[];me._timestamps={data:timestamps,datasets:datasets,labels:labels};},buildTicks:function(){var me=this;var min=me.min;var max=me.max;var options=me.options;var timeOpts=options.time;var timestamps=[];var ticks=[];var i,ilen,timestamp;switch(options.ticks.source){case'data':timestamps=me._timestamps.data;break;case'labels':timestamps=me._timestamps.labels;break;case'auto':default:timestamps=generate(min,max,me.getLabelCapacity(min),options);}
if(options.bounds==='ticks'&&timestamps.length){min=timestamps[0];max=timestamps[timestamps.length-1];}
min=parse(timeOpts.min,me)||min;max=parse(timeOpts.max,me)||max;for(i=0,ilen=timestamps.length;i<ilen;++i){timestamp=timestamps[i];if(timestamp>=min&&timestamp<=max){ticks.push(timestamp);}}
me.min=min;me.max=max;me._unit=timeOpts.unit||determineUnitForFormatting(ticks,timeOpts.minUnit,me.min,me.max);me._majorUnit=determineMajorUnit(me._unit);me._table=buildLookupTable(me._timestamps.data,min,max,options.distribution);me._offsets=computeOffsets(me._table,ticks,min,max,options);me._labelFormat=determineLabelFormat(me._timestamps.data,timeOpts);return ticksFromTimestamps(ticks,me._majorUnit);},getLabelForIndex:function(index,datasetIndex){var me=this;var data=me.chart.data;var timeOpts=me.options.time;var label=data.labels&&index<data.labels.length?data.labels[index]:'';var value=data.datasets[datasetIndex].data[index];if(helpers.isObject(value)){label=me.getRightValue(value);}
if(timeOpts.tooltipFormat){return momentify(label,timeOpts).format(timeOpts.tooltipFormat);}
if(typeof label==='string'){return label;}
return momentify(label,timeOpts).format(me._labelFormat);},tickFormatFunction:function(tick,index,ticks,formatOverride){var me=this;var options=me.options;var time=tick.valueOf();var formats=options.time.displayFormats;var minorFormat=formats[me._unit];var majorUnit=me._majorUnit;var majorFormat=formats[majorUnit];var majorTime=tick.clone().startOf(majorUnit).valueOf();var majorTickOpts=options.ticks.major;var major=majorTickOpts.enabled&&majorUnit&&majorFormat&&time===majorTime;var label=tick.format(formatOverride?formatOverride:major?majorFormat:minorFormat);var tickOpts=major?majorTickOpts:options.ticks.minor;var formatter=helpers.valueOrDefault(tickOpts.callback,tickOpts.userCallback);return formatter?formatter(label,index,ticks):label;},convertTicksToLabels:function(ticks){var labels=[];var i,ilen;for(i=0,ilen=ticks.length;i<ilen;++i){labels.push(this.tickFormatFunction(moment(ticks[i].value),i,ticks));}
return labels;},getPixelForOffset:function(time){var me=this;var size=me._horizontal?me.width:me.height;var start=me._horizontal?me.left:me.top;var pos=interpolate(me._table,'time',time,'pos');return start+size*(me._offsets.left+pos)/(me._offsets.left+1+me._offsets.right);},getPixelForValue:function(value,index,datasetIndex){var me=this;var time=null;if(index!==undefined&&datasetIndex!==undefined){time=me._timestamps.datasets[datasetIndex][index];}
if(time===null){time=parse(value,me);}
if(time!==null){return me.getPixelForOffset(time);}},getPixelForTick:function(index){var ticks=this.getTicks();return index>=0&&index<ticks.length?this.getPixelForOffset(ticks[index].value):null;},getValueForPixel:function(pixel){var me=this;var size=me._horizontal?me.width:me.height;var start=me._horizontal?me.left:me.top;var pos=(size?(pixel-start)/size:0)*(me._offsets.left+1+me._offsets.left)-me._offsets.right;var time=interpolate(me._table,'pos',pos,'time');return moment(time);},getLabelWidth:function(label){var me=this;var ticksOpts=me.options.ticks;var tickLabelWidth=me.ctx.measureText(label).width;var angle=helpers.toRadians(ticksOpts.maxRotation);var cosRotation=Math.cos(angle);var sinRotation=Math.sin(angle);var tickFontSize=helpers.valueOrDefault(ticksOpts.fontSize,defaults.global.defaultFontSize);return(tickLabelWidth*cosRotation)+(tickFontSize*sinRotation);},getLabelCapacity:function(exampleTime){var me=this;var formatOverride=me.options.time.displayFormats.millisecond;var exampleLabel=me.tickFormatFunction(moment(exampleTime),0,[],formatOverride);var tickLabelWidth=me.getLabelWidth(exampleLabel);var innerWidth=me.isHorizontal()?me.width:me.height;var capacity=Math.floor(innerWidth/tickLabelWidth);return capacity>0?capacity:1;}});Chart.scaleService.registerScaleType('time',TimeScale,defaultConfig);};},{"25":25,"45":45,"6":6}]},{},[7])(7)});(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.markdownit=f()}})(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){'use strict';module.exports=require('entities/maps/entities.json');},{"entities/maps/entities.json":52}],2:[function(require,module,exports){'use strict';module.exports=['address','article','aside','base','basefont','blockquote','body','caption','center','col','colgroup','dd','details','dialog','dir','div','dl','dt','fieldset','figcaption','figure','footer','form','frame','frameset','h1','h2','h3','h4','h5','h6','head','header','hr','html','iframe','legend','li','link','main','menu','menuitem','meta','nav','noframes','ol','optgroup','option','p','param','section','source','summary','table','tbody','td','tfoot','th','thead','title','tr','track','ul'];},{}],3:[function(require,module,exports){'use strict';var attr_name='[a-zA-Z_:][a-zA-Z0-9:._-]*';var unquoted='[^"\'=<>`\\x00-\\x20]+';var single_quoted="'[^']*'";var double_quoted='"[^"]*"';var attr_value='(?:'+unquoted+'|'+single_quoted+'|'+double_quoted+')';var attribute='(?:\\s+'+attr_name+'(?:\\s*=\\s*'+attr_value+')?)';var open_tag='<[A-Za-z][A-Za-z0-9\\-]*'+attribute+'*\\s*\\/?>';var close_tag='<\\/[A-Za-z][A-Za-z0-9\\-]*\\s*>';var comment='<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->';var processing='<[?].*?[?]>';var declaration='<![A-Z]+\\s+[^>]*>';var cdata='<!\\[CDATA\\[[\\s\\S]*?\\]\\]>';var HTML_TAG_RE=new RegExp('^(?:'+open_tag+'|'+close_tag+'|'+comment+'|'+processing+'|'+declaration+'|'+cdata+')');var HTML_OPEN_CLOSE_TAG_RE=new RegExp('^(?:'+open_tag+'|'+close_tag+')');module.exports.HTML_TAG_RE=HTML_TAG_RE;module.exports.HTML_OPEN_CLOSE_TAG_RE=HTML_OPEN_CLOSE_TAG_RE;},{}],4:[function(require,module,exports){'use strict';function _class(obj){return Object.prototype.toString.call(obj);}
function isString(obj){return _class(obj)==='[object String]';}
var _hasOwnProperty=Object.prototype.hasOwnProperty;function has(object,key){return _hasOwnProperty.call(object,key);}
function assign(obj){var sources=Array.prototype.slice.call(arguments,1);sources.forEach(function(source){if(!source){return;}
if(typeof source!=='object'){throw new TypeError(source+'must be object');}
Object.keys(source).forEach(function(key){obj[key]=source[key];});});return obj;}
function arrayReplaceAt(src,pos,newElements){return[].concat(src.slice(0,pos),newElements,src.slice(pos+1));}
function isValidEntityCode(c){if(c>=0xD800&&c<=0xDFFF){return false;}
if(c>=0xFDD0&&c<=0xFDEF){return false;}
if((c&0xFFFF)===0xFFFF||(c&0xFFFF)===0xFFFE){return false;}
if(c>=0x00&&c<=0x08){return false;}
if(c===0x0B){return false;}
if(c>=0x0E&&c<=0x1F){return false;}
if(c>=0x7F&&c<=0x9F){return false;}
if(c>0x10FFFF){return false;}
return true;}
function fromCodePoint(c){if(c>0xffff){c-=0x10000;var surrogate1=0xd800+(c>>10),surrogate2=0xdc00+(c&0x3ff);return String.fromCharCode(surrogate1,surrogate2);}
return String.fromCharCode(c);}
var UNESCAPE_MD_RE=/\\([!"#$%&'()*+,\-.\/:;<=>?@[\\\]^_`{|}~])/g;var ENTITY_RE=/&([a-z#][a-z0-9]{1,31});/gi;var UNESCAPE_ALL_RE=new RegExp(UNESCAPE_MD_RE.source+'|'+ENTITY_RE.source,'gi');var DIGITAL_ENTITY_TEST_RE=/^#((?:x[a-f0-9]{1,8}|[0-9]{1,8}))/i;var entities=require('./entities');function replaceEntityPattern(match,name){var code=0;if(has(entities,name)){return entities[name];}
if(name.charCodeAt(0)===0x23&&DIGITAL_ENTITY_TEST_RE.test(name)){code=name[1].toLowerCase()==='x'?parseInt(name.slice(2),16):parseInt(name.slice(1),10);if(isValidEntityCode(code)){return fromCodePoint(code);}}
return match;}
function unescapeMd(str){if(str.indexOf('\\')<0){return str;}
return str.replace(UNESCAPE_MD_RE,'$1');}
function unescapeAll(str){if(str.indexOf('\\')<0&&str.indexOf('&')<0){return str;}
return str.replace(UNESCAPE_ALL_RE,function(match,escaped,entity){if(escaped){return escaped;}
return replaceEntityPattern(match,entity);});}
var HTML_ESCAPE_TEST_RE=/[&<>"]/;var HTML_ESCAPE_REPLACE_RE=/[&<>"]/g;var HTML_REPLACEMENTS={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'};function replaceUnsafeChar(ch){return HTML_REPLACEMENTS[ch];}
function escapeHtml(str){if(HTML_ESCAPE_TEST_RE.test(str)){return str.replace(HTML_ESCAPE_REPLACE_RE,replaceUnsafeChar);}
return str;}
var REGEXP_ESCAPE_RE=/[.?*+^$[\]\\(){}|-]/g;function escapeRE(str){return str.replace(REGEXP_ESCAPE_RE,'\\$&');}
function isSpace(code){switch(code){case 0x09:case 0x20:return true;}
return false;}
function isWhiteSpace(code){if(code>=0x2000&&code<=0x200A){return true;}
switch(code){case 0x09:case 0x0A:case 0x0B:case 0x0C:case 0x0D:case 0x20:case 0xA0:case 0x1680:case 0x202F:case 0x205F:case 0x3000:return true;}
return false;}
var UNICODE_PUNCT_RE=require('uc.micro/categories/P/regex');function isPunctChar(ch){return UNICODE_PUNCT_RE.test(ch);}
function isMdAsciiPunct(ch){switch(ch){case 0x21:case 0x22:case 0x23:case 0x24:case 0x25:case 0x26:case 0x27:case 0x28:case 0x29:case 0x2A:case 0x2B:case 0x2C:case 0x2D:case 0x2E:case 0x2F:case 0x3A:case 0x3B:case 0x3C:case 0x3D:case 0x3E:case 0x3F:case 0x40:case 0x5B:case 0x5C:case 0x5D:case 0x5E:case 0x5F:case 0x60:case 0x7B:case 0x7C:case 0x7D:case 0x7E:return true;default:return false;}}
function normalizeReference(str){return str.trim().replace(/\s+/g,' ').toUpperCase();}
exports.lib={};exports.lib.mdurl=require('mdurl');exports.lib.ucmicro=require('uc.micro');exports.assign=assign;exports.isString=isString;exports.has=has;exports.unescapeMd=unescapeMd;exports.unescapeAll=unescapeAll;exports.isValidEntityCode=isValidEntityCode;exports.fromCodePoint=fromCodePoint;exports.escapeHtml=escapeHtml;exports.arrayReplaceAt=arrayReplaceAt;exports.isSpace=isSpace;exports.isWhiteSpace=isWhiteSpace;exports.isMdAsciiPunct=isMdAsciiPunct;exports.isPunctChar=isPunctChar;exports.escapeRE=escapeRE;exports.normalizeReference=normalizeReference;},{"./entities":1,"mdurl":58,"uc.micro":65,"uc.micro/categories/P/regex":63}],5:[function(require,module,exports){'use strict';exports.parseLinkLabel=require('./parse_link_label');exports.parseLinkDestination=require('./parse_link_destination');exports.parseLinkTitle=require('./parse_link_title');},{"./parse_link_destination":6,"./parse_link_label":7,"./parse_link_title":8}],6:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;var unescapeAll=require('../common/utils').unescapeAll;module.exports=function parseLinkDestination(str,pos,max){var code,level,lines=0,start=pos,result={ok:false,pos:0,lines:0,str:''};if(str.charCodeAt(pos)===0x3C){pos++;while(pos<max){code=str.charCodeAt(pos);if(code===0x0A||isSpace(code)){return result;}
if(code===0x3E){result.pos=pos+1;result.str=unescapeAll(str.slice(start+1,pos));result.ok=true;return result;}
if(code===0x5C&&pos+1<max){pos+=2;continue;}
pos++;}
return result;}
level=0;while(pos<max){code=str.charCodeAt(pos);if(code===0x20){break;}
if(code<0x20||code===0x7F){break;}
if(code===0x5C&&pos+1<max){pos+=2;continue;}
if(code===0x28){level++;}
if(code===0x29){if(level===0){break;}
level--;}
pos++;}
if(start===pos){return result;}
if(level!==0){return result;}
result.str=unescapeAll(str.slice(start,pos));result.lines=lines;result.pos=pos;result.ok=true;return result;};},{"../common/utils":4}],7:[function(require,module,exports){'use strict';module.exports=function parseLinkLabel(state,start,disableNested){var level,found,marker,prevPos,labelEnd=-1,max=state.posMax,oldPos=state.pos;state.pos=start+1;level=1;while(state.pos<max){marker=state.src.charCodeAt(state.pos);if(marker===0x5D){level--;if(level===0){found=true;break;}}
prevPos=state.pos;state.md.inline.skipToken(state);if(marker===0x5B){if(prevPos===state.pos-1){level++;}else if(disableNested){state.pos=oldPos;return-1;}}}
if(found){labelEnd=state.pos;}
state.pos=oldPos;return labelEnd;};},{}],8:[function(require,module,exports){'use strict';var unescapeAll=require('../common/utils').unescapeAll;module.exports=function parseLinkTitle(str,pos,max){var code,marker,lines=0,start=pos,result={ok:false,pos:0,lines:0,str:''};if(pos>=max){return result;}
marker=str.charCodeAt(pos);if(marker!==0x22&&marker!==0x27&&marker!==0x28){return result;}
pos++;if(marker===0x28){marker=0x29;}
while(pos<max){code=str.charCodeAt(pos);if(code===marker){result.pos=pos+1;result.lines=lines;result.str=unescapeAll(str.slice(start+1,pos));result.ok=true;return result;}else if(code===0x0A){lines++;}else if(code===0x5C&&pos+1<max){pos++;if(str.charCodeAt(pos)===0x0A){lines++;}}
pos++;}
return result;};},{"../common/utils":4}],9:[function(require,module,exports){'use strict';var utils=require('./common/utils');var helpers=require('./helpers');var Renderer=require('./renderer');var ParserCore=require('./parser_core');var ParserBlock=require('./parser_block');var ParserInline=require('./parser_inline');var LinkifyIt=require('linkify-it');var mdurl=require('mdurl');var punycode=require('punycode');var config={'default':require('./presets/default'),zero:require('./presets/zero'),commonmark:require('./presets/commonmark')};var BAD_PROTO_RE=/^(vbscript|javascript|file|data):/;var GOOD_DATA_RE=/^data:image\/(gif|png|jpeg|webp);/;function validateLink(url){var str=url.trim().toLowerCase();return BAD_PROTO_RE.test(str)?(GOOD_DATA_RE.test(str)?true:false):true;}
var RECODE_HOSTNAME_FOR=['http:','https:','mailto:'];function normalizeLink(url){var parsed=mdurl.parse(url,true);if(parsed.hostname){if(!parsed.protocol||RECODE_HOSTNAME_FOR.indexOf(parsed.protocol)>=0){try{parsed.hostname=punycode.toASCII(parsed.hostname);}catch(er){}}}
return mdurl.encode(mdurl.format(parsed));}
function normalizeLinkText(url){var parsed=mdurl.parse(url,true);if(parsed.hostname){if(!parsed.protocol||RECODE_HOSTNAME_FOR.indexOf(parsed.protocol)>=0){try{parsed.hostname=punycode.toUnicode(parsed.hostname);}catch(er){}}}
return mdurl.decode(mdurl.format(parsed));}
function MarkdownIt(presetName,options){if(!(this instanceof MarkdownIt)){return new MarkdownIt(presetName,options);}
if(!options){if(!utils.isString(presetName)){options=presetName||{};presetName='default';}}
this.inline=new ParserInline();this.block=new ParserBlock();this.core=new ParserCore();this.renderer=new Renderer();this.linkify=new LinkifyIt();this.validateLink=validateLink;this.normalizeLink=normalizeLink;this.normalizeLinkText=normalizeLinkText;this.utils=utils;this.helpers=utils.assign({},helpers);this.options={};this.configure(presetName);if(options){this.set(options);}}
MarkdownIt.prototype.set=function(options){utils.assign(this.options,options);return this;};MarkdownIt.prototype.configure=function(presets){var self=this,presetName;if(utils.isString(presets)){presetName=presets;presets=config[presetName];if(!presets){throw new Error('Wrong `markdown-it` preset "'+presetName+'", check name');}}
if(!presets){throw new Error('Wrong `markdown-it` preset, can\'t be empty');}
if(presets.options){self.set(presets.options);}
if(presets.components){Object.keys(presets.components).forEach(function(name){if(presets.components[name].rules){self[name].ruler.enableOnly(presets.components[name].rules);}
if(presets.components[name].rules2){self[name].ruler2.enableOnly(presets.components[name].rules2);}});}
return this;};MarkdownIt.prototype.enable=function(list,ignoreInvalid){var result=[];if(!Array.isArray(list)){list=[list];}
['core','block','inline'].forEach(function(chain){result=result.concat(this[chain].ruler.enable(list,true));},this);result=result.concat(this.inline.ruler2.enable(list,true));var missed=list.filter(function(name){return result.indexOf(name)<0;});if(missed.length&&!ignoreInvalid){throw new Error('MarkdownIt. Failed to enable unknown rule(s): '+missed);}
return this;};MarkdownIt.prototype.disable=function(list,ignoreInvalid){var result=[];if(!Array.isArray(list)){list=[list];}
['core','block','inline'].forEach(function(chain){result=result.concat(this[chain].ruler.disable(list,true));},this);result=result.concat(this.inline.ruler2.disable(list,true));var missed=list.filter(function(name){return result.indexOf(name)<0;});if(missed.length&&!ignoreInvalid){throw new Error('MarkdownIt. Failed to disable unknown rule(s): '+missed);}
return this;};MarkdownIt.prototype.use=function(plugin){var args=[this].concat(Array.prototype.slice.call(arguments,1));plugin.apply(plugin,args);return this;};MarkdownIt.prototype.parse=function(src,env){if(typeof src!=='string'){throw new Error('Input data should be a String');}
var state=new this.core.State(src,this,env);this.core.process(state);return state.tokens;};MarkdownIt.prototype.render=function(src,env){env=env||{};return this.renderer.render(this.parse(src,env),this.options,env);};MarkdownIt.prototype.parseInline=function(src,env){var state=new this.core.State(src,this,env);state.inlineMode=true;this.core.process(state);return state.tokens;};MarkdownIt.prototype.renderInline=function(src,env){env=env||{};return this.renderer.render(this.parseInline(src,env),this.options,env);};module.exports=MarkdownIt;},{"./common/utils":4,"./helpers":5,"./parser_block":10,"./parser_core":11,"./parser_inline":12,"./presets/commonmark":13,"./presets/default":14,"./presets/zero":15,"./renderer":16,"linkify-it":53,"mdurl":58,"punycode":60}],10:[function(require,module,exports){'use strict';var Ruler=require('./ruler');var _rules=[['table',require('./rules_block/table'),['paragraph','reference']],['code',require('./rules_block/code')],['fence',require('./rules_block/fence'),['paragraph','reference','blockquote','list']],['blockquote',require('./rules_block/blockquote'),['paragraph','reference','blockquote','list']],['hr',require('./rules_block/hr'),['paragraph','reference','blockquote','list']],['list',require('./rules_block/list'),['paragraph','reference','blockquote']],['reference',require('./rules_block/reference')],['heading',require('./rules_block/heading'),['paragraph','reference','blockquote']],['lheading',require('./rules_block/lheading')],['html_block',require('./rules_block/html_block'),['paragraph','reference','blockquote']],['paragraph',require('./rules_block/paragraph')]];function ParserBlock(){this.ruler=new Ruler();for(var i=0;i<_rules.length;i++){this.ruler.push(_rules[i][0],_rules[i][1],{alt:(_rules[i][2]||[]).slice()});}}
ParserBlock.prototype.tokenize=function(state,startLine,endLine){var ok,i,rules=this.ruler.getRules(''),len=rules.length,line=startLine,hasEmptyLines=false,maxNesting=state.md.options.maxNesting;while(line<endLine){state.line=line=state.skipEmptyLines(line);if(line>=endLine){break;}
if(state.sCount[line]<state.blkIndent){break;}
if(state.level>=maxNesting){state.line=endLine;break;}
for(i=0;i<len;i++){ok=rules[i](state,line,endLine,false);if(ok){break;}}
state.tight=!hasEmptyLines;if(state.isEmpty(state.line-1)){hasEmptyLines=true;}
line=state.line;if(line<endLine&&state.isEmpty(line)){hasEmptyLines=true;line++;state.line=line;}}};ParserBlock.prototype.parse=function(src,md,env,outTokens){var state;if(!src){return;}
state=new this.State(src,md,env,outTokens);this.tokenize(state,state.line,state.lineMax);};ParserBlock.prototype.State=require('./rules_block/state_block');module.exports=ParserBlock;},{"./ruler":17,"./rules_block/blockquote":18,"./rules_block/code":19,"./rules_block/fence":20,"./rules_block/heading":21,"./rules_block/hr":22,"./rules_block/html_block":23,"./rules_block/lheading":24,"./rules_block/list":25,"./rules_block/paragraph":26,"./rules_block/reference":27,"./rules_block/state_block":28,"./rules_block/table":29}],11:[function(require,module,exports){'use strict';var Ruler=require('./ruler');var _rules=[['normalize',require('./rules_core/normalize')],['block',require('./rules_core/block')],['inline',require('./rules_core/inline')],['linkify',require('./rules_core/linkify')],['replacements',require('./rules_core/replacements')],['smartquotes',require('./rules_core/smartquotes')]];function Core(){this.ruler=new Ruler();for(var i=0;i<_rules.length;i++){this.ruler.push(_rules[i][0],_rules[i][1]);}}
Core.prototype.process=function(state){var i,l,rules;rules=this.ruler.getRules('');for(i=0,l=rules.length;i<l;i++){rules[i](state);}};Core.prototype.State=require('./rules_core/state_core');module.exports=Core;},{"./ruler":17,"./rules_core/block":30,"./rules_core/inline":31,"./rules_core/linkify":32,"./rules_core/normalize":33,"./rules_core/replacements":34,"./rules_core/smartquotes":35,"./rules_core/state_core":36}],12:[function(require,module,exports){'use strict';var Ruler=require('./ruler');var _rules=[['text',require('./rules_inline/text')],['newline',require('./rules_inline/newline')],['escape',require('./rules_inline/escape')],['backticks',require('./rules_inline/backticks')],['strikethrough',require('./rules_inline/strikethrough').tokenize],['emphasis',require('./rules_inline/emphasis').tokenize],['link',require('./rules_inline/link')],['image',require('./rules_inline/image')],['autolink',require('./rules_inline/autolink')],['html_inline',require('./rules_inline/html_inline')],['entity',require('./rules_inline/entity')]];var _rules2=[['balance_pairs',require('./rules_inline/balance_pairs')],['strikethrough',require('./rules_inline/strikethrough').postProcess],['emphasis',require('./rules_inline/emphasis').postProcess],['text_collapse',require('./rules_inline/text_collapse')]];function ParserInline(){var i;this.ruler=new Ruler();for(i=0;i<_rules.length;i++){this.ruler.push(_rules[i][0],_rules[i][1]);}
this.ruler2=new Ruler();for(i=0;i<_rules2.length;i++){this.ruler2.push(_rules2[i][0],_rules2[i][1]);}}
ParserInline.prototype.skipToken=function(state){var ok,i,pos=state.pos,rules=this.ruler.getRules(''),len=rules.length,maxNesting=state.md.options.maxNesting,cache=state.cache;if(typeof cache[pos]!=='undefined'){state.pos=cache[pos];return;}
if(state.level<maxNesting){for(i=0;i<len;i++){state.level++;ok=rules[i](state,true);state.level--;if(ok){break;}}}else{state.pos=state.posMax;}
if(!ok){state.pos++;}
cache[pos]=state.pos;};ParserInline.prototype.tokenize=function(state){var ok,i,rules=this.ruler.getRules(''),len=rules.length,end=state.posMax,maxNesting=state.md.options.maxNesting;while(state.pos<end){if(state.level<maxNesting){for(i=0;i<len;i++){ok=rules[i](state,false);if(ok){break;}}}
if(ok){if(state.pos>=end){break;}
continue;}
state.pending+=state.src[state.pos++];}
if(state.pending){state.pushPending();}};ParserInline.prototype.parse=function(str,md,env,outTokens){var i,rules,len;var state=new this.State(str,md,env,outTokens);this.tokenize(state);rules=this.ruler2.getRules('');len=rules.length;for(i=0;i<len;i++){rules[i](state);}};ParserInline.prototype.State=require('./rules_inline/state_inline');module.exports=ParserInline;},{"./ruler":17,"./rules_inline/autolink":37,"./rules_inline/backticks":38,"./rules_inline/balance_pairs":39,"./rules_inline/emphasis":40,"./rules_inline/entity":41,"./rules_inline/escape":42,"./rules_inline/html_inline":43,"./rules_inline/image":44,"./rules_inline/link":45,"./rules_inline/newline":46,"./rules_inline/state_inline":47,"./rules_inline/strikethrough":48,"./rules_inline/text":49,"./rules_inline/text_collapse":50}],13:[function(require,module,exports){'use strict';module.exports={options:{html:true,xhtmlOut:true,breaks:false,langPrefix:'language-',linkify:false,typographer:false,quotes:'\u201c\u201d\u2018\u2019',highlight:null,maxNesting:20},components:{core:{rules:['normalize','block','inline']},block:{rules:['blockquote','code','fence','heading','hr','html_block','lheading','list','reference','paragraph']},inline:{rules:['autolink','backticks','emphasis','entity','escape','html_inline','image','link','newline','text'],rules2:['balance_pairs','emphasis','text_collapse']}}};},{}],14:[function(require,module,exports){'use strict';module.exports={options:{html:false,xhtmlOut:false,breaks:false,langPrefix:'language-',linkify:false,typographer:false,quotes:'\u201c\u201d\u2018\u2019',highlight:null,maxNesting:100},components:{core:{},block:{},inline:{}}};},{}],15:[function(require,module,exports){'use strict';module.exports={options:{html:false,xhtmlOut:false,breaks:false,langPrefix:'language-',linkify:false,typographer:false,quotes:'\u201c\u201d\u2018\u2019',highlight:null,maxNesting:20},components:{core:{rules:['normalize','block','inline']},block:{rules:['paragraph']},inline:{rules:['text'],rules2:['balance_pairs','text_collapse']}}};},{}],16:[function(require,module,exports){'use strict';var assign=require('./common/utils').assign;var unescapeAll=require('./common/utils').unescapeAll;var escapeHtml=require('./common/utils').escapeHtml;var default_rules={};default_rules.code_inline=function(tokens,idx,options,env,slf){var token=tokens[idx];return'<code'+slf.renderAttrs(token)+'>'+
escapeHtml(tokens[idx].content)+'</code>';};default_rules.code_block=function(tokens,idx,options,env,slf){var token=tokens[idx];return'<pre'+slf.renderAttrs(token)+'><code>'+
escapeHtml(tokens[idx].content)+'</code></pre>\n';};default_rules.fence=function(tokens,idx,options,env,slf){var token=tokens[idx],info=token.info?unescapeAll(token.info).trim():'',langName='',highlighted,i,tmpAttrs,tmpToken;if(info){langName=info.split(/\s+/g)[0];}
if(options.highlight){highlighted=options.highlight(token.content,langName)||escapeHtml(token.content);}else{highlighted=escapeHtml(token.content);}
if(highlighted.indexOf('<pre')===0){return highlighted+'\n';}
if(info){i=token.attrIndex('class');tmpAttrs=token.attrs?token.attrs.slice():[];if(i<0){tmpAttrs.push(['class',options.langPrefix+langName]);}else{tmpAttrs[i][1]+=' '+options.langPrefix+langName;}
tmpToken={attrs:tmpAttrs};return'<pre><code'+slf.renderAttrs(tmpToken)+'>'
+highlighted
+'</code></pre>\n';}
return'<pre><code'+slf.renderAttrs(token)+'>'
+highlighted
+'</code></pre>\n';};default_rules.image=function(tokens,idx,options,env,slf){var token=tokens[idx];token.attrs[token.attrIndex('alt')][1]=slf.renderInlineAsText(token.children,options,env);return slf.renderToken(tokens,idx,options);};default_rules.hardbreak=function(tokens,idx,options){return options.xhtmlOut?'<br />\n':'<br>\n';};default_rules.softbreak=function(tokens,idx,options){return options.breaks?(options.xhtmlOut?'<br />\n':'<br>\n'):'\n';};default_rules.text=function(tokens,idx){return escapeHtml(tokens[idx].content);};default_rules.html_block=function(tokens,idx){return tokens[idx].content;};default_rules.html_inline=function(tokens,idx){return tokens[idx].content;};function Renderer(){this.rules=assign({},default_rules);}
Renderer.prototype.renderAttrs=function renderAttrs(token){var i,l,result;if(!token.attrs){return'';}
result='';for(i=0,l=token.attrs.length;i<l;i++){result+=' '+escapeHtml(token.attrs[i][0])+'="'+escapeHtml(token.attrs[i][1])+'"';}
return result;};Renderer.prototype.renderToken=function renderToken(tokens,idx,options){var nextToken,result='',needLf=false,token=tokens[idx];if(token.hidden){return'';}
if(token.block&&token.nesting!==-1&&idx&&tokens[idx-1].hidden){result+='\n';}
result+=(token.nesting===-1?'</':'<')+token.tag;result+=this.renderAttrs(token);if(token.nesting===0&&options.xhtmlOut){result+=' /';}
if(token.block){needLf=true;if(token.nesting===1){if(idx+1<tokens.length){nextToken=tokens[idx+1];if(nextToken.type==='inline'||nextToken.hidden){needLf=false;}else if(nextToken.nesting===-1&&nextToken.tag===token.tag){needLf=false;}}}}
result+=needLf?'>\n':'>';return result;};Renderer.prototype.renderInline=function(tokens,options,env){var type,result='',rules=this.rules;for(var i=0,len=tokens.length;i<len;i++){type=tokens[i].type;if(typeof rules[type]!=='undefined'){result+=rules[type](tokens,i,options,env,this);}else{result+=this.renderToken(tokens,i,options);}}
return result;};Renderer.prototype.renderInlineAsText=function(tokens,options,env){var result='';for(var i=0,len=tokens.length;i<len;i++){if(tokens[i].type==='text'){result+=tokens[i].content;}else if(tokens[i].type==='image'){result+=this.renderInlineAsText(tokens[i].children,options,env);}}
return result;};Renderer.prototype.render=function(tokens,options,env){var i,len,type,result='',rules=this.rules;for(i=0,len=tokens.length;i<len;i++){type=tokens[i].type;if(type==='inline'){result+=this.renderInline(tokens[i].children,options,env);}else if(typeof rules[type]!=='undefined'){result+=rules[tokens[i].type](tokens,i,options,env,this);}else{result+=this.renderToken(tokens,i,options,env);}}
return result;};module.exports=Renderer;},{"./common/utils":4}],17:[function(require,module,exports){'use strict';function Ruler(){this.__rules__=[];this.__cache__=null;}
Ruler.prototype.__find__=function(name){for(var i=0;i<this.__rules__.length;i++){if(this.__rules__[i].name===name){return i;}}
return-1;};Ruler.prototype.__compile__=function(){var self=this;var chains=[''];self.__rules__.forEach(function(rule){if(!rule.enabled){return;}
rule.alt.forEach(function(altName){if(chains.indexOf(altName)<0){chains.push(altName);}});});self.__cache__={};chains.forEach(function(chain){self.__cache__[chain]=[];self.__rules__.forEach(function(rule){if(!rule.enabled){return;}
if(chain&&rule.alt.indexOf(chain)<0){return;}
self.__cache__[chain].push(rule.fn);});});};Ruler.prototype.at=function(name,fn,options){var index=this.__find__(name);var opt=options||{};if(index===-1){throw new Error('Parser rule not found: '+name);}
this.__rules__[index].fn=fn;this.__rules__[index].alt=opt.alt||[];this.__cache__=null;};Ruler.prototype.before=function(beforeName,ruleName,fn,options){var index=this.__find__(beforeName);var opt=options||{};if(index===-1){throw new Error('Parser rule not found: '+beforeName);}
this.__rules__.splice(index,0,{name:ruleName,enabled:true,fn:fn,alt:opt.alt||[]});this.__cache__=null;};Ruler.prototype.after=function(afterName,ruleName,fn,options){var index=this.__find__(afterName);var opt=options||{};if(index===-1){throw new Error('Parser rule not found: '+afterName);}
this.__rules__.splice(index+1,0,{name:ruleName,enabled:true,fn:fn,alt:opt.alt||[]});this.__cache__=null;};Ruler.prototype.push=function(ruleName,fn,options){var opt=options||{};this.__rules__.push({name:ruleName,enabled:true,fn:fn,alt:opt.alt||[]});this.__cache__=null;};Ruler.prototype.enable=function(list,ignoreInvalid){if(!Array.isArray(list)){list=[list];}
var result=[];list.forEach(function(name){var idx=this.__find__(name);if(idx<0){if(ignoreInvalid){return;}
throw new Error('Rules manager: invalid rule name '+name);}
this.__rules__[idx].enabled=true;result.push(name);},this);this.__cache__=null;return result;};Ruler.prototype.enableOnly=function(list,ignoreInvalid){if(!Array.isArray(list)){list=[list];}
this.__rules__.forEach(function(rule){rule.enabled=false;});this.enable(list,ignoreInvalid);};Ruler.prototype.disable=function(list,ignoreInvalid){if(!Array.isArray(list)){list=[list];}
var result=[];list.forEach(function(name){var idx=this.__find__(name);if(idx<0){if(ignoreInvalid){return;}
throw new Error('Rules manager: invalid rule name '+name);}
this.__rules__[idx].enabled=false;result.push(name);},this);this.__cache__=null;return result;};Ruler.prototype.getRules=function(chainName){if(this.__cache__===null){this.__compile__();}
return this.__cache__[chainName]||[];};module.exports=Ruler;},{}],18:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;module.exports=function blockquote(state,startLine,endLine,silent){var adjustTab,ch,i,initial,l,lastLineEmpty,lines,nextLine,offset,oldBMarks,oldBSCount,oldIndent,oldParentType,oldSCount,oldTShift,spaceAfterMarker,terminate,terminatorRules,token,wasOutdented,oldLineMax=state.lineMax,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(state.src.charCodeAt(pos++)!==0x3E){return false;}
if(silent){return true;}
initial=offset=state.sCount[startLine]+pos-(state.bMarks[startLine]+state.tShift[startLine]);if(state.src.charCodeAt(pos)===0x20){pos++;initial++;offset++;adjustTab=false;spaceAfterMarker=true;}else if(state.src.charCodeAt(pos)===0x09){spaceAfterMarker=true;if((state.bsCount[startLine]+offset)%4===3){pos++;initial++;offset++;adjustTab=false;}else{adjustTab=true;}}else{spaceAfterMarker=false;}
oldBMarks=[state.bMarks[startLine]];state.bMarks[startLine]=pos;while(pos<max){ch=state.src.charCodeAt(pos);if(isSpace(ch)){if(ch===0x09){offset+=4-(offset+state.bsCount[startLine]+(adjustTab?1:0))%4;}else{offset++;}}else{break;}
pos++;}
oldBSCount=[state.bsCount[startLine]];state.bsCount[startLine]=state.sCount[startLine]+1+(spaceAfterMarker?1:0);lastLineEmpty=pos>=max;oldSCount=[state.sCount[startLine]];state.sCount[startLine]=offset-initial;oldTShift=[state.tShift[startLine]];state.tShift[startLine]=pos-state.bMarks[startLine];terminatorRules=state.md.block.ruler.getRules('blockquote');oldParentType=state.parentType;state.parentType='blockquote';wasOutdented=false;for(nextLine=startLine+1;nextLine<endLine;nextLine++){if(state.sCount[nextLine]<state.blkIndent)wasOutdented=true;pos=state.bMarks[nextLine]+state.tShift[nextLine];max=state.eMarks[nextLine];if(pos>=max){break;}
if(state.src.charCodeAt(pos++)===0x3E&&!wasOutdented){initial=offset=state.sCount[nextLine]+pos-(state.bMarks[nextLine]+state.tShift[nextLine]);if(state.src.charCodeAt(pos)===0x20){pos++;initial++;offset++;adjustTab=false;spaceAfterMarker=true;}else if(state.src.charCodeAt(pos)===0x09){spaceAfterMarker=true;if((state.bsCount[nextLine]+offset)%4===3){pos++;initial++;offset++;adjustTab=false;}else{adjustTab=true;}}else{spaceAfterMarker=false;}
oldBMarks.push(state.bMarks[nextLine]);state.bMarks[nextLine]=pos;while(pos<max){ch=state.src.charCodeAt(pos);if(isSpace(ch)){if(ch===0x09){offset+=4-(offset+state.bsCount[nextLine]+(adjustTab?1:0))%4;}else{offset++;}}else{break;}
pos++;}
lastLineEmpty=pos>=max;oldBSCount.push(state.bsCount[nextLine]);state.bsCount[nextLine]=state.sCount[nextLine]+1+(spaceAfterMarker?1:0);oldSCount.push(state.sCount[nextLine]);state.sCount[nextLine]=offset-initial;oldTShift.push(state.tShift[nextLine]);state.tShift[nextLine]=pos-state.bMarks[nextLine];continue;}
if(lastLineEmpty){break;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){state.lineMax=nextLine;if(state.blkIndent!==0){oldBMarks.push(state.bMarks[nextLine]);oldBSCount.push(state.bsCount[nextLine]);oldTShift.push(state.tShift[nextLine]);oldSCount.push(state.sCount[nextLine]);state.sCount[nextLine]-=state.blkIndent;}
break;}
oldBMarks.push(state.bMarks[nextLine]);oldBSCount.push(state.bsCount[nextLine]);oldTShift.push(state.tShift[nextLine]);oldSCount.push(state.sCount[nextLine]);state.sCount[nextLine]=-1;}
oldIndent=state.blkIndent;state.blkIndent=0;token=state.push('blockquote_open','blockquote',1);token.markup='>';token.map=lines=[startLine,0];state.md.block.tokenize(state,startLine,nextLine);token=state.push('blockquote_close','blockquote',-1);token.markup='>';state.lineMax=oldLineMax;state.parentType=oldParentType;lines[1]=state.line;for(i=0;i<oldTShift.length;i++){state.bMarks[i+startLine]=oldBMarks[i];state.tShift[i+startLine]=oldTShift[i];state.sCount[i+startLine]=oldSCount[i];state.bsCount[i+startLine]=oldBSCount[i];}
state.blkIndent=oldIndent;return true;};},{"../common/utils":4}],19:[function(require,module,exports){'use strict';module.exports=function code(state,startLine,endLine){var nextLine,last,token;if(state.sCount[startLine]-state.blkIndent<4){return false;}
last=nextLine=startLine+1;while(nextLine<endLine){if(state.isEmpty(nextLine)){nextLine++;continue;}
if(state.sCount[nextLine]-state.blkIndent>=4){nextLine++;last=nextLine;continue;}
break;}
state.line=last;token=state.push('code_block','code',0);token.content=state.getLines(startLine,last,4+state.blkIndent,true);token.map=[startLine,state.line];return true;};},{}],20:[function(require,module,exports){'use strict';module.exports=function fence(state,startLine,endLine,silent){var marker,len,params,nextLine,mem,token,markup,haveEndMarker=false,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(pos+3>max){return false;}
marker=state.src.charCodeAt(pos);if(marker!==0x7E&&marker!==0x60){return false;}
mem=pos;pos=state.skipChars(pos,marker);len=pos-mem;if(len<3){return false;}
markup=state.src.slice(mem,pos);params=state.src.slice(pos,max);if(params.indexOf(String.fromCharCode(marker))>=0){return false;}
if(silent){return true;}
nextLine=startLine;for(;;){nextLine++;if(nextLine>=endLine){break;}
pos=mem=state.bMarks[nextLine]+state.tShift[nextLine];max=state.eMarks[nextLine];if(pos<max&&state.sCount[nextLine]<state.blkIndent){break;}
if(state.src.charCodeAt(pos)!==marker){continue;}
if(state.sCount[nextLine]-state.blkIndent>=4){continue;}
pos=state.skipChars(pos,marker);if(pos-mem<len){continue;}
pos=state.skipSpaces(pos);if(pos<max){continue;}
haveEndMarker=true;break;}
len=state.sCount[startLine];state.line=nextLine+(haveEndMarker?1:0);token=state.push('fence','code',0);token.info=params;token.content=state.getLines(startLine+1,nextLine,len,true);token.markup=markup;token.map=[startLine,state.line];return true;};},{}],21:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;module.exports=function heading(state,startLine,endLine,silent){var ch,level,tmp,token,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
ch=state.src.charCodeAt(pos);if(ch!==0x23||pos>=max){return false;}
level=1;ch=state.src.charCodeAt(++pos);while(ch===0x23&&pos<max&&level<=6){level++;ch=state.src.charCodeAt(++pos);}
if(level>6||(pos<max&&!isSpace(ch))){return false;}
if(silent){return true;}
max=state.skipSpacesBack(max,pos);tmp=state.skipCharsBack(max,0x23,pos);if(tmp>pos&&isSpace(state.src.charCodeAt(tmp-1))){max=tmp;}
state.line=startLine+1;token=state.push('heading_open','h'+String(level),1);token.markup='########'.slice(0,level);token.map=[startLine,state.line];token=state.push('inline','',0);token.content=state.src.slice(pos,max).trim();token.map=[startLine,state.line];token.children=[];token=state.push('heading_close','h'+String(level),-1);token.markup='########'.slice(0,level);return true;};},{"../common/utils":4}],22:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;module.exports=function hr(state,startLine,endLine,silent){var marker,cnt,ch,token,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
marker=state.src.charCodeAt(pos++);if(marker!==0x2A&&marker!==0x2D&&marker!==0x5F){return false;}
cnt=1;while(pos<max){ch=state.src.charCodeAt(pos++);if(ch!==marker&&!isSpace(ch)){return false;}
if(ch===marker){cnt++;}}
if(cnt<3){return false;}
if(silent){return true;}
state.line=startLine+1;token=state.push('hr','hr',0);token.map=[startLine,state.line];token.markup=Array(cnt+1).join(String.fromCharCode(marker));return true;};},{"../common/utils":4}],23:[function(require,module,exports){'use strict';var block_names=require('../common/html_blocks');var HTML_OPEN_CLOSE_TAG_RE=require('../common/html_re').HTML_OPEN_CLOSE_TAG_RE;var HTML_SEQUENCES=[[/^<(script|pre|style)(?=(\s|>|$))/i,/<\/(script|pre|style)>/i,true],[/^<!--/,/-->/,true],[/^<\?/,/\?>/,true],[/^<![A-Z]/,/>/,true],[/^<!\[CDATA\[/,/\]\]>/,true],[new RegExp('^</?('+block_names.join('|')+')(?=(\\s|/?>|$))','i'),/^$/,true],[new RegExp(HTML_OPEN_CLOSE_TAG_RE.source+'\\s*$'),/^$/,false]];module.exports=function html_block(state,startLine,endLine,silent){var i,nextLine,token,lineText,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(!state.md.options.html){return false;}
if(state.src.charCodeAt(pos)!==0x3C){return false;}
lineText=state.src.slice(pos,max);for(i=0;i<HTML_SEQUENCES.length;i++){if(HTML_SEQUENCES[i][0].test(lineText)){break;}}
if(i===HTML_SEQUENCES.length){return false;}
if(silent){return HTML_SEQUENCES[i][2];}
nextLine=startLine+1;if(!HTML_SEQUENCES[i][1].test(lineText)){for(;nextLine<endLine;nextLine++){if(state.sCount[nextLine]<state.blkIndent){break;}
pos=state.bMarks[nextLine]+state.tShift[nextLine];max=state.eMarks[nextLine];lineText=state.src.slice(pos,max);if(HTML_SEQUENCES[i][1].test(lineText)){if(lineText.length!==0){nextLine++;}
break;}}}
state.line=nextLine;token=state.push('html_block','',0);token.map=[startLine,nextLine];token.content=state.getLines(startLine,nextLine,state.blkIndent,true);return true;};},{"../common/html_blocks":2,"../common/html_re":3}],24:[function(require,module,exports){'use strict';module.exports=function lheading(state,startLine,endLine){var content,terminate,i,l,token,pos,max,level,marker,nextLine=startLine+1,oldParentType,terminatorRules=state.md.block.ruler.getRules('paragraph');if(state.sCount[startLine]-state.blkIndent>=4){return false;}
oldParentType=state.parentType;state.parentType='paragraph';for(;nextLine<endLine&&!state.isEmpty(nextLine);nextLine++){if(state.sCount[nextLine]-state.blkIndent>3){continue;}
if(state.sCount[nextLine]>=state.blkIndent){pos=state.bMarks[nextLine]+state.tShift[nextLine];max=state.eMarks[nextLine];if(pos<max){marker=state.src.charCodeAt(pos);if(marker===0x2D||marker===0x3D){pos=state.skipChars(pos,marker);pos=state.skipSpaces(pos);if(pos>=max){level=(marker===0x3D?1:2);break;}}}}
if(state.sCount[nextLine]<0){continue;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){break;}}
if(!level){return false;}
content=state.getLines(startLine,nextLine,state.blkIndent,false).trim();state.line=nextLine+1;token=state.push('heading_open','h'+String(level),1);token.markup=String.fromCharCode(marker);token.map=[startLine,state.line];token=state.push('inline','',0);token.content=content;token.map=[startLine,state.line-1];token.children=[];token=state.push('heading_close','h'+String(level),-1);token.markup=String.fromCharCode(marker);state.parentType=oldParentType;return true;};},{}],25:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;function skipBulletListMarker(state,startLine){var marker,pos,max,ch;pos=state.bMarks[startLine]+state.tShift[startLine];max=state.eMarks[startLine];marker=state.src.charCodeAt(pos++);if(marker!==0x2A&&marker!==0x2D&&marker!==0x2B){return-1;}
if(pos<max){ch=state.src.charCodeAt(pos);if(!isSpace(ch)){return-1;}}
return pos;}
function skipOrderedListMarker(state,startLine){var ch,start=state.bMarks[startLine]+state.tShift[startLine],pos=start,max=state.eMarks[startLine];if(pos+1>=max){return-1;}
ch=state.src.charCodeAt(pos++);if(ch<0x30||ch>0x39){return-1;}
for(;;){if(pos>=max){return-1;}
ch=state.src.charCodeAt(pos++);if(ch>=0x30&&ch<=0x39){if(pos-start>=10){return-1;}
continue;}
if(ch===0x29||ch===0x2e){break;}
return-1;}
if(pos<max){ch=state.src.charCodeAt(pos);if(!isSpace(ch)){return-1;}}
return pos;}
function markTightParagraphs(state,idx){var i,l,level=state.level+2;for(i=idx+2,l=state.tokens.length-2;i<l;i++){if(state.tokens[i].level===level&&state.tokens[i].type==='paragraph_open'){state.tokens[i+2].hidden=true;state.tokens[i].hidden=true;i+=2;}}}
module.exports=function list(state,startLine,endLine,silent){var ch,contentStart,i,indent,indentAfterMarker,initial,isOrdered,itemLines,l,listLines,listTokIdx,markerCharCode,markerValue,max,nextLine,offset,oldIndent,oldLIndent,oldParentType,oldTShift,oldTight,pos,posAfterMarker,prevEmptyEnd,start,terminate,terminatorRules,token,isTerminatingParagraph=false,tight=true;if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(silent&&state.parentType==='paragraph'){if(state.tShift[startLine]>=state.blkIndent){isTerminatingParagraph=true;}}
if((posAfterMarker=skipOrderedListMarker(state,startLine))>=0){isOrdered=true;start=state.bMarks[startLine]+state.tShift[startLine];markerValue=Number(state.src.substr(start,posAfterMarker-start-1));if(isTerminatingParagraph&&markerValue!==1)return false;}else if((posAfterMarker=skipBulletListMarker(state,startLine))>=0){isOrdered=false;}else{return false;}
if(isTerminatingParagraph){if(state.skipSpaces(posAfterMarker)>=state.eMarks[startLine])return false;}
markerCharCode=state.src.charCodeAt(posAfterMarker-1);if(silent){return true;}
listTokIdx=state.tokens.length;if(isOrdered){token=state.push('ordered_list_open','ol',1);if(markerValue!==1){token.attrs=[['start',markerValue]];}}else{token=state.push('bullet_list_open','ul',1);}
token.map=listLines=[startLine,0];token.markup=String.fromCharCode(markerCharCode);nextLine=startLine;prevEmptyEnd=false;terminatorRules=state.md.block.ruler.getRules('list');oldParentType=state.parentType;state.parentType='list';while(nextLine<endLine){pos=posAfterMarker;max=state.eMarks[nextLine];initial=offset=state.sCount[nextLine]+posAfterMarker-(state.bMarks[startLine]+state.tShift[startLine]);while(pos<max){ch=state.src.charCodeAt(pos);if(ch===0x09){offset+=4-(offset+state.bsCount[nextLine])%4;}else if(ch===0x20){offset++;}else{break;}
pos++;}
contentStart=pos;if(contentStart>=max){indentAfterMarker=1;}else{indentAfterMarker=offset-initial;}
if(indentAfterMarker>4){indentAfterMarker=1;}
indent=initial+indentAfterMarker;token=state.push('list_item_open','li',1);token.markup=String.fromCharCode(markerCharCode);token.map=itemLines=[startLine,0];oldIndent=state.blkIndent;oldTight=state.tight;oldTShift=state.tShift[startLine];oldLIndent=state.sCount[startLine];state.blkIndent=indent;state.tight=true;state.tShift[startLine]=contentStart-state.bMarks[startLine];state.sCount[startLine]=offset;if(contentStart>=max&&state.isEmpty(startLine+1)){state.line=Math.min(state.line+2,endLine);}else{state.md.block.tokenize(state,startLine,endLine,true);}
if(!state.tight||prevEmptyEnd){tight=false;}
prevEmptyEnd=(state.line-startLine)>1&&state.isEmpty(state.line-1);state.blkIndent=oldIndent;state.tShift[startLine]=oldTShift;state.sCount[startLine]=oldLIndent;state.tight=oldTight;token=state.push('list_item_close','li',-1);token.markup=String.fromCharCode(markerCharCode);nextLine=startLine=state.line;itemLines[1]=nextLine;contentStart=state.bMarks[startLine];if(nextLine>=endLine){break;}
if(state.sCount[nextLine]<state.blkIndent){break;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){break;}
if(isOrdered){posAfterMarker=skipOrderedListMarker(state,nextLine);if(posAfterMarker<0){break;}}else{posAfterMarker=skipBulletListMarker(state,nextLine);if(posAfterMarker<0){break;}}
if(markerCharCode!==state.src.charCodeAt(posAfterMarker-1)){break;}}
if(isOrdered){token=state.push('ordered_list_close','ol',-1);}else{token=state.push('bullet_list_close','ul',-1);}
token.markup=String.fromCharCode(markerCharCode);listLines[1]=nextLine;state.line=nextLine;state.parentType=oldParentType;if(tight){markTightParagraphs(state,listTokIdx);}
return true;};},{"../common/utils":4}],26:[function(require,module,exports){'use strict';module.exports=function paragraph(state,startLine){var content,terminate,i,l,token,oldParentType,nextLine=startLine+1,terminatorRules=state.md.block.ruler.getRules('paragraph'),endLine=state.lineMax;oldParentType=state.parentType;state.parentType='paragraph';for(;nextLine<endLine&&!state.isEmpty(nextLine);nextLine++){if(state.sCount[nextLine]-state.blkIndent>3){continue;}
if(state.sCount[nextLine]<0){continue;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){break;}}
content=state.getLines(startLine,nextLine,state.blkIndent,false).trim();state.line=nextLine;token=state.push('paragraph_open','p',1);token.map=[startLine,state.line];token=state.push('inline','',0);token.content=content;token.map=[startLine,state.line];token.children=[];token=state.push('paragraph_close','p',-1);state.parentType=oldParentType;return true;};},{}],27:[function(require,module,exports){'use strict';var normalizeReference=require('../common/utils').normalizeReference;var isSpace=require('../common/utils').isSpace;module.exports=function reference(state,startLine,_endLine,silent){var ch,destEndPos,destEndLineNo,endLine,href,i,l,label,labelEnd,oldParentType,res,start,str,terminate,terminatorRules,title,lines=0,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine],nextLine=startLine+1;if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(state.src.charCodeAt(pos)!==0x5B){return false;}
while(++pos<max){if(state.src.charCodeAt(pos)===0x5D&&state.src.charCodeAt(pos-1)!==0x5C){if(pos+1===max){return false;}
if(state.src.charCodeAt(pos+1)!==0x3A){return false;}
break;}}
endLine=state.lineMax;terminatorRules=state.md.block.ruler.getRules('reference');oldParentType=state.parentType;state.parentType='reference';for(;nextLine<endLine&&!state.isEmpty(nextLine);nextLine++){if(state.sCount[nextLine]-state.blkIndent>3){continue;}
if(state.sCount[nextLine]<0){continue;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){break;}}
str=state.getLines(startLine,nextLine,state.blkIndent,false).trim();max=str.length;for(pos=1;pos<max;pos++){ch=str.charCodeAt(pos);if(ch===0x5B){return false;}else if(ch===0x5D){labelEnd=pos;break;}else if(ch===0x0A){lines++;}else if(ch===0x5C){pos++;if(pos<max&&str.charCodeAt(pos)===0x0A){lines++;}}}
if(labelEnd<0||str.charCodeAt(labelEnd+1)!==0x3A){return false;}
for(pos=labelEnd+2;pos<max;pos++){ch=str.charCodeAt(pos);if(ch===0x0A){lines++;}else if(isSpace(ch)){}else{break;}}
res=state.md.helpers.parseLinkDestination(str,pos,max);if(!res.ok){return false;}
href=state.md.normalizeLink(res.str);if(!state.md.validateLink(href)){return false;}
pos=res.pos;lines+=res.lines;destEndPos=pos;destEndLineNo=lines;start=pos;for(;pos<max;pos++){ch=str.charCodeAt(pos);if(ch===0x0A){lines++;}else if(isSpace(ch)){}else{break;}}
res=state.md.helpers.parseLinkTitle(str,pos,max);if(pos<max&&start!==pos&&res.ok){title=res.str;pos=res.pos;lines+=res.lines;}else{title='';pos=destEndPos;lines=destEndLineNo;}
while(pos<max){ch=str.charCodeAt(pos);if(!isSpace(ch)){break;}
pos++;}
if(pos<max&&str.charCodeAt(pos)!==0x0A){if(title){title='';pos=destEndPos;lines=destEndLineNo;while(pos<max){ch=str.charCodeAt(pos);if(!isSpace(ch)){break;}
pos++;}}}
if(pos<max&&str.charCodeAt(pos)!==0x0A){return false;}
label=normalizeReference(str.slice(1,labelEnd));if(!label){return false;}
if(silent){return true;}
if(typeof state.env.references==='undefined'){state.env.references={};}
if(typeof state.env.references[label]==='undefined'){state.env.references[label]={title:title,href:href};}
state.parentType=oldParentType;state.line=startLine+lines+1;return true;};},{"../common/utils":4}],28:[function(require,module,exports){'use strict';var Token=require('../token');var isSpace=require('../common/utils').isSpace;function StateBlock(src,md,env,tokens){var ch,s,start,pos,len,indent,offset,indent_found;this.src=src;this.md=md;this.env=env;this.tokens=tokens;this.bMarks=[];this.eMarks=[];this.tShift=[];this.sCount=[];this.bsCount=[];this.blkIndent=0;this.line=0;this.lineMax=0;this.tight=false;this.ddIndent=-1;this.parentType='root';this.level=0;this.result='';s=this.src;indent_found=false;for(start=pos=indent=offset=0,len=s.length;pos<len;pos++){ch=s.charCodeAt(pos);if(!indent_found){if(isSpace(ch)){indent++;if(ch===0x09){offset+=4-offset%4;}else{offset++;}
continue;}else{indent_found=true;}}
if(ch===0x0A||pos===len-1){if(ch!==0x0A){pos++;}
this.bMarks.push(start);this.eMarks.push(pos);this.tShift.push(indent);this.sCount.push(offset);this.bsCount.push(0);indent_found=false;indent=0;offset=0;start=pos+1;}}
this.bMarks.push(s.length);this.eMarks.push(s.length);this.tShift.push(0);this.sCount.push(0);this.bsCount.push(0);this.lineMax=this.bMarks.length-1;}
StateBlock.prototype.push=function(type,tag,nesting){var token=new Token(type,tag,nesting);token.block=true;if(nesting<0){this.level--;}
token.level=this.level;if(nesting>0){this.level++;}
this.tokens.push(token);return token;};StateBlock.prototype.isEmpty=function isEmpty(line){return this.bMarks[line]+this.tShift[line]>=this.eMarks[line];};StateBlock.prototype.skipEmptyLines=function skipEmptyLines(from){for(var max=this.lineMax;from<max;from++){if(this.bMarks[from]+this.tShift[from]<this.eMarks[from]){break;}}
return from;};StateBlock.prototype.skipSpaces=function skipSpaces(pos){var ch;for(var max=this.src.length;pos<max;pos++){ch=this.src.charCodeAt(pos);if(!isSpace(ch)){break;}}
return pos;};StateBlock.prototype.skipSpacesBack=function skipSpacesBack(pos,min){if(pos<=min){return pos;}
while(pos>min){if(!isSpace(this.src.charCodeAt(--pos))){return pos+1;}}
return pos;};StateBlock.prototype.skipChars=function skipChars(pos,code){for(var max=this.src.length;pos<max;pos++){if(this.src.charCodeAt(pos)!==code){break;}}
return pos;};StateBlock.prototype.skipCharsBack=function skipCharsBack(pos,code,min){if(pos<=min){return pos;}
while(pos>min){if(code!==this.src.charCodeAt(--pos)){return pos+1;}}
return pos;};StateBlock.prototype.getLines=function getLines(begin,end,indent,keepLastLF){var i,lineIndent,ch,first,last,queue,lineStart,line=begin;if(begin>=end){return'';}
queue=new Array(end-begin);for(i=0;line<end;line++,i++){lineIndent=0;lineStart=first=this.bMarks[line];if(line+1<end||keepLastLF){last=this.eMarks[line]+1;}else{last=this.eMarks[line];}
while(first<last&&lineIndent<indent){ch=this.src.charCodeAt(first);if(isSpace(ch)){if(ch===0x09){lineIndent+=4-(lineIndent+this.bsCount[line])%4;}else{lineIndent++;}}else if(first-lineStart<this.tShift[line]){lineIndent++;}else{break;}
first++;}
if(lineIndent>indent){queue[i]=new Array(lineIndent-indent+1).join(' ')+this.src.slice(first,last);}else{queue[i]=this.src.slice(first,last);}}
return queue.join('');};StateBlock.prototype.Token=Token;module.exports=StateBlock;},{"../common/utils":4,"../token":51}],29:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;function getLine(state,line){var pos=state.bMarks[line]+state.blkIndent,max=state.eMarks[line];return state.src.substr(pos,max-pos);}
function escapedSplit(str){var result=[],pos=0,max=str.length,ch,escapes=0,lastPos=0,backTicked=false,lastBackTick=0;ch=str.charCodeAt(pos);while(pos<max){if(ch===0x60){if(backTicked){backTicked=false;lastBackTick=pos;}else if(escapes%2===0){backTicked=true;lastBackTick=pos;}}else if(ch===0x7c&&(escapes%2===0)&&!backTicked){result.push(str.substring(lastPos,pos));lastPos=pos+1;}
if(ch===0x5c){escapes++;}else{escapes=0;}
pos++;if(pos===max&&backTicked){backTicked=false;pos=lastBackTick+1;}
ch=str.charCodeAt(pos);}
result.push(str.substring(lastPos));return result;}
module.exports=function table(state,startLine,endLine,silent){var ch,lineText,pos,i,nextLine,columns,columnCount,token,aligns,t,tableLines,tbodyLines;if(startLine+2>endLine){return false;}
nextLine=startLine+1;if(state.sCount[nextLine]<state.blkIndent){return false;}
if(state.sCount[nextLine]-state.blkIndent>=4){return false;}
pos=state.bMarks[nextLine]+state.tShift[nextLine];if(pos>=state.eMarks[nextLine]){return false;}
ch=state.src.charCodeAt(pos++);if(ch!==0x7C&&ch!==0x2D&&ch!==0x3A){return false;}
while(pos<state.eMarks[nextLine]){ch=state.src.charCodeAt(pos);if(ch!==0x7C&&ch!==0x2D&&ch!==0x3A&&!isSpace(ch)){return false;}
pos++;}
lineText=getLine(state,startLine+1);columns=lineText.split('|');aligns=[];for(i=0;i<columns.length;i++){t=columns[i].trim();if(!t){if(i===0||i===columns.length-1){continue;}else{return false;}}
if(!/^:?-+:?$/.test(t)){return false;}
if(t.charCodeAt(t.length-1)===0x3A){aligns.push(t.charCodeAt(0)===0x3A?'center':'right');}else if(t.charCodeAt(0)===0x3A){aligns.push('left');}else{aligns.push('');}}
lineText=getLine(state,startLine).trim();if(lineText.indexOf('|')===-1){return false;}
if(state.sCount[startLine]-state.blkIndent>=4){return false;}
columns=escapedSplit(lineText.replace(/^\||\|$/g,''));columnCount=columns.length;if(columnCount>aligns.length){return false;}
if(silent){return true;}
token=state.push('table_open','table',1);token.map=tableLines=[startLine,0];token=state.push('thead_open','thead',1);token.map=[startLine,startLine+1];token=state.push('tr_open','tr',1);token.map=[startLine,startLine+1];for(i=0;i<columns.length;i++){token=state.push('th_open','th',1);token.map=[startLine,startLine+1];if(aligns[i]){token.attrs=[['style','text-align:'+aligns[i]]];}
token=state.push('inline','',0);token.content=columns[i].trim();token.map=[startLine,startLine+1];token.children=[];token=state.push('th_close','th',-1);}
token=state.push('tr_close','tr',-1);token=state.push('thead_close','thead',-1);token=state.push('tbody_open','tbody',1);token.map=tbodyLines=[startLine+2,0];for(nextLine=startLine+2;nextLine<endLine;nextLine++){if(state.sCount[nextLine]<state.blkIndent){break;}
lineText=getLine(state,nextLine).trim();if(lineText.indexOf('|')===-1){break;}
if(state.sCount[nextLine]-state.blkIndent>=4){break;}
columns=escapedSplit(lineText.replace(/^\||\|$/g,''));token=state.push('tr_open','tr',1);for(i=0;i<columnCount;i++){token=state.push('td_open','td',1);if(aligns[i]){token.attrs=[['style','text-align:'+aligns[i]]];}
token=state.push('inline','',0);token.content=columns[i]?columns[i].trim():'';token.children=[];token=state.push('td_close','td',-1);}
token=state.push('tr_close','tr',-1);}
token=state.push('tbody_close','tbody',-1);token=state.push('table_close','table',-1);tableLines[1]=tbodyLines[1]=nextLine;state.line=nextLine;return true;};},{"../common/utils":4}],30:[function(require,module,exports){'use strict';module.exports=function block(state){var token;if(state.inlineMode){token=new state.Token('inline','',0);token.content=state.src;token.map=[0,1];token.children=[];state.tokens.push(token);}else{state.md.block.parse(state.src,state.md,state.env,state.tokens);}};},{}],31:[function(require,module,exports){'use strict';module.exports=function inline(state){var tokens=state.tokens,tok,i,l;for(i=0,l=tokens.length;i<l;i++){tok=tokens[i];if(tok.type==='inline'){state.md.inline.parse(tok.content,state.md,state.env,tok.children);}}};},{}],32:[function(require,module,exports){'use strict';var arrayReplaceAt=require('../common/utils').arrayReplaceAt;function isLinkOpen(str){return/^<a[>\s]/i.test(str);}
function isLinkClose(str){return/^<\/a\s*>/i.test(str);}
module.exports=function linkify(state){var i,j,l,tokens,token,currentToken,nodes,ln,text,pos,lastPos,level,htmlLinkLevel,url,fullUrl,urlText,blockTokens=state.tokens,links;if(!state.md.options.linkify){return;}
for(j=0,l=blockTokens.length;j<l;j++){if(blockTokens[j].type!=='inline'||!state.md.linkify.pretest(blockTokens[j].content)){continue;}
tokens=blockTokens[j].children;htmlLinkLevel=0;for(i=tokens.length-1;i>=0;i--){currentToken=tokens[i];if(currentToken.type==='link_close'){i--;while(tokens[i].level!==currentToken.level&&tokens[i].type!=='link_open'){i--;}
continue;}
if(currentToken.type==='html_inline'){if(isLinkOpen(currentToken.content)&&htmlLinkLevel>0){htmlLinkLevel--;}
if(isLinkClose(currentToken.content)){htmlLinkLevel++;}}
if(htmlLinkLevel>0){continue;}
if(currentToken.type==='text'&&state.md.linkify.test(currentToken.content)){text=currentToken.content;links=state.md.linkify.match(text);nodes=[];level=currentToken.level;lastPos=0;for(ln=0;ln<links.length;ln++){url=links[ln].url;fullUrl=state.md.normalizeLink(url);if(!state.md.validateLink(fullUrl)){continue;}
urlText=links[ln].text;if(!links[ln].schema){urlText=state.md.normalizeLinkText('http://'+urlText).replace(/^http:\/\//,'');}else if(links[ln].schema==='mailto:'&&!/^mailto:/i.test(urlText)){urlText=state.md.normalizeLinkText('mailto:'+urlText).replace(/^mailto:/,'');}else{urlText=state.md.normalizeLinkText(urlText);}
pos=links[ln].index;if(pos>lastPos){token=new state.Token('text','',0);token.content=text.slice(lastPos,pos);token.level=level;nodes.push(token);}
token=new state.Token('link_open','a',1);token.attrs=[['href',fullUrl]];token.level=level++;token.markup='linkify';token.info='auto';nodes.push(token);token=new state.Token('text','',0);token.content=urlText;token.level=level;nodes.push(token);token=new state.Token('link_close','a',-1);token.level=--level;token.markup='linkify';token.info='auto';nodes.push(token);lastPos=links[ln].lastIndex;}
if(lastPos<text.length){token=new state.Token('text','',0);token.content=text.slice(lastPos);token.level=level;nodes.push(token);}
blockTokens[j].children=tokens=arrayReplaceAt(tokens,i,nodes);}}}};},{"../common/utils":4}],33:[function(require,module,exports){'use strict';var NEWLINES_RE=/\r[\n\u0085]?|[\u2424\u2028\u0085]/g;var NULL_RE=/\u0000/g;module.exports=function inline(state){var str;str=state.src.replace(NEWLINES_RE,'\n');str=str.replace(NULL_RE,'\uFFFD');state.src=str;};},{}],34:[function(require,module,exports){'use strict';var RARE_RE=/\+-|\.\.|\?\?\?\?|!!!!|,,|--/;var SCOPED_ABBR_TEST_RE=/\((c|tm|r|p)\)/i;var SCOPED_ABBR_RE=/\((c|tm|r|p)\)/ig;var SCOPED_ABBR={c:'Â©',r:'Â®',p:'Â§',tm:'â„¢'};function replaceFn(match,name){return SCOPED_ABBR[name.toLowerCase()];}
function replace_scoped(inlineTokens){var i,token,inside_autolink=0;for(i=inlineTokens.length-1;i>=0;i--){token=inlineTokens[i];if(token.type==='text'&&!inside_autolink){token.content=token.content.replace(SCOPED_ABBR_RE,replaceFn);}
if(token.type==='link_open'&&token.info==='auto'){inside_autolink--;}
if(token.type==='link_close'&&token.info==='auto'){inside_autolink++;}}}
function replace_rare(inlineTokens){var i,token,inside_autolink=0;for(i=inlineTokens.length-1;i>=0;i--){token=inlineTokens[i];if(token.type==='text'&&!inside_autolink){if(RARE_RE.test(token.content)){token.content=token.content.replace(/\+-/g,'Â±').replace(/\.{2,}/g,'â€¦').replace(/([?!])â€¦/g,'$1..').replace(/([?!]){4,}/g,'$1$1$1').replace(/,{2,}/g,',').replace(/(^|[^-])---([^-]|$)/mg,'$1\u2014$2').replace(/(^|\s)--(\s|$)/mg,'$1\u2013$2').replace(/(^|[^-\s])--([^-\s]|$)/mg,'$1\u2013$2');}}
if(token.type==='link_open'&&token.info==='auto'){inside_autolink--;}
if(token.type==='link_close'&&token.info==='auto'){inside_autolink++;}}}
module.exports=function replace(state){var blkIdx;if(!state.md.options.typographer){return;}
for(blkIdx=state.tokens.length-1;blkIdx>=0;blkIdx--){if(state.tokens[blkIdx].type!=='inline'){continue;}
if(SCOPED_ABBR_TEST_RE.test(state.tokens[blkIdx].content)){replace_scoped(state.tokens[blkIdx].children);}
if(RARE_RE.test(state.tokens[blkIdx].content)){replace_rare(state.tokens[blkIdx].children);}}};},{}],35:[function(require,module,exports){'use strict';var isWhiteSpace=require('../common/utils').isWhiteSpace;var isPunctChar=require('../common/utils').isPunctChar;var isMdAsciiPunct=require('../common/utils').isMdAsciiPunct;var QUOTE_TEST_RE=/['"]/;var QUOTE_RE=/['"]/g;var APOSTROPHE='\u2019';function replaceAt(str,index,ch){return str.substr(0,index)+ch+str.substr(index+1);}
function process_inlines(tokens,state){var i,token,text,t,pos,max,thisLevel,item,lastChar,nextChar,isLastPunctChar,isNextPunctChar,isLastWhiteSpace,isNextWhiteSpace,canOpen,canClose,j,isSingle,stack,openQuote,closeQuote;stack=[];for(i=0;i<tokens.length;i++){token=tokens[i];thisLevel=tokens[i].level;for(j=stack.length-1;j>=0;j--){if(stack[j].level<=thisLevel){break;}}
stack.length=j+1;if(token.type!=='text'){continue;}
text=token.content;pos=0;max=text.length;OUTER:while(pos<max){QUOTE_RE.lastIndex=pos;t=QUOTE_RE.exec(text);if(!t){break;}
canOpen=canClose=true;pos=t.index+1;isSingle=(t[0]==="'");lastChar=0x20;if(t.index-1>=0){lastChar=text.charCodeAt(t.index-1);}else{for(j=i-1;j>=0;j--){if(tokens[j].type==='softbreak'||tokens[j].type==='hardbreak')break;if(tokens[j].type!=='text')continue;lastChar=tokens[j].content.charCodeAt(tokens[j].content.length-1);break;}}
nextChar=0x20;if(pos<max){nextChar=text.charCodeAt(pos);}else{for(j=i+1;j<tokens.length;j++){if(tokens[j].type==='softbreak'||tokens[j].type==='hardbreak')break;if(tokens[j].type!=='text')continue;nextChar=tokens[j].content.charCodeAt(0);break;}}
isLastPunctChar=isMdAsciiPunct(lastChar)||isPunctChar(String.fromCharCode(lastChar));isNextPunctChar=isMdAsciiPunct(nextChar)||isPunctChar(String.fromCharCode(nextChar));isLastWhiteSpace=isWhiteSpace(lastChar);isNextWhiteSpace=isWhiteSpace(nextChar);if(isNextWhiteSpace){canOpen=false;}else if(isNextPunctChar){if(!(isLastWhiteSpace||isLastPunctChar)){canOpen=false;}}
if(isLastWhiteSpace){canClose=false;}else if(isLastPunctChar){if(!(isNextWhiteSpace||isNextPunctChar)){canClose=false;}}
if(nextChar===0x22&&t[0]==='"'){if(lastChar>=0x30&&lastChar<=0x39){canClose=canOpen=false;}}
if(canOpen&&canClose){canOpen=false;canClose=isNextPunctChar;}
if(!canOpen&&!canClose){if(isSingle){token.content=replaceAt(token.content,t.index,APOSTROPHE);}
continue;}
if(canClose){for(j=stack.length-1;j>=0;j--){item=stack[j];if(stack[j].level<thisLevel){break;}
if(item.single===isSingle&&stack[j].level===thisLevel){item=stack[j];if(isSingle){openQuote=state.md.options.quotes[2];closeQuote=state.md.options.quotes[3];}else{openQuote=state.md.options.quotes[0];closeQuote=state.md.options.quotes[1];}
token.content=replaceAt(token.content,t.index,closeQuote);tokens[item.token].content=replaceAt(tokens[item.token].content,item.pos,openQuote);pos+=closeQuote.length-1;if(item.token===i){pos+=openQuote.length-1;}
text=token.content;max=text.length;stack.length=j;continue OUTER;}}}
if(canOpen){stack.push({token:i,pos:t.index,single:isSingle,level:thisLevel});}else if(canClose&&isSingle){token.content=replaceAt(token.content,t.index,APOSTROPHE);}}}}
module.exports=function smartquotes(state){var blkIdx;if(!state.md.options.typographer){return;}
for(blkIdx=state.tokens.length-1;blkIdx>=0;blkIdx--){if(state.tokens[blkIdx].type!=='inline'||!QUOTE_TEST_RE.test(state.tokens[blkIdx].content)){continue;}
process_inlines(state.tokens[blkIdx].children,state);}};},{"../common/utils":4}],36:[function(require,module,exports){'use strict';var Token=require('../token');function StateCore(src,md,env){this.src=src;this.env=env;this.tokens=[];this.inlineMode=false;this.md=md;}
StateCore.prototype.Token=Token;module.exports=StateCore;},{"../token":51}],37:[function(require,module,exports){'use strict';var EMAIL_RE=/^<([a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)>/;var AUTOLINK_RE=/^<([a-zA-Z][a-zA-Z0-9+.\-]{1,31}):([^<>\x00-\x20]*)>/;module.exports=function autolink(state,silent){var tail,linkMatch,emailMatch,url,fullUrl,token,pos=state.pos;if(state.src.charCodeAt(pos)!==0x3C){return false;}
tail=state.src.slice(pos);if(tail.indexOf('>')<0){return false;}
if(AUTOLINK_RE.test(tail)){linkMatch=tail.match(AUTOLINK_RE);url=linkMatch[0].slice(1,-1);fullUrl=state.md.normalizeLink(url);if(!state.md.validateLink(fullUrl)){return false;}
if(!silent){token=state.push('link_open','a',1);token.attrs=[['href',fullUrl]];token.markup='autolink';token.info='auto';token=state.push('text','',0);token.content=state.md.normalizeLinkText(url);token=state.push('link_close','a',-1);token.markup='autolink';token.info='auto';}
state.pos+=linkMatch[0].length;return true;}
if(EMAIL_RE.test(tail)){emailMatch=tail.match(EMAIL_RE);url=emailMatch[0].slice(1,-1);fullUrl=state.md.normalizeLink('mailto:'+url);if(!state.md.validateLink(fullUrl)){return false;}
if(!silent){token=state.push('link_open','a',1);token.attrs=[['href',fullUrl]];token.markup='autolink';token.info='auto';token=state.push('text','',0);token.content=state.md.normalizeLinkText(url);token=state.push('link_close','a',-1);token.markup='autolink';token.info='auto';}
state.pos+=emailMatch[0].length;return true;}
return false;};},{}],38:[function(require,module,exports){'use strict';module.exports=function backtick(state,silent){var start,max,marker,matchStart,matchEnd,token,pos=state.pos,ch=state.src.charCodeAt(pos);if(ch!==0x60){return false;}
start=pos;pos++;max=state.posMax;while(pos<max&&state.src.charCodeAt(pos)===0x60){pos++;}
marker=state.src.slice(start,pos);matchStart=matchEnd=pos;while((matchStart=state.src.indexOf('`',matchEnd))!==-1){matchEnd=matchStart+1;while(matchEnd<max&&state.src.charCodeAt(matchEnd)===0x60){matchEnd++;}
if(matchEnd-matchStart===marker.length){if(!silent){token=state.push('code_inline','code',0);token.markup=marker;token.content=state.src.slice(pos,matchStart).replace(/[ \n]+/g,' ').trim();}
state.pos=matchEnd;return true;}}
if(!silent){state.pending+=marker;}
state.pos+=marker.length;return true;};},{}],39:[function(require,module,exports){'use strict';module.exports=function link_pairs(state){var i,j,lastDelim,currDelim,delimiters=state.delimiters,max=state.delimiters.length;for(i=0;i<max;i++){lastDelim=delimiters[i];if(!lastDelim.close){continue;}
j=i-lastDelim.jump-1;while(j>=0){currDelim=delimiters[j];if(currDelim.open&&currDelim.marker===lastDelim.marker&&currDelim.end<0&&currDelim.level===lastDelim.level){var odd_match=(currDelim.close||lastDelim.open)&&typeof currDelim.length!=='undefined'&&typeof lastDelim.length!=='undefined'&&(currDelim.length+lastDelim.length)%3===0;if(!odd_match){lastDelim.jump=i-j;lastDelim.open=false;currDelim.end=i;currDelim.jump=0;break;}}
j-=currDelim.jump+1;}}};},{}],40:[function(require,module,exports){'use strict';module.exports.tokenize=function emphasis(state,silent){var i,scanned,token,start=state.pos,marker=state.src.charCodeAt(start);if(silent){return false;}
if(marker!==0x5F&&marker!==0x2A){return false;}
scanned=state.scanDelims(state.pos,marker===0x2A);for(i=0;i<scanned.length;i++){token=state.push('text','',0);token.content=String.fromCharCode(marker);state.delimiters.push({marker:marker,length:scanned.length,jump:i,token:state.tokens.length-1,level:state.level,end:-1,open:scanned.can_open,close:scanned.can_close});}
state.pos+=scanned.length;return true;};module.exports.postProcess=function emphasis(state){var i,startDelim,endDelim,token,ch,isStrong,delimiters=state.delimiters,max=state.delimiters.length;for(i=max-1;i>=0;i--){startDelim=delimiters[i];if(startDelim.marker!==0x5F&&startDelim.marker!==0x2A){continue;}
if(startDelim.end===-1){continue;}
endDelim=delimiters[startDelim.end];isStrong=i>0&&delimiters[i-1].end===startDelim.end+1&&delimiters[i-1].token===startDelim.token-1&&delimiters[startDelim.end+1].token===endDelim.token+1&&delimiters[i-1].marker===startDelim.marker;ch=String.fromCharCode(startDelim.marker);token=state.tokens[startDelim.token];token.type=isStrong?'strong_open':'em_open';token.tag=isStrong?'strong':'em';token.nesting=1;token.markup=isStrong?ch+ch:ch;token.content='';token=state.tokens[endDelim.token];token.type=isStrong?'strong_close':'em_close';token.tag=isStrong?'strong':'em';token.nesting=-1;token.markup=isStrong?ch+ch:ch;token.content='';if(isStrong){state.tokens[delimiters[i-1].token].content='';state.tokens[delimiters[startDelim.end+1].token].content='';i--;}}};},{}],41:[function(require,module,exports){'use strict';var entities=require('../common/entities');var has=require('../common/utils').has;var isValidEntityCode=require('../common/utils').isValidEntityCode;var fromCodePoint=require('../common/utils').fromCodePoint;var DIGITAL_RE=/^&#((?:x[a-f0-9]{1,8}|[0-9]{1,8}));/i;var NAMED_RE=/^&([a-z][a-z0-9]{1,31});/i;module.exports=function entity(state,silent){var ch,code,match,pos=state.pos,max=state.posMax;if(state.src.charCodeAt(pos)!==0x26){return false;}
if(pos+1<max){ch=state.src.charCodeAt(pos+1);if(ch===0x23){match=state.src.slice(pos).match(DIGITAL_RE);if(match){if(!silent){code=match[1][0].toLowerCase()==='x'?parseInt(match[1].slice(1),16):parseInt(match[1],10);state.pending+=isValidEntityCode(code)?fromCodePoint(code):fromCodePoint(0xFFFD);}
state.pos+=match[0].length;return true;}}else{match=state.src.slice(pos).match(NAMED_RE);if(match){if(has(entities,match[1])){if(!silent){state.pending+=entities[match[1]];}
state.pos+=match[0].length;return true;}}}}
if(!silent){state.pending+='&';}
state.pos++;return true;};},{"../common/entities":1,"../common/utils":4}],42:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;var ESCAPED=[];for(var i=0;i<256;i++){ESCAPED.push(0);}'\\!"#$%&\'()*+,./:;<=>?@[]^_`{|}~-'.split('').forEach(function(ch){ESCAPED[ch.charCodeAt(0)]=1;});module.exports=function escape(state,silent){var ch,pos=state.pos,max=state.posMax;if(state.src.charCodeAt(pos)!==0x5C){return false;}
pos++;if(pos<max){ch=state.src.charCodeAt(pos);if(ch<256&&ESCAPED[ch]!==0){if(!silent){state.pending+=state.src[pos];}
state.pos+=2;return true;}
if(ch===0x0A){if(!silent){state.push('hardbreak','br',0);}
pos++;while(pos<max){ch=state.src.charCodeAt(pos);if(!isSpace(ch)){break;}
pos++;}
state.pos=pos;return true;}}
if(!silent){state.pending+='\\';}
state.pos++;return true;};},{"../common/utils":4}],43:[function(require,module,exports){'use strict';var HTML_TAG_RE=require('../common/html_re').HTML_TAG_RE;function isLetter(ch){var lc=ch|0x20;return(lc>=0x61)&&(lc<=0x7a);}
module.exports=function html_inline(state,silent){var ch,match,max,token,pos=state.pos;if(!state.md.options.html){return false;}
max=state.posMax;if(state.src.charCodeAt(pos)!==0x3C||pos+2>=max){return false;}
ch=state.src.charCodeAt(pos+1);if(ch!==0x21&&ch!==0x3F&&ch!==0x2F&&!isLetter(ch)){return false;}
match=state.src.slice(pos).match(HTML_TAG_RE);if(!match){return false;}
if(!silent){token=state.push('html_inline','',0);token.content=state.src.slice(pos,pos+match[0].length);}
state.pos+=match[0].length;return true;};},{"../common/html_re":3}],44:[function(require,module,exports){'use strict';var normalizeReference=require('../common/utils').normalizeReference;var isSpace=require('../common/utils').isSpace;module.exports=function image(state,silent){var attrs,code,content,label,labelEnd,labelStart,pos,ref,res,title,token,tokens,start,href='',oldPos=state.pos,max=state.posMax;if(state.src.charCodeAt(state.pos)!==0x21){return false;}
if(state.src.charCodeAt(state.pos+1)!==0x5B){return false;}
labelStart=state.pos+2;labelEnd=state.md.helpers.parseLinkLabel(state,state.pos+1,false);if(labelEnd<0){return false;}
pos=labelEnd+1;if(pos<max&&state.src.charCodeAt(pos)===0x28){pos++;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}
if(pos>=max){return false;}
start=pos;res=state.md.helpers.parseLinkDestination(state.src,pos,state.posMax);if(res.ok){href=state.md.normalizeLink(res.str);if(state.md.validateLink(href)){pos=res.pos;}else{href='';}}
start=pos;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}
res=state.md.helpers.parseLinkTitle(state.src,pos,state.posMax);if(pos<max&&start!==pos&&res.ok){title=res.str;pos=res.pos;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}}else{title='';}
if(pos>=max||state.src.charCodeAt(pos)!==0x29){state.pos=oldPos;return false;}
pos++;}else{if(typeof state.env.references==='undefined'){return false;}
if(pos<max&&state.src.charCodeAt(pos)===0x5B){start=pos+1;pos=state.md.helpers.parseLinkLabel(state,pos);if(pos>=0){label=state.src.slice(start,pos++);}else{pos=labelEnd+1;}}else{pos=labelEnd+1;}
if(!label){label=state.src.slice(labelStart,labelEnd);}
ref=state.env.references[normalizeReference(label)];if(!ref){state.pos=oldPos;return false;}
href=ref.href;title=ref.title;}
if(!silent){content=state.src.slice(labelStart,labelEnd);state.md.inline.parse(content,state.md,state.env,tokens=[]);token=state.push('image','img',0);token.attrs=attrs=[['src',href],['alt','']];token.children=tokens;token.content=content;if(title){attrs.push(['title',title]);}}
state.pos=pos;state.posMax=max;return true;};},{"../common/utils":4}],45:[function(require,module,exports){'use strict';var normalizeReference=require('../common/utils').normalizeReference;var isSpace=require('../common/utils').isSpace;module.exports=function link(state,silent){var attrs,code,label,labelEnd,labelStart,pos,res,ref,title,token,href='',oldPos=state.pos,max=state.posMax,start=state.pos,parseReference=true;if(state.src.charCodeAt(state.pos)!==0x5B){return false;}
labelStart=state.pos+1;labelEnd=state.md.helpers.parseLinkLabel(state,state.pos,true);if(labelEnd<0){return false;}
pos=labelEnd+1;if(pos<max&&state.src.charCodeAt(pos)===0x28){parseReference=false;pos++;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}
if(pos>=max){return false;}
start=pos;res=state.md.helpers.parseLinkDestination(state.src,pos,state.posMax);if(res.ok){href=state.md.normalizeLink(res.str);if(state.md.validateLink(href)){pos=res.pos;}else{href='';}}
start=pos;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}
res=state.md.helpers.parseLinkTitle(state.src,pos,state.posMax);if(pos<max&&start!==pos&&res.ok){title=res.str;pos=res.pos;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}}else{title='';}
if(pos>=max||state.src.charCodeAt(pos)!==0x29){parseReference=true;}
pos++;}
if(parseReference){if(typeof state.env.references==='undefined'){return false;}
if(pos<max&&state.src.charCodeAt(pos)===0x5B){start=pos+1;pos=state.md.helpers.parseLinkLabel(state,pos);if(pos>=0){label=state.src.slice(start,pos++);}else{pos=labelEnd+1;}}else{pos=labelEnd+1;}
if(!label){label=state.src.slice(labelStart,labelEnd);}
ref=state.env.references[normalizeReference(label)];if(!ref){state.pos=oldPos;return false;}
href=ref.href;title=ref.title;}
if(!silent){state.pos=labelStart;state.posMax=labelEnd;token=state.push('link_open','a',1);token.attrs=attrs=[['href',href]];if(title){attrs.push(['title',title]);}
state.md.inline.tokenize(state);token=state.push('link_close','a',-1);}
state.pos=pos;state.posMax=max;return true;};},{"../common/utils":4}],46:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;module.exports=function newline(state,silent){var pmax,max,pos=state.pos;if(state.src.charCodeAt(pos)!==0x0A){return false;}
pmax=state.pending.length-1;max=state.posMax;if(!silent){if(pmax>=0&&state.pending.charCodeAt(pmax)===0x20){if(pmax>=1&&state.pending.charCodeAt(pmax-1)===0x20){state.pending=state.pending.replace(/ +$/,'');state.push('hardbreak','br',0);}else{state.pending=state.pending.slice(0,-1);state.push('softbreak','br',0);}}else{state.push('softbreak','br',0);}}
pos++;while(pos<max&&isSpace(state.src.charCodeAt(pos))){pos++;}
state.pos=pos;return true;};},{"../common/utils":4}],47:[function(require,module,exports){'use strict';var Token=require('../token');var isWhiteSpace=require('../common/utils').isWhiteSpace;var isPunctChar=require('../common/utils').isPunctChar;var isMdAsciiPunct=require('../common/utils').isMdAsciiPunct;function StateInline(src,md,env,outTokens){this.src=src;this.env=env;this.md=md;this.tokens=outTokens;this.pos=0;this.posMax=this.src.length;this.level=0;this.pending='';this.pendingLevel=0;this.cache={};this.delimiters=[];}
StateInline.prototype.pushPending=function(){var token=new Token('text','',0);token.content=this.pending;token.level=this.pendingLevel;this.tokens.push(token);this.pending='';return token;};StateInline.prototype.push=function(type,tag,nesting){if(this.pending){this.pushPending();}
var token=new Token(type,tag,nesting);if(nesting<0){this.level--;}
token.level=this.level;if(nesting>0){this.level++;}
this.pendingLevel=this.level;this.tokens.push(token);return token;};StateInline.prototype.scanDelims=function(start,canSplitWord){var pos=start,lastChar,nextChar,count,can_open,can_close,isLastWhiteSpace,isLastPunctChar,isNextWhiteSpace,isNextPunctChar,left_flanking=true,right_flanking=true,max=this.posMax,marker=this.src.charCodeAt(start);lastChar=start>0?this.src.charCodeAt(start-1):0x20;while(pos<max&&this.src.charCodeAt(pos)===marker){pos++;}
count=pos-start;nextChar=pos<max?this.src.charCodeAt(pos):0x20;isLastPunctChar=isMdAsciiPunct(lastChar)||isPunctChar(String.fromCharCode(lastChar));isNextPunctChar=isMdAsciiPunct(nextChar)||isPunctChar(String.fromCharCode(nextChar));isLastWhiteSpace=isWhiteSpace(lastChar);isNextWhiteSpace=isWhiteSpace(nextChar);if(isNextWhiteSpace){left_flanking=false;}else if(isNextPunctChar){if(!(isLastWhiteSpace||isLastPunctChar)){left_flanking=false;}}
if(isLastWhiteSpace){right_flanking=false;}else if(isLastPunctChar){if(!(isNextWhiteSpace||isNextPunctChar)){right_flanking=false;}}
if(!canSplitWord){can_open=left_flanking&&(!right_flanking||isLastPunctChar);can_close=right_flanking&&(!left_flanking||isNextPunctChar);}else{can_open=left_flanking;can_close=right_flanking;}
return{can_open:can_open,can_close:can_close,length:count};};StateInline.prototype.Token=Token;module.exports=StateInline;},{"../common/utils":4,"../token":51}],48:[function(require,module,exports){'use strict';module.exports.tokenize=function strikethrough(state,silent){var i,scanned,token,len,ch,start=state.pos,marker=state.src.charCodeAt(start);if(silent){return false;}
if(marker!==0x7E){return false;}
scanned=state.scanDelims(state.pos,true);len=scanned.length;ch=String.fromCharCode(marker);if(len<2){return false;}
if(len%2){token=state.push('text','',0);token.content=ch;len--;}
for(i=0;i<len;i+=2){token=state.push('text','',0);token.content=ch+ch;state.delimiters.push({marker:marker,jump:i,token:state.tokens.length-1,level:state.level,end:-1,open:scanned.can_open,close:scanned.can_close});}
state.pos+=scanned.length;return true;};module.exports.postProcess=function strikethrough(state){var i,j,startDelim,endDelim,token,loneMarkers=[],delimiters=state.delimiters,max=state.delimiters.length;for(i=0;i<max;i++){startDelim=delimiters[i];if(startDelim.marker!==0x7E){continue;}
if(startDelim.end===-1){continue;}
endDelim=delimiters[startDelim.end];token=state.tokens[startDelim.token];token.type='s_open';token.tag='s';token.nesting=1;token.markup='~~';token.content='';token=state.tokens[endDelim.token];token.type='s_close';token.tag='s';token.nesting=-1;token.markup='~~';token.content='';if(state.tokens[endDelim.token-1].type==='text'&&state.tokens[endDelim.token-1].content==='~'){loneMarkers.push(endDelim.token-1);}}
while(loneMarkers.length){i=loneMarkers.pop();j=i+1;while(j<state.tokens.length&&state.tokens[j].type==='s_close'){j++;}
j--;if(i!==j){token=state.tokens[j];state.tokens[j]=state.tokens[i];state.tokens[i]=token;}}};},{}],49:[function(require,module,exports){'use strict';function isTerminatorChar(ch){switch(ch){case 0x0A:case 0x21:case 0x23:case 0x24:case 0x25:case 0x26:case 0x2A:case 0x2B:case 0x2D:case 0x3A:case 0x3C:case 0x3D:case 0x3E:case 0x40:case 0x5B:case 0x5C:case 0x5D:case 0x5E:case 0x5F:case 0x60:case 0x7B:case 0x7D:case 0x7E:return true;default:return false;}}
module.exports=function text(state,silent){var pos=state.pos;while(pos<state.posMax&&!isTerminatorChar(state.src.charCodeAt(pos))){pos++;}
if(pos===state.pos){return false;}
if(!silent){state.pending+=state.src.slice(state.pos,pos);}
state.pos=pos;return true;};},{}],50:[function(require,module,exports){'use strict';module.exports=function text_collapse(state){var curr,last,level=0,tokens=state.tokens,max=state.tokens.length;for(curr=last=0;curr<max;curr++){level+=tokens[curr].nesting;tokens[curr].level=level;if(tokens[curr].type==='text'&&curr+1<max&&tokens[curr+1].type==='text'){tokens[curr+1].content=tokens[curr].content+tokens[curr+1].content;}else{if(curr!==last){tokens[last]=tokens[curr];}
last++;}}
if(curr!==last){tokens.length=last;}};},{}],51:[function(require,module,exports){'use strict';function Token(type,tag,nesting){this.type=type;this.tag=tag;this.attrs=null;this.map=null;this.nesting=nesting;this.level=0;this.children=null;this.content='';this.markup='';this.info='';this.meta=null;this.block=false;this.hidden=false;}
Token.prototype.attrIndex=function attrIndex(name){var attrs,i,len;if(!this.attrs){return-1;}
attrs=this.attrs;for(i=0,len=attrs.length;i<len;i++){if(attrs[i][0]===name){return i;}}
return-1;};Token.prototype.attrPush=function attrPush(attrData){if(this.attrs){this.attrs.push(attrData);}else{this.attrs=[attrData];}};Token.prototype.attrSet=function attrSet(name,value){var idx=this.attrIndex(name),attrData=[name,value];if(idx<0){this.attrPush(attrData);}else{this.attrs[idx]=attrData;}};Token.prototype.attrGet=function attrGet(name){var idx=this.attrIndex(name),value=null;if(idx>=0){value=this.attrs[idx][1];}
return value;};Token.prototype.attrJoin=function attrJoin(name,value){var idx=this.attrIndex(name);if(idx<0){this.attrPush([name,value]);}else{this.attrs[idx][1]=this.attrs[idx][1]+' '+value;}};module.exports=Token;},{}],52:[function(require,module,exports){module.exports={"Aacute":"\u00C1","aacute":"\u00E1","Abreve":"\u0102","abreve":"\u0103","ac":"\u223E","acd":"\u223F","acE":"\u223E\u0333","Acirc":"\u00C2","acirc":"\u00E2","acute":"\u00B4","Acy":"\u0410","acy":"\u0430","AElig":"\u00C6","aelig":"\u00E6","af":"\u2061","Afr":"\uD835\uDD04","afr":"\uD835\uDD1E","Agrave":"\u00C0","agrave":"\u00E0","alefsym":"\u2135","aleph":"\u2135","Alpha":"\u0391","alpha":"\u03B1","Amacr":"\u0100","amacr":"\u0101","amalg":"\u2A3F","amp":"&","AMP":"&","andand":"\u2A55","And":"\u2A53","and":"\u2227","andd":"\u2A5C","andslope":"\u2A58","andv":"\u2A5A","ang":"\u2220","ange":"\u29A4","angle":"\u2220","angmsdaa":"\u29A8","angmsdab":"\u29A9","angmsdac":"\u29AA","angmsdad":"\u29AB","angmsdae":"\u29AC","angmsdaf":"\u29AD","angmsdag":"\u29AE","angmsdah":"\u29AF","angmsd":"\u2221","angrt":"\u221F","angrtvb":"\u22BE","angrtvbd":"\u299D","angsph":"\u2222","angst":"\u00C5","angzarr":"\u237C","Aogon":"\u0104","aogon":"\u0105","Aopf":"\uD835\uDD38","aopf":"\uD835\uDD52","apacir":"\u2A6F","ap":"\u2248","apE":"\u2A70","ape":"\u224A","apid":"\u224B","apos":"'","ApplyFunction":"\u2061","approx":"\u2248","approxeq":"\u224A","Aring":"\u00C5","aring":"\u00E5","Ascr":"\uD835\uDC9C","ascr":"\uD835\uDCB6","Assign":"\u2254","ast":"*","asymp":"\u2248","asympeq":"\u224D","Atilde":"\u00C3","atilde":"\u00E3","Auml":"\u00C4","auml":"\u00E4","awconint":"\u2233","awint":"\u2A11","backcong":"\u224C","backepsilon":"\u03F6","backprime":"\u2035","backsim":"\u223D","backsimeq":"\u22CD","Backslash":"\u2216","Barv":"\u2AE7","barvee":"\u22BD","barwed":"\u2305","Barwed":"\u2306","barwedge":"\u2305","bbrk":"\u23B5","bbrktbrk":"\u23B6","bcong":"\u224C","Bcy":"\u0411","bcy":"\u0431","bdquo":"\u201E","becaus":"\u2235","because":"\u2235","Because":"\u2235","bemptyv":"\u29B0","bepsi":"\u03F6","bernou":"\u212C","Bernoullis":"\u212C","Beta":"\u0392","beta":"\u03B2","beth":"\u2136","between":"\u226C","Bfr":"\uD835\uDD05","bfr":"\uD835\uDD1F","bigcap":"\u22C2","bigcirc":"\u25EF","bigcup":"\u22C3","bigodot":"\u2A00","bigoplus":"\u2A01","bigotimes":"\u2A02","bigsqcup":"\u2A06","bigstar":"\u2605","bigtriangledown":"\u25BD","bigtriangleup":"\u25B3","biguplus":"\u2A04","bigvee":"\u22C1","bigwedge":"\u22C0","bkarow":"\u290D","blacklozenge":"\u29EB","blacksquare":"\u25AA","blacktriangle":"\u25B4","blacktriangledown":"\u25BE","blacktriangleleft":"\u25C2","blacktriangleright":"\u25B8","blank":"\u2423","blk12":"\u2592","blk14":"\u2591","blk34":"\u2593","block":"\u2588","bne":"=\u20E5","bnequiv":"\u2261\u20E5","bNot":"\u2AED","bnot":"\u2310","Bopf":"\uD835\uDD39","bopf":"\uD835\uDD53","bot":"\u22A5","bottom":"\u22A5","bowtie":"\u22C8","boxbox":"\u29C9","boxdl":"\u2510","boxdL":"\u2555","boxDl":"\u2556","boxDL":"\u2557","boxdr":"\u250C","boxdR":"\u2552","boxDr":"\u2553","boxDR":"\u2554","boxh":"\u2500","boxH":"\u2550","boxhd":"\u252C","boxHd":"\u2564","boxhD":"\u2565","boxHD":"\u2566","boxhu":"\u2534","boxHu":"\u2567","boxhU":"\u2568","boxHU":"\u2569","boxminus":"\u229F","boxplus":"\u229E","boxtimes":"\u22A0","boxul":"\u2518","boxuL":"\u255B","boxUl":"\u255C","boxUL":"\u255D","boxur":"\u2514","boxuR":"\u2558","boxUr":"\u2559","boxUR":"\u255A","boxv":"\u2502","boxV":"\u2551","boxvh":"\u253C","boxvH":"\u256A","boxVh":"\u256B","boxVH":"\u256C","boxvl":"\u2524","boxvL":"\u2561","boxVl":"\u2562","boxVL":"\u2563","boxvr":"\u251C","boxvR":"\u255E","boxVr":"\u255F","boxVR":"\u2560","bprime":"\u2035","breve":"\u02D8","Breve":"\u02D8","brvbar":"\u00A6","bscr":"\uD835\uDCB7","Bscr":"\u212C","bsemi":"\u204F","bsim":"\u223D","bsime":"\u22CD","bsolb":"\u29C5","bsol":"\\","bsolhsub":"\u27C8","bull":"\u2022","bullet":"\u2022","bump":"\u224E","bumpE":"\u2AAE","bumpe":"\u224F","Bumpeq":"\u224E","bumpeq":"\u224F","Cacute":"\u0106","cacute":"\u0107","capand":"\u2A44","capbrcup":"\u2A49","capcap":"\u2A4B","cap":"\u2229","Cap":"\u22D2","capcup":"\u2A47","capdot":"\u2A40","CapitalDifferentialD":"\u2145","caps":"\u2229\uFE00","caret":"\u2041","caron":"\u02C7","Cayleys":"\u212D","ccaps":"\u2A4D","Ccaron":"\u010C","ccaron":"\u010D","Ccedil":"\u00C7","ccedil":"\u00E7","Ccirc":"\u0108","ccirc":"\u0109","Cconint":"\u2230","ccups":"\u2A4C","ccupssm":"\u2A50","Cdot":"\u010A","cdot":"\u010B","cedil":"\u00B8","Cedilla":"\u00B8","cemptyv":"\u29B2","cent":"\u00A2","centerdot":"\u00B7","CenterDot":"\u00B7","cfr":"\uD835\uDD20","Cfr":"\u212D","CHcy":"\u0427","chcy":"\u0447","check":"\u2713","checkmark":"\u2713","Chi":"\u03A7","chi":"\u03C7","circ":"\u02C6","circeq":"\u2257","circlearrowleft":"\u21BA","circlearrowright":"\u21BB","circledast":"\u229B","circledcirc":"\u229A","circleddash":"\u229D","CircleDot":"\u2299","circledR":"\u00AE","circledS":"\u24C8","CircleMinus":"\u2296","CirclePlus":"\u2295","CircleTimes":"\u2297","cir":"\u25CB","cirE":"\u29C3","cire":"\u2257","cirfnint":"\u2A10","cirmid":"\u2AEF","cirscir":"\u29C2","ClockwiseContourIntegral":"\u2232","CloseCurlyDoubleQuote":"\u201D","CloseCurlyQuote":"\u2019","clubs":"\u2663","clubsuit":"\u2663","colon":":","Colon":"\u2237","Colone":"\u2A74","colone":"\u2254","coloneq":"\u2254","comma":",","commat":"@","comp":"\u2201","compfn":"\u2218","complement":"\u2201","complexes":"\u2102","cong":"\u2245","congdot":"\u2A6D","Congruent":"\u2261","conint":"\u222E","Conint":"\u222F","ContourIntegral":"\u222E","copf":"\uD835\uDD54","Copf":"\u2102","coprod":"\u2210","Coproduct":"\u2210","copy":"\u00A9","COPY":"\u00A9","copysr":"\u2117","CounterClockwiseContourIntegral":"\u2233","crarr":"\u21B5","cross":"\u2717","Cross":"\u2A2F","Cscr":"\uD835\uDC9E","cscr":"\uD835\uDCB8","csub":"\u2ACF","csube":"\u2AD1","csup":"\u2AD0","csupe":"\u2AD2","ctdot":"\u22EF","cudarrl":"\u2938","cudarrr":"\u2935","cuepr":"\u22DE","cuesc":"\u22DF","cularr":"\u21B6","cularrp":"\u293D","cupbrcap":"\u2A48","cupcap":"\u2A46","CupCap":"\u224D","cup":"\u222A","Cup":"\u22D3","cupcup":"\u2A4A","cupdot":"\u228D","cupor":"\u2A45","cups":"\u222A\uFE00","curarr":"\u21B7","curarrm":"\u293C","curlyeqprec":"\u22DE","curlyeqsucc":"\u22DF","curlyvee":"\u22CE","curlywedge":"\u22CF","curren":"\u00A4","curvearrowleft":"\u21B6","curvearrowright":"\u21B7","cuvee":"\u22CE","cuwed":"\u22CF","cwconint":"\u2232","cwint":"\u2231","cylcty":"\u232D","dagger":"\u2020","Dagger":"\u2021","daleth":"\u2138","darr":"\u2193","Darr":"\u21A1","dArr":"\u21D3","dash":"\u2010","Dashv":"\u2AE4","dashv":"\u22A3","dbkarow":"\u290F","dblac":"\u02DD","Dcaron":"\u010E","dcaron":"\u010F","Dcy":"\u0414","dcy":"\u0434","ddagger":"\u2021","ddarr":"\u21CA","DD":"\u2145","dd":"\u2146","DDotrahd":"\u2911","ddotseq":"\u2A77","deg":"\u00B0","Del":"\u2207","Delta":"\u0394","delta":"\u03B4","demptyv":"\u29B1","dfisht":"\u297F","Dfr":"\uD835\uDD07","dfr":"\uD835\uDD21","dHar":"\u2965","dharl":"\u21C3","dharr":"\u21C2","DiacriticalAcute":"\u00B4","DiacriticalDot":"\u02D9","DiacriticalDoubleAcute":"\u02DD","DiacriticalGrave":"`","DiacriticalTilde":"\u02DC","diam":"\u22C4","diamond":"\u22C4","Diamond":"\u22C4","diamondsuit":"\u2666","diams":"\u2666","die":"\u00A8","DifferentialD":"\u2146","digamma":"\u03DD","disin":"\u22F2","div":"\u00F7","divide":"\u00F7","divideontimes":"\u22C7","divonx":"\u22C7","DJcy":"\u0402","djcy":"\u0452","dlcorn":"\u231E","dlcrop":"\u230D","dollar":"$","Dopf":"\uD835\uDD3B","dopf":"\uD835\uDD55","Dot":"\u00A8","dot":"\u02D9","DotDot":"\u20DC","doteq":"\u2250","doteqdot":"\u2251","DotEqual":"\u2250","dotminus":"\u2238","dotplus":"\u2214","dotsquare":"\u22A1","doublebarwedge":"\u2306","DoubleContourIntegral":"\u222F","DoubleDot":"\u00A8","DoubleDownArrow":"\u21D3","DoubleLeftArrow":"\u21D0","DoubleLeftRightArrow":"\u21D4","DoubleLeftTee":"\u2AE4","DoubleLongLeftArrow":"\u27F8","DoubleLongLeftRightArrow":"\u27FA","DoubleLongRightArrow":"\u27F9","DoubleRightArrow":"\u21D2","DoubleRightTee":"\u22A8","DoubleUpArrow":"\u21D1","DoubleUpDownArrow":"\u21D5","DoubleVerticalBar":"\u2225","DownArrowBar":"\u2913","downarrow":"\u2193","DownArrow":"\u2193","Downarrow":"\u21D3","DownArrowUpArrow":"\u21F5","DownBreve":"\u0311","downdownarrows":"\u21CA","downharpoonleft":"\u21C3","downharpoonright":"\u21C2","DownLeftRightVector":"\u2950","DownLeftTeeVector":"\u295E","DownLeftVectorBar":"\u2956","DownLeftVector":"\u21BD","DownRightTeeVector":"\u295F","DownRightVectorBar":"\u2957","DownRightVector":"\u21C1","DownTeeArrow":"\u21A7","DownTee":"\u22A4","drbkarow":"\u2910","drcorn":"\u231F","drcrop":"\u230C","Dscr":"\uD835\uDC9F","dscr":"\uD835\uDCB9","DScy":"\u0405","dscy":"\u0455","dsol":"\u29F6","Dstrok":"\u0110","dstrok":"\u0111","dtdot":"\u22F1","dtri":"\u25BF","dtrif":"\u25BE","duarr":"\u21F5","duhar":"\u296F","dwangle":"\u29A6","DZcy":"\u040F","dzcy":"\u045F","dzigrarr":"\u27FF","Eacute":"\u00C9","eacute":"\u00E9","easter":"\u2A6E","Ecaron":"\u011A","ecaron":"\u011B","Ecirc":"\u00CA","ecirc":"\u00EA","ecir":"\u2256","ecolon":"\u2255","Ecy":"\u042D","ecy":"\u044D","eDDot":"\u2A77","Edot":"\u0116","edot":"\u0117","eDot":"\u2251","ee":"\u2147","efDot":"\u2252","Efr":"\uD835\uDD08","efr":"\uD835\uDD22","eg":"\u2A9A","Egrave":"\u00C8","egrave":"\u00E8","egs":"\u2A96","egsdot":"\u2A98","el":"\u2A99","Element":"\u2208","elinters":"\u23E7","ell":"\u2113","els":"\u2A95","elsdot":"\u2A97","Emacr":"\u0112","emacr":"\u0113","empty":"\u2205","emptyset":"\u2205","EmptySmallSquare":"\u25FB","emptyv":"\u2205","EmptyVerySmallSquare":"\u25AB","emsp13":"\u2004","emsp14":"\u2005","emsp":"\u2003","ENG":"\u014A","eng":"\u014B","ensp":"\u2002","Eogon":"\u0118","eogon":"\u0119","Eopf":"\uD835\uDD3C","eopf":"\uD835\uDD56","epar":"\u22D5","eparsl":"\u29E3","eplus":"\u2A71","epsi":"\u03B5","Epsilon":"\u0395","epsilon":"\u03B5","epsiv":"\u03F5","eqcirc":"\u2256","eqcolon":"\u2255","eqsim":"\u2242","eqslantgtr":"\u2A96","eqslantless":"\u2A95","Equal":"\u2A75","equals":"=","EqualTilde":"\u2242","equest":"\u225F","Equilibrium":"\u21CC","equiv":"\u2261","equivDD":"\u2A78","eqvparsl":"\u29E5","erarr":"\u2971","erDot":"\u2253","escr":"\u212F","Escr":"\u2130","esdot":"\u2250","Esim":"\u2A73","esim":"\u2242","Eta":"\u0397","eta":"\u03B7","ETH":"\u00D0","eth":"\u00F0","Euml":"\u00CB","euml":"\u00EB","euro":"\u20AC","excl":"!","exist":"\u2203","Exists":"\u2203","expectation":"\u2130","exponentiale":"\u2147","ExponentialE":"\u2147","fallingdotseq":"\u2252","Fcy":"\u0424","fcy":"\u0444","female":"\u2640","ffilig":"\uFB03","fflig":"\uFB00","ffllig":"\uFB04","Ffr":"\uD835\uDD09","ffr":"\uD835\uDD23","filig":"\uFB01","FilledSmallSquare":"\u25FC","FilledVerySmallSquare":"\u25AA","fjlig":"fj","flat":"\u266D","fllig":"\uFB02","fltns":"\u25B1","fnof":"\u0192","Fopf":"\uD835\uDD3D","fopf":"\uD835\uDD57","forall":"\u2200","ForAll":"\u2200","fork":"\u22D4","forkv":"\u2AD9","Fouriertrf":"\u2131","fpartint":"\u2A0D","frac12":"\u00BD","frac13":"\u2153","frac14":"\u00BC","frac15":"\u2155","frac16":"\u2159","frac18":"\u215B","frac23":"\u2154","frac25":"\u2156","frac34":"\u00BE","frac35":"\u2157","frac38":"\u215C","frac45":"\u2158","frac56":"\u215A","frac58":"\u215D","frac78":"\u215E","frasl":"\u2044","frown":"\u2322","fscr":"\uD835\uDCBB","Fscr":"\u2131","gacute":"\u01F5","Gamma":"\u0393","gamma":"\u03B3","Gammad":"\u03DC","gammad":"\u03DD","gap":"\u2A86","Gbreve":"\u011E","gbreve":"\u011F","Gcedil":"\u0122","Gcirc":"\u011C","gcirc":"\u011D","Gcy":"\u0413","gcy":"\u0433","Gdot":"\u0120","gdot":"\u0121","ge":"\u2265","gE":"\u2267","gEl":"\u2A8C","gel":"\u22DB","geq":"\u2265","geqq":"\u2267","geqslant":"\u2A7E","gescc":"\u2AA9","ges":"\u2A7E","gesdot":"\u2A80","gesdoto":"\u2A82","gesdotol":"\u2A84","gesl":"\u22DB\uFE00","gesles":"\u2A94","Gfr":"\uD835\uDD0A","gfr":"\uD835\uDD24","gg":"\u226B","Gg":"\u22D9","ggg":"\u22D9","gimel":"\u2137","GJcy":"\u0403","gjcy":"\u0453","gla":"\u2AA5","gl":"\u2277","glE":"\u2A92","glj":"\u2AA4","gnap":"\u2A8A","gnapprox":"\u2A8A","gne":"\u2A88","gnE":"\u2269","gneq":"\u2A88","gneqq":"\u2269","gnsim":"\u22E7","Gopf":"\uD835\uDD3E","gopf":"\uD835\uDD58","grave":"`","GreaterEqual":"\u2265","GreaterEqualLess":"\u22DB","GreaterFullEqual":"\u2267","GreaterGreater":"\u2AA2","GreaterLess":"\u2277","GreaterSlantEqual":"\u2A7E","GreaterTilde":"\u2273","Gscr":"\uD835\uDCA2","gscr":"\u210A","gsim":"\u2273","gsime":"\u2A8E","gsiml":"\u2A90","gtcc":"\u2AA7","gtcir":"\u2A7A","gt":">","GT":">","Gt":"\u226B","gtdot":"\u22D7","gtlPar":"\u2995","gtquest":"\u2A7C","gtrapprox":"\u2A86","gtrarr":"\u2978","gtrdot":"\u22D7","gtreqless":"\u22DB","gtreqqless":"\u2A8C","gtrless":"\u2277","gtrsim":"\u2273","gvertneqq":"\u2269\uFE00","gvnE":"\u2269\uFE00","Hacek":"\u02C7","hairsp":"\u200A","half":"\u00BD","hamilt":"\u210B","HARDcy":"\u042A","hardcy":"\u044A","harrcir":"\u2948","harr":"\u2194","hArr":"\u21D4","harrw":"\u21AD","Hat":"^","hbar":"\u210F","Hcirc":"\u0124","hcirc":"\u0125","hearts":"\u2665","heartsuit":"\u2665","hellip":"\u2026","hercon":"\u22B9","hfr":"\uD835\uDD25","Hfr":"\u210C","HilbertSpace":"\u210B","hksearow":"\u2925","hkswarow":"\u2926","hoarr":"\u21FF","homtht":"\u223B","hookleftarrow":"\u21A9","hookrightarrow":"\u21AA","hopf":"\uD835\uDD59","Hopf":"\u210D","horbar":"\u2015","HorizontalLine":"\u2500","hscr":"\uD835\uDCBD","Hscr":"\u210B","hslash":"\u210F","Hstrok":"\u0126","hstrok":"\u0127","HumpDownHump":"\u224E","HumpEqual":"\u224F","hybull":"\u2043","hyphen":"\u2010","Iacute":"\u00CD","iacute":"\u00ED","ic":"\u2063","Icirc":"\u00CE","icirc":"\u00EE","Icy":"\u0418","icy":"\u0438","Idot":"\u0130","IEcy":"\u0415","iecy":"\u0435","iexcl":"\u00A1","iff":"\u21D4","ifr":"\uD835\uDD26","Ifr":"\u2111","Igrave":"\u00CC","igrave":"\u00EC","ii":"\u2148","iiiint":"\u2A0C","iiint":"\u222D","iinfin":"\u29DC","iiota":"\u2129","IJlig":"\u0132","ijlig":"\u0133","Imacr":"\u012A","imacr":"\u012B","image":"\u2111","ImaginaryI":"\u2148","imagline":"\u2110","imagpart":"\u2111","imath":"\u0131","Im":"\u2111","imof":"\u22B7","imped":"\u01B5","Implies":"\u21D2","incare":"\u2105","in":"\u2208","infin":"\u221E","infintie":"\u29DD","inodot":"\u0131","intcal":"\u22BA","int":"\u222B","Int":"\u222C","integers":"\u2124","Integral":"\u222B","intercal":"\u22BA","Intersection":"\u22C2","intlarhk":"\u2A17","intprod":"\u2A3C","InvisibleComma":"\u2063","InvisibleTimes":"\u2062","IOcy":"\u0401","iocy":"\u0451","Iogon":"\u012E","iogon":"\u012F","Iopf":"\uD835\uDD40","iopf":"\uD835\uDD5A","Iota":"\u0399","iota":"\u03B9","iprod":"\u2A3C","iquest":"\u00BF","iscr":"\uD835\uDCBE","Iscr":"\u2110","isin":"\u2208","isindot":"\u22F5","isinE":"\u22F9","isins":"\u22F4","isinsv":"\u22F3","isinv":"\u2208","it":"\u2062","Itilde":"\u0128","itilde":"\u0129","Iukcy":"\u0406","iukcy":"\u0456","Iuml":"\u00CF","iuml":"\u00EF","Jcirc":"\u0134","jcirc":"\u0135","Jcy":"\u0419","jcy":"\u0439","Jfr":"\uD835\uDD0D","jfr":"\uD835\uDD27","jmath":"\u0237","Jopf":"\uD835\uDD41","jopf":"\uD835\uDD5B","Jscr":"\uD835\uDCA5","jscr":"\uD835\uDCBF","Jsercy":"\u0408","jsercy":"\u0458","Jukcy":"\u0404","jukcy":"\u0454","Kappa":"\u039A","kappa":"\u03BA","kappav":"\u03F0","Kcedil":"\u0136","kcedil":"\u0137","Kcy":"\u041A","kcy":"\u043A","Kfr":"\uD835\uDD0E","kfr":"\uD835\uDD28","kgreen":"\u0138","KHcy":"\u0425","khcy":"\u0445","KJcy":"\u040C","kjcy":"\u045C","Kopf":"\uD835\uDD42","kopf":"\uD835\uDD5C","Kscr":"\uD835\uDCA6","kscr":"\uD835\uDCC0","lAarr":"\u21DA","Lacute":"\u0139","lacute":"\u013A","laemptyv":"\u29B4","lagran":"\u2112","Lambda":"\u039B","lambda":"\u03BB","lang":"\u27E8","Lang":"\u27EA","langd":"\u2991","langle":"\u27E8","lap":"\u2A85","Laplacetrf":"\u2112","laquo":"\u00AB","larrb":"\u21E4","larrbfs":"\u291F","larr":"\u2190","Larr":"\u219E","lArr":"\u21D0","larrfs":"\u291D","larrhk":"\u21A9","larrlp":"\u21AB","larrpl":"\u2939","larrsim":"\u2973","larrtl":"\u21A2","latail":"\u2919","lAtail":"\u291B","lat":"\u2AAB","late":"\u2AAD","lates":"\u2AAD\uFE00","lbarr":"\u290C","lBarr":"\u290E","lbbrk":"\u2772","lbrace":"{","lbrack":"[","lbrke":"\u298B","lbrksld":"\u298F","lbrkslu":"\u298D","Lcaron":"\u013D","lcaron":"\u013E","Lcedil":"\u013B","lcedil":"\u013C","lceil":"\u2308","lcub":"{","Lcy":"\u041B","lcy":"\u043B","ldca":"\u2936","ldquo":"\u201C","ldquor":"\u201E","ldrdhar":"\u2967","ldrushar":"\u294B","ldsh":"\u21B2","le":"\u2264","lE":"\u2266","LeftAngleBracket":"\u27E8","LeftArrowBar":"\u21E4","leftarrow":"\u2190","LeftArrow":"\u2190","Leftarrow":"\u21D0","LeftArrowRightArrow":"\u21C6","leftarrowtail":"\u21A2","LeftCeiling":"\u2308","LeftDoubleBracket":"\u27E6","LeftDownTeeVector":"\u2961","LeftDownVectorBar":"\u2959","LeftDownVector":"\u21C3","LeftFloor":"\u230A","leftharpoondown":"\u21BD","leftharpoonup":"\u21BC","leftleftarrows":"\u21C7","leftrightarrow":"\u2194","LeftRightArrow":"\u2194","Leftrightarrow":"\u21D4","leftrightarrows":"\u21C6","leftrightharpoons":"\u21CB","leftrightsquigarrow":"\u21AD","LeftRightVector":"\u294E","LeftTeeArrow":"\u21A4","LeftTee":"\u22A3","LeftTeeVector":"\u295A","leftthreetimes":"\u22CB","LeftTriangleBar":"\u29CF","LeftTriangle":"\u22B2","LeftTriangleEqual":"\u22B4","LeftUpDownVector":"\u2951","LeftUpTeeVector":"\u2960","LeftUpVectorBar":"\u2958","LeftUpVector":"\u21BF","LeftVectorBar":"\u2952","LeftVector":"\u21BC","lEg":"\u2A8B","leg":"\u22DA","leq":"\u2264","leqq":"\u2266","leqslant":"\u2A7D","lescc":"\u2AA8","les":"\u2A7D","lesdot":"\u2A7F","lesdoto":"\u2A81","lesdotor":"\u2A83","lesg":"\u22DA\uFE00","lesges":"\u2A93","lessapprox":"\u2A85","lessdot":"\u22D6","lesseqgtr":"\u22DA","lesseqqgtr":"\u2A8B","LessEqualGreater":"\u22DA","LessFullEqual":"\u2266","LessGreater":"\u2276","lessgtr":"\u2276","LessLess":"\u2AA1","lesssim":"\u2272","LessSlantEqual":"\u2A7D","LessTilde":"\u2272","lfisht":"\u297C","lfloor":"\u230A","Lfr":"\uD835\uDD0F","lfr":"\uD835\uDD29","lg":"\u2276","lgE":"\u2A91","lHar":"\u2962","lhard":"\u21BD","lharu":"\u21BC","lharul":"\u296A","lhblk":"\u2584","LJcy":"\u0409","ljcy":"\u0459","llarr":"\u21C7","ll":"\u226A","Ll":"\u22D8","llcorner":"\u231E","Lleftarrow":"\u21DA","llhard":"\u296B","lltri":"\u25FA","Lmidot":"\u013F","lmidot":"\u0140","lmoustache":"\u23B0","lmoust":"\u23B0","lnap":"\u2A89","lnapprox":"\u2A89","lne":"\u2A87","lnE":"\u2268","lneq":"\u2A87","lneqq":"\u2268","lnsim":"\u22E6","loang":"\u27EC","loarr":"\u21FD","lobrk":"\u27E6","longleftarrow":"\u27F5","LongLeftArrow":"\u27F5","Longleftarrow":"\u27F8","longleftrightarrow":"\u27F7","LongLeftRightArrow":"\u27F7","Longleftrightarrow":"\u27FA","longmapsto":"\u27FC","longrightarrow":"\u27F6","LongRightArrow":"\u27F6","Longrightarrow":"\u27F9","looparrowleft":"\u21AB","looparrowright":"\u21AC","lopar":"\u2985","Lopf":"\uD835\uDD43","lopf":"\uD835\uDD5D","loplus":"\u2A2D","lotimes":"\u2A34","lowast":"\u2217","lowbar":"_","LowerLeftArrow":"\u2199","LowerRightArrow":"\u2198","loz":"\u25CA","lozenge":"\u25CA","lozf":"\u29EB","lpar":"(","lparlt":"\u2993","lrarr":"\u21C6","lrcorner":"\u231F","lrhar":"\u21CB","lrhard":"\u296D","lrm":"\u200E","lrtri":"\u22BF","lsaquo":"\u2039","lscr":"\uD835\uDCC1","Lscr":"\u2112","lsh":"\u21B0","Lsh":"\u21B0","lsim":"\u2272","lsime":"\u2A8D","lsimg":"\u2A8F","lsqb":"[","lsquo":"\u2018","lsquor":"\u201A","Lstrok":"\u0141","lstrok":"\u0142","ltcc":"\u2AA6","ltcir":"\u2A79","lt":"<","LT":"<","Lt":"\u226A","ltdot":"\u22D6","lthree":"\u22CB","ltimes":"\u22C9","ltlarr":"\u2976","ltquest":"\u2A7B","ltri":"\u25C3","ltrie":"\u22B4","ltrif":"\u25C2","ltrPar":"\u2996","lurdshar":"\u294A","luruhar":"\u2966","lvertneqq":"\u2268\uFE00","lvnE":"\u2268\uFE00","macr":"\u00AF","male":"\u2642","malt":"\u2720","maltese":"\u2720","Map":"\u2905","map":"\u21A6","mapsto":"\u21A6","mapstodown":"\u21A7","mapstoleft":"\u21A4","mapstoup":"\u21A5","marker":"\u25AE","mcomma":"\u2A29","Mcy":"\u041C","mcy":"\u043C","mdash":"\u2014","mDDot":"\u223A","measuredangle":"\u2221","MediumSpace":"\u205F","Mellintrf":"\u2133","Mfr":"\uD835\uDD10","mfr":"\uD835\uDD2A","mho":"\u2127","micro":"\u00B5","midast":"*","midcir":"\u2AF0","mid":"\u2223","middot":"\u00B7","minusb":"\u229F","minus":"\u2212","minusd":"\u2238","minusdu":"\u2A2A","MinusPlus":"\u2213","mlcp":"\u2ADB","mldr":"\u2026","mnplus":"\u2213","models":"\u22A7","Mopf":"\uD835\uDD44","mopf":"\uD835\uDD5E","mp":"\u2213","mscr":"\uD835\uDCC2","Mscr":"\u2133","mstpos":"\u223E","Mu":"\u039C","mu":"\u03BC","multimap":"\u22B8","mumap":"\u22B8","nabla":"\u2207","Nacute":"\u0143","nacute":"\u0144","nang":"\u2220\u20D2","nap":"\u2249","napE":"\u2A70\u0338","napid":"\u224B\u0338","napos":"\u0149","napprox":"\u2249","natural":"\u266E","naturals":"\u2115","natur":"\u266E","nbsp":"\u00A0","nbump":"\u224E\u0338","nbumpe":"\u224F\u0338","ncap":"\u2A43","Ncaron":"\u0147","ncaron":"\u0148","Ncedil":"\u0145","ncedil":"\u0146","ncong":"\u2247","ncongdot":"\u2A6D\u0338","ncup":"\u2A42","Ncy":"\u041D","ncy":"\u043D","ndash":"\u2013","nearhk":"\u2924","nearr":"\u2197","neArr":"\u21D7","nearrow":"\u2197","ne":"\u2260","nedot":"\u2250\u0338","NegativeMediumSpace":"\u200B","NegativeThickSpace":"\u200B","NegativeThinSpace":"\u200B","NegativeVeryThinSpace":"\u200B","nequiv":"\u2262","nesear":"\u2928","nesim":"\u2242\u0338","NestedGreaterGreater":"\u226B","NestedLessLess":"\u226A","NewLine":"\n","nexist":"\u2204","nexists":"\u2204","Nfr":"\uD835\uDD11","nfr":"\uD835\uDD2B","ngE":"\u2267\u0338","nge":"\u2271","ngeq":"\u2271","ngeqq":"\u2267\u0338","ngeqslant":"\u2A7E\u0338","nges":"\u2A7E\u0338","nGg":"\u22D9\u0338","ngsim":"\u2275","nGt":"\u226B\u20D2","ngt":"\u226F","ngtr":"\u226F","nGtv":"\u226B\u0338","nharr":"\u21AE","nhArr":"\u21CE","nhpar":"\u2AF2","ni":"\u220B","nis":"\u22FC","nisd":"\u22FA","niv":"\u220B","NJcy":"\u040A","njcy":"\u045A","nlarr":"\u219A","nlArr":"\u21CD","nldr":"\u2025","nlE":"\u2266\u0338","nle":"\u2270","nleftarrow":"\u219A","nLeftarrow":"\u21CD","nleftrightarrow":"\u21AE","nLeftrightarrow":"\u21CE","nleq":"\u2270","nleqq":"\u2266\u0338","nleqslant":"\u2A7D\u0338","nles":"\u2A7D\u0338","nless":"\u226E","nLl":"\u22D8\u0338","nlsim":"\u2274","nLt":"\u226A\u20D2","nlt":"\u226E","nltri":"\u22EA","nltrie":"\u22EC","nLtv":"\u226A\u0338","nmid":"\u2224","NoBreak":"\u2060","NonBreakingSpace":"\u00A0","nopf":"\uD835\uDD5F","Nopf":"\u2115","Not":"\u2AEC","not":"\u00AC","NotCongruent":"\u2262","NotCupCap":"\u226D","NotDoubleVerticalBar":"\u2226","NotElement":"\u2209","NotEqual":"\u2260","NotEqualTilde":"\u2242\u0338","NotExists":"\u2204","NotGreater":"\u226F","NotGreaterEqual":"\u2271","NotGreaterFullEqual":"\u2267\u0338","NotGreaterGreater":"\u226B\u0338","NotGreaterLess":"\u2279","NotGreaterSlantEqual":"\u2A7E\u0338","NotGreaterTilde":"\u2275","NotHumpDownHump":"\u224E\u0338","NotHumpEqual":"\u224F\u0338","notin":"\u2209","notindot":"\u22F5\u0338","notinE":"\u22F9\u0338","notinva":"\u2209","notinvb":"\u22F7","notinvc":"\u22F6","NotLeftTriangleBar":"\u29CF\u0338","NotLeftTriangle":"\u22EA","NotLeftTriangleEqual":"\u22EC","NotLess":"\u226E","NotLessEqual":"\u2270","NotLessGreater":"\u2278","NotLessLess":"\u226A\u0338","NotLessSlantEqual":"\u2A7D\u0338","NotLessTilde":"\u2274","NotNestedGreaterGreater":"\u2AA2\u0338","NotNestedLessLess":"\u2AA1\u0338","notni":"\u220C","notniva":"\u220C","notnivb":"\u22FE","notnivc":"\u22FD","NotPrecedes":"\u2280","NotPrecedesEqual":"\u2AAF\u0338","NotPrecedesSlantEqual":"\u22E0","NotReverseElement":"\u220C","NotRightTriangleBar":"\u29D0\u0338","NotRightTriangle":"\u22EB","NotRightTriangleEqual":"\u22ED","NotSquareSubset":"\u228F\u0338","NotSquareSubsetEqual":"\u22E2","NotSquareSuperset":"\u2290\u0338","NotSquareSupersetEqual":"\u22E3","NotSubset":"\u2282\u20D2","NotSubsetEqual":"\u2288","NotSucceeds":"\u2281","NotSucceedsEqual":"\u2AB0\u0338","NotSucceedsSlantEqual":"\u22E1","NotSucceedsTilde":"\u227F\u0338","NotSuperset":"\u2283\u20D2","NotSupersetEqual":"\u2289","NotTilde":"\u2241","NotTildeEqual":"\u2244","NotTildeFullEqual":"\u2247","NotTildeTilde":"\u2249","NotVerticalBar":"\u2224","nparallel":"\u2226","npar":"\u2226","nparsl":"\u2AFD\u20E5","npart":"\u2202\u0338","npolint":"\u2A14","npr":"\u2280","nprcue":"\u22E0","nprec":"\u2280","npreceq":"\u2AAF\u0338","npre":"\u2AAF\u0338","nrarrc":"\u2933\u0338","nrarr":"\u219B","nrArr":"\u21CF","nrarrw":"\u219D\u0338","nrightarrow":"\u219B","nRightarrow":"\u21CF","nrtri":"\u22EB","nrtrie":"\u22ED","nsc":"\u2281","nsccue":"\u22E1","nsce":"\u2AB0\u0338","Nscr":"\uD835\uDCA9","nscr":"\uD835\uDCC3","nshortmid":"\u2224","nshortparallel":"\u2226","nsim":"\u2241","nsime":"\u2244","nsimeq":"\u2244","nsmid":"\u2224","nspar":"\u2226","nsqsube":"\u22E2","nsqsupe":"\u22E3","nsub":"\u2284","nsubE":"\u2AC5\u0338","nsube":"\u2288","nsubset":"\u2282\u20D2","nsubseteq":"\u2288","nsubseteqq":"\u2AC5\u0338","nsucc":"\u2281","nsucceq":"\u2AB0\u0338","nsup":"\u2285","nsupE":"\u2AC6\u0338","nsupe":"\u2289","nsupset":"\u2283\u20D2","nsupseteq":"\u2289","nsupseteqq":"\u2AC6\u0338","ntgl":"\u2279","Ntilde":"\u00D1","ntilde":"\u00F1","ntlg":"\u2278","ntriangleleft":"\u22EA","ntrianglelefteq":"\u22EC","ntriangleright":"\u22EB","ntrianglerighteq":"\u22ED","Nu":"\u039D","nu":"\u03BD","num":"#","numero":"\u2116","numsp":"\u2007","nvap":"\u224D\u20D2","nvdash":"\u22AC","nvDash":"\u22AD","nVdash":"\u22AE","nVDash":"\u22AF","nvge":"\u2265\u20D2","nvgt":">\u20D2","nvHarr":"\u2904","nvinfin":"\u29DE","nvlArr":"\u2902","nvle":"\u2264\u20D2","nvlt":"<\u20D2","nvltrie":"\u22B4\u20D2","nvrArr":"\u2903","nvrtrie":"\u22B5\u20D2","nvsim":"\u223C\u20D2","nwarhk":"\u2923","nwarr":"\u2196","nwArr":"\u21D6","nwarrow":"\u2196","nwnear":"\u2927","Oacute":"\u00D3","oacute":"\u00F3","oast":"\u229B","Ocirc":"\u00D4","ocirc":"\u00F4","ocir":"\u229A","Ocy":"\u041E","ocy":"\u043E","odash":"\u229D","Odblac":"\u0150","odblac":"\u0151","odiv":"\u2A38","odot":"\u2299","odsold":"\u29BC","OElig":"\u0152","oelig":"\u0153","ofcir":"\u29BF","Ofr":"\uD835\uDD12","ofr":"\uD835\uDD2C","ogon":"\u02DB","Ograve":"\u00D2","ograve":"\u00F2","ogt":"\u29C1","ohbar":"\u29B5","ohm":"\u03A9","oint":"\u222E","olarr":"\u21BA","olcir":"\u29BE","olcross":"\u29BB","oline":"\u203E","olt":"\u29C0","Omacr":"\u014C","omacr":"\u014D","Omega":"\u03A9","omega":"\u03C9","Omicron":"\u039F","omicron":"\u03BF","omid":"\u29B6","ominus":"\u2296","Oopf":"\uD835\uDD46","oopf":"\uD835\uDD60","opar":"\u29B7","OpenCurlyDoubleQuote":"\u201C","OpenCurlyQuote":"\u2018","operp":"\u29B9","oplus":"\u2295","orarr":"\u21BB","Or":"\u2A54","or":"\u2228","ord":"\u2A5D","order":"\u2134","orderof":"\u2134","ordf":"\u00AA","ordm":"\u00BA","origof":"\u22B6","oror":"\u2A56","orslope":"\u2A57","orv":"\u2A5B","oS":"\u24C8","Oscr":"\uD835\uDCAA","oscr":"\u2134","Oslash":"\u00D8","oslash":"\u00F8","osol":"\u2298","Otilde":"\u00D5","otilde":"\u00F5","otimesas":"\u2A36","Otimes":"\u2A37","otimes":"\u2297","Ouml":"\u00D6","ouml":"\u00F6","ovbar":"\u233D","OverBar":"\u203E","OverBrace":"\u23DE","OverBracket":"\u23B4","OverParenthesis":"\u23DC","para":"\u00B6","parallel":"\u2225","par":"\u2225","parsim":"\u2AF3","parsl":"\u2AFD","part":"\u2202","PartialD":"\u2202","Pcy":"\u041F","pcy":"\u043F","percnt":"%","period":".","permil":"\u2030","perp":"\u22A5","pertenk":"\u2031","Pfr":"\uD835\uDD13","pfr":"\uD835\uDD2D","Phi":"\u03A6","phi":"\u03C6","phiv":"\u03D5","phmmat":"\u2133","phone":"\u260E","Pi":"\u03A0","pi":"\u03C0","pitchfork":"\u22D4","piv":"\u03D6","planck":"\u210F","planckh":"\u210E","plankv":"\u210F","plusacir":"\u2A23","plusb":"\u229E","pluscir":"\u2A22","plus":"+","plusdo":"\u2214","plusdu":"\u2A25","pluse":"\u2A72","PlusMinus":"\u00B1","plusmn":"\u00B1","plussim":"\u2A26","plustwo":"\u2A27","pm":"\u00B1","Poincareplane":"\u210C","pointint":"\u2A15","popf":"\uD835\uDD61","Popf":"\u2119","pound":"\u00A3","prap":"\u2AB7","Pr":"\u2ABB","pr":"\u227A","prcue":"\u227C","precapprox":"\u2AB7","prec":"\u227A","preccurlyeq":"\u227C","Precedes":"\u227A","PrecedesEqual":"\u2AAF","PrecedesSlantEqual":"\u227C","PrecedesTilde":"\u227E","preceq":"\u2AAF","precnapprox":"\u2AB9","precneqq":"\u2AB5","precnsim":"\u22E8","pre":"\u2AAF","prE":"\u2AB3","precsim":"\u227E","prime":"\u2032","Prime":"\u2033","primes":"\u2119","prnap":"\u2AB9","prnE":"\u2AB5","prnsim":"\u22E8","prod":"\u220F","Product":"\u220F","profalar":"\u232E","profline":"\u2312","profsurf":"\u2313","prop":"\u221D","Proportional":"\u221D","Proportion":"\u2237","propto":"\u221D","prsim":"\u227E","prurel":"\u22B0","Pscr":"\uD835\uDCAB","pscr":"\uD835\uDCC5","Psi":"\u03A8","psi":"\u03C8","puncsp":"\u2008","Qfr":"\uD835\uDD14","qfr":"\uD835\uDD2E","qint":"\u2A0C","qopf":"\uD835\uDD62","Qopf":"\u211A","qprime":"\u2057","Qscr":"\uD835\uDCAC","qscr":"\uD835\uDCC6","quaternions":"\u210D","quatint":"\u2A16","quest":"?","questeq":"\u225F","quot":"\"","QUOT":"\"","rAarr":"\u21DB","race":"\u223D\u0331","Racute":"\u0154","racute":"\u0155","radic":"\u221A","raemptyv":"\u29B3","rang":"\u27E9","Rang":"\u27EB","rangd":"\u2992","range":"\u29A5","rangle":"\u27E9","raquo":"\u00BB","rarrap":"\u2975","rarrb":"\u21E5","rarrbfs":"\u2920","rarrc":"\u2933","rarr":"\u2192","Rarr":"\u21A0","rArr":"\u21D2","rarrfs":"\u291E","rarrhk":"\u21AA","rarrlp":"\u21AC","rarrpl":"\u2945","rarrsim":"\u2974","Rarrtl":"\u2916","rarrtl":"\u21A3","rarrw":"\u219D","ratail":"\u291A","rAtail":"\u291C","ratio":"\u2236","rationals":"\u211A","rbarr":"\u290D","rBarr":"\u290F","RBarr":"\u2910","rbbrk":"\u2773","rbrace":"}","rbrack":"]","rbrke":"\u298C","rbrksld":"\u298E","rbrkslu":"\u2990","Rcaron":"\u0158","rcaron":"\u0159","Rcedil":"\u0156","rcedil":"\u0157","rceil":"\u2309","rcub":"}","Rcy":"\u0420","rcy":"\u0440","rdca":"\u2937","rdldhar":"\u2969","rdquo":"\u201D","rdquor":"\u201D","rdsh":"\u21B3","real":"\u211C","realine":"\u211B","realpart":"\u211C","reals":"\u211D","Re":"\u211C","rect":"\u25AD","reg":"\u00AE","REG":"\u00AE","ReverseElement":"\u220B","ReverseEquilibrium":"\u21CB","ReverseUpEquilibrium":"\u296F","rfisht":"\u297D","rfloor":"\u230B","rfr":"\uD835\uDD2F","Rfr":"\u211C","rHar":"\u2964","rhard":"\u21C1","rharu":"\u21C0","rharul":"\u296C","Rho":"\u03A1","rho":"\u03C1","rhov":"\u03F1","RightAngleBracket":"\u27E9","RightArrowBar":"\u21E5","rightarrow":"\u2192","RightArrow":"\u2192","Rightarrow":"\u21D2","RightArrowLeftArrow":"\u21C4","rightarrowtail":"\u21A3","RightCeiling":"\u2309","RightDoubleBracket":"\u27E7","RightDownTeeVector":"\u295D","RightDownVectorBar":"\u2955","RightDownVector":"\u21C2","RightFloor":"\u230B","rightharpoondown":"\u21C1","rightharpoonup":"\u21C0","rightleftarrows":"\u21C4","rightleftharpoons":"\u21CC","rightrightarrows":"\u21C9","rightsquigarrow":"\u219D","RightTeeArrow":"\u21A6","RightTee":"\u22A2","RightTeeVector":"\u295B","rightthreetimes":"\u22CC","RightTriangleBar":"\u29D0","RightTriangle":"\u22B3","RightTriangleEqual":"\u22B5","RightUpDownVector":"\u294F","RightUpTeeVector":"\u295C","RightUpVectorBar":"\u2954","RightUpVector":"\u21BE","RightVectorBar":"\u2953","RightVector":"\u21C0","ring":"\u02DA","risingdotseq":"\u2253","rlarr":"\u21C4","rlhar":"\u21CC","rlm":"\u200F","rmoustache":"\u23B1","rmoust":"\u23B1","rnmid":"\u2AEE","roang":"\u27ED","roarr":"\u21FE","robrk":"\u27E7","ropar":"\u2986","ropf":"\uD835\uDD63","Ropf":"\u211D","roplus":"\u2A2E","rotimes":"\u2A35","RoundImplies":"\u2970","rpar":")","rpargt":"\u2994","rppolint":"\u2A12","rrarr":"\u21C9","Rrightarrow":"\u21DB","rsaquo":"\u203A","rscr":"\uD835\uDCC7","Rscr":"\u211B","rsh":"\u21B1","Rsh":"\u21B1","rsqb":"]","rsquo":"\u2019","rsquor":"\u2019","rthree":"\u22CC","rtimes":"\u22CA","rtri":"\u25B9","rtrie":"\u22B5","rtrif":"\u25B8","rtriltri":"\u29CE","RuleDelayed":"\u29F4","ruluhar":"\u2968","rx":"\u211E","Sacute":"\u015A","sacute":"\u015B","sbquo":"\u201A","scap":"\u2AB8","Scaron":"\u0160","scaron":"\u0161","Sc":"\u2ABC","sc":"\u227B","sccue":"\u227D","sce":"\u2AB0","scE":"\u2AB4","Scedil":"\u015E","scedil":"\u015F","Scirc":"\u015C","scirc":"\u015D","scnap":"\u2ABA","scnE":"\u2AB6","scnsim":"\u22E9","scpolint":"\u2A13","scsim":"\u227F","Scy":"\u0421","scy":"\u0441","sdotb":"\u22A1","sdot":"\u22C5","sdote":"\u2A66","searhk":"\u2925","searr":"\u2198","seArr":"\u21D8","searrow":"\u2198","sect":"\u00A7","semi":";","seswar":"\u2929","setminus":"\u2216","setmn":"\u2216","sext":"\u2736","Sfr":"\uD835\uDD16","sfr":"\uD835\uDD30","sfrown":"\u2322","sharp":"\u266F","SHCHcy":"\u0429","shchcy":"\u0449","SHcy":"\u0428","shcy":"\u0448","ShortDownArrow":"\u2193","ShortLeftArrow":"\u2190","shortmid":"\u2223","shortparallel":"\u2225","ShortRightArrow":"\u2192","ShortUpArrow":"\u2191","shy":"\u00AD","Sigma":"\u03A3","sigma":"\u03C3","sigmaf":"\u03C2","sigmav":"\u03C2","sim":"\u223C","simdot":"\u2A6A","sime":"\u2243","simeq":"\u2243","simg":"\u2A9E","simgE":"\u2AA0","siml":"\u2A9D","simlE":"\u2A9F","simne":"\u2246","simplus":"\u2A24","simrarr":"\u2972","slarr":"\u2190","SmallCircle":"\u2218","smallsetminus":"\u2216","smashp":"\u2A33","smeparsl":"\u29E4","smid":"\u2223","smile":"\u2323","smt":"\u2AAA","smte":"\u2AAC","smtes":"\u2AAC\uFE00","SOFTcy":"\u042C","softcy":"\u044C","solbar":"\u233F","solb":"\u29C4","sol":"/","Sopf":"\uD835\uDD4A","sopf":"\uD835\uDD64","spades":"\u2660","spadesuit":"\u2660","spar":"\u2225","sqcap":"\u2293","sqcaps":"\u2293\uFE00","sqcup":"\u2294","sqcups":"\u2294\uFE00","Sqrt":"\u221A","sqsub":"\u228F","sqsube":"\u2291","sqsubset":"\u228F","sqsubseteq":"\u2291","sqsup":"\u2290","sqsupe":"\u2292","sqsupset":"\u2290","sqsupseteq":"\u2292","square":"\u25A1","Square":"\u25A1","SquareIntersection":"\u2293","SquareSubset":"\u228F","SquareSubsetEqual":"\u2291","SquareSuperset":"\u2290","SquareSupersetEqual":"\u2292","SquareUnion":"\u2294","squarf":"\u25AA","squ":"\u25A1","squf":"\u25AA","srarr":"\u2192","Sscr":"\uD835\uDCAE","sscr":"\uD835\uDCC8","ssetmn":"\u2216","ssmile":"\u2323","sstarf":"\u22C6","Star":"\u22C6","star":"\u2606","starf":"\u2605","straightepsilon":"\u03F5","straightphi":"\u03D5","strns":"\u00AF","sub":"\u2282","Sub":"\u22D0","subdot":"\u2ABD","subE":"\u2AC5","sube":"\u2286","subedot":"\u2AC3","submult":"\u2AC1","subnE":"\u2ACB","subne":"\u228A","subplus":"\u2ABF","subrarr":"\u2979","subset":"\u2282","Subset":"\u22D0","subseteq":"\u2286","subseteqq":"\u2AC5","SubsetEqual":"\u2286","subsetneq":"\u228A","subsetneqq":"\u2ACB","subsim":"\u2AC7","subsub":"\u2AD5","subsup":"\u2AD3","succapprox":"\u2AB8","succ":"\u227B","succcurlyeq":"\u227D","Succeeds":"\u227B","SucceedsEqual":"\u2AB0","SucceedsSlantEqual":"\u227D","SucceedsTilde":"\u227F","succeq":"\u2AB0","succnapprox":"\u2ABA","succneqq":"\u2AB6","succnsim":"\u22E9","succsim":"\u227F","SuchThat":"\u220B","sum":"\u2211","Sum":"\u2211","sung":"\u266A","sup1":"\u00B9","sup2":"\u00B2","sup3":"\u00B3","sup":"\u2283","Sup":"\u22D1","supdot":"\u2ABE","supdsub":"\u2AD8","supE":"\u2AC6","supe":"\u2287","supedot":"\u2AC4","Superset":"\u2283","SupersetEqual":"\u2287","suphsol":"\u27C9","suphsub":"\u2AD7","suplarr":"\u297B","supmult":"\u2AC2","supnE":"\u2ACC","supne":"\u228B","supplus":"\u2AC0","supset":"\u2283","Supset":"\u22D1","supseteq":"\u2287","supseteqq":"\u2AC6","supsetneq":"\u228B","supsetneqq":"\u2ACC","supsim":"\u2AC8","supsub":"\u2AD4","supsup":"\u2AD6","swarhk":"\u2926","swarr":"\u2199","swArr":"\u21D9","swarrow":"\u2199","swnwar":"\u292A","szlig":"\u00DF","Tab":"\t","target":"\u2316","Tau":"\u03A4","tau":"\u03C4","tbrk":"\u23B4","Tcaron":"\u0164","tcaron":"\u0165","Tcedil":"\u0162","tcedil":"\u0163","Tcy":"\u0422","tcy":"\u0442","tdot":"\u20DB","telrec":"\u2315","Tfr":"\uD835\uDD17","tfr":"\uD835\uDD31","there4":"\u2234","therefore":"\u2234","Therefore":"\u2234","Theta":"\u0398","theta":"\u03B8","thetasym":"\u03D1","thetav":"\u03D1","thickapprox":"\u2248","thicksim":"\u223C","ThickSpace":"\u205F\u200A","ThinSpace":"\u2009","thinsp":"\u2009","thkap":"\u2248","thksim":"\u223C","THORN":"\u00DE","thorn":"\u00FE","tilde":"\u02DC","Tilde":"\u223C","TildeEqual":"\u2243","TildeFullEqual":"\u2245","TildeTilde":"\u2248","timesbar":"\u2A31","timesb":"\u22A0","times":"\u00D7","timesd":"\u2A30","tint":"\u222D","toea":"\u2928","topbot":"\u2336","topcir":"\u2AF1","top":"\u22A4","Topf":"\uD835\uDD4B","topf":"\uD835\uDD65","topfork":"\u2ADA","tosa":"\u2929","tprime":"\u2034","trade":"\u2122","TRADE":"\u2122","triangle":"\u25B5","triangledown":"\u25BF","triangleleft":"\u25C3","trianglelefteq":"\u22B4","triangleq":"\u225C","triangleright":"\u25B9","trianglerighteq":"\u22B5","tridot":"\u25EC","trie":"\u225C","triminus":"\u2A3A","TripleDot":"\u20DB","triplus":"\u2A39","trisb":"\u29CD","tritime":"\u2A3B","trpezium":"\u23E2","Tscr":"\uD835\uDCAF","tscr":"\uD835\uDCC9","TScy":"\u0426","tscy":"\u0446","TSHcy":"\u040B","tshcy":"\u045B","Tstrok":"\u0166","tstrok":"\u0167","twixt":"\u226C","twoheadleftarrow":"\u219E","twoheadrightarrow":"\u21A0","Uacute":"\u00DA","uacute":"\u00FA","uarr":"\u2191","Uarr":"\u219F","uArr":"\u21D1","Uarrocir":"\u2949","Ubrcy":"\u040E","ubrcy":"\u045E","Ubreve":"\u016C","ubreve":"\u016D","Ucirc":"\u00DB","ucirc":"\u00FB","Ucy":"\u0423","ucy":"\u0443","udarr":"\u21C5","Udblac":"\u0170","udblac":"\u0171","udhar":"\u296E","ufisht":"\u297E","Ufr":"\uD835\uDD18","ufr":"\uD835\uDD32","Ugrave":"\u00D9","ugrave":"\u00F9","uHar":"\u2963","uharl":"\u21BF","uharr":"\u21BE","uhblk":"\u2580","ulcorn":"\u231C","ulcorner":"\u231C","ulcrop":"\u230F","ultri":"\u25F8","Umacr":"\u016A","umacr":"\u016B","uml":"\u00A8","UnderBar":"_","UnderBrace":"\u23DF","UnderBracket":"\u23B5","UnderParenthesis":"\u23DD","Union":"\u22C3","UnionPlus":"\u228E","Uogon":"\u0172","uogon":"\u0173","Uopf":"\uD835\uDD4C","uopf":"\uD835\uDD66","UpArrowBar":"\u2912","uparrow":"\u2191","UpArrow":"\u2191","Uparrow":"\u21D1","UpArrowDownArrow":"\u21C5","updownarrow":"\u2195","UpDownArrow":"\u2195","Updownarrow":"\u21D5","UpEquilibrium":"\u296E","upharpoonleft":"\u21BF","upharpoonright":"\u21BE","uplus":"\u228E","UpperLeftArrow":"\u2196","UpperRightArrow":"\u2197","upsi":"\u03C5","Upsi":"\u03D2","upsih":"\u03D2","Upsilon":"\u03A5","upsilon":"\u03C5","UpTeeArrow":"\u21A5","UpTee":"\u22A5","upuparrows":"\u21C8","urcorn":"\u231D","urcorner":"\u231D","urcrop":"\u230E","Uring":"\u016E","uring":"\u016F","urtri":"\u25F9","Uscr":"\uD835\uDCB0","uscr":"\uD835\uDCCA","utdot":"\u22F0","Utilde":"\u0168","utilde":"\u0169","utri":"\u25B5","utrif":"\u25B4","uuarr":"\u21C8","Uuml":"\u00DC","uuml":"\u00FC","uwangle":"\u29A7","vangrt":"\u299C","varepsilon":"\u03F5","varkappa":"\u03F0","varnothing":"\u2205","varphi":"\u03D5","varpi":"\u03D6","varpropto":"\u221D","varr":"\u2195","vArr":"\u21D5","varrho":"\u03F1","varsigma":"\u03C2","varsubsetneq":"\u228A\uFE00","varsubsetneqq":"\u2ACB\uFE00","varsupsetneq":"\u228B\uFE00","varsupsetneqq":"\u2ACC\uFE00","vartheta":"\u03D1","vartriangleleft":"\u22B2","vartriangleright":"\u22B3","vBar":"\u2AE8","Vbar":"\u2AEB","vBarv":"\u2AE9","Vcy":"\u0412","vcy":"\u0432","vdash":"\u22A2","vDash":"\u22A8","Vdash":"\u22A9","VDash":"\u22AB","Vdashl":"\u2AE6","veebar":"\u22BB","vee":"\u2228","Vee":"\u22C1","veeeq":"\u225A","vellip":"\u22EE","verbar":"|","Verbar":"\u2016","vert":"|","Vert":"\u2016","VerticalBar":"\u2223","VerticalLine":"|","VerticalSeparator":"\u2758","VerticalTilde":"\u2240","VeryThinSpace":"\u200A","Vfr":"\uD835\uDD19","vfr":"\uD835\uDD33","vltri":"\u22B2","vnsub":"\u2282\u20D2","vnsup":"\u2283\u20D2","Vopf":"\uD835\uDD4D","vopf":"\uD835\uDD67","vprop":"\u221D","vrtri":"\u22B3","Vscr":"\uD835\uDCB1","vscr":"\uD835\uDCCB","vsubnE":"\u2ACB\uFE00","vsubne":"\u228A\uFE00","vsupnE":"\u2ACC\uFE00","vsupne":"\u228B\uFE00","Vvdash":"\u22AA","vzigzag":"\u299A","Wcirc":"\u0174","wcirc":"\u0175","wedbar":"\u2A5F","wedge":"\u2227","Wedge":"\u22C0","wedgeq":"\u2259","weierp":"\u2118","Wfr":"\uD835\uDD1A","wfr":"\uD835\uDD34","Wopf":"\uD835\uDD4E","wopf":"\uD835\uDD68","wp":"\u2118","wr":"\u2240","wreath":"\u2240","Wscr":"\uD835\uDCB2","wscr":"\uD835\uDCCC","xcap":"\u22C2","xcirc":"\u25EF","xcup":"\u22C3","xdtri":"\u25BD","Xfr":"\uD835\uDD1B","xfr":"\uD835\uDD35","xharr":"\u27F7","xhArr":"\u27FA","Xi":"\u039E","xi":"\u03BE","xlarr":"\u27F5","xlArr":"\u27F8","xmap":"\u27FC","xnis":"\u22FB","xodot":"\u2A00","Xopf":"\uD835\uDD4F","xopf":"\uD835\uDD69","xoplus":"\u2A01","xotime":"\u2A02","xrarr":"\u27F6","xrArr":"\u27F9","Xscr":"\uD835\uDCB3","xscr":"\uD835\uDCCD","xsqcup":"\u2A06","xuplus":"\u2A04","xutri":"\u25B3","xvee":"\u22C1","xwedge":"\u22C0","Yacute":"\u00DD","yacute":"\u00FD","YAcy":"\u042F","yacy":"\u044F","Ycirc":"\u0176","ycirc":"\u0177","Ycy":"\u042B","ycy":"\u044B","yen":"\u00A5","Yfr":"\uD835\uDD1C","yfr":"\uD835\uDD36","YIcy":"\u0407","yicy":"\u0457","Yopf":"\uD835\uDD50","yopf":"\uD835\uDD6A","Yscr":"\uD835\uDCB4","yscr":"\uD835\uDCCE","YUcy":"\u042E","yucy":"\u044E","yuml":"\u00FF","Yuml":"\u0178","Zacute":"\u0179","zacute":"\u017A","Zcaron":"\u017D","zcaron":"\u017E","Zcy":"\u0417","zcy":"\u0437","Zdot":"\u017B","zdot":"\u017C","zeetrf":"\u2128","ZeroWidthSpace":"\u200B","Zeta":"\u0396","zeta":"\u03B6","zfr":"\uD835\uDD37","Zfr":"\u2128","ZHcy":"\u0416","zhcy":"\u0436","zigrarr":"\u21DD","zopf":"\uD835\uDD6B","Zopf":"\u2124","Zscr":"\uD835\uDCB5","zscr":"\uD835\uDCCF","zwj":"\u200D","zwnj":"\u200C"}},{}],53:[function(require,module,exports){'use strict';function assign(obj){var sources=Array.prototype.slice.call(arguments,1);sources.forEach(function(source){if(!source){return;}
Object.keys(source).forEach(function(key){obj[key]=source[key];});});return obj;}
function _class(obj){return Object.prototype.toString.call(obj);}
function isString(obj){return _class(obj)==='[object String]';}
function isObject(obj){return _class(obj)==='[object Object]';}
function isRegExp(obj){return _class(obj)==='[object RegExp]';}
function isFunction(obj){return _class(obj)==='[object Function]';}
function escapeRE(str){return str.replace(/[.?*+^$[\]\\(){}|-]/g,'\\$&');}
var defaultOptions={fuzzyLink:true,fuzzyEmail:true,fuzzyIP:false};function isOptionsObj(obj){return Object.keys(obj||{}).reduce(function(acc,k){return acc||defaultOptions.hasOwnProperty(k);},false);}
var defaultSchemas={'http:':{validate:function(text,pos,self){var tail=text.slice(pos);if(!self.re.http){self.re.http=new RegExp('^\\/\\/'+self.re.src_auth+self.re.src_host_port_strict+self.re.src_path,'i');}
if(self.re.http.test(tail)){return tail.match(self.re.http)[0].length;}
return 0;}},'https:':'http:','ftp:':'http:','//':{validate:function(text,pos,self){var tail=text.slice(pos);if(!self.re.no_http){self.re.no_http=new RegExp('^'+
self.re.src_auth+'(?:localhost|(?:(?:'+self.re.src_domain+')\\.)+'+self.re.src_domain_root+')'+
self.re.src_port+
self.re.src_host_terminator+
self.re.src_path,'i');}
if(self.re.no_http.test(tail)){if(pos>=3&&text[pos-3]===':'){return 0;}
if(pos>=3&&text[pos-3]==='/'){return 0;}
return tail.match(self.re.no_http)[0].length;}
return 0;}},'mailto:':{validate:function(text,pos,self){var tail=text.slice(pos);if(!self.re.mailto){self.re.mailto=new RegExp('^'+self.re.src_email_name+'@'+self.re.src_host_strict,'i');}
if(self.re.mailto.test(tail)){return tail.match(self.re.mailto)[0].length;}
return 0;}}};var tlds_2ch_src_re='a[cdefgilmnoqrstuwxz]|b[abdefghijmnorstvwyz]|c[acdfghiklmnoruvwxyz]|d[ejkmoz]|e[cegrstu]|f[ijkmor]|g[abdefghilmnpqrstuwy]|h[kmnrtu]|i[delmnoqrst]|j[emop]|k[eghimnprwyz]|l[abcikrstuvy]|m[acdeghklmnopqrstuvwxyz]|n[acefgilopruz]|om|p[aefghklmnrstwy]|qa|r[eosuw]|s[abcdeghijklmnortuvxyz]|t[cdfghjklmnortvwz]|u[agksyz]|v[aceginu]|w[fs]|y[et]|z[amw]';var tlds_default='biz|com|edu|gov|net|org|pro|web|xxx|aero|asia|coop|info|museum|name|shop|Ñ€Ñ„'.split('|');function resetScanCache(self){self.__index__=-1;self.__text_cache__='';}
function createValidator(re){return function(text,pos){var tail=text.slice(pos);if(re.test(tail)){return tail.match(re)[0].length;}
return 0;};}
function createNormalizer(){return function(match,self){self.normalize(match);};}
function compile(self){var re=self.re=require('./lib/re')(self.__opts__);var tlds=self.__tlds__.slice();self.onCompile();if(!self.__tlds_replaced__){tlds.push(tlds_2ch_src_re);}
tlds.push(re.src_xn);re.src_tlds=tlds.join('|');function untpl(tpl){return tpl.replace('%TLDS%',re.src_tlds);}
re.email_fuzzy=RegExp(untpl(re.tpl_email_fuzzy),'i');re.link_fuzzy=RegExp(untpl(re.tpl_link_fuzzy),'i');re.link_no_ip_fuzzy=RegExp(untpl(re.tpl_link_no_ip_fuzzy),'i');re.host_fuzzy_test=RegExp(untpl(re.tpl_host_fuzzy_test),'i');var aliases=[];self.__compiled__={};function schemaError(name,val){throw new Error('(LinkifyIt) Invalid schema "'+name+'": '+val);}
Object.keys(self.__schemas__).forEach(function(name){var val=self.__schemas__[name];if(val===null){return;}
var compiled={validate:null,link:null};self.__compiled__[name]=compiled;if(isObject(val)){if(isRegExp(val.validate)){compiled.validate=createValidator(val.validate);}else if(isFunction(val.validate)){compiled.validate=val.validate;}else{schemaError(name,val);}
if(isFunction(val.normalize)){compiled.normalize=val.normalize;}else if(!val.normalize){compiled.normalize=createNormalizer();}else{schemaError(name,val);}
return;}
if(isString(val)){aliases.push(name);return;}
schemaError(name,val);});aliases.forEach(function(alias){if(!self.__compiled__[self.__schemas__[alias]]){return;}
self.__compiled__[alias].validate=self.__compiled__[self.__schemas__[alias]].validate;self.__compiled__[alias].normalize=self.__compiled__[self.__schemas__[alias]].normalize;});self.__compiled__['']={validate:null,normalize:createNormalizer()};var slist=Object.keys(self.__compiled__).filter(function(name){return name.length>0&&self.__compiled__[name];}).map(escapeRE).join('|');self.re.schema_test=RegExp('(^|(?!_)(?:[><\uff5c]|'+re.src_ZPCc+'))('+slist+')','i');self.re.schema_search=RegExp('(^|(?!_)(?:[><\uff5c]|'+re.src_ZPCc+'))('+slist+')','ig');self.re.pretest=RegExp('('+self.re.schema_test.source+')|'+'('+self.re.host_fuzzy_test.source+')|'+'@','i');resetScanCache(self);}
function Match(self,shift){var start=self.__index__,end=self.__last_index__,text=self.__text_cache__.slice(start,end);this.schema=self.__schema__.toLowerCase();this.index=start+shift;this.lastIndex=end+shift;this.raw=text;this.text=text;this.url=text;}
function createMatch(self,shift){var match=new Match(self,shift);self.__compiled__[match.schema].normalize(match,self);return match;}
function LinkifyIt(schemas,options){if(!(this instanceof LinkifyIt)){return new LinkifyIt(schemas,options);}
if(!options){if(isOptionsObj(schemas)){options=schemas;schemas={};}}
this.__opts__=assign({},defaultOptions,options);this.__index__=-1;this.__last_index__=-1;this.__schema__='';this.__text_cache__='';this.__schemas__=assign({},defaultSchemas,schemas);this.__compiled__={};this.__tlds__=tlds_default;this.__tlds_replaced__=false;this.re={};compile(this);}
LinkifyIt.prototype.add=function add(schema,definition){this.__schemas__[schema]=definition;compile(this);return this;};LinkifyIt.prototype.set=function set(options){this.__opts__=assign(this.__opts__,options);return this;};LinkifyIt.prototype.test=function test(text){this.__text_cache__=text;this.__index__=-1;if(!text.length){return false;}
var m,ml,me,len,shift,next,re,tld_pos,at_pos;if(this.re.schema_test.test(text)){re=this.re.schema_search;re.lastIndex=0;while((m=re.exec(text))!==null){len=this.testSchemaAt(text,m[2],re.lastIndex);if(len){this.__schema__=m[2];this.__index__=m.index+m[1].length;this.__last_index__=m.index+m[0].length+len;break;}}}
if(this.__opts__.fuzzyLink&&this.__compiled__['http:']){tld_pos=text.search(this.re.host_fuzzy_test);if(tld_pos>=0){if(this.__index__<0||tld_pos<this.__index__){if((ml=text.match(this.__opts__.fuzzyIP?this.re.link_fuzzy:this.re.link_no_ip_fuzzy))!==null){shift=ml.index+ml[1].length;if(this.__index__<0||shift<this.__index__){this.__schema__='';this.__index__=shift;this.__last_index__=ml.index+ml[0].length;}}}}}
if(this.__opts__.fuzzyEmail&&this.__compiled__['mailto:']){at_pos=text.indexOf('@');if(at_pos>=0){if((me=text.match(this.re.email_fuzzy))!==null){shift=me.index+me[1].length;next=me.index+me[0].length;if(this.__index__<0||shift<this.__index__||(shift===this.__index__&&next>this.__last_index__)){this.__schema__='mailto:';this.__index__=shift;this.__last_index__=next;}}}}
return this.__index__>=0;};LinkifyIt.prototype.pretest=function pretest(text){return this.re.pretest.test(text);};LinkifyIt.prototype.testSchemaAt=function testSchemaAt(text,schema,pos){if(!this.__compiled__[schema.toLowerCase()]){return 0;}
return this.__compiled__[schema.toLowerCase()].validate(text,pos,this);};LinkifyIt.prototype.match=function match(text){var shift=0,result=[];if(this.__index__>=0&&this.__text_cache__===text){result.push(createMatch(this,shift));shift=this.__last_index__;}
var tail=shift?text.slice(shift):text;while(this.test(tail)){result.push(createMatch(this,shift));tail=tail.slice(this.__last_index__);shift+=this.__last_index__;}
if(result.length){return result;}
return null;};LinkifyIt.prototype.tlds=function tlds(list,keepOld){list=Array.isArray(list)?list:[list];if(!keepOld){this.__tlds__=list.slice();this.__tlds_replaced__=true;compile(this);return this;}
this.__tlds__=this.__tlds__.concat(list).sort().filter(function(el,idx,arr){return el!==arr[idx-1];}).reverse();compile(this);return this;};LinkifyIt.prototype.normalize=function normalize(match){if(!match.schema){match.url='http://'+match.url;}
if(match.schema==='mailto:'&&!/^mailto:/i.test(match.url)){match.url='mailto:'+match.url;}};LinkifyIt.prototype.onCompile=function onCompile(){};module.exports=LinkifyIt;},{"./lib/re":54}],54:[function(require,module,exports){'use strict';module.exports=function(opts){var re={};re.src_Any=require('uc.micro/properties/Any/regex').source;re.src_Cc=require('uc.micro/categories/Cc/regex').source;re.src_Z=require('uc.micro/categories/Z/regex').source;re.src_P=require('uc.micro/categories/P/regex').source;re.src_ZPCc=[re.src_Z,re.src_P,re.src_Cc].join('|');re.src_ZCc=[re.src_Z,re.src_Cc].join('|');var text_separators='[><\uff5c]';re.src_pseudo_letter='(?:(?!'+text_separators+'|'+re.src_ZPCc+')'+re.src_Any+')';re.src_ip4='(?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)';re.src_auth='(?:(?:(?!'+re.src_ZCc+'|[@/\\[\\]()]).)+@)?';re.src_port='(?::(?:6(?:[0-4]\\d{3}|5(?:[0-4]\\d{2}|5(?:[0-2]\\d|3[0-5])))|[1-5]?\\d{1,4}))?';re.src_host_terminator='(?=$|'+text_separators+'|'+re.src_ZPCc+')(?!-|_|:\\d|\\.-|\\.(?!$|'+re.src_ZPCc+'))';re.src_path='(?:'+'[/?#]'+'(?:'+'(?!'+re.src_ZCc+'|'+text_separators+'|[()[\\]{}.,"\'?!\\-]).|'+'\\[(?:(?!'+re.src_ZCc+'|\\]).)*\\]|'+'\\((?:(?!'+re.src_ZCc+'|[)]).)*\\)|'+'\\{(?:(?!'+re.src_ZCc+'|[}]).)*\\}|'+'\\"(?:(?!'+re.src_ZCc+'|["]).)+\\"|'+"\\'(?:(?!"+re.src_ZCc+"|[']).)+\\'|"+"\\'(?="+re.src_pseudo_letter+'|[-]).|'+'\\.{2,3}[a-zA-Z0-9%/]|'+'\\.(?!'+re.src_ZCc+'|[.]).|'+
(opts&&opts['---']?'\\-(?!--(?:[^-]|$))(?:-*)|':'\\-+|')+'\\,(?!'+re.src_ZCc+').|'+'\\!(?!'+re.src_ZCc+'|[!]).|'+'\\?(?!'+re.src_ZCc+'|[?]).'+')+'+'|\\/'+')?';re.src_email_name='[\\-;:&=\\+\\$,\\"\\.a-zA-Z0-9_]+';re.src_xn='xn--[a-z0-9\\-]{1,59}';re.src_domain_root='(?:'+
re.src_xn+'|'+
re.src_pseudo_letter+'{1,63}'+')';re.src_domain='(?:'+
re.src_xn+'|'+'(?:'+re.src_pseudo_letter+')'+'|'+'(?:'+re.src_pseudo_letter+'(?:-(?!-)|'+re.src_pseudo_letter+'){0,61}'+re.src_pseudo_letter+')'+')';re.src_host='(?:'+'(?:(?:(?:'+re.src_domain+')\\.)*'+re.src_domain+')'+')';re.tpl_host_fuzzy='(?:'+
re.src_ip4+'|'+'(?:(?:(?:'+re.src_domain+')\\.)+(?:%TLDS%))'+')';re.tpl_host_no_ip_fuzzy='(?:(?:(?:'+re.src_domain+')\\.)+(?:%TLDS%))';re.src_host_strict=re.src_host+re.src_host_terminator;re.tpl_host_fuzzy_strict=re.tpl_host_fuzzy+re.src_host_terminator;re.src_host_port_strict=re.src_host+re.src_port+re.src_host_terminator;re.tpl_host_port_fuzzy_strict=re.tpl_host_fuzzy+re.src_port+re.src_host_terminator;re.tpl_host_port_no_ip_fuzzy_strict=re.tpl_host_no_ip_fuzzy+re.src_port+re.src_host_terminator;re.tpl_host_fuzzy_test='localhost|www\\.|\\.\\d{1,3}\\.|(?:\\.(?:%TLDS%)(?:'+re.src_ZPCc+'|>|$))';re.tpl_email_fuzzy='(^|'+text_separators+'|\\(|'+re.src_ZCc+')('+re.src_email_name+'@'+re.tpl_host_fuzzy_strict+')';re.tpl_link_fuzzy='(^|(?![.:/\\-_@])(?:[$+<=>^`|\uff5c]|'+re.src_ZPCc+'))'+'((?![$+<=>^`|\uff5c])'+re.tpl_host_port_fuzzy_strict+re.src_path+')';re.tpl_link_no_ip_fuzzy='(^|(?![.:/\\-_@])(?:[$+<=>^`|\uff5c]|'+re.src_ZPCc+'))'+'((?![$+<=>^`|\uff5c])'+re.tpl_host_port_no_ip_fuzzy_strict+re.src_path+')';return re;};},{"uc.micro/categories/Cc/regex":61,"uc.micro/categories/P/regex":63,"uc.micro/categories/Z/regex":64,"uc.micro/properties/Any/regex":66}],55:[function(require,module,exports){'use strict';var decodeCache={};function getDecodeCache(exclude){var i,ch,cache=decodeCache[exclude];if(cache){return cache;}
cache=decodeCache[exclude]=[];for(i=0;i<128;i++){ch=String.fromCharCode(i);cache.push(ch);}
for(i=0;i<exclude.length;i++){ch=exclude.charCodeAt(i);cache[ch]='%'+('0'+ch.toString(16).toUpperCase()).slice(-2);}
return cache;}
function decode(string,exclude){var cache;if(typeof exclude!=='string'){exclude=decode.defaultChars;}
cache=getDecodeCache(exclude);return string.replace(/(%[a-f0-9]{2})+/gi,function(seq){var i,l,b1,b2,b3,b4,chr,result='';for(i=0,l=seq.length;i<l;i+=3){b1=parseInt(seq.slice(i+1,i+3),16);if(b1<0x80){result+=cache[b1];continue;}
if((b1&0xE0)===0xC0&&(i+3<l)){b2=parseInt(seq.slice(i+4,i+6),16);if((b2&0xC0)===0x80){chr=((b1<<6)&0x7C0)|(b2&0x3F);if(chr<0x80){result+='\ufffd\ufffd';}else{result+=String.fromCharCode(chr);}
i+=3;continue;}}
if((b1&0xF0)===0xE0&&(i+6<l)){b2=parseInt(seq.slice(i+4,i+6),16);b3=parseInt(seq.slice(i+7,i+9),16);if((b2&0xC0)===0x80&&(b3&0xC0)===0x80){chr=((b1<<12)&0xF000)|((b2<<6)&0xFC0)|(b3&0x3F);if(chr<0x800||(chr>=0xD800&&chr<=0xDFFF)){result+='\ufffd\ufffd\ufffd';}else{result+=String.fromCharCode(chr);}
i+=6;continue;}}
if((b1&0xF8)===0xF0&&(i+9<l)){b2=parseInt(seq.slice(i+4,i+6),16);b3=parseInt(seq.slice(i+7,i+9),16);b4=parseInt(seq.slice(i+10,i+12),16);if((b2&0xC0)===0x80&&(b3&0xC0)===0x80&&(b4&0xC0)===0x80){chr=((b1<<18)&0x1C0000)|((b2<<12)&0x3F000)|((b3<<6)&0xFC0)|(b4&0x3F);if(chr<0x10000||chr>0x10FFFF){result+='\ufffd\ufffd\ufffd\ufffd';}else{chr-=0x10000;result+=String.fromCharCode(0xD800+(chr>>10),0xDC00+(chr&0x3FF));}
i+=9;continue;}}
result+='\ufffd';}
return result;});}
decode.defaultChars=';/?:@&=+$,#';decode.componentChars='';module.exports=decode;},{}],56:[function(require,module,exports){'use strict';var encodeCache={};function getEncodeCache(exclude){var i,ch,cache=encodeCache[exclude];if(cache){return cache;}
cache=encodeCache[exclude]=[];for(i=0;i<128;i++){ch=String.fromCharCode(i);if(/^[0-9a-z]$/i.test(ch)){cache.push(ch);}else{cache.push('%'+('0'+i.toString(16).toUpperCase()).slice(-2));}}
for(i=0;i<exclude.length;i++){cache[exclude.charCodeAt(i)]=exclude[i];}
return cache;}
function encode(string,exclude,keepEscaped){var i,l,code,nextCode,cache,result='';if(typeof exclude!=='string'){keepEscaped=exclude;exclude=encode.defaultChars;}
if(typeof keepEscaped==='undefined'){keepEscaped=true;}
cache=getEncodeCache(exclude);for(i=0,l=string.length;i<l;i++){code=string.charCodeAt(i);if(keepEscaped&&code===0x25&&i+2<l){if(/^[0-9a-f]{2}$/i.test(string.slice(i+1,i+3))){result+=string.slice(i,i+3);i+=2;continue;}}
if(code<128){result+=cache[code];continue;}
if(code>=0xD800&&code<=0xDFFF){if(code>=0xD800&&code<=0xDBFF&&i+1<l){nextCode=string.charCodeAt(i+1);if(nextCode>=0xDC00&&nextCode<=0xDFFF){result+=encodeURIComponent(string[i]+string[i+1]);i++;continue;}}
result+='%EF%BF%BD';continue;}
result+=encodeURIComponent(string[i]);}
return result;}
encode.defaultChars=";/?:@&=+$,-_.!~*'()#";encode.componentChars="-_.!~*'()";module.exports=encode;},{}],57:[function(require,module,exports){'use strict';module.exports=function format(url){var result='';result+=url.protocol||'';result+=url.slashes?'//':'';result+=url.auth?url.auth+'@':'';if(url.hostname&&url.hostname.indexOf(':')!==-1){result+='['+url.hostname+']';}else{result+=url.hostname||'';}
result+=url.port?':'+url.port:'';result+=url.pathname||'';result+=url.search||'';result+=url.hash||'';return result;};},{}],58:[function(require,module,exports){'use strict';module.exports.encode=require('./encode');module.exports.decode=require('./decode');module.exports.format=require('./format');module.exports.parse=require('./parse');},{"./decode":55,"./encode":56,"./format":57,"./parse":59}],59:[function(require,module,exports){'use strict';function Url(){this.protocol=null;this.slashes=null;this.auth=null;this.port=null;this.hostname=null;this.hash=null;this.search=null;this.pathname=null;}
var protocolPattern=/^([a-z0-9.+-]+:)/i,portPattern=/:[0-9]*$/,simplePathPattern=/^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,delims=['<','>','"','`',' ','\r','\n','\t'],unwise=['{','}','|','\\','^','`'].concat(delims),autoEscape=['\''].concat(unwise),nonHostChars=['%','/','?',';','#'].concat(autoEscape),hostEndingChars=['/','?','#'],hostnameMaxLen=255,hostnamePartPattern=/^[+a-z0-9A-Z_-]{0,63}$/,hostnamePartStart=/^([+a-z0-9A-Z_-]{0,63})(.*)$/,hostlessProtocol={'javascript':true,'javascript:':true},slashedProtocol={'http':true,'https':true,'ftp':true,'gopher':true,'file':true,'http:':true,'https:':true,'ftp:':true,'gopher:':true,'file:':true};function urlParse(url,slashesDenoteHost){if(url&&url instanceof Url){return url;}
var u=new Url();u.parse(url,slashesDenoteHost);return u;}
Url.prototype.parse=function(url,slashesDenoteHost){var i,l,lowerProto,hec,slashes,rest=url;rest=rest.trim();if(!slashesDenoteHost&&url.split('#').length===1){var simplePath=simplePathPattern.exec(rest);if(simplePath){this.pathname=simplePath[1];if(simplePath[2]){this.search=simplePath[2];}
return this;}}
var proto=protocolPattern.exec(rest);if(proto){proto=proto[0];lowerProto=proto.toLowerCase();this.protocol=proto;rest=rest.substr(proto.length);}
if(slashesDenoteHost||proto||rest.match(/^\/\/[^@\/]+@[^@\/]+/)){slashes=rest.substr(0,2)==='//';if(slashes&&!(proto&&hostlessProtocol[proto])){rest=rest.substr(2);this.slashes=true;}}
if(!hostlessProtocol[proto]&&(slashes||(proto&&!slashedProtocol[proto]))){var hostEnd=-1;for(i=0;i<hostEndingChars.length;i++){hec=rest.indexOf(hostEndingChars[i]);if(hec!==-1&&(hostEnd===-1||hec<hostEnd)){hostEnd=hec;}}
var auth,atSign;if(hostEnd===-1){atSign=rest.lastIndexOf('@');}else{atSign=rest.lastIndexOf('@',hostEnd);}
if(atSign!==-1){auth=rest.slice(0,atSign);rest=rest.slice(atSign+1);this.auth=auth;}
hostEnd=-1;for(i=0;i<nonHostChars.length;i++){hec=rest.indexOf(nonHostChars[i]);if(hec!==-1&&(hostEnd===-1||hec<hostEnd)){hostEnd=hec;}}
if(hostEnd===-1){hostEnd=rest.length;}
if(rest[hostEnd-1]===':'){hostEnd--;}
var host=rest.slice(0,hostEnd);rest=rest.slice(hostEnd);this.parseHost(host);this.hostname=this.hostname||'';var ipv6Hostname=this.hostname[0]==='['&&this.hostname[this.hostname.length-1]===']';if(!ipv6Hostname){var hostparts=this.hostname.split(/\./);for(i=0,l=hostparts.length;i<l;i++){var part=hostparts[i];if(!part){continue;}
if(!part.match(hostnamePartPattern)){var newpart='';for(var j=0,k=part.length;j<k;j++){if(part.charCodeAt(j)>127){newpart+='x';}else{newpart+=part[j];}}
if(!newpart.match(hostnamePartPattern)){var validParts=hostparts.slice(0,i);var notHost=hostparts.slice(i+1);var bit=part.match(hostnamePartStart);if(bit){validParts.push(bit[1]);notHost.unshift(bit[2]);}
if(notHost.length){rest=notHost.join('.')+rest;}
this.hostname=validParts.join('.');break;}}}}
if(this.hostname.length>hostnameMaxLen){this.hostname='';}
if(ipv6Hostname){this.hostname=this.hostname.substr(1,this.hostname.length-2);}}
var hash=rest.indexOf('#');if(hash!==-1){this.hash=rest.substr(hash);rest=rest.slice(0,hash);}
var qm=rest.indexOf('?');if(qm!==-1){this.search=rest.substr(qm);rest=rest.slice(0,qm);}
if(rest){this.pathname=rest;}
if(slashedProtocol[lowerProto]&&this.hostname&&!this.pathname){this.pathname='';}
return this;};Url.prototype.parseHost=function(host){var port=portPattern.exec(host);if(port){port=port[0];if(port!==':'){this.port=port.substr(1);}
host=host.substr(0,host.length-port.length);}
if(host){this.hostname=host;}};module.exports=urlParse;},{}],60:[function(require,module,exports){(function(global){;(function(root){var freeExports=typeof exports=='object'&&exports&&!exports.nodeType&&exports;var freeModule=typeof module=='object'&&module&&!module.nodeType&&module;var freeGlobal=typeof global=='object'&&global;if(freeGlobal.global===freeGlobal||freeGlobal.window===freeGlobal||freeGlobal.self===freeGlobal){root=freeGlobal;}
var punycode,maxInt=2147483647,base=36,tMin=1,tMax=26,skew=38,damp=700,initialBias=72,initialN=128,delimiter='-',regexPunycode=/^xn--/,regexNonASCII=/[^\x20-\x7E]/,regexSeparators=/[\x2E\u3002\uFF0E\uFF61]/g,errors={'overflow':'Overflow: input needs wider integers to process','not-basic':'Illegal input >= 0x80 (not a basic code point)','invalid-input':'Invalid input'},baseMinusTMin=base-tMin,floor=Math.floor,stringFromCharCode=String.fromCharCode,key;function error(type){throw new RangeError(errors[type]);}
function map(array,fn){var length=array.length;var result=[];while(length--){result[length]=fn(array[length]);}
return result;}
function mapDomain(string,fn){var parts=string.split('@');var result='';if(parts.length>1){result=parts[0]+'@';string=parts[1];}
string=string.replace(regexSeparators,'\x2E');var labels=string.split('.');var encoded=map(labels,fn).join('.');return result+encoded;}
function ucs2decode(string){var output=[],counter=0,length=string.length,value,extra;while(counter<length){value=string.charCodeAt(counter++);if(value>=0xD800&&value<=0xDBFF&&counter<length){extra=string.charCodeAt(counter++);if((extra&0xFC00)==0xDC00){output.push(((value&0x3FF)<<10)+(extra&0x3FF)+0x10000);}else{output.push(value);counter--;}}else{output.push(value);}}
return output;}
function ucs2encode(array){return map(array,function(value){var output='';if(value>0xFFFF){value-=0x10000;output+=stringFromCharCode(value>>>10&0x3FF|0xD800);value=0xDC00|value&0x3FF;}
output+=stringFromCharCode(value);return output;}).join('');}
function basicToDigit(codePoint){if(codePoint-48<10){return codePoint-22;}
if(codePoint-65<26){return codePoint-65;}
if(codePoint-97<26){return codePoint-97;}
return base;}
function digitToBasic(digit,flag){return digit+22+75*(digit<26)-((flag!=0)<<5);}
function adapt(delta,numPoints,firstTime){var k=0;delta=firstTime?floor(delta/damp):delta>>1;delta+=floor(delta/numPoints);for(;delta>baseMinusTMin*tMax>>1;k+=base){delta=floor(delta/baseMinusTMin);}
return floor(k+(baseMinusTMin+1)*delta/(delta+skew));}
function decode(input){var output=[],inputLength=input.length,out,i=0,n=initialN,bias=initialBias,basic,j,index,oldi,w,k,digit,t,baseMinusT;basic=input.lastIndexOf(delimiter);if(basic<0){basic=0;}
for(j=0;j<basic;++j){if(input.charCodeAt(j)>=0x80){error('not-basic');}
output.push(input.charCodeAt(j));}
for(index=basic>0?basic+1:0;index<inputLength;){for(oldi=i,w=1,k=base;;k+=base){if(index>=inputLength){error('invalid-input');}
digit=basicToDigit(input.charCodeAt(index++));if(digit>=base||digit>floor((maxInt-i)/w)){error('overflow');}
i+=digit*w;t=k<=bias?tMin:(k>=bias+tMax?tMax:k-bias);if(digit<t){break;}
baseMinusT=base-t;if(w>floor(maxInt/baseMinusT)){error('overflow');}
w*=baseMinusT;}
out=output.length+1;bias=adapt(i-oldi,out,oldi==0);if(floor(i/out)>maxInt-n){error('overflow');}
n+=floor(i/out);i%=out;output.splice(i++,0,n);}
return ucs2encode(output);}
function encode(input){var n,delta,handledCPCount,basicLength,bias,j,m,q,k,t,currentValue,output=[],inputLength,handledCPCountPlusOne,baseMinusT,qMinusT;input=ucs2decode(input);inputLength=input.length;n=initialN;delta=0;bias=initialBias;for(j=0;j<inputLength;++j){currentValue=input[j];if(currentValue<0x80){output.push(stringFromCharCode(currentValue));}}
handledCPCount=basicLength=output.length;if(basicLength){output.push(delimiter);}
while(handledCPCount<inputLength){for(m=maxInt,j=0;j<inputLength;++j){currentValue=input[j];if(currentValue>=n&&currentValue<m){m=currentValue;}}
handledCPCountPlusOne=handledCPCount+1;if(m-n>floor((maxInt-delta)/handledCPCountPlusOne)){error('overflow');}
delta+=(m-n)*handledCPCountPlusOne;n=m;for(j=0;j<inputLength;++j){currentValue=input[j];if(currentValue<n&&++delta>maxInt){error('overflow');}
if(currentValue==n){for(q=delta,k=base;;k+=base){t=k<=bias?tMin:(k>=bias+tMax?tMax:k-bias);if(q<t){break;}
qMinusT=q-t;baseMinusT=base-t;output.push(stringFromCharCode(digitToBasic(t+qMinusT%baseMinusT,0)));q=floor(qMinusT/baseMinusT);}
output.push(stringFromCharCode(digitToBasic(q,0)));bias=adapt(delta,handledCPCountPlusOne,handledCPCount==basicLength);delta=0;++handledCPCount;}}
++delta;++n;}
return output.join('');}
function toUnicode(input){return mapDomain(input,function(string){return regexPunycode.test(string)?decode(string.slice(4).toLowerCase()):string;});}
function toASCII(input){return mapDomain(input,function(string){return regexNonASCII.test(string)?'xn--'+encode(string):string;});}
punycode={'version':'1.4.1','ucs2':{'decode':ucs2decode,'encode':ucs2encode},'decode':decode,'encode':encode,'toASCII':toASCII,'toUnicode':toUnicode};if(typeof define=='function'&&typeof define.amd=='object'&&define.amd){define('punycode',function(){return punycode;});}else if(freeExports&&freeModule){if(module.exports==freeExports){freeModule.exports=punycode;}else{for(key in punycode){punycode.hasOwnProperty(key)&&(freeExports[key]=punycode[key]);}}}else{root.punycode=punycode;}}(this));}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{}],61:[function(require,module,exports){module.exports=/[\0-\x1F\x7F-\x9F]/},{}],62:[function(require,module,exports){module.exports=/[\xAD\u0600-\u0605\u061C\u06DD\u070F\u08E2\u180E\u200B-\u200F\u202A-\u202E\u2060-\u2064\u2066-\u206F\uFEFF\uFFF9-\uFFFB]|\uD804\uDCBD|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|\uDB40[\uDC01\uDC20-\uDC7F]/},{}],63:[function(require,module,exports){module.exports=/[!-#%-\*,-/:;\?@\[-\]_\{\}\xA1\xA7\xAB\xB6\xB7\xBB\xBF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u09FD\u0AF0\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166D\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208D\u208E\u2308-\u230B\u2329\u232A\u2768-\u2775\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00-\u2E2E\u2E30-\u2E49\u3001-\u3003\u3008-\u3011\u3014-\u301F\u3030\u303D\u30A0\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA8FC\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE61\uFE63\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF0A\uFF0C-\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3B-\uFF3D\uFF3F\uFF5B\uFF5D\uFF5F-\uFF65]|\uD800[\uDD00-\uDD02\uDF9F\uDFD0]|\uD801\uDD6F|\uD802[\uDC57\uDD1F\uDD3F\uDE50-\uDE58\uDE7F\uDEF0-\uDEF6\uDF39-\uDF3F\uDF99-\uDF9C]|\uD804[\uDC47-\uDC4D\uDCBB\uDCBC\uDCBE-\uDCC1\uDD40-\uDD43\uDD74\uDD75\uDDC5-\uDDC9\uDDCD\uDDDB\uDDDD-\uDDDF\uDE38-\uDE3D\uDEA9]|\uD805[\uDC4B-\uDC4F\uDC5B\uDC5D\uDCC6\uDDC1-\uDDD7\uDE41-\uDE43\uDE60-\uDE6C\uDF3C-\uDF3E]|\uD806[\uDE3F-\uDE46\uDE9A-\uDE9C\uDE9E-\uDEA2]|\uD807[\uDC41-\uDC45\uDC70\uDC71]|\uD809[\uDC70-\uDC74]|\uD81A[\uDE6E\uDE6F\uDEF5\uDF37-\uDF3B\uDF44]|\uD82F\uDC9F|\uD836[\uDE87-\uDE8B]|\uD83A[\uDD5E\uDD5F]/},{}],64:[function(require,module,exports){module.exports=/[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/},{}],65:[function(require,module,exports){'use strict';exports.Any=require('./properties/Any/regex');exports.Cc=require('./categories/Cc/regex');exports.Cf=require('./categories/Cf/regex');exports.P=require('./categories/P/regex');exports.Z=require('./categories/Z/regex');},{"./categories/Cc/regex":61,"./categories/Cf/regex":62,"./categories/P/regex":63,"./categories/Z/regex":64,"./properties/Any/regex":66}],66:[function(require,module,exports){module.exports=/[\0-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/},{}],67:[function(require,module,exports){'use strict';module.exports=require('./lib/');},{"./lib/":9}]},{},[67])(67)});!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e(t.pell={})}(this,function(t){"use strict";var e=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(t[r]=n[r])}return t},n=function(t,e,n){return t.addEventListener(e,n)},r=function(t,e){return t.appendChild(e)},i=function(t){return document.createElement(t)},o=function(t){return document.queryCommandState(t)},u=function(t){return document.queryCommandValue(t)},c=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;return document.execCommand(t,!1,e)},l={bold:{icon:"<b>B</b>",title:"Bold",state:function(){return o("bold")},result:function(){return c("bold")}},italic:{icon:"<i>I</i>",title:"Italic",state:function(){return o("italic")},result:function(){return c("italic")}},underline:{icon:"<u>U</u>",title:"Underline",state:function(){return o("underline")},result:function(){return c("underline")}},strikethrough:{icon:"<strike>S</strike>",title:"Strike-through",state:function(){return o("strikeThrough")},result:function(){return c("strikeThrough")}},heading1:{icon:"<b>H<sub>1</sub></b>",title:"Heading 1",result:function(){return c("formatBlock","<h1>")}},heading2:{icon:"<b>H<sub>2</sub></b>",title:"Heading 2",result:function(){return c("formatBlock","<h2>")}},paragraph:{icon:"&#182;",title:"Paragraph",result:function(){return c("formatBlock","<p>")}},quote:{icon:"&#8220; &#8221;",title:"Quote",result:function(){return c("formatBlock","<blockquote>")}},olist:{icon:"&#35;",title:"Ordered List",result:function(){return c("insertOrderedList")}},ulist:{icon:"&#8226;",title:"Unordered List",result:function(){return c("insertUnorderedList")}},code:{icon:"&lt;/&gt;",title:"Code",result:function(){return c("formatBlock","<pre>")}},line:{icon:"&#8213;",title:"Horizontal Line",result:function(){return c("insertHorizontalRule")}},link:{icon:"&#128279;",title:"Link",result:function(){var t=window.prompt("Enter the link URL");t&&c("createLink",t)}},image:{icon:"&#128247;",title:"Image",result:function(){var t=window.prompt("Enter the image URL");t&&c("insertImage",t)}}},a={actionbar:"pell-actionbar",button:"pell-button",content:"pell-content",selected:"pell-button-selected"},s=function(t){var o=t.actions?t.actions.map(function(t){return"string"==typeof t?l[t]:l[t.name]?e({},l[t.name],t):t}):Object.keys(l).map(function(t){return l[t]}),s=e({},a,t.classes),f=t.defaultParagraphSeparator||"div",d=i("div");d.className=s.actionbar,r(t.element,d);var m=t.element.content=i("div");return m.contentEditable=!0,m.className=s.content,m.oninput=function(e){var n=e.target.firstChild;n&&3===n.nodeType?c("formatBlock","<"+f+">"):"<br>"===m.innerHTML&&(m.innerHTML=""),t.onChange(m.innerHTML)},m.onkeydown=function(t){"Tab"===t.key?t.preventDefault():"Enter"===t.key&&"blockquote"===u("formatBlock")&&setTimeout(function(){return c("formatBlock","<"+f+">")},0)},r(t.element,m),o.forEach(function(t){var e=i("button");if(e.className=s.button,e.innerHTML=t.icon,e.title=t.title,e.setAttribute("type","button"),e.onclick=function(){return t.result()&&m.focus()},t.state){var o=function(){return e.classList[t.state()?"add":"remove"](s.selected)};n(m,"keyup",o),n(m,"mouseup",o),n(e,"click",o)}r(d,e)}),t.styleWithCSS&&c("styleWithCSS"),c("defaultParagraphSeparator",f),t.element},f={exec:c,init:s};t.exec=c,t.init=s,t.default=f,Object.defineProperty(t,"__esModule",{value:!0})});var _self="undefined"!=typeof window?window:"undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope?self:{},Prism=function(g){var c=/\blang(?:uage)?-([\w-]+)\b/i,a=0,C={manual:g.Prism&&g.Prism.manual,disableWorkerMessageHandler:g.Prism&&g.Prism.disableWorkerMessageHandler,util:{encode:function(e){return e instanceof M?new M(e.type,C.util.encode(e.content),e.alias):Array.isArray(e)?e.map(C.util.encode):e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/\u00a0/g," ")},type:function(e){return Object.prototype.toString.call(e).slice(8,-1)},objId:function(e){return e.__id||Object.defineProperty(e,"__id",{value:++a}),e.__id},clone:function n(e,t){var r,a,i=C.util.type(e);switch(t=t||{},i){case"Object":if(a=C.util.objId(e),t[a])return t[a];for(var o in r={},t[a]=r,e)e.hasOwnProperty(o)&&(r[o]=n(e[o],t));return r;case"Array":return a=C.util.objId(e),t[a]?t[a]:(r=[],t[a]=r,e.forEach(function(e,a){r[a]=n(e,t)}),r);default:return e}}},languages:{extend:function(e,a){var n=C.util.clone(C.languages[e]);for(var t in a)n[t]=a[t];return n},insertBefore:function(n,e,a,t){var r=(t=t||C.languages)[n],i={};for(var o in r)if(r.hasOwnProperty(o)){if(o==e)for(var l in a)a.hasOwnProperty(l)&&(i[l]=a[l]);a.hasOwnProperty(o)||(i[o]=r[o])}var s=t[n];return t[n]=i,C.languages.DFS(C.languages,function(e,a){a===s&&e!=n&&(this[e]=i)}),i},DFS:function e(a,n,t,r){r=r||{};var i=C.util.objId;for(var o in a)if(a.hasOwnProperty(o)){n.call(a,o,a[o],t||o);var l=a[o],s=C.util.type(l);"Object"!==s||r[i(l)]?"Array"!==s||r[i(l)]||(r[i(l)]=!0,e(l,n,o,r)):(r[i(l)]=!0,e(l,n,null,r))}}},plugins:{},highlightAll:function(e,a){C.highlightAllUnder(document,e,a)},highlightAllUnder:function(e,a,n){var t={callback:n,selector:'code[class*="language-"], [class*="language-"] code, code[class*="lang-"], [class*="lang-"] code'};C.hooks.run("before-highlightall",t);for(var r,i=e.querySelectorAll(t.selector),o=0;r=i[o++];)C.highlightElement(r,!0===a,t.callback)},highlightElement:function(e,a,n){for(var t,r="none",i=e;i&&!c.test(i.className);)i=i.parentNode;i&&(r=(i.className.match(c)||[,"none"])[1].toLowerCase(),t=C.languages[r]),e.className=e.className.replace(c,"").replace(/\s+/g," ")+" language-"+r,e.parentNode&&(i=e.parentNode,/pre/i.test(i.nodeName)&&(i.className=i.className.replace(c,"").replace(/\s+/g," ")+" language-"+r));var o={element:e,language:r,grammar:t,code:e.textContent},l=function(e){o.highlightedCode=e,C.hooks.run("before-insert",o),o.element.innerHTML=o.highlightedCode,C.hooks.run("after-highlight",o),C.hooks.run("complete",o),n&&n.call(o.element)};if(C.hooks.run("before-sanity-check",o),o.code)if(C.hooks.run("before-highlight",o),o.grammar)if(a&&g.Worker){var s=new Worker(C.filename);s.onmessage=function(e){l(e.data)},s.postMessage(JSON.stringify({language:o.language,code:o.code,immediateClose:!0}))}else l(C.highlight(o.code,o.grammar,o.language));else l(C.util.encode(o.code));else C.hooks.run("complete",o)},highlight:function(e,a,n){var t={code:e,grammar:a,language:n};return C.hooks.run("before-tokenize",t),t.tokens=C.tokenize(t.code,t.grammar),C.hooks.run("after-tokenize",t),M.stringify(C.util.encode(t.tokens),t.language)},matchGrammar:function(e,a,n,t,r,i,o){for(var l in n)if(n.hasOwnProperty(l)&&n[l]){if(l==o)return;var s=n[l];s="Array"===C.util.type(s)?s:[s];for(var g=0;g<s.length;++g){var c=s[g],u=c.inside,h=!!c.lookbehind,f=!!c.greedy,d=0,m=c.alias;if(f&&!c.pattern.global){var p=c.pattern.toString().match(/[imuy]*$/)[0];c.pattern=RegExp(c.pattern.source,p+"g")}c=c.pattern||c;for(var y=t,v=r;y<a.length;v+=a[y].length,++y){var k=a[y];if(a.length>e.length)return;if(!(k instanceof M)){if(f&&y!=a.length-1){if(c.lastIndex=v,!(x=c.exec(e)))break;for(var b=x.index+(h?x[1].length:0),w=x.index+x[0].length,A=y,P=v,O=a.length;A<O&&(P<w||!a[A].type&&!a[A-1].greedy);++A)(P+=a[A].length)<=b&&(++y,v=P);if(a[y]instanceof M)continue;N=A-y,k=e.slice(v,P),x.index-=v}else{c.lastIndex=0;var x=c.exec(k),N=1}if(x){h&&(d=x[1]?x[1].length:0);w=(b=x.index+d)+(x=x[0].slice(d)).length;var j=k.slice(0,b),S=k.slice(w),E=[y,N];j&&(++y,v+=j.length,E.push(j));var _=new M(l,u?C.tokenize(x,u):x,m,x,f);if(E.push(_),S&&E.push(S),Array.prototype.splice.apply(a,E),1!=N&&C.matchGrammar(e,a,n,y,v,!0,l),i)break}else if(i)break}}}}},tokenize:function(e,a){var n=[e],t=a.rest;if(t){for(var r in t)a[r]=t[r];delete a.rest}return C.matchGrammar(e,n,a,0,0,!1),n},hooks:{all:{},add:function(e,a){var n=C.hooks.all;n[e]=n[e]||[],n[e].push(a)},run:function(e,a){var n=C.hooks.all[e];if(n&&n.length)for(var t,r=0;t=n[r++];)t(a)}},Token:M};function M(e,a,n,t,r){this.type=e,this.content=a,this.alias=n,this.length=0|(t||"").length,this.greedy=!!r}if(g.Prism=C,M.stringify=function(e,a){if("string"==typeof e)return e;if(Array.isArray(e))return e.map(function(e){return M.stringify(e,a)}).join("");var n={type:e.type,content:M.stringify(e.content,a),tag:"span",classes:["token",e.type],attributes:{},language:a};if(e.alias){var t=Array.isArray(e.alias)?e.alias:[e.alias];Array.prototype.push.apply(n.classes,t)}C.hooks.run("wrap",n);var r=Object.keys(n.attributes).map(function(e){return e+'="'+(n.attributes[e]||"").replace(/"/g,"&quot;")+'"'}).join(" ");return"<"+n.tag+' class="'+n.classes.join(" ")+'"'+(r?" "+r:"")+">"+n.content+"</"+n.tag+">"},!g.document)return g.addEventListener&&(C.disableWorkerMessageHandler||g.addEventListener("message",function(e){var a=JSON.parse(e.data),n=a.language,t=a.code,r=a.immediateClose;g.postMessage(C.highlight(t,C.languages[n],n)),r&&g.close()},!1)),C;var e=document.currentScript||[].slice.call(document.getElementsByTagName("script")).pop();return e&&(C.filename=e.src,C.manual||e.hasAttribute("data-manual")||("loading"!==document.readyState?window.requestAnimationFrame?window.requestAnimationFrame(C.highlightAll):window.setTimeout(C.highlightAll,16):document.addEventListener("DOMContentLoaded",C.highlightAll))),C}(_self);"undefined"!=typeof module&&module.exports&&(module.exports=Prism),"undefined"!=typeof global&&(global.Prism=Prism);Prism.languages.markup={comment:/<!--[\s\S]*?-->/,prolog:/<\?[\s\S]+?\?>/,doctype:/<!DOCTYPE[\s\S]+?>/i,cdata:/<!\[CDATA\[[\s\S]*?]]>/i,tag:{pattern:/<\/?(?!\d)[^\s>\/=$<%]+(?:\s(?:\s*[^\s>\/=]+(?:\s*=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+(?=[\s>]))|(?=[\s/>])))+)?\s*\/?>/i,greedy:!0,inside:{tag:{pattern:/^<\/?[^\s>\/]+/i,inside:{punctuation:/^<\/?/,namespace:/^[^\s>\/:]+:/}},"attr-value":{pattern:/=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+)/i,inside:{punctuation:[/^=/,{pattern:/^(\s*)["']|["']$/,lookbehind:!0}]}},punctuation:/\/?>/,"attr-name":{pattern:/[^\s>\/]+/,inside:{namespace:/^[^\s>\/:]+:/}}}},entity:/&#?[\da-z]{1,8};/i},Prism.languages.markup.tag.inside["attr-value"].inside.entity=Prism.languages.markup.entity,Prism.hooks.add("wrap",function(a){"entity"===a.type&&(a.attributes.title=a.content.replace(/&amp;/,"&"))}),Object.defineProperty(Prism.languages.markup.tag,"addInlined",{value:function(a,e){var s={};s["language-"+e]={pattern:/(^<!\[CDATA\[)[\s\S]+?(?=\]\]>$)/i,lookbehind:!0,inside:Prism.languages[e]},s.cdata=/^<!\[CDATA\[|\]\]>$/i;var n={"included-cdata":{pattern:/<!\[CDATA\[[\s\S]*?\]\]>/i,inside:s}};n["language-"+e]={pattern:/[\s\S]+/,inside:Prism.languages[e]};var i={};i[a]={pattern:RegExp("(<__[\\s\\S]*?>)(?:<!\\[CDATA\\[[\\s\\S]*?\\]\\]>\\s*|[\\s\\S])*?(?=<\\/__>)".replace(/__/g,a),"i"),lookbehind:!0,greedy:!0,inside:n},Prism.languages.insertBefore("markup","cdata",i)}}),Prism.languages.xml=Prism.languages.extend("markup",{}),Prism.languages.html=Prism.languages.markup,Prism.languages.mathml=Prism.languages.markup,Prism.languages.svg=Prism.languages.markup;!function(s){var t=/("|')(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/;s.languages.css={comment:/\/\*[\s\S]*?\*\//,atrule:{pattern:/@[\w-]+[\s\S]*?(?:;|(?=\s*\{))/,inside:{rule:/@[\w-]+/}},url:{pattern:RegExp("url\\((?:"+t.source+"|[^\n\r()]*)\\)","i"),inside:{function:/^url/i,punctuation:/^\(|\)$/}},selector:RegExp("[^{}\\s](?:[^{};\"']|"+t.source+")*?(?=\\s*\\{)"),string:{pattern:t,greedy:!0},property:/[-_a-z\xA0-\uFFFF][-\w\xA0-\uFFFF]*(?=\s*:)/i,important:/!important\b/i,function:/[-a-z0-9]+(?=\()/i,punctuation:/[(){};:,]/},s.languages.css.atrule.inside.rest=s.languages.css;var e=s.languages.markup;e&&(e.tag.addInlined("style","css"),s.languages.insertBefore("inside","attr-value",{"style-attr":{pattern:/\s*style=("|')(?:\\[\s\S]|(?!\1)[^\\])*\1/i,inside:{"attr-name":{pattern:/^\s*style/i,inside:e.tag.inside},punctuation:/^\s*=\s*['"]|['"]\s*$/,"attr-value":{pattern:/.+/i,inside:s.languages.css}},alias:"language-css"}},e.tag))}(Prism);Prism.languages.clike={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,lookbehind:!0},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:!0,greedy:!0}],string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:!0},"class-name":{pattern:/((?:\b(?:class|interface|extends|implements|trait|instanceof|new)\s+)|(?:catch\s+\())[\w.\\]+/i,lookbehind:!0,inside:{punctuation:/[.\\]/}},keyword:/\b(?:if|else|while|do|for|return|in|instanceof|function|new|try|throw|catch|finally|null|break|continue)\b/,boolean:/\b(?:true|false)\b/,function:/\w+(?=\()/,number:/\b0x[\da-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?/i,operator:/--?|\+\+?|!=?=?|<=?|>=?|==?=?|&&?|\|\|?|\?|\*|\/|~|\^|%/,punctuation:/[{}[\];(),.:]/};Prism.languages.javascript=Prism.languages.extend("clike",{"class-name":[Prism.languages.clike["class-name"],{pattern:/(^|[^$\w\xA0-\uFFFF])[_$A-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\.(?:prototype|constructor))/,lookbehind:!0}],keyword:[{pattern:/((?:^|})\s*)(?:catch|finally)\b/,lookbehind:!0},{pattern:/(^|[^.])\b(?:as|async(?=\s*(?:function\b|\(|[$\w\xA0-\uFFFF]|$))|await|break|case|class|const|continue|debugger|default|delete|do|else|enum|export|extends|for|from|function|get|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|set|static|super|switch|this|throw|try|typeof|undefined|var|void|while|with|yield)\b/,lookbehind:!0}],number:/\b(?:(?:0[xX](?:[\dA-Fa-f](?:_[\dA-Fa-f])?)+|0[bB](?:[01](?:_[01])?)+|0[oO](?:[0-7](?:_[0-7])?)+)n?|(?:\d(?:_\d)?)+n|NaN|Infinity)\b|(?:\b(?:\d(?:_\d)?)+\.?(?:\d(?:_\d)?)*|\B\.(?:\d(?:_\d)?)+)(?:[Ee][+-]?(?:\d(?:_\d)?)+)?/,function:/#?[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*(?:\.\s*(?:apply|bind|call)\s*)?\()/,operator:/-[-=]?|\+[+=]?|!=?=?|<<?=?|>>?>?=?|=(?:==?|>)?|&[&=]?|\|[|=]?|\*\*?=?|\/=?|~|\^=?|%=?|\?|\.{3}/}),Prism.languages.javascript["class-name"][0].pattern=/(\b(?:class|interface|extends|implements|instanceof|new)\s+)[\w.\\]+/,Prism.languages.insertBefore("javascript","keyword",{regex:{pattern:/((?:^|[^$\w\xA0-\uFFFF."'\])\s])\s*)\/(\[(?:[^\]\\\r\n]|\\.)*]|\\.|[^/\\\[\r\n])+\/[gimyus]{0,6}(?=\s*($|[\r\n,.;})\]]))/,lookbehind:!0,greedy:!0},"function-variable":{pattern:/#?[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*[=:]\s*(?:async\s*)?(?:\bfunction\b|(?:\((?:[^()]|\([^()]*\))*\)|[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*)\s*=>))/,alias:"function"},parameter:[{pattern:/(function(?:\s+[_$A-Za-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*)?\s*\(\s*)(?!\s)(?:[^()]|\([^()]*\))+?(?=\s*\))/,lookbehind:!0,inside:Prism.languages.javascript},{pattern:/[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*=>)/i,inside:Prism.languages.javascript},{pattern:/(\(\s*)(?!\s)(?:[^()]|\([^()]*\))+?(?=\s*\)\s*=>)/,lookbehind:!0,inside:Prism.languages.javascript},{pattern:/((?:\b|\s|^)(?!(?:as|async|await|break|case|catch|class|const|continue|debugger|default|delete|do|else|enum|export|extends|finally|for|from|function|get|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|set|static|super|switch|this|throw|try|typeof|undefined|var|void|while|with|yield)(?![$\w\xA0-\uFFFF]))(?:[_$A-Za-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*\s*)\(\s*)(?!\s)(?:[^()]|\([^()]*\))+?(?=\s*\)\s*\{)/,lookbehind:!0,inside:Prism.languages.javascript}],constant:/\b[A-Z](?:[A-Z_]|\dx?)*\b/}),Prism.languages.insertBefore("javascript","string",{"template-string":{pattern:/`(?:\\[\s\S]|\${(?:[^{}]|{(?:[^{}]|{[^}]*})*})+}|(?!\${)[^\\`])*`/,greedy:!0,inside:{"template-punctuation":{pattern:/^`|`$/,alias:"string"},interpolation:{pattern:/((?:^|[^\\])(?:\\{2})*)\${(?:[^{}]|{(?:[^{}]|{[^}]*})*})+}/,lookbehind:!0,inside:{"interpolation-punctuation":{pattern:/^\${|}$/,alias:"punctuation"},rest:Prism.languages.javascript}},string:/[\s\S]+/}}}),Prism.languages.markup&&Prism.languages.markup.tag.addInlined("script","javascript"),Prism.languages.js=Prism.languages.javascript;!function(e){var t="\\b(?:BASH|BASHOPTS|BASH_ALIASES|BASH_ARGC|BASH_ARGV|BASH_CMDS|BASH_COMPLETION_COMPAT_DIR|BASH_LINENO|BASH_REMATCH|BASH_SOURCE|BASH_VERSINFO|BASH_VERSION|COLORTERM|COLUMNS|COMP_WORDBREAKS|DBUS_SESSION_BUS_ADDRESS|DEFAULTS_PATH|DESKTOP_SESSION|DIRSTACK|DISPLAY|EUID|GDMSESSION|GDM_LANG|GNOME_KEYRING_CONTROL|GNOME_KEYRING_PID|GPG_AGENT_INFO|GROUPS|HISTCONTROL|HISTFILE|HISTFILESIZE|HISTSIZE|HOME|HOSTNAME|HOSTTYPE|IFS|INSTANCE|JOB|LANG|LANGUAGE|LC_ADDRESS|LC_ALL|LC_IDENTIFICATION|LC_MEASUREMENT|LC_MONETARY|LC_NAME|LC_NUMERIC|LC_PAPER|LC_TELEPHONE|LC_TIME|LESSCLOSE|LESSOPEN|LINES|LOGNAME|LS_COLORS|MACHTYPE|MAILCHECK|MANDATORY_PATH|NO_AT_BRIDGE|OLDPWD|OPTERR|OPTIND|ORBIT_SOCKETDIR|OSTYPE|PAPERSIZE|PATH|PIPESTATUS|PPID|PS1|PS2|PS3|PS4|PWD|RANDOM|REPLY|SECONDS|SELINUX_INIT|SESSION|SESSIONTYPE|SESSION_MANAGER|SHELL|SHELLOPTS|SHLVL|SSH_AUTH_SOCK|TERM|UID|UPSTART_EVENTS|UPSTART_INSTANCE|UPSTART_JOB|UPSTART_SESSION|USER|WINDOWID|XAUTHORITY|XDG_CONFIG_DIRS|XDG_CURRENT_DESKTOP|XDG_DATA_DIRS|XDG_GREETER_DATA_DIR|XDG_MENU_PREFIX|XDG_RUNTIME_DIR|XDG_SEAT|XDG_SEAT_PATH|XDG_SESSION_DESKTOP|XDG_SESSION_ID|XDG_SESSION_PATH|XDG_SESSION_TYPE|XDG_VTNR|XMODIFIERS)\\b",n={environment:{pattern:RegExp("\\$"+t),alias:"constant"},variable:[{pattern:/\$?\(\([\s\S]+?\)\)/,greedy:!0,inside:{variable:[{pattern:/(^\$\(\([\s\S]+)\)\)/,lookbehind:!0},/^\$\(\(/],number:/\b0x[\dA-Fa-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee]-?\d+)?/,operator:/--?|-=|\+\+?|\+=|!=?|~|\*\*?|\*=|\/=?|%=?|<<=?|>>=?|<=?|>=?|==?|&&?|&=|\^=?|\|\|?|\|=|\?|:/,punctuation:/\(\(?|\)\)?|,|;/}},{pattern:/\$\((?:\([^)]+\)|[^()])+\)|`[^`]+`/,greedy:!0,inside:{variable:/^\$\(|^`|\)$|`$/}},{pattern:/\$\{[^}]+\}/,greedy:!0,inside:{operator:/:[-=?+]?|[!\/]|##?|%%?|\^\^?|,,?/,punctuation:/[\[\]]/,environment:{pattern:RegExp("(\\{)"+t),lookbehind:!0,alias:"constant"}}},/\$(?:\w+|[#?*!@$])/],entity:/\\(?:[abceEfnrtv\\"]|O?[0-7]{1,3}|x[0-9a-fA-F]{1,2}|u[0-9a-fA-F]{4}|U[0-9a-fA-F]{8})/};e.languages.bash={shebang:{pattern:/^#!\s*\/.*/,alias:"important"},comment:{pattern:/(^|[^"{\\$])#.*/,lookbehind:!0},"function-name":[{pattern:/(\bfunction\s+)\w+(?=(?:\s*\(?:\s*\))?\s*\{)/,lookbehind:!0,alias:"function"},{pattern:/\b\w+(?=\s*\(\s*\)\s*\{)/,alias:"function"}],"for-or-select":{pattern:/(\b(?:for|select)\s+)\w+(?=\s+in\s)/,alias:"variable",lookbehind:!0},"assign-left":{pattern:/(^|[\s;|&]|[<>]\()\w+(?=\+?=)/,inside:{environment:{pattern:RegExp("(^|[\\s;|&]|[<>]\\()"+t),lookbehind:!0,alias:"constant"}},alias:"variable",lookbehind:!0},string:[{pattern:/((?:^|[^<])<<-?\s*)(\w+?)\s*(?:\r?\n|\r)(?:[\s\S])*?(?:\r?\n|\r)\2/,lookbehind:!0,greedy:!0,inside:n},{pattern:/((?:^|[^<])<<-?\s*)(["'])(\w+)\2\s*(?:\r?\n|\r)(?:[\s\S])*?(?:\r?\n|\r)\3/,lookbehind:!0,greedy:!0},{pattern:/(["'])(?:\\[\s\S]|\$\([^)]+\)|`[^`]+`|(?!\1)[^\\])*\1/,greedy:!0,inside:n}],environment:{pattern:RegExp("\\$?"+t),alias:"constant"},variable:n.variable,function:{pattern:/(^|[\s;|&]|[<>]\()(?:add|apropos|apt|aptitude|apt-cache|apt-get|aspell|automysqlbackup|awk|basename|bash|bc|bconsole|bg|bzip2|cal|cat|cfdisk|chgrp|chkconfig|chmod|chown|chroot|cksum|clear|cmp|column|comm|cp|cron|crontab|csplit|curl|cut|date|dc|dd|ddrescue|debootstrap|df|diff|diff3|dig|dir|dircolors|dirname|dirs|dmesg|du|egrep|eject|env|ethtool|expand|expect|expr|fdformat|fdisk|fg|fgrep|file|find|fmt|fold|format|free|fsck|ftp|fuser|gawk|git|gparted|grep|groupadd|groupdel|groupmod|groups|grub-mkconfig|gzip|halt|head|hg|history|host|hostname|htop|iconv|id|ifconfig|ifdown|ifup|import|install|ip|jobs|join|kill|killall|less|link|ln|locate|logname|logrotate|look|lpc|lpr|lprint|lprintd|lprintq|lprm|ls|lsof|lynx|make|man|mc|mdadm|mkconfig|mkdir|mke2fs|mkfifo|mkfs|mkisofs|mknod|mkswap|mmv|more|most|mount|mtools|mtr|mutt|mv|nano|nc|netstat|nice|nl|nohup|notify-send|npm|nslookup|op|open|parted|passwd|paste|pathchk|ping|pkill|pnpm|popd|pr|printcap|printenv|ps|pushd|pv|quota|quotacheck|quotactl|ram|rar|rcp|reboot|remsync|rename|renice|rev|rm|rmdir|rpm|rsync|scp|screen|sdiff|sed|sendmail|seq|service|sftp|sh|shellcheck|shuf|shutdown|sleep|slocate|sort|split|ssh|stat|strace|su|sudo|sum|suspend|swapon|sync|tac|tail|tar|tee|time|timeout|top|touch|tr|traceroute|tsort|tty|umount|uname|unexpand|uniq|units|unrar|unshar|unzip|update-grub|uptime|useradd|userdel|usermod|users|uudecode|uuencode|v|vdir|vi|vim|virsh|vmstat|wait|watch|wc|wget|whereis|which|who|whoami|write|xargs|xdg-open|yarn|yes|zenity|zip|zsh|zypper)(?=$|[)\s;|&])/,lookbehind:!0},keyword:{pattern:/(^|[\s;|&]|[<>]\()(?:if|then|else|elif|fi|for|while|in|case|esac|function|select|do|done|until)(?=$|[)\s;|&])/,lookbehind:!0},builtin:{pattern:/(^|[\s;|&]|[<>]\()(?:\.|:|break|cd|continue|eval|exec|exit|export|getopts|hash|pwd|readonly|return|shift|test|times|trap|umask|unset|alias|bind|builtin|caller|command|declare|echo|enable|help|let|local|logout|mapfile|printf|read|readarray|source|type|typeset|ulimit|unalias|set|shopt)(?=$|[)\s;|&])/,lookbehind:!0,alias:"class-name"},boolean:{pattern:/(^|[\s;|&]|[<>]\()(?:true|false)(?=$|[)\s;|&])/,lookbehind:!0},"file-descriptor":{pattern:/\B&\d\b/,alias:"important"},operator:{pattern:/\d?<>|>\||\+=|==?|!=?|=~|<<[<-]?|[&\d]?>>|\d?[<>]&?|&[>&]?|\|[&|]?|<=?|>=?/,inside:{"file-descriptor":{pattern:/^\d/,alias:"important"}}},punctuation:/\$?\(\(?|\)\)?|\.\.|[{}[\];\\]/,number:{pattern:/(^|\s)(?:[1-9]\d*|0)(?:[.,]\d+)?\b/,lookbehind:!0}};for(var a=["comment","function-name","for-or-select","assign-left","string","environment","function","keyword","builtin","boolean","file-descriptor","operator","punctuation","number"],r=n.variable[1].inside,s=0;s<a.length;s++)r[a[s]]=e.languages.bash[a[s]];e.languages.shell=e.languages.bash}(Prism);!function(e){e.languages.ruby=e.languages.extend("clike",{comment:[/#.*/,{pattern:/^=begin\s[\s\S]*?^=end/m,greedy:!0}],keyword:/\b(?:alias|and|BEGIN|begin|break|case|class|def|define_method|defined|do|each|else|elsif|END|end|ensure|false|for|if|in|module|new|next|nil|not|or|protected|private|public|raise|redo|require|rescue|retry|return|self|super|then|throw|true|undef|unless|until|when|while|yield)\b/});var n={pattern:/#\{[^}]+\}/,inside:{delimiter:{pattern:/^#\{|\}$/,alias:"tag"},rest:e.languages.ruby}};delete e.languages.ruby.function,e.languages.insertBefore("ruby","keyword",{regex:[{pattern:/%r([^a-zA-Z0-9\s{(\[<])(?:(?!\1)[^\\]|\\[\s\S])*\1[gim]{0,3}/,greedy:!0,inside:{interpolation:n}},{pattern:/%r\((?:[^()\\]|\\[\s\S])*\)[gim]{0,3}/,greedy:!0,inside:{interpolation:n}},{pattern:/%r\{(?:[^#{}\\]|#(?:\{[^}]+\})?|\\[\s\S])*\}[gim]{0,3}/,greedy:!0,inside:{interpolation:n}},{pattern:/%r\[(?:[^\[\]\\]|\\[\s\S])*\][gim]{0,3}/,greedy:!0,inside:{interpolation:n}},{pattern:/%r<(?:[^<>\\]|\\[\s\S])*>[gim]{0,3}/,greedy:!0,inside:{interpolation:n}},{pattern:/(^|[^/])\/(?!\/)(\[.+?]|\\.|[^/\\\r\n])+\/[gim]{0,3}(?=\s*($|[\r\n,.;})]))/,lookbehind:!0,greedy:!0}],variable:/[@$]+[a-zA-Z_]\w*(?:[?!]|\b)/,symbol:{pattern:/(^|[^:]):[a-zA-Z_]\w*(?:[?!]|\b)/,lookbehind:!0},"method-definition":{pattern:/(\bdef\s+)[\w.]+/,lookbehind:!0,inside:{function:/\w+$/,rest:e.languages.ruby}}}),e.languages.insertBefore("ruby","number",{builtin:/\b(?:Array|Bignum|Binding|Class|Continuation|Dir|Exception|FalseClass|File|Stat|Fixnum|Float|Hash|Integer|IO|MatchData|Method|Module|NilClass|Numeric|Object|Proc|Range|Regexp|String|Struct|TMS|Symbol|ThreadGroup|Thread|Time|TrueClass)\b/,constant:/\b[A-Z]\w*(?:[?!]|\b)/}),e.languages.ruby.string=[{pattern:/%[qQiIwWxs]?([^a-zA-Z0-9\s{(\[<])(?:(?!\1)[^\\]|\\[\s\S])*\1/,greedy:!0,inside:{interpolation:n}},{pattern:/%[qQiIwWxs]?\((?:[^()\\]|\\[\s\S])*\)/,greedy:!0,inside:{interpolation:n}},{pattern:/%[qQiIwWxs]?\{(?:[^#{}\\]|#(?:\{[^}]+\})?|\\[\s\S])*\}/,greedy:!0,inside:{interpolation:n}},{pattern:/%[qQiIwWxs]?\[(?:[^\[\]\\]|\\[\s\S])*\]/,greedy:!0,inside:{interpolation:n}},{pattern:/%[qQiIwWxs]?<(?:[^<>\\]|\\[\s\S])*>/,greedy:!0,inside:{interpolation:n}},{pattern:/("|')(?:#\{[^}]+\}|\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:!0,inside:{interpolation:n}}],e.languages.rb=e.languages.ruby}(Prism);!function(h){function v(e,n){return"___"+e.toUpperCase()+n+"___"}Object.defineProperties(h.languages["markup-templating"]={},{buildPlaceholders:{value:function(a,r,e,o){if(a.language===r){var c=a.tokenStack=[];a.code=a.code.replace(e,function(e){if("function"==typeof o&&!o(e))return e;for(var n,t=c.length;-1!==a.code.indexOf(n=v(r,t));)++t;return c[t]=e,n}),a.grammar=h.languages.markup}}},tokenizePlaceholders:{value:function(p,k){if(p.language===k&&p.tokenStack){p.grammar=h.languages[k];var m=0,d=Object.keys(p.tokenStack);!function e(n){for(var t=0;t<n.length&&!(m>=d.length);t++){var a=n[t];if("string"==typeof a||a.content&&"string"==typeof a.content){var r=d[m],o=p.tokenStack[r],c="string"==typeof a?a:a.content,i=v(k,r),u=c.indexOf(i);if(-1<u){++m;var g=c.substring(0,u),l=new h.Token(k,h.tokenize(o,p.grammar),"language-"+k,o),s=c.substring(u+i.length),f=[];g&&f.push.apply(f,e([g])),f.push(l),s&&f.push.apply(f,e([s])),"string"==typeof a?n.splice.apply(n,[t,1].concat(f)):a.content=f}}else a.content&&e(a.content)}return n}(p.tokens)}}}})}(Prism);!function(t){t.languages.http={"request-line":{pattern:/^(?:POST|GET|PUT|DELETE|OPTIONS|PATCH|TRACE|CONNECT)\s(?:https?:\/\/|\/)\S+\sHTTP\/[0-9.]+/m,inside:{property:/^(?:POST|GET|PUT|DELETE|OPTIONS|PATCH|TRACE|CONNECT)\b/,"attr-name":/:\w+/}},"response-status":{pattern:/^HTTP\/1.[01] \d+.*/m,inside:{property:{pattern:/(^HTTP\/1.[01] )\d+.*/i,lookbehind:!0}}},"header-name":{pattern:/^[\w-]+:(?=.)/m,alias:"keyword"}};var a,e,n,i=t.languages,s={"application/javascript":i.javascript,"application/json":i.json||i.javascript,"application/xml":i.xml,"text/xml":i.xml,"text/html":i.html,"text/css":i.css},p={"application/json":!0,"application/xml":!0};for(var r in s)if(s[r]){a=a||{};var T=p[r]?(void 0,n=(e=r).replace(/^[a-z]+\//,""),"(?:"+e+"|\\w+/(?:[\\w.-]+\\+)+"+n+"(?![+\\w.-]))"):r;a[r]={pattern:RegExp("(content-type:\\s*"+T+"[\\s\\S]*?)(?:\\r?\\n|\\r){2}[\\s\\S]*","i"),lookbehind:!0,inside:{rest:s[r]}}}a&&t.languages.insertBefore("http","header-name",a)}(Prism);!function(n){n.languages.php=n.languages.extend("clike",{keyword:/\b(?:__halt_compiler|abstract|and|array|as|break|callable|case|catch|class|clone|const|continue|declare|default|die|do|echo|else|elseif|empty|enddeclare|endfor|endforeach|endif|endswitch|endwhile|eval|exit|extends|final|finally|for|foreach|function|global|goto|if|implements|include|include_once|instanceof|insteadof|interface|isset|list|namespace|new|or|parent|print|private|protected|public|require|require_once|return|static|switch|throw|trait|try|unset|use|var|while|xor|yield)\b/i,boolean:{pattern:/\b(?:false|true)\b/i,alias:"constant"},constant:[/\b[A-Z_][A-Z0-9_]*\b/,/\b(?:null)\b/i],comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|\/\/.*)/,lookbehind:!0}}),n.languages.insertBefore("php","string",{"shell-comment":{pattern:/(^|[^\\])#.*/,lookbehind:!0,alias:"comment"}}),n.languages.insertBefore("php","comment",{delimiter:{pattern:/\?>$|^<\?(?:php(?=\s)|=)?/i,alias:"important"}}),n.languages.insertBefore("php","keyword",{variable:/\$+(?:\w+\b|(?={))/i,package:{pattern:/(\\|namespace\s+|use\s+)[\w\\]+/,lookbehind:!0,inside:{punctuation:/\\/}}}),n.languages.insertBefore("php","operator",{property:{pattern:/(->)[\w]+/,lookbehind:!0}});var e={pattern:/{\$(?:{(?:{[^{}]+}|[^{}]+)}|[^{}])+}|(^|[^\\{])\$+(?:\w+(?:\[.+?]|->\w+)*)/,lookbehind:!0,inside:{rest:n.languages.php}};n.languages.insertBefore("php","string",{"nowdoc-string":{pattern:/<<<'([^']+)'(?:\r\n?|\n)(?:.*(?:\r\n?|\n))*?\1;/,greedy:!0,alias:"string",inside:{delimiter:{pattern:/^<<<'[^']+'|[a-z_]\w*;$/i,alias:"symbol",inside:{punctuation:/^<<<'?|[';]$/}}}},"heredoc-string":{pattern:/<<<(?:"([^"]+)"(?:\r\n?|\n)(?:.*(?:\r\n?|\n))*?\1;|([a-z_]\w*)(?:\r\n?|\n)(?:.*(?:\r\n?|\n))*?\2;)/i,greedy:!0,alias:"string",inside:{delimiter:{pattern:/^<<<(?:"[^"]+"|[a-z_]\w*)|[a-z_]\w*;$/i,alias:"symbol",inside:{punctuation:/^<<<"?|[";]$/}},interpolation:e}},"single-quoted-string":{pattern:/'(?:\\[\s\S]|[^\\'])*'/,greedy:!0,alias:"string"},"double-quoted-string":{pattern:/"(?:\\[\s\S]|[^\\"])*"/,greedy:!0,alias:"string",inside:{interpolation:e}}}),delete n.languages.php.string,n.hooks.add("before-tokenize",function(e){if(/<\?/.test(e.code)){n.languages["markup-templating"].buildPlaceholders(e,"php",/<\?(?:[^"'/#]|\/(?![*/])|("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|(?:\/\/|#)(?:[^?\n\r]|\?(?!>))*|\/\*[\s\S]*?(?:\*\/|$))*?(?:\?>|$)/gi)}}),n.hooks.add("after-tokenize",function(e){n.languages["markup-templating"].tokenizePlaceholders(e,"php")})}(Prism);Prism.languages.json={property:{pattern:/"(?:\\.|[^\\"\r\n])*"(?=\s*:)/,greedy:!0},string:{pattern:/"(?:\\.|[^\\"\r\n])*"(?!\s*:)/,greedy:!0},comment:/\/\/.*|\/\*[\s\S]*?(?:\*\/|$)/,number:/-?\d+\.?\d*(e[+-]?\d+)?/i,punctuation:/[{}[\],]/,operator:/:/,boolean:/\b(?:true|false)\b/,null:{pattern:/\bnull\b/,alias:"keyword"}};Prism.languages.python={comment:{pattern:/(^|[^\\])#.*/,lookbehind:!0},"string-interpolation":{pattern:/(?:f|rf|fr)(?:("""|''')[\s\S]+?\1|("|')(?:\\.|(?!\2)[^\\\r\n])*\2)/i,greedy:!0,inside:{interpolation:{pattern:/((?:^|[^{])(?:{{)*){(?!{)(?:[^{}]|{(?!{)(?:[^{}]|{(?!{)(?:[^{}])+})+})+}/,lookbehind:!0,inside:{"format-spec":{pattern:/(:)[^:(){}]+(?=}$)/,lookbehind:!0},"conversion-option":{pattern:/![sra](?=[:}]$)/,alias:"punctuation"},rest:null}},string:/[\s\S]+/}},"triple-quoted-string":{pattern:/(?:[rub]|rb|br)?("""|''')[\s\S]+?\1/i,greedy:!0,alias:"string"},string:{pattern:/(?:[rub]|rb|br)?("|')(?:\\.|(?!\1)[^\\\r\n])*\1/i,greedy:!0},function:{pattern:/((?:^|\s)def[ \t]+)[a-zA-Z_]\w*(?=\s*\()/g,lookbehind:!0},"class-name":{pattern:/(\bclass\s+)\w+/i,lookbehind:!0},decorator:{pattern:/(^\s*)@\w+(?:\.\w+)*/i,lookbehind:!0,alias:["annotation","punctuation"],inside:{punctuation:/\./}},keyword:/\b(?:and|as|assert|async|await|break|class|continue|def|del|elif|else|except|exec|finally|for|from|global|if|import|in|is|lambda|nonlocal|not|or|pass|print|raise|return|try|while|with|yield)\b/,builtin:/\b(?:__import__|abs|all|any|apply|ascii|basestring|bin|bool|buffer|bytearray|bytes|callable|chr|classmethod|cmp|coerce|compile|complex|delattr|dict|dir|divmod|enumerate|eval|execfile|file|filter|float|format|frozenset|getattr|globals|hasattr|hash|help|hex|id|input|int|intern|isinstance|issubclass|iter|len|list|locals|long|map|max|memoryview|min|next|object|oct|open|ord|pow|property|range|raw_input|reduce|reload|repr|reversed|round|set|setattr|slice|sorted|staticmethod|str|sum|super|tuple|type|unichr|unicode|vars|xrange|zip)\b/,boolean:/\b(?:True|False|None)\b/,number:/(?:\b(?=\d)|\B(?=\.))(?:0[bo])?(?:(?:\d|0x[\da-f])[\da-f]*\.?\d*|\.\d+)(?:e[+-]?\d+)?j?\b/i,operator:/[-+%=]=?|!=|\*\*?=?|\/\/?=?|<[<=>]?|>[=>]?|[&|^~]/,punctuation:/[{}[\];(),.:]/},Prism.languages.python["string-interpolation"].inside.interpolation.inside.rest=Prism.languages.python,Prism.languages.py=Prism.languages.python;!function(){if("undefined"!=typeof self&&self.Prism&&self.document){var l="line-numbers",c=/\n(?!$)/g,m=function(e){var t=a(e)["white-space"];if("pre-wrap"===t||"pre-line"===t){var n=e.querySelector("code"),r=e.querySelector(".line-numbers-rows"),s=e.querySelector(".line-numbers-sizer"),i=n.textContent.split(c);s||((s=document.createElement("span")).className="line-numbers-sizer",n.appendChild(s)),s.style.display="block",i.forEach(function(e,t){s.textContent=e||"\n";var n=s.getBoundingClientRect().height;r.children[t].style.height=n+"px"}),s.textContent="",s.style.display="none"}},a=function(e){return e?window.getComputedStyle?getComputedStyle(e):e.currentStyle||null:null};window.addEventListener("resize",function(){Array.prototype.forEach.call(document.querySelectorAll("pre."+l),m)}),Prism.hooks.add("complete",function(e){if(e.code){var t=e.element,n=t.parentNode;if(n&&/pre/i.test(n.nodeName)&&!t.querySelector(".line-numbers-rows")){for(var r=!1,s=/(?:^|\s)line-numbers(?:\s|$)/,i=t;i;i=i.parentNode)if(s.test(i.className)){r=!0;break}if(r){t.className=t.className.replace(s," "),s.test(n.className)||(n.className+=" line-numbers");var l,a=e.code.match(c),o=a?a.length+1:1,u=new Array(o+1).join("<span></span>");(l=document.createElement("span")).setAttribute("aria-hidden","true"),l.className="line-numbers-rows",l.innerHTML=u,n.hasAttribute("data-start")&&(n.style.counterReset="linenumber "+(parseInt(n.getAttribute("data-start"),10)-1)),e.element.appendChild(l),m(n),Prism.hooks.run("line-numbers",e)}}}}),Prism.hooks.add("line-numbers",function(e){e.plugins=e.plugins||{},e.plugins.lineNumbers=!0}),Prism.plugins.lineNumbers={getLine:function(e,t){if("PRE"===e.tagName&&e.classList.contains(l)){var n=e.querySelector(".line-numbers-rows"),r=parseInt(e.getAttribute("data-start"),10)||1,s=r+(n.children.length-1);t<r&&(t=r),s<t&&(t=s);var i=t-r;return n.children[i]}}}}}();var TurndownService=(function(){'use strict';function extend(destination){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(source.hasOwnProperty(key))destination[key]=source[key];}}
return destination}
function repeat(character,count){return Array(count+1).join(character)}
var blockElements=['address','article','aside','audio','blockquote','body','canvas','center','dd','dir','div','dl','dt','fieldset','figcaption','figure','footer','form','frameset','h1','h2','h3','h4','h5','h6','header','hgroup','hr','html','isindex','li','main','menu','nav','noframes','noscript','ol','output','p','pre','section','table','tbody','td','tfoot','th','thead','tr','ul'];function isBlock(node){return blockElements.indexOf(node.nodeName.toLowerCase())!==-1}
var voidElements=['area','base','br','col','command','embed','hr','img','input','keygen','link','meta','param','source','track','wbr'];function isVoid(node){return voidElements.indexOf(node.nodeName.toLowerCase())!==-1}
var voidSelector=voidElements.join();function hasVoid(node){return node.querySelector&&node.querySelector(voidSelector)}
var rules={};rules.paragraph={filter:'p',replacement:function(content){return'\n\n'+content+'\n\n'}};rules.lineBreak={filter:'br',replacement:function(content,node,options){return options.br+'\n'}};rules.heading={filter:['h1','h2','h3','h4','h5','h6'],replacement:function(content,node,options){var hLevel=Number(node.nodeName.charAt(1));if(options.headingStyle==='setext'&&hLevel<3){var underline=repeat((hLevel===1?'=':'-'),content.length);return('\n\n'+content+'\n'+underline+'\n\n')}else{return'\n\n'+repeat('#',hLevel)+' '+content+'\n\n'}}};rules.blockquote={filter:'blockquote',replacement:function(content){content=content.replace(/^\n+|\n+$/g,'');content=content.replace(/^/gm,'> ');return'\n\n'+content+'\n\n'}};rules.list={filter:['ul','ol'],replacement:function(content,node){var parent=node.parentNode;if(parent.nodeName==='LI'&&parent.lastElementChild===node){return'\n'+content}else{return'\n\n'+content+'\n\n'}}};rules.listItem={filter:'li',replacement:function(content,node,options){content=content.replace(/^\n+/,'').replace(/\n+$/,'\n').replace(/\n/gm,'\n    ');var prefix=options.bulletListMarker+'   ';var parent=node.parentNode;if(parent.nodeName==='OL'){var start=parent.getAttribute('start');var index=Array.prototype.indexOf.call(parent.children,node);prefix=(start?Number(start)+index:index+1)+'.  ';}
return(prefix+content+(node.nextSibling&&!/\n$/.test(content)?'\n':''))}};rules.indentedCodeBlock={filter:function(node,options){return(options.codeBlockStyle==='indented'&&node.nodeName==='PRE'&&node.firstChild&&node.firstChild.nodeName==='CODE')},replacement:function(content,node,options){return('\n\n    '+
node.firstChild.textContent.replace(/\n/g,'\n    ')+'\n\n')}};rules.fencedCodeBlock={filter:function(node,options){return(options.codeBlockStyle==='fenced'&&node.nodeName==='PRE'&&node.firstChild&&node.firstChild.nodeName==='CODE')},replacement:function(content,node,options){var className=node.firstChild.className||'';var language=(className.match(/language-(\S+)/)||[null,''])[1];return('\n\n'+options.fence+language+'\n'+
node.firstChild.textContent+'\n'+options.fence+'\n\n')}};rules.horizontalRule={filter:'hr',replacement:function(content,node,options){return'\n\n'+options.hr+'\n\n'}};rules.inlineLink={filter:function(node,options){return(options.linkStyle==='inlined'&&node.nodeName==='A'&&node.getAttribute('href'))},replacement:function(content,node){var href=node.getAttribute('href');var title=node.title?' "'+node.title+'"':'';return'['+content+']('+href+title+')'}};rules.referenceLink={filter:function(node,options){return(options.linkStyle==='referenced'&&node.nodeName==='A'&&node.getAttribute('href'))},replacement:function(content,node,options){var href=node.getAttribute('href');var title=node.title?' "'+node.title+'"':'';var replacement;var reference;switch(options.linkReferenceStyle){case'collapsed':replacement='['+content+'][]';reference='['+content+']: '+href+title;break
case'shortcut':replacement='['+content+']';reference='['+content+']: '+href+title;break
default:var id=this.references.length+1;replacement='['+content+']['+id+']';reference='['+id+']: '+href+title;}
this.references.push(reference);return replacement},references:[],append:function(options){var references='';if(this.references.length){references='\n\n'+this.references.join('\n')+'\n\n';this.references=[];}
return references}};rules.emphasis={filter:['em','i'],replacement:function(content,node,options){if(!content.trim())return''
return options.emDelimiter+content+options.emDelimiter}};rules.strong={filter:['strong','b'],replacement:function(content,node,options){if(!content.trim())return''
return options.strongDelimiter+content+options.strongDelimiter}};rules.code={filter:function(node){var hasSiblings=node.previousSibling||node.nextSibling;var isCodeBlock=node.parentNode.nodeName==='PRE'&&!hasSiblings;return node.nodeName==='CODE'&&!isCodeBlock},replacement:function(content){if(!content.trim())return''
var delimiter='`';var leadingSpace='';var trailingSpace='';var matches=content.match(/`+/gm);if(matches){if(/^`/.test(content))leadingSpace=' ';if(/`$/.test(content))trailingSpace=' ';while(matches.indexOf(delimiter)!==-1)delimiter=delimiter+'`';}
return delimiter+leadingSpace+content+trailingSpace+delimiter}};rules.image={filter:'img',replacement:function(content,node){var alt=node.alt||'';var src=node.getAttribute('src')||'';var title=node.title||'';var titlePart=title?' "'+title+'"':'';return src?'!['+alt+']'+'('+src+titlePart+')':''}};function Rules(options){this.options=options;this._keep=[];this._remove=[];this.blankRule={replacement:options.blankReplacement};this.keepReplacement=options.keepReplacement;this.defaultRule={replacement:options.defaultReplacement};this.array=[];for(var key in options.rules)this.array.push(options.rules[key]);}
Rules.prototype={add:function(key,rule){this.array.unshift(rule);},keep:function(filter){this._keep.unshift({filter:filter,replacement:this.keepReplacement});},remove:function(filter){this._remove.unshift({filter:filter,replacement:function(){return''}});},forNode:function(node){if(node.isBlank)return this.blankRule
var rule;if((rule=findRule(this.array,node,this.options)))return rule
if((rule=findRule(this._keep,node,this.options)))return rule
if((rule=findRule(this._remove,node,this.options)))return rule
return this.defaultRule},forEach:function(fn){for(var i=0;i<this.array.length;i++)fn(this.array[i],i);}};function findRule(rules,node,options){for(var i=0;i<rules.length;i++){var rule=rules[i];if(filterValue(rule,node,options))return rule}
return void 0}
function filterValue(rule,node,options){var filter=rule.filter;if(typeof filter==='string'){if(filter===node.nodeName.toLowerCase())return true}else if(Array.isArray(filter)){if(filter.indexOf(node.nodeName.toLowerCase())>-1)return true}else if(typeof filter==='function'){if(filter.call(rule,node,options))return true}else{throw new TypeError('`filter` needs to be a string, array, or function')}}
function collapseWhitespace(options){var element=options.element;var isBlock=options.isBlock;var isVoid=options.isVoid;var isPre=options.isPre||function(node){return node.nodeName==='PRE'};if(!element.firstChild||isPre(element))return
var prevText=null;var prevVoid=false;var prev=null;var node=next(prev,element,isPre);while(node!==element){if(node.nodeType===3||node.nodeType===4){var text=node.data.replace(/[ \r\n\t]+/g,' ');if((!prevText||/ $/.test(prevText.data))&&!prevVoid&&text[0]===' '){text=text.substr(1);}
if(!text){node=remove(node);continue}
node.data=text;prevText=node;}else if(node.nodeType===1){if(isBlock(node)||node.nodeName==='BR'){if(prevText){prevText.data=prevText.data.replace(/ $/,'');}
prevText=null;prevVoid=false;}else if(isVoid(node)){prevText=null;prevVoid=true;}}else{node=remove(node);continue}
var nextNode=next(prev,node,isPre);prev=node;node=nextNode;}
if(prevText){prevText.data=prevText.data.replace(/ $/,'');if(!prevText.data){remove(prevText);}}}
function remove(node){var next=node.nextSibling||node.parentNode;node.parentNode.removeChild(node);return next}
function next(prev,current,isPre){if((prev&&prev.parentNode===current)||isPre(current)){return current.nextSibling||current.parentNode}
return current.firstChild||current.nextSibling||current.parentNode}
var root=(typeof window!=='undefined'?window:{});function canParseHTMLNatively(){var Parser=root.DOMParser;var canParse=false;try{if(new Parser().parseFromString('','text/html')){canParse=true;}}catch(e){}
return canParse}
function createHTMLParser(){var Parser=function(){};{if(shouldUseActiveX()){Parser.prototype.parseFromString=function(string){var doc=new window.ActiveXObject('htmlfile');doc.designMode='on';doc.open();doc.write(string);doc.close();return doc};}else{Parser.prototype.parseFromString=function(string){var doc=document.implementation.createHTMLDocument('');doc.open();doc.write(string);doc.close();return doc};}}
return Parser}
function shouldUseActiveX(){var useActiveX=false;try{document.implementation.createHTMLDocument('').open();}catch(e){if(window.ActiveXObject)useActiveX=true;}
return useActiveX}
var HTMLParser=canParseHTMLNatively()?root.DOMParser:createHTMLParser();function RootNode(input){var root;if(typeof input==='string'){var doc=htmlParser().parseFromString('<x-turndown id="turndown-root">'+input+'</x-turndown>','text/html');root=doc.getElementById('turndown-root');}else{root=input.cloneNode(true);}
collapseWhitespace({element:root,isBlock:isBlock,isVoid:isVoid});return root}
var _htmlParser;function htmlParser(){_htmlParser=_htmlParser||new HTMLParser();return _htmlParser}
function Node(node){node.isBlock=isBlock(node);node.isCode=node.nodeName.toLowerCase()==='code'||node.parentNode.isCode;node.isBlank=isBlank(node);node.flankingWhitespace=flankingWhitespace(node);return node}
function isBlank(node){return(['A','TH','TD'].indexOf(node.nodeName)===-1&&/^\s*$/i.test(node.textContent)&&!isVoid(node)&&!hasVoid(node))}
function flankingWhitespace(node){var leading='';var trailing='';if(!node.isBlock){var hasLeading=/^[ \r\n\t]/.test(node.textContent);var hasTrailing=/[ \r\n\t]$/.test(node.textContent);if(hasLeading&&!isFlankedByWhitespace('left',node)){leading=' ';}
if(hasTrailing&&!isFlankedByWhitespace('right',node)){trailing=' ';}}
return{leading:leading,trailing:trailing}}
function isFlankedByWhitespace(side,node){var sibling;var regExp;var isFlanked;if(side==='left'){sibling=node.previousSibling;regExp=/ $/;}else{sibling=node.nextSibling;regExp=/^ /;}
if(sibling){if(sibling.nodeType===3){isFlanked=regExp.test(sibling.nodeValue);}else if(sibling.nodeType===1&&!isBlock(sibling)){isFlanked=regExp.test(sibling.textContent);}}
return isFlanked}
var reduce=Array.prototype.reduce;var leadingNewLinesRegExp=/^\n*/;var trailingNewLinesRegExp=/\n*$/;function TurndownService(options){if(!(this instanceof TurndownService))return new TurndownService(options)
var defaults={rules:rules,headingStyle:'setext',hr:'* * *',bulletListMarker:'*',codeBlockStyle:'indented',fence:'```',emDelimiter:'_',strongDelimiter:'**',linkStyle:'inlined',linkReferenceStyle:'full',br:'  ',blankReplacement:function(content,node){return node.isBlock?'\n\n':''},keepReplacement:function(content,node){return node.isBlock?'\n\n'+node.outerHTML+'\n\n':node.outerHTML},defaultReplacement:function(content,node){return node.isBlock?'\n\n'+content+'\n\n':content}};this.options=extend({},defaults,options);this.rules=new Rules(this.options);}
TurndownService.prototype={turndown:function(input){if(!canConvert(input)){throw new TypeError(input+' is not a string, or an element/document/fragment node.')}
if(input==='')return''
var output=process.call(this,new RootNode(input));return postProcess.call(this,output)},use:function(plugin){if(Array.isArray(plugin)){for(var i=0;i<plugin.length;i++)this.use(plugin[i]);}else if(typeof plugin==='function'){plugin(this);}else{throw new TypeError('plugin must be a Function or an Array of Functions')}
return this},addRule:function(key,rule){this.rules.add(key,rule);return this},keep:function(filter){this.rules.keep(filter);return this},remove:function(filter){this.rules.remove(filter);return this},escape:function(string){return(string.replace(/\\(\S)/g,'\\\\$1').replace(/^(#{1,6} )/gm,'\\$1').replace(/^([-*_] *){3,}$/gm,function(match,character){return match.split(character).join('\\'+character)}).replace(/^(\W* {0,3})(\d+)\. /gm,'$1$2\\. ').replace(/^([^\\\w]*)[*+-] /gm,function(match){return match.replace(/([*+-])/g,'\\$1')}).replace(/^(\W* {0,3})> /gm,'$1\\> ').replace(/\*+(?![*\s\W]).+?\*+/g,function(match){return match.replace(/\*/g,'\\*')}).replace(/_+(?![_\s\W]).+?_+/g,function(match){return match.replace(/_/g,'\\_')}).replace(/`+(?![`\s\W]).+?`+/g,function(match){return match.replace(/`/g,'\\`')}).replace(/[\[\]]/g,'\\$&'))}};function process(parentNode){var self=this;return reduce.call(parentNode.childNodes,function(output,node){node=new Node(node);var replacement='';if(node.nodeType===3){replacement=node.isCode?node.nodeValue:self.escape(node.nodeValue);}else if(node.nodeType===1){replacement=replacementForNode.call(self,node);}
return join(output,replacement)},'')}
function postProcess(output){var self=this;this.rules.forEach(function(rule){if(typeof rule.append==='function'){output=join(output,rule.append(self.options));}});return output.replace(/^[\t\r\n]+/,'').replace(/[\t\r\n\s]+$/,'')}
function replacementForNode(node){var rule=this.rules.forNode(node);var content=process.call(this,node);var whitespace=node.flankingWhitespace;if(whitespace.leading||whitespace.trailing)content=content.trim();return(whitespace.leading+
rule.replacement(content,node,this.options)+
whitespace.trailing)}
function separatingNewlines(output,replacement){var newlines=[output.match(trailingNewLinesRegExp)[0],replacement.match(leadingNewLinesRegExp)[0]].sort();var maxNewlines=newlines[newlines.length-1];return maxNewlines.length<2?maxNewlines:'\n\n'}
function join(string1,string2){var separator=separatingNewlines(string1,string2);string1=string1.replace(trailingNewLinesRegExp,'');string2=string2.replace(leadingNewLinesRegExp,'');return string1+separator+string2}
function canConvert(input){return(input!=null&&(typeof input==='string'||(input.nodeType&&(input.nodeType===1||input.nodeType===9||input.nodeType===11))))}
return TurndownService;}());

window.ls=window.ls||{};window.ls.container=function(){let stock={};let listeners={};let set=function(name,object,singleton,watch=true){if(typeof name!=='string'){throw new Error('var name must be of type string');}
if(typeof singleton!=='boolean'){throw new Error('var singleton "'+singleton+'" of service "'+name+'" must be of type boolean');}
stock[name]={name:name,object:object,singleton:singleton,instance:null,watch:watch,};if(!watch){return this;}
let binds=listeners[name]||{};for(let key in binds){if(binds.hasOwnProperty(key)){document.dispatchEvent(new CustomEvent(key));}}
return this;};let get=function(name){let service=(undefined!==stock[name])?stock[name]:null;if(null==service){return null;}
if(service.instance){return service.instance;}
let instance=(typeof service.object==='function')?this.resolve(service.object):service.object;let skip=false;if(service.watch&&name!=='window'&&name!=='document'&&name!=='element'&&typeof instance==='object'&&instance!==null){let handler={name:service.name,watch:function(){},get:function(target,key){if(key==="__name"){return this.name;}
if(key==="__watch"){return this.watch;}
if(key==="__proxy"){return true;}
if(typeof target[key]==='object'&&target[key]!==null&&!target[key].__proxy){let handler=Object.assign({},this);handler.name=handler.name+'.'+key;return new Proxy(target[key],handler)}
else{return target[key];}},set:function(target,key,value,receiver){if(key==="__name"){return this.name=value;}
if(key==="__watch"){return this.watch=value;}
target[key]=value;let path=receiver.__name+'.'+key;document.dispatchEvent(new CustomEvent(path+'.changed'));if(skip){return true;}
skip=true;container.set('$prop',key,true);container.set('$value',value,true);container.resolve(this.watch);container.set('$key',null,true);container.set('$value',null,true);skip=false;return true;},};instance=new Proxy(instance,handler);}
if(service.singleton){service.instance=instance;}
return instance;};let resolve=function(target){if(!target){return()=>{};}
let self=this;const REGEX_COMMENTS=/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/mg;const REGEX_FUNCTION_PARAMS=/(?:\s*(?:function\s*[^(]*)?\s*)((?:[^'"]|(?:(?:(['"])(?:(?:.*?[^\\]\2)|\2))))*?)\s*(?=(?:=>)|{)/m;const REGEX_PARAMETERS_VALUES=/\s*([\w\\$]+)\s*(?:=\s*((?:(?:(['"])(?:\3|(?:.*?[^\\]\3)))((\s*\+\s*)(?:(?:(['"])(?:\6|(?:.*?[^\\]\6)))|(?:[\w$]*)))*)|.*?))?\s*(?:,|$)/gm;function getParams(func){let functionAsString=func.toString();let params=[];let match;functionAsString=functionAsString.replace(REGEX_COMMENTS,'');functionAsString=functionAsString.match(REGEX_FUNCTION_PARAMS)[1];if(functionAsString.charAt(0)==='('){functionAsString=functionAsString.slice(1,-1);}
while(match=REGEX_PARAMETERS_VALUES.exec(functionAsString)){params.push(match[1]);}
return params;}
let args=getParams(target);return target.apply(target,args.map(function(value){return self.get(value.trim());}));};let path=function(path,value,as,prefix){as=(as)?as:container.get('$as');prefix=(prefix)?prefix:container.get('$prefix');path=((path.indexOf('.')>-1)?path.replace(as+'.',prefix+'.'):path.replace(as,prefix)).split('.');let name=path.shift();let object=this.get(name);let result=null;while(path.length>1){if(!object){return null;}
object=object[path.shift()];}
let shift=path.shift();if(value!==null&&value!==undefined&&object&&shift&&object[shift]){object[shift]=value;return true;}
if(!object){return null;}
if(!shift){result=object;}
else{return object[shift];}
return result;};let bind=function(element,path,callback,as,prefix){as=(as)?as:container.get('$as');prefix=(prefix)?prefix:container.get('$prefix');let event=((path.indexOf('.')>-1)?path.replace(as+'.',prefix+'.'):path.replace(as,prefix))+'.changed';let service=event.split('.').slice(0,1).pop();listeners[service]=listeners[service]||{};listeners[service][event]=true;let printer=()=>{if(!document.body.contains(element)){element=null;document.removeEventListener(event,printer,false);return false;}
callback();};document.addEventListener(event,printer);};let container={set:set,get:get,resolve:resolve,path:path,bind:bind,stock:stock,listeners:listeners,};set('container',container,true,false);return container;}();window.ls.container.set('http',function(document){let globalParams=[],globalHeaders=[];let addParam=function(url,param,value){param=encodeURIComponent(param);let a=document.createElement('a');param+=(value?"="+encodeURIComponent(value):"");a.href=url;a.search+=(a.search?"&":"")+param;return a.href;};let request=function(method,url,headers,payload,progress){let i;if(-1===['GET','POST','PUT','DELETE','TRACE','HEAD','OPTIONS','CONNECT','PATCH'].indexOf(method)){throw new Error('var method must contain a valid HTTP method name');}
if(typeof url!=='string'){throw new Error('var url must be of type string');}
if(typeof headers!=='object'){throw new Error('var headers must be of type object');}
if(typeof url!=='string'){throw new Error('var url must be of type string');}
for(i=0;i<globalParams.length;i++){url=addParam(url,globalParams[i].key,globalParams[i].value);}
return new Promise(function(resolve,reject){let xmlhttp=new XMLHttpRequest();xmlhttp.open(method,url,true);xmlhttp.setRequestHeader('Ajax','1');for(i=0;i<globalHeaders.length;i++){xmlhttp.setRequestHeader(globalHeaders[i].key,globalHeaders[i].value);}
for(let key in headers){if(headers.hasOwnProperty(key)){xmlhttp.setRequestHeader(key,headers[key]);}}
xmlhttp.onload=function(){if(4===xmlhttp.readyState&&200===xmlhttp.status){resolve(xmlhttp.response);}
else{document.dispatchEvent(new CustomEvent('http-'+method.toLowerCase()+'-'+xmlhttp.status));reject(new Error(xmlhttp.statusText));}};if(progress){xmlhttp.addEventListener('progress',progress);xmlhttp.upload.addEventListener('progress',progress,false);}
xmlhttp.onerror=function(){reject(new Error("Network Error"));};xmlhttp.send(payload);})};return{'get':function(url){return request('GET',url,{},'')},'post':function(url,headers,payload){return request('POST',url,headers,payload)},'put':function(url,headers,payload){return request('PUT',url,headers,payload)},'patch':function(url,headers,payload){return request('PATCH',url,headers,payload)},'delete':function(url){return request('DELETE',url,{},'')},'addGlobalParam':function(key,value){globalParams.push({key:key,value:value});},'addGlobalHeader':function(key,value){globalHeaders.push({key:key,value:value});}}},true,false);window.ls.container.set('cookie',function(document){function get(name){let value="; "+document.cookie,parts=value.split("; "+name+"=");if(parts.length===2){return parts.pop().split(";").shift();}
return null;}
function set(name,value,days){let date=new Date();date.setTime(date.getTime()+(days*24*60*60*1000));let expires=(0<days)?'expires='+date.toUTCString():'expires=0';document.cookie=name+"="+value+";"+expires+";path=/";return this;}
return{'get':get,'set':set}},true,false);window.ls.container.set('view',function(http,container){let stock={};let execute=function(view,node,container){container.set('element',node,true,false);container.resolve(view.controller);if(true!==view.repeat){node.removeAttribute(view.selector);}};let parse=function(node,skip){if(node.tagName==='SCRIPT'){return;}
if(node.attributes&&skip!==true){let attrs=[];let attrsLen=node.attributes.length;for(let x=0;x<attrsLen;x++){attrs.push(node.attributes[x].nodeName);}
if(1!==node.nodeType){return;}
if(attrs&&attrsLen){for(let x=0;x<attrsLen;x++){if(node.$lsSkip===true){break;}
let pointer=(!/Edge/.test(navigator.userAgent))?x:(attrsLen-1)-x;let length=attrsLen;let attr=attrs[pointer];if(!stock[attr]){continue;}
let comp=stock[attr];if(typeof comp.template==="function"){comp.template=container.resolve(comp.template);}
if(!comp.template){(function(comp,node,container){execute(comp,node,container);})(comp,node,container);if(length!==attrsLen){x--;}
continue;}
node.classList.remove('load-end');node.classList.add('load-start');node.$lsSkip=true;http.get(comp.template).then(function(node,comp){return function(data){node.$lsSkip=false;node.innerHTML=data;node.classList.remove('load-start');node.classList.add('load-end');(function(comp,node,container){execute(comp,node,container);})(comp,node,container);parse(node,true);}}(node,comp),function(error){throw new Error('Failed to load comp template: '+error.message);});}}}
if(true===node.$lsSkip){return;}
let list=(node)?node.childNodes:[];if(node.$lsSkip===true){list=[];}
for(let i=0;i<list.length;i++){let child=list[i];parse(child);}};return{stock:stock,add:function(object){if(typeof object!=='object'){throw new Error('object must be of type object');}
let defaults={'selector':'','controller':function(){},'template':'','repeat':false,'protected':false};for(let prop in defaults){if(!defaults.hasOwnProperty(prop)){continue;}
if(prop in object){continue;}
object[prop]=defaults[prop];}
if(!object.selector){throw new Error('View component is missing a selector attribute');}
stock[object.selector]=object;return this;},render:function(element){parse(element);element.dispatchEvent(new window.Event('rendered',{bubbles:false}));}}},true,false);window.ls.container.set('router',function(window){let getJsonFromUrl=function(URL){let query;if(URL){let pos=location.href.indexOf('?');if(pos===-1)return[];query=location.href.substr(pos+1);}else{query=location.search.substr(1);}
let result={};query.split('&').forEach(function(part){if(!part){return;}
part=part.split('+').join(' ');let eq=part.indexOf('=');let key=eq>-1?part.substr(0,eq):part;let val=eq>-1?decodeURIComponent(part.substr(eq+1)):'';let from=key.indexOf('[');if(from===-1){result[decodeURIComponent(key)]=val;}
else{let to=key.indexOf(']');let index=decodeURIComponent(key.substring(from+1,to));key=decodeURIComponent(key.substring(0,from));if(!result[key]){result[key]=[];}
if(!index){result[key].push(val);}
else{result[key][index]=val;}}});return result;};let states=[];let params=getJsonFromUrl(window.location.search);let hash=window.location.hash;let current=null;let previous=null;let getPrevious=()=>previous;let getCurrent=()=>current;let setPrevious=(value)=>{previous=value;return this;};let setCurrent=(value)=>{current=value;return this;};let setParam=function(key,value){params[key]=value;return this;};let getParam=function(key,def){if(key in params){return params[key];}
return def;};let getParams=function(){return params;};let getURL=function(){return window.location.href;};let add=function(path,view){if(typeof path!=='string'){throw new Error('path must be of type string');}
if(typeof view!=='object'){throw new Error('view must be of type object');}
states[states.length++]={path:path,view:view};return this;};let match=function(location){let url=location.pathname;states.sort(function(a,b){return b.path.length-a.path.length;});states.sort(function(a,b){let n=b.path.split('/').length-a.path.split('/').length;if(n!==0){return n;}
return b.path.length-a.path.length;});for(let i=0;i<states.length;i++){let value=states[i];value.path=(value.path.substring(0,1)!=='/')?location.pathname+value.path:value.path;let match=new RegExp("^"+value.path.replace(/:[^\s/]+/g,'([\\w-]+)')+"$");let found=url.match(match);if(found){previous=current;current=value;return value;}}
return null};let change=function(URL,replace){if(!replace){window.history.pushState({},'',URL);}
else{window.history.replaceState({},'',URL);}
window.dispatchEvent(new PopStateEvent('popstate',{}));return this;};let reload=function(){return change(window.location.href);};return{setParam:setParam,getParam:getParam,getParams:getParams,getURL:getURL,add:add,change:change,reload:reload,match:match,getCurrent:getCurrent,setCurrent:setCurrent,getPrevious:getPrevious,setPrevious:setPrevious,params:params,hash:hash,reset:function(){this.params=getJsonFromUrl(window.location.search);this.hash=window.location.hash;}};},true,true);window.ls.container.set('expression',function(container,filter){let paths=[];return{regex:/(\{{.*?\}})/gi,parse:function(string,def,as,prefix,cast=false){def=def||'';paths=[];return string.replace(this.regex,match=>{let reference=match.substring(2,match.length-2).replace('[\'','.').replace('\']','').trim();reference=reference.split('|');let path=(reference[0]||'');let result=container.path(path,undefined,as,prefix);path=(path.indexOf('.')>-1)?path.replace(as+'.',prefix+'.'):path.replace(as,prefix);if(!paths.includes(path)){paths.push(path);}
if(reference.length>=2){for(let i=1;i<reference.length;i++){result=filter.apply(reference[i],result);}}
if(null===result||undefined===result){result=def;}
else if(typeof result==='object'){result=JSON.stringify(result,null,4);}
else if(((typeof result==='object')||(typeof result==='string'))&&cast){result='\''+result+'\'';}
return result;});},getPaths:()=>paths,}},true,false);window.ls.container.set('filter',function(container){let filters={};let add=function(name,callback){filters[name]=callback;return this;};let apply=function(name,value){container.set('$value',value,true,false);return container.resolve(filters[name]);};add('uppercase',($value)=>{if(typeof $value!=='string'){return $value;}
return $value.toUpperCase();});add('lowercase',($value)=>{if(typeof $value!=='string'){return $value;}
return $value.toLowerCase();});return{add:add,apply:apply}},true,false);window.ls.container.get('filter').add('escape',value=>{if(typeof value!=='string'){return value;}
return value.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/\"/g,'&quot;').replace(/\'/g,'&#39;').replace(/\//g,'&#x2F;');});window.ls=window.ls||{};window.ls.container.set('window',window,true,false).set('document',window.document,true,false).set('element',window.document,true,false);window.ls.run=function(window){try{this.view.render(window.document);}
catch(error){let handler=window.ls.container.resolve(this.error);handler(error);}};window.ls.error=()=>{return error=>{console.error('ls-error',error.message,error.stack,error.toString());}};window.ls.router=window.ls.container.get('router');window.ls.view=window.ls.container.get('view');window.ls.filter=window.ls.container.get('filter');window.ls.container.get('view').add({selector:'data-ls-router',repeat:false,controller:function(element,window,document,view,router){let firstFromServer=(element.getAttribute('data-first-from-server')==='true');let scope={selector:'data-ls-scope',template:false,repeat:true,controller:function(){},};let init=function(route){let count=parseInt(element.getAttribute('data-ls-scope-count')||0);element.setAttribute('data-ls-scope-count',count+1);window.scrollTo(0,0);if(window.document.body.scrollTo){window.document.body.scrollTo(0,0);}
router.reset();if(null===route){return;}
scope.template=(undefined!==route.view.template)?route.view.template:null;scope.controller=(undefined!==route.view.controller)?route.view.controller:function(){};document.dispatchEvent(new CustomEvent('state-change'));if(firstFromServer&&null===router.getPrevious()){scope.template='';}
else if(count===1){view.render(element);}
else if(null!==router.getPrevious()){view.render(element);}
document.dispatchEvent(new CustomEvent('state-changed'));};let findParent=function(tagName,el){if((el.nodeName||el.tagName).toLowerCase()===tagName.toLowerCase()){return el;}
while(el=el.parentNode){if((el.nodeName||el.tagName).toLowerCase()===tagName.toLowerCase()){return el;}}
return null;};element.removeAttribute('data-ls-router');element.setAttribute('data-ls-scope','');element.setAttribute('data-ls-scope-count',1);view.add(scope);document.addEventListener('click',function(event){let target=findParent('a',event.target);if(!target){return false;}
if(!target.href){return false;}
if((event.metaKey)){return false;}
if((target.hasAttribute('target'))&&('_blank'===target.getAttribute('target'))){return false;}
if(target.hostname!==window.location.hostname){return false;}
let route=router.match(target);if(null===route){return false;}
event.preventDefault();if(window.location===target.href){return false;}
route.view.state=(undefined===route.view.state)?true:route.view.state;if(true===route.view.state){if(router.getPrevious()&&router.getPrevious().view&&(router.getPrevious().view.scope!==route.view.scope)){window.location.href=target.href;return false;}
window.history.pushState({},'Unknown',target.href);}
init(route);return true;});window.addEventListener('popstate',function(){init(router.match(window.location));});window.addEventListener('hashchange',function(){init(router.match(window.location));});init(router.match(window.location));}});window.ls.container.get('view').add({selector:'data-ls-attrs',controller:function(element,expression,container,$as,$prefix){let attrs=element.getAttribute('data-ls-attrs').trim().split(',');let paths=[];let debug=element.getAttribute('data-debug')||false;let check=()=>{container.set('element',element,true,false);if(debug){console.info('debug-ls-attrs attributes:',attrs);}
for(let i=0;i<attrs.length;i++){let attr=attrs[i];let key=expression.parse((attr.substring(0,attr.indexOf('='))||attr),null,$as,$prefix);paths=paths.concat(expression.getPaths());let value='';if(attr.indexOf('=')>-1){value=expression.parse(attr.substring(attr.indexOf('=')+1),null,$as,$prefix)||'';paths=paths.concat(expression.getPaths());}
if(!key){return null;}
element.setAttribute(key,value);}};check();for(let i=0;i<paths.length;i++){let path=paths[i].split('.');if(debug){console.info('debug-ls-attrs listen to:',path.join('.'));}
while(path.length){container.bind(element,path.join('.'),check,$as,$prefix);path.pop();}}}});window.ls.container.get('view').add({selector:'data-ls-bind',controller:function(element,expression,container,$prefix,$as){let echo=function(value,bind=true){if(element.tagName==='INPUT'||element.tagName==='SELECT'||element.tagName==='BUTTON'||element.tagName==='TEXTAREA'){let type=element.getAttribute('type');if('radio'===type){if(value.toString()===element.value){element.setAttribute('checked','checked');}
else{element.removeAttribute('checked');}
if(bind){element.addEventListener('change',()=>{for(let i=0;i<paths.length;i++){if(element.checked){value=element.value;}
container.path(paths[i],value,$as,$prefix);}});}
return;}
if('checkbox'===type){if(typeof value==='boolean'||value==='true'||value==='false'){if(value===true||value==='true'){element.setAttribute('checked','checked');element.checked=true;}
else{element.removeAttribute('checked');element.checked=false;}}
else{try{value=JSON.parse(value);element.checked=(Array.isArray(value)&&(value.indexOf(element.value)>-1));value=element.value;}
catch{return null;}}
if(bind){element.addEventListener('change',()=>{for(let i=0;i<paths.length;i++){let value=container.path(paths[i],undefined,$as,$prefix);let index=value.indexOf(element.value);if(element.checked&&index<0){value.push(element.value);}
if(!element.checked&&index>-1){value.splice(index,1);}
container.path(paths[i],value,$as,$prefix);}});}
return;}
if(element.value!==value){element.value=value;element.dispatchEvent(new Event('change'));}
if(bind){element.addEventListener('input',sync);element.addEventListener('change',sync);}}
else{if(element.textContent!=value){element.innerHTML=value;}}};let sync=((as,prefix)=>{return()=>{for(let i=0;i<paths.length;i++){if('{{'+paths[i]+'}}'!==syntax){continue;}
container.path(paths[i],element.value,as,prefix);}}})($as,$prefix);let syntax=element.getAttribute('data-ls-bind');let unsync=(!!element.getAttribute('data-unsync'))||false;let result=expression.parse(syntax,null,$as,$prefix);let paths=expression.getPaths();echo(result,!unsync);element.addEventListener('looped',function(){echo(expression.parse(syntax,null,$as,$prefix),false);});for(let i=0;i<paths.length;i++){let path=paths[i].split('.');while(path.length){container.bind(element,path.join('.'),()=>{echo(expression.parse(syntax,null,$as,$prefix),false);});path.pop();}}}});window.ls.container.get('view').add({selector:'data-ls-if',controller:function(element,expression,container,view,$as,$prefix){let result='';let syntax=element.getAttribute('data-ls-if')||'';let debug=element.getAttribute('data-debug')||false;let paths=[];let check=()=>{if(debug){console.info('debug-ls-if',expression.parse(syntax.replace(/(\r\n|\n|\r)/gm,' '),'undefined',$as,$prefix,true));}
try{result=(eval(expression.parse(syntax.replace(/(\r\n|\n|\r)/gm,' '),'undefined',$as,$prefix,true)));}
catch(error){throw new Error('Failed to evaluate expression "'+syntax+' (resulted with: "'+result+'")": '+error);}
if(debug){console.info('debug-ls-if result:',result);}
paths=expression.getPaths();let prv=element.$lsSkip;element.$lsSkip=!result;if(!result){element.style.visibility='hidden';element.style.display='none';}
else{element.style.removeProperty('display');element.style.removeProperty('visibility');}
if(prv===true&&element.$lsSkip===false){view.render(element)}};check();for(let i=0;i<paths.length;i++){let path=paths[i].split('.');while(path.length){container.bind(element,path.join('.'),check,$as,$prefix);path.pop();}}}});window.ls.container.get('view').add({selector:'data-ls-loop',template:false,repeat:false,nested:false,controller:function(element,view,container,window){let expr=element.getAttribute('data-ls-loop');let as=element.getAttribute('data-ls-as');let echo=function(){let array=container.path(expr);array=(!array)?[]:array;let watch=!!(array&&array.__proxy);while(element.hasChildNodes()){element.removeChild(element.lastChild);element.lastChild=null;}
if(array instanceof Array&&typeof array!=='object'){throw new Error('Reference value must be array or object. '+(typeof array)+' given');}
let children=[];let originalIndex=container.get('$index')||null;let originalPrefix=container.get('$prefix')||null;let originalAs=container.get('$as')||null;element.$lsSkip=true;element.style.visibility=(0===array.length)?'hidden':'visible';for(let prop in array){if(!array.hasOwnProperty(prop)){continue;}
children[prop]=template.cloneNode(true);element.appendChild(children[prop]);(index=>{let context=expr+'.'+index;container.set(as,container.path(context),true,watch);container.set('$index',index,true,false);container.set('$prefix',context,true,false);container.set('$as',as,true,false);view.render(children[prop]);})(prop);}
container.set('$index',originalIndex,true,false);container.set('$prefix',originalPrefix,true,false);container.set('$as',originalAs,true,false);element.dispatchEvent(new Event('looped'));};let template=(element.children.length===1)?element.children[0]:window.document.createElement('li');echo();container.bind(element,expr+'.length',echo);let path=(expr+'.length').split('.');while(path.length){container.bind(element,path.join('.'),echo);path.pop();}}});window.ls.container.get('view').add({selector:'data-ls-template',template:false,repeat:true,controller:function(element,view,http,expression,document){let template=expression.parse(element.getAttribute('data-ls-template'));let type=element.getAttribute('data-type')||'url';element.innerHTML='';if('script'===type){let inlineTemplate=document.getElementById(template);if(inlineTemplate&&inlineTemplate.innerHTML){element.innerHTML=inlineTemplate.innerHTML;element.dispatchEvent(new CustomEvent('template-loaded',{bubbles:true,cancelable:false}));}
else{element.innerHTML='<span style="color: red">Missing template "'+template+'"</span>';}
return;}
http.get(template).then(function(element){return function(data){element.innerHTML=data;view.render(element);element.dispatchEvent(new CustomEvent('template-loaded',{bubbles:true,cancelable:false}));}}(element),function(){throw new Error('Failed loading template');});}});window.ls.error=function(){return function(error){console.error('ERROR-APP',error);}};window.addEventListener('error',function(event){console.error('ERROR-EVENT:',event.error.message,event.error.stack);});document.addEventListener('logout',function(){window.location='/auth/signin';});document.addEventListener('http-get-401',function(){document.dispatchEvent(new CustomEvent('logout'));},true);(function(window){"use strict";window.ls.container.set('alerts',function(window){return{list:[],counter:0,add:function(message,time){var scope=this;message.id=this.counter++;scope.list.unshift(message);if(time>0){window.setTimeout(function(message){return function(){scope.remove(message.id)}}(message),time);}
return message.id;},remove:function(id){let scope=this;for(let index=0;index<scope.list.length;index++){let obj=scope.list[index];if(obj.id===parseInt(id)){if(typeof obj.callback==="function"){obj.callback();}
scope.list.splice(index,1);};}}};},true,true);})(window);(function(window){"use strict";window.ls.container.set('console',function(window){var sdk=new window.Appwrite();sdk.setEndpoint(APP_ENV.API).setProject('console').setLocale(APP_ENV.LOCALE);return sdk;},true);})(window);(function(window){"use strict";window.ls.container.set('date',function(){function format(format,timestamp){var jsdate,f
var txtWords=['Sun','Mon','Tues','Wednes','Thurs','Fri','Satur','January','February','March','April','May','June','July','August','September','October','November','December']
var formatChr=/\\?(.?)/gi
var formatChrCb=function(t,s){return f[t]?f[t]():s}
var _pad=function(n,c){n=String(n)
while(n.length<c){n='0'+n}
return n}
f={d:function(){return _pad(f.j(),2)},D:function(){return f.l().slice(0,3)},j:function(){return jsdate.getDate()},l:function(){return txtWords[f.w()]+'day'},N:function(){return f.w()||7},S:function(){var j=f.j()
var i=j%10
if(i<=3&&parseInt((j%100)/10,10)===1){i=0}
return['st','nd','rd'][i-1]||'th'},w:function(){return jsdate.getDay()},z:function(){var a=new Date(f.Y(),f.n()-1,f.j())
var b=new Date(f.Y(),0,1)
return Math.round((a-b)/864e5)},W:function(){var a=new Date(f.Y(),f.n()-1,f.j()-f.N()+3)
var b=new Date(a.getFullYear(),0,4)
return _pad(1+Math.round((a-b)/864e5/7),2)},F:function(){return txtWords[6+f.n()]},m:function(){return _pad(f.n(),2)},M:function(){return f.F().slice(0,3)},n:function(){return jsdate.getMonth()+1},t:function(){return(new Date(f.Y(),f.n(),0)).getDate()},L:function(){var j=f.Y()
return j%4===0&j%100!==0|j%400===0},o:function(){var n=f.n()
var W=f.W()
var Y=f.Y()
return Y+(n===12&&W<9?1:n===1&&W>9?-1:0)},Y:function(){return jsdate.getFullYear()},y:function(){return f.Y().toString().slice(-2)},a:function(){return jsdate.getHours()>11?'pm':'am'},A:function(){return f.a().toUpperCase()},B:function(){var H=jsdate.getUTCHours()*36e2
var i=jsdate.getUTCMinutes()*60
var s=jsdate.getUTCSeconds()
return _pad(Math.floor((H+i+s+36e2)/86.4)%1e3,3)},g:function(){return f.G()%12||12},G:function(){return jsdate.getHours()},h:function(){return _pad(f.g(),2)},H:function(){return _pad(f.G(),2)},i:function(){return _pad(jsdate.getMinutes(),2)},s:function(){return _pad(jsdate.getSeconds(),2)},u:function(){return _pad(jsdate.getMilliseconds()*1000,6)},e:function(){var msg='Not supported (see source code of date() for timezone on how to add support)'
throw new Error(msg)},I:function(){var a=new Date(f.Y(),0)
var c=Date.UTC(f.Y(),0)
var b=new Date(f.Y(),6)
var d=Date.UTC(f.Y(),6)
return((a-c)!==(b-d))?1:0},O:function(){var tzo=jsdate.getTimezoneOffset()
var a=Math.abs(tzo)
return(tzo>0?'-':'+')+_pad(Math.floor(a/60)*100+a%60,4)},P:function(){var O=f.O()
return(O.substr(0,3)+':'+O.substr(3,2))},T:function(){return'UTC'},Z:function(){return-jsdate.getTimezoneOffset()*60},c:function(){return'Y-m-d\\TH:i:sP'.replace(formatChr,formatChrCb)},r:function(){return'D, d M Y H:i:s O'.replace(formatChr,formatChrCb)},U:function(){return jsdate/1000|0}}
var _date=function(format,timestamp){jsdate=(timestamp===undefined?new Date():(timestamp instanceof Date)?new Date(timestamp):new Date(timestamp*1000))
return format.replace(formatChr,formatChrCb)}
return _date(format,timestamp)}
function strtotime(text,now){var parsed
var match
var today
var year
var date
var days
var ranges
var len
var times
var regex
var i
var fail=false
if(!text){return fail}
text=text.replace(/^\s+|\s+$/g,'').replace(/\s{2,}/g,' ').replace(/[\t\r\n]/g,'').toLowerCase()
var pattern=new RegExp(['^(\\d{1,4})','([\\-\\.\\/:])','(\\d{1,2})','([\\-\\.\\/:])','(\\d{1,4})','(?:\\s(\\d{1,2}):(\\d{2})?:?(\\d{2})?)?','(?:\\s([A-Z]+)?)?$'].join(''))
match=text.match(pattern)
if(match&&match[2]===match[4]){if(match[1]>1901){switch(match[2]){case'-':if(match[3]>12||match[5]>31){return fail}
return new Date(match[1],parseInt(match[3],10)-1,match[5],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case'.':return fail
case'/':if(match[3]>12||match[5]>31){return fail}
return new Date(match[1],parseInt(match[3],10)-1,match[5],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000}}else if(match[5]>1901){switch(match[2]){case'-':if(match[3]>12||match[1]>31){return fail}
return new Date(match[5],parseInt(match[3],10)-1,match[1],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case'.':if(match[3]>12||match[1]>31){return fail}
return new Date(match[5],parseInt(match[3],10)-1,match[1],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case'/':if(match[1]>12||match[3]>31){return fail}
return new Date(match[5],parseInt(match[1],10)-1,match[3],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000}}else{switch(match[2]){case'-':if(match[3]>12||match[5]>31||(match[1]<70&&match[1]>38)){return fail}
year=match[1]>=0&&match[1]<=38?+match[1]+2000:match[1]
return new Date(year,parseInt(match[3],10)-1,match[5],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case'.':if(match[5]>=70){if(match[3]>12||match[1]>31){return fail}
return new Date(match[5],parseInt(match[3],10)-1,match[1],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000}
if(match[5]<60&&!match[6]){if(match[1]>23||match[3]>59){return fail}
today=new Date()
return new Date(today.getFullYear(),today.getMonth(),today.getDate(),match[1]||0,match[3]||0,match[5]||0,match[9]||0)/1000}
return fail
case'/':if(match[1]>12||match[3]>31||(match[5]<70&&match[5]>38)){return fail}
year=match[5]>=0&&match[5]<=38?+match[5]+2000:match[5]
return new Date(year,parseInt(match[1],10)-1,match[3],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case':':if(match[1]>23||match[3]>59||match[5]>59){return fail}
today=new Date()
return new Date(today.getFullYear(),today.getMonth(),today.getDate(),match[1]||0,match[3]||0,match[5]||0)/1000}}}
if(text==='now'){return now===null||isNaN(now)?new Date().getTime()/1000|0:now|0}
if(!isNaN(parsed=Date.parse(text))){return parsed/1000|0}
pattern=new RegExp(['^([0-9]{4}-[0-9]{2}-[0-9]{2})','[ t]','([0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]+)?)','([\\+-][0-9]{2}(:[0-9]{2})?|z)'].join(''))
match=text.match(pattern)
if(match){if(match[4]==='z'){match[4]='Z'}else if(match[4].match(/^([+-][0-9]{2})$/)){match[4]=match[4]+':00'}
if(!isNaN(parsed=Date.parse(match[1]+'T'+match[2]+match[4]))){return parsed/1000|0}}
date=now?new Date(now*1000):new Date()
days={'sun':0,'mon':1,'tue':2,'wed':3,'thu':4,'fri':5,'sat':6}
ranges={'yea':'FullYear','mon':'Month','day':'Date','hou':'Hours','min':'Minutes','sec':'Seconds'}
function lastNext(type,range,modifier){var diff
var day=days[range]
if(typeof day!=='undefined'){diff=day-date.getDay()
if(diff===0){diff=7*modifier}else if(diff>0&&type==='last'){diff-=7}else if(diff<0&&type==='next'){diff+=7}
date.setDate(date.getDate()+diff)}}
function process(val){var splt=val.split(' ')
var type=splt[0]
var range=splt[1].substring(0,3)
var typeIsNumber=/\d+/.test(type)
var ago=splt[2]==='ago'
var num=(type==='last'?-1:1)*(ago?-1:1)
if(typeIsNumber){num*=parseInt(type,10)}
if(ranges.hasOwnProperty(range)&&!splt[1].match(/^mon(day|\.)?$/i)){return date['set'+ranges[range]](date['get'+ranges[range]]()+num)}
if(range==='wee'){return date.setDate(date.getDate()+(num*7))}
if(type==='next'||type==='last'){lastNext(type,range,num)}else if(!typeIsNumber){return false}
return true}
times='(years?|months?|weeks?|days?|hours?|minutes?|min|seconds?|sec'+'|sunday|sun\\.?|monday|mon\\.?|tuesday|tue\\.?|wednesday|wed\\.?'+'|thursday|thu\\.?|friday|fri\\.?|saturday|sat\\.?)'
regex='([+-]?\\d+\\s'+times+'|'+'(last|next)\\s'+times+')(\\sago)?'
match=text.match(new RegExp(regex,'gi'))
if(!match){return fail}
for(i=0,len=match.length;i<len;i++){if(!process(match[i])){return fail}}
return(date.getTime()/1000)}
return{format:format,strtotime:strtotime}}(),true);})(window);(function(window){"use strict";window.ls.container.set('env',function(){return APP_ENV;},true);})(window);(function(window){"use strict";window.ls.container.set('form',function(){function cast(value,to){switch(to){case'int':case'integer':value=parseInt(value);break;case'string':value=value.toString();break;case'json':value=(value)?JSON.parse(value):[];break;case'array':value=(value.constructor===Array)?value:[value];break;case'array-empty':value=[];break;case'bool':case'boolean':value=(value==='false')?false:value;value=!!value;break;}
return value;}
function toJson(element,json){json=json||{};let name=element.getAttribute('name');let type=element.getAttribute('type');let castTo=element.getAttribute('data-cast-to');let ref=json;if(name&&'FORM'!==element.tagName){if('FIELDSET'===element.tagName){if(castTo==='object'){if(json[name]===undefined){json[name]={};}
ref=json[name];}
else{if(!Array.isArray(json[name])){json[name]=[];}
json[name].push({});ref=json[name][json[name].length-1];}}
else if(undefined!==element.value){if('SELECT'===element.tagName&&element.children>0){json[name]=element.children[element.selectedIndex].value;}
else if('radio'===type){if(element.checked){json[name]=element.value;}}
else if('checkbox'===type){if(!Array.isArray(json[name])){json[name]=[];}
if(element.checked){json[name].push(element.value);}}
else if('file'===type){json[name]=element.files[0];}
else if(undefined!==element.value){if((json[name]!==undefined)&&(!Array.isArray(json[name]))){json[name]=[json[name]];}
if(Array.isArray(json[name])){json[name].push(element.value);}
else{json[name]=element.value;}}
json[name]=cast(json[name],castTo);}}
for(let i=0;i<element.children.length;i++){if(Array.isArray(ref)){ref.push({});toJson(element.children[i],ref[ref.length]);}
else{toJson(element.children[i],ref);}}
return json;}
return{'toJson':toJson}},true,false);})(window);(function(window){"use strict";window.ls.container.set('markdown',function(window){var md=window.markdownit();function renderEm(tokens,idx,opts,_,slf){var token=tokens[idx];if(token.markup==='__'){token.tag='u';}
return slf.renderToken(tokens,idx,opts);}
md.renderer.rules.strong_open=renderEm;md.renderer.rules.strong_close=renderEm;return md;},true);})(window);(function(window){"use strict";window.ls.container.set('sdk',function(window,router){var sdk=new window.Appwrite();sdk.setEndpoint(APP_ENV.API).setProject(router.params.project||'').setLocale(APP_ENV.LOCALE).setMode('admin');return sdk;},false);})(window);(function(window){"use strict";window.ls.container.set('timezone',function(){return{convert:function(unixTime){var timezoneMinutes=new Date().getTimezoneOffset();timezoneMinutes=(timezoneMinutes===0)?0:-timezoneMinutes;return parseInt(unixTime)+(timezoneMinutes*60);}};},true);})(window);window.ls.router.add('/auth/signin',{template:'/auth/signin?version='+APP_ENV.VERSION,scope:'home'}).add('/auth/signup',{template:'/auth/signup?version='+APP_ENV.VERSION,scope:'home'}).add('/auth/recovery',{template:'/auth/recovery?version='+APP_ENV.VERSION,scope:'home'}).add('/auth/recovery/reset',{template:'/auth/recovery/reset?version='+APP_ENV.VERSION,scope:'home'}).add('/auth/confirm',{template:'/auth/confirm?version='+APP_ENV.VERSION,scope:'home'}).add('/auth/join',{template:'/auth/join?version='+APP_ENV.VERSION,scope:'home'}).add('/console',{template:'/console?version='+APP_ENV.VERSION,scope:'console'}).add('/console/account',{template:'/console/account?version='+APP_ENV.VERSION,scope:'console'}).add('/console/account/:tab',{template:'/console/account?version='+APP_ENV.VERSION,scope:'console'}).add('/console/home',{template:'/console/home?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/home/:tab',{template:'/console/home?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/platforms/:platform',{template:function(window){return window.location.pathname+'?version='+APP_ENV.VERSION;},scope:'console',project:true}).add('/console/notifications',{template:'/console/notifications?version='+APP_ENV.VERSION,scope:'console'}).add('/console/settings',{template:'/console/settings?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/settings/:tab',{template:'/console/settings?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/webhooks',{template:'/console/webhooks?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/webhooks/:tab',{template:'/console/webhooks?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/keys',{template:'/console/keys?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/keys/:tab',{template:'/console/keys?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/tasks',{template:'/console/tasks?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/tasks/:tab',{template:'/console/tasks?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/database',{template:'/console/database?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/database/collection',{template:'/console/database/collection?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/storage',{template:'/console/storage?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/storage/:tab',{template:'/console/storage?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/users',{template:'/console/users?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/users/view',{template:'/console/users/view?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/users/view/:tab',{template:'/console/users/view?version='+APP_ENV.VERSION,scope:'console',project:true}).add('/console/users/:tab',{template:'/console/users?version='+APP_ENV.VERSION,scope:'console',project:true});window.ls.filter.add('gravatar',function($value,element){if(!$value){return'';}
let MD5=function(s){function L(k,d){return(k<<d)|(k>>>(32-d))}function K(G,k){let I,d,F,H,x;F=(G&2147483648);H=(k&2147483648);I=(G&1073741824);d=(k&1073741824);x=(G&1073741823)+(k&1073741823);if(I&d){return(x^2147483648^F^H)}if(I|d){if(x&1073741824){return(x^3221225472^F^H)}else{return(x^1073741824^F^H)}}else{return(x^F^H)}}function r(d,F,k){return(d&F)|((~d)&k)}function q(d,F,k){return(d&k)|(F&(~k))}function p(d,F,k){return(d^F^k)}function n(d,F,k){return(F^(d|(~k)))}function u(G,F,aa,Z,k,H,I){G=K(G,K(K(r(F,aa,Z),k),I));return K(L(G,H),F)}function f(G,F,aa,Z,k,H,I){G=K(G,K(K(q(F,aa,Z),k),I));return K(L(G,H),F)}function D(G,F,aa,Z,k,H,I){G=K(G,K(K(p(F,aa,Z),k),I));return K(L(G,H),F)}function t(G,F,aa,Z,k,H,I){G=K(G,K(K(n(F,aa,Z),k),I));return K(L(G,H),F)}function e(G){let Z;let F=G.length;let x=F+8;let k=(x-(x%64))/64;let I=(k+1)*16;let aa=Array(I-1);let d=0;let H=0;while(H<F){Z=(H-(H%4))/4;d=(H%4)*8;aa[Z]=(aa[Z]|(G.charCodeAt(H)<<d));H++}Z=(H-(H%4))/4;d=(H%4)*8;aa[Z]=aa[Z]|(128<<d);aa[I-2]=F<<3;aa[I-1]=F>>>29;return aa}function B(x){let k="",F="",G,d;for(d=0;d<=3;d++){G=(x>>>(d*8))&255;F="0"+G.toString(16);k=k+F.substr(F.length-2,2)}return k}function J(k){k=k.replace(/rn/g,"n");let d="";for(let F=0;F<k.length;F++){let x=k.charCodeAt(F);if(x<128){d+=String.fromCharCode(x)}else{if((x>127)&&(x<2048)){d+=String.fromCharCode((x>>6)|192);d+=String.fromCharCode((x&63)|128)}else{d+=String.fromCharCode((x>>12)|224);d+=String.fromCharCode(((x>>6)&63)|128);d+=String.fromCharCode((x&63)|128)}}}return d}let C=Array();let P,h,E,v,g,Y,X,W,V;let S=7,Q=12,N=17,M=22;let A=5,z=9,y=14,w=20;let o=4,m=11,l=16,j=23;let U=6,T=10,R=15,O=21;s=J(s);C=e(s);Y=1732584193;X=4023233417;W=2562383102;V=271733878;for(P=0;P<C.length;P+=16){h=Y;E=X;v=W;g=V;Y=u(Y,X,W,V,C[P+0],S,3614090360);V=u(V,Y,X,W,C[P+1],Q,3905402710);W=u(W,V,Y,X,C[P+2],N,606105819);X=u(X,W,V,Y,C[P+3],M,3250441966);Y=u(Y,X,W,V,C[P+4],S,4118548399);V=u(V,Y,X,W,C[P+5],Q,1200080426);W=u(W,V,Y,X,C[P+6],N,2821735955);X=u(X,W,V,Y,C[P+7],M,4249261313);Y=u(Y,X,W,V,C[P+8],S,1770035416);V=u(V,Y,X,W,C[P+9],Q,2336552879);W=u(W,V,Y,X,C[P+10],N,4294925233);X=u(X,W,V,Y,C[P+11],M,2304563134);Y=u(Y,X,W,V,C[P+12],S,1804603682);V=u(V,Y,X,W,C[P+13],Q,4254626195);W=u(W,V,Y,X,C[P+14],N,2792965006);X=u(X,W,V,Y,C[P+15],M,1236535329);Y=f(Y,X,W,V,C[P+1],A,4129170786);V=f(V,Y,X,W,C[P+6],z,3225465664);W=f(W,V,Y,X,C[P+11],y,643717713);X=f(X,W,V,Y,C[P+0],w,3921069994);Y=f(Y,X,W,V,C[P+5],A,3593408605);V=f(V,Y,X,W,C[P+10],z,38016083);W=f(W,V,Y,X,C[P+15],y,3634488961);X=f(X,W,V,Y,C[P+4],w,3889429448);Y=f(Y,X,W,V,C[P+9],A,568446438);V=f(V,Y,X,W,C[P+14],z,3275163606);W=f(W,V,Y,X,C[P+3],y,4107603335);X=f(X,W,V,Y,C[P+8],w,1163531501);Y=f(Y,X,W,V,C[P+13],A,2850285829);V=f(V,Y,X,W,C[P+2],z,4243563512);W=f(W,V,Y,X,C[P+7],y,1735328473);X=f(X,W,V,Y,C[P+12],w,2368359562);Y=D(Y,X,W,V,C[P+5],o,4294588738);V=D(V,Y,X,W,C[P+8],m,2272392833);W=D(W,V,Y,X,C[P+11],l,1839030562);X=D(X,W,V,Y,C[P+14],j,4259657740);Y=D(Y,X,W,V,C[P+1],o,2763975236);V=D(V,Y,X,W,C[P+4],m,1272893353);W=D(W,V,Y,X,C[P+7],l,4139469664);X=D(X,W,V,Y,C[P+10],j,3200236656);Y=D(Y,X,W,V,C[P+13],o,681279174);V=D(V,Y,X,W,C[P+0],m,3936430074);W=D(W,V,Y,X,C[P+3],l,3572445317);X=D(X,W,V,Y,C[P+6],j,76029189);Y=D(Y,X,W,V,C[P+9],o,3654602809);V=D(V,Y,X,W,C[P+12],m,3873151461);W=D(W,V,Y,X,C[P+15],l,530742520);X=D(X,W,V,Y,C[P+2],j,3299628645);Y=t(Y,X,W,V,C[P+0],U,4096336452);V=t(V,Y,X,W,C[P+7],T,1126891415);W=t(W,V,Y,X,C[P+14],R,2878612391);X=t(X,W,V,Y,C[P+5],O,4237533241);Y=t(Y,X,W,V,C[P+12],U,1700485571);V=t(V,Y,X,W,C[P+3],T,2399980690);W=t(W,V,Y,X,C[P+10],R,4293915773);X=t(X,W,V,Y,C[P+1],O,2240044497);Y=t(Y,X,W,V,C[P+8],U,1873313359);V=t(V,Y,X,W,C[P+15],T,4264355552);W=t(W,V,Y,X,C[P+6],R,2734768916);X=t(X,W,V,Y,C[P+13],O,1309151649);Y=t(Y,X,W,V,C[P+4],U,4149444226);V=t(V,Y,X,W,C[P+11],T,3174756917);W=t(W,V,Y,X,C[P+2],R,718787259);X=t(X,W,V,Y,C[P+9],O,3951481745);Y=K(Y,h);X=K(X,E);W=K(W,v);V=K(V,g)}let i=B(Y)+B(X)+B(W)+B(V);return i.toLowerCase()};let size=element.dataset['size']||80;let email=$value.email||$value||'';let name=$value.name||$value||'';let theme=name.split('').map(char=>char.charCodeAt(0)).reduce((a,b)=>a+b,0).toString();let themes=[{color:'27005e',background:'e1d2f6'},{color:'5e2700',background:'f3d9c6'},{color:'006128',background:'c9f3c6'},{color:'580061',background:'f2d1f5'},{color:'00365d',background:'c6e1f3'},{color:'00075c',background:'d2d5f6'},{color:'610038',background:'f5d1e6'},{color:'386100',background:'dcf1bd'},{color:'615800',background:'f1ecba'},{color:'610008',background:'f6d2d5'},];name=name.split(' ').map(function(n){if(!isNaN(parseFloat(n))&&isFinite(n)){return'';}
return n[0];}).join('')||'--';let background=themes[theme[theme.length-1]]['background'];let color=themes[theme[theme.length-1]]['color'];let def='https://ui-avatars.com/api/'+encodeURIComponent(name)+'/'+size+'/'+encodeURIComponent(background)+'/'+encodeURIComponent(color);return'//www.gravatar.com/avatar/'+MD5(email)+'.jpg?s='+size+'&d='+encodeURIComponent(def);}).add('selectedCollection',function($value,router){return($value===router.params.collectionId)?'selected':'';}).add('selectedDocument',function($value,router){return($value===router.params.documentId)?'selected':'';}).add('localeString',function($value){$value=parseInt($value);return(!Number.isNaN($value))?$value.toLocaleString():'';}).add('date',function($value,date){return date.format('Y-m-d',$value);}).add('date-time',function($value,date){return date.format('Y-m-d H:i',$value);}).add('date-text',function($value,date){return date.format('d M Y',$value);}).add('ms2hum',function($value){let temp=$value;const years=Math.floor(temp/31536000),days=Math.floor((temp%=31536000)/86400),hours=Math.floor((temp%=86400)/3600),minutes=Math.floor((temp%=3600)/60),seconds=temp%60;if(days||hours||seconds||minutes){return(years?years+"y ":"")+
(days?days+"d ":"")+
(hours?hours+"h ":"")+
(minutes?minutes+"m ":"")+
Number.parseFloat(seconds).toFixed(0)+"s";}
return"< 1s";}).add('markdown',function($value,markdown){return markdown.render($value);}).add('pageCurrent',function($value,env){return Math.ceil(parseInt($value||0)/env.PAGING_LIMIT)+1;}).add('pageTotal',function($value,env){let total=Math.ceil(parseInt($value||0)/env.PAGING_LIMIT);return(total)?total:1;}).add('humanFileSize',function($value){if(!$value){return 0;}
let thresh=1000;if(Math.abs($value)<thresh){return $value+' B';}
let units=['kB','MB','GB','TB','PB','EB','ZB','YB'];let u=-1;do{$value/=thresh;++u;}while(Math.abs($value)>=thresh&&u<units.length-1);return $value.toFixed(1)+'<span class="text-size-small unit">'+units[u]+'</span>';}).add('statsTotal',function($value){if(!$value){return 0;}
$value=abbreviate($value,1,false,false);return($value==='0')?'N/A':$value;});function abbreviate(number,maxPlaces,forcePlaces,forceLetter){number=Number(number);forceLetter=forceLetter||false;if(forceLetter!==false){return annotate(number,maxPlaces,forcePlaces,forceLetter);}
let abbr;if(number>=1e12){abbr='T';}
else if(number>=1e9){abbr='B';}
else if(number>=1e6){abbr='M';}
else if(number>=1e3){abbr='K';}
else{abbr='';}
return annotate(number,maxPlaces,forcePlaces,abbr);}
function annotate(number,maxPlaces,forcePlaces,abbr){let rounded=0;switch(abbr){case'T':rounded=number/1e12;break;case'B':rounded=number/1e9;break;case'M':rounded=number/1e6;break;case'K':rounded=number/1e3;break;case'':rounded=number;break}
if(maxPlaces!==false){let test=new RegExp('\\.\\d{'+(maxPlaces+1)+',}$')
if(test.test((''+rounded))){rounded=rounded.toFixed(maxPlaces)}}
if(forcePlaces!==false){rounded=Number(rounded).toFixed(forcePlaces)}
return rounded+abbr}
window.ls.container.get('view').add({selector:'data-acl',controller:function(element,document,router,alerts){document.body.classList.remove('console');document.body.classList.remove('home');document.body.classList.add(router.getCurrent().view.scope);if(!router.getCurrent().view.project){document.body.classList.add('hide-nav');document.body.classList.remove('show-nav');}
else{document.body.classList.add('show-nav');document.body.classList.remove('hide-nav');}
if('/console'===router.getCurrent().path){document.body.classList.add('index');}
else{document.body.classList.remove('index');}}}).add({selector:'data-cookie-policy',controller:function(element,alerts,cookie,env){if(!cookie.get('cookie-alert')){let text=element.dataset['cookiePolicy']||'';alerts.add({text:text,class:'cookie-alert',link:env.HOME+'/policy/cookies',callback:function(){cookie.set('cookie-alert','true',365*10);}},0);}}}).add({selector:'data-ls-ui-alerts',controller:function(element,window,view){window.document.addEventListener('alerted',function(){view.render(element);},true);}}).add({selector:'data-ls-ui-alerts-delete',controller:function(document,element,alerts,expression){let message=expression.parse(element.dataset['message']);let remove=function(){alerts.remove(message);};element.addEventListener('click',remove);}}).add({selector:'data-forms-headers',controller:function(element){let key=document.createElement('input');let value=document.createElement('input');let wrap=document.createElement('div');let cell1=document.createElement('div');let cell2=document.createElement('div');key.type='text';key.className='margin-bottom-no';key.placeholder='Key';value.type='text';value.className='margin-bottom-no';value.placeholder='Value';wrap.className='row thin margin-bottom-small';cell1.className='col span-6';cell2.className='col span-6';element.parentNode.insertBefore(wrap,element);cell1.appendChild(key);cell2.appendChild(value);wrap.appendChild(cell1);wrap.appendChild(cell2);key.addEventListener('input',function(){syncA();});value.addEventListener('input',function(){syncA();});element.addEventListener('change',function(){syncB();});let syncA=function(){element.value=key.value.toLowerCase()+':'+value.value.toLowerCase();};let syncB=function(){let split=element.value.toLowerCase().split(':');key.value=split[0]||'';value.value=split[1]||'';key.value=key.value.trim();value.value=value.value.trim();};syncB();}}).add({selector:'data-prism',controller:function(window,document,element,alerts){Prism.highlightElement(element);let copy=document.createElement('i');copy.className='icon-docs copy';copy.title='Copy to Clipboard';copy.addEventListener('click',function(){window.getSelection().removeAllRanges();let range=document.createRange();range.selectNode(element);window.getSelection().addRange(range);try{document.execCommand('copy');alerts.add({text:'Copied to clipboard',class:''},3000);}catch(err){alerts.add({text:"Failed to copy text ",class:'error'},3000);}
window.getSelection().removeAllRanges();});element.parentNode.parentNode.appendChild(copy);}}).add({selector:'data-code-example',controller:function(window,document,element,cookie){let prefix=element.dataset['codeExample']||'unknown';element.addEventListener('change',function(){select(element.value);});let select=function(value){for(let i=0;i<element.length;i++){document.body.classList.remove(prefix+'-'+element.options[i].value);}
document.body.classList.add(prefix+'-'+value);cookie.set('language-'+prefix,value,365);document.dispatchEvent(new CustomEvent('updated-language-'+prefix));};document.addEventListener('updated-language-'+prefix,function(){element.value=cookie.get('language-'+prefix);});let def=cookie.get('language-'+prefix)||element.options[0].value;select(def);element.value=def;}}).add({selector:'data-ls-ui-chart',controller:function(element,container,date,document){let child=document.createElement('canvas');child.width=500;child.height=175;let stats=container.get('usage');if(!stats||!stats['requests']||!stats['requests']['data']){return;}
let config={type:'line',data:{labels:[],datasets:[{label:'Requests',backgroundColor:'rgba(230, 248, 253, 0.3)',borderColor:'#29b5d9',borderWidth:2,data:[0,0,0,0,0,0,0],fill:true}]},options:{responsive:true,title:{display:false,text:'Stats'},legend:{display:false},tooltips:{mode:'index',intersect:false,caretPadding:0},hover:{mode:'nearest',intersect:true},scales:{xAxes:[{display:false}],yAxes:[{display:false,}]}}};for(let i=0;i<stats['requests']['data'].length;i++){config.data.datasets[0].data[i]=stats['requests']['data'][i].value;config.data.labels[i]=date.format('d F Y',stats['requests']['data'][i].date);}
let chart=container.get('chart');if(chart){}
element.innerHTML='';element.appendChild(child);container.set('chart',new Chart(child.getContext('2d'),config),true);element.dataset['canvas']=true;}});(function(window){"use strict";window.ls.view.add({selector:'data-service',controller:function(element,view,container,form,alerts,expression,window){let action=element.dataset['service'];let service=element.dataset['name']||action;let event=element.dataset['event'];let confirm=element.dataset['confirm']||'';let loading=element.dataset['loading']||'';let loaderId=null;let scope=element.dataset['scope']||'sdk';let debug=!!(element.dataset['debug']);let success=(element.dataset['success']||'');let failure=(element.dataset['failure']||'');success=(success&&success!='')?success.split(',').map(element=>element.trim()):[];failure=(failure&&failure!='')?failure.split(',').map(element=>element.trim()):[];if(debug)console.log('%c[service init]: '+action+' ('+service+')','color:red');let callbacks={'reset':function(){return function(){if('FORM'===element.tagName){return element.reset();}
throw new Error('This callback is only valid for forms');}},'alert':function(text,classname){return function(alerts){alerts.add({text:text,class:(classname||'success')},3000);}},'redirect':function(url){return function(router){router.change(url||'/');}},'reload':function(){return function(router){router.reload();}},'state':function(keys){let updateQueryString=function(key,value,url){var re=new RegExp("([?&])"+key+"=.*?(&|#|$)(.*)","gi"),hash;if(re.test(url)){if(typeof value!=='undefined'&&value!==null){return url.replace(re,'$1'+key+"="+value+'$2$3');}
else{hash=url.split('#');url=hash[0].replace(re,'$1$3').replace(/(&|\?)$/,'');if(typeof hash[1]!=='undefined'&&hash[1]!==null){url+='#'+hash[1];}
return url;}}
else{if(typeof value!=='undefined'&&value!==null){var separator=url.indexOf('?')!==-1?'&':'?';hash=url.split('#');url=hash[0]+separator+key+'='+value;if(typeof hash[1]!=='undefined'&&hash[1]!==null){url+='#'+hash[1];}
return url;}
else{return url;}}}
keys=keys.split(',').map(element=>element.trim());return function(serviceForm,router,window){let url=window.location.href;keys.map(node=>{node=node.split('=');let key=node[0]||'';let name=node[1]||key;let value=getValue(key,'param',serviceForm);url=updateQueryString(name,(value?value:null),url)});if(url!==window.location.href){window.history.pushState({},'',url);router.reset();}}},'trigger':function(events){return function(document){events=events.trim().split(',');for(let i=0;i<events.length;i++){if(''===events[i]){continue;}
if(debug)console.log('%c[event triggered]: '+events[i],'color:green');document.dispatchEvent(new CustomEvent(events[i]));}}}};let getParams=function getParams(func){const REGEX_COMMENTS=/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/mg;const REGEX_FUNCTION_PARAMS=/(?:\s*(?:function\s*[^(]*)?\s*)((?:[^'"]|(?:(?:(['"])(?:(?:.*?[^\\]\2)|\2))))*?)\s*(?=(?:=>)|{)/m;const REGEX_PARAMETERS_VALUES=/\s*([\w\\$]+)\s*(?:=\s*((?:(?:(['"])(?:\3|(?:.*?[^\\]\3)))((\s*\+\s*)(?:(?:(['"])(?:\6|(?:.*?[^\\]\6)))|(?:[\w$]*)))*)|.*?))?\s*(?:,|$)/gm;let functionAsString=func.toString();let params=[];let match;functionAsString=functionAsString.replace(REGEX_COMMENTS,'');functionAsString=functionAsString.match(REGEX_FUNCTION_PARAMS)[1];if(functionAsString.charAt(0)==='('){functionAsString=functionAsString.slice(1,-1);}
while(match=REGEX_PARAMETERS_VALUES.exec(functionAsString)){params.push(match[1]);}
return params;}
let getValue=function(key,prefix,data){let result=null;if(!key){return null;}
let attrKey=prefix+key.charAt(0).toUpperCase()+key.slice(1);if(element.dataset[attrKey]){result=expression.parse(element.dataset[attrKey]);if(element.dataset[attrKey+'CastTo']==='array'){result=result.split(',');}}
if(data[key]){result=data[key];}
if(!result){result='';}
return result;}
let resolve=function(target,prefix='param',data={}){if(!target){return function(){};}
let args=getParams(target);if(debug)console.log('%c[form data]: ','color:green',data);return target.apply(target,args.map(function(value){let result=getValue(value,prefix,data);if(debug)console.log('[param resolved]: ('+service+') '+value+'=',result);return result;}));};let exec=function(event){element.$lsSkip=true;element.classList.add('load-service-start');if(debug)console.log('%c[executed]: '+scope+'.'+action,'color:yellow',event,element,document.body.contains(element));if(!document.body.contains(element)){element=undefined;return false;}
if(event){event.preventDefault();}
if(confirm){if(window.confirm(confirm)!==true){return false;}}
if(loading){loaderId=alerts.add({text:loading,class:''},0);}
let method=container.path(scope+'.'+action);if(!method){throw new Error('Method "'+scope+'.'+action+'" not found');}
let formData=('FORM'===element.tagName)?form.toJson(element):{};let result=resolve(method,'param',formData);if(!result){return;}
result.then(function(data){if(loaderId!==null){alerts.remove(loaderId);}
if(!element){return;}
element.classList.add('load-service-end');container.set(service.replace('.','-'),data,true,true);container.set('serviceData',data,true,true);container.set('serviceForm',formData,true,true);if(debug)console.log('%cservice ready: "'+service.replace('.','-')+'"','color:green');if(debug)console.log('%cservice:','color:blue',container.get(service.replace('.','-')));for(let i=0;i<success.length;i++){container.resolve(resolve(callbacks[success[i]],'successParam'+success[i].charAt(0).toUpperCase()+success[i].slice(1),{}));}
container.set('serviceData',null,true,true);container.set('serviceForm',null,true,true);element.$lsSkip=false;view.render(element);},function(exception){if(loaderId!==null){alerts.remove(loaderId);}
if(!element){return;}
for(let i=0;i<failure.length;i++){container.resolve(resolve(callbacks[failure[i]],'failureParam'+failure[i].charAt(0).toUpperCase()+failure[i].slice(1),{}));}
element.$lsSkip=false;view.render(element);});};let events=event.trim().split(',');for(let y=0;y<events.length;y++){if(''===events[y]){continue;}
switch(events[y].trim()){case'load':exec();break;case'none':break;case'click':case'change':case'keypress':case'keydown':case'keyup':case'input':case'submit':element.addEventListener(events[y],exec);break;default:document.addEventListener(events[y],exec);}
if(debug)console.log('%cregistered: "'+events[y].trim()+'" ('+service+')','color:blue');}}});})(window);(function(window){"use strict";window.ls.container.get('view').add({'selector':'data-analytics-event','controller':function(element){var action=element.getAttribute('data-event-action')||'click';element.addEventListener(action,function(){var category=element.getAttribute('data-event-category')||'undefined';var label=element.getAttribute('data-event-label')||'undefined';if(!ga){console.error('Google Analytics ga object is not available');}
ga('send',{hitType:'event',eventCategory:category,eventAction:action,eventLabel:label});});}});})(window);(function(window){"use strict";window.ls.container.get('view').add({'selector':'data-analytics-pageview','controller':function(window,router){if(!ga){console.error('Google Analytics ga object is not available');}
var company=router.params['company']||null;if(!company){}
ga('set','page',window.location.pathname);ga('set','dimension1',company);ga('send','pageview');}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-clone',controller:function(element,document,view){var template=element.innerHTML.toString();var label=element.dataset['label']||'Add';var icon=element.dataset['icon']||null;var target=element.dataset['target']||null;var first=parseInt(element.dataset['first']||1);var button=document.createElement('button');button.type='button';button.innerText=' '+label+' ';button.classList.add('margin-end');button.classList.add('margin-bottom-small');button.classList.add('reverse');if(icon){var iconElement=document.createElement('i');iconElement.className=icon;button.insertBefore(iconElement,button.firstChild);}
if(target){target=document.getElementById(target);}
button.addEventListener('click',function(){var clone=document.createElement(element.tagName);if(element.name){clone.name=element.name;}
clone.innerHTML=template;clone.className=element.className;view.render(clone);if(target){target.appendChild(clone);}
else{button.parentNode.insertBefore(clone,button);}
clone.querySelector('input').focus();Array.prototype.slice.call(clone.querySelectorAll('[data-remove]')).map(function(obj){obj.addEventListener('click',function(){clone.parentNode.removeChild(clone);obj.scrollIntoView({behavior:'smooth'});});});Array.prototype.slice.call(clone.querySelectorAll('[data-up]')).map(function(obj){obj.addEventListener('click',function(){if(clone.previousElementSibling){clone.parentNode.insertBefore(clone,clone.previousElementSibling);obj.scrollIntoView({behavior:'smooth'});}});});Array.prototype.slice.call(clone.querySelectorAll('[data-down]')).map(function(obj){obj.addEventListener('click',function(){if(clone.nextElementSibling){clone.parentNode.insertBefore(clone.nextElementSibling,clone);obj.scrollIntoView({behavior:'smooth'});}});});});element.parentNode.insertBefore(button,element.nextSibling);element.parentNode.removeChild(element);if(first){button.click();}}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-code',controller:function(element,alerts){let lang=element.dataset['formsCode']||'json';let div=document.createElement('div');let pre=document.createElement('pre');let code=document.createElement('code');let copy=document.createElement('i');div.appendChild(pre);div.appendChild(copy);pre.appendChild(code);element.parentNode.appendChild(div);div.className='ide';pre.className='line-numbers';code.className='prism language-'+lang;copy.className='icon-docs copy';copy.title='Copy to Clipboard';copy.addEventListener('click',function(){window.getSelection().removeAllRanges();let range=document.createRange();range.selectNode(element);window.getSelection().addRange(range);try{document.execCommand('copy');alerts.add({text:'Copied to clipboard',class:''},3000);}catch(err){alerts.add({text:"Failed to copy text ",class:'error'},3000);}
window.getSelection().removeAllRanges();});let check=function(){if(!element.value){return;}
let value=null;try{value=JSON.stringify(JSON.parse(element.value),null,4);}
catch(error){value=element.value;}
code.innerHTML=value;Prism.highlightElement(code);div.scrollTop=0;}
element.addEventListener('change',check);check();}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-color',controller:function(element){var preview=document.createElement('div');var picker=document.createElement('input');picker.type='color';preview.className='color-preview';preview.appendChild(picker);picker.addEventListener('change',syncA);picker.addEventListener('input',syncA);element.addEventListener('input',update);element.addEventListener('change',update);function update(){if(element.validity.valid){preview.style.background=element.value;syncB();}}
function syncA(){element.value=picker.value;update();}
function syncB(){picker.value=element.value;}
element.parentNode.insertBefore(preview,element);update();syncB();}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-copy',controller:function(element,alerts,document,window){var button=window.document.createElement('i');button.type='button';button.className='icon-docs note copy';button.style.cursor='pointer';element.parentNode.insertBefore(button,element.nextSibling);var copy=function(event){window.getSelection().removeAllRanges();var range=document.createRange();range.selectNode(element);window.getSelection().addRange(range);try{document.execCommand('copy');alerts.add({text:'Copied to clipboard',class:''},3000);}catch(err){alerts.add({text:"Failed to copy text ",class:'error'},3000);}
window.getSelection().removeAllRanges();};button.addEventListener('click',copy);}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-forms-filter',controller:function(document,container,expression,element,form,di){let name=element.dataset['formsFilter']||'';let events=element.dataset['event']||'';let serialize=function(obj,prefix){let str=[],p;for(p in obj){if(obj.hasOwnProperty(p)){let k=prefix?prefix+"["+p+"]":p,v=obj[p];if(v===''){continue;}
str.push((v!==null&&typeof v==="object")?serialize(v,k):encodeURIComponent(k)+"="+encodeURIComponent(v));}}
return str.join("&");};let parse=function(filter){if(filter===''){return null;}
let operatorsMap=["!=",">=","<=","=",">","<"];let operator=null;for(let key=0;key<operatorsMap.length;key++){if(filter.indexOf(operatorsMap[key])>-1){operator=operatorsMap[key];}}
if(operator===null){throw new Error("Invalid operator");}
filter=filter.split(operator);if(filter.length!==2){throw new Error("Invalid filter expression");}
return{"key":filter[0],"value":filter[1],"operator":operator};};let flatten=function(params){let list={};for(let key in params){if(params.hasOwnProperty(key)){if(key!=='filters'){list[key]=params[key];}
else{for(let i=0;i<params[key].length;i++){let filter=parse(params[key][i]);if(null===filter){continue;}
list['filters-'+filter.key]=params[key][i];}}}}
return list;};let apply=function(params){let cached=container.get(name);cached=(cached)?cached.params:[];params=Object.assign(cached,params);container.set(name,{name:name,params:params,query:serialize(params),forward:parseInt(params.offset)+parseInt(params.limit),backward:parseInt(params.offset)-parseInt(params.limit),keys:flatten(params)},true,name);document.dispatchEvent(new CustomEvent(name+'-changed',{bubbles:false,cancelable:true}));};switch(element.tagName){case'INPUT':break;case'TEXTAREA':break;case'BUTTON':element.addEventListener('click',function(){apply(JSON.parse(expression.parse(element.dataset['params']||'{}')));});break;case'FORM':element.addEventListener('input',function(){apply(form.toJson(element));});element.addEventListener('change',function(){apply(form.toJson(element));});element.addEventListener('reset',function(){setTimeout(function(){apply(form.toJson(element));},0);});events=events.trim().split(',');for(let y=0;y<events.length;y++){if(events[y]==='init'){element.addEventListener('rendered',function(){apply(form.toJson(element));},{once:true});}
else{}
element.setAttribute('data-event','none');}
break;default:break;}}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-parent-down',controller:function(element){var target=element.dataset['target']||null;target=(target)?element.closest(target):element.parentNode;element.addEventListener('click',function(){if(target.nextElementSibling){target.parentNode.insertBefore(target.nextElementSibling,target);element.scrollIntoView({behavior:'smooth'});}});}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-parent-remove',controller:function(element){var target=element.dataset['target']||null;target=(target)?element.closest(target):element.parentNode;element.addEventListener('click',function(){target.parentNode.removeChild(target);element.scrollIntoView({behavior:'smooth'});});}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-parent-up',controller:function(element){var target=element.dataset['target']||null;target=(target)?element.closest(target):element.parentNode;element.addEventListener('click',function(){if(target.previousElementSibling){target.parentNode.insertBefore(target,target.previousElementSibling);element.scrollIntoView({behavior:'smooth'});}});}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-password-meter',controller:function(element,window){var calc=function(password){var score=0;if(!password)
return score;var letters=new window.Object();for(var i=0;i<password.length;i++){letters[password[i]]=(letters[password[i]]||0)+1;score+=5.0/letters[password[i]];}
var variations={digits:/\d/.test(password),lower:/[a-z]/.test(password),upper:/[A-Z]/.test(password),nonWords:/\W/.test(password)};var variationCount=0;for(var check in variations){if(variations.hasOwnProperty(check)){variationCount+=(variations[check]===true)?1:0;}}
score+=(variationCount-1)*10;return parseInt(score);};var callback=function(){var score=calc(this.value);if(''===this.value)
return meter.className='password-meter';if(score>60)
return meter.className='password-meter strong';if(score>30)
return meter.className='password-meter medium';if(score>=0)
return meter.className='password-meter weak';};var meter=window.document.createElement('div');meter.className='password-meter';element.parentNode.insertBefore(meter,element.nextSibling);element.addEventListener('change',callback);element.addEventListener('keypress',callback);element.addEventListener('keyup',callback);element.addEventListener('keydown',callback);}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-pell',controller:function(element,window,document,markdown){var div=document.createElement('div');element.className='pell hide';div.className='input pell';element.parentNode.insertBefore(div,element);element.tabIndex=-1;var turndownService=new TurndownService();turndownService.addRule('underline',{filter:['u'],replacement:function(content){return'__'+content+'__'}});var editor=window.pell.init({element:div,onChange:function onChange(html){element.value=turndownService.turndown(html);},defaultParagraphSeparator:'p',actions:[{name:'bold',icon:'<i class="icon-bold"></i>'},{name:'underline',icon:'<i class="icon-underline"></i>'},{name:'italic',icon:'<i class="icon-italic"></i>'},{name:'olist',icon:'<i class="icon-list-numbered"></i>'},{name:'ulist',icon:'<i class="icon-list-bullet"></i>'},{name:'link',icon:'<i class="icon-link"></i>'}]});element.addEventListener('change',function(){editor.content.innerHTML=markdown.render(element.value);});editor.content.setAttribute('placeholder',element.placeholder);editor.content.innerHTML=markdown.render(element.value);editor.content.tabIndex=0;editor.content.onkeydown=function preventTab(event){if(event.which===9){event.preventDefault();if(document.activeElement){var focussable=Array.prototype.filter.call(document.querySelectorAll('a:not([disabled]), button:not([disabled]), select:not([disabled]), input[type=text]:not([disabled]), input[type=checkbox]:not([disabled]), [tabindex]:not([disabled]):not([tabindex="-1"])'),function(element){return element.offsetWidth>0||element.offsetHeight>0||element===document.activeElement});var index=focussable.indexOf(document.activeElement);if(index>-1){if(event.shiftKey){var prevElement=focussable[index-1]||focussable[focussable.length-1];prevElement.focus();}
else{var nextElement=focussable[index+1]||focussable[0];nextElement.focus();}}}}};var clean=function(e){e.stopPropagation();e.preventDefault();var clipboardData=e.clipboardData||window.clipboardData;window.pell.exec('insertText',clipboardData.getData('Text'));return true;};div.addEventListener('paste',clean);div.addEventListener('drop',clean);}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-remove',controller:function(element){Array.prototype.slice.call(element.querySelectorAll('[data-remove]')).map(function(obj){obj.addEventListener('click',function(){element.parentNode.removeChild(element);});});}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-switch',controller:function(element){let input=window.document.createElement('input');input.type='checkbox';input.className='switch';let syncA=function(){element.value=(input.checked)?'on':'off';};let syncB=function(){input.checked=(element.value==='on');};input.addEventListener('input',syncA);input.addEventListener('change',syncA);element.addEventListener('input',syncB);element.addEventListener('change',syncB);syncA();element.parentNode.insertBefore(input,element);}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-tags',controller:function(element){let array=[];let tags=window.document.createElement('div');let preview=window.document.createElement('ul');let add=window.document.createElement('input');tags.className='tags';preview.className='tags-list';add.type='text';add.className='add';tags.addEventListener('click',function(){add.focus();});add.addEventListener('keydown',function(event){if(((event.key==="Enter"||event.key===" "))&&(add.value.length>0)){array.push(add.value);add.value='';element.value=JSON.stringify(array);check();event.preventDefault();}
if(((event.key==="Backspace"||event.key==="Delete"))&&(add.value==='')){array.splice(-1,1)
element.value=JSON.stringify(array);check();}
return false;});let check=function(){try{array=JSON.parse(element.value)||[];}
catch(error){array=[];}
if(!Array.isArray(array)){array=[];}
preview.innerHTML='';for(let index=0;index<array.length;index++){let value=array[index];let tag=window.document.createElement('li');tag.className='tag';tag.textContent=value;tag.addEventListener('click',function(){array.splice(index,1);element.value=JSON.stringify(array);check();});preview.appendChild(tag);}
if(element.required&&array.length===0){add.setCustomValidity('Please add permissions');}
else{add.setCustomValidity('');}};tags.appendChild(preview);tags.appendChild(add);element.parentNode.insertBefore(tags,element);element.addEventListener('change',check);check();}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-text-count',controller:function(element){var counter=document.createElement('span');counter.className='counter';element.parentNode.insertBefore(counter,element.nextSibling);var count=function(){if(0<=element.maxLength){counter.innerText=(element.maxLength-element.value.length).toString()+' / '+element.maxLength;}
else{var words=(element.value!=='')?element.value.trim().split(' ').length:0;counter.innerText=words+' words and '+element.value.length.toString()+' chars';}};element.addEventListener('keyup',count);element.addEventListener('change',count);element.addEventListener('cut',count);element.addEventListener('paste',count);element.addEventListener('drop',count);count();}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-text-direction',controller:function(element){var rtlStock='^ا^ب^ت^ث^ج^ح^خ^د^ذ^ر^ز^س^ش^ص^ض^ط^ظ^ع^غ^ف^ق^ك^ل^م^ن^ه^و^ي^א^ב^ג^ד^ה^ו^ז^ח^ט^י^כ^ך^ל^מ^ם^נ^ן^ס^ע^פ^ף^צ^ץ^ק^ר^ש^ת^';var special=['\n',' ','״','"','_','\'','!','@','#','$','^','&','%','*','(',')','+','=','-','[',']','\\','/','{','}','|',':','<','>','?',',','.','0','1','2','3','4','5','6','7','8','9'];var setDirection=function(){var value=(element.value[0])?element.value:'';var direction='ltr';var align='left';for(var i=0;i<value.length;i++){if(-1===special.indexOf(value[i])){var firstChar=value[i];break;}}
if(-1<rtlStock.indexOf('^'+firstChar+'^')){direction='rtl';align='right';}
element.style.direction=direction;element.style.textAlign=align;};element.addEventListener('keyup',setDirection);element.addEventListener('change',setDirection);element.addEventListener('cut',setDirection);element.addEventListener('paste',setDirection);element.addEventListener('drop',setDirection);setDirection();}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-text-resize',controller:function(element,window){function resize(){var scrollLeft=window.pageXOffset||(window.document.documentElement||window.document.body.parentNode||window.document.body).scrollLeft;var scrollTop=window.pageYOffset||(window.document.documentElement||window.document.body.parentNode||window.document.body).scrollTop;var offset=element.offsetHeight-element.clientHeight;element.style.height='auto';element.style.height=element.scrollHeight+offset+'px';window.scrollTo(scrollLeft,scrollTop);}
element.addEventListener('keyup',resize);element.addEventListener('change',resize);element.addEventListener('cut',resize);element.addEventListener('paste',resize);element.addEventListener('drop',resize);window.addEventListener('resize',resize);resize();}});})(window);(function(window){"use strict";window.ls.container.get('view').add({selector:'data-forms-upload',controller:function(element,container,alerts,expression,env){var scope=element.dataset['scope'];var labelButton=element.dataset['labelButton']||'Upload';var labelLoading=element.dataset['labelLoading']||'Uploading...';var previewWidth=element.dataset['previewWidth']||200;var previewHeight=element.dataset['previewHeight']||200;var accept=element.dataset['accept']||'';var required=(element.dataset['required']||false);var multiple=(element.dataset['multiple']||false);var className=(element.dataset['class']||'upload');var max=parseInt((element.dataset['max']||4));var sdk=(scope==='sdk')?container.get('sdk'):container.get('console');var output=(element.value)?((multiple)?JSON.parse(element.value):[element.value]):[];var total=0;var wrapper=document.createElement('div');var input=document.createElement('input');var upload=document.createElement('div');var preview=document.createElement('ul');var progress=document.createElement('div');var count=document.createElement('div');wrapper.className=className;input.type='file';input.accept=accept;input.required=required;input.multiple=multiple;input.tabIndex=-1;count.className='count';upload.className='button reverse margin-bottom';upload.innerHTML='<i class="icon icon-upload"></i> '+labelButton;upload.tabIndex=0;preview.className='preview';progress.className='progress';progress.style.width='0%';progress.style.display='none';var humanFileSize=function(bytes,si){var thresh=si?1000:1024;if(Math.abs(bytes)<thresh){return bytes+' B';}
var units=si?['KB','MB','GB','TB','PB','EB','ZB','YB']:['KiB','MiB','GiB','TiB','PiB','EiB','ZiB','YiB'];var u=-1;do{bytes/=thresh;++u;}while(Math.abs(bytes)>=thresh&&u<units.length-1);return bytes.toFixed(1)+' '+units[u];};var onComplete=function(message){alerts.remove(message);input.disabled=false;upload.classList.remove('disabled');progress.style.width='0%';progress.style.display='none';};var render=function(files){if(!Array.isArray(files)){files=[files];}
preview.innerHTML='';count.innerHTML='0 / '+max;files.map(function(obj){var file=document.createElement('li');var image=document.createElement('img');image.src=image.src=env.API+'/storage/files/'+obj+'/preview?width='+previewWidth+'&height='+previewHeight;file.className='file avatar';file.tabIndex=0;file.appendChild(image);count.innerHTML=files.length+' / '+max;preview.appendChild(file);if((files.length>=max)){input.disabled=true;upload.classList.add('disabled');}
else{input.disabled=false;upload.classList.remove('disabled');}
var remove=(function(obj){return function(event){output=(Array.isArray(output))?output.filter(function(e){return e!==obj}):[];render(output);}})(obj);file.addEventListener('click',remove);file.addEventListener('keypress',remove);element.value=(multiple)?JSON.stringify(output):output[0];});};input.addEventListener('change',function(){var message=alerts.add({text:labelLoading,class:''},0);var files=input.files;var read=JSON.parse(expression.parse(element.dataset['read']||'[]'));var write=JSON.parse(expression.parse(element.dataset['write']||'[]'));if(!multiple){output=[];}
sdk.storage.createFile(files[0],read,write,1).then(function(response){response.map(function(obj){if(!Array.isArray(output)){throw new Error('Can\'t append new file to non array value');}
output[output.length]=obj['$uid'];});onComplete(message);render(output);},function(error){alerts.add({text:'An error occurred!',class:''},3000);onComplete(message);});input.disabled=true;});element.addEventListener('change',function(){if(!element.value){return;}
output=(multiple)?JSON.parse(element.value):[element.value];render(output);});upload.addEventListener('keypress',function(){input.click();});element.parentNode.insertBefore(wrapper,element);wrapper.appendChild(preview);wrapper.appendChild(progress);wrapper.appendChild(upload);if(multiple){wrapper.appendChild(count);}
upload.appendChild(input);render(output);}});})(window);(function(window){window.ls.container.get('view').add({'selector':'data-page-title','repeat':true,'controller':function(element,document,expression){document.title=expression.parse(element.getAttribute('data-page-title'))||document.title;}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-setup',controller:function(element,console,form){element.addEventListener('submit',function(event){event.preventDefault();let formData=form.toJson(element);formData['name']=formData['name']||(element.dataset['defaultName']||'');console.teams.createTeam(formData['name']||'').then(function(data){let team=data['$uid'];formData=JSON.parse(JSON.stringify(formData).replace(new RegExp('{{teamId}}','g'),team));console.projects.createProject(formData['name'],team).then(function(project){window.location.href='/console?project='+project['$uid'];},function(){throw new Error('Failed to setup project');});},function(){throw new Error('Setup failed creating project team');});})}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-switch',controller:function(element,router,document){let check=function(c){if(!element.value){return;}
if(element.value===router.params.project){return;}
return router.change('/console/home?project='+element.value);};element.addEventListener('change',function(){check();});}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-paging-back',controller:function(element,container,expression,env){let paths=[];let limit=env.PAGING_LIMIT;let check=function(){let offset=parseInt(expression.parse(element.dataset['offset'])||'0');paths=paths.concat(expression.getPaths());if((offset-limit)<0){element.disabled=true;}
else{element.disabled=false;element.value=offset-limit;}};check();for(let i=0;i<paths.length;i++){let path=paths[i].split('.');while(path.length){container.bind(element,path.join('.'),check);path.pop();}}}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-paging-next',controller:function(element,container,expression,env){let paths=[];let limit=env.PAGING_LIMIT;let check=function(){let offset=parseInt(expression.parse(element.dataset['offset'])||'0');paths=paths.concat(expression.getPaths());let sum=parseInt(expression.parse(element.dataset['sum'])||'0');paths=paths.concat(expression.getPaths());if((offset+limit)>=sum){element.disabled=true;}
else{element.disabled=false;element.value=offset+limit;}};check();for(let i=0;i<paths.length;i++){let path=paths[i].split('.');while(path.length){container.bind(element,path.join('.'),check);path.pop();}}}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-ui-highlight',controller:function(element,expression,document){let check=function(){let links=element.getElementsByTagName('a');let selected=null;let list=[];for(let i=0;i<links.length;i++){links[i].href=links[i].href||expression.parse(links[i].dataset['lsHref']||'');list.push(links[i]);}
list.sort(function(a,b){return a.pathname.length-b.pathname.length;});for(let i=0;i<list.length;i++){if(list[i].pathname===window.location.pathname.substring(0,list[i].pathname.length)){list[i].classList.add('selected');if(selected!==null){list[selected].classList.remove('selected');}
selected=i;}
else{list[i].classList.remove('selected');}}};document.addEventListener('state-changed',check);check();}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-ui-modal',controller:function(document,element,expression){let name=element.dataset['name']||null;let buttonText=expression.parse(element.dataset['buttonText']||'');let buttonClass=element.dataset['buttonClass']||'button-class';let buttonIcon=element.dataset['buttonIcon']||null;let buttonEvent=element.dataset['buttonEvent']||'';let buttonAlias=element.dataset['buttonAlias']||'';let buttonElements=(!buttonAlias)?[document.createElement('button')]:document.querySelectorAll(buttonAlias);let openEvent=element.dataset['openEvent']||null;let background=document.getElementById('modal-bg');if(!background){background=document.createElement('div');background.id='modal-bg';background.className='modal-bg';document.body.appendChild(background);background.addEventListener('click',function(){document.dispatchEvent(new CustomEvent('modal-close',{bubbles:false,cancelable:true}));});}
if(!buttonAlias){buttonElements.forEach((button)=>{button.innerText=buttonText;button.className=buttonClass;button.type='button';if(buttonIcon){let iconElement=document.createElement('i');iconElement.className=buttonIcon;button.insertBefore(iconElement,button.firstChild);}});}
if(buttonEvent){buttonElements.forEach((button)=>{button.addEventListener('click',function(){document.dispatchEvent(new CustomEvent(buttonEvent,{bubbles:false,cancelable:true}));});});}
element.classList.add('modal');if(!buttonAlias){buttonElements.forEach((button)=>{element.parentNode.insertBefore(button,element);});}
let open=function(){document.documentElement.classList.add('modal-open');document.dispatchEvent(new CustomEvent('modal-open',{bubbles:false,cancelable:true}));element.classList.add('open');element.classList.remove('close');};let close=function(){document.documentElement.classList.remove('modal-open');element.classList.add('close');element.classList.remove('open');};if(name){document.querySelectorAll("[data-ui-modal-ref='"+name+"']").forEach(function(elem){elem.addEventListener('click',open);});}
if(openEvent){document.addEventListener(openEvent,open);}
buttonElements.forEach((button)=>{button.addEventListener('click',open);});document.addEventListener('keydown',function(event){if(event.which===27){close();}});element.addEventListener('blur',close);let closeButtons=element.querySelectorAll('[data-ui-modal-close]');for(let i=0;i<closeButtons.length;i++){closeButtons[i].addEventListener('click',close);}
document.addEventListener('modal-close',close);element.addEventListener('submit',close);}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-ls-ui-open',controller:function(element,window){let def=(element.classList.contains('open'))?'open':'close';let buttonClass=element.dataset['buttonClass']||'ls-ui-open';let buttonText=element.dataset['buttonText']||'';let buttonIcon=element.dataset['buttonIcon']||'';let buttonSelector=element.dataset['buttonSelector']||'';let hover=element.hasAttribute('data-hover');let blur=element.hasAttribute('data-blur');let button=window.document.createElement('button');let isTouch=function(){return'ontouchstart'in window||navigator.maxTouchPoints;};button.innerText=buttonText;button.className=buttonClass;button.tabIndex=1;button.type='button';if(buttonIcon){let icon=window.document.createElement('i');icon.className=buttonIcon;button.insertBefore(icon,button.firstChild);}
if(def==='close'){element.classList.add('close');element.classList.remove('open');}
else{element.classList.add('open');element.classList.remove('close');}
button.addEventListener('click',function(){element.classList.toggle('open');element.classList.toggle('close');});if(hover&&!isTouch()){element.addEventListener('mouseover',function(){element.classList.add('open');element.classList.remove('close');});element.addEventListener('mouseout',function(){element.classList.add('close');element.classList.remove('open');});}
let close=function(){element.classList.add('close');element.classList.remove('open');};let closeDelay=function(){window.setTimeout(function(){close();},150);};let findParent=function(tagName,el){if((el.nodeName||el.tagName).toLowerCase()===tagName.toLowerCase()){return el;}
while(el=el.parentNode){if((el.nodeName||el.tagName).toLowerCase()===tagName.toLowerCase()){return el;}}
return null;};if(blur){button.addEventListener('blur',closeDelay);}
if(buttonSelector){let buttonElements=element.querySelectorAll(buttonSelector);buttonElements.forEach((node)=>{node.addEventListener('click',function(){element.classList.toggle('open');element.classList.toggle('close');});if(blur){node.addEventListener('blur',closeDelay);}});}
element.addEventListener('click',function(event){let target=findParent('a',event.target);if(!target){return false;}
if(!target.href){return false;}
closeDelay();});element.insertBefore(button,element.firstChild);}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-ui-phases',controller:function(element,window,document,expression,router){var tabs=document.createElement('ul');var container=document.createElement('div');var titles=Array.prototype.slice.call(element.getElementsByTagName('h2'));var next=Array.prototype.slice.call(element.querySelectorAll('[data-next]'));var previous=Array.prototype.slice.call(element.querySelectorAll('[data-previous]'));var position=0;var init=false;for(var i=0;i<element.children.length;i++){var tabState=expression.parse(element.children[i].dataset['state']||'');if(tabState===(window.location.pathname+window.location.search).substring(0,tabState.length)){position=i;}}
var setTab=function(index){var tabState=expression.parse(element.children[index].dataset['state']||'');var url='';if((tabState!=='')&&(tabState!==window.location.pathname+window.location.search)){var parser=document.createElement('a');parser.href=tabState;url=(!init)?parser.pathname+window.location.search:tabState;if(position!=index){window.history.pushState({},'',url);router.reset();}}
element.children[position].classList.remove('selected');element.children[index].classList.add('selected');tabs.children[position].classList.remove('selected');tabs.children[index].classList.add('selected');position=index;document.dispatchEvent(new CustomEvent('tab-changed'));init=true;};tabs.classList.add('tabs');container.classList.add('container');container.classList.add('close');container.dataset['lsUiOpen']='';container.dataset['buttonClass']='icon icon-down-dir';titles.map(function(obj,i){var title=document.createElement('li');title.innerHTML=obj.innerHTML;title.className=obj.className;title.tabIndex=0;tabs.appendChild(title);title.addEventListener('click',function(){setTab(i);});title.addEventListener('keyup',function(){if(event.which===13){setTab(i);}});});next.map(function(obj){obj.addEventListener('click',function(){setTab(position+1)});});previous.map(function(obj){obj.addEventListener('click',function(){setTab(position-1)});});setTab(position);container.appendChild(tabs);element.parentNode.insertBefore(container,element);}});})(window);(function(window){window.ls.container.get('view').add({selector:'data-ls-ui-trigger',controller:function(element,document){let trigger=element.dataset['lsUiTrigger'];let event=element.dataset['event']||'click';element.addEventListener(event,function(){document.dispatchEvent(new CustomEvent(trigger));});}});})(window);