(function(window){window.Appwrite=function(){let config={endpoint:'https://appwrite.test/v1',project:'',key:'',locale:'',mode:'',};let setEndpoint=function(endpoint){config.endpoint=endpoint;return this};let setProject=function(value){http.addGlobalHeader('X-Appwrite-Project',value);config.project=value;return this};let setKey=function(value){http.addGlobalHeader('X-Appwrite-Key',value);config.key=value;return this};let setLocale=function(value){http.addGlobalHeader('X-Appwrite-Locale',value);config.locale=value;return this};let setMode=function(value){http.addGlobalHeader('X-Appwrite-Mode',value);config.mode=value;return this};let http=function(document){let globalParams=[],globalHeaders=[];let addParam=function(url,param,value){let a=document.createElement('a'),regex=/(?:\?|&amp;|&)+([^=]+)(?:=([^&]*))*/g;let match,str=[];a.href=url;param=encodeURIComponent(param);while(match=regex.exec(a.search))if(param!==match[1])str.push(match[1]+(match[2]?"="+match[2]:""));str.push(param+(value?"="+encodeURIComponent(value):""));a.search=str.join("&");return a.href};let buildQuery=function(params){let str=[];for(let p in params){if(Array.isArray(params[p])){for(let index=0;index<params[p].length;index++){let param=params[p][index];str.push(encodeURIComponent(p+'[]')+"="+encodeURIComponent(param))}}else{str.push(encodeURIComponent(p)+"="+encodeURIComponent(params[p]))}}
return str.join("&")};let addGlobalHeader=function(key,value){globalHeaders[key]={key:key.toLowerCase(),value:value.toLowerCase()}};let addGlobalParam=function(key,value){globalParams.push({key:key,value:value})};addGlobalHeader('x-sdk-version','appwrite:javascript:v1.0.19');addGlobalHeader('content-type','');let call=function(method,path,headers={},params={},progress=null){let i;path=config.endpoint+path;if(-1===['GET','POST','PUT','DELETE','TRACE','HEAD','OPTIONS','CONNECT','PATCH'].indexOf(method)){throw new Error('var method must contain a valid HTTP method name')}
if(typeof path!=='string'){throw new Error('var path must be of type string')}
if(typeof headers!=='object'){throw new Error('var headers must be of type object')}
for(i=0;i<globalParams.length;i++){path=addParam(path,globalParams[i].key,globalParams[i].value)}
for(let key in globalHeaders){if(globalHeaders.hasOwnProperty(key)){if(!headers[globalHeaders[key].key]){headers[globalHeaders[key].key]=globalHeaders[key].value}}}
if(method==='GET'){for(let param in params){if(param.hasOwnProperty(key)){path=addParam(path,key+(Array.isArray(param)?'[]':''),params[key])}}}
switch(headers['content-type']){case 'application/json':params=JSON.stringify(params);break;case 'multipart/form-data':let formData=new FormData();Object.keys(params).forEach(function(key){let param=params[key];formData.append(key+(Array.isArray(param)?'[]':''),param)});params=formData;break}
return new Promise(function(resolve,reject){let request=new XMLHttpRequest(),key;request.withCredentials=!0;request.open(method,path,!0);for(key in headers){if(headers.hasOwnProperty(key)){if(key==='content-type'&&headers[key]==='multipart/form-data'){continue}
request.setRequestHeader(key,headers[key])}}
request.onload=function(){if(4===request.readyState&&399>=request.status){let data=request.response;let contentType=this.getResponseHeader('content-type')||'';contentType=contentType.substring(0,contentType.indexOf(';'));switch(contentType){case 'application/json':data=JSON.parse(data);break}
resolve(data)}else{reject(new Error(request.statusText))}};if(progress){request.addEventListener('progress',progress);request.upload.addEventListener('progress',progress,!1)}
request.onerror=function(){reject(new Error("Network Error"))};request.send(params)})};return{'get':function(path,headers={},params={}){return call('GET',path+((Object.keys(params).length>0)?'?'+buildQuery(params):''),headers,{})},'post':function(path,headers={},params={},progress=null){return call('POST',path,headers,params,progress)},'put':function(path,headers={},params={},progress=null){return call('PUT',path,headers,params,progress)},'patch':function(path,headers={},params={},progress=null){return call('PATCH',path,headers,params,progress)},'delete':function(path,headers={},params={},progress=null){return call('DELETE',path,headers,params,progress)},'addGlobalParam':addGlobalParam,'addGlobalHeader':addGlobalHeader}}(window.document);let iframe=function(method,url,params){let form=document.createElement('form');form.setAttribute('method',method);form.setAttribute('action',config.endpoint+url);for(let key in params){if(params.hasOwnProperty(key)){let hiddenField=document.createElement("input");hiddenField.setAttribute("type","hidden");hiddenField.setAttribute("name",key);hiddenField.setAttribute("value",params[key]);form.appendChild(hiddenField)}}
document.body.appendChild(form);return form.submit()};let account={get:function(){let path='/account';return http.get(path,{'content-type':'application/json'},{})},delete:function(){let path='/account';return http.delete(path,{'content-type':'application/json'},{})},updateEmail:function(email,password){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(password===undefined){throw new Error('Missing required parameter: "password"')}
let path='/account/email';return http.patch(path,{'content-type':'application/json'},{'email':email,'password':password})},updateName:function(name){if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/account/name';return http.patch(path,{'content-type':'application/json'},{'name':name})},updatePassword:function(password,oldPassword){if(password===undefined){throw new Error('Missing required parameter: "password"')}
if(oldPassword===undefined){throw new Error('Missing required parameter: "oldPassword"')}
let path='/account/password';return http.patch(path,{'content-type':'application/json'},{'password':password,'old-password':oldPassword})},getPrefs:function(){let path='/account/prefs';return http.get(path,{'content-type':'application/json'},{})},updatePrefs:function(prefs){if(prefs===undefined){throw new Error('Missing required parameter: "prefs"')}
let path='/account/prefs';return http.patch(path,{'content-type':'application/json'},{'prefs':prefs})},getSecurity:function(){let path='/account/security';return http.get(path,{'content-type':'application/json'},{})},getSessions:function(){let path='/account/sessions';return http.get(path,{'content-type':'application/json'},{})}};let auth={login:function(email,password,success='',failure=''){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(password===undefined){throw new Error('Missing required parameter: "password"')}
let path='/auth/login';return iframe('post',path,{project:config.project,'email':email,'password':password,'success':success,'failure':failure})},logout:function(){let path='/auth/logout';return http.delete(path,{'content-type':'application/json'},{})},logoutBySession:function(id){if(id===undefined){throw new Error('Missing required parameter: "id"')}
let path='/auth/logout/{id}'.replace(new RegExp('{id}','g'),id);return http.delete(path,{'content-type':'application/json'},{})},recovery:function(email,redirect){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"')}
let path='/auth/recovery';return http.post(path,{'content-type':'application/json'},{'email':email,'redirect':redirect})},recoveryReset:function(userId,token,passwordA,passwordB){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(token===undefined){throw new Error('Missing required parameter: "token"')}
if(passwordA===undefined){throw new Error('Missing required parameter: "passwordA"')}
if(passwordB===undefined){throw new Error('Missing required parameter: "passwordB"')}
let path='/auth/recovery/reset';return http.put(path,{'content-type':'application/json'},{'userId':userId,'token':token,'password-a':passwordA,'password-b':passwordB})},register:function(email,password,redirect,name='',success='',failure=''){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(password===undefined){throw new Error('Missing required parameter: "password"')}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"')}
let path='/auth/register';return iframe('post',path,{project:config.project,'email':email,'password':password,'name':name,'redirect':redirect,'success':success,'failure':failure})},confirm:function(userId,token){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(token===undefined){throw new Error('Missing required parameter: "token"')}
let path='/auth/register/confirm';return http.post(path,{'content-type':'application/json'},{'userId':userId,'token':token})},confirmResend:function(redirect){if(redirect===undefined){throw new Error('Missing required parameter: "redirect"')}
let path='/auth/register/confirm/resend';return http.post(path,{'content-type':'application/json'},{'redirect':redirect})},oauthCallback:function(projectId,provider,code,state=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(provider===undefined){throw new Error('Missing required parameter: "provider"')}
if(code===undefined){throw new Error('Missing required parameter: "code"')}
let path='/oauth/callback/{provider}/{projectId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{provider}','g'),provider);return http.get(path,{'content-type':'application/json'},{'code':code,'state':state})},oauth:function(provider,success='',failure=''){if(provider===undefined){throw new Error('Missing required parameter: "provider"')}
let path='/oauth/{provider}'.replace(new RegExp('{provider}','g'),provider);return http.get(path,{'content-type':'application/json'},{'success':success,'failure':failure})}};let avatars={getBrowser:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"')}
let path='/avatars/browsers/{code}'.replace(new RegExp('{code}','g'),code);return http.get(path,{'content-type':'application/json'},{'width':width,'height':height,'quality':quality})},getCreditCard:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"')}
let path='/avatars/credit-cards/{code}'.replace(new RegExp('{code}','g'),code);return http.get(path,{'content-type':'application/json'},{'width':width,'height':height,'quality':quality})},getFavicon:function(url){if(url===undefined){throw new Error('Missing required parameter: "url"')}
let path='/avatars/favicon';return http.get(path,{'content-type':'application/json'},{'url':url})},getFlag:function(code,width=100,height=100,quality=100){if(code===undefined){throw new Error('Missing required parameter: "code"')}
let path='/avatars/flags/{code}'.replace(new RegExp('{code}','g'),code);return http.get(path,{'content-type':'application/json'},{'width':width,'height':height,'quality':quality})},getImage:function(url,width=400,height=400){if(url===undefined){throw new Error('Missing required parameter: "url"')}
let path='/avatars/image';return http.get(path,{'content-type':'application/json'},{'url':url,'width':width,'height':height})},getQR:function(text,size=400,margin=1,download=0){if(text===undefined){throw new Error('Missing required parameter: "text"')}
let path='/avatars/qr';return http.get(path,{'content-type':'application/json'},{'text':text,'size':size,'margin':margin,'download':download})}};let database={listCollections:function(search='',limit=25,offset=0,orderType='ASC'){let path='/database';return http.get(path,{'content-type':'application/json'},{'search':search,'limit':limit,'offset':offset,'orderType':orderType})},createCollection:function(name,read=[],write=[],rules=[]){if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/database';return http.post(path,{'content-type':'application/json'},{'name':name,'read':read,'write':write,'rules':rules})},getCollection:function(collectionId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);return http.get(path,{'content-type':'application/json'},{})},updateCollection:function(collectionId,name,read=[],write=[],rules=[]){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);return http.put(path,{'content-type':'application/json'},{'name':name,'read':read,'write':write,'rules':rules})},deleteCollection:function(collectionId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
let path='/database/{collectionId}'.replace(new RegExp('{collectionId}','g'),collectionId);return http.delete(path,{'content-type':'application/json'},{})},listDocuments:function(collectionId,filters=[],offset=0,limit=50,orderField='$uid',orderType='ASC',orderCast='string',search='',first=0,last=0){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
let path='/database/{collectionId}/documents'.replace(new RegExp('{collectionId}','g'),collectionId);return http.get(path,{'content-type':'application/json'},{'filters':filters,'offset':offset,'limit':limit,'order-field':orderField,'order-type':orderType,'order-cast':orderCast,'search':search,'first':first,'last':last})},createDocument:function(collectionId,data,read=[],write=[],parentDocument='',parentProperty='',parentPropertyType='assign'){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(data===undefined){throw new Error('Missing required parameter: "data"')}
let path='/database/{collectionId}/documents'.replace(new RegExp('{collectionId}','g'),collectionId);return http.post(path,{'content-type':'application/json'},{'data':data,'read':read,'write':write,'parentDocument':parentDocument,'parentProperty':parentProperty,'parentPropertyType':parentPropertyType})},getDocument:function(collectionId,documentId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"')}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);return http.get(path,{'content-type':'application/json'},{})},updateDocument:function(collectionId,documentId,data,read=[],write=[]){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"')}
if(data===undefined){throw new Error('Missing required parameter: "data"')}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);return http.patch(path,{'content-type':'application/json'},{'data':data,'read':read,'write':write})},deleteDocument:function(collectionId,documentId){if(collectionId===undefined){throw new Error('Missing required parameter: "collectionId"')}
if(documentId===undefined){throw new Error('Missing required parameter: "documentId"')}
let path='/database/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}','g'),collectionId).replace(new RegExp('{documentId}','g'),documentId);return http.delete(path,{'content-type':'application/json'},{})}};let locale={getLocale:function(){let path='/locale';return http.get(path,{'content-type':'application/json'},{})},getCountries:function(){let path='/locale/countries';return http.get(path,{'content-type':'application/json'},{})},getCountriesEU:function(){let path='/locale/countries/eu';return http.get(path,{'content-type':'application/json'},{})},getCountriesPhones:function(){let path='/locale/countries/phones';return http.get(path,{'content-type':'application/json'},{})},getCurrencies:function(){let path='/locale/currencies';return http.get(path,{'content-type':'application/json'},{})}};let projects={listProjects:function(){let path='/projects';return http.get(path,{'content-type':'application/json'},{})},createProject:function(name,teamId,description='',logo='',url='',legalName='',legalCountry='',legalState='',legalCity='',legalAddress='',legalTaxId=''){if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
let path='/projects';return http.post(path,{'content-type':'application/json'},{'name':name,'teamId':teamId,'description':description,'logo':logo,'url':url,'legalName':legalName,'legalCountry':legalCountry,'legalState':legalState,'legalCity':legalCity,'legalAddress':legalAddress,'legalTaxId':legalTaxId})},getProject:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{})},updateProject:function(projectId,name,description='',logo='',url='',legalName='',legalCountry='',legalState='',legalCity='',legalAddress='',legalTaxId=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);return http.patch(path,{'content-type':'application/json'},{'name':name,'description':description,'logo':logo,'url':url,'legalName':legalName,'legalCountry':legalCountry,'legalState':legalState,'legalCity':legalCity,'legalAddress':legalAddress,'legalTaxId':legalTaxId})},deleteProject:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}'.replace(new RegExp('{projectId}','g'),projectId);return http.delete(path,{'content-type':'application/json'},{})},listKeys:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/keys'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{})},createKey:function(projectId,name,scopes){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(scopes===undefined){throw new Error('Missing required parameter: "scopes"')}
let path='/projects/{projectId}/keys'.replace(new RegExp('{projectId}','g'),projectId);return http.post(path,{'content-type':'application/json'},{'name':name,'scopes':scopes})},getKey:function(projectId,keyId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"')}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);return http.get(path,{'content-type':'application/json'},{})},updateKey:function(projectId,keyId,name,scopes){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(scopes===undefined){throw new Error('Missing required parameter: "scopes"')}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);return http.put(path,{'content-type':'application/json'},{'name':name,'scopes':scopes})},deleteKey:function(projectId,keyId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(keyId===undefined){throw new Error('Missing required parameter: "keyId"')}
let path='/projects/{projectId}/keys/{keyId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{keyId}','g'),keyId);return http.delete(path,{'content-type':'application/json'},{})},updateProjectOAuth:function(projectId,provider,appId='',secret=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(provider===undefined){throw new Error('Missing required parameter: "provider"')}
let path='/projects/{projectId}/oauth'.replace(new RegExp('{projectId}','g'),projectId);return http.patch(path,{'content-type':'application/json'},{'provider':provider,'appId':appId,'secret':secret})},listPlatforms:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/platforms'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{})},createPlatform:function(projectId,type,name,key='',store='',url=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(type===undefined){throw new Error('Missing required parameter: "type"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/projects/{projectId}/platforms'.replace(new RegExp('{projectId}','g'),projectId);return http.post(path,{'content-type':'application/json'},{'type':type,'name':name,'key':key,'store':store,'url':url})},getPlatform:function(projectId,platformId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"')}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);return http.get(path,{'content-type':'application/json'},{})},updatePlatform:function(projectId,platformId,name,key='',store='',url=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);return http.put(path,{'content-type':'application/json'},{'name':name,'key':key,'store':store,'url':url})},deletePlatform:function(projectId,platformId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(platformId===undefined){throw new Error('Missing required parameter: "platformId"')}
let path='/projects/{projectId}/platforms/{platformId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{platformId}','g'),platformId);return http.delete(path,{'content-type':'application/json'},{})},listTasks:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/tasks'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{})},createTask:function(projectId,name,status,schedule,security,httpMethod,httpUrl,httpHeaders=[],httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(status===undefined){throw new Error('Missing required parameter: "status"')}
if(schedule===undefined){throw new Error('Missing required parameter: "schedule"')}
if(security===undefined){throw new Error('Missing required parameter: "security"')}
if(httpMethod===undefined){throw new Error('Missing required parameter: "httpMethod"')}
if(httpUrl===undefined){throw new Error('Missing required parameter: "httpUrl"')}
let path='/projects/{projectId}/tasks'.replace(new RegExp('{projectId}','g'),projectId);return http.post(path,{'content-type':'application/json'},{'name':name,'status':status,'schedule':schedule,'security':security,'httpMethod':httpMethod,'httpUrl':httpUrl,'httpHeaders':httpHeaders,'httpUser':httpUser,'httpPass':httpPass})},getTask:function(projectId,taskId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"')}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);return http.get(path,{'content-type':'application/json'},{})},updateTask:function(projectId,taskId,name,status,schedule,security,httpMethod,httpUrl,httpHeaders=[],httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(status===undefined){throw new Error('Missing required parameter: "status"')}
if(schedule===undefined){throw new Error('Missing required parameter: "schedule"')}
if(security===undefined){throw new Error('Missing required parameter: "security"')}
if(httpMethod===undefined){throw new Error('Missing required parameter: "httpMethod"')}
if(httpUrl===undefined){throw new Error('Missing required parameter: "httpUrl"')}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);return http.put(path,{'content-type':'application/json'},{'name':name,'status':status,'schedule':schedule,'security':security,'httpMethod':httpMethod,'httpUrl':httpUrl,'httpHeaders':httpHeaders,'httpUser':httpUser,'httpPass':httpPass})},deleteTask:function(projectId,taskId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(taskId===undefined){throw new Error('Missing required parameter: "taskId"')}
let path='/projects/{projectId}/tasks/{taskId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{taskId}','g'),taskId);return http.delete(path,{'content-type':'application/json'},{})},getProjectUsage:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/usage'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{})},listWebhooks:function(projectId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
let path='/projects/{projectId}/webhooks'.replace(new RegExp('{projectId}','g'),projectId);return http.get(path,{'content-type':'application/json'},{})},createWebhook:function(projectId,name,events,url,security,httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(events===undefined){throw new Error('Missing required parameter: "events"')}
if(url===undefined){throw new Error('Missing required parameter: "url"')}
if(security===undefined){throw new Error('Missing required parameter: "security"')}
let path='/projects/{projectId}/webhooks'.replace(new RegExp('{projectId}','g'),projectId);return http.post(path,{'content-type':'application/json'},{'name':name,'events':events,'url':url,'security':security,'httpUser':httpUser,'httpPass':httpPass})},getWebhook:function(projectId,webhookId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"')}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);return http.get(path,{'content-type':'application/json'},{})},updateWebhook:function(projectId,webhookId,name,events,url,security,httpUser='',httpPass=''){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
if(events===undefined){throw new Error('Missing required parameter: "events"')}
if(url===undefined){throw new Error('Missing required parameter: "url"')}
if(security===undefined){throw new Error('Missing required parameter: "security"')}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);return http.put(path,{'content-type':'application/json'},{'name':name,'events':events,'url':url,'security':security,'httpUser':httpUser,'httpPass':httpPass})},deleteWebhook:function(projectId,webhookId){if(projectId===undefined){throw new Error('Missing required parameter: "projectId"')}
if(webhookId===undefined){throw new Error('Missing required parameter: "webhookId"')}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace(new RegExp('{projectId}','g'),projectId).replace(new RegExp('{webhookId}','g'),webhookId);return http.delete(path,{'content-type':'application/json'},{})}};let storage={listFiles:function(search='',limit=25,offset=0,orderType='ASC'){let path='/storage/files';return http.get(path,{'content-type':'application/json'},{'search':search,'limit':limit,'offset':offset,'orderType':orderType})},createFile:function(files,read=[],write=[],folderId=''){if(files===undefined){throw new Error('Missing required parameter: "files"')}
let path='/storage/files';return http.post(path,{'content-type':'multipart/form-data'},{'files':files,'read':read,'write':write,'folderId':folderId})},getFile:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);return http.get(path,{'content-type':'application/json'},{})},updateFile:function(fileId,read=[],write=[],folderId=''){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);return http.put(path,{'content-type':'application/json'},{'read':read,'write':write,'folderId':folderId})},deleteFile:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}'.replace(new RegExp('{fileId}','g'),fileId);return http.delete(path,{'content-type':'application/json'},{})},getFileDownload:function(fileId){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}/download'.replace(new RegExp('{fileId}','g'),fileId);return http.get(path,{'content-type':'application/json'},{})},getFilePreview:function(fileId,width=0,height=0,quality=100,background='',output=''){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}/preview'.replace(new RegExp('{fileId}','g'),fileId);return http.get(path,{'content-type':'application/json'},{'width':width,'height':height,'quality':quality,'background':background,'output':output})},getFileView:function(fileId,as=''){if(fileId===undefined){throw new Error('Missing required parameter: "fileId"')}
let path='/storage/files/{fileId}/view'.replace(new RegExp('{fileId}','g'),fileId);return http.get(path,{'content-type':'application/json'},{'as':as})}};let teams={listTeams:function(search='',limit=25,offset=0,orderType='ASC'){let path='/teams';return http.get(path,{'content-type':'application/json'},{'search':search,'limit':limit,'offset':offset,'orderType':orderType})},createTeam:function(name,roles=["owner"]){if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/teams';return http.post(path,{'content-type':'application/json'},{'name':name,'roles':roles})},getTeam:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);return http.get(path,{'content-type':'application/json'},{})},updateTeam:function(teamId,name){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(name===undefined){throw new Error('Missing required parameter: "name"')}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);return http.put(path,{'content-type':'application/json'},{'name':name})},deleteTeam:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
let path='/teams/{teamId}'.replace(new RegExp('{teamId}','g'),teamId);return http.delete(path,{'content-type':'application/json'},{})},getTeamMembers:function(teamId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
let path='/teams/{teamId}/members'.replace(new RegExp('{teamId}','g'),teamId);return http.get(path,{'content-type':'application/json'},{})},createTeamMembership:function(teamId,email,roles,redirect,name=''){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(roles===undefined){throw new Error('Missing required parameter: "roles"')}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"')}
let path='/teams/{teamId}/memberships'.replace(new RegExp('{teamId}','g'),teamId);return http.post(path,{'content-type':'application/json'},{'email':email,'name':name,'roles':roles,'redirect':redirect})},deleteTeamMembership:function(teamId,inviteId){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"')}
let path='/teams/{teamId}/memberships/{inviteId}'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);return http.delete(path,{'content-type':'application/json'},{})},createTeamMembershipResend:function(teamId,inviteId,redirect){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"')}
if(redirect===undefined){throw new Error('Missing required parameter: "redirect"')}
let path='/teams/{teamId}/memberships/{inviteId}/resend'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);return http.post(path,{'content-type':'application/json'},{'redirect':redirect})},updateTeamMembershipStatus:function(teamId,inviteId,userId,secret,success='',failure=''){if(teamId===undefined){throw new Error('Missing required parameter: "teamId"')}
if(inviteId===undefined){throw new Error('Missing required parameter: "inviteId"')}
if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(secret===undefined){throw new Error('Missing required parameter: "secret"')}
let path='/teams/{teamId}/memberships/{inviteId}/status'.replace(new RegExp('{teamId}','g'),teamId).replace(new RegExp('{inviteId}','g'),inviteId);return iframe('patch',path,{project:config.project,'userId':userId,'secret':secret,'success':success,'failure':failure})}};let users={listUsers:function(search='',limit=25,offset=0,orderType='ASC'){let path='/users';return http.get(path,{'content-type':'application/json'},{'search':search,'limit':limit,'offset':offset,'orderType':orderType})},createUser:function(email,password,name=''){if(email===undefined){throw new Error('Missing required parameter: "email"')}
if(password===undefined){throw new Error('Missing required parameter: "password"')}
let path='/users';return http.post(path,{'content-type':'application/json'},{'email':email,'password':password,'name':name})},getUser:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}'.replace(new RegExp('{userId}','g'),userId);return http.get(path,{'content-type':'application/json'},{})},getUserLogs:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}/logs'.replace(new RegExp('{userId}','g'),userId);return http.get(path,{'content-type':'application/json'},{})},getUserPrefs:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}/prefs'.replace(new RegExp('{userId}','g'),userId);return http.get(path,{'content-type':'application/json'},{})},getUserSessions:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}/sessions'.replace(new RegExp('{userId}','g'),userId);return http.get(path,{'content-type':'application/json'},{})},deleteUserSessions:function(userId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
let path='/users/{userId}/sessions'.replace(new RegExp('{userId}','g'),userId);return http.delete(path,{'content-type':'application/json'},{})},deleteUsersSession:function(userId,sessionId){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(sessionId===undefined){throw new Error('Missing required parameter: "sessionId"')}
let path='/users/{userId}/sessions/:session'.replace(new RegExp('{userId}','g'),userId);return http.delete(path,{'content-type':'application/json'},{'sessionId':sessionId})},updateUserStatus:function(userId,status){if(userId===undefined){throw new Error('Missing required parameter: "userId"')}
if(status===undefined){throw new Error('Missing required parameter: "status"')}
let path='/users/{userId}/status'.replace(new RegExp('{userId}','g'),userId);return http.patch(path,{'content-type':'application/json'},{'status':status})}};return{setEndpoint:setEndpoint,setProject:setProject,setKey:setKey,setLocale:setLocale,setMode:setMode,account:account,auth:auth,avatars:avatars,database:database,locale:locale,projects:projects,storage:storage,teams:teams,users:users}}})(window)