/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.layouts;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.commonsware.cwac.layouts.MirroringFrameLayout;

public class Mirror
extends View {
    private MirroringFrameLayout source = null;
    private Rect rect = new Rect();

    public Mirror(Context context) {
        super(context);
    }

    public Mirror(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public Mirror(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setSource(MirroringFrameLayout source) {
        this.source = source;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.source != null) {
            this.getDrawingRect(this.rect);
            Bitmap cache = this.source.getLastBitmap();
            if (cache != null) {
                Mirror.calcCenter(this.rect.width(), this.rect.height(), cache.getWidth(), cache.getHeight(), this.rect);
                canvas.drawBitmap(cache, null, this.rect, null);
            }
        }
    }

    private static void calcCenter(int vw, int vh, int iw, int ih, Rect out) {
        double scale = Math.min((double)vw / (double)iw, (double)vh / (double)ih);
        int h = (int)(scale * (double)ih);
        int w = (int)(scale * (double)iw);
        int x = vw - w >> 1;
        int y = vh - h >> 1;
        out.set(x, y, x + w, y + h);
    }
}

