/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion.loader;

import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FileDataEmitter;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class FileLoader
implements Loader {
    @Override
    public Future<InputStream> load(Ion ion, final AsyncHttpRequest request) {
        if (!request.getUri().getScheme().startsWith("file")) {
            return null;
        }
        final SimpleFuture ret = new SimpleFuture();
        ion.getServer().getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FileInputStream stream = new FileInputStream(new File(request.getUri()));
                    ret.setComplete((Object)stream);
                }
                catch (Exception e) {
                    ret.setComplete(e);
                }
            }
        });
        return ret;
    }

    @Override
    public Future<DataEmitter> load(final Ion ion, final AsyncHttpRequest request, final FutureCallback<Loader.LoaderEmitter> callback) {
        if (!request.getUri().getScheme().startsWith("file")) {
            return null;
        }
        final FileFuture ret = new FileFuture();
        ion.getHttpClient().getServer().post(new Runnable(){

            @Override
            public void run() {
                File file = new File(request.getUri());
                FileDataEmitter emitter = new FileDataEmitter(ion.getHttpClient().getServer(), file);
                ret.setComplete(emitter);
                callback.onCompleted(null, (Object)new Loader.LoaderEmitter((DataEmitter)emitter, (int)file.length(), 1, null, null));
            }
        });
        return ret;
    }

    private static final class FileFuture
    extends SimpleFuture<DataEmitter> {
        private FileFuture() {
        }
    }
}

