/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion.cookie;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.SimpleMiddleware;
import com.koushikdutta.async.http.libcore.RawHeaders;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class CookieMiddleware
extends SimpleMiddleware {
    CookieManager manager = new CookieManager(null, null);
    SharedPreferences preferences;

    public CookieStore getCookieStore() {
        return this.manager.getCookieStore();
    }

    public void clear() {
        this.getCookieStore().removeAll();
        this.preferences.edit().clear().commit();
    }

    public CookieManager getCookieManager() {
        return this.manager;
    }

    public CookieMiddleware(Context context, String name) {
        this.preferences = context.getSharedPreferences(name + "-cookies", 0);
        Map allPrefs = this.preferences.getAll();
        for (String key : allPrefs.keySet()) {
            try {
                String value = this.preferences.getString(key, null);
                RawHeaders headers = new RawHeaders();
                String[] lines = value.split("\n");
                boolean first = true;
                for (String line : lines) {
                    if (first) {
                        first = false;
                        headers.setStatusLine(line);
                        continue;
                    }
                    if (TextUtils.isEmpty((CharSequence)line)) continue;
                    headers.addLine(line);
                }
                this.manager.put(URI.create(key), headers.toMultimap());
            }
            catch (Exception e) {
                Log.e((String)"Ion", (String)"unable to load cookies", (Throwable)e);
            }
        }
    }

    public void onSocket(AsyncHttpClientMiddleware.OnSocketData data) {
        try {
            Map<String, List<String>> cookies = this.manager.get(data.request.getUri(), data.request.getHeaders().getHeaders().toMultimap());
            data.request.getHeaders().addCookies(cookies);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onHeadersReceived(AsyncHttpClientMiddleware.OnHeadersReceivedData data) {
        try {
            this.manager.put(data.request.getUri(), data.headers.getHeaders().toMultimap());
            if (data.headers.getHeaders().get("Set-Cookie") == null) {
                return;
            }
            URI uri = data.request.getUri();
            String key = uri.getScheme() + "://" + uri.getAuthority();
            this.preferences.edit().putString(key, data.headers.getHeaders().toHeaderString()).commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

