/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion.bitmap;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.bitmap.BitmapInfo;
import com.koushikdutta.ion.bitmap.LruBitmapCache;
import com.koushikdutta.ion.bitmap.MarkableInputStream;
import java.io.InputStream;

public class IonBitmapCache {
    public static final long DEFAULT_ERROR_CACHE_DURATION = 30000L;
    Resources resources;
    DisplayMetrics metrics;
    LruBitmapCache cache;
    Ion ion;
    long errorCacheDuration = 30000L;

    public long getErrorCacheDuration() {
        return this.errorCacheDuration;
    }

    public void setErrorCacheDuration(long errorCacheDuration) {
        this.errorCacheDuration = errorCacheDuration;
    }

    public IonBitmapCache(Ion ion) {
        Context context = ion.getContext();
        this.ion = ion;
        this.metrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(this.metrics);
        AssetManager mgr = context.getAssets();
        this.resources = new Resources(mgr, this.metrics, context.getResources().getConfiguration());
        this.cache = new LruBitmapCache(IonBitmapCache.getHeapSize(context) / 7);
    }

    public BitmapInfo remove(String key) {
        return (BitmapInfo)this.cache.remove(key);
    }

    public void put(BitmapInfo info) {
        assert (Thread.currentThread() == Looper.getMainLooper().getThread());
        this.cache.put(info.key, info);
    }

    public BitmapInfo get(String key) {
        if (key == null) {
            return null;
        }
        assert (Thread.currentThread() == Looper.getMainLooper().getThread());
        BitmapInfo ret = (BitmapInfo)this.cache.get(key);
        if (ret == null || ret.bitmap != null) {
            return ret;
        }
        if (ret.loadTime + this.errorCacheDuration > System.currentTimeMillis()) {
            return ret;
        }
        this.cache.remove(key);
        return null;
    }

    public void dump() {
        Log.i((String)"IonBitmapCache", (String)("bitmap cache: " + this.cache.size()));
        Log.i((String)"IonBitmapCache", (String)("freeMemory: " + Runtime.getRuntime().freeMemory()));
    }

    public Bitmap loadBitmap(byte[] bytes, int offset, int length, int minx, int miny) {
        assert (Thread.currentThread() != Looper.getMainLooper().getThread());
        int targetWidth = minx;
        int targetHeight = miny;
        if (targetWidth <= 0) {
            targetWidth = this.metrics.widthPixels;
        }
        if (targetWidth <= 0) {
            targetWidth = Integer.MAX_VALUE;
        }
        if (targetHeight <= 0) {
            targetHeight = this.metrics.heightPixels;
        }
        if (targetHeight <= 0) {
            targetHeight = Integer.MAX_VALUE;
        }
        BitmapFactory.Options o = null;
        if (targetWidth != Integer.MAX_VALUE || targetHeight != Integer.MAX_VALUE) {
            o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])bytes, (int)offset, (int)length, (BitmapFactory.Options)o);
            if (o.outWidth < 0 || o.outHeight < 0) {
                return null;
            }
            int scale = Math.min(o.outWidth / targetWidth, o.outHeight / targetHeight);
            o = new BitmapFactory.Options();
            o.inSampleSize = scale;
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)offset, (int)length, (BitmapFactory.Options)o);
    }

    public Bitmap loadBitmap(InputStream stream, int minx, int miny) {
        if (!stream.markSupported()) {
            stream = new MarkableInputStream(stream);
        }
        assert (Thread.currentThread() != Looper.getMainLooper().getThread());
        int targetWidth = minx;
        int targetHeight = miny;
        if (targetWidth <= 0) {
            targetWidth = this.metrics.widthPixels;
        }
        if (targetWidth <= 0) {
            targetWidth = Integer.MAX_VALUE;
        }
        if (targetHeight <= 0) {
            targetHeight = this.metrics.heightPixels;
        }
        if (targetHeight <= 0) {
            targetHeight = Integer.MAX_VALUE;
        }
        BitmapFactory.Options o = null;
        if (targetWidth != Integer.MAX_VALUE || targetHeight != Integer.MAX_VALUE) {
            o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            stream.mark(Integer.MAX_VALUE);
            BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)o);
            if (o.outWidth < 0 || o.outHeight < 0) {
                return null;
            }
            try {
                stream.reset();
            }
            catch (Exception e) {
                return null;
            }
            int scale = Math.min(o.outWidth / targetWidth, o.outHeight / targetHeight);
            o = new BitmapFactory.Options();
            o.inSampleSize = scale;
        }
        return BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)o);
    }

    private static int getHeapSize(Context context) {
        return ((ActivityManager)context.getSystemService("activity")).getMemoryClass() * 1024 * 1024;
    }
}

