/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.builder.Builders;
import java.lang.ref.WeakReference;

public class NetworkImageView
extends ImageView {
    private String mUrl;
    private int mDefaultImageId;
    private int mErrorImageId;
    private Ion mIon;
    private WeakReference<Future<ImageView>> mFuture;

    public NetworkImageView(Context context) {
        this(context, null);
    }

    public NetworkImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setImageUrl(String url, Ion ion) {
        this.mIon = ion;
        this.loadImageIfNecessary(url);
    }

    public void setImageUrl(String url) {
        this.mIon = Ion.getDefault(this.getContext());
        this.loadImageIfNecessary(url);
    }

    public void setDefaultImageResId(int defaultImage) {
        this.mDefaultImageId = defaultImage;
    }

    public void setErrorImageResId(int errorImage) {
        this.mErrorImageId = errorImage;
    }

    private void loadImageIfNecessary(String url) {
        int width = this.getWidth();
        int height = this.getHeight();
        String oldUrl = this.mUrl;
        this.mUrl = url;
        if (width == 0 && height == 0) {
            return;
        }
        Future<ImageView> future = this.mFuture == null ? null : (Future<ImageView>)this.mFuture.get();
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (future != null) {
                future.cancel();
                this.mFuture = null;
            }
            this.setImageBitmap(null);
            return;
        }
        if (future != null && oldUrl != null) {
            if (oldUrl.equals(this.mUrl)) {
                return;
            }
            future.cancel();
            this.setImageBitmap(null);
        }
        future = ((Builders.ImageView.F)((Builders.ImageView.F)this.mIon.build(this).placeholder(this.mDefaultImageId)).error(this.mErrorImageId)).load(this.mUrl);
        this.mFuture = new WeakReference<Future<ImageView>>(future);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.loadImageIfNecessary(this.mUrl);
    }

    protected void onDetachedFromWindow() {
        Future future = this.mFuture == null ? null : (Future)this.mFuture.get();
        if (future != null) {
            future.cancel();
            this.setImageBitmap(null);
            this.mFuture = null;
        }
        super.onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }
}

