/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.graphics.Bitmap;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.BitmapCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.IonRequestBuilder;
import com.koushikdutta.ion.bitmap.BitmapInfo;
import java.nio.ByteBuffer;

class LoadBitmap
extends BitmapCallback
implements FutureCallback<ByteBufferList> {
    int resizeWidth;
    int resizeHeight;
    IonRequestBuilder.EmitterTransform<ByteBufferList> emitterTransform;

    public LoadBitmap(Ion ion, String urlKey, boolean put, int resizeWidth, int resizeHeight, IonRequestBuilder.EmitterTransform<ByteBufferList> emitterTransform) {
        super(ion, urlKey, put);
        this.resizeWidth = resizeWidth;
        this.resizeHeight = resizeHeight;
        this.emitterTransform = emitterTransform;
    }

    public void onCompleted(Exception e, final ByteBufferList result) {
        if (e != null) {
            this.report(e, null);
            return;
        }
        this.ion.getServer().getExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ByteBuffer bb = result.getAll();
                try {
                    Bitmap bitmap = LoadBitmap.this.ion.bitmapCache.loadBitmap(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining(), LoadBitmap.this.resizeWidth, LoadBitmap.this.resizeHeight);
                    if (bitmap == null) {
                        throw new Exception("bitmap failed to load");
                    }
                    BitmapInfo info = new BitmapInfo();
                    info.key = LoadBitmap.this.key;
                    info.bitmap = bitmap;
                    info.loadedFrom = LoadBitmap.this.emitterTransform.loadedFrom();
                    LoadBitmap.this.report(null, info);
                }
                catch (Exception e) {
                    LoadBitmap.this.report(e, null);
                }
                finally {
                    ByteBufferList.reclaim((ByteBuffer)bb);
                }
            }
        });
    }
}

