/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ProgressDialog;
import android.app.Service;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.DataTrackingEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.body.DocumentBody;
import com.koushikdutta.async.http.body.MultipartFormDataBody;
import com.koushikdutta.async.http.body.StringBody;
import com.koushikdutta.async.http.body.UrlEncodedFormBody;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.parser.AsyncParser;
import com.koushikdutta.async.parser.DocumentParser;
import com.koushikdutta.async.parser.StringParser;
import com.koushikdutta.async.stream.OutputStreamDataSink;
import com.koushikdutta.ion.HeadersCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.IonBitmapRequestBuilder;
import com.koushikdutta.ion.Loader;
import com.koushikdutta.ion.ProgressCallback;
import com.koushikdutta.ion.RequestBodyUploadObserver;
import com.koushikdutta.ion.Response;
import com.koushikdutta.ion.builder.Builders;
import com.koushikdutta.ion.builder.FutureBuilder;
import com.koushikdutta.ion.builder.LoadBuilder;
import com.koushikdutta.ion.future.ResponseFuture;
import com.koushikdutta.ion.gson.GsonBody;
import com.koushikdutta.ion.gson.GsonParser;
import com.koushikdutta.ion.gson.GsonSerializer;
import com.koushikdutta.ion.gson.PojoBody;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

class IonRequestBuilder
implements Builders.Any.B,
Builders.Any.F,
Builders.Any.M,
Builders.Any.U,
LoadBuilder<Builders.Any.B> {
    Ion ion;
    WeakReference<Context> context;
    Handler handler = Ion.mainHandler;
    String method = "GET";
    String uri;
    boolean methodWasSet;
    RawHeaders headers;
    Multimap query;
    int timeoutMilliseconds = 30000;
    AsyncHttpRequestBody body;
    boolean followRedirect = true;
    WeakReference<ProgressBar> progressBar;
    WeakReference<ProgressDialog> progressDialog;
    ProgressCallback progress;
    ProgressCallback progressHandler;
    Multimap bodyParameters;
    MultipartFormDataBody multipartBody;
    String logTag;
    int logLevel;
    ArrayList<WeakReference<Object>> groups;
    String proxyHost;
    int proxyPort;
    ProgressCallback uploadProgress;
    ProgressBar uploadProgressBar;
    ProgressDialog uploadProgressDialog;
    ProgressCallback uploadProgressHandler;
    HeadersCallback headersCallback;

    public IonRequestBuilder(Context context, Ion ion) {
        this.ion = ion;
        this.context = new WeakReference<Context>(context);
    }

    @Override
    public IonRequestBuilder load(String url) {
        return this.loadInternal("GET", url);
    }

    private IonRequestBuilder loadInternal(String method, String url) {
        this.method = method;
        this.uri = url;
        return this;
    }

    @Override
    public IonRequestBuilder load(String method, String url) {
        this.methodWasSet = true;
        return this.loadInternal(method, url);
    }

    private RawHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new RawHeaders();
            AsyncHttpRequest.setDefaultHeaders((RawHeaders)this.headers, (URI)URI.create(this.uri));
        }
        return this.headers;
    }

    @Override
    public IonRequestBuilder userAgent(String userAgent) {
        return this.setHeader("User-Agent", userAgent);
    }

    @Override
    public IonRequestBuilder setHeader(String name, String value) {
        this.getHeaders().set(name, value);
        return this;
    }

    @Override
    public IonRequestBuilder addHeader(String name, String value) {
        this.getHeaders().add(name, value);
        return this;
    }

    @Override
    public IonRequestBuilder addQuery(String name, String value) {
        if (this.query == null) {
            this.query = new Multimap();
        }
        this.query.add(name, value);
        return this;
    }

    @Override
    public IonRequestBuilder setTimeout(int timeoutMilliseconds) {
        this.timeoutMilliseconds = timeoutMilliseconds;
        return this;
    }

    @Override
    public IonRequestBuilder setHandler(Handler handler) {
        this.handler = handler;
        return this;
    }

    private <T> IonRequestBuilder setBody(AsyncHttpRequestBody<T> body) {
        if (!this.methodWasSet) {
            this.method = "POST";
        }
        this.body = body;
        return this;
    }

    @Override
    public IonRequestBuilder setJsonObjectBody(JsonObject jsonObject) {
        return this.setBody(new GsonBody<JsonObject>(this.ion.configure().getGson(), jsonObject));
    }

    @Override
    public IonRequestBuilder setJsonArrayBody(JsonArray jsonArray) {
        return this.setBody(new GsonBody<JsonArray>(this.ion.configure().getGson(), jsonArray));
    }

    @Override
    public IonRequestBuilder setStringBody(String string) {
        return this.setBody((AsyncHttpRequestBody)new StringBody(string));
    }

    @Override
    public IonRequestBuilder followRedirect(boolean follow) {
        this.followRedirect = follow;
        return this;
    }

    private static boolean isServiceRunning(Service candidate) {
        ActivityManager manager = (ActivityManager)candidate.getSystemService("activity");
        List services = manager.getRunningServices(Integer.MAX_VALUE);
        if (services == null) {
            return false;
        }
        for (ActivityManager.RunningServiceInfo service : services) {
            if (!candidate.getClass().getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkContext() {
        Service service;
        Activity activity;
        Context context = (Context)this.context.get();
        if (context == null) {
            return false;
        }
        return !(context instanceof Activity ? (activity = (Activity)context).isFinishing() : context instanceof Service && !IonRequestBuilder.isServiceRunning(service = (Service)context));
    }

    private <T> void postExecute(final SimpleFuture<T> future, final Exception ex, final T value) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (!IonRequestBuilder.this.checkContext()) {
                    return;
                }
                if (ex != null) {
                    future.setComplete(ex);
                } else {
                    future.setComplete(value);
                }
            }
        };
        if (this.handler == null) {
            this.ion.httpClient.getServer().post(runner);
        } else {
            AsyncServer.post((Handler)this.handler, (Runnable)runner);
        }
    }

    private URI prepareURI() {
        URI uri;
        try {
            if (this.query != null) {
                Uri.Builder builder = Uri.parse((String)this.uri).buildUpon();
                for (String key : this.query.keySet()) {
                    for (String value : (List)this.query.get((Object)key)) {
                        builder = builder.appendQueryParameter(key, value);
                    }
                }
                uri = URI.create(builder.toString());
            } else {
                uri = URI.create(this.uri);
            }
        }
        catch (Exception e) {
            uri = null;
        }
        if (uri == null || uri.getScheme() == null) {
            return null;
        }
        return uri;
    }

    private AsyncHttpRequest prepareRequest(URI uri, AsyncHttpRequestBody wrappedBody) {
        AsyncHttpRequest request = this.ion.configure().getAsyncHttpRequestFactory().createAsyncHttpRequest(uri, this.method, this.headers);
        request.setFollowRedirect(this.followRedirect);
        request.setBody(wrappedBody);
        request.setLogging(this.ion.LOGTAG, this.ion.logLevel);
        if (this.logTag != null) {
            request.setLogging(this.logTag, this.logLevel);
        }
        request.enableProxy(this.proxyHost, this.proxyPort);
        request.setTimeout(this.timeoutMilliseconds);
        request.setHandler(null);
        request.logd("preparing request");
        return request;
    }

    private <T> void getLoaderEmitter(final EmitterTransform<T> ret) {
        URI uri = this.prepareURI();
        if (uri == null) {
            ret.setComplete(new Exception("Invalid URI"));
            return;
        }
        AsyncHttpRequestBody wrappedBody = this.body;
        if (this.uploadProgressHandler != null || this.uploadProgressBar != null || this.uploadProgress != null || this.uploadProgressDialog != null) {
            wrappedBody = new RequestBodyUploadObserver(this.body, new ProgressCallback(){

                @Override
                public void onProgress(final int downloaded, final int total) {
                    assert (Thread.currentThread() != Looper.getMainLooper().getThread());
                    int percent = (int)((float)total / (float)total * 100.0f);
                    if (IonRequestBuilder.this.uploadProgressBar != null) {
                        IonRequestBuilder.this.uploadProgressBar.setProgress(percent);
                    }
                    if (IonRequestBuilder.this.uploadProgressDialog != null) {
                        IonRequestBuilder.this.uploadProgressDialog.setProgress(percent);
                    }
                    if (IonRequestBuilder.this.uploadProgress != null) {
                        IonRequestBuilder.this.uploadProgress.onProgress(downloaded, total);
                    }
                    if (IonRequestBuilder.this.uploadProgressHandler != null) {
                        AsyncServer.post((Handler)IonRequestBuilder.this.handler, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ret.isCancelled() || ret.isDone()) {
                                    return;
                                }
                                IonRequestBuilder.this.progressHandler.onProgress(downloaded, total);
                            }
                        });
                    }
                }
            });
        }
        AsyncHttpRequest request = this.prepareRequest(uri, wrappedBody);
        ((EmitterTransform)ret).initialRequest = request;
        for (Loader loader : this.ion.config.loaders) {
            Future<DataEmitter> emitter = loader.load(this.ion, request, (FutureCallback<Loader.LoaderEmitter>)ret);
            if (emitter == null) continue;
            ret.setParent((Cancellable)emitter);
            return;
        }
        ret.setComplete(new Exception("Unknown uri scheme"));
    }

    @Override
    public IonRequestBuilder progressBar(ProgressBar progressBar) {
        this.progressBar = new WeakReference<ProgressBar>(progressBar);
        return this;
    }

    @Override
    public IonRequestBuilder progressDialog(ProgressDialog progressDialog) {
        this.progressDialog = new WeakReference<ProgressDialog>(progressDialog);
        return this;
    }

    @Override
    public IonRequestBuilder progress(ProgressCallback callback) {
        this.progress = callback;
        return this;
    }

    @Override
    public IonRequestBuilder progressHandler(ProgressCallback callback) {
        this.progressHandler = callback;
        return this;
    }

    <T> EmitterTransform<T> execute(DataSink sink, boolean close, T result) {
        return this.execute(sink, close, result, null);
    }

    <T> EmitterTransform<T> execute(final DataSink sink, final boolean close, final T result, Runnable cancel) {
        EmitterTransform ret = new EmitterTransform<T>(cancel){
            TransformFuture<T, Loader.LoaderEmitter> self;
            {
                super(x0);
                this.self = this;
            }

            protected void cleanup() {
                super.cleanup();
                if (close) {
                    sink.close();
                }
            }

            @Override
            protected void transform(Loader.LoaderEmitter emitter) throws Exception {
                super.transform(emitter);
                Util.pump((DataEmitter)this.emitter, (DataSink)sink, (CompletedCallback)new CompletedCallback(){

                    public void onCompleted(Exception ex) {
                        IonRequestBuilder.this.postExecute(self, ex, result);
                    }
                });
            }
        };
        this.getLoaderEmitter(ret);
        return ret;
    }

    <T> EmitterTransform<T> execute(AsyncParser<T> parser) {
        return this.execute(parser, null);
    }

    <T> EmitterTransform<T> execute(final AsyncParser<T> parser, Runnable cancel) {
        assert (parser != null);
        EmitterTransform ret = new EmitterTransform<T>(cancel){
            TransformFuture<T, Loader.LoaderEmitter> self;
            {
                super(x0);
                this.self = this;
            }

            @Override
            protected void transform(Loader.LoaderEmitter emitter) throws Exception {
                super.transform(emitter);
                parser.parse(this.emitter).setCallback(new FutureCallback<T>(){

                    public void onCompleted(Exception e, T result) {
                        IonRequestBuilder.this.postExecute(self, e, result);
                    }
                });
            }
        };
        this.getLoaderEmitter(ret);
        return ret;
    }

    Future<InputStream> execute() {
        URI uri = this.prepareURI();
        if (uri == null) {
            return null;
        }
        AsyncHttpRequest request = this.prepareRequest(uri, null);
        for (Loader loader : this.ion.config.loaders) {
            Future<InputStream> ret = loader.load(this.ion, request);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public ResponseFuture<JsonObject> asJsonObject() {
        return this.execute(new GsonParser());
    }

    @Override
    public ResponseFuture<JsonArray> asJsonArray() {
        return this.execute(new GsonParser());
    }

    @Override
    public ResponseFuture<String> asString() {
        return this.execute((AsyncParser)new StringParser());
    }

    public <F extends OutputStream> ResponseFuture<F> write(F outputStream, boolean close) {
        return this.execute((DataSink)new OutputStreamDataSink(this.ion.getServer(), outputStream, true), close, outputStream);
    }

    public <F extends OutputStream> ResponseFuture<F> write(F outputStream) {
        return this.execute((DataSink)new OutputStreamDataSink(this.ion.getServer(), outputStream, true), true, outputStream);
    }

    @Override
    public ResponseFuture<File> write(final File file) {
        try {
            return this.execute((DataSink)new OutputStreamDataSink(this.ion.getServer(), (OutputStream)new FileOutputStream(file)), true, file, new Runnable(){

                @Override
                public void run() {
                    file.delete();
                }
            });
        }
        catch (Exception e) {
            EmitterTransform<File> ret = new EmitterTransform<File>(null);
            ret.setComplete(e);
            return ret;
        }
    }

    @Override
    public IonRequestBuilder setBodyParameter(String name, String value) {
        if (this.bodyParameters == null) {
            this.bodyParameters = new Multimap();
            this.setBody((AsyncHttpRequestBody)new UrlEncodedFormBody(this.bodyParameters));
        }
        this.bodyParameters.add(name, value);
        return this;
    }

    @Override
    public IonRequestBuilder setMultipartFile(String name, File file) {
        if (this.multipartBody == null) {
            this.multipartBody = new MultipartFormDataBody();
            this.setBody((AsyncHttpRequestBody)this.multipartBody);
        }
        this.multipartBody.addFilePart(name, file);
        return this;
    }

    @Override
    public IonRequestBuilder setMultipartParameter(String name, String value) {
        if (this.multipartBody == null) {
            this.multipartBody = new MultipartFormDataBody();
            this.setBody((AsyncHttpRequestBody)this.multipartBody);
        }
        this.multipartBody.addStringPart(name, value);
        return this;
    }

    public IonBitmapRequestBuilder withBitmap() {
        return new IonBitmapRequestBuilder(this);
    }

    IonBitmapRequestBuilder withImageView(ImageView imageView) {
        return new IonBitmapRequestBuilder(this).withImageView(imageView);
    }

    @Override
    public Future<ImageView> intoImageView(ImageView imageView) {
        return new IonBitmapRequestBuilder(this).intoImageView(imageView);
    }

    @Override
    public IonRequestBuilder load(File file) {
        this.loadInternal(null, file.toURI().toString());
        return this;
    }

    @Override
    public Future<Bitmap> asBitmap() {
        return new IonBitmapRequestBuilder(this).asBitmap();
    }

    @Override
    public IonRequestBuilder setLogging(String tag, int level) {
        this.logTag = tag;
        this.logLevel = level;
        return this;
    }

    @Override
    public <T> ResponseFuture<T> as(Class<T> clazz) {
        return this.execute(new GsonSerializer<T>(this.ion.configure().getGson(), clazz));
    }

    @Override
    public <T> ResponseFuture<T> as(TypeToken<T> token) {
        return this.execute(new GsonSerializer<T>(this.ion.configure().getGson(), token));
    }

    @Override
    public FutureBuilder group(Object groupKey) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        this.groups.add(new WeakReference<Object>(groupKey));
        return this;
    }

    @Override
    public IonRequestBuilder proxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        return this;
    }

    @Override
    public IonRequestBuilder setJsonObjectBody(Object object, TypeToken token) {
        this.setBody(new PojoBody<Object>(this.ion.configure().getGson(), object, token));
        return this;
    }

    @Override
    public IonRequestBuilder setJsonObjectBody(Object object) {
        this.setBody(new PojoBody<Object>(this.ion.configure().getGson(), object, null));
        return this;
    }

    @Override
    public IonRequestBuilder basicAuthentication(String username, String password) {
        return this.setHeader("Authorization", "Basic " + Base64.encodeToString((byte[])String.format("%s:%s", username, password).getBytes(), (int)2));
    }

    @Override
    public Builders.Any.B uploadProgress(ProgressCallback callback) {
        this.uploadProgress = callback;
        return this;
    }

    @Override
    public Builders.Any.B uploadProgressBar(ProgressBar progressBar) {
        this.uploadProgressBar = progressBar;
        return this;
    }

    @Override
    public Builders.Any.B uploadProgressDialog(ProgressDialog progressDialog) {
        this.uploadProgressDialog = progressDialog;
        return this;
    }

    @Override
    public Builders.Any.B uploadProgressHandler(ProgressCallback callback) {
        this.uploadProgressHandler = callback;
        return this;
    }

    @Override
    public Builders.Any.B onHeaders(HeadersCallback callback) {
        this.headersCallback = callback;
        return this;
    }

    @Override
    public Builders.Any.F setDocumentBody(Document document) {
        this.setBody((AsyncHttpRequestBody)new DocumentBody(document));
        return this;
    }

    @Override
    public ResponseFuture<Document> asDocument() {
        return this.execute((AsyncParser)new DocumentParser());
    }

    class EmitterTransform<T>
    extends TransformFuture<T, Loader.LoaderEmitter>
    implements ResponseFuture<T> {
        private AsyncHttpRequest initialRequest;
        private AsyncHttpRequest finalRequest;
        private int loadedFrom;
        Runnable cancelCallback;
        RawHeaders headers;
        DataEmitter emitter;

        @Override
        public Future<Response<T>> withResponse() {
            ResponseFutureImpl ret = new ResponseFutureImpl();
            this.setCallback((FutureCallback)ret);
            return ret;
        }

        public int loadedFrom() {
            return this.loadedFrom;
        }

        public EmitterTransform(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
            IonRequestBuilder.this.ion.addFutureInFlight(this, IonRequestBuilder.this.context.get());
            if (IonRequestBuilder.this.groups == null) {
                return;
            }
            for (WeakReference<Object> ref : IonRequestBuilder.this.groups) {
                Object group = ref.get();
                if (group == null) continue;
                IonRequestBuilder.this.ion.addFutureInFlight(this, group);
            }
        }

        protected void cancelCleanup() {
            super.cancelCleanup();
            if (this.emitter != null) {
                this.emitter.close();
            }
            if (this.cancelCallback != null) {
                this.cancelCallback.run();
            }
        }

        protected void error(Exception e) {
            IonRequestBuilder.this.postExecute((SimpleFuture)this, e, null);
        }

        protected void transform(Loader.LoaderEmitter emitter) throws Exception {
            FilteredDataEmitter tracker;
            this.emitter = emitter.getDataEmitter();
            this.loadedFrom = emitter.loadedFrom();
            this.headers = emitter.getHeaders();
            this.finalRequest = emitter.getRequest();
            if (IonRequestBuilder.this.headersCallback != null) {
                final RawHeaders headers = emitter.getHeaders();
                AsyncServer.post((Handler)IonRequestBuilder.this.handler, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IonRequestBuilder.this.headersCallback.onHeaders(headers);
                    }
                });
            }
            final int total = emitter.length();
            if (!(emitter instanceof DataTrackingEmitter)) {
                tracker = new FilteredDataEmitter();
                tracker.setDataEmitter(this.emitter);
            } else {
                tracker = (DataTrackingEmitter)this.emitter;
            }
            this.emitter = tracker;
            tracker.setDataTracker(new DataTrackingEmitter.DataTracker(){
                int lastPercent;

                public void onData(final int totalBytesRead) {
                    assert (Thread.currentThread() != Looper.getMainLooper().getThread());
                    if (!IonRequestBuilder.this.checkContext()) {
                        EmitterTransform.this.cancel();
                        return;
                    }
                    final int percent = (int)((float)totalBytesRead / (float)total * 100.0f);
                    if ((IonRequestBuilder.this.progressBar != null || IonRequestBuilder.this.progressDialog != null) && percent != this.lastPercent) {
                        IonRequestBuilder.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                ProgressDialog dlg;
                                ProgressBar bar;
                                if (IonRequestBuilder.this.progressBar != null && (bar = (ProgressBar)IonRequestBuilder.this.progressBar.get()) != null) {
                                    bar.setProgress(percent);
                                }
                                if (IonRequestBuilder.this.progressDialog != null && (dlg = (ProgressDialog)IonRequestBuilder.this.progressDialog.get()) != null) {
                                    dlg.setProgress(percent);
                                }
                            }
                        });
                    }
                    this.lastPercent = percent;
                    if (IonRequestBuilder.this.progress != null) {
                        IonRequestBuilder.this.progress.onProgress(totalBytesRead, total);
                    }
                    if (IonRequestBuilder.this.progressHandler != null) {
                        AsyncServer.post((Handler)IonRequestBuilder.this.handler, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (EmitterTransform.this.isCancelled() || EmitterTransform.this.isDone()) {
                                    return;
                                }
                                IonRequestBuilder.this.progressHandler.onProgress(totalBytesRead, total);
                            }
                        });
                    }
                }
            });
        }

        class ResponseFutureImpl
        extends TransformFuture<Response<T>, T> {
            ResponseFutureImpl() {
            }

            protected void error(Exception e) {
                Response response = new Response();
                response.headers = EmitterTransform.this.headers;
                response.request = EmitterTransform.this.finalRequest;
                this.setComplete(e, response);
            }

            protected void transform(T result) throws Exception {
                Response response = new Response();
                response.headers = EmitterTransform.this.headers;
                response.result = result;
                response.request = EmitterTransform.this.finalRequest;
                this.setComplete(response);
            }
        }
    }
}

