/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.http.ResponseCacheMiddleware;
import com.koushikdutta.async.http.libcore.DiskLruCache;
import com.koushikdutta.async.parser.ByteBufferListParser;
import com.koushikdutta.ion.BitmapToBitmapInfo;
import com.koushikdutta.ion.DefaultTransform;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.IonDrawable;
import com.koushikdutta.ion.IonRequestBuilder;
import com.koushikdutta.ion.LoadBitmap;
import com.koushikdutta.ion.LoadBitmapStream;
import com.koushikdutta.ion.ScaleMode;
import com.koushikdutta.ion.bitmap.BitmapInfo;
import com.koushikdutta.ion.bitmap.Transform;
import com.koushikdutta.ion.builder.BitmapFutureBuilder;
import com.koushikdutta.ion.builder.Builders;
import com.koushikdutta.ion.builder.ImageViewFutureBuilder;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class IonBitmapRequestBuilder
implements Builders.ImageView.F,
ImageViewFutureBuilder,
BitmapFutureBuilder,
Builders.Any.BF {
    IonRequestBuilder builder;
    Ion ion;
    WeakReference<ImageView> imageViewPostRef;
    ArrayList<Transform> transforms;
    String bitmapKey;
    private static final SimpleFuture<ImageView> FUTURE_IMAGEVIEW_NULL_URI = new SimpleFuture<ImageView>(){
        {
            this.setComplete(new NullPointerException("uri"));
        }
    };
    private static final SimpleFuture<Bitmap> FUTURE_BITMAP_NULL_URI = new SimpleFuture<Bitmap>(){
        {
            this.setComplete(new NullPointerException("uri"));
        }
    };
    Drawable placeholderDrawable;
    int placeholderResource;
    Drawable errorDrawable;
    int errorResource;
    Animation inAnimation;
    Animation loadAnimation;
    int loadAnimationResource;
    int inAnimationResource;
    ScaleMode scaleMode = ScaleMode.FitXY;
    int resizeWidth;
    int resizeHeight;
    private boolean disableFadeIn;

    private void ensureBuilder() {
        if (this.builder == null) {
            this.builder = new IonRequestBuilder(((ImageView)this.imageViewPostRef.get()).getContext(), this.ion);
        }
    }

    @Override
    public Future<ImageView> load(String uri) {
        this.ensureBuilder();
        this.builder.load(uri);
        return this.intoImageView((ImageView)this.imageViewPostRef.get());
    }

    @Override
    public Future<ImageView> load(String method, String url) {
        this.ensureBuilder();
        this.builder.load(method, url);
        return this.intoImageView((ImageView)this.imageViewPostRef.get());
    }

    IonBitmapRequestBuilder withImageView(ImageView imageView) {
        this.imageViewPostRef = new WeakReference<ImageView>(imageView);
        return this;
    }

    public IonBitmapRequestBuilder(IonRequestBuilder builder) {
        this.builder = builder;
        this.ion = builder.ion;
    }

    public IonBitmapRequestBuilder(Ion ion) {
        this.ion = ion;
    }

    @Override
    public IonBitmapRequestBuilder transform(Transform transform) {
        if (this.transforms == null) {
            this.transforms = new ArrayList();
        }
        this.transforms.add(transform);
        return this;
    }

    BitmapInfo execute() {
        BitmapInfo bitmap;
        boolean hasTransforms;
        final String downloadKey = ResponseCacheMiddleware.toKeyString((String)this.builder.uri);
        assert (Thread.currentThread() == Looper.getMainLooper().getThread());
        assert (downloadKey != null);
        if (this.resizeHeight != 0 || this.resizeWidth != 0) {
            this.transform(new DefaultTransform(this.resizeWidth, this.resizeHeight, this.scaleMode));
        }
        this.bitmapKey = downloadKey;
        boolean bl = hasTransforms = this.transforms != null && this.transforms.size() > 0;
        if (hasTransforms) {
            for (Transform transform : this.transforms) {
                this.bitmapKey = this.bitmapKey + transform.key();
            }
            this.bitmapKey = ResponseCacheMiddleware.toKeyString((String)this.bitmapKey);
        }
        if ((bitmap = this.builder.ion.bitmapCache.get(this.bitmapKey)) != null) {
            return bitmap;
        }
        DiskLruCache diskLruCache = this.ion.getResponseCache().getDiskLruCache();
        if (hasTransforms && diskLruCache.containsKey(this.bitmapKey)) {
            BitmapToBitmapInfo.getBitmapSnapshot(this.ion, this.bitmapKey);
            return null;
        }
        if (!this.ion.bitmapsPending.contains(downloadKey)) {
            Future<InputStream> inputStreamFuture = this.builder.execute();
            if (inputStreamFuture != null) {
                inputStreamFuture.setCallback((FutureCallback)new LoadBitmapStream(this.ion, downloadKey, !hasTransforms, this.resizeWidth, this.resizeHeight));
            } else {
                this.builder.setHandler(null);
                IonRequestBuilder.EmitterTransform<ByteBufferList> emitterTransform = this.builder.execute(new ByteBufferListParser(), new Runnable(){

                    @Override
                    public void run() {
                        AsyncServer.post((Handler)Ion.mainHandler, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                IonBitmapRequestBuilder.this.ion.bitmapsPending.remove((Object)downloadKey);
                            }
                        });
                    }
                });
                emitterTransform.setCallback(new LoadBitmap(this.ion, downloadKey, !hasTransforms, this.resizeWidth, this.resizeHeight, emitterTransform));
            }
        }
        if (!hasTransforms) {
            return null;
        }
        if (!this.ion.bitmapsPending.contains(downloadKey) || !this.ion.bitmapsPending.contains(this.bitmapKey)) {
            this.ion.bitmapsPending.add(downloadKey, (Object)new BitmapToBitmapInfo(this.ion, this.bitmapKey, this.transforms));
        }
        return null;
    }

    private IonDrawable setIonDrawable(ImageView imageView, BitmapInfo info, int loadedFrom) {
        IonDrawable ret = IonDrawable.getOrCreateIonDrawable(imageView);
        ret.setBitmap(info, loadedFrom);
        ret.setError(this.errorResource, this.errorDrawable);
        ret.setPlaceholder(this.placeholderResource, this.placeholderDrawable);
        ret.setInAnimation(this.inAnimation, this.inAnimationResource);
        ret.setDisableFadeIn(this.disableFadeIn);
        imageView.setImageDrawable((Drawable)ret);
        return ret;
    }

    @Override
    public Future<ImageView> intoImageView(ImageView imageView) {
        if (imageView == null) {
            throw new IllegalArgumentException("imageView");
        }
        assert (Thread.currentThread() == Looper.getMainLooper().getThread());
        if (this.builder.uri == null) {
            this.bitmapKey = null;
            this.setIonDrawable(imageView, null, 0).cancel();
            return FUTURE_IMAGEVIEW_NULL_URI;
        }
        BitmapInfo info = this.execute();
        if (info != null) {
            IonBitmapRequestBuilder.doAnimation(imageView, null, 0);
            IonDrawable drawable = this.setIonDrawable(imageView, info, 0);
            drawable.cancel();
            SimpleFuture<ImageView> imageViewFuture = drawable.getFuture();
            imageViewFuture.reset();
            imageViewFuture.setComplete((Object)imageView);
            return imageViewFuture;
        }
        IonDrawable drawable = this.setIonDrawable(imageView, null, 0);
        IonBitmapRequestBuilder.doAnimation(imageView, this.loadAnimation, this.loadAnimationResource);
        SimpleFuture<ImageView> imageViewFuture = drawable.getFuture();
        imageViewFuture.reset();
        drawable.register(this.ion, this.bitmapKey);
        return imageViewFuture;
    }

    @Override
    public Future<Bitmap> asBitmap() {
        if (this.builder.uri == null) {
            return FUTURE_BITMAP_NULL_URI;
        }
        BitmapInfo info = this.execute();
        if (info != null) {
            SimpleFuture ret = new SimpleFuture();
            ret.setComplete((Object)info.bitmap);
            return ret;
        }
        BitmapInfoToBitmap ret = new BitmapInfoToBitmap();
        this.ion.bitmapsPending.add(this.bitmapKey, (Object)ret);
        return ret;
    }

    @Override
    public IonBitmapRequestBuilder placeholder(Drawable drawable) {
        this.placeholderDrawable = drawable;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder placeholder(int resourceId) {
        this.placeholderResource = resourceId;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder error(Drawable drawable) {
        this.errorDrawable = drawable;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder error(int resourceId) {
        this.errorResource = resourceId;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder animateIn(Animation in) {
        this.inAnimation = in;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder animateLoad(Animation load) {
        this.loadAnimation = load;
        return this;
    }

    static void doAnimation(ImageView imageView, Animation animation, int animationResource) {
        if (imageView == null) {
            return;
        }
        if (animation == null && animationResource != 0) {
            animation = AnimationUtils.loadAnimation((Context)imageView.getContext(), (int)animationResource);
        }
        if (animation == null) {
            imageView.setAnimation(null);
            return;
        }
        imageView.startAnimation(animation);
    }

    @Override
    public IonBitmapRequestBuilder animateLoad(int animationResource) {
        this.loadAnimationResource = animationResource;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder animateIn(int animationResource) {
        this.inAnimationResource = animationResource;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder centerCrop() {
        if (this.resizeWidth == 0 || this.resizeHeight == 0) {
            throw new IllegalStateException("must call resize first");
        }
        this.scaleMode = ScaleMode.CenterCrop;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder centerInside() {
        if (this.resizeWidth == 0 || this.resizeHeight == 0) {
            throw new IllegalStateException("must call resize first");
        }
        this.scaleMode = ScaleMode.CenterInside;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder resize(int width, int height) {
        this.resizeWidth = width;
        this.resizeHeight = height;
        return this;
    }

    @Override
    public IonBitmapRequestBuilder disableFadeIn() {
        this.disableFadeIn = true;
        return this;
    }

    void reset() {
        this.placeholderDrawable = null;
        this.placeholderResource = 0;
        this.errorDrawable = null;
        this.errorResource = 0;
        this.ion = null;
        this.imageViewPostRef = null;
        this.transforms = null;
        this.bitmapKey = null;
        this.inAnimation = null;
        this.inAnimationResource = 0;
        this.loadAnimation = null;
        this.loadAnimationResource = 0;
        this.scaleMode = ScaleMode.FitXY;
        this.resizeWidth = 0;
        this.resizeHeight = 0;
        this.disableFadeIn = false;
        this.builder = null;
    }

    private static class BitmapInfoToBitmap
    extends TransformFuture<Bitmap, BitmapInfo> {
        private BitmapInfoToBitmap() {
        }

        protected void transform(BitmapInfo result) throws Exception {
            this.setComplete(result.bitmap);
        }
    }
}

