/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.preso;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.view.Display;

public class PresentationHelper
implements DisplayManager.DisplayListener {
    private Listener listener = null;
    private DisplayManager mgr = null;
    private Context ctxt = null;
    private Display current = null;
    private boolean isFirstRun = true;
    private boolean isEnabled = true;

    public PresentationHelper(Context ctxt, Listener listener) {
        this.ctxt = ctxt;
        this.listener = listener;
    }

    public void onResume() {
        if (Build.VERSION.SDK_INT >= 17) {
            this.mgr = (DisplayManager)this.ctxt.getSystemService("display");
            this.handleRoute();
            this.mgr.registerDisplayListener((DisplayManager.DisplayListener)this, null);
        }
    }

    public void onPause() {
        if (Build.VERSION.SDK_INT >= 17) {
            this.listener.clearPreso(false);
            this.current = null;
            this.mgr.unregisterDisplayListener((DisplayManager.DisplayListener)this);
        }
    }

    public void enable() {
        this.isEnabled = true;
        this.handleRoute();
    }

    public void disable() {
        this.isEnabled = false;
        if (this.current != null) {
            this.listener.clearPreso(true);
            this.current = null;
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private void handleRoute() {
        if (this.isEnabled()) {
            Display[] displays = this.mgr.getDisplays("android.hardware.display.category.PRESENTATION");
            if (displays.length == 0) {
                if (this.current != null || this.isFirstRun) {
                    this.listener.clearPreso(true);
                    this.current = null;
                }
            } else {
                Display display = displays[0];
                if (display != null && display.isValid()) {
                    if (this.current == null) {
                        this.listener.showPreso(display);
                        this.current = display;
                    } else if (this.current.getDisplayId() != display.getDisplayId()) {
                        this.listener.clearPreso(true);
                        this.listener.showPreso(display);
                        this.current = display;
                    }
                } else if (this.current != null) {
                    this.listener.clearPreso(true);
                    this.current = null;
                }
            }
            this.isFirstRun = false;
        }
    }

    public void onDisplayAdded(int displayId) {
        this.handleRoute();
    }

    public void onDisplayChanged(int displayId) {
        this.handleRoute();
    }

    public void onDisplayRemoved(int displayId) {
        this.handleRoute();
    }

    public static interface Listener {
        public void showPreso(Display var1);

        public void clearPreso(boolean var1);
    }
}

