/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.layouts;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import com.commonsware.cwac.layouts.AspectLockedFrameLayout;
import com.commonsware.cwac.layouts.MirrorSink;

public class MirroringFrameLayout
extends AspectLockedFrameLayout
implements ViewTreeObserver.OnPreDrawListener,
ViewTreeObserver.OnScrollChangedListener {
    private MirrorSink mirror = null;
    private Bitmap bmp = null;
    private Canvas bmpBackedCanvas = null;
    private Rect rect = new Rect();

    public MirroringFrameLayout(Context context) {
        this(context, null);
    }

    public MirroringFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
    }

    public void setMirror(MirrorSink mirror) {
        this.mirror = mirror;
        if (mirror != null) {
            this.setAspectRatioSource(mirror);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.getViewTreeObserver().addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
    }

    public void onDetachedFromWindow() {
        this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.getViewTreeObserver().removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        super.onDetachedFromWindow();
    }

    public void draw(Canvas canvas) {
        if (this.mirror != null) {
            this.bmp.eraseColor(0);
            super.draw(this.bmpBackedCanvas);
            this.getDrawingRect(this.rect);
            canvas.drawBitmap(this.bmp, null, this.rect, null);
            this.mirror.update(this.bmp);
        } else {
            super.draw(canvas);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.initBitmap(w, h);
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean onPreDraw() {
        if (this.mirror != null) {
            if (this.bmp == null) {
                this.requestLayout();
            } else {
                this.invalidate();
            }
        }
        return true;
    }

    public void onScrollChanged() {
        this.onPreDraw();
    }

    private void initBitmap(int w, int h) {
        if (this.mirror != null && (this.bmp == null || this.bmp.getWidth() != w || this.bmp.getHeight() != h)) {
            if (this.bmp != null) {
                this.bmp.recycle();
            }
            this.bmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.bmpBackedCanvas = new Canvas(this.bmp);
        }
    }
}

