/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.layouts;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public class AspectLockedFrameLayout
extends FrameLayout {
    private double aspectRatio = 0.0;
    private AspectRatioSource aspectRatioSource = null;

    public AspectLockedFrameLayout(Context context) {
        super(context);
    }

    public AspectLockedFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        double localRatio = this.aspectRatio;
        if (localRatio == 0.0 && this.aspectRatioSource != null && this.aspectRatioSource.getHeight() > 0) {
            localRatio = (double)this.aspectRatioSource.getWidth() / (double)this.aspectRatioSource.getHeight();
        }
        if (localRatio == 0.0) {
            super.onMeasure(widthSpec, heightSpec);
        } else {
            int lockedWidth = View.MeasureSpec.getSize((int)widthSpec);
            int lockedHeight = View.MeasureSpec.getSize((int)heightSpec);
            if (lockedWidth == 0 && lockedHeight == 0) {
                throw new IllegalArgumentException("Both width and height cannot be zero -- watch out for scrollable containers");
            }
            int hPadding = this.getPaddingLeft() + this.getPaddingRight();
            int vPadding = this.getPaddingTop() + this.getPaddingBottom();
            lockedWidth -= hPadding;
            if ((lockedHeight -= vPadding) > 0 && (double)lockedWidth > (double)lockedHeight * localRatio) {
                lockedWidth = (int)((double)lockedHeight * localRatio + 0.5);
            } else {
                lockedHeight = (int)((double)lockedWidth / localRatio + 0.5);
            }
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)(lockedWidth += hPadding), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(lockedHeight += vPadding), (int)0x40000000));
        }
    }

    public void setAspectRatioSource(View v) {
        this.aspectRatioSource = new ViewAspectRatioSource(v);
    }

    public void setAspectRatioSource(AspectRatioSource aspectRatioSource) {
        this.aspectRatioSource = aspectRatioSource;
    }

    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio <= 0.0) {
            throw new IllegalArgumentException("aspect ratio must be positive");
        }
        if (this.aspectRatio != aspectRatio) {
            this.aspectRatio = aspectRatio;
            this.requestLayout();
        }
    }

    private static class ViewAspectRatioSource
    implements AspectRatioSource {
        private View v = null;

        ViewAspectRatioSource(View v) {
            this.v = v;
        }

        @Override
        public int getWidth() {
            return this.v.getWidth();
        }

        @Override
        public int getHeight() {
            return this.v.getHeight();
        }
    }

    public static interface AspectRatioSource {
        public int getWidth();

        public int getHeight();
    }
}

