/*
 * Decompiled with CFR 0.152.
 */
package retrofit.mime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class TypedFile
implements TypedInput,
TypedOutput {
    private static final int BUFFER_SIZE = 4096;
    private final String mimeType;
    private final File file;

    public TypedFile(String mimeType, File file) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.mimeType = mimeType;
        this.file = file;
    }

    public File file() {
        return this.file;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public String fileName() {
        return this.file.getName();
    }

    @Override
    public InputStream in() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(this.file);
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            in.close();
        }
    }

    public void moveTo(TypedFile destination) throws IOException {
        if (!this.mimeType().equals(destination.mimeType())) {
            throw new IOException("Type mismatch.");
        }
        if (!this.file.renameTo(destination.file())) {
            throw new IOException("Rename failed!");
        }
    }

    public String toString() {
        return this.file.getAbsolutePath() + " (" + this.mimeType() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TypedFile) {
            TypedFile rhs = (TypedFile)o;
            return this.file.equals(rhs.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

