/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.media.AudioManager;
import com.phonegap.AudioPlayer;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public class AudioHandler
extends Plugin {
    HashMap<String, AudioPlayer> players = new HashMap();

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("startRecordingAudio")) {
                this.startRecordingAudio(args.getString(0), args.getString(1));
            } else if (action.equals("stopRecordingAudio")) {
                this.stopRecordingAudio(args.getString(0));
            } else if (action.equals("startPlayingAudio")) {
                this.startPlayingAudio(args.getString(0), args.getString(1));
            } else if (action.equals("pausePlayingAudio")) {
                this.pausePlayingAudio(args.getString(0));
            } else if (action.equals("stopPlayingAudio")) {
                this.stopPlayingAudio(args.getString(0));
            } else {
                if (action.equals("getCurrentPositionAudio")) {
                    long l = this.getCurrentPositionAudio(args.getString(0));
                    return new PluginResult(status, l);
                }
                if (action.equals("getDurationAudio")) {
                    long l = this.getDurationAudio(args.getString(0), args.getString(1));
                    return new PluginResult(status, l);
                }
                if (action.equals("release")) {
                    boolean b = this.release(args.getString(0));
                    return new PluginResult(status, b);
                }
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        if (action.equals("getCurrentPositionAudio")) {
            return true;
        }
        return action.equals("getDurationAudio");
    }

    public void onDestroy() {
        Set<Map.Entry<String, AudioPlayer>> s = this.players.entrySet();
        for (Map.Entry<String, AudioPlayer> entry : s) {
            AudioPlayer audio = entry.getValue();
            audio.destroy();
        }
        this.players.clear();
    }

    private boolean release(String id) {
        if (!this.players.containsKey(id)) {
            return false;
        }
        AudioPlayer audio = this.players.get(id);
        this.players.remove(id);
        audio.destroy();
        return true;
    }

    public void startRecordingAudio(String id, String file) {
        if (this.players.containsKey(id)) {
            return;
        }
        AudioPlayer audio = new AudioPlayer(this, id);
        this.players.put(id, audio);
        audio.startRecording(file);
    }

    public void stopRecordingAudio(String id) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            audio.stopRecording();
            this.players.remove(id);
        }
    }

    public void startPlayingAudio(String id, String file) {
        AudioPlayer audio = this.players.get(id);
        if (audio == null) {
            audio = new AudioPlayer(this, id);
            this.players.put(id, audio);
        }
        audio.startPlaying(file);
    }

    public void pausePlayingAudio(String id) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            audio.pausePlaying();
        }
    }

    public void stopPlayingAudio(String id) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            audio.stopPlaying();
        }
    }

    public long getCurrentPositionAudio(String id) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            return audio.getCurrentPosition();
        }
        return -1L;
    }

    public long getDurationAudio(String id, String file) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            return audio.getDuration(file);
        }
        audio = new AudioPlayer(this, id);
        this.players.put(id, audio);
        return audio.getDuration(file);
    }

    public void setAudioOutputDevice(int output) {
        AudioManager audiMgr = (AudioManager)this.ctx.getSystemService("audio");
        if (output == 2) {
            audiMgr.setRouting(0, 2, -1);
        } else if (output == 1) {
            audiMgr.setRouting(0, 1, -1);
        } else {
            System.out.println("AudioHandler.setAudioOutputDevice() Error: Unknown output device.");
        }
    }

    public int getAudioOutputDevice() {
        AudioManager audiMgr = (AudioManager)this.ctx.getSystemService("audio");
        if (audiMgr.getRouting(0) == 1) {
            return 1;
        }
        if (audiMgr.getRouting(0) == 2) {
            return 2;
        }
        return -1;
    }
}

