/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import retrofit.RequestInterceptor;
import retrofit.RestMethodInfo;
import retrofit.client.Request;
import retrofit.converter.Converter;
import retrofit.http.Body;
import retrofit.http.EncodedPath;
import retrofit.http.EncodedQuery;
import retrofit.http.EncodedQueryMap;
import retrofit.http.Field;
import retrofit.http.FieldMap;
import retrofit.http.Header;
import retrofit.http.Part;
import retrofit.http.PartMap;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.QueryMap;
import retrofit.mime.FormUrlEncodedTypedOutput;
import retrofit.mime.MultipartTypedOutput;
import retrofit.mime.TypedOutput;
import retrofit.mime.TypedString;

final class RequestBuilder
implements RequestInterceptor.RequestFacade {
    private final Converter converter;
    private final Annotation[] paramAnnotations;
    private final String requestMethod;
    private final boolean isSynchronous;
    private final boolean isObservable;
    private final String apiUrl;
    private final FormUrlEncodedTypedOutput formBody;
    private final MultipartTypedOutput multipartBody;
    private TypedOutput body;
    private String relativeUrl;
    private StringBuilder queryParams;
    private List<retrofit.client.Header> headers;
    private String contentTypeHeader;

    RequestBuilder(String apiUrl, RestMethodInfo methodInfo, Converter converter) {
        this.apiUrl = apiUrl;
        this.converter = converter;
        this.paramAnnotations = methodInfo.requestParamAnnotations;
        this.requestMethod = methodInfo.requestMethod;
        this.isSynchronous = methodInfo.isSynchronous;
        this.isObservable = methodInfo.isObservable;
        if (methodInfo.headers != null) {
            this.headers = new ArrayList<retrofit.client.Header>(methodInfo.headers);
        }
        this.contentTypeHeader = methodInfo.contentTypeHeader;
        this.relativeUrl = methodInfo.requestUrl;
        String requestQuery = methodInfo.requestQuery;
        if (requestQuery != null) {
            this.queryParams = new StringBuilder().append('?').append(requestQuery);
        }
        switch (methodInfo.requestType) {
            case FORM_URL_ENCODED: {
                this.formBody = new FormUrlEncodedTypedOutput();
                this.multipartBody = null;
                this.body = this.formBody;
                break;
            }
            case MULTIPART: {
                this.formBody = null;
                this.multipartBody = new MultipartTypedOutput();
                this.body = this.multipartBody;
                break;
            }
            case SIMPLE: {
                this.formBody = null;
                this.multipartBody = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + (Object)((Object)methodInfo.requestType));
            }
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name must not be null.");
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.contentTypeHeader = value;
            return;
        }
        List<retrofit.client.Header> headers = this.headers;
        if (headers == null) {
            this.headers = headers = new ArrayList<retrofit.client.Header>(2);
        }
        headers.add(new retrofit.client.Header(name, value));
    }

    @Override
    public void addPathParam(String name, String value) {
        this.addPathParam(name, value, true);
    }

    @Override
    public void addEncodedPathParam(String name, String value) {
        this.addPathParam(name, value, false);
    }

    private void addPathParam(String name, String value, boolean urlEncodeValue) {
        if (name == null) {
            throw new IllegalArgumentException("Path replacement name must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Path replacement \"" + name + "\" value must not be null.");
        }
        try {
            if (urlEncodeValue) {
                String encodedValue = URLEncoder.encode(String.valueOf(value), "UTF-8");
                encodedValue = encodedValue.replace("+", "%20");
                this.relativeUrl = this.relativeUrl.replace("{" + name + "}", encodedValue);
            } else {
                this.relativeUrl = this.relativeUrl.replace("{" + name + "}", String.valueOf(value));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert path parameter \"" + name + "\" value to UTF-8:" + value, e);
        }
    }

    @Override
    public void addQueryParam(String name, String value) {
        this.addQueryParam(name, value, false, true);
    }

    @Override
    public void addEncodedQueryParam(String name, String value) {
        this.addQueryParam(name, value, false, false);
    }

    private void addQueryParam(String name, Object value, boolean encodeName, boolean encodeValue) {
        if (value instanceof Iterable) {
            for (Object iterableValue : (Iterable)value) {
                if (iterableValue == null) continue;
                this.addQueryParam(name, iterableValue.toString(), encodeName, encodeValue);
            }
        } else if (value.getClass().isArray()) {
            int arrayLength = Array.getLength(value);
            for (int x = 0; x < arrayLength; ++x) {
                Object arrayValue = Array.get(value, x);
                if (arrayValue == null) continue;
                this.addQueryParam(name, arrayValue.toString(), encodeName, encodeValue);
            }
        } else {
            this.addQueryParam(name, value.toString(), encodeName, encodeValue);
        }
    }

    private void addQueryParam(String name, String value, boolean encodeName, boolean encodeValue) {
        if (name == null) {
            throw new IllegalArgumentException("Query param name must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Query param \"" + name + "\" value must not be null.");
        }
        try {
            StringBuilder queryParams = this.queryParams;
            if (queryParams == null) {
                this.queryParams = queryParams = new StringBuilder();
            }
            queryParams.append(queryParams.length() > 0 ? (char)'&' : '?');
            if (encodeName) {
                name = URLEncoder.encode(name, "UTF-8");
            }
            if (encodeValue) {
                value = URLEncoder.encode(value, "UTF-8");
            }
            queryParams.append(name).append('=').append(value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert query parameter \"" + name + "\" value to UTF-8: " + value, e);
        }
    }

    private void addQueryParamMap(int parameterNumber, Map<?, ?> map, boolean encodeNames, boolean encodeValues) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object entryKey = entry.getKey();
            if (entryKey == null) {
                throw new IllegalArgumentException("Parameter #" + (parameterNumber + 1) + " query map contained null key.");
            }
            Object entryValue = entry.getValue();
            if (entryValue == null) continue;
            this.addQueryParam(entryKey.toString(), entryValue.toString(), encodeNames, encodeValues);
        }
    }

    /*
     * WARNING - void declaration
     */
    void setArguments(Object[] args) {
        if (args == null) {
            return;
        }
        int count = args.length;
        if (!this.isSynchronous && !this.isObservable) {
            --count;
        }
        for (int i = 0; i < count; ++i) {
            Annotation query;
            Object name;
            Object value = args[i];
            Annotation annotation = this.paramAnnotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == Path.class) {
                Path path = (Path)annotation;
                String string = path.value();
                if (value == null) {
                    throw new IllegalArgumentException("Path parameter \"" + string + "\" value must not be null.");
                }
                this.addPathParam(string, value.toString(), path.encode());
                continue;
            }
            if (annotationType == EncodedPath.class) {
                name = ((EncodedPath)annotation).value();
                if (value == null) {
                    throw new IllegalArgumentException("Path parameter \"" + (String)name + "\" value must not be null.");
                }
                this.addPathParam((String)name, value.toString(), false);
                continue;
            }
            if (annotationType == Query.class) {
                if (value == null) continue;
                query = (Query)annotation;
                this.addQueryParam(query.value(), value, query.encodeName(), query.encodeValue());
                continue;
            }
            if (annotationType == EncodedQuery.class) {
                if (value == null) continue;
                query = (EncodedQuery)annotation;
                this.addQueryParam(query.value(), value, false, false);
                continue;
            }
            if (annotationType == QueryMap.class) {
                if (value == null) continue;
                QueryMap queryMap = (QueryMap)annotation;
                this.addQueryParamMap(i, (Map)value, queryMap.encodeNames(), queryMap.encodeValues());
                continue;
            }
            if (annotationType == EncodedQueryMap.class) {
                if (value == null) continue;
                this.addQueryParamMap(i, (Map)value, false, false);
                continue;
            }
            if (annotationType == Header.class) {
                if (value == null) continue;
                name = ((Header)annotation).value();
                this.addHeader((String)name, value.toString());
                continue;
            }
            if (annotationType == Field.class) {
                name = ((Field)annotation).value();
                if (value == null) continue;
                if (value instanceof Iterable) {
                    for (Object iterableValue : (Iterable)value) {
                        if (iterableValue == null) continue;
                        this.formBody.addField((String)name, iterableValue.toString());
                    }
                    continue;
                }
                if (value.getClass().isArray()) {
                    void var8_11;
                    boolean bl = false;
                    int arrayLength = Array.getLength(value);
                    while (var8_11 < arrayLength) {
                        Object arrayValue = Array.get(value, (int)var8_11);
                        if (arrayValue != null) {
                            this.formBody.addField((String)name, arrayValue.toString());
                        }
                        ++var8_11;
                    }
                    continue;
                }
                this.formBody.addField((String)name, value.toString());
                continue;
            }
            if (annotationType == FieldMap.class) {
                if (value == null) continue;
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object entryKey = entry.getKey();
                    if (entryKey == null) {
                        throw new IllegalArgumentException("Parameter #" + (i + 1) + " field map contained null key.");
                    }
                    Object entryValue = entry.getValue();
                    if (entryValue == null) continue;
                    this.formBody.addField(entryKey.toString(), entryValue.toString());
                }
                continue;
            }
            if (annotationType == Part.class) {
                name = ((Part)annotation).value();
                if (value == null) continue;
                String string = ((Part)annotation).encoding();
                if (value instanceof TypedOutput) {
                    this.multipartBody.addPart((String)name, string, (TypedOutput)value);
                    continue;
                }
                if (value instanceof String) {
                    this.multipartBody.addPart((String)name, string, new TypedString((String)value));
                    continue;
                }
                this.multipartBody.addPart((String)name, string, this.converter.toBody(value));
                continue;
            }
            if (annotationType == PartMap.class) {
                if (value == null) continue;
                String transferEncoding = ((PartMap)annotation).encoding();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object entryKey = entry.getKey();
                    if (entryKey == null) {
                        throw new IllegalArgumentException("Parameter #" + (i + 1) + " part map contained null key.");
                    }
                    String entryName = entryKey.toString();
                    Object entryValue = entry.getValue();
                    if (entryValue == null) continue;
                    if (entryValue instanceof TypedOutput) {
                        this.multipartBody.addPart(entryName, transferEncoding, (TypedOutput)entryValue);
                        continue;
                    }
                    if (entryValue instanceof String) {
                        this.multipartBody.addPart(entryName, transferEncoding, new TypedString((String)entryValue));
                        continue;
                    }
                    this.multipartBody.addPart(entryName, transferEncoding, this.converter.toBody(entryValue));
                }
                continue;
            }
            if (annotationType == Body.class) {
                if (value == null) {
                    throw new IllegalArgumentException("Body parameter value must not be null.");
                }
                if (value instanceof TypedOutput) {
                    this.body = (TypedOutput)value;
                    continue;
                }
                this.body = this.converter.toBody(value);
                continue;
            }
            throw new IllegalArgumentException("Unknown annotation: " + annotationType.getCanonicalName());
        }
    }

    Request build() throws UnsupportedEncodingException {
        if (this.multipartBody != null && this.multipartBody.getPartCount() == 0) {
            throw new IllegalStateException("Multipart requests must contain at least one part.");
        }
        String apiUrl = this.apiUrl;
        StringBuilder url = new StringBuilder(apiUrl);
        if (apiUrl.endsWith("/")) {
            url.deleteCharAt(url.length() - 1);
        }
        url.append(this.relativeUrl);
        StringBuilder queryParams = this.queryParams;
        if (queryParams != null) {
            url.append((CharSequence)queryParams);
        }
        TypedOutput body = this.body;
        List<retrofit.client.Header> headers = this.headers;
        if (this.contentTypeHeader != null) {
            if (body != null) {
                body = new MimeOverridingTypedOutput(body, this.contentTypeHeader);
            } else {
                retrofit.client.Header header = new retrofit.client.Header("Content-Type", this.contentTypeHeader);
                if (headers == null) {
                    headers = Collections.singletonList(header);
                } else {
                    headers.add(header);
                }
            }
        }
        return new Request(this.requestMethod, url.toString(), headers, body);
    }

    private static class MimeOverridingTypedOutput
    implements TypedOutput {
        private final TypedOutput delegate;
        private final String mimeType;

        MimeOverridingTypedOutput(TypedOutput delegate, String mimeType) {
            this.delegate = delegate;
            this.mimeType = mimeType;
        }

        @Override
        public String fileName() {
            return this.delegate.fileName();
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        public long length() {
            return this.delegate.length();
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.delegate.writeTo(out);
        }
    }
}

