/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.QName;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Namespace
extends IdScriptableObject {
    static final long serialVersionUID = -5765755238131301744L;
    private static final Object NAMESPACE_TAG = "Namespace";
    private Namespace prototype;
    private XmlNode.Namespace ns;
    private static final int Id_prefix = 1;
    private static final int Id_uri = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;

    private Namespace() {
    }

    static Namespace create(Scriptable scriptable, Namespace namespace, XmlNode.Namespace namespace2) {
        Namespace namespace3 = new Namespace();
        namespace3.setParentScope(scriptable);
        namespace3.prototype = namespace;
        namespace3.setPrototype(namespace);
        namespace3.ns = namespace2;
        return namespace3;
    }

    final XmlNode.Namespace getDelegate() {
        return this.ns;
    }

    public void exportAsJSClass(boolean bl) {
        this.exportAsJSClass(3, this.getParentScope(), bl);
    }

    public String uri() {
        return this.ns.getUri();
    }

    public String prefix() {
        return this.ns.getPrefix();
    }

    public String toString() {
        return this.uri();
    }

    public String toLocaleString() {
        return this.toString();
    }

    private boolean equals(Namespace namespace) {
        return this.uri().equals(namespace.uri());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Namespace)) {
            return false;
        }
        return this.equals((Namespace)object);
    }

    @Override
    protected Object equivalentValues(Object object) {
        if (!(object instanceof Namespace)) {
            return Scriptable.NOT_FOUND;
        }
        boolean bl = this.equals((Namespace)object);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public String getClassName() {
        return "Namespace";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return this.uri();
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        int n3 = string.length();
        if (n3 == 3) {
            string2 = "uri";
            n2 = 2;
        } else if (n3 == 6) {
            string2 = "prefix";
            n2 = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: 
            case 2: {
                n = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Namespace.instanceIdInfo(n, super.getMaxInstanceId() + n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return "prefix";
            }
            case 2: {
                return "uri";
            }
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                if (this.ns.getPrefix() == null) {
                    return Undefined.instance;
                }
                return this.ns.getPrefix();
            }
            case 2: {
                return this.ns.getUri();
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block6: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 8) {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 3;
                } else if (c == 't') {
                    string2 = "toString";
                    n = 2;
                }
            } else if (n2 == 11) {
                string2 = "constructor";
                n = 1;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block6;
            n = 0;
        }
        return n;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(NAMESPACE_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(NAMESPACE_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.jsConstructor(context, scriptable2 == null, objectArray);
            }
            case 2: {
                return this.realThis(scriptable2, idFunctionObject).toString();
            }
            case 3: {
                return this.realThis(scriptable2, idFunctionObject).js_toSource();
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private Namespace realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof Namespace)) {
            throw Namespace.incompatibleCallError(idFunctionObject);
        }
        return (Namespace)scriptable;
    }

    Namespace newNamespace(String string) {
        Namespace namespace = this.prototype == null ? this : this.prototype;
        return Namespace.create(this.getParentScope(), namespace, XmlNode.Namespace.create(string));
    }

    Namespace newNamespace(String string, String string2) {
        if (string == null) {
            return this.newNamespace(string2);
        }
        Namespace namespace = this.prototype == null ? this : this.prototype;
        return Namespace.create(this.getParentScope(), namespace, XmlNode.Namespace.create(string, string2));
    }

    Namespace constructNamespace(Object object) {
        String string;
        String string2;
        if (object instanceof Namespace) {
            Namespace namespace = (Namespace)object;
            string2 = namespace.prefix();
            string = namespace.uri();
        } else if (object instanceof QName) {
            QName qName = (QName)object;
            string = qName.uri();
            if (string != null) {
                string2 = qName.prefix();
            } else {
                string = qName.toString();
                string2 = null;
            }
        } else {
            string = ScriptRuntime.toString(object);
            string2 = string.length() == 0 ? "" : null;
        }
        return this.newNamespace(string2, string);
    }

    Namespace castToNamespace(Object object) {
        if (object instanceof Namespace) {
            return (Namespace)object;
        }
        return this.constructNamespace(object);
    }

    private Namespace constructNamespace(Object object, Object object2) {
        String string;
        String string2;
        if (object2 instanceof QName) {
            QName qName = (QName)object2;
            string2 = qName.uri();
            if (string2 == null) {
                string2 = qName.toString();
            }
        } else {
            string2 = ScriptRuntime.toString(object2);
        }
        if (string2.length() == 0) {
            if (object == Undefined.instance) {
                string = "";
            } else {
                string = ScriptRuntime.toString(object);
                if (string.length() != 0) {
                    throw ScriptRuntime.typeError("Illegal prefix '" + string + "' for 'no namespace'.");
                }
            }
        } else {
            string = object == Undefined.instance ? "" : (!XMLName.accept(object) ? "" : ScriptRuntime.toString(object));
        }
        return this.newNamespace(string, string2);
    }

    private Namespace constructNamespace() {
        return this.newNamespace("", "");
    }

    private Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (!bl && objectArray.length == 1) {
            return this.castToNamespace(objectArray[0]);
        }
        if (objectArray.length == 0) {
            return this.constructNamespace();
        }
        if (objectArray.length == 1) {
            return this.constructNamespace(objectArray[0]);
        }
        return this.constructNamespace(objectArray[0], objectArray[1]);
    }

    private String js_toSource() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Namespace.toSourceImpl(this.ns.getPrefix(), this.ns.getUri(), stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static void toSourceImpl(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append("new Namespace(");
        if (string2.length() == 0) {
            if (!"".equals(string)) {
                throw new IllegalArgumentException(string);
            }
        } else {
            stringBuffer.append('\'');
            if (string != null) {
                stringBuffer.append(ScriptRuntime.escapeString(string, '\''));
                stringBuffer.append("', '");
            }
            stringBuffer.append(ScriptRuntime.escapeString(string2, '\''));
            stringBuffer.append('\'');
        }
        stringBuffer.append(')');
    }
}

