/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.idswitch.CodePrinter;
import org.mozilla.javascript.tools.idswitch.FileBody;
import org.mozilla.javascript.tools.idswitch.IdValuePair;
import org.mozilla.javascript.tools.idswitch.SwitchGenerator;

public class Main {
    private static final String SWITCH_TAG_STR = "string_id_map";
    private static final String GENERATED_TAG_STR = "generated";
    private static final String STRING_TAG_STR = "string";
    private static final int NORMAL_LINE = 0;
    private static final int SWITCH_TAG = 1;
    private static final int GENERATED_TAG = 2;
    private static final int STRING_TAG = 3;
    private final List<IdValuePair> all_pairs = new ArrayList<IdValuePair>();
    private ToolErrorReporter R;
    private CodePrinter P;
    private FileBody body;
    private String source_file;
    private int tag_definition_end;
    private int tag_value_start;
    private int tag_value_end;

    private static boolean is_value_type(int n) {
        return n == 3;
    }

    private static String tag_name(int n) {
        switch (n) {
            case 1: {
                return SWITCH_TAG_STR;
            }
            case -1: {
                return "/string_id_map";
            }
            case 2: {
                return GENERATED_TAG_STR;
            }
            case -2: {
                return "/generated";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process_file(String string) throws IOException {
        Closeable closeable;
        this.source_file = string;
        this.body = new FileBody();
        InputStream inputStream = string.equals("-") ? System.in : new FileInputStream(string);
        try {
            closeable = new InputStreamReader(inputStream, "ASCII");
            this.body.readData((Reader)closeable);
        }
        finally {
            inputStream.close();
        }
        this.process_file();
        if (this.body.wasModified()) {
            closeable = string.equals("-") ? System.out : new FileOutputStream(string);
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)closeable);
                this.body.writeData(outputStreamWriter);
                ((Writer)outputStreamWriter).flush();
            }
            finally {
                ((OutputStream)closeable).close();
            }
        }
    }

    private void process_file() {
        int n = 0;
        char[] cArray = this.body.getBuffer();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        this.body.startLineLoop();
        while (this.body.nextLine()) {
            String string;
            int n6 = this.body.getLineBegin();
            int n7 = this.body.getLineEnd();
            int n8 = this.extract_line_tag_id(cArray, n6, n7);
            boolean bl = false;
            switch (n) {
                case 0: {
                    if (n8 == 1) {
                        n = 1;
                        this.all_pairs.clear();
                        n2 = -1;
                        break;
                    }
                    if (n8 != -1) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (n8 == 0) {
                        this.look_for_id_definitions(cArray, n6, n7, false);
                        break;
                    }
                    if (n8 == 3) {
                        this.look_for_id_definitions(cArray, n6, n7, true);
                        break;
                    }
                    if (n8 == 2) {
                        if (n2 >= 0) {
                            bl = true;
                            break;
                        }
                        n = 2;
                        n4 = this.tag_definition_end;
                        n5 = n7;
                        break;
                    }
                    if (n8 == -1) {
                        n = 0;
                        if (n2 < 0 || this.all_pairs.isEmpty()) break;
                        this.generate_java_code();
                        string = this.P.toString();
                        boolean bl2 = this.body.setReplacement(n2, n3, string);
                        if (!bl2) break;
                        String string2 = this.get_time_stamp();
                        this.body.setReplacement(n4, n5, string2);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 2: {
                    if (n8 == 0) {
                        if (n2 >= 0) break;
                        n2 = n6;
                        break;
                    }
                    if (n8 == -2) {
                        if (n2 < 0) {
                            n2 = n6;
                        }
                        n = 1;
                        n3 = n6;
                        break;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            string = ToolErrorReporter.getMessage("msg.idswitch.bad_tag_order", Main.tag_name(n8));
            throw this.R.runtimeError(string, this.source_file, this.body.getLineNumber(), null, 0);
        }
        if (n != 0) {
            String string = ToolErrorReporter.getMessage("msg.idswitch.file_end_in_switch", Main.tag_name(n));
            throw this.R.runtimeError(string, this.source_file, this.body.getLineNumber(), null, 0);
        }
    }

    private String get_time_stamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(" 'Last update:' yyyy-MM-dd HH:mm:ss z");
        return simpleDateFormat.format(new Date());
    }

    private void generate_java_code() {
        this.P.clear();
        IdValuePair[] idValuePairArray = new IdValuePair[this.all_pairs.size()];
        this.all_pairs.toArray(idValuePairArray);
        SwitchGenerator switchGenerator = new SwitchGenerator();
        switchGenerator.char_tail_test_threshold = 2;
        switchGenerator.setReporter(this.R);
        switchGenerator.setCodePrinter(this.P);
        switchGenerator.generateSwitch(idValuePairArray, "0");
    }

    private int extract_line_tag_id(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n = Main.skip_white_space(cArray, n, n2);
        if ((n = this.look_for_slash_slash(cArray, n, n2)) != n2) {
            boolean bl = n4 + 2 == n;
            if ((n = Main.skip_white_space(cArray, n, n2)) != n2 && cArray[n] == '#') {
                int n5;
                boolean bl2 = false;
                if (++n != n2 && cArray[n] == '/') {
                    ++n;
                    bl2 = true;
                }
                int n6 = n;
                while (n != n2 && (n5 = cArray[n]) != 35 && n5 != 61 && !Main.is_white_space(n5)) {
                    ++n;
                }
                if (n != n2) {
                    char c;
                    n5 = n;
                    if ((n = Main.skip_white_space(cArray, n, n2)) != n2 && ((c = cArray[n]) == '=' || c == '#') && (n3 = this.get_tag_id(cArray, n6, n5, bl)) != 0) {
                        String string = null;
                        if (c == '#') {
                            if (bl2 && Main.is_value_type(n3 = -n3)) {
                                string = "msg.idswitch.no_end_usage";
                            }
                            this.tag_definition_end = n + 1;
                        } else {
                            if (bl2) {
                                string = "msg.idswitch.no_end_with_value";
                            } else if (!Main.is_value_type(n3)) {
                                string = "msg.idswitch.no_value_allowed";
                            }
                            n3 = this.extract_tag_value(cArray, n + 1, n2, n3);
                        }
                        if (string != null) {
                            String string2 = ToolErrorReporter.getMessage(string, Main.tag_name(n3));
                            throw this.R.runtimeError(string2, this.source_file, this.body.getLineNumber(), null, 0);
                        }
                    }
                }
            }
        }
        return n3;
    }

    private int look_for_slash_slash(char[] cArray, int n, int n2) {
        while (n + 2 <= n2) {
            char c;
            if ((c = cArray[n++]) != '/' || (c = cArray[n++]) != '/') continue;
            return n;
        }
        return n2;
    }

    private int extract_tag_value(char[] cArray, int n, int n2, int n3) {
        boolean bl = false;
        if ((n = Main.skip_white_space(cArray, n, n2)) != n2) {
            int n4 = n;
            int n5 = n;
            while (n != n2) {
                char c = cArray[n];
                if (Main.is_white_space(c)) {
                    int n6 = Main.skip_white_space(cArray, n + 1, n2);
                    if (n6 != n2 && cArray[n6] == '#') {
                        n5 = n;
                        n = n6;
                        break;
                    }
                    n = n6 + 1;
                    continue;
                }
                if (c == '#') {
                    n5 = n;
                    break;
                }
                ++n;
            }
            if (n != n2) {
                bl = true;
                this.tag_value_start = n4;
                this.tag_value_end = n5;
                this.tag_definition_end = n + 1;
            }
        }
        return bl ? n3 : 0;
    }

    private int get_tag_id(char[] cArray, int n, int n2, boolean bl) {
        if (bl) {
            if (Main.equals(SWITCH_TAG_STR, cArray, n, n2)) {
                return 1;
            }
            if (Main.equals(GENERATED_TAG_STR, cArray, n, n2)) {
                return 2;
            }
        }
        if (Main.equals(STRING_TAG_STR, cArray, n, n2)) {
            return 3;
        }
        return 0;
    }

    private void look_for_id_definitions(char[] cArray, int n, int n2, boolean bl) {
        int n3 = n;
        int n4 = n3 = Main.skip_white_space(cArray, n3, n2);
        int n5 = Main.skip_matched_prefix("Id_", cArray, n3, n2);
        if (n5 >= 0) {
            n3 = n5;
            int n6 = n3 = Main.skip_name_char(cArray, n3, n2);
            if (n5 != n6 && (n3 = Main.skip_white_space(cArray, n3, n2)) != n2 && cArray[n3] == '=') {
                int n7 = n6;
                if (bl) {
                    n5 = this.tag_value_start;
                    n6 = this.tag_value_end;
                }
                this.add_id(cArray, n4, n7, n5, n6);
            }
        }
    }

    private void add_id(char[] cArray, int n, int n2, int n3, int n4) {
        String string = new String(cArray, n3, n4 - n3);
        String string2 = new String(cArray, n, n2 - n);
        IdValuePair idValuePair = new IdValuePair(string, string2);
        idValuePair.setLineNumber(this.body.getLineNumber());
        this.all_pairs.add(idValuePair);
    }

    private static boolean is_white_space(int n) {
        return n == 32 || n == 9;
    }

    private static int skip_white_space(char[] cArray, int n, int n2) {
        char c;
        int n3;
        for (n3 = n; n3 != n2 && Main.is_white_space(c = cArray[n3]); ++n3) {
        }
        return n3;
    }

    private static int skip_matched_prefix(String string, char[] cArray, int n, int n2) {
        int n3 = -1;
        int n4 = string.length();
        if (n4 <= n2 - n) {
            n3 = n;
            int n5 = 0;
            while (n5 != n4) {
                if (string.charAt(n5) != cArray[n3]) {
                    n3 = -1;
                    break;
                }
                ++n5;
                ++n3;
            }
        }
        return n3;
    }

    private static boolean equals(String string, char[] cArray, int n, int n2) {
        if (string.length() == n2 - n) {
            int n3 = n;
            int n4 = 0;
            while (n3 != n2) {
                if (cArray[n3] != string.charAt(n4)) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            return true;
        }
        return false;
    }

    private static int skip_name_char(char[] cArray, int n, int n2) {
        char c;
        int n3;
        for (n3 = n; n3 != n2 && ('a' <= (c = cArray[n3]) && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_'); ++n3) {
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        int n = main.exec(stringArray);
        System.exit(n);
    }

    private int exec(String[] stringArray) {
        this.R = new ToolErrorReporter(true, System.err);
        int n = this.process_options(stringArray);
        if (n == 0) {
            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.no_file_argument"));
            return -1;
        }
        if (n > 1) {
            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.too_many_arguments"));
            return -1;
        }
        this.P = new CodePrinter();
        this.P.setIndentStep(4);
        this.P.setIndentTabSize(0);
        try {
            this.process_file(stringArray[0]);
        }
        catch (IOException iOException) {
            this.print_error(ToolErrorReporter.getMessage("msg.idswitch.io_error", iOException.toString()));
            return -1;
        }
        catch (EvaluatorException evaluatorException) {
            return -1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int process_options(String[] stringArray) {
        int n = 1;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = stringArray.length;
        block3: for (int i = 0; i != n2; ++i) {
            block14: {
                int n3;
                String string;
                block15: {
                    string = stringArray[i];
                    n3 = string.length();
                    if (n3 < 2 || string.charAt(0) != '-') continue;
                    if (string.charAt(1) != '-') break block15;
                    if (n3 == 2) {
                        stringArray[i] = null;
                        break;
                    }
                    if (string.equals("--help")) {
                        bl = true;
                        break block14;
                    } else if (string.equals("--version")) {
                        bl2 = true;
                        break block14;
                    } else {
                        this.option_error(ToolErrorReporter.getMessage("msg.idswitch.bad_option", string));
                        n = -1;
                        break;
                    }
                }
                block4: for (int j = 1; j != n3; ++j) {
                    char c = string.charAt(j);
                    switch (c) {
                        case 'h': {
                            bl = true;
                            continue block4;
                        }
                        default: {
                            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.bad_option_char", String.valueOf(c)));
                            n = -1;
                            break block3;
                        }
                    }
                }
            }
            stringArray[i] = null;
        }
        if (n == 1) {
            if (bl) {
                this.show_usage();
                n = 0;
            }
            if (bl2) {
                this.show_version();
                n = 0;
            }
        }
        if (n != 1) {
            System.exit(n);
        }
        return this.remove_nulls(stringArray);
    }

    private void show_usage() {
        System.out.println(ToolErrorReporter.getMessage("msg.idswitch.usage"));
        System.out.println();
    }

    private void show_version() {
        System.out.println(ToolErrorReporter.getMessage("msg.idswitch.version"));
    }

    private void option_error(String string) {
        this.print_error(ToolErrorReporter.getMessage("msg.idswitch.bad_invocation", string));
    }

    private void print_error(String string) {
        System.err.println(string);
    }

    private int remove_nulls(String[] stringArray) {
        int n;
        int n2 = stringArray.length;
        for (n = 0; n != n2 && stringArray[n] != null; ++n) {
        }
        int n3 = n;
        if (n != n2) {
            ++n;
            while (n != n2) {
                String string = stringArray[n];
                if (string != null) {
                    stringArray[n3] = string;
                    ++n3;
                }
                ++n;
            }
        }
        return n3;
    }
}

