/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.mozilla.javascript.tools.debugger.SwingGui;

class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2971618907207577000L;
    private SwingGui debugGui;
    private List<String> expressions;
    private List<String> values;

    public MyTableModel(SwingGui swingGui) {
        this.debugGui = swingGui;
        this.expressions = Collections.synchronizedList(new ArrayList());
        this.values = Collections.synchronizedList(new ArrayList());
        this.expressions.add("");
        this.values.add("");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.expressions.size();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Expression";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.expressions.get(n);
            }
            case 1: {
                return this.values.get(n);
            }
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                String string = object.toString();
                this.expressions.set(n, string);
                String string2 = "";
                if (string.length() > 0 && (string2 = this.debugGui.dim.eval(string)) == null) {
                    string2 = "";
                }
                this.values.set(n, string2);
                this.updateModel();
                if (n + 1 != this.expressions.size()) break;
                this.expressions.add("");
                this.values.add("");
                this.fireTableRowsInserted(n + 1, n + 1);
                break;
            }
            case 1: {
                this.fireTableDataChanged();
            }
        }
    }

    void updateModel() {
        for (int i = 0; i < this.expressions.size(); ++i) {
            String string = this.expressions.get(i);
            String string2 = "";
            if (string.length() > 0) {
                string2 = this.debugGui.dim.eval(string);
                if (string2 == null) {
                    string2 = "";
                }
            } else {
                string2 = "";
            }
            string2 = string2.replace('\n', ' ');
            this.values.set(i, string2);
        }
        this.fireTableDataChanged();
    }
}

