/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.phonegap.api.PhonegapActivity;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;

public class NetworkManager
extends Plugin {
    public static int NOT_REACHABLE = 0;
    public static int REACHABLE_VIA_CARRIER_DATA_NETWORK = 1;
    public static int REACHABLE_VIA_WIFI_NETWORK = 2;
    ConnectivityManager sockMan;

    public void setContext(PhonegapActivity ctx) {
        super.setContext(ctx);
        this.sockMan = (ConnectivityManager)ctx.getSystemService("connectivity");
    }

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("isAvailable")) {
                boolean b = this.isAvailable();
                return new PluginResult(status, b);
            }
            if (action.equals("isWifiActive")) {
                boolean b = this.isWifiActive();
                return new PluginResult(status, b);
            }
            if (action.equals("isReachable")) {
                int i = this.isReachable(args.getString(0), args.getBoolean(1));
                return new PluginResult(status, i);
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        return false;
    }

    public boolean isAvailable() {
        NetworkInfo info = this.sockMan.getActiveNetworkInfo();
        boolean conn = false;
        if (info != null) {
            conn = info.isConnected();
        }
        return conn;
    }

    public boolean isWifiActive() {
        NetworkInfo info = this.sockMan.getActiveNetworkInfo();
        if (info != null) {
            String type = info.getTypeName();
            return type.equals("WIFI");
        }
        return false;
    }

    public int isReachable(String uri, boolean isIpAddress) {
        int reachable = NOT_REACHABLE;
        if (uri.indexOf("http://") == -1) {
            uri = "http://" + uri;
        }
        if (this.isAvailable()) {
            try {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpGet httpget = new HttpGet(uri);
                httpclient.execute((HttpUriRequest)httpget);
                reachable = this.isWifiActive() ? REACHABLE_VIA_WIFI_NETWORK : REACHABLE_VIA_CARRIER_DATA_NETWORK;
            }
            catch (Exception e) {
                reachable = NOT_REACHABLE;
            }
        }
        return reachable;
    }
}

