/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Picture;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.GeolocationPermissions;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import com.phonegap.BrowserKey;
import com.phonegap.CallbackServer;
import com.phonegap.WebViewReflect;
import com.phonegap.api.PhonegapActivity;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginManager;
import org.json.JSONArray;

public class DroidGap
extends PhonegapActivity {
    protected WebView appView;
    protected WebViewClient webViewClient;
    private LinearLayout root;
    private BrowserKey mKey;
    public CallbackServer callbackServer;
    protected PluginManager pluginManager;
    protected boolean cancelLoadUrl = false;
    protected boolean clearHistory = false;
    private String url;
    private String baseUrl;
    private Plugin activityResultCallback = null;
    private boolean activityResultKeepRunning;
    private int loadUrlTimeout = 0;
    protected boolean hideLoadingDialogOnPageLoad = false;
    protected boolean loadInWebView = false;
    protected int splashscreen = 0;
    protected int loadUrlTimeoutValue = 20000;
    protected boolean keepRunning = true;

    public void onCreate(Bundle savedInstanceState) {
        String url;
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(1);
        this.getWindow().setFlags(2048, 2048);
        this.root = new LinearLayout((Context)this);
        this.root.setOrientation(1);
        this.root.setBackgroundColor(-16777216);
        this.root.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.0f));
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null && (url = bundle.getString("url")) != null) {
            this.init();
        }
        this.setVolumeControlStream(3);
    }

    public void init() {
        this.appView = new WebView((Context)this);
        this.appView.setId(100);
        this.appView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        WebViewReflect.checkCompatibility();
        if (Build.VERSION.RELEASE.startsWith("2.")) {
            this.appView.setWebChromeClient((WebChromeClient)new EclairClient((Context)this));
        } else {
            this.appView.setWebChromeClient((WebChromeClient)new GapClient((Context)this));
        }
        this.setWebViewClient(this.appView, new GapViewClient(this));
        this.appView.setInitialScale(100);
        this.appView.setVerticalScrollBarEnabled(false);
        this.appView.requestFocusFromTouch();
        WebSettings settings = this.appView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        Package pack = ((Object)((Object)this)).getClass().getPackage();
        String appPackage = pack.getName();
        WebViewReflect.setStorage(settings, true, "/data/data/" + appPackage + "/app_database/");
        WebViewReflect.setDomStorage(settings);
        WebViewReflect.setGeolocationEnabled(settings, true);
        this.bindBrowser(this.appView);
        this.root.addView((View)this.appView);
        this.setContentView((View)this.root);
        this.cancelLoadUrl = false;
        String url = this.getStringProperty("url", null);
        if (url != null) {
            System.out.println("Loading initial URL=" + url);
            this.loadUrl(url);
        }
    }

    protected void setWebViewClient(WebView appView, WebViewClient client) {
        this.webViewClient = client;
        appView.setWebViewClient(client);
    }

    private void bindBrowser(WebView appView) {
        this.callbackServer = new CallbackServer();
        this.pluginManager = new PluginManager(appView, this);
        this.mKey = new BrowserKey(appView, this);
        appView.addJavascriptInterface((Object)this.pluginManager, "PluginManager");
        appView.addJavascriptInterface((Object)this.mKey, "BackButton");
        appView.addJavascriptInterface((Object)this.callbackServer, "CallbackServer");
        this.addService("App", "com.phonegap.App");
        this.addService("Geolocation", "com.phonegap.GeoBroker");
        this.addService("Device", "com.phonegap.Device");
        this.addService("Accelerometer", "com.phonegap.AccelListener");
        this.addService("Compass", "com.phonegap.CompassListener");
        this.addService("Media", "com.phonegap.AudioHandler");
        this.addService("Camera", "com.phonegap.CameraLauncher");
        this.addService("Contacts", "com.phonegap.ContactManager");
        this.addService("Crypto", "com.phonegap.CryptoHandler");
        this.addService("File", "com.phonegap.FileUtils");
        this.addService("Location", "com.phonegap.GeoBroker");
        this.addService("Network Status", "com.phonegap.NetworkManager");
        this.addService("Notification", "com.phonegap.Notification");
        this.addService("Storage", "com.phonegap.Storage");
        this.addService("Temperature", "com.phonegap.TempListener");
        this.addService("FileTransfer", "com.phonegap.FileTransfer");
    }

    private void handleActivityParameters() {
        if (this.appView == null) {
            this.init();
        }
        this.splashscreen = this.getIntegerProperty("splashscreen", 0);
        if (this.splashscreen != 0) {
            this.appView.setBackgroundColor(0);
            this.appView.setBackgroundResource(this.splashscreen);
        }
        this.hideLoadingDialogOnPageLoad = this.getBooleanProperty("hideLoadingDialogOnPageLoad", false);
        this.loadInWebView = this.getBooleanProperty("loadInWebView", false);
        int timeout = this.getIntegerProperty("loadUrlTimeoutValue", 0);
        if (timeout > 0) {
            this.loadUrlTimeoutValue = timeout;
        }
        this.keepRunning = this.getBooleanProperty("keepRunning", true);
    }

    public void loadUrl(final String url) {
        System.out.println("loadUrl(" + url + ")");
        this.url = url;
        int i = url.lastIndexOf(47);
        this.baseUrl = i > 0 ? url.substring(0, i) : this.url;
        System.out.println("url=" + url + " baseUrl=" + this.baseUrl);
        final DroidGap me = this;
        this.runOnUiThread(new Runnable(){

            public void run() {
                me.handleActivityParameters();
                me.callbackServer.init(url);
                String loading = me.getStringProperty("loadingDialog", null);
                if (loading != null) {
                    String title = "";
                    String message = "Loading Application...";
                    if (loading.length() > 0) {
                        int comma = loading.indexOf(44);
                        if (comma > 0) {
                            title = loading.substring(0, comma);
                            message = loading.substring(comma + 1);
                        } else {
                            title = "";
                            message = loading;
                        }
                    }
                    JSONArray parm = new JSONArray();
                    parm.put((Object)title);
                    parm.put((Object)message);
                    me.pluginManager.exec("Notification", "activityStart", null, parm.toString(), false);
                }
                final int currentLoadUrlTimeout = me.loadUrlTimeout;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(me.loadUrlTimeoutValue);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (me.loadUrlTimeout == currentLoadUrlTimeout) {
                            me.appView.stopLoading();
                            me.webViewClient.onReceivedError(me.appView, -6, "The connection to the server was unsuccessful.", url);
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
                me.appView.loadUrl(url);
            }
        });
    }

    public void loadUrl(final String url, final int time) {
        System.out.println("loadUrl(" + url + "," + time + ")");
        final DroidGap me = this;
        this.runOnUiThread(new Runnable(){

            public void run() {
                me.handleActivityParameters();
            }
        });
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(time);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!me.cancelLoadUrl) {
                    me.loadUrl(url);
                } else {
                    me.cancelLoadUrl = false;
                    System.out.println("Aborting loadUrl(" + url + "): Another URL was loaded before timer expired.");
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void cancelLoadUrl() {
        this.cancelLoadUrl = true;
    }

    public void clearCache() {
        if (this.appView == null) {
            this.init();
        }
        this.appView.clearCache(true);
    }

    public void clearHistory() {
        this.clearHistory = true;
        if (this.appView != null) {
            this.appView.clearHistory();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Boolean p = (Boolean)bundle.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Integer p = (Integer)bundle.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public String getStringProperty(String name, String defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        String p = bundle.getString(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public double getDoubleProperty(String name, double defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Double p = (Double)bundle.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.getIntent().putExtra(name, value);
    }

    public void setIntegerProperty(String name, int value) {
        this.getIntent().putExtra(name, value);
    }

    public void setStringProperty(String name, String value) {
        this.getIntent().putExtra(name, value);
    }

    public void setDoubleProperty(String name, double value) {
        this.getIntent().putExtra(name, value);
    }

    protected void onPause() {
        super.onPause();
        if (!this.keepRunning) {
            this.pluginManager.onPause();
            this.appView.loadUrl("javascript:try{PhoneGap.onPause.fire();}catch(e){};");
            this.appView.pauseTimers();
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.keepRunning || this.activityResultKeepRunning) {
            if (this.activityResultKeepRunning) {
                this.keepRunning = this.activityResultKeepRunning;
                this.activityResultKeepRunning = false;
            }
            this.pluginManager.onResume();
            this.appView.loadUrl("javascript:try{PhoneGap.onResume.fire();}catch(e){};");
            this.appView.resumeTimers();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.appView.loadUrl("javascript:try{PhoneGap.onPause.fire();}catch(e){};");
        this.appView.loadUrl("about:blank");
        if (this.mKey != null) {
            // empty if block
        }
        this.pluginManager.onDestroy();
        if (this.callbackServer != null) {
            this.callbackServer.destroy();
        }
    }

    public void addService(String serviceType, String className) {
        this.pluginManager.addService(serviceType, className);
    }

    public void sendJavascript(String statement) {
        this.callbackServer.sendJavascript(statement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.mKey.isBound()) {
                this.appView.loadUrl("javascript:document.keyEvent.backTrigger()");
                return false;
            } else {
                if (!this.appView.canGoBack()) return super.onKeyDown(keyCode, event);
                this.appView.goBack();
            }
            return false;
        } else if (keyCode == 82) {
            this.appView.loadUrl("javascript:keyEvent.menuTrigger()");
            return false;
        } else {
            if (keyCode != 84) return false;
            this.appView.loadUrl("javascript:keyEvent.searchTrigger()");
        }
        return false;
    }

    public void startActivityForResult(Intent intent, int requestCode) throws RuntimeException {
        System.out.println("startActivityForResult(intent," + requestCode + ")");
        if (requestCode != -1) {
            throw new RuntimeException("PhoneGap Exception: Call startActivityForResult(Command, Intent) instead.");
        }
        super.startActivityForResult(intent, requestCode);
    }

    public void startActivityForResult(Plugin command, Intent intent, int requestCode) {
        this.activityResultCallback = command;
        this.activityResultKeepRunning = this.keepRunning;
        if (command != null) {
            this.keepRunning = false;
        }
        super.startActivityForResult(intent, requestCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        Plugin callback = this.activityResultCallback;
        if (callback != null) {
            callback.onActivityResult(requestCode, resultCode, intent);
        }
    }

    public void onReceivedError(int errorCode, String description, String failingUrl) {
        final DroidGap me = this;
        final String errorUrl = me.getStringProperty("errorUrl", null);
        if (errorUrl != null && errorUrl.startsWith("file://") && !failingUrl.equals(errorUrl)) {
            me.runOnUiThread(new Runnable(){

                public void run() {
                    me.appView.loadUrl(errorUrl);
                }
            });
        } else {
            me.appView.loadUrl("about:blank");
            me.displayError("Application Error", description + " (" + failingUrl + ")", "OK", true);
        }
    }

    public void displayError(final String title, final String message, final String button, final boolean exit) {
        final DroidGap me = this;
        me.runOnUiThread(new Runnable(){

            public void run() {
                AlertDialog.Builder dlg = new AlertDialog.Builder((Context)me);
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(false);
                dlg.setPositiveButton((CharSequence)button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        if (exit) {
                            me.finish();
                        }
                    }
                });
                dlg.create();
                dlg.show();
            }
        });
    }

    public class GapViewClient
    extends WebViewClient {
        DroidGap ctx;

        public GapViewClient(DroidGap ctx) {
            this.ctx = ctx;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith("tel:")) {
                try {
                    Intent intent = new Intent("android.intent.action.DIAL");
                    intent.setData(Uri.parse((String)url));
                    DroidGap.this.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    System.out.println("Error dialing " + url + ": " + e.toString());
                }
                return true;
            }
            if (url.startsWith("geo:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    DroidGap.this.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    System.out.println("Error showing map " + url + ": " + e.toString());
                }
                return true;
            }
            if (url.startsWith("mailto:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    DroidGap.this.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    System.out.println("Error sending email " + url + ": " + e.toString());
                }
                return true;
            }
            if (url.startsWith("sms:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    intent.putExtra("address", url.substring(4));
                    intent.setType("vnd.android-dir/mms-sms");
                    DroidGap.this.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    System.out.println("Error sending sms " + url + ":" + e.toString());
                }
                return true;
            }
            int i = url.lastIndexOf(47);
            String newBaseUrl = url;
            if (i > 0) {
                newBaseUrl = url.substring(0, i);
            }
            if (this.ctx.loadInWebView || url.startsWith("file://") || this.ctx.baseUrl.equals(newBaseUrl)) {
                this.ctx.appView.loadUrl(url);
            } else {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    DroidGap.this.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    System.out.println("Error loading url " + url + ":" + e.toString());
                }
            }
            return true;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            this.ctx.loadUrlTimeout++;
            DroidGap.this.appView.loadUrl("javascript:try{ PhoneGap.onNativeReady.fire();}catch(e){_nativeReady = true;}");
            if (this.ctx.splashscreen != 0) {
                this.ctx.splashscreen = 0;
                DroidGap.this.appView.setPictureListener(new WebView.PictureListener(){

                    public void onNewPicture(WebView viewtwo, Picture picture) {
                        DroidGap.this.appView.setBackgroundResource(0);
                        DroidGap.this.appView.setPictureListener(null);
                    }
                });
            }
            if (this.ctx.hideLoadingDialogOnPageLoad) {
                this.ctx.hideLoadingDialogOnPageLoad = false;
                this.ctx.pluginManager.exec("Notification", "activityStop", null, "[]", false);
            }
            if (this.ctx.clearHistory) {
                this.ctx.clearHistory = false;
                this.ctx.appView.clearHistory();
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            System.out.println("onReceivedError: Error code=" + errorCode + " Description=" + description + " URL=" + failingUrl);
            this.ctx.loadUrlTimeout++;
            this.ctx.pluginManager.exec("Notification", "activityStop", null, "[]", false);
            this.ctx.onReceivedError(errorCode, description, failingUrl);
        }
    }

    public final class EclairClient
    extends GapClient {
        private String TAG;
        private long MAX_QUOTA;

        public EclairClient(Context ctx) {
            super(ctx);
            this.TAG = "PhoneGapLog";
            this.MAX_QUOTA = 0x6400000L;
        }

        public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
            Log.d((String)this.TAG, (String)("event raised onExceededDatabaseQuota estimatedSize: " + Long.toString(estimatedSize) + " currentQuota: " + Long.toString(currentQuota) + " totalUsedQuota: " + Long.toString(totalUsedQuota)));
            if (estimatedSize < this.MAX_QUOTA) {
                long newQuota = estimatedSize;
                Log.d((String)this.TAG, (String)("calling quotaUpdater.updateQuota newQuota: " + Long.toString(newQuota)));
                quotaUpdater.updateQuota(newQuota);
            } else {
                quotaUpdater.updateQuota(currentQuota);
            }
        }

        public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            Log.d((String)this.TAG, (String)(sourceID + ": Line " + Integer.toString(lineNumber) + " : " + message));
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            super.onGeolocationPermissionsShowPrompt(origin, callback);
            callback.invoke(origin, true, false);
        }
    }

    public class GapClient
    extends WebChromeClient {
        private Context ctx;

        public GapClient(Context ctx) {
            this.ctx = ctx;
        }

        public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
            AlertDialog.Builder dlg = new AlertDialog.Builder(this.ctx);
            dlg.setMessage((CharSequence)message);
            dlg.setTitle((CharSequence)"Alert");
            dlg.setCancelable(false);
            dlg.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.confirm();
                }
            });
            dlg.create();
            dlg.show();
            return true;
        }

        public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
            AlertDialog.Builder dlg = new AlertDialog.Builder(this.ctx);
            dlg.setMessage((CharSequence)message);
            dlg.setTitle((CharSequence)"Confirm");
            dlg.setCancelable(false);
            dlg.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.confirm();
                }
            });
            dlg.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.cancel();
                }
            });
            dlg.create();
            dlg.show();
            return true;
        }
    }
}

