/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Contacts;
import android.util.Log;
import android.webkit.WebView;
import com.phonegap.ContactAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactAccessorSdk3_4
extends ContactAccessor {
    private static final String PEOPLE_ID_EQUALS = "people._id = ?";
    private static final Map<String, String> dbMap = new HashMap<String, String>();

    public ContactAccessorSdk3_4(WebView view, Activity app) {
        this.mApp = app;
        this.mView = view;
    }

    @Override
    public JSONArray search(JSONArray fields, JSONObject options) {
        String searchTerm = "";
        int limit = Integer.MAX_VALUE;
        boolean multiple = true;
        if (options != null) {
            searchTerm = options.optString("filter");
            searchTerm = searchTerm.length() == 0 ? "%" : "%" + searchTerm + "%";
            try {
                multiple = options.getBoolean("multiple");
                if (!multiple) {
                    limit = 1;
                }
            }
            catch (JSONException e) {}
        } else {
            searchTerm = "%";
        }
        ContentResolver cr = this.mApp.getContentResolver();
        Set<String> contactIds = this.buildSetOfContactIds(fields, searchTerm);
        HashMap<String, Boolean> populate = this.buildPopulationSet(fields);
        Iterator<String> it = contactIds.iterator();
        JSONArray contacts = new JSONArray();
        int pos = 0;
        while (it.hasNext() && pos < limit) {
            JSONObject contact = new JSONObject();
            try {
                String contactId = it.next();
                contact.put("id", (Object)contactId);
                Cursor cur = cr.query(Contacts.People.CONTENT_URI, new String[]{"display_name", "notes"}, PEOPLE_ID_EQUALS, new String[]{contactId}, null);
                cur.moveToFirst();
                if (this.isRequired("displayName", populate)) {
                    contact.put("displayName", (Object)cur.getString(cur.getColumnIndex("display_name")));
                }
                if (this.isRequired("phoneNumbers", populate)) {
                    contact.put("phoneNumbers", (Object)this.phoneQuery(cr, contactId));
                }
                if (this.isRequired("emails", populate)) {
                    contact.put("emails", (Object)this.emailQuery(cr, contactId));
                }
                if (this.isRequired("addresses", populate)) {
                    contact.put("addresses", (Object)this.addressQuery(cr, contactId));
                }
                if (this.isRequired("organizations", populate)) {
                    contact.put("organizations", (Object)this.organizationQuery(cr, contactId));
                }
                if (this.isRequired("ims", populate)) {
                    contact.put("ims", (Object)this.imQuery(cr, contactId));
                }
                if (this.isRequired("note", populate)) {
                    contact.put("note", (Object)cur.getString(cur.getColumnIndex("notes")));
                }
                ++pos;
                cur.close();
            }
            catch (JSONException e) {
                Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            }
            contacts.put((Object)contact);
        }
        return contacts;
    }

    private Set<String> buildSetOfContactIds(JSONArray fields, String searchTerm) {
        HashSet<String> contactIds = new HashSet<String>();
        try {
            for (int i = 0; i < fields.length(); ++i) {
                String key = fields.getString(i);
                if (key.startsWith("displayName")) {
                    this.doQuery(searchTerm, contactIds, Contacts.People.CONTENT_URI, "_id", dbMap.get(key) + " LIKE ?", new String[]{searchTerm});
                    continue;
                }
                if (key.startsWith("phoneNumbers")) {
                    this.doQuery(searchTerm, contactIds, Contacts.Phones.CONTENT_URI, "person", dbMap.get(key) + " LIKE ?", new String[]{searchTerm});
                    continue;
                }
                if (key.startsWith("emails")) {
                    this.doQuery(searchTerm, contactIds, Contacts.ContactMethods.CONTENT_EMAIL_URI, "person", dbMap.get(key) + " LIKE ? AND " + "kind" + " = ?", new String[]{searchTerm, "vnd.android.cursor.item/email"});
                    continue;
                }
                if (key.startsWith("addresses")) {
                    this.doQuery(searchTerm, contactIds, Contacts.ContactMethods.CONTENT_URI, "person", dbMap.get(key) + " LIKE ? AND " + "kind" + " = ?", new String[]{searchTerm, "vnd.android.cursor.item/postal-address"});
                    continue;
                }
                if (key.startsWith("ims")) {
                    this.doQuery(searchTerm, contactIds, Contacts.ContactMethods.CONTENT_URI, "person", dbMap.get(key) + " LIKE ? AND " + "kind" + " = ?", new String[]{searchTerm, "vnd.android.cursor.item/jabber-im"});
                    continue;
                }
                if (key.startsWith("organizations")) {
                    this.doQuery(searchTerm, contactIds, Contacts.Organizations.CONTENT_URI, "person", dbMap.get(key) + " LIKE ?", new String[]{searchTerm});
                    continue;
                }
                if (!key.startsWith("note")) continue;
                this.doQuery(searchTerm, contactIds, Contacts.People.CONTENT_URI, "_id", dbMap.get(key) + " LIKE ?", new String[]{searchTerm});
            }
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return contactIds;
    }

    private void doQuery(String searchTerm, Set<String> contactIds, Uri uri, String projection, String selection, String[] selectionArgs) {
        ContentResolver cr = this.mApp.getContentResolver();
        Cursor cursor = cr.query(uri, null, selection, selectionArgs, null);
        while (cursor.moveToNext()) {
            contactIds.add(cursor.getString(cursor.getColumnIndex(projection)));
        }
        cursor.close();
    }

    private JSONArray imQuery(ContentResolver cr, String contactId) {
        String imWhere = "person = ? AND kind = ?";
        String[] imWhereParams = new String[]{contactId, "vnd.android.cursor.item/jabber-im"};
        Cursor cursor = cr.query(Contacts.ContactMethods.CONTENT_URI, null, imWhere, imWhereParams, null);
        JSONArray ims = new JSONArray();
        while (cursor.moveToNext()) {
            JSONObject im = new JSONObject();
            try {
                im.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
                im.put("perf", false);
                im.put("value", (Object)cursor.getString(cursor.getColumnIndex("data")));
                im.put("type", (Object)this.getContactType(cursor.getInt(cursor.getColumnIndex("type"))));
                ims.put((Object)im);
            }
            catch (JSONException e) {
                Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            }
        }
        cursor.close();
        return null;
    }

    private JSONArray organizationQuery(ContentResolver cr, String contactId) {
        String orgWhere = "person = ?";
        String[] orgWhereParams = new String[]{contactId};
        Cursor cursor = cr.query(Contacts.Organizations.CONTENT_URI, null, orgWhere, orgWhereParams, null);
        JSONArray organizations = new JSONArray();
        while (cursor.moveToNext()) {
            JSONObject organization = new JSONObject();
            try {
                organization.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
                organization.put("name", (Object)cursor.getString(cursor.getColumnIndex("company")));
                organization.put("title", (Object)cursor.getString(cursor.getColumnIndex("title")));
                organizations.put((Object)organization);
            }
            catch (JSONException e) {
                Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            }
        }
        return organizations;
    }

    private JSONArray addressQuery(ContentResolver cr, String contactId) {
        String addrWhere = "person = ? AND kind = ?";
        String[] addrWhereParams = new String[]{contactId, "vnd.android.cursor.item/postal-address"};
        Cursor cursor = cr.query(Contacts.ContactMethods.CONTENT_URI, null, addrWhere, addrWhereParams, null);
        JSONArray addresses = new JSONArray();
        while (cursor.moveToNext()) {
            JSONObject address = new JSONObject();
            try {
                address.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
                address.put("formatted", (Object)cursor.getString(cursor.getColumnIndex("data")));
                addresses.put((Object)address);
            }
            catch (JSONException e) {
                Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            }
        }
        return addresses;
    }

    private JSONArray phoneQuery(ContentResolver cr, String contactId) {
        Cursor cursor = cr.query(Contacts.Phones.CONTENT_URI, null, "person = ?", new String[]{contactId}, null);
        JSONArray phones = new JSONArray();
        while (cursor.moveToNext()) {
            JSONObject phone = new JSONObject();
            try {
                phone.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
                phone.put("perf", false);
                phone.put("value", (Object)cursor.getString(cursor.getColumnIndex("number")));
                phone.put("type", (Object)this.getPhoneType(cursor.getInt(cursor.getColumnIndex("type"))));
                phones.put((Object)phone);
            }
            catch (JSONException e) {
                Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            }
        }
        return phones;
    }

    private JSONArray emailQuery(ContentResolver cr, String contactId) {
        Cursor cursor = cr.query(Contacts.ContactMethods.CONTENT_EMAIL_URI, null, "person = ?", new String[]{contactId}, null);
        JSONArray emails = new JSONArray();
        while (cursor.moveToNext()) {
            JSONObject email = new JSONObject();
            try {
                email.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
                email.put("perf", false);
                email.put("value", (Object)cursor.getString(cursor.getColumnIndex("data")));
                emails.put((Object)email);
            }
            catch (JSONException e) {
                Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            }
        }
        return emails;
    }

    @Override
    public boolean save(JSONObject contact) {
        Uri newPersonUri;
        String note;
        ContentValues personValues = new ContentValues();
        String id = this.getJsonString(contact, "id");
        String name = this.getJsonString(contact, "displayName");
        if (name != null) {
            personValues.put("name", name);
        }
        if ((note = this.getJsonString(contact, "note")) != null) {
            personValues.put("notes", note);
        }
        personValues.put("starred", Integer.valueOf(0));
        if (id == null) {
            newPersonUri = Contacts.People.createPersonInMyContactsGroup((ContentResolver)this.mApp.getContentResolver(), (ContentValues)personValues);
        } else {
            newPersonUri = Uri.withAppendedPath((Uri)Contacts.People.CONTENT_URI, (String)id);
            this.mApp.getContentResolver().update(newPersonUri, personValues, PEOPLE_ID_EQUALS, new String[]{id});
        }
        if (newPersonUri != null) {
            this.savePhoneNumbers(contact, newPersonUri);
            this.saveEntries(contact, newPersonUri, "emails", 1);
            this.saveAddresses(contact, newPersonUri);
            this.saveOrganizations(contact, newPersonUri);
            this.saveEntries(contact, newPersonUri, "ims", 3);
            return true;
        }
        return false;
    }

    private void saveOrganizations(JSONObject contact, Uri newPersonUri) {
        ContentValues values = new ContentValues();
        Uri orgUri = Uri.withAppendedPath((Uri)newPersonUri, (String)"organizations");
        String id = null;
        try {
            JSONArray orgs = contact.getJSONArray("organizations");
            if (orgs != null && orgs.length() > 0) {
                for (int i = 0; i < orgs.length(); ++i) {
                    JSONObject org = orgs.getJSONObject(i);
                    id = this.getJsonString(org, "id");
                    values.put("company", this.getJsonString(org, "name"));
                    values.put("title", this.getJsonString(org, "title"));
                    if (id == null) {
                        Uri contactUpdate = this.mApp.getContentResolver().insert(orgUri, values);
                        continue;
                    }
                    Uri tempUri = Uri.withAppendedPath((Uri)orgUri, (String)id);
                    this.mApp.getContentResolver().update(tempUri, values, null, null);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)("Could not save organizations = " + e.getMessage()));
        }
    }

    private void saveAddresses(JSONObject contact, Uri uri) {
        ContentValues values = new ContentValues();
        Uri newUri = Uri.withAppendedPath((Uri)uri, (String)"contact_methods");
        String id = null;
        try {
            JSONArray entries = contact.getJSONArray("addresses");
            if (entries != null && entries.length() > 0) {
                values.put("kind", Integer.valueOf(2));
                for (int i = 0; i < entries.length(); ++i) {
                    JSONObject entry = entries.getJSONObject(i);
                    id = this.getJsonString(entry, "id");
                    String address = this.getJsonString(entry, "formatted");
                    if (address != null) {
                        values.put("data", address);
                    } else {
                        values.put("data", this.createAddressString(entry));
                    }
                    if (id == null) {
                        Uri contactUpdate = this.mApp.getContentResolver().insert(newUri, values);
                        continue;
                    }
                    Uri tempUri = Uri.withAppendedPath((Uri)newUri, (String)id);
                    this.mApp.getContentResolver().update(tempUri, values, null, null);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)("Could not save address = " + e.getMessage()));
        }
    }

    private String createAddressString(JSONObject entry) {
        StringBuffer buffer = new StringBuffer("");
        if (this.getJsonString(entry, "locality") != null) {
            buffer.append(this.getJsonString(entry, "locality"));
        }
        if (this.getJsonString(entry, "region") != null) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getJsonString(entry, "region"));
        }
        if (this.getJsonString(entry, "postalCode") != null) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getJsonString(entry, "postalCode"));
        }
        if (this.getJsonString(entry, "country") != null) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getJsonString(entry, "country"));
        }
        return buffer.toString();
    }

    private void saveEntries(JSONObject contact, Uri uri, String dataType, int contactKind) {
        ContentValues values = new ContentValues();
        Uri newUri = Uri.withAppendedPath((Uri)uri, (String)"contact_methods");
        String id = null;
        try {
            JSONArray entries = contact.getJSONArray(dataType);
            if (entries != null && entries.length() > 0) {
                values.put("kind", Integer.valueOf(contactKind));
                for (int i = 0; i < entries.length(); ++i) {
                    JSONObject entry = entries.getJSONObject(i);
                    id = this.getJsonString(entry, "id");
                    values.put("data", this.getJsonString(entry, "value"));
                    values.put("type", Integer.valueOf(this.getContactType(this.getJsonString(entry, "type"))));
                    if (id == null) {
                        Uri contactUpdate = this.mApp.getContentResolver().insert(newUri, values);
                        continue;
                    }
                    Uri tempUri = Uri.withAppendedPath((Uri)newUri, (String)id);
                    this.mApp.getContentResolver().update(tempUri, values, null, null);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)("Could not save " + dataType + " = " + e.getMessage()));
        }
    }

    private int getContactType(String string) {
        int type = 3;
        if (string != null) {
            if ("home".equals(string.toLowerCase())) {
                return 1;
            }
            if ("work".equals(string.toLowerCase())) {
                return 2;
            }
            if ("other".equals(string.toLowerCase())) {
                return 3;
            }
            if ("custom".equals(string.toLowerCase())) {
                return 0;
            }
        }
        return type;
    }

    private String getContactType(int type) {
        String stringType;
        switch (type) {
            case 0: {
                stringType = "custom";
                break;
            }
            case 1: {
                stringType = "home";
                break;
            }
            case 2: {
                stringType = "work";
                break;
            }
            default: {
                stringType = "other";
            }
        }
        return stringType;
    }

    private void savePhoneNumbers(JSONObject contact, Uri uri) {
        ContentValues values = new ContentValues();
        Uri phonesUri = Uri.withAppendedPath((Uri)uri, (String)"phones");
        String id = null;
        try {
            JSONArray phones = contact.getJSONArray("phoneNumbers");
            if (phones != null && phones.length() > 0) {
                for (int i = 0; i < phones.length(); ++i) {
                    JSONObject phone = phones.getJSONObject(i);
                    id = this.getJsonString(phone, "id");
                    values.put("number", this.getJsonString(phone, "value"));
                    values.put("type", Integer.valueOf(this.getPhoneType(this.getJsonString(phone, "type"))));
                    if (id == null) {
                        Uri phoneUpdate = this.mApp.getContentResolver().insert(phonesUri, values);
                        continue;
                    }
                    Uri newUri = Uri.withAppendedPath((Uri)phonesUri, (String)id);
                    this.mApp.getContentResolver().update(newUri, values, null, null);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)("Could not save phones = " + e.getMessage()));
        }
    }

    private int getPhoneType(String string) {
        int type = 7;
        if ("home".equals(string.toLowerCase())) {
            return 1;
        }
        if ("mobile".equals(string.toLowerCase())) {
            return 2;
        }
        if ("work".equals(string.toLowerCase())) {
            return 3;
        }
        if ("work fax".equals(string.toLowerCase())) {
            return 4;
        }
        if ("home fax".equals(string.toLowerCase())) {
            return 5;
        }
        if ("fax".equals(string.toLowerCase())) {
            return 4;
        }
        if ("pager".equals(string.toLowerCase())) {
            return 6;
        }
        if ("other".equals(string.toLowerCase())) {
            return 7;
        }
        if ("custom".equals(string.toLowerCase())) {
            return 0;
        }
        return type;
    }

    private String getPhoneType(int type) {
        String stringType;
        switch (type) {
            case 0: {
                stringType = "custom";
                break;
            }
            case 5: {
                stringType = "home fax";
                break;
            }
            case 4: {
                stringType = "work fax";
                break;
            }
            case 1: {
                stringType = "home";
                break;
            }
            case 2: {
                stringType = "mobile";
                break;
            }
            case 6: {
                stringType = "pager";
                break;
            }
            case 3: {
                stringType = "work";
                break;
            }
            default: {
                stringType = "custom";
            }
        }
        return stringType;
    }

    @Override
    public boolean remove(String id) {
        int result = this.mApp.getContentResolver().delete(Contacts.People.CONTENT_URI, PEOPLE_ID_EQUALS, new String[]{id});
        return result > 0;
    }

    static {
        dbMap.put("id", "_id");
        dbMap.put("displayName", "display_name");
        dbMap.put("phoneNumbers", "number");
        dbMap.put("phoneNumbers.value", "number");
        dbMap.put("emails", "data");
        dbMap.put("emails.value", "data");
        dbMap.put("addresses", "data");
        dbMap.put("addresses.formatted", "data");
        dbMap.put("ims", "data");
        dbMap.put("ims.value", "data");
        dbMap.put("organizations", "company");
        dbMap.put("organizations.name", "company");
        dbMap.put("organizations.title", "title");
        dbMap.put("note", "notes");
    }
}

