/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.squareup.picasso.Cache;
import com.squareup.picasso.StatsSnapshot;
import com.squareup.picasso.Utils;

class Stats {
    private static final int REQUESTED_COMPLETED = 0;
    private static final int CACHE_HIT = 1;
    private static final int CACHE_MISS = 2;
    private static final int BITMAP_DECODE_FINISHED = 3;
    private static final int BITMAP_TRANSFORMED_FINISHED = 4;
    private static final String STATS_THREAD_NAME = "Picasso-Stats";
    final HandlerThread statsThread;
    final Cache cache;
    final Handler handler;
    long cacheHits;
    long cacheMisses;
    long totalOriginalBitmapSize;
    long totalTransformedBitmapSize;
    long averageOriginalBitmapSize;
    long averageTransformedBitmapSize;
    int originalBitmapCount;
    int transformedBitmapCount;

    Stats(Cache cache) {
        this.cache = cache;
        this.statsThread = new HandlerThread(STATS_THREAD_NAME, 10);
        this.statsThread.start();
        this.handler = new StatsHandler(this.statsThread.getLooper());
    }

    void dispatchBitmapDecoded(Bitmap bitmap) {
        this.processBitmap(bitmap, 3);
    }

    void dispatchBitmapTransformed(Bitmap bitmap) {
        this.processBitmap(bitmap, 4);
    }

    void dispatchCacheHit() {
        this.handler.sendEmptyMessage(1);
    }

    void dispatchCacheMiss() {
        this.handler.sendEmptyMessage(2);
    }

    void shutdown() {
        this.statsThread.quit();
    }

    void performCacheHit() {
        ++this.cacheHits;
    }

    void performCacheMiss() {
        ++this.cacheMisses;
    }

    void performBitmapDecoded(long size) {
        ++this.originalBitmapCount;
        this.totalOriginalBitmapSize += size;
        this.averageOriginalBitmapSize = Stats.getAverage(this.originalBitmapCount, this.totalOriginalBitmapSize);
    }

    void performBitmapTransformed(long size) {
        ++this.transformedBitmapCount;
        this.totalTransformedBitmapSize += size;
        this.averageTransformedBitmapSize = Stats.getAverage(this.originalBitmapCount, this.totalTransformedBitmapSize);
    }

    synchronized StatsSnapshot createSnapshot() {
        return new StatsSnapshot(this.cache.maxSize(), this.cache.size(), this.cacheHits, this.cacheMisses, this.totalOriginalBitmapSize, this.totalTransformedBitmapSize, this.averageOriginalBitmapSize, this.averageTransformedBitmapSize, this.originalBitmapCount, this.transformedBitmapCount, System.currentTimeMillis());
    }

    private void processBitmap(Bitmap bitmap, int what) {
        int bitmapSize = Utils.getBitmapBytes(bitmap);
        this.handler.sendMessage(this.handler.obtainMessage(what, bitmapSize, 0));
    }

    private static long getAverage(int count, long totalSize) {
        return totalSize / (long)count;
    }

    private class StatsHandler
    extends Handler {
        public StatsHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(final Message msg) {
            Stats stats = Stats.this;
            synchronized (stats) {
                switch (msg.what) {
                    case 1: {
                        Stats.this.performCacheHit();
                        break;
                    }
                    case 2: {
                        Stats.this.performCacheMiss();
                        break;
                    }
                    case 3: {
                        Stats.this.performBitmapDecoded(msg.arg1);
                        break;
                    }
                    case 4: {
                        Stats.this.performBitmapTransformed(msg.arg1);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        Handler mainHandler = new Handler(Looper.getMainLooper());
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                throw new AssertionError((Object)("Unhandled stats message." + msg.what));
                            }
                        });
                    }
                }
            }
        }
    }
}

