/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Handshake;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkResponseCache;
import com.squareup.okhttp.ResponseSource;
import com.squareup.okhttp.internal.DiskLruCache;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.Headers;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.internal.http.Request;
import com.squareup.okhttp.internal.http.Response;
import com.squareup.okhttp.internal.okio.BufferedSource;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.Okio;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Cache
extends ResponseCache
implements OkResponseCache {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public Cache(File directory, long maxSize) throws IOException {
        this.cache = DiskLruCache.open(directory, 201105, 2, maxSize);
    }

    @Override
    public CacheResponse get(URI uri, String s, Map<String, List<String>> stringListMap) throws IOException {
        throw new UnsupportedOperationException("This is not a general purpose response cache.");
    }

    @Override
    public CacheRequest put(URI uri, URLConnection urlConnection) throws IOException {
        throw new UnsupportedOperationException("This is not a general purpose response cache.");
    }

    private static String urlToKey(Request requst) {
        return Util.hash(requst.urlString());
    }

    @Override
    public Response get(Request request) {
        Entry entry;
        DiskLruCache.Snapshot snapshot;
        String key = Cache.urlToKey(request);
        try {
            snapshot = this.cache.get(key);
            if (snapshot == null) {
                return null;
            }
            entry = new Entry(snapshot.getInputStream(0));
        }
        catch (IOException e) {
            return null;
        }
        Response response = entry.response(request, snapshot);
        if (!entry.matches(request, response)) {
            Util.closeQuietly(response.body());
            return null;
        }
        return response;
    }

    @Override
    public CacheRequest put(Response response) throws IOException {
        String requestMethod = response.request().method();
        if (this.maybeRemove(response.request())) {
            return null;
        }
        if (!requestMethod.equals("GET")) {
            return null;
        }
        if (response.hasVaryAll()) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            editor = this.cache.edit(Cache.urlToKey(response.request()));
            if (editor == null) {
                return null;
            }
            entry.writeTo(editor);
            return new CacheRequestImpl(editor);
        }
        catch (IOException e) {
            this.abortQuietly(editor);
            return null;
        }
    }

    @Override
    public boolean maybeRemove(Request request) {
        if (HttpMethod.invalidatesCache(request.method())) {
            try {
                this.cache.remove(Cache.urlToKey(request));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public void update(Response cached, Response network) {
        Entry entry = new Entry(network);
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)cached.body()).snapshot;
        DiskLruCache.Editor editor = null;
        try {
            editor = snapshot.edit();
            if (editor != null) {
                entry.writeTo(editor);
                editor.commit();
            }
        }
        catch (IOException e) {
            this.abortQuietly(editor);
        }
    }

    private void abortQuietly(DiskLruCache.Editor editor) {
        try {
            if (editor != null) {
                editor.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public synchronized int getWriteAbortCount() {
        return this.writeAbortCount;
    }

    public synchronized int getWriteSuccessCount() {
        return this.writeSuccessCount;
    }

    public long getSize() {
        return this.cache.size();
    }

    public long getMaxSize() {
        return this.cache.getMaxSize();
    }

    public void flush() throws IOException {
        this.cache.flush();
    }

    public void close() throws IOException {
        this.cache.close();
    }

    public File getDirectory() {
        return this.cache.getDirectory();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    @Override
    public synchronized void trackResponse(ResponseSource source) {
        ++this.requestCount;
        switch (source) {
            case CACHE: {
                ++this.hitCount;
                break;
            }
            case CONDITIONAL_CACHE: 
            case NETWORK: {
                ++this.networkCount;
            }
        }
    }

    @Override
    public synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public synchronized int getNetworkCount() {
        return this.networkCount;
    }

    public synchronized int getHitCount() {
        return this.hitCount;
    }

    public synchronized int getRequestCount() {
        return this.requestCount;
    }

    private static int readInt(BufferedSource source) throws IOException {
        String line = source.readUtf8Line(true);
        try {
            return Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            throw new IOException("Expected an integer but was \"" + line + "\"");
        }
    }

    private static class CacheResponseBody
    extends Response.Body {
        private final DiskLruCache.Snapshot snapshot;
        private final InputStream bodyIn;
        private final String contentType;
        private final String contentLength;

        public CacheResponseBody(final DiskLruCache.Snapshot snapshot, String contentType, String contentLength) {
            this.snapshot = snapshot;
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.bodyIn = new FilterInputStream(snapshot.getInputStream(1)){

                @Override
                public void close() throws IOException {
                    snapshot.close();
                    super.close();
                }
            };
        }

        @Override
        public boolean ready() throws IOException {
            return true;
        }

        @Override
        public MediaType contentType() {
            return this.contentType != null ? MediaType.parse(this.contentType) : null;
        }

        @Override
        public long contentLength() {
            try {
                return this.contentLength != null ? Long.parseLong(this.contentLength) : -1L;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }

        @Override
        public InputStream byteStream() {
            return this.bodyIn;
        }
    }

    private static final class Entry {
        private final String url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final String statusLine;
        private final Headers responseHeaders;
        private final Handshake handshake;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Entry(InputStream in) throws IOException {
            try {
                BufferedSource source = Okio.buffer(Okio.source(in));
                this.url = source.readUtf8Line(true);
                this.requestMethod = source.readUtf8Line(true);
                Headers.Builder varyHeadersBuilder = new Headers.Builder();
                int varyRequestHeaderLineCount = Cache.readInt(source);
                for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                    varyHeadersBuilder.addLine(source.readUtf8Line(true));
                }
                this.varyHeaders = varyHeadersBuilder.build();
                this.statusLine = source.readUtf8Line(true);
                Headers.Builder responseHeadersBuilder = new Headers.Builder();
                int responseHeaderLineCount = Cache.readInt(source);
                for (int i = 0; i < responseHeaderLineCount; ++i) {
                    responseHeadersBuilder.addLine(source.readUtf8Line(true));
                }
                this.responseHeaders = responseHeadersBuilder.build();
                if (this.isHttps()) {
                    String blank = source.readUtf8Line(true);
                    if (blank.length() > 0) {
                        throw new IOException("expected \"\" but was \"" + blank + "\"");
                    }
                    String cipherSuite = source.readUtf8Line(true);
                    List<Certificate> peerCertificates = this.readCertificateList(source);
                    List<Certificate> localCertificates = this.readCertificateList(source);
                    this.handshake = Handshake.get(cipherSuite, peerCertificates, localCertificates);
                } else {
                    this.handshake = null;
                }
            }
            finally {
                in.close();
            }
        }

        public Entry(Response response) {
            this.url = response.request().urlString();
            this.varyHeaders = response.request().headers().getAll(response.getVaryFields());
            this.requestMethod = response.request().method();
            this.statusLine = response.statusLine();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
        }

        public void writeTo(DiskLruCache.Editor editor) throws IOException {
            int i;
            OutputStream out = editor.newOutputStream(0);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, Util.UTF_8));
            writer.write(this.url + '\n');
            writer.write(this.requestMethod + '\n');
            writer.write(Integer.toString(this.varyHeaders.size()) + '\n');
            for (i = 0; i < this.varyHeaders.size(); ++i) {
                writer.write(this.varyHeaders.name(i) + ": " + this.varyHeaders.value(i) + '\n');
            }
            writer.write(this.statusLine + '\n');
            writer.write(Integer.toString(this.responseHeaders.size()) + '\n');
            for (i = 0; i < this.responseHeaders.size(); ++i) {
                writer.write(this.responseHeaders.name(i) + ": " + this.responseHeaders.value(i) + '\n');
            }
            if (this.isHttps()) {
                ((Writer)writer).write(10);
                writer.write(this.handshake.cipherSuite() + '\n');
                this.writeCertArray(writer, this.handshake.peerCertificates());
                this.writeCertArray(writer, this.handshake.localCertificates());
            }
            ((Writer)writer).close();
        }

        private boolean isHttps() {
            return this.url.startsWith("https://");
        }

        private List<Certificate> readCertificateList(BufferedSource source) throws IOException {
            int length = Cache.readInt(source);
            if (length == -1) {
                return Collections.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result = new ArrayList<Certificate>(length);
                for (int i = 0; i < length; ++i) {
                    String line = source.readUtf8Line(true);
                    byte[] bytes = ByteString.decodeBase64(line).toByteArray();
                    result.add(certificateFactory.generateCertificate(new ByteArrayInputStream(bytes)));
                }
                return result;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private void writeCertArray(Writer writer, List<Certificate> certificates) throws IOException {
            try {
                writer.write(Integer.toString(certificates.size()) + '\n');
                int size = certificates.size();
                for (int i = 0; i < size; ++i) {
                    byte[] bytes = certificates.get(i).getEncoded();
                    String line = ByteString.of(bytes).base64();
                    writer.write(line + '\n');
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public boolean matches(Request request, Response response) {
            return this.url.equals(request.urlString()) && this.requestMethod.equals(request.method()) && response.varyMatches(this.varyHeaders, request);
        }

        public Response response(Request request, DiskLruCache.Snapshot snapshot) {
            String contentType = this.responseHeaders.get("Content-Type");
            String contentLength = this.responseHeaders.get("Content-Length");
            return new Response.Builder().request(request).statusLine(this.statusLine).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, contentType, contentLength)).handshake(this.handshake).build();
        }
    }

    private final class CacheRequestImpl
    extends CacheRequest {
        private final DiskLruCache.Editor editor;
        private OutputStream cacheOut;
        private boolean done;
        private OutputStream body;

        public CacheRequestImpl(final DiskLruCache.Editor editor) throws IOException {
            this.editor = editor;
            this.cacheOut = editor.newOutputStream(1);
            this.body = new FilterOutputStream(this.cacheOut){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    synchronized (cache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        Cache.this.writeSuccessCount++;
                    }
                    super.close();
                    editor.commit();
                }

                @Override
                public void write(byte[] buffer, int offset, int length) throws IOException {
                    this.out.write(buffer, offset, length);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                Cache.this.writeAbortCount++;
            }
            Util.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public OutputStream getBody() throws IOException {
            return this.body;
        }
    }
}

