/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.internal.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;

public class Strings {
    public static boolean isEmptyOrWhitespace(String s) {
        return s == null || s.trim().length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromStream(InputStream inputStream) throws IOException {
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(inputStream, "UTF-8");
        try {
            int read;
            while ((read = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                out.append(buffer, 0, read);
            }
            String string = out.toString();
            return string;
        }
        finally {
            ((Reader)in).close();
            inputStream.close();
        }
    }

    public static InputStream asStream(String string) {
        return new ByteArrayInputStream(string.getBytes());
    }

    public static String formatDollarAmount(int amount) {
        NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(Locale.US);
        return "$" + currencyFormatter.format((float)amount / 100.0f).substring(1);
    }

    public static String fromFile(String filename) {
        try {
            return Strings.fromStream(new FileInputStream(filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String join(String delimiter, Collection collection) {
        return Strings.join(delimiter, collection.toArray());
    }

    public static String join(String delimiter, Object ... collection) {
        String del = "";
        StringBuilder sb = new StringBuilder();
        for (Object obj : collection) {
            String asString;
            String string = asString = obj == null ? null : obj.toString();
            if (asString == null || asString.length() <= 0) continue;
            sb.append(del).append(asString);
            del = delimiter;
        }
        return sb.toString();
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }
}

