/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tv.ouya.console.api.CreditCardInfo;
import tv.ouya.console.api.OuyaResponseListener;
import tv.ouya.console.api.RequestRunnable;
import tv.ouya.console.internal.CreditCardInfoListenerBinder;
import tv.ouya.console.internal.IUserServiceDefinition;
import tv.ouya.console.internal.StringListenerBinder;
import tv.ouya.console.internal.VoidListenerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManager
implements ServiceConnection {
    private static final String LOG_TAG = "OUYAUM";
    private static UserManager instance = null;
    private Context context;
    private IUserServiceDefinition remoteService;
    private List<Runnable> pendingRequests = new ArrayList<Runnable>();
    private boolean bindRequestHasBeenMade;

    public static UserManager getInstance(Context context) {
        if (instance != null) {
            return instance;
        }
        return new UserManager(context);
    }

    @Deprecated
    protected static void setInstance(UserManager instance) {
        UserManager.instance = instance;
    }

    protected UserManager(Context context) {
        this.context = context;
    }

    public void shutdown() {
        if (this.context != null) {
            if (this.remoteService != null) {
                this.context.unbindService((ServiceConnection)this);
                this.remoteService = null;
                this.bindRequestHasBeenMade = false;
            }
            this.context = null;
        }
    }

    public void requestUsername(String consoleId, OuyaResponseListener<String> usernameListener) {
        this.runRequest(new RequestUsernameRunnable(consoleId, usernameListener));
    }

    public void requestUserAddsAccount(Activity activity, OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestUserAddsAccountRunnable(listener));
    }

    public void requestUserAddCreditCard(String name, String email, String number, String cvn, String expiry_month, String expiry_year, String zip, OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestUserAddCreditCardRunnable(name, email, number, cvn, expiry_month, expiry_year, zip, listener));
    }

    public void requestUserGetCreditCardInfo(OuyaResponseListener<CreditCardInfo> listener) {
        this.runRequest(new RequestUserGetCreditCardInfoRunnable(listener));
    }

    public void requestAddLike(String uuid, OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestAddLikeRunnable(uuid, listener));
    }

    public void requestRemoveLike(String uuid, OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestRemoveLikeRunnable(uuid, listener));
    }

    public void requestGetLikes(OuyaResponseListener<String> listener) {
        this.runRequest(new RequestGetLikesRunnable(listener));
    }

    private void runRequest(Runnable requestRunnable) {
        if (this.context == null) {
            Log.e((String)LOG_TAG, (String)"Dropping request due to context having been closed");
            return;
        }
        this.ensureServiceIsBound();
        if (this.remoteService != null) {
            requestRunnable.run();
        } else {
            this.pendingRequests.add(requestRunnable);
        }
    }

    @Deprecated
    IUserServiceDefinition getRemoteService() {
        return this.remoteService;
    }

    @Deprecated
    public boolean bindRequestHasBeenMade() {
        return this.bindRequestHasBeenMade;
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Log.d((String)LOG_TAG, (String)"Successfully bound to UserService");
        this.remoteService = IUserServiceDefinition.Stub.asInterface(iBinder);
        while (this.pendingRequests.size() > 0) {
            this.pendingRequests.remove(0).run();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.remoteService = null;
        this.bindRequestHasBeenMade = false;
    }

    void ensureServiceIsBound() {
        if (!this.bindRequestHasBeenMade) {
            Log.d((String)LOG_TAG, (String)"Binding to UserService");
            Intent intent = new Intent();
            intent.setClassName("tv.ouya", "tv.ouya.console.service.user.UserService");
            this.context.bindService(intent, (ServiceConnection)this, 1);
            this.bindRequestHasBeenMade = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddAccountCallback
    implements AccountManagerCallback<Bundle> {
        private OuyaResponseListener<Void> mListener;

        AddAccountCallback(OuyaResponseListener<Void> listener) {
            this.mListener = listener;
        }

        public void run(AccountManagerFuture<Bundle> future) {
            try {
                Bundle bundle = (Bundle)future.getResult();
                bundle.keySet();
                this.mListener.onSuccess(null);
            }
            catch (OperationCanceledException e) {
                this.mListener.onCancel();
            }
            catch (IOException e) {
                this.mListener.onFailure(3003, e.getMessage(), Bundle.EMPTY);
            }
            catch (AuthenticatorException e) {
                this.mListener.onFailure(2001, e.getMessage(), Bundle.EMPTY);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestGetLikesRunnable
    extends RequestRunnable {
        private RequestGetLikesRunnable(OuyaResponseListener<String> listener) {
            super(listener, "requesting get likes");
        }

        @Override
        void doRun() throws RemoteException {
            UserManager.this.remoteService.requestUserLikes(new StringListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestRemoveLikeRunnable
    extends RequestRunnable {
        private String uuid;

        private RequestRemoveLikeRunnable(String uuid, OuyaResponseListener<Void> listener) {
            super(listener, "requesting remove like");
            this.uuid = uuid;
        }

        @Override
        void doRun() throws RemoteException {
            UserManager.this.remoteService.requestRemoveLike(this.uuid, new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestAddLikeRunnable
    extends RequestRunnable {
        private String uuid;

        private RequestAddLikeRunnable(String uuid, OuyaResponseListener<Void> listener) {
            super(listener, "requesting add like");
            this.uuid = uuid;
        }

        @Override
        void doRun() throws RemoteException {
            UserManager.this.remoteService.requestAddLike(this.uuid, new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestUserGetCreditCardInfoRunnable
    extends RequestRunnable {
        private RequestUserGetCreditCardInfoRunnable(OuyaResponseListener<CreditCardInfo> listener) {
            super(listener, "requesting user credit card info");
        }

        @Override
        void doRun() throws RemoteException {
            UserManager.this.remoteService.requestUserGetCreditCard(new CreditCardInfoListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestUserAddCreditCardRunnable
    extends RequestRunnable {
        final String name;
        final String number;
        final String email;
        final String cvn;
        final String expiry_month;
        final String expiry_year;
        final String zip;

        public RequestUserAddCreditCardRunnable(String name, String email, String number, String cvn, String expiry_month, String expiry_year, String zip, OuyaResponseListener<Void> listener) {
            super(listener, "requesting user add credit card");
            this.name = name;
            this.email = email;
            this.number = number;
            this.cvn = cvn;
            this.expiry_month = expiry_month;
            this.expiry_year = expiry_year;
            this.zip = zip;
        }

        @Override
        void doRun() throws RemoteException {
            UserManager.this.remoteService.requestUserAddCreditCardWithZIP(this.name, this.email, this.number, this.cvn, this.expiry_month, this.expiry_year, this.zip, new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestUserAddsAccountRunnable
    extends RequestRunnable {
        public RequestUserAddsAccountRunnable(OuyaResponseListener<Void> listener) {
            super(listener, "requesting user adds account");
        }

        @Override
        void doRun() throws RemoteException {
            UserManager.this.remoteService.requestUserAddsAccount(new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestUsernameRunnable
    extends RequestRunnable {
        final String mConsoleId;

        public RequestUsernameRunnable(String consoleId, OuyaResponseListener<String> gamerUuidListener) {
            super(gamerUuidListener, "fetching username");
            this.mConsoleId = consoleId;
        }

        @Override
        void doRun() throws RemoteException {
            UserManager.this.remoteService.requestUsername(this.mConsoleId, new StringListenerBinder(this.listener));
        }
    }
}

