/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Purchasable
implements Parcelable {
    private String productId;
    public static final Parcelable.Creator<Purchasable> CREATOR = new Parcelable.Creator<Purchasable>(){

        public Purchasable createFromParcel(Parcel parcel) {
            String productId = parcel.readString();
            switch (parcel.readByte()) {
                case 1: {
                    return new Purchasable(productId);
                }
                case 2: {
                    return new Purchasable(productId, parcel.readString(), parcel.readString(), parcel.readString());
                }
            }
            throw new IllegalArgumentException("Unable to rebuild purchasable. Encryption data state unknown");
        }

        public Purchasable[] newArray(int size) {
            return new Purchasable[size];
        }
    };
    private String mKey;
    private String mIV;
    private String mPayload;

    public String getProductId() {
        return this.productId;
    }

    public Purchasable(String productId) {
        this.productId = productId;
    }

    public Purchasable(String productId, String key, String iv, String payload) {
        this.productId = productId;
        this.mKey = key;
        this.mIV = iv;
        this.mPayload = payload;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.productId);
        if (this.hasEncryptionParameters()) {
            dest.writeByte((byte)2);
            dest.writeString(this.mKey);
            dest.writeString(this.mIV);
            dest.writeString(this.mPayload);
        } else {
            dest.writeByte((byte)1);
        }
    }

    public boolean hasEncryptionParameters() {
        return this.mKey != null && this.mIV != null && this.mPayload != null;
    }

    private boolean encrypt(PublicKey appKey) throws GeneralSecurityException, UnsupportedEncodingException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] keyBytes = new byte[16];
        sr.nextBytes(keyBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        byte[] ivBytes = new byte[16];
        sr.nextBytes(ivBytes);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, (Key)key, iv);
        byte[] payload = cipher.doFinal(this.productId.getBytes("UTF-8"));
        cipher = Cipher.getInstance("RSA");
        cipher.init(1, appKey);
        byte[] encryptedKey = cipher.doFinal(keyBytes);
        this.mKey = Base64.encodeToString((byte[])encryptedKey, (int)0);
        this.mIV = Base64.encodeToString((byte[])ivBytes, (int)0);
        this.mPayload = Base64.encodeToString((byte[])payload, (int)0);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Purchasable that = (Purchasable)o;
        return this.productId.equals(that.productId);
    }

    public int hashCode() {
        return this.productId.hashCode();
    }

    public String toJSON() {
        if (!this.hasEncryptionParameters()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"key\" : \"");
        builder.append(this.mKey);
        builder.append("\", \"iv\" : \"");
        builder.append(this.mIV);
        builder.append("\", \"blob\" : \"");
        builder.append(this.mPayload);
        builder.append("\" }");
        return builder.toString();
    }
}

