/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.security;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.text.TextUtils;
import com.commonsware.cwac.security.PermissionLint;
import java.util.ArrayList;
import java.util.HashMap;

public class PermissionUtils {
    private static final int PROTECTION_MASK_BASE = 15;

    public static HashMap<PackageInfo, ArrayList<PermissionLint>> checkCustomPermissions(Context ctxt) {
        HashMap<PackageInfo, ArrayList<PermissionLint>> results = new HashMap<PackageInfo, ArrayList<PermissionLint>>();
        PackageManager mgr = ctxt.getPackageManager();
        try {
            PackageInfo self = mgr.getPackageInfo(ctxt.getPackageName(), 4096);
            for (PackageInfo pkg : mgr.getInstalledPackages(4096)) {
                if (pkg.packageName.equals(self.packageName) || pkg.permissions == null) continue;
                ArrayList<PermissionLint> lints = new ArrayList<PermissionLint>();
                for (PermissionInfo perm : pkg.permissions) {
                    PermissionInfo myPerm = PermissionUtils.getPermissionForName(self.permissions, perm.name);
                    if (myPerm == null) continue;
                    PermissionLint lint = new PermissionLint(perm);
                    int base = perm.protectionLevel & 0xF;
                    int myBase = myPerm.protectionLevel & 0xF;
                    if (base < myBase) {
                        lint.wasDowngraded = true;
                    } else if (base > myBase) {
                        lint.wasUpgraded = true;
                    }
                    CharSequence desc = perm.loadDescription(mgr);
                    CharSequence myDesc = myPerm.loadDescription(mgr);
                    if (!TextUtils.equals((CharSequence)desc, (CharSequence)myDesc)) {
                        lint.proseDiffers = true;
                    } else {
                        CharSequence myLabel;
                        CharSequence label = perm.loadLabel(mgr);
                        if (!TextUtils.equals((CharSequence)label, (CharSequence)(myLabel = myPerm.loadLabel(mgr)))) {
                            lint.proseDiffers = true;
                        }
                    }
                    lints.add(lint);
                }
                if (lints.size() <= 0) continue;
                results.put(pkg, lints);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("We do not exist?!?", e);
        }
        return results;
    }

    private static PermissionInfo getPermissionForName(PermissionInfo[] perms, String name) {
        for (PermissionInfo perm : perms) {
            if (!name.equals(perm.name)) continue;
            return perm;
        }
        return null;
    }
}

