/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class ContentStreamBitmapHunter
extends BitmapHunter {
    final Context context;

    ContentStreamBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.context = context;
    }

    @Override
    Bitmap decode(Request data) throws IOException {
        return this.decodeContentStream(data);
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.DISK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap decodeContentStream(Request data) throws IOException {
        InputStream is;
        ContentResolver contentResolver = this.context.getContentResolver();
        BitmapFactory.Options options = ContentStreamBitmapHunter.createBitmapOptions(data);
        if (ContentStreamBitmapHunter.requiresInSampleSize(options)) {
            is = null;
            try {
                is = contentResolver.openInputStream(data.uri);
                BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            }
            finally {
                Utils.closeQuietly(is);
            }
            ContentStreamBitmapHunter.calculateInSampleSize(data.targetWidth, data.targetHeight, options);
        }
        is = contentResolver.openInputStream(data.uri);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }
}

