/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import android.content.Context;
import android.util.Log;
import java.io.File;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteDatabaseHook;
import net.sqlcipher.database.SQLiteException;

public abstract class SQLiteOpenHelper {
    private static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    private final Context mContext;
    private final String mName;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private final SQLiteDatabaseHook mHook;
    private SQLiteDatabase mDatabase = null;
    private boolean mIsInitializing = false;

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        this(context, name, factory, version, null);
    }

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, SQLiteDatabaseHook hook) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        this.mContext = context;
        this.mName = name;
        this.mFactory = factory;
        this.mNewVersion = version;
        this.mHook = hook;
    }

    public synchronized SQLiteDatabase getWritableDatabase(String password) {
        return this.getWritableDatabase(password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getWritableDatabase(char[] password) {
        if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getWritableDatabase called recursively");
        }
        boolean success = false;
        SQLiteDatabase db = null;
        if (this.mDatabase != null) {
            this.mDatabase.lock();
        }
        try {
            this.mIsInitializing = true;
            if (this.mName == null) {
                db = SQLiteDatabase.create(null, password);
            } else {
                String path = this.mContext.getDatabasePath(this.mName).getPath();
                File dbPathFile = new File(path);
                if (!dbPathFile.exists()) {
                    dbPathFile.getParentFile().mkdirs();
                }
                db = SQLiteDatabase.openOrCreateDatabase(path, password, this.mFactory, this.mHook);
            }
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else {
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            success = true;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (success) {
                if (this.mDatabase != null) {
                    try {
                        this.mDatabase.close();
                    }
                    catch (Exception e) {}
                    this.mDatabase.unlock();
                }
                this.mDatabase = db;
            } else {
                if (this.mDatabase != null) {
                    this.mDatabase.unlock();
                }
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    public synchronized SQLiteDatabase getReadableDatabase(String password) {
        return this.getReadableDatabase(password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getReadableDatabase(char[] password) {
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getReadableDatabase called recursively");
        }
        try {
            return this.getWritableDatabase(password);
        }
        catch (SQLiteException e) {
            if (this.mName == null) {
                throw e;
            }
            Log.e((String)TAG, (String)("Couldn't open " + this.mName + " for writing (will try read-only):"), (Throwable)e);
            SQLiteDatabase db = null;
            try {
                this.mIsInitializing = true;
                String path = this.mContext.getDatabasePath(this.mName).getPath();
                File databasePath = new File(path);
                File databasesDirectory = new File(this.mContext.getDatabasePath(this.mName).getParent());
                if (!databasesDirectory.exists()) {
                    databasesDirectory.mkdirs();
                }
                if (!databasePath.exists()) {
                    this.mIsInitializing = false;
                    db = this.getWritableDatabase(password);
                    this.mIsInitializing = true;
                    db.close();
                }
                if ((db = SQLiteDatabase.openDatabase(path, password, this.mFactory, 1)).getVersion() != this.mNewVersion) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + path);
                }
                this.onOpen(db);
                Log.w((String)TAG, (String)("Opened " + this.mName + " in read-only mode"));
                SQLiteDatabase sQLiteDatabase = this.mDatabase = db;
                return sQLiteDatabase;
            }
            finally {
                this.mIsInitializing = false;
                if (db != null && db != this.mDatabase) {
                    db.close();
                }
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public void onOpen(SQLiteDatabase db) {
    }
}

