/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.stream;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InputStreamDataEmitter
implements DataEmitter {
    AsyncServer server;
    InputStream inputStream;
    DataCallback callback;
    boolean paused;
    int mToAlloc = 0;
    ByteBufferList pending = new ByteBufferList();
    Runnable pumper = new Runnable(){

        @Override
        public void run() {
            try {
                if (!InputStreamDataEmitter.this.pending.isEmpty()) {
                    InputStreamDataEmitter.this.getServer().run(new Runnable(){

                        @Override
                        public void run() {
                            Util.emitAllData(InputStreamDataEmitter.this, InputStreamDataEmitter.this.pending);
                        }
                    });
                    if (!InputStreamDataEmitter.this.pending.isEmpty()) {
                        return;
                    }
                }
                do {
                    ByteBuffer b;
                    int read;
                    if (-1 == (read = InputStreamDataEmitter.this.inputStream.read((b = ByteBufferList.obtain(Math.min(Math.max(InputStreamDataEmitter.this.mToAlloc, 4096), 262144))).array()))) {
                        InputStreamDataEmitter.this.report(null);
                        return;
                    }
                    InputStreamDataEmitter.this.mToAlloc = read * 2;
                    b.limit(read);
                    InputStreamDataEmitter.this.pending.add(b);
                    InputStreamDataEmitter.this.getServer().run(new Runnable(){

                        @Override
                        public void run() {
                            Util.emitAllData(InputStreamDataEmitter.this, InputStreamDataEmitter.this.pending);
                        }
                    });
                } while (InputStreamDataEmitter.this.pending.remaining() == 0 && !InputStreamDataEmitter.this.isPaused());
            }
            catch (Exception e) {
                InputStreamDataEmitter.this.report(e);
            }
        }
    };
    CompletedCallback endCallback;

    public InputStreamDataEmitter(AsyncServer server, InputStream inputStream) {
        this.server = server;
        this.inputStream = inputStream;
        this.doResume();
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.callback = callback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.callback;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
        this.doResume();
    }

    private void report(final Exception e) {
        this.getServer().post(new Runnable(){

            @Override
            public void run() {
                Exception ex = e;
                try {
                    InputStreamDataEmitter.this.inputStream.close();
                }
                catch (Exception e2) {
                    ex = e2;
                }
                if (InputStreamDataEmitter.this.endCallback != null) {
                    InputStreamDataEmitter.this.endCallback.onCompleted(ex);
                }
            }
        });
    }

    private void doResume() {
        this.server.getExecutorService().execute(this.pumper);
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void setEndCallback(CompletedCallback callback) {
        this.endCallback = callback;
    }

    @Override
    public CompletedCallback getEndCallback() {
        return this.endCallback;
    }

    @Override
    public AsyncServer getServer() {
        return this.server;
    }

    @Override
    public void close() {
        this.report(null);
        try {
            this.inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

