/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.filter;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;

public class ContentLengthFilter
extends FilteredDataEmitter {
    int contentLength;
    int totalRead;
    ByteBufferList transformed = new ByteBufferList();

    public ContentLengthFilter(int contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    protected void report(Exception e) {
        if (e == null && this.totalRead != this.contentLength) {
            e = new Exception("End of data reached before content length was read");
        }
        super.report(e);
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        assert (this.totalRead < this.contentLength);
        int remaining = bb.remaining();
        int toRead = Math.min(this.contentLength - this.totalRead, remaining);
        bb.get(this.transformed, toRead);
        this.totalRead += this.transformed.remaining();
        super.onDataAvailable(emitter, this.transformed);
        if (this.totalRead == this.contentLength) {
            this.report(null);
        }
    }
}

