/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.filter;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.Util;

public class ChunkedInputFilter
extends FilteredDataEmitter {
    private int mChunkLength = 0;
    private int mChunkLengthRemaining = 0;
    private State mState = State.CHUNK_LEN;

    private boolean checkByte(char b, char value) {
        if (b != value) {
            this.report(new Exception(value + " was expeceted, got " + b));
            return false;
        }
        return true;
    }

    private boolean checkLF(char b) {
        return this.checkByte(b, '\n');
    }

    private boolean checkCR(char b) {
        return this.checkByte(b, '\r');
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        try {
            while (bb.remaining() > 0) {
                switch (this.mState) {
                    case CHUNK_LEN: {
                        char c = bb.getByteChar();
                        if (c == '\r') {
                            this.mState = State.CHUNK_LEN_CR;
                        } else {
                            this.mChunkLength *= 16;
                            if (c >= 'a' && c <= 'f') {
                                this.mChunkLength += c - 97 + 10;
                            } else if (c >= '0' && c <= '9') {
                                this.mChunkLength += c - 48;
                            } else if (c >= 'A' && c <= 'F') {
                                this.mChunkLength += c - 65 + 10;
                            } else {
                                this.report(new Exception("invalid chunk length: " + c));
                                return;
                            }
                        }
                        this.mChunkLengthRemaining = this.mChunkLength;
                        break;
                    }
                    case CHUNK_LEN_CR: {
                        if (!this.checkLF(bb.getByteChar())) {
                            return;
                        }
                        this.mState = State.CHUNK;
                        break;
                    }
                    case CHUNK: {
                        int remaining = bb.remaining();
                        int reading = Math.min(this.mChunkLengthRemaining, remaining);
                        this.mChunkLengthRemaining -= reading;
                        if (this.mChunkLengthRemaining == 0) {
                            this.mState = State.CHUNK_CR;
                        }
                        if (reading == 0) break;
                        ByteBufferList chunk = bb.get(reading);
                        int newRemaining = bb.remaining();
                        assert (remaining == chunk.remaining() + bb.remaining());
                        assert (reading == chunk.remaining());
                        Util.emitAllData(this, chunk);
                        assert (newRemaining == bb.remaining());
                        break;
                    }
                    case CHUNK_CR: {
                        if (!this.checkCR(bb.getByteChar())) {
                            return;
                        }
                        this.mState = State.CHUNK_CRLF;
                        break;
                    }
                    case CHUNK_CRLF: {
                        if (!this.checkLF(bb.getByteChar())) {
                            return;
                        }
                        if (this.mChunkLength > 0) {
                            this.mState = State.CHUNK_LEN;
                        } else {
                            this.mState = State.COMPLETE;
                            this.report(null);
                        }
                        this.mChunkLength = 0;
                        break;
                    }
                    case COMPLETE: {
                        assert (false);
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.report(ex);
        }
    }

    private static enum State {
        CHUNK_LEN,
        CHUNK_LEN_CR,
        CHUNK_LEN_CRLF,
        CHUNK,
        CHUNK_CR,
        CHUNK_CRLF,
        COMPLETE;

    }
}

