/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import java.nio.ByteBuffer;

public class BufferedDataSink
implements DataSink {
    DataSink mDataSink;
    ByteBufferList mPendingWrites = new ByteBufferList();
    WritableCallback mWritable;
    int mMaxBuffer = Integer.MAX_VALUE;
    boolean closePending;
    boolean endPending;

    public BufferedDataSink(DataSink datasink) {
        this.mDataSink = datasink;
        this.mDataSink.setWriteableCallback(new WritableCallback(){

            @Override
            public void onWriteable() {
                BufferedDataSink.this.writePending();
            }
        });
    }

    public boolean isBuffering() {
        return this.mPendingWrites.hasRemaining();
    }

    public DataSink getDataSink() {
        return this.mDataSink;
    }

    private void writePending() {
        if (this.mPendingWrites.hasRemaining()) {
            this.mDataSink.write(this.mPendingWrites);
            if (this.mPendingWrites.remaining() == 0) {
                if (this.endPending) {
                    this.mDataSink.end();
                }
                if (this.closePending) {
                    this.mDataSink.close();
                }
            }
        }
        if (!this.mPendingWrites.hasRemaining() && this.mWritable != null) {
            this.mWritable.onWriteable();
        }
    }

    @Override
    public void write(ByteBuffer bb) {
        if (this.remaining() >= this.getMaxBuffer()) {
            return;
        }
        boolean needsWrite = true;
        if (!this.mPendingWrites.hasRemaining()) {
            needsWrite = false;
            this.mDataSink.write(bb);
        }
        if (bb.hasRemaining()) {
            ByteBuffer dup = ByteBufferList.obtain(bb.remaining());
            dup.put(bb);
            dup.flip();
            this.mPendingWrites.add(dup);
            if (needsWrite) {
                this.mDataSink.write(this.mPendingWrites);
            }
        }
    }

    @Override
    public void write(ByteBufferList bb) {
        this.write(bb, false);
    }

    protected void write(ByteBufferList bb, boolean ignoreBuffer) {
        if (!this.mPendingWrites.hasRemaining()) {
            this.mDataSink.write(bb);
        }
        if (bb.remaining() > 0) {
            int toRead = Math.min(bb.remaining(), this.mMaxBuffer);
            if (ignoreBuffer) {
                toRead = bb.remaining();
            }
            if (toRead > 0) {
                bb.get(this.mPendingWrites, toRead);
            }
        }
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWritable = handler;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWritable;
    }

    public int remaining() {
        return this.mPendingWrites.remaining();
    }

    public int getMaxBuffer() {
        return this.mMaxBuffer;
    }

    public void setMaxBuffer(int maxBuffer) {
        assert (maxBuffer >= 0);
        this.mMaxBuffer = maxBuffer;
    }

    @Override
    public boolean isOpen() {
        return !this.closePending && this.mDataSink.isOpen();
    }

    @Override
    public void close() {
        if (this.mPendingWrites.hasRemaining()) {
            this.closePending = true;
            return;
        }
        this.mDataSink.close();
    }

    @Override
    public void end() {
        if (this.mPendingWrites.hasRemaining()) {
            this.endPending = true;
            return;
        }
        this.mDataSink.end();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mDataSink.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mDataSink.getClosedCallback();
    }

    @Override
    public AsyncServer getServer() {
        return this.mDataSink.getServer();
    }
}

