/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.socketio;

import com.koushikdutta.async.http.socketio.Acknowledge;
import com.koushikdutta.async.http.socketio.EventCallback;
import com.koushikdutta.async.util.HashList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;

public class EventEmitter {
    HashList<EventCallback> callbacks = new HashList();

    void onEvent(String event, JSONArray arguments, Acknowledge acknowledge) {
        List list = (List)this.callbacks.get(event);
        if (list == null) {
            return;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            EventCallback cb = (EventCallback)iter.next();
            cb.onEvent(arguments, acknowledge);
            if (!(cb instanceof OnceCallback)) continue;
            iter.remove();
        }
    }

    public void addListener(String event, EventCallback callback) {
        this.on(event, callback);
    }

    public void once(String event, final EventCallback callback) {
        this.on(event, new OnceCallback(){

            @Override
            public void onEvent(JSONArray arguments, Acknowledge acknowledge) {
                callback.onEvent(arguments, acknowledge);
            }
        });
    }

    public void on(String event, EventCallback callback) {
        this.callbacks.add(event, callback);
    }

    public void removeListener(String event, EventCallback callback) {
        List list = (List)this.callbacks.get(event);
        if (list == null) {
            return;
        }
        list.remove(callback);
    }

    static interface OnceCallback
    extends EventCallback {
    }
}

