/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import android.os.Build;
import android.os.Process;
import com.google.gson.Gson;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import retrofit.RestAdapter;
import retrofit.Utils;
import retrofit.android.AndroidApacheClient;
import retrofit.android.AndroidLog;
import retrofit.android.MainThreadExecutor;
import retrofit.appengine.UrlFetchClient;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.client.UrlConnectionClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    static final boolean HAS_RX_JAVA = Platform.hasRxJavaOnClasspath();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (System.getProperty("com.google.appengine.runtime.version") != null) {
            return new AppEngine();
        }
        return new Base();
    }

    abstract Converter defaultConverter();

    abstract Client.Provider defaultClient();

    abstract Executor defaultHttpExecutor();

    abstract Executor defaultCallbackExecutor();

    abstract RestAdapter.Log defaultLog();

    private static boolean hasOkHttpOnClasspath() {
        boolean okUrlFactory = false;
        try {
            Class.forName("com.squareup.okhttp.OkUrlFactory");
            okUrlFactory = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        boolean okHttpClient = false;
        try {
            Class.forName("com.squareup.okhttp.OkHttpClient");
            okHttpClient = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (okHttpClient != okUrlFactory) {
            throw new RuntimeException("Retrofit detected an unsupported OkHttp on the classpath.\nTo use OkHttp with this version of Retrofit, you'll need:\n1. com.squareup.okhttp:okhttp:1.6.0 (or newer)\n2. com.squareup.okhttp:okhttp-urlconnection:1.6.0 (or newer)\nNote that OkHttp 2.0.0+ is supported!");
        }
        return okHttpClient;
    }

    private static boolean hasRxJavaOnClasspath() {
        try {
            Class.forName("rx.Observable");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static class OkClientInstantiator {
        private OkClientInstantiator() {
        }

        static Client instantiate() {
            return new OkClient();
        }
    }

    private static class AppEngine
    extends Base {
        private AppEngine() {
        }

        @Override
        Client.Provider defaultClient() {
            final UrlFetchClient client = new UrlFetchClient();
            return new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            };
        }
    }

    private static class Android
    extends Platform {
        private Android() {
        }

        @Override
        Converter defaultConverter() {
            return new GsonConverter(new Gson());
        }

        @Override
        Client.Provider defaultClient() {
            final Client client = Platform.hasOkHttpOnClasspath() ? OkClientInstantiator.instantiate() : (Build.VERSION.SDK_INT < 9 ? new AndroidApacheClient() : new UrlConnectionClient());
            return new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            };
        }

        @Override
        Executor defaultHttpExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable r) {
                    return new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Process.setThreadPriority((int)10);
                            r.run();
                        }
                    }, "Retrofit-Idle");
                }
            });
        }

        @Override
        Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        @Override
        RestAdapter.Log defaultLog() {
            return new AndroidLog("Retrofit");
        }
    }

    private static class Base
    extends Platform {
        private Base() {
        }

        @Override
        Converter defaultConverter() {
            return new GsonConverter(new Gson());
        }

        @Override
        Client.Provider defaultClient() {
            final Client client = Platform.hasOkHttpOnClasspath() ? OkClientInstantiator.instantiate() : new UrlConnectionClient();
            return new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            };
        }

        @Override
        Executor defaultHttpExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable r) {
                    return new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Thread.currentThread().setPriority(1);
                            r.run();
                        }
                    }, "Retrofit-Idle");
                }
            });
        }

        @Override
        Executor defaultCallbackExecutor() {
            return new Utils.SynchronousExecutor();
        }

        @Override
        RestAdapter.Log defaultLog() {
            return new RestAdapter.Log(){

                @Override
                public void log(String message) {
                    System.out.println(message);
                }
            };
        }
    }
}

