/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkResponseCache;
import com.squareup.okhttp.ResponseSource;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.TunnelRequest;
import com.squareup.okhttp.internal.Dns;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.CacheStrategy;
import com.squareup.okhttp.internal.http.Headers;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.Request;
import com.squareup.okhttp.internal.http.Response;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.RouteSelector;
import com.squareup.okhttp.internal.http.Transport;
import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.GzipSource;
import com.squareup.okhttp.internal.okio.Okio;
import com.squareup.okhttp.internal.okio.Sink;
import com.squareup.okhttp.internal.okio.Source;
import java.io.IOException;
import java.io.InputStream;
import java.net.CacheRequest;
import java.net.CookieHandler;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;

public class HttpEngine {
    final OkHttpClient client;
    private Connection connection;
    private RouteSelector routeSelector;
    private Route route;
    private Transport transport;
    long sentRequestMillis = -1L;
    private boolean transparentGzip;
    public final boolean bufferRequestBody;
    private Request originalRequest;
    private Request request;
    private Sink requestBodyOut;
    private BufferedSink bufferedRequestBody;
    private ResponseSource responseSource;
    private Response response;
    private Source responseTransferSource;
    private Source responseBody;
    private InputStream responseBodyBytes;
    private Response validatingResponse;
    private CacheRequest cacheRequest;

    public HttpEngine(OkHttpClient client, Request request, boolean bufferRequestBody, Connection connection, RouteSelector routeSelector, RetryableSink requestBodyOut) {
        this.client = client;
        this.originalRequest = request;
        this.request = request;
        this.bufferRequestBody = bufferRequestBody;
        this.connection = connection;
        this.routeSelector = routeSelector;
        this.requestBodyOut = requestBodyOut;
        if (connection != null) {
            connection.setOwner(this);
            this.route = connection.getRoute();
        } else {
            this.route = null;
        }
    }

    public final void sendRequest() throws IOException {
        if (this.responseSource != null) {
            return;
        }
        if (this.transport != null) {
            throw new IllegalStateException();
        }
        this.prepareRawRequestHeaders();
        OkResponseCache responseCache = this.client.getOkResponseCache();
        Response cacheResponse = responseCache != null ? responseCache.get(this.request) : null;
        long now = System.currentTimeMillis();
        CacheStrategy cacheStrategy = new CacheStrategy.Factory(now, this.request, cacheResponse).get();
        this.responseSource = cacheStrategy.source;
        this.request = cacheStrategy.request;
        if (responseCache != null) {
            responseCache.trackResponse(this.responseSource);
        }
        if (this.responseSource != ResponseSource.NETWORK) {
            this.validatingResponse = cacheStrategy.response;
        }
        if (cacheResponse != null && !this.responseSource.usesCache()) {
            Util.closeQuietly(cacheResponse.body());
        }
        if (this.responseSource.requiresConnection()) {
            if (this.connection == null) {
                this.connect();
            }
            if (this.connection.getOwner() != this && !this.connection.isSpdy()) {
                throw new AssertionError();
            }
            this.transport = (Transport)this.connection.newTransport(this);
            if (this.hasRequestBody() && this.requestBodyOut == null) {
                this.requestBodyOut = this.transport.createRequestBody(this.request);
            }
        } else {
            if (this.connection != null) {
                this.client.getConnectionPool().recycle(this.connection);
                this.connection = null;
            }
            this.response = this.validatingResponse;
            if (this.validatingResponse.body() != null) {
                this.initContentStream(this.validatingResponse.body().source());
            }
        }
    }

    private Response cacheableResponse() {
        return this.response.newBuilder().body(null).build();
    }

    private void connect() throws IOException {
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        if (this.routeSelector == null) {
            String uriHost = this.request.url().getHost();
            if (uriHost == null || uriHost.length() == 0) {
                throw new UnknownHostException(this.request.url().toString());
            }
            SSLSocketFactory sslSocketFactory = null;
            HostnameVerifier hostnameVerifier = null;
            if (this.request.isHttps()) {
                sslSocketFactory = this.client.getSslSocketFactory();
                hostnameVerifier = this.client.getHostnameVerifier();
            }
            Address address = new Address(uriHost, Util.getEffectivePort(this.request.url()), sslSocketFactory, hostnameVerifier, this.client.getAuthenticator(), this.client.getProxy(), this.client.getProtocols());
            this.routeSelector = new RouteSelector(address, this.request.uri(), this.client.getProxySelector(), this.client.getConnectionPool(), Dns.DEFAULT, this.client.getRoutesDatabase());
        }
        this.connection = this.routeSelector.next(this.request.method());
        this.connection.setOwner(this);
        if (!this.connection.isConnected()) {
            this.connection.connect(this.client.getConnectTimeout(), this.client.getReadTimeout(), this.getTunnelConfig());
            if (this.connection.isSpdy()) {
                this.client.getConnectionPool().share(this.connection);
            }
            this.client.getRoutesDatabase().connected(this.connection.getRoute());
        } else if (!this.connection.isSpdy()) {
            this.connection.updateReadTimeout(this.client.getReadTimeout());
        }
        this.route = this.connection.getRoute();
    }

    public void writingRequestHeaders() {
        if (this.sentRequestMillis != -1L) {
            throw new IllegalStateException();
        }
        this.sentRequestMillis = System.currentTimeMillis();
    }

    boolean hasRequestBody() {
        return HttpMethod.hasRequestBody(this.request.method());
    }

    public final Sink getRequestBody() {
        if (this.responseSource == null) {
            throw new IllegalStateException();
        }
        return this.requestBodyOut;
    }

    public final BufferedSink getBufferedRequestBody() {
        BufferedSink result = this.bufferedRequestBody;
        if (result != null) {
            return result;
        }
        Sink requestBody = this.getRequestBody();
        return requestBody != null ? (this.bufferedRequestBody = Okio.buffer(requestBody)) : null;
    }

    public final boolean hasResponse() {
        return this.response != null;
    }

    public final ResponseSource responseSource() {
        return this.responseSource;
    }

    public final Request getRequest() {
        return this.request;
    }

    public final Response getResponse() {
        if (this.response == null) {
            throw new IllegalStateException();
        }
        return this.response;
    }

    public final Source getResponseBody() {
        if (this.response == null) {
            throw new IllegalStateException();
        }
        return this.responseBody;
    }

    public final InputStream getResponseBodyBytes() {
        InputStream result = this.responseBodyBytes;
        return result != null ? result : (this.responseBodyBytes = Okio.buffer(this.getResponseBody()).inputStream());
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public HttpEngine recover(IOException e) {
        boolean canRetryRequestBody;
        if (this.routeSelector != null && this.connection != null) {
            this.routeSelector.connectFailed(this.connection, e);
        }
        boolean bl = canRetryRequestBody = this.requestBodyOut == null || this.requestBodyOut instanceof RetryableSink;
        if (this.routeSelector == null && this.connection == null || this.routeSelector != null && !this.routeSelector.hasNext() || !this.isRecoverable(e) || !canRetryRequestBody) {
            return null;
        }
        Connection connection = this.close();
        return new HttpEngine(this.client, this.originalRequest, this.bufferRequestBody, connection, this.routeSelector, (RetryableSink)this.requestBodyOut);
    }

    private boolean isRecoverable(IOException e) {
        boolean sslFailure = e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException;
        boolean protocolFailure = e instanceof ProtocolException;
        return !sslFailure && !protocolFailure;
    }

    public Route getRoute() {
        return this.route;
    }

    private void maybeCache() throws IOException {
        OkResponseCache responseCache = this.client.getOkResponseCache();
        if (responseCache == null) {
            return;
        }
        if (!CacheStrategy.isCacheable(this.response, this.request)) {
            responseCache.maybeRemove(this.request);
            return;
        }
        this.cacheRequest = responseCache.put(this.cacheableResponse());
    }

    public final void releaseConnection() throws IOException {
        if (this.transport != null && this.connection != null) {
            this.transport.releaseConnectionOnIdle();
        }
        this.connection = null;
    }

    public final void disconnect() throws IOException {
        if (this.transport != null) {
            this.transport.disconnect(this);
        }
    }

    public final Connection close() {
        if (this.bufferedRequestBody != null) {
            Util.closeQuietly(this.bufferedRequestBody);
        } else if (this.requestBodyOut != null) {
            Util.closeQuietly(this.requestBodyOut);
        }
        if (this.responseBody == null) {
            Util.closeQuietly(this.connection);
            this.connection = null;
            return null;
        }
        Util.closeQuietly(this.responseBody);
        Util.closeQuietly(this.responseBodyBytes);
        if (this.transport != null && !this.transport.canReuseConnection()) {
            Util.closeQuietly(this.connection);
            this.connection = null;
            return null;
        }
        if (this.connection != null && !this.connection.clearOwner()) {
            this.connection = null;
        }
        Connection result = this.connection;
        this.connection = null;
        return result;
    }

    private void initContentStream(Source transferSource) throws IOException {
        this.responseTransferSource = transferSource;
        if (this.transparentGzip && "gzip".equalsIgnoreCase(this.response.header("Content-Encoding"))) {
            this.response = this.response.newBuilder().removeHeader("Content-Encoding").removeHeader("Content-Length").build();
            this.responseBody = new GzipSource(transferSource);
        } else {
            this.responseBody = transferSource;
        }
    }

    public final boolean hasResponseBody() {
        if (this.request.method().equals("HEAD")) {
            return false;
        }
        int responseCode = this.response.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return OkHeaders.contentLength(this.response) != -1L || "chunked".equalsIgnoreCase(this.response.header("Transfer-Encoding"));
    }

    private void prepareRawRequestHeaders() throws IOException {
        CookieHandler cookieHandler;
        Request.Builder result = this.request.newBuilder();
        if (this.request.getUserAgent() == null) {
            result.setUserAgent(HttpEngine.getDefaultUserAgent());
        }
        if (this.request.header("Host") == null) {
            result.header("Host", HttpEngine.hostHeader(this.request.url()));
        }
        if ((this.connection == null || this.connection.getHttpMinorVersion() != 0) && this.request.header("Connection") == null) {
            result.header("Connection", "Keep-Alive");
        }
        if (this.request.header("Accept-Encoding") == null) {
            this.transparentGzip = true;
            result.header("Accept-Encoding", "gzip");
        }
        if (this.hasRequestBody() && this.request.header("Content-Type") == null) {
            result.header("Content-Type", "application/x-www-form-urlencoded");
        }
        if ((cookieHandler = this.client.getCookieHandler()) != null) {
            Map<String, List<String>> headers = OkHeaders.toMultimap(result.build().headers(), null);
            Map<String, List<String>> cookies = cookieHandler.get(this.request.uri(), headers);
            OkHeaders.addCookies(result, cookies);
        }
        this.request = result.build();
    }

    public static String getDefaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }

    public static String hostHeader(URL url) {
        return Util.getEffectivePort(url) != Util.getDefaultPort(url.getProtocol()) ? url.getHost() + ":" + url.getPort() : url.getHost();
    }

    public final void readResponse() throws IOException {
        if (this.response != null) {
            return;
        }
        if (this.responseSource == null) {
            throw new IllegalStateException("call sendRequest() first!");
        }
        if (!this.responseSource.requiresConnection()) {
            return;
        }
        if (this.bufferedRequestBody != null && this.bufferedRequestBody.buffer().size() > 0L) {
            this.bufferedRequestBody.flush();
        }
        if (this.sentRequestMillis == -1L) {
            if (OkHeaders.contentLength(this.request) == -1L && this.requestBodyOut instanceof RetryableSink) {
                long contentLength = ((RetryableSink)this.requestBodyOut).contentLength();
                this.request = this.request.newBuilder().header("Content-Length", Long.toString(contentLength)).build();
            }
            this.transport.writeRequestHeaders(this.request);
        }
        if (this.requestBodyOut != null) {
            if (this.bufferedRequestBody != null) {
                this.bufferedRequestBody.close();
            } else {
                this.requestBodyOut.close();
            }
            if (this.requestBodyOut instanceof RetryableSink) {
                this.transport.writeRequestBody((RetryableSink)this.requestBodyOut);
            }
        }
        this.transport.flushRequest();
        this.response = this.transport.readResponseHeaders().request(this.request).handshake(this.connection.getHandshake()).header(OkHeaders.SENT_MILLIS, Long.toString(this.sentRequestMillis)).header(OkHeaders.RECEIVED_MILLIS, Long.toString(System.currentTimeMillis())).setResponseSource(this.responseSource).build();
        this.connection.setHttpMinorVersion(this.response.httpMinorVersion());
        this.receiveHeaders(this.response.headers());
        if (this.responseSource == ResponseSource.CONDITIONAL_CACHE) {
            if (this.validatingResponse.validate(this.response)) {
                this.transport.emptyTransferStream();
                this.releaseConnection();
                this.response = HttpEngine.combine(this.validatingResponse, this.response);
                OkResponseCache responseCache = this.client.getOkResponseCache();
                responseCache.trackConditionalCacheHit();
                responseCache.update(this.validatingResponse, this.cacheableResponse());
                if (this.validatingResponse.body() != null) {
                    this.initContentStream(this.validatingResponse.body().source());
                }
                return;
            }
            Util.closeQuietly(this.validatingResponse.body());
        }
        if (!this.hasResponseBody()) {
            this.responseBody = this.responseTransferSource = this.transport.getTransferStream(this.cacheRequest);
            return;
        }
        this.maybeCache();
        this.initContentStream(this.transport.getTransferStream(this.cacheRequest));
    }

    private static Response combine(Response cached, Response network) throws IOException {
        Headers.Builder result = new Headers.Builder();
        Headers cachedHeaders = cached.headers();
        for (int i = 0; i < cachedHeaders.size(); ++i) {
            String fieldName = cachedHeaders.name(i);
            String value = cachedHeaders.value(i);
            if ("Warning".equals(fieldName) && value.startsWith("1") || HttpEngine.isEndToEnd(fieldName) && network.header(fieldName) != null) continue;
            result.add(fieldName, value);
        }
        Headers networkHeaders = network.headers();
        for (int i = 0; i < networkHeaders.size(); ++i) {
            String fieldName = networkHeaders.name(i);
            if (!HttpEngine.isEndToEnd(fieldName)) continue;
            result.add(fieldName, networkHeaders.value(i));
        }
        return cached.newBuilder().headers(result.build()).build();
    }

    private static boolean isEndToEnd(String fieldName) {
        return !"Connection".equalsIgnoreCase(fieldName) && !"Keep-Alive".equalsIgnoreCase(fieldName) && !"Proxy-Authenticate".equalsIgnoreCase(fieldName) && !"Proxy-Authorization".equalsIgnoreCase(fieldName) && !"TE".equalsIgnoreCase(fieldName) && !"Trailers".equalsIgnoreCase(fieldName) && !"Transfer-Encoding".equalsIgnoreCase(fieldName) && !"Upgrade".equalsIgnoreCase(fieldName);
    }

    private TunnelRequest getTunnelConfig() {
        if (!this.request.isHttps()) {
            return null;
        }
        String userAgent = this.request.getUserAgent();
        if (userAgent == null) {
            userAgent = HttpEngine.getDefaultUserAgent();
        }
        URL url = this.request.url();
        return new TunnelRequest(url.getHost(), Util.getEffectivePort(url), userAgent, this.request.getProxyAuthorization());
    }

    public void receiveHeaders(Headers headers) throws IOException {
        CookieHandler cookieHandler = this.client.getCookieHandler();
        if (cookieHandler != null) {
            cookieHandler.put(this.request.uri(), OkHeaders.toMultimap(headers, null));
        }
    }
}

