/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xml.impl.xmlbeans;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLObjectImpl;

class XMLName
extends Ref {
    static final long serialVersionUID = 3832176310755686977L;
    private String uri;
    private String localName;
    private boolean isAttributeName;
    private boolean isDescendants;
    private XMLObjectImpl xmlObject;

    private XMLName(String string, String string2) {
        this.uri = string;
        this.localName = string2;
    }

    static XMLName formStar() {
        return new XMLName(null, "*");
    }

    static XMLName formProperty(String string, String string2) {
        return new XMLName(string, string2);
    }

    void initXMLObject(XMLObjectImpl xMLObjectImpl) {
        if (xMLObjectImpl == null) {
            throw new IllegalArgumentException();
        }
        if (this.xmlObject != null) {
            throw new IllegalStateException();
        }
        this.xmlObject = xMLObjectImpl;
    }

    String uri() {
        return this.uri;
    }

    String localName() {
        return this.localName;
    }

    boolean isAttributeName() {
        return this.isAttributeName;
    }

    void setAttributeName() {
        if (this.isAttributeName) {
            throw new IllegalStateException();
        }
        this.isAttributeName = true;
    }

    boolean isDescendants() {
        return this.isDescendants;
    }

    void setIsDescendants() {
        if (this.isDescendants) {
            throw new IllegalStateException();
        }
        this.isDescendants = true;
    }

    public boolean has(Context context) {
        if (this.xmlObject == null) {
            return false;
        }
        return this.xmlObject.hasXMLProperty(this);
    }

    public Object get(Context context) {
        if (this.xmlObject == null) {
            throw ScriptRuntime.undefReadError(Undefined.instance, this.toString());
        }
        return this.xmlObject.getXMLProperty(this);
    }

    public Object set(Context context, Object object) {
        if (this.xmlObject == null) {
            throw ScriptRuntime.undefWriteError(Undefined.instance, this.toString(), object);
        }
        if (this.isDescendants) {
            throw Kit.codeBug();
        }
        this.xmlObject.putXMLProperty(this, object);
        return object;
    }

    public boolean delete(Context context) {
        if (this.xmlObject == null) {
            return true;
        }
        this.xmlObject.deleteXMLProperty(this);
        return !this.xmlObject.hasXMLProperty(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDescendants) {
            stringBuffer.append("..");
        }
        if (this.isAttributeName) {
            stringBuffer.append('@');
        }
        if (this.uri == null) {
            stringBuffer.append('*');
            if (this.localName().equals("*")) {
                return stringBuffer.toString();
            }
        } else {
            stringBuffer.append('\"').append(this.uri()).append('\"');
        }
        stringBuffer.append(':').append(this.localName());
        return stringBuffer.toString();
    }
}

