/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xml.impl.xmlbeans;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.impl.xmlbeans.XML;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLLibImpl;

class XMLCtor
extends IdFunctionObject {
    static final long serialVersionUID = -8708195078359817341L;
    private static final Object XMLCTOR_TAG = "XMLCtor";
    private XMLLibImpl lib;
    private static final int Id_ignoreComments = 1;
    private static final int Id_ignoreProcessingInstructions = 2;
    private static final int Id_ignoreWhitespace = 3;
    private static final int Id_prettyIndent = 4;
    private static final int Id_prettyPrinting = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_defaultSettings = 1;
    private static final int Id_settings = 2;
    private static final int Id_setSettings = 3;
    private static final int MAX_FUNCTION_ID = 3;

    XMLCtor(XML xML, Object object, int n, int n2) {
        super(xML, object, n, n2);
        this.lib = xML.lib;
        this.activatePrototypeMap(3);
    }

    private void writeSetting(Scriptable scriptable) {
        for (int i = 1; i <= 5; ++i) {
            int n = super.getMaxInstanceId() + i;
            String string = this.getInstanceIdName(n);
            Object object = this.getInstanceIdValue(n);
            ScriptableObject.putProperty(scriptable, string, object);
        }
    }

    private void readSettings(Scriptable scriptable) {
        block4: for (int i = 1; i <= 5; ++i) {
            int n = super.getMaxInstanceId() + i;
            String string = this.getInstanceIdName(n);
            Object object = ScriptableObject.getProperty(scriptable, string);
            if (object == Scriptable.NOT_FOUND) continue;
            switch (i) {
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    if (object instanceof Boolean) break;
                    continue block4;
                }
                case 4: {
                    if (object instanceof Number) break;
                    continue block4;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.setInstanceIdValue(n, object);
        }
    }

    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 5;
    }

    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        switch (string.length()) {
            case 12: {
                string2 = "prettyIndent";
                n2 = 4;
                break;
            }
            case 14: {
                char c = string.charAt(0);
                if (c == 'i') {
                    string2 = "ignoreComments";
                    n2 = 1;
                    break;
                }
                if (c != 'p') break;
                string2 = "prettyPrinting";
                n2 = 5;
                break;
            }
            case 16: {
                string2 = "ignoreWhitespace";
                n2 = 3;
                break;
            }
            case 28: {
                string2 = "ignoreProcessingInstructions";
                n2 = 2;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n = 6;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return XMLCtor.instanceIdInfo(n, super.getMaxInstanceId() + n2);
    }

    protected String getInstanceIdName(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return "ignoreComments";
            }
            case 2: {
                return "ignoreProcessingInstructions";
            }
            case 3: {
                return "ignoreWhitespace";
            }
            case 4: {
                return "prettyIndent";
            }
            case 5: {
                return "prettyPrinting";
            }
        }
        return super.getInstanceIdName(n);
    }

    protected Object getInstanceIdValue(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return ScriptRuntime.wrapBoolean(this.lib.ignoreComments);
            }
            case 2: {
                return ScriptRuntime.wrapBoolean(this.lib.ignoreProcessingInstructions);
            }
            case 3: {
                return ScriptRuntime.wrapBoolean(this.lib.ignoreWhitespace);
            }
            case 4: {
                return ScriptRuntime.wrapInt(this.lib.prettyIndent);
            }
            case 5: {
                return ScriptRuntime.wrapBoolean(this.lib.prettyPrinting);
            }
        }
        return super.getInstanceIdValue(n);
    }

    protected void setInstanceIdValue(int n, Object object) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                this.lib.ignoreComments = ScriptRuntime.toBoolean(object);
                return;
            }
            case 2: {
                this.lib.ignoreProcessingInstructions = ScriptRuntime.toBoolean(object);
                return;
            }
            case 3: {
                this.lib.ignoreWhitespace = ScriptRuntime.toBoolean(object);
                return;
            }
            case 4: {
                this.lib.prettyIndent = ScriptRuntime.toInt32(object);
                return;
            }
            case 5: {
                this.lib.prettyPrinting = ScriptRuntime.toBoolean(object);
                return;
            }
        }
        super.setInstanceIdValue(n, object);
    }

    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 8) {
            string2 = "settings";
            n = 2;
        } else if (n2 == 11) {
            string2 = "setSettings";
            n = 3;
        } else if (n2 == 15) {
            string2 = "defaultSettings";
            n = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "defaultSettings";
                break;
            }
            case 2: {
                n2 = 0;
                string = "settings";
                break;
            }
            case 3: {
                n2 = 1;
                string = "setSettings";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(XMLCTOR_TAG, n, string, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(XMLCTOR_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                this.lib.defaultSettings();
                Scriptable scriptable3 = context.newObject(scriptable);
                this.writeSetting(scriptable3);
                return scriptable3;
            }
            case 2: {
                Scriptable scriptable4 = context.newObject(scriptable);
                this.writeSetting(scriptable4);
                return scriptable4;
            }
            case 3: {
                if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
                    this.lib.defaultSettings();
                } else if (objectArray[0] instanceof Scriptable) {
                    this.readSettings((Scriptable)objectArray[0]);
                }
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }
}

