/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;

class ResourceBitmapHunter
extends BitmapHunter {
    private final Context context;

    ResourceBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.context = context;
    }

    @Override
    Bitmap decode(Request data) throws IOException {
        Resources res = Utils.getResources(this.context, data);
        int id = Utils.getResourceId(res, data);
        return this.decodeResource(res, id, data);
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.DISK;
    }

    private Bitmap decodeResource(Resources resources, int id, Request data) {
        BitmapFactory.Options options = ResourceBitmapHunter.createBitmapOptions(data);
        if (ResourceBitmapHunter.requiresInSampleSize(options)) {
            BitmapFactory.decodeResource((Resources)resources, (int)id, (BitmapFactory.Options)options);
            ResourceBitmapHunter.calculateInSampleSize(data.targetWidth, data.targetHeight, options);
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)id, (BitmapFactory.Options)options);
    }
}

