/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.IonBitmapRequestBuilder;
import com.koushikdutta.ion.bitmap.BitmapInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class IonDrawable
extends Drawable {
    private Paint paint;
    private Bitmap bitmap;
    private BitmapInfo info;
    private int placeholderResource;
    private Drawable placeholder;
    private int errorResource;
    private Drawable error;
    private Resources resources;
    private int loadedFrom;
    private IonDrawableCallback callback;
    private boolean disableFadeIn;
    int requestCount;
    private static final int DEFAULT_PAINT_FLAGS = 6;
    public static final long FADE_DURATION = 200L;

    public IonDrawable cancel() {
        ++this.requestCount;
        return this;
    }

    public SimpleFuture<ImageView> getFuture() {
        return this.callback.imageViewFuture;
    }

    public void setDisableFadeIn(boolean disableFadeIn) {
        this.disableFadeIn = disableFadeIn;
    }

    public void setInAnimation(Animation inAnimation, int inAnimationResource) {
        this.callback.inAnimation = inAnimation;
        this.callback.inAnimationResource = inAnimationResource;
    }

    public void register(Ion ion, String bitmapKey) {
        this.callback.requestId = ++this.requestCount;
        String previousKey = this.callback.bitmapKey;
        if (TextUtils.equals((CharSequence)previousKey, (CharSequence)bitmapKey)) {
            return;
        }
        this.callback.bitmapKey = bitmapKey;
        ion.bitmapsPending.add(bitmapKey, (Object)this.callback);
        if (previousKey == null) {
            return;
        }
        ArrayList cbs = (ArrayList)ion.bitmapsPending.get((Object)previousKey);
        if (cbs == null) {
            return;
        }
        cbs.remove(this.callback);
        if (cbs.size() == 0) {
            ion.bitmapsPending.remove((Object)previousKey);
        }
    }

    public IonDrawable(Resources resources, ImageView imageView) {
        this.resources = resources;
        this.paint = new Paint(6);
        this.callback = new IonDrawableCallback(this, imageView);
    }

    public IonDrawable setBitmap(BitmapInfo info, int loadedFrom) {
        this.loadedFrom = loadedFrom;
        if (this.info == info) {
            return this;
        }
        this.invalidateSelf();
        this.info = info;
        if (info == null) {
            this.callback.bitmapKey = null;
            this.bitmap = null;
            return this;
        }
        this.callback.bitmapKey = info.key;
        this.bitmap = info.bitmap;
        return this;
    }

    public IonDrawable setError(int resource, Drawable drawable) {
        if (drawable != null && drawable == this.error || resource != 0 && resource == this.errorResource) {
            return this;
        }
        this.errorResource = resource;
        this.error = drawable;
        this.invalidateSelf();
        return this;
    }

    public IonDrawable setPlaceholder(int resource, Drawable drawable) {
        if (drawable != null && drawable == this.placeholder || resource != 0 && resource == this.placeholderResource) {
            return this;
        }
        this.placeholderResource = resource;
        this.placeholder = drawable;
        this.invalidateSelf();
        return this;
    }

    public void setFilterBitmap(boolean filter) {
        this.paint.setFilterBitmap(filter);
        this.invalidateSelf();
    }

    public void setDither(boolean dither) {
        this.paint.setDither(dither);
        this.invalidateSelf();
    }

    public int getIntrinsicWidth() {
        if (this.bitmap != null) {
            return this.bitmap.getScaledWidth(this.resources.getDisplayMetrics().densityDpi);
        }
        if (this.error != null) {
            return this.error.getIntrinsicWidth();
        }
        if (this.placeholder != null) {
            return this.placeholder.getIntrinsicWidth();
        }
        return -1;
    }

    public int getIntrinsicHeight() {
        if (this.bitmap != null) {
            return this.bitmap.getScaledHeight(this.resources.getDisplayMetrics().densityDpi);
        }
        if (this.error != null) {
            return this.error.getIntrinsicHeight();
        }
        if (this.placeholder != null) {
            return this.placeholder.getIntrinsicHeight();
        }
        return -1;
    }

    public void draw(Canvas canvas) {
        if (this.info == null) {
            if (this.placeholder == null && this.placeholderResource != 0) {
                this.placeholder = this.resources.getDrawable(this.placeholderResource);
            }
            if (this.placeholder != null) {
                this.placeholder.setBounds(this.getBounds());
                this.placeholder.draw(canvas);
            }
            return;
        }
        if (this.info.drawTime == 0L) {
            this.info.drawTime = SystemClock.uptimeMillis();
        }
        long destAlpha = 255L;
        if (!this.disableFadeIn) {
            destAlpha = (SystemClock.uptimeMillis() - this.info.drawTime << 8) / 200L;
            destAlpha = Math.min(destAlpha, 255L);
        }
        if (destAlpha != 255L) {
            if (this.placeholder == null && this.placeholderResource != 0) {
                this.placeholder = this.resources.getDrawable(this.placeholderResource);
            }
            if (this.placeholder != null) {
                this.placeholder.setBounds(this.getBounds());
                this.placeholder.draw(canvas);
            }
        }
        if (this.bitmap != null) {
            this.paint.setAlpha((int)destAlpha);
            canvas.drawBitmap(this.bitmap, null, this.getBounds(), this.paint);
            this.paint.setAlpha(255);
        } else {
            if (this.error == null && this.errorResource != 0) {
                this.error = this.resources.getDrawable(this.errorResource);
            }
            if (this.error != null) {
                this.error.setAlpha((int)destAlpha);
                this.error.setBounds(this.getBounds());
                this.error.draw(canvas);
                this.error.setAlpha(255);
            }
        }
        if (destAlpha != 255L) {
            this.invalidateSelf();
        }
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.paint.setColorFilter(cf);
    }

    public int getOpacity() {
        return this.bitmap == null || this.bitmap.hasAlpha() || this.paint.getAlpha() < 255 ? -3 : -1;
    }

    static IonDrawable getOrCreateIonDrawable(ImageView imageView) {
        IonDrawable ret;
        Drawable current = imageView.getDrawable();
        if (current == null || !(current instanceof IonDrawable)) {
            ret = new IonDrawable(imageView.getResources(), imageView);
            imageView.setImageDrawable((Drawable)ret);
        } else {
            ret = (IonDrawable)current;
        }
        imageView.setImageDrawable(null);
        return ret;
    }

    static class IonDrawableCallback
    implements FutureCallback<BitmapInfo> {
        private WeakReference<IonDrawable> ionDrawableRef;
        private WeakReference<ImageView> imageViewRef;
        private String bitmapKey;
        private SimpleFuture<ImageView> imageViewFuture = new SimpleFuture();
        private Animation inAnimation;
        private int inAnimationResource;
        private int requestId;

        public IonDrawableCallback(IonDrawable drawable, ImageView imageView) {
            this.ionDrawableRef = new WeakReference<IonDrawable>(drawable);
            this.imageViewRef = new WeakReference<ImageView>(imageView);
        }

        public void onCompleted(Exception e, BitmapInfo result) {
            assert (Thread.currentThread() == Looper.getMainLooper().getThread());
            assert (result != null);
            ImageView imageView = (ImageView)this.imageViewRef.get();
            if (imageView == null) {
                return;
            }
            IonDrawable drawable = (IonDrawable)((Object)this.ionDrawableRef.get());
            if (drawable == null) {
                return;
            }
            if (imageView.getDrawable() != drawable) {
                return;
            }
            if (drawable.requestCount != this.requestId) {
                return;
            }
            ++drawable.requestCount;
            imageView.setImageDrawable(null);
            drawable.setBitmap(result, result.loadedFrom);
            imageView.setImageDrawable((Drawable)drawable);
            IonBitmapRequestBuilder.doAnimation(imageView, this.inAnimation, this.inAnimationResource);
            this.imageViewFuture.setComplete((Object)imageView);
        }
    }
}

