/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import com.squareup.picasso.Action;
import com.squareup.picasso.Cache;
import com.squareup.picasso.ContentStreamBitmapHunter;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import java.io.IOException;

class ContentProviderBitmapHunter
extends ContentStreamBitmapHunter {
    private static final String[] CONTENT_ORIENTATION = new String[]{"orientation"};

    ContentProviderBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(context, picasso, dispatcher, cache, stats, action);
    }

    @Override
    Bitmap decode(Request data) throws IOException {
        this.setExifRotation(ContentProviderBitmapHunter.getContentProviderExifRotation(this.context.getContentResolver(), data.uri));
        return super.decodeContentStream(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getContentProviderExifRotation(ContentResolver contentResolver, Uri uri) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(uri, CONTENT_ORIENTATION, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                int n = 0;
                return n;
            }
            int n = cursor.getInt(0);
            return n;
        }
        catch (RuntimeException ignored) {
            int n = 0;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }
}

