/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.app.Notification;
import android.app.NotificationManager;
import android.appwidget.AppWidgetManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import com.squareup.picasso.Action;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Utils;

abstract class RemoteViewsAction
extends Action<RemoteViewsTarget> {
    final RemoteViews remoteViews;
    final int viewId;

    RemoteViewsAction(Picasso picasso, Request data, RemoteViews remoteViews, int viewId, int errorResId, boolean skipCache, String key) {
        super(picasso, new RemoteViewsTarget(remoteViews, viewId), data, skipCache, false, errorResId, null, key);
        this.remoteViews = remoteViews;
        this.viewId = viewId;
    }

    @Override
    void complete(Bitmap result, Picasso.LoadedFrom from) {
        this.remoteViews.setImageViewBitmap(this.viewId, result);
        this.update();
    }

    @Override
    public void error() {
        if (this.errorResId != 0) {
            this.setImageResource(this.errorResId);
        }
    }

    void setImageResource(int resId) {
        this.remoteViews.setImageViewResource(this.viewId, resId);
        this.update();
    }

    abstract void update();

    static class NotificationAction
    extends RemoteViewsAction {
        private final int notificationId;
        private final Notification notification;

        NotificationAction(Picasso picasso, Request data, RemoteViews remoteViews, int viewId, int notificationId, Notification notification, boolean skipCache, int errorResId, String key) {
            super(picasso, data, remoteViews, viewId, errorResId, skipCache, key);
            this.notificationId = notificationId;
            this.notification = notification;
        }

        @Override
        void update() {
            NotificationManager manager = (NotificationManager)Utils.getService(this.picasso.context, "notification");
            manager.notify(this.notificationId, this.notification);
        }
    }

    static class AppWidgetAction
    extends RemoteViewsAction {
        private final int[] appWidgetIds;

        AppWidgetAction(Picasso picasso, Request data, RemoteViews remoteViews, int viewId, int[] appWidgetIds, boolean skipCache, int errorResId, String key) {
            super(picasso, data, remoteViews, viewId, errorResId, skipCache, key);
            this.appWidgetIds = appWidgetIds;
        }

        @Override
        void update() {
            AppWidgetManager manager = AppWidgetManager.getInstance((Context)this.picasso.context);
            manager.updateAppWidget(this.appWidgetIds, this.remoteViews);
        }
    }

    static class RemoteViewsTarget {
        final RemoteViews remoteViews;
        final int viewId;

        RemoteViewsTarget(RemoteViews remoteViews, int viewId) {
            this.remoteViews = remoteViews;
            this.viewId = viewId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteViewsTarget remoteViewsTarget = (RemoteViewsTarget)o;
            return this.viewId == remoteViewsTarget.viewId && this.remoteViews.equals(remoteViewsTarget.remoteViews);
        }

        public int hashCode() {
            return 31 * this.remoteViews.hashCode() + this.viewId;
        }
    }
}

