/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api.store;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDescription
implements Parcelable {
    private static final String DATE_FORMAT = "yyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String[] APP_STATUSES = new String[]{"unsubmitted", "submitted", "under_review", "approved", "published"};
    public static final Parcelable.Creator<AppDescription> CREATOR = new Parcelable.Creator<AppDescription>(){

        public AppDescription createFromParcel(Parcel parcel) {
            String uuid = parcel.readString();
            String title = parcel.readString();
            String mainImageFullUrl = parcel.readString();
            int versionCount = parcel.readInt();
            HashMap<String, AppVersion> versions = null;
            if (versionCount > -1) {
                versions = new HashMap<String, AppVersion>();
                for (int i = 0; i < versionCount; ++i) {
                    String key = parcel.readString();
                    AppVersion version = new AppVersion();
                    version.setUuid(parcel.readString());
                    version.setUploadedAt(parcel.readString());
                    version.setMainImageFullUrl(parcel.readString());
                    versions.put(key, version);
                }
            }
            int tagCount = parcel.readInt();
            ArrayList<String> tagNames = null;
            if (tagCount > -1) {
                tagNames = new ArrayList<String>();
                for (int i = 0; i < tagCount; ++i) {
                    tagNames.add(parcel.readString());
                }
            }
            return new AppDescription(uuid, title, mainImageFullUrl, versions, tagNames);
        }

        public AppDescription[] newArray(int size) {
            return new AppDescription[size];
        }
    };
    private String uuid;
    private String title;
    private HashMap<String, AppVersion> versions;
    private String mainImageFullUrl;
    private List<String> tagNames;

    public AppDescription() {
    }

    public AppDescription(JSONObject object) throws JSONException {
        this.readFromJSON(object);
    }

    public AppDescription(String uuid, String title, HashMap<String, AppVersion> versions) {
        this(uuid, title, null, versions, new ArrayList<String>());
    }

    public AppDescription(String uuid, String title, String imageUrl, HashMap<String, AppVersion> versions) {
        this(uuid, title, imageUrl, versions, new ArrayList<String>());
    }

    public AppDescription(String uuid, String title, String imageUrl, HashMap<String, AppVersion> versions, List<String> tagNames) {
        this.uuid = uuid;
        this.title = title;
        this.mainImageFullUrl = imageUrl;
        this.versions = versions;
        this.tagNames = tagNames;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public HashMap<String, AppVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(HashMap<String, AppVersion> versions) {
        this.versions = versions;
    }

    public String getMainImageFullUrl() {
        return this.mainImageFullUrl;
    }

    public void setMainImageFullUrl(String mainImageFullUrl) {
        this.mainImageFullUrl = mainImageFullUrl;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uuid);
        dest.writeString(this.title);
        dest.writeString(this.mainImageFullUrl);
        if (this.versions == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(this.versions.size());
            for (String key : this.versions.keySet()) {
                dest.writeString(key);
                dest.writeString(this.versions.get(key).getUuid());
                dest.writeString(this.versions.get(key).getUploadedAt());
                dest.writeString(this.versions.get(key).getMainImageFullUrl());
            }
        }
        if (this.tagNames == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(this.tagNames.size());
            for (String tagName : this.tagNames) {
                dest.writeString(tagName);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppDescription)) {
            return false;
        }
        AppDescription that = (AppDescription)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null) {
            return false;
        }
        if (this.versions != null ? !this.versions.equals(that.versions) : that.versions != null) {
            return false;
        }
        return !(this.tagNames != null ? !((Object)this.tagNames).equals(that.tagNames) : that.tagNames != null);
    }

    public int hashCode() {
        int result = this.uuid != null ? this.uuid.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.versions != null ? this.versions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AppDescription{title='" + this.title + '\'' + ", uuid='" + this.uuid + '\'' + ", versions=" + this.versions + '}';
    }

    public void readFromJSON(JSONObject object) throws JSONException {
        this.uuid = object.getString("uuid");
        this.title = object.getString("title");
        this.versions = new HashMap();
        if (object.has("versions")) {
            JSONObject versionsJSON = object.getJSONObject("versions");
            Iterator versionKeys = versionsJSON.keys();
            while (versionKeys.hasNext()) {
                String key = (String)versionKeys.next();
                this.versions.put(key, new AppVersion(versionsJSON.getJSONObject(key)));
            }
        } else {
            AppVersion fakeVersion = new AppVersion();
            fakeVersion.setUuid(object.getString("version"));
            this.versions.put("approved", fakeVersion);
        }
        this.tagNames = new ArrayList<String>();
        if (object.has("tags")) {
            JSONArray tagsJSON = object.getJSONArray("tags");
            for (int i = 0; i < tagsJSON.length(); ++i) {
                this.tagNames.add(tagsJSON.getString(i));
            }
        }
        if (object.has("main_image_full_url")) {
            this.mainImageFullUrl = object.getString("main_image_full_url");
        }
    }

    public String getMostRecentVersionUuid() {
        return this.getMostRecentVersion().getUuid();
    }

    public String getMostRecentVersionUploadedAt() {
        return this.getMostRecentVersion().getUploadedAt();
    }

    public String getMostRecentVersionMainImageFullUrl() {
        return this.getMostRecentVersion().getMainImageFullUrl();
    }

    private AppVersion getMostRecentVersion() {
        if (this.versions == null) {
            return AppVersion.EMPTY_VERSION;
        }
        for (String status : APP_STATUSES) {
            if (!this.versions.containsKey(status)) continue;
            return this.versions.get(status);
        }
        return AppVersion.EMPTY_VERSION;
    }

    public Intent getLaunchIntent(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent mainIntent = new Intent("android.intent.action.MAIN", null);
        mainIntent.addCategory("android.intent.category.LAUNCHER");
        mainIntent.setPackage(this.getUuid());
        ResolveInfo resolveInfo = packageManager.resolveActivity(mainIntent, 0);
        if (resolveInfo != null) {
            mainIntent.setClassName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name);
            return mainIntent;
        }
        return null;
    }

    public List<String> getTagNames() {
        return this.tagNames;
    }

    public static class AppVersion {
        public static final AppVersion EMPTY_VERSION = new AppVersion();
        private String uuid;
        private String uploadedAt;
        private String mainImageFullUrl;

        public AppVersion() {
        }

        public AppVersion(JSONObject object) throws JSONException {
            this.readFromJSON(object);
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getUploadedAt() {
            return this.uploadedAt;
        }

        public Date getUploadedAtDate() {
            try {
                return this.parseDate(this.uploadedAt);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public void setUploadedAt(String uploadedAt) {
            this.uploadedAt = uploadedAt;
        }

        public String getMainImageFullUrl() {
            return this.mainImageFullUrl;
        }

        public void setMainImageFullUrl(String mainImageFullUrl) {
            this.mainImageFullUrl = mainImageFullUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppVersion that = (AppVersion)o;
            if (this.uploadedAt != null ? !this.uploadedAt.equals(that.uploadedAt) : that.uploadedAt != null) {
                return false;
            }
            if (this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null) {
                return false;
            }
            return !(this.mainImageFullUrl != null ? !this.mainImageFullUrl.equals(that.mainImageFullUrl) : that.mainImageFullUrl != null);
        }

        public int hashCode() {
            int result = this.uuid != null ? this.uuid.hashCode() : 0;
            result = 31 * result + (this.uploadedAt != null ? this.uploadedAt.hashCode() : 0);
            result = 31 * result + (this.mainImageFullUrl != null ? this.mainImageFullUrl.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "AppVersion{uuid='" + this.uuid + '\'' + ", uploadedAt=" + this.uploadedAt + ", mainImageFullUrl='" + this.mainImageFullUrl + '\'' + '}';
        }

        public void readFromJSON(JSONObject object) throws JSONException {
            this.uuid = object.getString("uuid");
            this.uploadedAt = object.getString("uploadedAt");
            this.mainImageFullUrl = object.getString("mainImageFullUrl");
        }

        private Date parseDate(String dateString) throws ParseException {
            SimpleDateFormat sdf = new SimpleDateFormat(AppDescription.DATE_FORMAT);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.parse(dateString);
        }
    }
}

